/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.util.HashMap;
import jp.fric.graphics.draw.ColorPaint;
import jp.fric.graphics.draw.GradationPaint;
import jp.fric.graphics.draw.PaintScheme;

public class PaintSchemeFactory {
    private static final PaintScheme defaultScheme = new GradationPaint();
    private static HashMap nameToScheme = new HashMap();
    private static HashMap codeToName = new HashMap();
    private static final PaintScheme[] schemes = new PaintScheme[]{new ColorPaint(), new GradationPaint()};

    static {
        int i = 0;
        while (i < schemes.length) {
            nameToScheme.put(schemes[i].getClass().getName(), schemes[i]);
            codeToName.put(schemes[i].getCode(), schemes[i].getClass().getName());
            ++i;
        }
    }

    public static PaintScheme create(String schemename) {
        try {
            PaintScheme ps = (PaintScheme)nameToScheme.get(schemename);
            if (ps == null) {
                ps = defaultScheme;
            }
            ps = (PaintScheme)ps.getClass().newInstance();
            return ps;
        }
        catch (Exception e) {
            System.out.println("PaintSchemeFactory.create()" + e.getMessage());
            return null;
        }
    }

    public static PaintScheme createByCode(String code) {
        try {
            String schemename = (String)codeToName.get(code);
            PaintScheme ps = (PaintScheme)nameToScheme.get(schemename);
            if (ps == null) {
                ps = defaultScheme;
            }
            ps = (PaintScheme)ps.getClass().newInstance();
            return ps;
        }
        catch (Exception e) {
            System.out.println("PaintSchemeFactory.createByCode()" + e.getMessage());
            return null;
        }
    }

    public static PaintScheme createDefault() {
        try {
            PaintScheme ps = (PaintScheme)defaultScheme.getClass().newInstance();
            return ps;
        }
        catch (Exception e) {
            System.out.println("PaintSchmeFactory.createDefault()" + e.getMessage());
            return null;
        }
    }

    public static String getName(String code) {
        return (String)codeToName.get(code);
    }
}

