/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;

public abstract class MarkInendofModificationLine
implements GLinkedLineModificationShape {
    protected int index = 0;
    protected double lineLineWidth = 1.0;
    protected boolean isVisible = true;
    protected boolean isReversed = false;
    protected LinkedCreaseLine parent = null;
    protected Point2D modifiedPoint;
    protected Point2D gatePoint;
    protected Ellipse2D ellipseGate = new Ellipse2D.Double();
    protected Rectangle2D.Double ellipse2Bounds = null;
    protected Rectangle2D.Double polygonBounds = null;

    public abstract void dobeforeDrawModification(Graphics2D var1);

    public abstract void drawMyMARK(Graphics2D var1);

    public abstract void doafterDrawModification(Graphics2D var1);

    public abstract MarkInendofModificationLine createMyNewCopy();

    public MarkInendofModificationLine() {
    }

    public MarkInendofModificationLine(LinkedCreaseLine parent) {
        this.setParent(parent);
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        MarkInendofModificationLine copy = this.createMyNewCopy();
        copy.setReversed(this.isReversed);
        copy.setVisible(this.isVisible);
        copy.setIndex(this.index);
        return copy;
    }

    @Override
    public void drawModification(Graphics2D g2) {
        Color color = g2.getColor();
        BasicStroke org_stroke = (BasicStroke)g2.getStroke();
        this.dobeforeDrawModification(g2);
        this.drawGate(g2);
        if (!this.parent.isSingleLine()) {
            return;
        }
        if (this.polygonBounds != null && this.isVisible) {
            this.drawMyMARK(g2);
        }
        g2.setColor(color);
        g2.setStroke(org_stroke);
        this.doafterDrawModification(g2);
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        Rectangle2D.Double gateBounds = null;
        Rectangle2D.Double modificationBounds = null;
        if (this.isDrawGate()) {
            gateBounds = this.ellipse2Bounds;
        }
        if (this.parent.isSingleLine()) {
            modificationBounds = this.polygonBounds;
        }
        return GUtil.union(gateBounds, modificationBounds);
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double line2) {
        return MarkInendofModificationLine.modifyLinkedtoLogicGateSubLineAgain(line2, this.parent, this.isReversed, this.modifiedPoint);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indx) {
        this.index = indx;
    }

    public void setReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    public void setParent(LinkedCreaseLine parent) {
        this.parent = parent;
    }

    protected Rectangle2D.Double updateGate(Point2D.Double start, Point2D.Double end, double lineWidth) {
        if (!this.isDrawGate()) {
            this.ellipse2Bounds = null;
            return null;
        }
        Rectangle2D.Double prev = this.ellipse2Bounds;
        double size = lineWidth + 11.0;
        if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
            size = lineWidth + 24.0;
        }
        GLogicGate gate = this.parent.getLogicGate();
        Point2D.Double headerPoint = null;
        headerPoint = gate.getHeaderPoint().getPosition() != null ? new Point2D.Double(gate.getHeaderPoint().getPosition().x, gate.getHeaderPoint().getPosition().y) : start;
        this.ellipseGate.setFrame(headerPoint.x - size / 2.0, headerPoint.y - size / 2.0, size, size);
        this.gatePoint = headerPoint;
        double extend = Math.ceil(0.5 * lineWidth);
        Rectangle2D r2 = this.ellipseGate.getBounds2D();
        this.ellipse2Bounds = new Rectangle2D.Double(r2.getX() - extend, r2.getY() - extend, r2.getWidth() + 2.0 * extend, r2.getHeight() + 2.0 * extend);
        if (prev == null) {
            return this.ellipse2Bounds;
        }
        if (prev.equals(this.ellipse2Bounds)) {
            return null;
        }
        return GUtil.union(prev, this.ellipse2Bounds);
    }

    protected void drawGate(Graphics2D g2) {
        if (!this.isDrawGate()) {
            return;
        }
        if (this.ellipseGate != null && this.isVisible) {
            Color color = g2.getColor();
            BasicStroke org_stroke = (BasicStroke)g2.getStroke();
            Font oldFont = g2.getFont();
            BasicStroke stroke = new BasicStroke((float)this.lineLineWidth);
            g2.setStroke(stroke);
            g2.setColor(Color.WHITE);
            g2.fill(this.ellipseGate);
            g2.setColor(color);
            g2.draw(this.ellipseGate);
            String s = this.getLogicGateType();
            if (GLogicGate.isLogicGateInSBGNViewer(this.parent)) {
                s = GLogicGate.getLogicGateTypeInSBGNViewer(this.parent.getLogicGate().getLogicType());
            }
            String family = g2.getFont().getFamily();
            Font font = new Font(family, 0, 11);
            g2.setFont(font);
            double h = g2.getFontMetrics().getAscent();
            double h2 = g2.getFontMetrics().getDescent();
            h -= h2;
            double w = 0.0;
            int i = 0;
            while (i < s.toCharArray().length) {
                w += (double)g2.getFontMetrics().charWidth(s.toCharArray()[i]);
                ++i;
            }
            double x = this.gatePoint.getX() - w / 2.0;
            double y = this.gatePoint.getY() + h / 2.0;
            g2.drawString(s, (int)x, (int)y);
            g2.setFont(oldFont);
            g2.setStroke(org_stroke);
            g2.setColor(color);
        }
    }

    protected boolean isDrawGate() {
        if (!this.parent.isLogicGate()) {
            return false;
        }
        if (this.parent.getLogicGate() == null) {
            return false;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected String getLogicGateType() {
        String s = "";
        if (!this.isDrawGate()) {
            return s;
        }
        int type = this.parent.getLogicGate().getLogicType();
        switch (type) {
            case 1: {
                return "&";
            }
            case 2: {
                return "|";
            }
            case 4: {
                return "!";
            }
            case 3: {
                return "?";
            }
        }
        return s;
    }

    public static final Line2D.Double modifyLinkedtoLogicGateSubLineAgain(Line2D.Double subline, LinkedCreaseLine lcsln, boolean rvs, Point2D mdPoint) {
        GLogicGate gate;
        GCreasePoint headerPoint;
        ReactionLink link;
        Line2D.Double myLine = null;
        if (subline == null) {
            return myLine;
        }
        if (lcsln == null) {
            return myLine;
        }
        GLinkedStraightLine[] sublines = lcsln.getLines();
        boolean bRtnGateModifyLine = false;
        Point2D modifyPoint = mdPoint;
        if (lcsln.getEndTarget() instanceof ReactionLink && (link = (ReactionLink)lcsln.getEndTarget()).getGLinkedShape() instanceof GLogicGate && (headerPoint = (gate = (GLogicGate)link.getGLinkedShape()).getHeaderPoint()) != null) {
            try {
                Point2D.Double hp = headerPoint.getPosition();
                Point2D.Double sp = sublines[sublines.length - 1].getStartPoint();
                double lengthStartEnd = hp.distance(sp);
                double lineWidth = gate.getRealLine().getLineWidth();
                double sizeGateR = lineWidth + 5.5;
                if (GLogicGate.isLogicGateInSBGNViewer(gate.getRealLine())) {
                    sizeGateR = lineWidth + 12.0;
                }
                double distancex = 0.0;
                double distancey = 0.0;
                double cos = (sp.x - hp.x) / lengthStartEnd;
                double sin = (sp.y - hp.y) / lengthStartEnd;
                if (lengthStartEnd > sizeGateR) {
                    distancex = sizeGateR * cos;
                    distancey = sizeGateR * sin;
                }
                modifyPoint = new Point2D.Double(hp.x + distancex, hp.y + distancey);
                bRtnGateModifyLine = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        myLine = bRtnGateModifyLine ? GLinkedLineArrowShape.modifyLineStatic(false, modifyPoint, subline) : GLinkedLineArrowShape.modifyLineStatic(rvs, modifyPoint, subline);
        return myLine;
    }

    public static final Point2D.Double calcNewTargetPoint(Point2D.Double pntTargetCenter, double dTargetR, Point2D.Double pntObjLineStart) {
        Point2D.Double rtn = null;
        if (pntTargetCenter == null) {
            return rtn;
        }
        if (dTargetR <= 0.0) {
            return rtn;
        }
        if (pntObjLineStart == null) {
            return rtn;
        }
        double lengthStartEnd = pntObjLineStart.distance(pntTargetCenter);
        double distancex = 0.0;
        double distancey = 0.0;
        double cos = (pntObjLineStart.x - pntTargetCenter.x) / lengthStartEnd;
        double sin = (pntObjLineStart.y - pntTargetCenter.y) / lengthStartEnd;
        if (lengthStartEnd > dTargetR) {
            distancex = dTargetR * cos;
            distancey = dTargetR * sin;
        }
        rtn = new Point2D.Double(pntTargetCenter.x + distancex, pntTargetCenter.y + distancey);
        return rtn;
    }

    public static final Point2D.Double calcNewTargetPoint(LinkedCreaseLine parentline, double offset) {
        Point2D.Double modifyPoint = null;
        if (parentline == null) {
            return modifyPoint;
        }
        GLinkedShape comp3x = null;
        try {
            GLinkTarget gtgt = parentline.getEndTarget();
            if (gtgt instanceof ReactionLink) {
                comp3x = ((ReactionLink)gtgt).getGLinkedShape();
            }
        }
        catch (Exception myErr) {
            comp3x = null;
        }
        GLinkedStraightLine[] sublines = parentline.getLines();
        if (comp3x instanceof Dissociation) {
            try {
                Dissociation cmp3x = (Dissociation)comp3x;
                if (cmp3x.isInSBGNViewer()) {
                    Point2D.Double mp = null;
                    Point2D.Double[] ps = cmp3x.setupLinkAnchorCoord();
                    if (ps == null || ps[2] == null) {
                        throw new Exception();
                    }
                    mp = ps[2];
                    Point2D.Double sp = sublines[sublines.length - 1].getStartPoint();
                    modifyPoint = MarkInendofModificationLine.calcNewTargetPoint(mp, 5.0 + offset, sp);
                }
            }
            catch (Exception cmp3x) {}
        } else if (comp3x instanceof DimerFormation) {
            try {
                DimerFormation cmp3x = (DimerFormation)comp3x;
                if (cmp3x.isInSBGNViewer()) {
                    Point2D.Double mp = null;
                    Point2D.Double[] ps = cmp3x.setupLinkAnchorCoord();
                    if (ps == null || ps[2] == null) {
                        throw new Exception();
                    }
                    mp = ps[2];
                    Point2D.Double sp = sublines[sublines.length - 1].getStartPoint();
                    modifyPoint = MarkInendofModificationLine.calcNewTargetPoint(mp, 3.0 + offset, sp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return modifyPoint;
    }
}

