/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.PaintScheme;

public class GradationPaint
implements PaintScheme {
    private static final String CODE = "Gradation";
    private static final int edgeThreshold = 700;
    private static final Color defaultEdgeColor = new Color(0, 0, 0);
    private static final Color defaultBGColor = new Color(255, 255, 255);
    private Color fgcolor = new Color(0, 0, 0);
    private Color hilightedcolor = new Color(0, 0, 0);
    private Color fgedgecolor = new Color(0, 0, 0);
    private Color hilightededgecolor = new Color(0, 0, 0);
    private Color bgcolor = new Color(0, 0, 0);
    private Color hilightedbgcolor = new Color(0, 0, 0);
    private Stroke stroke = new BasicStroke(1.0f, 0, 1);

    @Override
    public void drawEdge(Graphics2D g2, Shape shape, int state) {
        Color paintColor = this.fgedgecolor;
        if (state == 3) {
            paintColor = this.hilightededgecolor;
        }
        g2.setStroke(this.stroke);
        g2.setColor(paintColor);
        g2.draw(shape);
    }

    @Override
    public void drawDefaultColorEdge(Graphics2D g2, Shape shape, int state) {
        Color paintColor = defaultEdgeColor;
        if (state == 2) {
            paintColor = GColor.editAssistFG;
        }
        g2.setStroke(this.stroke);
        g2.setColor(paintColor);
        g2.draw(shape);
    }

    @Override
    public void drawVanishableDefaultColorEdge(Graphics2D g2, Shape shape, int state) {
        if ((double)((BasicStroke)this.stroke).getLineWidth() == 0.0) {
            return;
        }
        Color paintColor = defaultEdgeColor;
        if (state == 2) {
            paintColor = GColor.editAssistFG;
        }
        g2.setStroke(this.stroke);
        g2.setColor(paintColor);
        g2.draw(shape);
    }

    @Override
    public void fillPaint(Graphics2D g2, Shape shape, int state) {
        Color bg = this.bgcolor;
        Color paintColor = this.fgcolor;
        if (state == 3) {
            bg = this.hilightedbgcolor;
            paintColor = this.hilightedcolor;
        }
        Rectangle boundrect = shape.getBounds();
        float af = 0.5f * (float)(boundrect.width + boundrect.height);
        g2.setPaint(new GradientPaint(boundrect.x, boundrect.y, bg, (float)boundrect.x + af, (float)boundrect.y + af, paintColor));
        g2.fill(shape);
    }

    @Override
    public void fillHalfTransparentPaint(Graphics2D g2, Shape shape, int state) {
        Color bg = this.bgcolor;
        Color paintColor = this.fgcolor;
        if (state == 3) {
            bg = this.hilightedbgcolor;
            paintColor = this.hilightedcolor;
        }
        Composite composite = g2.getComposite();
        paintColor = new Color(paintColor.getRed(), paintColor.getGreen(), paintColor.getBlue(), paintColor.getAlpha() / 2);
        bg = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), bg.getAlpha() / 2);
        AlphaComposite ac = AlphaComposite.getInstance(3, (float)paintColor.getAlpha() / 255.0f);
        g2.setComposite(ac);
        Rectangle boundrect = shape.getBounds();
        float af = 0.5f * (float)(boundrect.width + boundrect.height);
        g2.setPaint(new GradientPaint(boundrect.x, boundrect.y, bg, (float)boundrect.x + af, (float)boundrect.y + af, paintColor));
        g2.fill(shape);
        g2.setComposite(composite);
    }

    @Override
    public String getCode() {
        return CODE;
    }

    @Override
    public void setColor(Color color) {
        this.fgcolor = color;
        int rgbsum = this.fgcolor.getRed() + this.fgcolor.getGreen() + this.fgcolor.getBlue();
        this.fgedgecolor = rgbsum > 700 ? defaultEdgeColor : this.fgcolor;
        this.hilightedcolor = this.fgcolor.darker();
        rgbsum = this.hilightedcolor.getRed() + this.hilightedcolor.getGreen() + this.hilightedcolor.getBlue();
        this.hilightededgecolor = rgbsum > 700 ? defaultEdgeColor : this.hilightedcolor;
        this.bgcolor = defaultBGColor;
        this.hilightedbgcolor = this.bgcolor.darker();
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }
}

