/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GUtil {
    public static final double eps = 0.001;

    public static AffineTransform addRotateAT(AffineTransform affinetransform, Point2D.Double point1, Point2D.Double point2) {
        double angle;
        if (point1 == null || point2 == null) {
            return null;
        }
        if (point1.x == point2.x && point1.y == point2.y) {
            return null;
        }
        if (point1.x == point2.x) {
            angle = point1.y < point2.y ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            double distance = Math.sqrt((point2.x - point1.x) * (point2.x - point1.x) + (point2.y - point1.y) * (point2.y - point1.y));
            double cosine = (point2.x - point1.x) / distance;
            angle = point1.y > point2.y ? -Math.acos(cosine) : Math.acos(cosine);
        }
        affinetransform.rotate(angle);
        return affinetransform;
    }

    public static Point2D.Double createDiff(double sx, double sy, double ex, double ey) {
        double dx = 0.0;
        double dy = 0.0;
        double h = Math.abs(ey - sy);
        double w = Math.abs(ex - sx);
        if (w <= 0.001 && h <= 0.001) {
            dx = 0.0;
            dy = 0.0;
        } else if (w <= 0.001) {
            dx = 0.0;
            dy = (ey - sy) / h;
        } else if (h <= 0.001) {
            dx = (ex - sx) / w;
            dy = 0.0;
        } else {
            double absy;
            dx = ex - sx;
            dy = ey - sy;
            double absx = Math.abs(dx);
            if (absx > (absy = Math.abs(dy))) {
                absx = 1.0 / absx;
                dx *= absx;
                dy *= absx;
            } else {
                absy = 1.0 / absy;
                dx *= absy;
                dy *= absy;
            }
        }
        return new Point2D.Double(dx, dy);
    }

    public static void createLocalTransform(Point2D.Double point1, AffineTransform affinetransform) {
        if (point1 != null) {
            affinetransform.setToIdentity();
            affinetransform.setToTranslation(point1.x, point1.y);
        }
    }

    public static void createLocalTransform(Point2D.Double point1, Point2D.Double point2, AffineTransform affinetransform) {
        if (point1 != null && point2 != null) {
            double angle;
            if (point1.x == point2.x && point1.y == point2.y) {
                GUtil.createLocalTransform(point1, affinetransform);
                return;
            }
            affinetransform.setToIdentity();
            double distance = Math.sqrt((point2.x - point1.x) * (point2.x - point1.x) + (point2.y - point1.y) * (point2.y - point1.y));
            if (point1.x == point2.x) {
                angle = point1.y < point2.y ? 1.5707963267948966 : -1.5707963267948966;
            } else {
                double cosine = (point2.x - point1.x) / distance;
                angle = point1.y > point2.y ? -Math.acos(cosine) : Math.acos(cosine);
            }
            affinetransform.setToTranslation(point1.x, point1.y);
            affinetransform.scale(distance, distance);
            affinetransform.rotate(angle);
        }
    }

    public static void createLocalTransform(Point2D.Double point0, Point2D.Double point1, Point2D.Double point2, AffineTransform affinetransform) {
        if (!(point0 == null || point1 == null || point2 == null || point0.x == point1.x && point0.y == point1.y || point0.x == point2.x && point0.y == point2.y || point1.x == point2.x && point1.y == point2.y)) {
            affinetransform.setToIdentity();
            affinetransform.setTransform(point1.x - point0.x, point1.y - point0.y, point2.x - point0.x, point2.y - point0.y, point0.x, point0.y);
            try {
                affinetransform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Point2D.Double p0 = new Point2D.Double(point0.x + 1.0, point0.y + 1.0);
                GUtil.createLocalTransform(p0, point1, point2, affinetransform);
            }
        }
    }

    public static AffineTransform createRotateAT(Point2D.Double point1, Point2D.Double point2) {
        return GUtil.addRotateAT(new AffineTransform(), point1, point2);
    }

    public static Point2D.Double createVerticalFootPoint(Point2D.Double point1, Point2D.Double point2, Point2D.Double apex) {
        double x1 = point1.x;
        double y1 = point1.y;
        double x2 = point2.x;
        double y2 = point2.y;
        double tx = apex.x;
        double ty = apex.y;
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double cross = x1 * y2 - x2 * y1;
        double norm = x21 * x21 + y21 * y21;
        double fx = (x21 * x21 * tx + x21 * y21 * ty + y21 * cross) / norm;
        double fy = (y21 * y21 * ty + y21 * x21 * tx - x21 * cross) / norm;
        return new Point2D.Double(fx, fy);
    }

    public static Rectangle2D.Double union(Rectangle2D rect1, Rectangle2D rect2) {
        Rectangle2D r1 = rect1;
        Rectangle2D r2 = rect2;
        if (rect1 == null && rect2 == null) {
            return null;
        }
        if (rect1 == null) {
            r1 = r2;
        }
        if (rect2 == null) {
            r2 = r1;
        }
        Rectangle2D.Double union = new Rectangle2D.Double();
        Rectangle2D.union(r1, r2, union);
        return union;
    }
}

