/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GPointed;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GStructureListener;

public class GStructureReporter {
    private GStructure structure;
    private MyStructureListener myListener;
    private boolean isReportPrintON = true;

    public GStructureReporter(GStructure gstructure) {
        this.structure = gstructure;
        this.myListener = new MyStructureListener();
        gstructure.setReportingListener(this.myListener);
    }

    public void dispose() {
        this.structure.removeStructureListener(this.myListener);
        this.myListener = null;
        this.structure = null;
    }

    public void setReportON(boolean reportOn) {
        this.isReportPrintON = reportOn;
    }

    private class MyStructureListener
    implements GStructureListener {
        private MyStructureListener() {
        }

        @Override
        public void elementAdded(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("elementAdded, element=" + gelement.getName());
            }
        }

        @Override
        public void elementCreated(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("elementCreated, element class=" + gelement.getClass().getName());
            }
        }

        @Override
        public void elementDeselected(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("elementDeselected, element=" + gelement.getName());
            }
        }

        @Override
        public void resetList(Vector selectedVector) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("elementDeselected, element=");
            }
        }

        @Override
        public void elementMoved(GElement gelement, Point2D.Double prevpoint) {
            if (GStructureReporter.this.isReportPrintON) {
                String string = "elementMoved, moved=" + gelement.getName() + " ";
                Point2D.Double elementPosition = new Point2D.Double(0.0, 0.0);
                if (gelement instanceof GFramed) {
                    elementPosition = ((GFramed)((Object)gelement)).getFramePosition();
                }
                if (gelement instanceof GPointed) {
                    elementPosition = ((GPointed)((Object)gelement)).getPoint();
                }
                if (gelement instanceof GLink) {
                    elementPosition = ((GLink)gelement).getRepresentPosition(false);
                }
                if (gelement instanceof GEditPoint) {
                    elementPosition = ((GEditPoint)gelement).getPosition();
                }
                string = String.valueOf(string) + "prevpoint=" + prevpoint.toString() + " newPoint=" + elementPosition.toString();
                System.out.println(string);
            }
        }

        @Override
        public void elementRemoved(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("elementRemoved, element=" + gelement.getName());
            }
        }

        @Override
        public void elementResized(GElement gelement, Rectangle2D.Double var_double) {
            if (GStructureReporter.this.isReportPrintON) {
                String string = "elementResized, resized=" + gelement.getName() + " ";
                Rectangle2D.Double var_double_1_ = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
                if (gelement instanceof GFramed) {
                    var_double_1_ = ((GFramed)((Object)gelement)).getFrameBounds();
                }
                if (gelement instanceof GPointed) {
                    Point2D.Double var_double_2_ = ((GPointed)((Object)gelement)).getPoint();
                    var_double_1_ = new Rectangle2D.Double(var_double_2_.x, var_double_2_.y, 0.0, 0.0);
                }
                string = String.valueOf(string) + "prevbounds=" + var_double.toString() + " newBounds=" + var_double_1_.toString();
                System.out.println(string);
            }
        }

        @Override
        public void elementSelected(GElement gelement) {
            if (gelement != null && GStructureReporter.this.isReportPrintON) {
                System.out.println("elementSelected, element=" + gelement.getName());
            }
        }

        @Override
        public void elementsSelected(Vector gelements) {
            if (gelements != null && GStructureReporter.this.isReportPrintON) {
                int i = 0;
                while (i < gelements.size()) {
                    GElement gelement = (GElement)gelements.elementAt(i);
                    System.out.println("elementSelected, element=" + gelement.getName());
                    ++i;
                }
            }
        }

        @Override
        public void elementsAdded(Vector vector) {
            if (GStructureReporter.this.isReportPrintON) {
                int i = 0;
                while (i < vector.size()) {
                    GElement gelement = (GElement)vector.elementAt(i);
                    System.out.println("elementsAdded, elements(" + i + ")=" + gelement.getName());
                    ++i;
                }
            }
        }

        @Override
        public void elementsAddedAndRemoved(Vector vector, Vector vector_3_) {
            if (GStructureReporter.this.isReportPrintON) {
                GElement gelement;
                int i = 0;
                while (i < vector.size()) {
                    gelement = (GElement)vector.elementAt(i);
                    System.out.println("elementsAddedAndRemoved, added(" + i + ")=" + gelement.getName());
                    ++i;
                }
                i = 0;
                while (i < vector_3_.size()) {
                    gelement = (GElement)vector_3_.elementAt(i);
                    System.out.println("elementsAddedAndRemoved, removed(" + i + ")=" + gelement.getName());
                    ++i;
                }
            }
        }

        @Override
        public void elementsMoved(Vector vector, Vector vector_4_) {
            if (GStructureReporter.this.isReportPrintON) {
                int i = 0;
                while (i < vector.size()) {
                    GElement gelement = (GElement)vector.elementAt(i);
                    Point2D.Double var_double = (Point2D.Double)vector_4_.elementAt(i);
                    System.out.println("elementsMoved, elements(" + i + ")=" + gelement.getName() + ", " + var_double.toString());
                    ++i;
                }
            }
        }

        @Override
        public void elementsPasted(Vector vector) {
            if (GStructureReporter.this.isReportPrintON) {
                int i = 0;
                while (i < vector.size()) {
                    GElement gelement = (GElement)vector.elementAt(i);
                    System.out.println("elementsPasted, elements(" + i + ")=" + gelement.getName());
                    ++i;
                }
            }
        }

        @Override
        public void elementsRemoved(Vector vector) {
            if (GStructureReporter.this.isReportPrintON) {
                int i = 0;
                while (i < vector.size()) {
                    GElement gelement = (GElement)vector.elementAt(i);
                    System.out.println("elementsRemoved, elements(" + i + ")=" + gelement.getName());
                    ++i;
                }
            }
        }

        @Override
        public void reformSquareLinesBegan(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("reformSquareLinesBegan, element=" + gelement.getName());
            }
        }

        @Override
        public void reformSquareLinesEnded(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("reformSquareLinesEnded, element=" + gelement.getName());
            }
        }

        @Override
        public void eventGroupBegan(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("eventGroupBegan, element=" + gelement.getName());
            }
        }

        @Override
        public void eventGroupEnded(GElement gelement) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("eventGroupEnded, element=" + gelement.getName());
            }
        }

        @Override
        public void squareLinesDirectionChanged(GElement gelement, Vector directions) {
            if (GStructureReporter.this.isReportPrintON) {
                System.out.println("squareLinesDirectionChanged, element=" + gelement.getName());
                int i = 0;
                while (i < directions.size()) {
                    Integer dir = (Integer)directions.elementAt(i);
                    System.out.println("squareLinesDirectionChanged, direction(" + i + ")=" + dir);
                    ++i;
                }
            }
        }

        @Override
        public void elementsAutoLayout(Dimension newSize, Vector elements, Vector reactions, Vector prev, Vector next) {
        }

        @Override
        public void elementsPasted(Vector elements, Dimension newCanvasSize) {
        }

        @Override
        public void elementMoved(GElement element, Vector prevpoint) {
        }
    }
}

