/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GGroup;
import jp.fric.graphics.draw.GGroupTarget;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GPointed;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GStructureAdapter;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.sbml.Notes;
import org.sbml.libsbml.Species;

public class GStructureEditor {
    private GStructure structure;
    private Vector selecteds = new Vector();
    private static Vector copiedSelecteds = new Vector();
    private static Vector copiedLinks = new Vector();
    private static Vector copiedTagLines = new Vector();
    private static Vector copiedGroupTargets = new Vector();
    private static Vector copiedContainerTargets = new Vector();
    private static Notes[] copiedSpeciesNotes = null;
    private static Notes[] copiedContainerTargetsNotes = null;
    private static Notes[] copiedProteinNotes = null;
    private static Notes[] copiedContainerTargetsProteinNotes = null;
    private static Notes[] copiedReactionNotes = null;
    private static SBModel copySBModel = null;
    public static SBModel pasteSBModel = null;
    private Rectangle2D.Double prevPasteArea = null;
    private int samePasteAreaCnt = 0;
    private final double SAME_PASTE_OFFSET = 10.0;
    private MyStructureListener myListener;

    public GStructureEditor(GStructure gstructure) {
        this.structure = gstructure;
        this.myListener = new MyStructureListener();
        gstructure.addStructureListener(this.myListener);
    }

    public void copySelecteds(SBModel sbmodel) {
        if (this.selecteds.size() >= 1) {
            Vector groupTarget = this.getGroupTargets(this.selecteds);
            Vector containerTarget = this.getContainerTargets(this.selecteds);
            copiedSelecteds.clear();
            HashMap<GElement, GElement> selectedAndCopy = new HashMap<GElement, GElement>();
            int i = 0;
            while (i < this.selecteds.size()) {
                Object target;
                GElement gelement = (GElement)this.selecteds.get(i);
                GElement copy = gelement.createCopy();
                selectedAndCopy.put(gelement, copy);
                if (gelement instanceof LayerSpeciesAlias && (target = ((LayerSpeciesAlias)gelement).getTargetAlias()) != null && this.selecteds.contains(target)) {
                    this.setTagProperties(gelement, copy);
                }
                if (copy instanceof ComplexSpeciesAlias) {
                    ((ComplexSpeciesAlias)copy).backupChildren();
                }
                copiedSelecteds.add(copy);
                ++i;
            }
            try {
                copiedTagLines.clear();
                for (Object key : selectedAndCopy.keySet()) {
                    if (!(key instanceof LayerSpeciesAlias)) continue;
                    LayerSpeciesAlias lsa = (LayerSpeciesAlias)key;
                    Vector layerTagLink = this.structure.getLayerTagLinkLinesWhichLinksToTag(lsa);
                    int ti = 0;
                    while (ti < layerTagLink.size()) {
                        LayerReactionLink lrl = (LayerReactionLink)layerTagLink.get(ti);
                        GLinkTarget target = lrl.getTargetAt(1);
                        Object copySource = selectedAndCopy.get(key);
                        Object copyTarget = selectedAndCopy.get(target);
                        if (copySource != null && copySource instanceof LayerSpeciesAlias && copyTarget != null && copyTarget instanceof SpeciesAlias) {
                            LayerReactionLink copyLink = this.createSurroundedTagLineCopies((LayerSpeciesAlias)copySource, (SpeciesAlias)copyTarget, lrl);
                            copiedTagLines.add(copyLink);
                        }
                        ++ti;
                    }
                }
            }
            catch (Exception it) {
                // empty catch block
            }
            copiedGroupTargets.clear();
            copiedGroupTargets = this.getGroupTargets(copiedSelecteds);
            copiedContainerTargets.clear();
            copiedContainerTargets = this.getContainerTargets(copiedSelecteds);
            Vector links = this.structure.getLinks();
            int i2 = 0;
            while (i2 < links.size()) {
                GLogicGate gate;
                GCreasePoint point;
                ReactionLink link = (ReactionLink)links.elementAt(i2);
                if (link.getGLinkedShape() instanceof GLogicGate && !this.selecteds.contains(point = (gate = (GLogicGate)link.getGLinkedShape()).getHeaderPoint())) {
                    this.selecteds.add(point);
                    copiedSelecteds.add(point.createCopy());
                }
                ++i2;
            }
            Vector originals = new Vector();
            originals.addAll(this.selecteds);
            originals.addAll(groupTarget);
            originals.addAll(containerTarget);
            Vector copies = new Vector();
            copies.addAll(copiedSelecteds);
            copies.addAll(copiedGroupTargets);
            copies.addAll(copiedContainerTargets);
            copiedLinks.clear();
            copiedLinks = this.createSurroundedLinksCopies(originals, copies, this.structure.getLinks());
            this.releasePrevPasteArea();
            if (sbmodel != null) {
                this.copySelectedNotes(sbmodel);
                this.copyContainerTargetNotes(sbmodel);
                this.copySelectedProteinNotes(sbmodel);
                this.copySelectedReactionNotes(sbmodel);
                this.setCopySBModel(sbmodel);
            }
        }
    }

    public void createOrReleaseGroup() {
        if (this.selecteds.size() >= 1) {
            Rectangle2D.Double redrawArea = null;
            if (this.selecteds.size() == 1) {
                if (this.selecteds.elementAt(0) instanceof GGroup) {
                    GGroup ggroup = (GGroup)this.selecteds.elementAt(0);
                    Vector vector = ggroup.getMembers();
                    redrawArea = GUtil.union(this.structure.deselect(ggroup), redrawArea);
                    this.structure.remove(ggroup);
                    int i = 0;
                    while (i < vector.size()) {
                        GElement gelement = (GElement)vector.elementAt(i);
                        redrawArea = GUtil.union(this.structure.select(gelement), redrawArea);
                        ++i;
                    }
                    this.structure.notifyRepaint(redrawArea);
                }
            } else {
                int i = 0;
                while (i < this.selecteds.size()) {
                    GElement gelement = (GElement)this.selecteds.elementAt(i);
                    if (!(gelement instanceof GGroupTarget)) {
                        return;
                    }
                    if (gelement instanceof GBasicAtom && ((GBasicAtom)gelement).getContainer() instanceof GContainableAtom) {
                        return;
                    }
                    if (gelement instanceof GContainableAtom && ((GContainableAtom)gelement).getContainer() instanceof GContainableAtom) {
                        return;
                    }
                    ++i;
                }
                GGroup ggroup = new GGroup(this.selecteds);
                this.structure.add(ggroup);
                Vector copySelecteds2 = (Vector)this.selecteds.clone();
                int i2 = 0;
                while (i2 < copySelecteds2.size()) {
                    GElement gelement = (GElement)copySelecteds2.elementAt(i2);
                    redrawArea = GUtil.union(this.structure.deselect(gelement), redrawArea);
                    ++i2;
                }
                redrawArea = GUtil.union(this.structure.select(ggroup), redrawArea);
                this.structure.notifyRepaint(redrawArea);
            }
        }
    }

    private Vector createSurroundedLinksCopies(Vector elements, Vector copiedElements, Vector links) {
        Vector<GLink> linkCopies = new Vector<GLink>();
        Vector<Integer> indices = new Vector<Integer>();
        int i = 0;
        while (i < links.size()) {
            try {
                GLink glink = (GLink)links.elementAt(i);
                int linkTargetSize = glink.targetSize();
                GLinkTarget[] glinktargets = new GLinkTarget[linkTargetSize];
                boolean exist = true;
                int j = 0;
                while (j < linkTargetSize) {
                    GLinkTarget glinktarget = glink.getTargetAt(j);
                    int index = elements.indexOf(glinktarget);
                    if (index > -1) {
                        glinktargets[j] = (GLinkTarget)copiedElements.elementAt(index);
                    } else {
                        index = links.indexOf(glinktarget);
                        if (index > -1) {
                            int copiedLinkIndex = -1;
                            int k = 0;
                            while (k < indices.size()) {
                                int tempIndex = (Integer)indices.elementAt(k);
                                if (tempIndex == index) {
                                    copiedLinkIndex = k;
                                    break;
                                }
                                ++k;
                            }
                            if (copiedLinkIndex > -1) {
                                glinktargets[j] = (GLinkTarget)linkCopies.elementAt(copiedLinkIndex);
                            } else {
                                exist = false;
                            }
                        } else {
                            exist = false;
                            break;
                        }
                    }
                    ++j;
                }
                if (exist) {
                    GLogicGate gate;
                    GLink baseLink;
                    GLinkedShape shape = glink.getGLinkedShape();
                    if (glink instanceof ReactionLink && !((ReactionLink)glink).isPartOfBaseLinkGate() && GLogicGate.isModification(shape) && !((LinkedCreaseLine)shape).isSingleLine()) {
                        GLink gateLink = (GLink)((LinkedCreaseLine)shape).getEndTarget();
                        shape = gateLink.getGLinkedShape();
                    }
                    if (glink instanceof ReactionLink && ((ReactionLink)glink).isBaseLinkGate()) {
                        GLogicGate baseLinkGate = (GLogicGate)shape;
                        GElement baseSpecies = (GElement)((Object)baseLinkGate.getRealLine().getEndTarget());
                        if (!elements.contains(baseSpecies) || !elements.containsAll(((ReactionLink)glink).getBaseLinkGateSource())) {
                            exist = false;
                        }
                    } else if (!(!(shape instanceof GLogicGate) || elements.containsAll((baseLink = (GLink)(gate = (GLogicGate)shape).getRealLine().getEndTarget()).getSources()) && elements.containsAll(gate.getTargetElement()))) {
                        exist = false;
                    }
                }
                if (exist) {
                    GLink copy = (GLink)glink.createCopy();
                    GLinkedShape glinkedshape = copy.getGLinkedShape();
                    int j2 = 0;
                    while (j2 < linkTargetSize) {
                        GLinkedLineIndex glinkedlineindex = glinkedshape.getGLinkedLineIndexAt(j2);
                        if (glinkedlineindex != null) {
                            copy.setTargetAt(glinktargets[j2], j2, glinkedlineindex);
                        } else {
                            GLinkPositionInfo lpi = glinkedshape.getTargetLinkPositionInfoAt(j2);
                            copy.setTargetAt(glinktargets[j2], j2, lpi);
                        }
                        ++j2;
                    }
                    if (glinkedshape instanceof GLogicGate) {
                        GCreasePoint point = (GCreasePoint)glinktargets[0];
                        GLogicGate newGate = (GLogicGate)glinkedshape;
                        Point2D.Double pos = (Point2D.Double)point.getPosition().clone();
                        newGate.getRealLine().setStartPoint(pos);
                        newGate.setHeaderPoint(point);
                        GLogicGate oldGate = (GLogicGate)glink.getGLinkedShape();
                        Point2D.Double endPoint = oldGate.getRealLine().getEndPoint();
                        GLinkPositionInfo linkInfo = oldGate.getRealLine().getEndLinkPositionInfo();
                        copy.setTargetAt(glinktargets[1], 1, endPoint.x, endPoint.y, linkInfo);
                    }
                    copy.setupAfterAllTargetsSetted();
                    if (glink instanceof ReactionLink) {
                        ((ReactionLink)copy).getParentReaction().setId(((ReactionLink)glink).getParentReaction().getId());
                    }
                    linkCopies.add(copy);
                    indices.add(new Integer(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return linkCopies;
    }

    public void cutSelecteds(SBModel sbmodel) {
        if (this.selecteds.size() >= 1) {
            this.copySelecteds(sbmodel);
            this.removeSelecteds();
            this.releasePrevPasteArea();
        }
    }

    public void dispose() {
        this.structure.removeStructureListener(this.myListener);
        this.myListener = null;
        this.structure = null;
        this.selecteds.clear();
        this.selecteds = null;
        this.prevPasteArea = null;
    }

    private Vector getContainerTargets(Vector elements) {
        Vector targets = new Vector();
        int i = 0;
        while (i < elements.size()) {
            Vector target;
            GElement gelement = (GElement)elements.elementAt(i);
            if (gelement instanceof ComplexSpeciesAlias) {
                target = ((ComplexSpeciesAlias)gelement).getAllTargetsInMe(true);
                targets.addAll(target);
            } else if (gelement instanceof GContainer) {
                target = ((GContainer)((Object)gelement)).getTargets();
                targets.addAll(target);
            }
            ++i;
        }
        return targets;
    }

    public static Vector getCopies() {
        return (Vector)copiedSelecteds.clone();
    }

    private Vector getGroupTargets(Vector elements) {
        Vector targets = new Vector();
        int i = 0;
        while (i < elements.size()) {
            GElement gelement = (GElement)elements.elementAt(i);
            if (gelement instanceof GGroup) {
                Vector member = ((GGroup)gelement).getMembers();
                targets.addAll(member);
                int j = 0;
                while (j < member.size()) {
                    Vector gctargets;
                    GElement gel = (GElement)member.elementAt(j);
                    if (gel instanceof ComplexSpeciesAlias) {
                        gctargets = ((ComplexSpeciesAlias)gel).getAllTargetsInMe(true);
                        targets.addAll(gctargets);
                    } else if (gel instanceof GContainableAtom) {
                        gctargets = ((GContainableAtom)gel).getTargets();
                        targets.addAll(gctargets);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return targets;
    }

    public Vector getSelecteds() {
        return (Vector)this.selecteds.clone();
    }

    private void offset(Vector elements, double x, double y) {
        int i = 0;
        while (i < elements.size()) {
            GElement gelement = (GElement)elements.elementAt(i);
            if (gelement instanceof GFramed) {
                GFramed gframed = (GFramed)((Object)gelement);
                Point2D.Double position = gframed.getFramePosition();
                gframed.setFramePosition(position.x + x, position.y + y);
            }
            if (gelement instanceof GPointed) {
                GPointed gpointed = (GPointed)((Object)gelement);
                Point2D.Double point = gpointed.getPoint();
                gpointed.setPoint(point.x + x, point.y + y);
            }
            if (gelement instanceof LayerReactionLink) {
                GLink glink = (GLink)gelement;
                GLinkedCreaseLine shape = (GLinkedCreaseLine)glink.getGLinkedShape();
                GLinkedStraightLine line = shape.getLines()[0];
                line.start = new Point2D.Double(line.start.x + x, line.start.y + y);
                line.end = new Point2D.Double(line.end.x + x, line.end.y + y);
                shape.getStartHandlePoint().setPosition(new Point2D.Double(line.start.x, line.start.y));
                shape.getEndHandlePoint().setPosition(new Point2D.Double(line.end.x, line.end.y));
            }
            if (gelement instanceof GCreasePoint && ((GCreasePoint)gelement).isLogicGateHeaderPoint()) {
                GCreasePoint point = (GCreasePoint)gelement;
                Point2D.Double pos = point.getPosition();
                Point2D.Double newPos = new Point2D.Double(pos.x + x, pos.y + y);
                point.setPosition(newPos);
                point.setLocalPosition(newPos);
            }
            gelement.update();
            ++i;
        }
    }

    public void pasteCopies(Rectangle2D.Double pasteArea) {
        block26: {
            Vector containerTargets;
            Vector groupTargets;
            Vector<GElement> copiedCopiedSelecteds;
            block33: {
                GStructureEditor.pasteSBModel.isPastedFromOtherSBModel = copySBModel == null || copySBModel != pasteSBModel;
                if (copiedSelecteds.size() < 1) break block26;
                this.structure.deselectAll();
                this.samePasteAreaCnt = this.prevPasteArea == null ? 0 : (this.prevPasteArea.equals(pasteArea) ? ++this.samePasteAreaCnt : 0);
                copiedCopiedSelecteds = new Vector<GElement>();
                int j = 0;
                while (j < 2) {
                    int i = 0;
                    while (i < copiedSelecteds.size()) {
                        block27: {
                            GElement copy;
                            block28: {
                                block29: {
                                    MonoSpeciesProperty mono;
                                    MonoSpeciesShape monoShape;
                                    block32: {
                                        block31: {
                                            block30: {
                                                SpeciesAlias sa;
                                                GElement gelement = (GElement)copiedSelecteds.get(i);
                                                if (j == 0 && gelement instanceof ComplexSpeciesAlias || j == 1 && !(gelement instanceof ComplexSpeciesAlias)) break block27;
                                                copy = gelement.createCopy();
                                                if (gelement instanceof LayerSpeciesAlias) {
                                                    this.setTagProperties(gelement, copy);
                                                }
                                                if (copy instanceof ComplexSpeciesAlias) {
                                                    ((ComplexSpeciesAlias)copy).backupChildren();
                                                }
                                                if (copySBModel != null && copySBModel == pasteSBModel) break block28;
                                                if (!(copy instanceof SpeciesAlias)) break block29;
                                                if (copiedSpeciesNotes != null && copiedSpeciesNotes.length >= 0 && copiedSelecteds.size() == copiedSpeciesNotes.length) {
                                                    ((SpeciesAlias)copy).getOriginalSpecies().setNotes(copiedSpeciesNotes[i].getText());
                                                    ((SpeciesAlias)copy).setTempNotesStr(copiedSpeciesNotes[i].getText());
                                                }
                                                if (!((sa = (SpeciesAlias)copy).getGFramedShape() instanceof MonoSpeciesShape)) break block28;
                                                monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                                                mono = (MonoSpeciesProperty)monoShape.getProperty();
                                                if (copiedProteinNotes == null || copiedProteinNotes.length < 0 || copiedSelecteds.size() != copiedProteinNotes.length) break block28;
                                                if (!monoShape.getSpeciesSymbol().isProtein()) break block30;
                                                mono.getProtein().setNotes(copiedProteinNotes[i].getText());
                                                break block28;
                                            }
                                            if (!monoShape.getSpeciesSymbol().isGene()) break block31;
                                            mono.getGene().setNotes(copiedProteinNotes[i].getText());
                                            break block28;
                                        }
                                        if (!monoShape.getSpeciesSymbol().isRNA()) break block32;
                                        mono.getRNA().setNotes(copiedProteinNotes[i].getText());
                                        break block28;
                                    }
                                    if (!monoShape.getSpeciesSymbol().isAntiSenseRNA()) break block28;
                                    mono.getAntiSenseRNA().setNotes(copiedProteinNotes[i].getText());
                                    break block28;
                                }
                                if (copy instanceof GGroup) {
                                    Vector v = ((GGroup)copy).getMembers();
                                    int k = 0;
                                    while (k < v.size()) {
                                        GElement gel2 = (GElement)v.elementAt(k);
                                        GStructureEditor.resetCopiedSBaseNotes(copySBModel, gel2);
                                        ++k;
                                    }
                                }
                            }
                            copiedCopiedSelecteds.add(copy);
                        }
                        ++i;
                    }
                    ++j;
                }
                groupTargets = this.getGroupTargets(copiedCopiedSelecteds);
                containerTargets = this.getContainerTargets(copiedCopiedSelecteds);
                if (copySBModel != null && copySBModel == pasteSBModel || containerTargets == null) break block33;
                int i = 0;
                while (i < containerTargets.size()) {
                    block35: {
                        block34: {
                            MonoSpeciesProperty mono;
                            MonoSpeciesShape monoShape;
                            block38: {
                                block37: {
                                    block36: {
                                        SpeciesAlias sa;
                                        if (!(containerTargets.get(i) instanceof SpeciesAlias)) break block34;
                                        if (copiedContainerTargetsNotes != null && copiedContainerTargetsNotes.length >= 0 && containerTargets.size() == copiedContainerTargetsNotes.length) {
                                            ((SpeciesAlias)containerTargets.get(i)).getOriginalSpecies().setNotes(copiedContainerTargetsNotes[i].getText());
                                            ((SpeciesAlias)containerTargets.get(i)).setTempNotesStr(copiedContainerTargetsNotes[i].getText());
                                        }
                                        if (!((sa = (SpeciesAlias)containerTargets.get(i)).getGFramedShape() instanceof MonoSpeciesShape)) break block35;
                                        monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                                        mono = (MonoSpeciesProperty)monoShape.getProperty();
                                        if (copiedContainerTargetsProteinNotes == null || copiedContainerTargetsProteinNotes.length < 0 || containerTargets.size() != copiedContainerTargetsProteinNotes.length) break block35;
                                        if (!monoShape.getSpeciesSymbol().isProtein()) break block36;
                                        mono.getProtein().setNotes(copiedContainerTargetsProteinNotes[i].getText());
                                        break block35;
                                    }
                                    if (!monoShape.getSpeciesSymbol().isGene()) break block37;
                                    mono.getGene().setNotes(copiedContainerTargetsProteinNotes[i].getText());
                                    break block35;
                                }
                                if (!monoShape.getSpeciesSymbol().isRNA()) break block38;
                                mono.getRNA().setNotes(copiedContainerTargetsProteinNotes[i].getText());
                                break block35;
                            }
                            if (!monoShape.getSpeciesSymbol().isAntiSenseRNA()) break block35;
                            mono.getAntiSenseRNA().setNotes(copiedContainerTargetsProteinNotes[i].getText());
                            break block35;
                        }
                        if (containerTargets.get(i) instanceof GGroup) {
                            Vector v = ((GGroup)containerTargets.get(i)).getMembers();
                            int k = 0;
                            while (k < v.size()) {
                                GElement gel2 = (GElement)v.elementAt(k);
                                GStructureEditor.resetCopiedSBaseNotes(copySBModel, gel2);
                                ++k;
                            }
                        }
                    }
                    ++i;
                }
            }
            Vector copiedElements = new Vector();
            Vector<GElement> newcopiedSelecteds = new Vector<GElement>();
            int j = 0;
            while (j < 2) {
                int i = 0;
                while (i < copiedSelecteds.size()) {
                    GElement gelement = (GElement)copiedSelecteds.get(i);
                    if (!(j == 0 && gelement instanceof ComplexSpeciesAlias || j == 1 && !(gelement instanceof ComplexSpeciesAlias))) {
                        newcopiedSelecteds.add(gelement);
                    }
                    ++i;
                }
                ++j;
            }
            copiedElements.addAll(newcopiedSelecteds);
            copiedElements.addAll(copiedGroupTargets);
            copiedElements.addAll(copiedContainerTargets);
            Vector<GElement> copiedCopiedElements = new Vector<GElement>();
            copiedCopiedElements.addAll(copiedCopiedSelecteds);
            copiedCopiedElements.addAll(groupTargets);
            copiedCopiedElements.addAll(containerTargets);
            Vector copiedCopiedTagLines = new Vector();
            copiedCopiedTagLines = this.createSurroundedTagLineCopies(copiedElements, copiedCopiedElements, copiedTagLines);
            Vector copiedCopiedLinks = this.createSurroundedLinksCopies(copiedElements, copiedCopiedElements, copiedLinks);
            int i = 0;
            while (i < copiedCopiedLinks.size()) {
                GElement copy = (GElement)copiedCopiedLinks.get(i);
                if (copy instanceof ReactionLink && copiedReactionNotes != null && copiedReactionNotes.length >= 0 && copiedCopiedLinks.size() == copiedReactionNotes.length) {
                    ((ReactionLink)copy).getParentReaction().setNotes(copiedReactionNotes[i].getText());
                    ((ReactionLink)copy).getParentReaction().setId("");
                }
                ++i;
            }
            Vector<GElement> pasteElements = new Vector<GElement>();
            pasteElements.addAll(groupTargets);
            pasteElements.addAll(copiedCopiedSelecteds);
            pasteElements.addAll(containerTargets);
            pasteElements.addAll(copiedCopiedLinks);
            pasteElements.addAll(copiedCopiedTagLines);
            Rectangle2D.Double boundsUnion = null;
            int i2 = 0;
            while (i2 < copiedSelecteds.size()) {
                GElement gelement = (GElement)copiedSelecteds.get(i2);
                boundsUnion = GUtil.union(boundsUnion, gelement.getRepaintBounds());
                ++i2;
            }
            i2 = 0;
            while (i2 < copiedCopiedLinks.size()) {
                GLink link = (GLink)copiedCopiedLinks.get(i2);
                boundsUnion = GUtil.union(boundsUnion, link.getRepaintBounds());
                ++i2;
            }
            i2 = 0;
            while (i2 < copiedCopiedTagLines.size()) {
                LayerReactionLink tagLine = (LayerReactionLink)copiedCopiedTagLines.get(i2);
                boundsUnion = GUtil.union(boundsUnion, tagLine.getRepaintBounds());
                ++i2;
            }
            double offset = (double)this.samePasteAreaCnt * 10.0;
            double pointX = pasteArea.x + (pasteArea.width - boundsUnion.width) / 2.0 - boundsUnion.x;
            double pointY = pasteArea.y + (pasteArea.height - boundsUnion.height) / 2.0 - boundsUnion.y;
            this.offset(copiedCopiedSelecteds, pointX += offset, pointY += offset);
            this.offset(containerTargets, pointX, pointY);
            boundsUnion = null;
            int i3 = 0;
            while (i3 < copiedCopiedSelecteds.size()) {
                GElement gelement = (GElement)copiedCopiedSelecteds.get(i3);
                boundsUnion = GUtil.union(boundsUnion, gelement.getRepaintBounds());
                ++i3;
            }
            i3 = 0;
            while (i3 < copiedCopiedLinks.size()) {
                GLink link = (GLink)copiedCopiedLinks.get(i3);
                link.update();
                link.setupAfterAllTargetsSetted();
                boundsUnion = GUtil.union(boundsUnion, link.getRepaintBounds());
                ++i3;
            }
            i3 = 0;
            while (i3 < copiedCopiedTagLines.size()) {
                LayerReactionLink tagLine = (LayerReactionLink)copiedCopiedTagLines.get(i3);
                tagLine.update();
                boundsUnion = GUtil.union(boundsUnion, tagLine.getRepaintBounds());
                ++i3;
            }
            Dimension size = null;
            Rectangle2D.Double area = this.structure.getMaxDrawSize();
            if (!area.contains(boundsUnion)) {
                double x = boundsUnion.x >= 0.0 ? boundsUnion.x : 0.0;
                double y = boundsUnion.y >= 0.0 ? boundsUnion.y : 0.0;
                double w = Math.max(((RectangularShape)area).getWidth(), boundsUnion.width + x);
                double h = Math.max(((RectangularShape)area).getHeight(), boundsUnion.height + y);
                size = new Dimension((int)(w + 10.0), (int)(h + 10.0));
                x = boundsUnion.x < 0.0 ? -boundsUnion.x + 5.0 : 0.0;
                y = boundsUnion.y < 0.0 ? -boundsUnion.y + 5.0 : 0.0;
                this.offset(copiedCopiedSelecteds, x, y);
                this.offset(containerTargets, x, y);
            }
            this.structure.paste(pasteElements, size, false);
            Rectangle2D.Double rect = null;
            int i4 = 0;
            while (i4 < copiedCopiedSelecteds.size()) {
                GElement gelement = (GElement)copiedCopiedSelecteds.get(i4);
                rect = GUtil.union(this.structure.select(gelement, false, false, false), rect);
                if (gelement instanceof GCreasePoint && ((GCreasePoint)gelement).isLogicGateHeaderPoint()) {
                    if (this.structure.getSelecteds().contains(gelement)) {
                        this.structure.getSelecteds().remove(gelement);
                    }
                    this.structure.getSelecteds().add(gelement);
                }
                ++i4;
            }
            rect = GUtil.union(this.structure.highlightChainedLinks(), rect);
            this.structure.notifyRepaint(rect);
            this.structure.notifyChangeSelected();
            this.prevPasteArea = (Rectangle2D.Double)pasteArea.clone();
        }
    }

    public void releasePrevPasteArea() {
        this.prevPasteArea = null;
    }

    public void removeSelecteds() {
        if (this.selecteds.size() != 0) {
            GElement gel;
            Vector selectedCopy = (Vector)this.selecteds.clone();
            Vector<SpeciesAlias> vectSortedSelecteds = new Vector<SpeciesAlias>();
            int i = selectedCopy.size() - 1;
            while (i >= 0) {
                SpeciesAlias alias;
                if (selectedCopy.get(i) instanceof GCreasePoint) {
                    selectedCopy.remove(i);
                } else if (selectedCopy.get(i) instanceof SpeciesAlias && (alias = (SpeciesAlias)selectedCopy.get(i)).isPhenotype()) {
                    vectSortedSelecteds.add(alias);
                    selectedCopy.remove(i);
                }
                --i;
            }
            vectSortedSelecteds.addAll(selectedCopy);
            selectedCopy.clear();
            i = vectSortedSelecteds.size() - 1;
            while (i >= 0) {
                selectedCopy.add(vectSortedSelecteds.get(i));
                --i;
            }
            ListIterator it = selectedCopy.listIterator();
            while (it.hasNext()) {
                gel = (GElement)it.next();
                if (gel instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias complex = (ComplexSpeciesAlias)gel;
                    Vector targets = complex.getAllTargetsInMe(false);
                    it.previous();
                    int i2 = 0;
                    while (i2 < targets.size()) {
                        it.add(targets.elementAt(i2));
                        ++i2;
                    }
                    it.next();
                    continue;
                }
                if (!(gel instanceof GContainableAtom)) continue;
                Vector targets = ((GContainableAtom)gel).getTargets();
                it.previous();
                int i3 = 0;
                while (i3 < targets.size()) {
                    it.add(targets.elementAt(i3));
                    ++i3;
                }
                it.next();
            }
            i = 0;
            while (i < this.selecteds.size()) {
                gel = (GElement)this.selecteds.elementAt(i);
                if (gel instanceof GGroup) {
                    Vector v = ((GGroup)gel).getMembers();
                    int j = 0;
                    while (j < v.size()) {
                        GElement gel2 = (GElement)v.elementAt(j);
                        if (gel2 instanceof ComplexSpeciesAlias) {
                            selectedCopy.addAll(((ComplexSpeciesAlias)gel2).getAllTargetsInMe(false));
                            selectedCopy.addElement(gel2);
                        } else {
                            if (gel2 instanceof GContainableAtom) {
                                selectedCopy.addAll(((GContainableAtom)gel2).getTargets());
                            }
                            selectedCopy.addElement(gel2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Vector<GElement> vDirectSingleLines = new Vector<GElement>();
            Vector vTags = new Vector();
            int i4 = 0;
            while (i4 < selectedCopy.size()) {
                GLinkedShape lnkshp;
                GElement gel2 = (GElement)selectedCopy.elementAt(i4);
                if (gel2 instanceof GLink && (lnkshp = ((GLink)gel2).getGLinkedShape()) instanceof DirectSingleLine) {
                    vDirectSingleLines.add(gel2);
                    vTags.add(((GLink)gel2).getSources().get(0));
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < vTags.size()) {
                if (!selectedCopy.contains(vTags.get(i4))) {
                    selectedCopy.add(vTags.get(i4));
                }
                ++i4;
            }
            Vector<GElementImpl> vTagWithLinks = new Vector<GElementImpl>();
            int i5 = 0;
            while (i5 < selectedCopy.size()) {
                GElement gel3 = (GElement)selectedCopy.elementAt(i5);
                Vector<GElement> removelines = null;
                if (gel3 instanceof SpeciesAlias) {
                    removelines = this.structure.getLayerTagLinkLinesWhichLinksTo(gel3);
                } else if (gel3 instanceof LayerSpeciesAlias) {
                    removelines = this.structure.getLayerTagLinkLinesWhichLinksToTag(gel3);
                } else if (gel3 instanceof LayerReactionLink) {
                    removelines = new Vector<GElement>();
                    removelines.add(gel3);
                }
                if (removelines != null) {
                    int k = 0;
                    while (k < removelines.size()) {
                        LayerReactionLink taglink = (LayerReactionLink)removelines.get(k);
                        vTagWithLinks.add(taglink);
                        LayerSpeciesAlias layerSpeciesAlias = this.structure.getTagLineSource(taglink);
                        if (layerSpeciesAlias != null) {
                            vTagWithLinks.add(layerSpeciesAlias);
                        }
                        ++k;
                    }
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < vTagWithLinks.size()) {
                if (!selectedCopy.contains(vTagWithLinks.get(i5))) {
                    selectedCopy.add(vTagWithLinks.get(i5));
                }
                ++i5;
            }
            this.structure.remove(selectedCopy);
        }
    }

    public void setCopySBModel(SBModel sbmodel) {
        copySBModel = sbmodel;
    }

    public void copySelectedNotes(SBModel sbmdl) {
        copiedSpeciesNotes = null;
        if (sbmdl == null) {
            return;
        }
        if (sbmdl.getHashSpeciesNotes() == null) {
            return;
        }
        int iHashSpeciesNotesSize = sbmdl.getHashSpeciesNotes().size();
        if (iHashSpeciesNotesSize <= 0) {
            return;
        }
        if (copiedSelecteds == null) {
            return;
        }
        int iSelectedSize = copiedSelecteds.size();
        if (iSelectedSize <= 0) {
            return;
        }
        HashMap refHashModelNotes = sbmdl.getHashSpeciesNotes();
        copiedSpeciesNotes = new Notes[iSelectedSize];
        int i = 0;
        while (i < iSelectedSize) {
            GElement gelement = (GElement)copiedSelecteds.get(i);
            if (gelement instanceof SpeciesAlias) {
                String sid = ((SpeciesAlias)gelement).getOriginalSpecies().getId();
                Notes notes = (Notes)refHashModelNotes.get(sid);
                if (notes == null) {
                    notes = new Notes();
                }
                GStructureEditor.copiedSpeciesNotes[i] = notes;
            } else {
                GStructureEditor.copiedSpeciesNotes[i] = null;
            }
            ++i;
        }
    }

    public void copyContainerTargetNotes(SBModel sbmdl) {
        copiedContainerTargetsNotes = null;
        if (sbmdl == null) {
            return;
        }
        if (sbmdl.getHashSpeciesNotes() == null) {
            return;
        }
        int iHashSpeciesNotesSize = sbmdl.getHashSpeciesNotes().size();
        if (iHashSpeciesNotesSize <= 0) {
            return;
        }
        if (copiedContainerTargets == null) {
            return;
        }
        int iSelectedSize = copiedContainerTargets.size();
        if (iSelectedSize <= 0) {
            return;
        }
        HashMap refHashModelNotes = sbmdl.getHashSpeciesNotes();
        copiedContainerTargetsNotes = new Notes[iSelectedSize];
        int i = 0;
        while (i < iSelectedSize) {
            GElement gelement = (GElement)copiedContainerTargets.get(i);
            if (gelement instanceof SpeciesAlias) {
                String sid = ((SpeciesAlias)gelement).getOriginalSpecies().getId();
                Notes notes = (Notes)refHashModelNotes.get(sid);
                if (notes == null) {
                    notes = new Notes();
                }
                GStructureEditor.copiedContainerTargetsNotes[i] = notes;
            } else {
                GStructureEditor.copiedContainerTargetsNotes[i] = null;
            }
            ++i;
        }
    }

    public void copySelectedProteinNotes(SBModel sbmdl) {
        copiedProteinNotes = this.copySelectedProteinNotes(sbmdl, copiedSelecteds);
        copiedContainerTargetsProteinNotes = this.copySelectedProteinNotes(sbmdl, copiedContainerTargets);
    }

    /*
     * Unable to fully structure code
     */
    public Notes[] copySelectedProteinNotes(SBModel sbmdl, Vector selecteds) {
        block11: {
            if (selecteds == null) {
                return null;
            }
            iSelectedSize = selecteds.size();
            if (iSelectedSize <= 0) {
                return null;
            }
            doProtein = true;
            doGene = true;
            doRNA = true;
            doAntiSenseRNA = true;
            if (sbmdl == null) {
                return null;
            }
            if (sbmdl.getHashProteinNotes() == null || sbmdl.getHashProteinNotes().size() <= 0) {
                doProtein = false;
            }
            if (sbmdl.getHashGeneNotes() == null || sbmdl.getHashGeneNotes().size() <= 0) {
                doGene = false;
            }
            if (sbmdl.getHashRNANotes() == null || sbmdl.getHashRNANotes().size() <= 0) {
                doRNA = false;
            }
            if (sbmdl.getHashAntiSenseRNANotes() == null || sbmdl.getHashAntiSenseRNANotes().size() <= 0) {
                doAntiSenseRNA = false;
            }
            proteinNotes = null;
            if (!doProtein && !doGene && !doRNA && !doAntiSenseRNA) break block11;
            refHashProteinNotes = sbmdl.getHashProteinNotes();
            refHashGeneNotes = sbmdl.getHashGeneNotes();
            refHashRNANotes = sbmdl.getHashRNANotes();
            refHashAntiSenseRNANotes = sbmdl.getHashAntiSenseRNANotes();
            proteinNotes = new Notes[iSelectedSize];
            i = 0;
            while (i < iSelectedSize) {
                block17: {
                    block12: {
                        block13: {
                            block16: {
                                block15: {
                                    block14: {
                                        gelement = (GElement)selecteds.get(i);
                                        if (!(gelement instanceof ElementSpeciesAlias)) break block12;
                                        sa = (ElementSpeciesAlias)gelement;
                                        if (!(sa.getGFramedShape() instanceof MonoSpeciesShape)) break block13;
                                        monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                                        mono = (MonoSpeciesProperty)monoShape.getProperty();
                                        notes = null;
                                        if (!doProtein || !monoShape.getSpeciesSymbol().isProtein()) break block14;
                                        notes = (Notes)refHashProteinNotes.get(mono.getProtein().getId());
                                        ** GOTO lbl52
                                    }
                                    if (!doGene || !monoShape.getSpeciesSymbol().isGene()) break block15;
                                    notes = (Notes)refHashGeneNotes.get(mono.getGene().getId());
                                    ** GOTO lbl52
                                }
                                if (!doRNA || !monoShape.getSpeciesSymbol().isRNA()) break block16;
                                notes = (Notes)refHashRNANotes.get(mono.getRNA().getId());
                                ** GOTO lbl52
                            }
                            if (!doAntiSenseRNA || !monoShape.getSpeciesSymbol().isAntiSenseRNA()) {
                                proteinNotes[i] = null;
                            } else {
                                notes = (Notes)refHashAntiSenseRNANotes.get(mono.getAntiSenseRNA().getId());
lbl52:
                                // 4 sources

                                if (notes == null) {
                                    notes = new Notes();
                                }
                                proteinNotes[i] = notes;
                            }
                            break block17;
                        }
                        proteinNotes[i] = null;
                        break block17;
                    }
                    proteinNotes[i] = null;
                }
                ++i;
            }
        }
        return proteinNotes;
    }

    public void copySelectedReactionNotes(SBModel sbmdl) {
        copiedReactionNotes = null;
        if (sbmdl == null) {
            return;
        }
        if (sbmdl.getHashReactionNotes() == null) {
            return;
        }
        int iHashReactionNotesSize = sbmdl.getHashReactionNotes().size();
        if (iHashReactionNotesSize <= 0) {
            return;
        }
        if (copiedLinks == null) {
            return;
        }
        int iSelectedSize = copiedLinks.size();
        if (iSelectedSize <= 0) {
            return;
        }
        HashMap refHashReactionNotes = sbmdl.getHashReactionNotes();
        copiedReactionNotes = new Notes[iSelectedSize];
        int i = 0;
        while (i < iSelectedSize) {
            GElement gelement = (GElement)copiedLinks.get(i);
            if (gelement instanceof ReactionLink) {
                String sid = ((ReactionLink)gelement).getParentReaction().getId();
                Notes notes = (Notes)refHashReactionNotes.get(sid);
                if (notes == null) {
                    notes = new Notes();
                }
                GStructureEditor.copiedReactionNotes[i] = notes;
            } else {
                GStructureEditor.copiedReactionNotes[i] = null;
            }
            ++i;
        }
    }

    public void checkNotesBeforePast(SBModelFrame sbframe, boolean showmsg) {
        boolean duplicateNotes = false;
        if (sbframe == null) {
            return;
        }
        if (sbframe.getSBModel() == null) {
            return;
        }
        pasteSBModel = sbframe.getSBModel();
        if (copySBModel != null && copySBModel == pasteSBModel) {
            return;
        }
        if (copiedSelecteds.size() >= 1) {
            duplicateNotes = this.checkNotesBeforePastSelecteds(copiedSelecteds, copiedSpeciesNotes, copiedProteinNotes);
        }
        if (!duplicateNotes && copiedContainerTargets.size() >= 1) {
            duplicateNotes = this.checkNotesBeforePastSelecteds(copiedContainerTargets, copiedContainerTargetsNotes, copiedContainerTargetsProteinNotes);
        }
        if (duplicateNotes && showmsg) {
            String msg = "Species in current model have the same ID as pasted species.\nThe notes of pasted species will be changed.";
            JOptionPane.showMessageDialog(sbframe, msg, "Duplicate SpeciesID", 2);
        }
    }

    private boolean checkNotesBeforePastSelecteds(Vector selecteds, Notes[] speciesNotes, Notes[] proteinNotes) {
        boolean duplicateNotes = false;
        int i = 0;
        while (i < selecteds.size()) {
            GElement gelement = (GElement)selecteds.get(i);
            if (gelement instanceof SpeciesAlias) {
                Species s = ((SpeciesAlias)gelement).getOriginalSpecies();
                String sid = s.getId();
                if (pasteSBModel.getHashSpeciesNotes().containsKey(sid) && speciesNotes[i].getText() != null && !speciesNotes[i].getText().equals("")) {
                    return true;
                }
                SpeciesAlias sa = (SpeciesAlias)gelement;
                if (sa.getGFramedShape() instanceof MonoSpeciesShape) {
                    MonoSpeciesShape monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                    MonoSpeciesProperty mono = (MonoSpeciesProperty)monoShape.getProperty();
                    boolean isExistID = false;
                    if (monoShape.getSpeciesSymbol().isProtein() && pasteSBModel.getHashProteinNotes().containsKey(mono.getProtein().getId())) {
                        isExistID = true;
                    } else if (monoShape.getSpeciesSymbol().isGene() && pasteSBModel.getHashGeneNotes().containsKey(mono.getGene().getId())) {
                        isExistID = true;
                    } else if (monoShape.getSpeciesSymbol().isRNA() && pasteSBModel.getHashRNANotes().containsKey(mono.getRNA().getId())) {
                        isExistID = true;
                    } else if (monoShape.getSpeciesSymbol().isAntiSenseRNA() && pasteSBModel.getHashAntiSenseRNANotes().containsKey(mono.getAntiSenseRNA().getId())) {
                        isExistID = true;
                    }
                    if (isExistID && proteinNotes[i].getText() != null && !proteinNotes[i].getText().equals("")) {
                        return true;
                    }
                }
            } else if (gelement instanceof GGroup) {
                Vector v = ((GGroup)gelement).getMembers();
                int k = 0;
                while (k < v.size()) {
                    if (GStructureEditor.sbaseExistenceInPasteModel((GElement)v.elementAt(k), pasteSBModel) && GStructureEditor.checkNotesBeforePastSelecteds(copySBModel, (GElement)v.elementAt(k))) {
                        return true;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return duplicateNotes;
    }

    public static final boolean canSeeAsNoNotes(HashMap map, String key) {
        Notes notes;
        String txt;
        if (map == null) {
            return true;
        }
        if (key == null || "".equals(key)) {
            return true;
        }
        return !map.containsKey(key) || !(map.get(key) instanceof Notes) || (txt = (notes = (Notes)map.get(key)).getText()) == null || txt.equals("");
    }

    public static final void resetCopiedSBaseNotes(SBModel copysbmodel, GElement gelem) {
        try {
            HashMap refHashSpeciesNotes = copysbmodel.getHashSpeciesNotes();
            HashMap refHashReactionNotes = copysbmodel.getHashReactionNotes();
            HashMap refHashProteinNotes = copysbmodel.getHashProteinNotes();
            HashMap refHashGeneNotes = copysbmodel.getHashGeneNotes();
            HashMap refHashRNANotes = copysbmodel.getHashRNANotes();
            HashMap refHashAntiSenseRNANotes = copysbmodel.getHashAntiSenseRNANotes();
            if (gelem instanceof SpeciesAlias) {
                Notes notes;
                String txt;
                SpeciesAlias sa = (SpeciesAlias)gelem;
                String key = sa.getOriginalSpecies().getId();
                if (refHashSpeciesNotes.get(key) != null && (txt = (notes = (Notes)refHashSpeciesNotes.get(key)).getText()) != null && !txt.equals("")) {
                    sa.getOriginalSpecies().setNotes(txt);
                    sa.setTempNotesStr(txt);
                }
                if (sa.getGFramedShape() instanceof MonoSpeciesShape) {
                    Notes notes2;
                    String txt2;
                    MonoSpeciesShape monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                    MonoSpeciesProperty mono = (MonoSpeciesProperty)monoShape.getProperty();
                    if (monoShape.getSpeciesSymbol().isProtein()) {
                        Notes notes3;
                        String txt3;
                        key = mono.getProtein().getId();
                        if (refHashProteinNotes.get(key) != null && (txt3 = (notes3 = (Notes)refHashProteinNotes.get(key)).getText()) != null && !txt3.equals("")) {
                            mono.getProtein().setNotes(txt3);
                        }
                    } else if (monoShape.getSpeciesSymbol().isGene()) {
                        Notes notes4;
                        String txt4;
                        key = mono.getGene().getId();
                        if (refHashGeneNotes.get(key) != null && (txt4 = (notes4 = (Notes)refHashGeneNotes.get(key)).getText()) != null && !txt4.equals("")) {
                            mono.getGene().setNotes(txt4);
                        }
                    } else if (monoShape.getSpeciesSymbol().isRNA()) {
                        Notes notes5;
                        String txt5;
                        key = mono.getRNA().getId();
                        if (refHashRNANotes.get(key) != null && (txt5 = (notes5 = (Notes)refHashRNANotes.get(key)).getText()) != null && !txt5.equals("")) {
                            mono.getRNA().setNotes(txt5);
                        }
                    } else if (monoShape.getSpeciesSymbol().isAntiSenseRNA() && refHashAntiSenseRNANotes.get(key = mono.getAntiSenseRNA().getId()) != null && (txt2 = (notes2 = (Notes)refHashAntiSenseRNANotes.get(key)).getText()) != null && !txt2.equals("")) {
                        mono.getAntiSenseRNA().setNotes(txt2);
                    }
                }
            } else if (gelem instanceof ReactionLink) {
                Notes notes;
                String txt;
                ReactionLink glink = (ReactionLink)gelem;
                String key = glink.getParentReaction().getId();
                if (refHashReactionNotes.get(key) != null && (txt = (notes = (Notes)refHashReactionNotes.get(key)).getText()) != null && !txt.equals("")) {
                    glink.getParentReaction().setNotes(txt);
                }
                glink.getParentReaction().setId("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean checkNotesBeforePastSelecteds(SBModel srcSbmodel, GElement gelem) {
        block10: {
            MonoSpeciesProperty mono;
            MonoSpeciesShape monoShape;
            String key;
            HashMap srcHashAntiSenseRNANotes;
            block14: {
                HashMap srcHashRNANotes;
                block13: {
                    HashMap srcHashGeneNotes;
                    block12: {
                        SpeciesAlias sa;
                        HashMap srcHashProteinNotes;
                        block11: {
                            try {
                                HashMap srcHashSpeciesNotes = srcSbmodel.getHashSpeciesNotes();
                                srcHashProteinNotes = srcSbmodel.getHashProteinNotes();
                                srcHashGeneNotes = srcSbmodel.getHashGeneNotes();
                                srcHashRNANotes = srcSbmodel.getHashRNANotes();
                                srcHashAntiSenseRNANotes = srcSbmodel.getHashAntiSenseRNANotes();
                                if (!(gelem instanceof SpeciesAlias)) break block10;
                                sa = (SpeciesAlias)gelem;
                                key = sa.getOriginalSpecies().getId();
                                if (GStructureEditor.canSeeAsNoNotes(srcHashSpeciesNotes, key)) break block11;
                                return true;
                            }
                            catch (Exception myErr) {
                                return false;
                            }
                        }
                        if (!(sa.getGFramedShape() instanceof MonoSpeciesShape)) break block10;
                        monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                        mono = (MonoSpeciesProperty)monoShape.getProperty();
                        if (!monoShape.getSpeciesSymbol().isProtein()) break block12;
                        key = mono.getProtein().getId();
                        if (!GStructureEditor.canSeeAsNoNotes(srcHashProteinNotes, key)) {
                            return true;
                        }
                    }
                    if (!monoShape.getSpeciesSymbol().isGene()) break block13;
                    key = mono.getGene().getId();
                    if (!GStructureEditor.canSeeAsNoNotes(srcHashGeneNotes, key)) {
                        return true;
                    }
                }
                if (!monoShape.getSpeciesSymbol().isRNA()) break block14;
                key = mono.getRNA().getId();
                if (!GStructureEditor.canSeeAsNoNotes(srcHashRNANotes, key)) {
                    return true;
                }
            }
            if (monoShape.getSpeciesSymbol().isAntiSenseRNA() && !GStructureEditor.canSeeAsNoNotes(srcHashAntiSenseRNANotes, key = mono.getAntiSenseRNA().getId())) {
                return true;
            }
        }
        return false;
    }

    private static final boolean sbaseExistenceInPasteModel(GElement gelement, SBModel pasteModel) {
        if (pasteModel == null || pasteModel.getModel() == null || gelement == null) {
            return false;
        }
        if (gelement instanceof SpeciesAlias) {
            Species s = ((SpeciesAlias)gelement).getOriginalSpecies();
            String sid = s.getId();
            Species sp = pasteModel.getModel().getListOfSpecies().get(sid);
            if (sp != null) {
                return true;
            }
        } else if (gelement instanceof GGroup) {
            Vector v = ((GGroup)gelement).getMembers();
            int k = 0;
            while (k < v.size()) {
                if (GStructureEditor.sbaseExistenceInPasteModel((GElement)v.elementAt(k), pasteModel)) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    private LayerReactionLink createSurroundedTagLineCopies(LayerSpeciesAlias copysource, SpeciesAlias copytarget, LayerReactionLink tagLine) {
        GLinkTarget linkTarget;
        LayerSpeciesAlias linkSource;
        LayerReactionLink layerLink;
        block17: {
            try {
                layerLink = tagLine;
                linkSource = (LayerSpeciesAlias)layerLink.getTargetAt(0);
                linkTarget = layerLink.getTargetAt(1);
                if (linkTarget != null) break block17;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        String direct = "";
        try {
            LayerMonoSpeciesShape monoTagShape = (LayerMonoSpeciesShape)linkSource.getGFramedShape();
            LayerTagSymbol tag = (LayerTagSymbol)monoTagShape.getSpeciesSymbol();
            direct = tag.getTagDirect();
        }
        catch (Exception myErr) {
            return null;
        }
        GLinkPositionInfo linkPosition = new GLinkPositionInfo(4, 0.0);
        GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
        if (direct.equals("UP")) {
            linkPosition = new GLinkPositionInfo(8, 0.0);
            posinfTargetTmp = new GLinkPositionInfo(0, 0.0);
        } else if (direct.equals("DOWN")) {
            linkPosition = new GLinkPositionInfo(0, 0.0);
            posinfTargetTmp = new GLinkPositionInfo(8, 0.0);
        } else if (direct.equals("RIGHT")) {
            linkPosition = new GLinkPositionInfo(12, 0.0);
            posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
        } else if (direct.equals("LEFT")) {
            linkPosition = new GLinkPositionInfo(4, 0.0);
            posinfTargetTmp = new GLinkPositionInfo(12, 0.0);
        }
        LayerReactionLink copy = (LayerReactionLink)layerLink.createCopy();
        if (layerLink.getBelong_layer_id() == -99) {
            copy.setBelong_layer_id(-99);
        }
        copysource.setTargetAlias(copytarget);
        copy.setTargetAt((GLinkTarget)copysource, 0, posinfTargetTmp);
        if (linkTarget instanceof ElementSpeciesAlias) {
            copy.setTargetAt((GLinkTarget)((ElementSpeciesAlias)copytarget), 1, linkPosition);
        } else if (linkTarget instanceof ComplexSpeciesAlias) {
            copy.setTargetAt((GLinkTarget)((ComplexSpeciesAlias)copytarget), 1, linkPosition);
        }
        return copy;
    }

    private void setTagProperties(GElement gelement, GElement copy) {
        if (gelement instanceof LayerSpeciesAlias && ((LayerSpeciesAlias)gelement).getBelong_layer_id() == -99) {
            ((LayerSpeciesAlias)copy).setBelong_layer_id(-99);
            try {
                LayerMonoSpeciesShape monoTagShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)gelement).getGFramedShape();
                LayerTagSymbol tag = (LayerTagSymbol)monoTagShape.getSpeciesSymbol();
                String direct = tag.getTagDirect();
                LayerMonoSpeciesShape monoTagShapeCopy = (LayerMonoSpeciesShape)((LayerSpeciesAlias)copy).getGFramedShape();
                LayerTagSymbol tagCopy = (LayerTagSymbol)monoTagShapeCopy.getSpeciesSymbol();
                tagCopy.setTagDirect(direct);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Vector createSurroundedTagLineCopies(Vector elements, Vector copiedElements, Vector tagLines) {
        Vector<LayerReactionLink> copiedTagLine = new Vector<LayerReactionLink>();
        if (tagLines == null) {
            tagLines = new Vector();
            LayerManager tagLayer = this.structure.getTaglayer();
            ArrayList layerTagFreeLines = tagLayer.getListOfFreeLines();
            int i = 0;
            while (i < layerTagFreeLines.size()) {
                tagLines.add(layerTagFreeLines.get(i));
                ++i;
            }
        }
        try {
            int i = 0;
            while (i < tagLines.size()) {
                block21: {
                    LayerReactionLink layerLink = (LayerReactionLink)tagLines.get(i);
                    boolean exist = false;
                    LayerSpeciesAlias linkSource = (LayerSpeciesAlias)layerLink.getTargetAt(0);
                    GLinkTarget linkTarget = layerLink.getTargetAt(1);
                    LayerSpeciesAlias copiedSource = null;
                    Object copiedTarget = null;
                    int indexSource = elements.indexOf(linkSource);
                    int indexTarget = elements.indexOf(linkTarget);
                    if (indexSource > -1 && indexTarget > -1) {
                        if (copiedElements.elementAt(indexSource) instanceof LayerSpeciesAlias) {
                            copiedSource = (LayerSpeciesAlias)copiedElements.elementAt(indexSource);
                        }
                        copiedTarget = copiedElements.elementAt(indexTarget);
                        exist = true;
                    }
                    if (exist) {
                        String direct = "";
                        try {
                            LayerMonoSpeciesShape monoTagShape = (LayerMonoSpeciesShape)linkSource.getGFramedShape();
                            LayerTagSymbol tag = (LayerTagSymbol)monoTagShape.getSpeciesSymbol();
                            direct = tag.getTagDirect();
                        }
                        catch (Exception myErr) {
                            break block21;
                        }
                        GLinkPositionInfo linkPosition = new GLinkPositionInfo(4, 0.0);
                        GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
                        if (direct.equals("UP")) {
                            linkPosition = new GLinkPositionInfo(8, 0.0);
                            posinfTargetTmp = new GLinkPositionInfo(0, 0.0);
                        } else if (direct.equals("DOWN")) {
                            linkPosition = new GLinkPositionInfo(0, 0.0);
                            posinfTargetTmp = new GLinkPositionInfo(8, 0.0);
                        } else if (direct.equals("RIGHT")) {
                            linkPosition = new GLinkPositionInfo(12, 0.0);
                            posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
                        } else if (direct.equals("LEFT")) {
                            linkPosition = new GLinkPositionInfo(4, 0.0);
                            posinfTargetTmp = new GLinkPositionInfo(12, 0.0);
                        }
                        LayerReactionLink copy = (LayerReactionLink)layerLink.createCopy();
                        if (layerLink.getBelong_layer_id() == -99) {
                            copy.setBelong_layer_id(-99);
                        }
                        copiedSource.setTargetAlias(copiedTarget);
                        copy.setTargetAt((GLinkTarget)copiedSource, 0, posinfTargetTmp);
                        if (linkTarget instanceof ElementSpeciesAlias) {
                            copy.setTargetAt((GLinkTarget)copiedTarget, 1, linkPosition);
                        } else if (linkTarget instanceof ComplexSpeciesAlias) {
                            copy.setTargetAt((GLinkTarget)copiedTarget, 1, linkPosition);
                        }
                        copy.setupAfterAllTargetsSetted();
                        copiedTagLine.add(copy);
                    }
                }
                ++i;
            }
            return copiedTagLine;
        }
        catch (Exception e) {
            return copiedTagLine;
        }
    }

    private class MyStructureListener
    extends GStructureAdapter {
        private MyStructureListener() {
        }

        @Override
        public void elementDeselected(GElement gelement) {
            GStructureEditor.this.selecteds.remove(gelement);
        }

        @Override
        public void elementSelected(GElement gelement) {
            if (GStructureEditor.this.selecteds.size() > 0) {
                GStructureEditor.this.selecteds.removeAllElements();
            }
            if (gelement != null) {
                GStructureEditor.this.selecteds.add(gelement);
            }
            MainWindow pluginSide = MainWindow.getLastInstance();
            pluginSide.noticeSelectedInfoToPluginSide(GStructureEditor.this.selecteds);
        }

        @Override
        public void elementsSelected(Vector gelements) {
            if (GStructureEditor.this.selecteds.size() > 0) {
                GStructureEditor.this.selecteds.removeAllElements();
            }
            int i = 0;
            while (i < gelements.size()) {
                GStructureEditor.this.selecteds.add((GElement)gelements.elementAt(i));
                ++i;
            }
            MainWindow pluginSide = MainWindow.getLastInstance();
            pluginSide.noticeSelectedInfoToPluginSide(GStructureEditor.this.selecteds);
        }
    }
}

