/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JFrame;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GCreasePointForUndo;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GGroup;
import jp.fric.graphics.draw.GGroupTarget;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkHandlePointForUndo;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedCurveLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.fric.graphics.draw.GPaintOrder;
import jp.fric.graphics.draw.GPointed;
import jp.fric.graphics.draw.GResizable;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructureListener;
import jp.fric.graphics.draw.GStructurePainter;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.event.GEventProperty;
import jp.fric.graphics.draw.event.GEventRecorder;
import jp.fric.util.Debug;
import jp.fric.util.LogFactory;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.NameImage;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBEvent;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesShadeSymbol;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.layer.swing.LayerNameInputDialog;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerClosedCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoShower.InformationShowerImpl;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoShower.InformationShowerMappingArrayMass;
import jp.sbi.celldesigner.plugin.InfoCenter.InfoUI.MappingArrayMassShowerMainWinFrm;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;
import jp.sbi.celldesigner.symbol.species.Tag;

public class GStructure {
    private static boolean moveLinkMode = false;
    private Vector atoms = new Vector();
    private Vector containeratoms = new Vector();
    private Vector containers = new Vector();
    private Vector links = new Vector();
    private Vector groups = new Vector();
    private Vector layers = new Vector();
    private Vector informationShowers = new Vector();
    private JFrame currentInformationShowersControlFrame = null;
    private int atomCnt = 0;
    private int containerAtomCnt = 0;
    private int containerCnt = 0;
    private int linkCnt = 0;
    private int groupCnt = 0;
    private String atomTag = "atom";
    private String containerAtomTag = "complexAtom";
    private String containerTag = "container";
    private String linkTag = "link";
    private String groupTag = "group";
    private Vector selectedVector = new Vector();
    private GElement tmp = null;
    private Rectangle2D.Double maxArea = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Rectangle2D selectRect = null;
    private Vector sortedLinks = new Vector();
    private boolean isClossLineON = true;
    private GEventRecorder recorder = null;
    private Vector listeners = new Vector();
    private Vector painters = new Vector();
    public static final BasicStroke XOR_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    protected static final int CREATED = 0;
    protected static final int ADDED = 1;
    protected static final int REMOVED = 2;
    protected static final int VECTOR_ADDED = 3;
    protected static final int VECTOR_REMOVED = 4;
    protected static final int ADDED_AND_REMOVED = 5;
    protected static final int SELECTED = 6;
    protected static final int DESELECTED = 7;
    protected static final int MOVED = 8;
    protected static final int VECTOR_MOVED = 9;
    protected static final int RESIZED = 10;
    protected static final int VECTOR_PASTED = 11;
    protected static final int REFORM_SQUARE_LINES_BEGAN = 12;
    protected static final int REFORM_SQUARE_LINES_ENDED = 13;
    protected static final int SQUARE_LINES_DIRECTION_CHANGED = 14;
    protected static final int EVENT_GROUP_BEGAN = -1;
    protected static final int EVENT_GROUP_ENDED = -2;
    private Logger log = LogFactory.getLogger(GStructure.class);
    private GElement movingElement = null;
    private boolean moveMode = false;
    private boolean linkMoveMode = false;
    private boolean selectMode = false;
    private ArrayList moveLinkList = new ArrayList();
    private Rectangle2D repaintArea;
    private boolean bInMacroProcessingFlg = false;
    private Vector vctMacroTargets = new Vector();
    private boolean bBypassDraw = false;
    private Vector vectOutputingImgInDebug = null;
    private double temp_dx;
    private double temp_dy;
    private static boolean isTemp;
    private double temp_startx;
    private double temp_starty;

    public void setMovingElement(GElement element) {
        this.movingElement = element;
    }

    public GElement getMovingElement() {
        return this.movingElement;
    }

    public void setInMacroProcessingFlg(boolean bFlg) {
        this.bInMacroProcessingFlg = bFlg;
    }

    public boolean getInMacroProcessingFlg() {
        return this.bInMacroProcessingFlg;
    }

    public void setMacroTargets(Vector vTargets) {
        this.vctMacroTargets = (Vector)vTargets.clone();
    }

    public Vector getMacroTargets() {
        if (this.vctMacroTargets == null) {
            return null;
        }
        return (Vector)this.vctMacroTargets.clone();
    }

    public synchronized void add(Vector elements) {
        if (elements != null && elements.size() != 0) {
            ComplexSpeciesAlias alias;
            Rectangle2D.Double redrawArea = null;
            Vector<GElement> addElements = new Vector<GElement>();
            int i = 0;
            while (i < elements.size()) {
                GElement gelement = (GElement)elements.elementAt(i);
                if (gelement != null) {
                    try {
                        redrawArea = GUtil.union(redrawArea, this.addElement(gelement, false));
                        addElements.add(gelement);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            i = 0;
            while (i < elements.size()) {
                if (elements.elementAt(i) instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias alias2 = (ComplexSpeciesAlias)elements.elementAt(i);
                    alias2.restoreChildren(this);
                }
                ++i;
            }
            Vector<ComplexSpeciesAlias> hasFoundBriefParents = new Vector<ComplexSpeciesAlias>();
            Vector<ComplexSpeciesAlias> otherComplexes = new Vector<ComplexSpeciesAlias>();
            int i2 = 0;
            while (i2 < elements.size()) {
                if (elements.elementAt(i2) instanceof ComplexSpeciesAlias) {
                    alias = (ComplexSpeciesAlias)elements.elementAt(i2);
                    if (alias.getCurrentView() == 3) {
                        ComplexSpeciesAlias parent = alias.findBriefParent();
                        if (!hasFoundBriefParents.contains(parent)) {
                            if (otherComplexes.contains(parent)) {
                                otherComplexes.remove(parent);
                            }
                            hasFoundBriefParents.addElement(parent);
                        }
                    } else if (!otherComplexes.contains(alias) && !hasFoundBriefParents.contains(alias)) {
                        otherComplexes.addElement(alias);
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < hasFoundBriefParents.size()) {
                ComplexSpeciesAlias parent = (ComplexSpeciesAlias)hasFoundBriefParents.elementAt(i2);
                this.changeComplexOrder(parent);
                parent.changeComplexView(new Integer(1));
                parent.update();
                ++i2;
            }
            i2 = 0;
            while (i2 < otherComplexes.size()) {
                alias = (ComplexSpeciesAlias)otherComplexes.elementAt(i2);
                this.changeComplexOrder(alias);
                ++i2;
            }
            if (addElements.size() != 0) {
                Rectangle2D redrawArea1 = this.updateLinks();
                redrawArea = GUtil.union(redrawArea, redrawArea1);
                this.notifyChange(addElements, 3, null);
                this.notifyRepaint(redrawArea);
            }
        }
    }

    public synchronized void add(GElement element) {
        if (element != null) {
            Rectangle2D.Double redrawArea = null;
            try {
                redrawArea = this.addElement(element, false);
            }
            catch (Exception exception) {
                return;
            }
            if (element instanceof GLink) {
                redrawArea = GUtil.union(redrawArea, ((GLink)element).update());
            }
            this.notifyChange(element, 1, null);
            this.notifyRepaint(redrawArea);
        }
    }

    public synchronized void addAndRemove(Vector addElements, Vector removeElements) {
        Rectangle2D.Double redrawArea = null;
        boolean add = false;
        boolean remove = false;
        if (addElements != null && addElements.size() != 0) {
            add = true;
            int i = 0;
            while (i < addElements.size()) {
                try {
                    GElement gelement = (GElement)addElements.elementAt(i);
                    if (gelement != null) {
                        redrawArea = GUtil.union(redrawArea, this.addElement(gelement, false));
                    }
                }
                catch (Exception gelement) {
                    // empty catch block
                }
                ++i;
            }
        }
        Vector removedElemns = new Vector();
        if (removeElements != null && removeElements.size() != 0) {
            remove = true;
            int i = 0;
            while (i < removeElements.size()) {
                try {
                    GElement gelement = (GElement)removeElements.elementAt(i);
                    if (gelement != null) {
                        redrawArea = GUtil.union(redrawArea, this.removeElement(gelement, removedElemns));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (add || remove) {
            Rectangle2D redrawArea2 = this.updateLinks();
            redrawArea = GUtil.union(redrawArea, redrawArea2);
            this.notifyChange(addElements, 5, removedElemns);
            this.notifyRepaint(redrawArea);
        }
    }

    public int getAtomCnt() {
        ++this.atomCnt;
        return this.atomCnt;
    }

    private Rectangle2D.Double addElement(GElement element, boolean keepInclusionRelation) throws Exception {
        Rectangle2D.Double redrawArea = element.getRepaintBounds();
        if (element instanceof GBasicAtom) {
            if (element instanceof LayerSpeciesAlias) {
                LayerSpeciesAlias alias = (LayerSpeciesAlias)element;
                if (alias.getBelong_layer_id() == -99) {
                    this.addLayerForTag();
                    LayerManager layer = LayerManager.getSelectedLayerManager(this.layers, alias.getBelong_layer_id());
                    layer.addTexts(element);
                } else if (alias.getBelong_layer_id() != -1) {
                    LayerManager layer = LayerManager.getSelectedLayerManager(this.layers, alias.getBelong_layer_id());
                    layer.addTexts(element);
                } else {
                    LayerManager layer = MainWindow.getLastInstance().getSelectedLayer();
                    layer.addTexts(element);
                    ((LayerSpeciesAlias)element).setBelong_layer_id(layer.getId());
                }
            } else {
                if (element.getName().equals("")) {
                    ++this.atomCnt;
                    element.setName(String.valueOf(this.atomNametag()) + this.atomCnt);
                }
                this.atoms.add(element);
            }
        } else if (element instanceof GContainableAtom) {
            if (element.getName().equals("")) {
                ++this.containerAtomCnt;
                element.setName(String.valueOf(this.containerAtomtag()) + this.containerAtomCnt);
            }
            this.containeratoms.add(element);
        } else if (element instanceof GGroup) {
            if (element.getName().equals("")) {
                ++this.groupCnt;
                element.setName(String.valueOf(this.groupNametag()) + this.groupCnt);
            }
            this.groups.add(element);
        } else if (element instanceof GContainer) {
            if (element instanceof LayerCompartmentAlias) {
                LayerCompartmentAlias alias = (LayerCompartmentAlias)((Object)element);
                if (alias.getBelong_layer_id() != -1) {
                    LayerManager layer = LayerManager.getSelectedLayerManager(this.layers, alias.getBelong_layer_id());
                    layer.addSquares(element);
                } else {
                    LayerManager layer = MainWindow.getLastInstance().getSelectedLayer();
                    layer.addSquares(element);
                    ((LayerCompartmentAlias)((Object)element)).setBelong_layer_id(layer.getId());
                }
            } else {
                if (element.getName().equals("")) {
                    ++this.containerCnt;
                    element.setName(String.valueOf(this.containerNametag()) + this.containerCnt);
                }
                this.containers.add(element);
            }
        } else if (element instanceof GLink) {
            if (element instanceof LayerReactionLink) {
                LayerReactionLink alias = (LayerReactionLink)element;
                if (alias.getBelong_layer_id() == -99) {
                    this.addLayerForTag();
                    LayerManager layer = LayerManager.getSelectedLayerManager(this.layers, alias.getBelong_layer_id());
                    layer.addFreeLines(element);
                } else if (alias.getBelong_layer_id() != -1) {
                    LayerManager layer = LayerManager.getSelectedLayerManager(this.layers, alias.getBelong_layer_id());
                    layer.addFreeLines(element);
                } else {
                    LayerManager layer = MainWindow.getLastInstance().getSelectedLayer();
                    layer.addFreeLines(element);
                    ((LayerReactionLink)element).setBelong_layer_id(layer.getId());
                }
            } else {
                if (!this.isAbleToAdd((GLink)element)) {
                    System.out.println("CAUTION !isAbleToAdd");
                    throw new Exception();
                }
                if (element.getName().equals("")) {
                    ++this.linkCnt;
                    element.setName(String.valueOf(this.linkNametag()) + this.linkCnt);
                }
                this.links.add(element);
                this.sortLinks((GLink)element);
                redrawArea = GUtil.union(redrawArea, GLogicGate.changeLinkBecauseGLogicGate((GLink)element, true));
                GLogicGate.changeLinkOrder(this.links, (GLink)element);
            }
        } else if (element instanceof GCreasePointForUndo) {
            int index;
            Rectangle2D updateRect1;
            GCreasePoint cp = ((GCreasePointForUndo)element).getOriginal();
            GEditable owner = cp.getOwner();
            if (owner instanceof GLinkedCreaseLine) {
                Map paramMap;
                int index2 = ((GCreasePointForUndo)element).getIndex();
                Rectangle2D updateRect12 = ((GLinkedCreaseLine)owner).addCreasePointWithoutNotify(cp, this, index2, paramMap = ((GCreasePointForUndo)element).getParamMap());
                if (updateRect12 != null) {
                    redrawArea = GUtil.union(redrawArea, updateRect12);
                }
            } else if (owner instanceof GLogicGate) {
                int index3 = ((GCreasePointForUndo)element).getIndex();
                Map paramMap = ((GCreasePointForUndo)element).getParamMap();
                Rectangle2D updateRect13 = ((GLogicGate)owner).getRealLine().addCreasePointWithoutNotify(cp, this, index3, paramMap);
                if (updateRect13 != null) {
                    redrawArea = GUtil.union(redrawArea, updateRect13);
                }
            } else if (owner instanceof GLinkedCurveAndLine && (updateRect1 = ((GLinkedCurveAndLine)owner).addCreasePointWithoutNotify(cp, this, index = ((GCreasePointForUndo)element).getIndex())) != null) {
                redrawArea = GUtil.union(redrawArea, updateRect1);
            }
        } else {
            return null;
        }
        if (element instanceof GPointed) {
            ((GPointed)((Object)element)).setMaxArea(this.maxArea);
        }
        if (GStructure.inContainableState(element) && !keepInclusionRelation) {
            this.resetContainer((GContainer)((Object)element));
        }
        if (element instanceof GContainerTarget) {
            this.resetContainerOf((GContainerTarget)((Object)element));
        }
        element.update();
        return redrawArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStructureListener(GStructureListener structurelistener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(structurelistener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStructurePainter(GStructurePainter structurepainter) {
        Vector vector = this.painters;
        synchronized (vector) {
            this.painters.add(structurepainter);
        }
    }

    public String atomNametag() {
        return this.atomTag;
    }

    public String containerAtomtag() {
        return this.containerAtomTag;
    }

    private Rectangle2D.Double changeTargetHighlights(Vector prevHighlighteds, Vector newHighlighteds) {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < prevHighlighteds.size()) {
            GContainerTarget containertarget1 = (GContainerTarget)prevHighlighteds.elementAt(i);
            if (!newHighlighteds.contains(containertarget1)) {
                containertarget1.setHighlightedAsTarget(false);
                redrawArea = GUtil.union(redrawArea, ((GElement)((Object)containertarget1)).getRepaintBounds());
            } else if (!containertarget1.isHighlightedAsTarget()) {
                containertarget1.setHighlightedAsTarget(true);
                redrawArea = GUtil.union(redrawArea, ((GElement)((Object)containertarget1)).getRepaintBounds());
            }
            ++i;
        }
        i = 0;
        while (i < newHighlighteds.size()) {
            GContainerTarget containertarget2 = (GContainerTarget)newHighlighteds.elementAt(i);
            if (!prevHighlighteds.contains(containertarget2)) {
                containertarget2.setHighlightedAsTarget(true);
                redrawArea = GUtil.union(redrawArea, ((GElement)((Object)containertarget2)).getRepaintBounds());
            }
            ++i;
        }
        return redrawArea;
    }

    private void clearContainer(GContainer container) {
        if (container instanceof ComplexSpeciesAlias) {
            this.clearComplexContainer((ComplexSpeciesAlias)container);
            return;
        }
        Vector targets = container.getTargets();
        int i = 0;
        while (i < targets.size()) {
            GContainerTarget gcontainertarget = (GContainerTarget)targets.elementAt(i);
            GContainer gcontainer = this.getOutside(gcontainertarget);
            if (gcontainer == null) {
                this.clearContainerOf(gcontainertarget);
                container.removeTarget(gcontainertarget);
            } else if (gcontainer != container) {
                GStructure.setContainerTarget(gcontainer, gcontainertarget);
                container.removeTarget(gcontainertarget);
            }
            ++i;
        }
    }

    private void clearContainerOf(GContainerTarget gcontainertarget) {
        GContainer gcontainer = gcontainertarget.getContainer();
        if (gcontainer != null) {
            ComplexSpeciesAlias complexAlias;
            if (gcontainer instanceof ComplexSpeciesAlias && ((complexAlias = (ComplexSpeciesAlias)gcontainer).getCurrentView() == 1 || complexAlias.getCurrentView() == 3)) {
                return;
            }
            gcontainer.removeTarget(gcontainertarget);
            gcontainertarget.setContainer(null);
            gcontainertarget.setInnerPosition(null);
        }
    }

    public String containerNametag() {
        return this.containerTag;
    }

    public boolean contains(GElement gelement) {
        block23: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block22: {
                                    if (!(gelement instanceof GBasicAtom)) break block22;
                                    if (gelement instanceof LayerSpeciesAlias) {
                                        int i = this.layers.size() - 1;
                                        while (i >= 0) {
                                            LayerManager m = (LayerManager)this.layers.get(i);
                                            ArrayList listOfTexts = m.getListOfTexts();
                                            if (listOfTexts.contains(gelement)) {
                                                return true;
                                            }
                                            --i;
                                        }
                                        return false;
                                    }
                                    if (this.atoms.contains(gelement)) {
                                        return true;
                                    }
                                    break block23;
                                }
                                if (!(gelement instanceof GContainableAtom)) break block24;
                                if (this.containeratoms.contains(gelement)) {
                                    return true;
                                }
                                break block23;
                            }
                            if (!(gelement instanceof GContainer)) break block25;
                            if (gelement instanceof LayerClosedCompartmentAlias) {
                                int i = this.layers.size() - 1;
                                while (i >= 0) {
                                    LayerManager m = (LayerManager)this.layers.get(i);
                                    ArrayList listOfSquares = m.getListOfSquares();
                                    if (listOfSquares.contains(gelement)) {
                                        return true;
                                    }
                                    --i;
                                }
                                return false;
                            }
                            if (this.containers.contains(gelement)) {
                                return true;
                            }
                            break block23;
                        }
                        if (!(gelement instanceof GLink)) break block26;
                        if (gelement instanceof LayerReactionLink) {
                            int i = this.layers.size() - 1;
                            while (i >= 0) {
                                LayerManager m = (LayerManager)this.layers.get(i);
                                ArrayList listOfFreeLines = m.getListOfFreeLines();
                                if (listOfFreeLines.contains(gelement)) {
                                    return true;
                                }
                                --i;
                            }
                            return false;
                        }
                        if (this.links.contains(gelement)) {
                            return true;
                        }
                        break block23;
                    }
                    if (!(gelement instanceof GGroup)) break block27;
                    if (this.groups.contains(gelement)) {
                        return true;
                    }
                    break block23;
                }
                if (!(gelement instanceof NameImage)) break block28;
                int size = this.containers.size();
                int i = 0;
                while (i < size) {
                    CompartmentAlias compartmentAlias;
                    if (this.containers.elementAt(i) instanceof CompartmentAlias && (compartmentAlias = (CompartmentAlias)this.containers.elementAt(i)).getCompartmentNameImage().equals(gelement)) {
                        return true;
                    }
                    ++i;
                }
                break block23;
            }
            if (!(gelement instanceof InformationBox)) break block23;
            int cnt = this.atoms.size() - 1;
            while (cnt >= 0) {
                ElementSpeciesAlias elementSpeciesAlias = (ElementSpeciesAlias)this.atoms.elementAt(cnt);
                if (elementSpeciesAlias.getInfoBox() != null && !InformationBox.isEmptyState(elementSpeciesAlias.getInfoBox().getStateString()) && elementSpeciesAlias.getInfoBox().equals(gelement)) {
                    return true;
                }
                --cnt;
            }
            cnt = 0;
            while (cnt < this.containeratoms.size()) {
                ComplexSpeciesAlias complexSpeciesAlias = (ComplexSpeciesAlias)this.containeratoms.elementAt(cnt);
                if (complexSpeciesAlias.getInfoBox() != null && !InformationBox.isEmptyState(complexSpeciesAlias.getInfoBox().getStateString()) && complexSpeciesAlias.getInfoBox().equals(gelement)) {
                    return true;
                }
                ++cnt;
            }
            int size = this.containers.size();
            int i = 0;
            while (i < size) {
                CompartmentAlias compartmentAlias;
                if (this.containers.elementAt(i) instanceof CompartmentAlias && (compartmentAlias = (CompartmentAlias)this.containers.elementAt(i)).getInfoBox() != null && !InformationBox.isEmptyState(compartmentAlias.getInfoBox().getStateString()) && compartmentAlias.getInfoBox().equals(gelement)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public synchronized Rectangle2D deselect(GElement gelement) {
        return this.deselect(gelement, false);
    }

    public synchronized Rectangle2D deselect(GElement gelement, boolean repaint) {
        return this.deselect(gelement, repaint, true);
    }

    public synchronized Rectangle2D deselect(GElement gelement, boolean repaint, boolean change) {
        return this.deselect(gelement, repaint, change, true);
    }

    public synchronized Rectangle2D deselect(GElement gelement, boolean repaint, boolean change, boolean highlight) {
        Rectangle2D redrawArea = new Rectangle2D.Double();
        if (gelement != null && this.contains(gelement)) {
            redrawArea = this.doDeselect(gelement, highlight);
            if (change) {
                this.notifyChange(gelement, 7, null);
            }
            if (repaint) {
                this.notifyRepaint(redrawArea);
            }
        }
        return redrawArea;
    }

    private synchronized Rectangle2D doDeselect(GElement gelement) {
        return this.doDeselect(gelement, true);
    }

    private synchronized Rectangle2D doDeselect(GElement gelement, boolean highlight) {
        GLinkedShape glinkedshape;
        GContainer container;
        Rectangle2D.Double redrawArea = null;
        Vector<GContainer> parentNodes = new Vector<GContainer>();
        if (gelement instanceof ComplexSpeciesAlias) {
            this.foundAllParentComplexNodes((ComplexSpeciesAlias)gelement, parentNodes);
        } else if (gelement instanceof ElementSpeciesAlias && (container = ((ElementSpeciesAlias)gelement).getContainer()) != null && container instanceof ComplexSpeciesAlias) {
            parentNodes.add(container);
            this.foundAllParentComplexNodes((ComplexSpeciesAlias)container, parentNodes);
        }
        if (parentNodes != null && parentNodes.size() > 0) {
            int c = 0;
            while (c < parentNodes.size()) {
                if (this.selectedVector.contains(parentNodes.get(c))) {
                    return null;
                }
                ++c;
            }
        }
        gelement.setHighlighted(false);
        if (gelement instanceof GResizable) {
            ((GResizable)((Object)gelement)).activateHandle(false);
        }
        if (gelement instanceof GLink && (glinkedshape = ((GLink)gelement).getGLinkedShape()) instanceof GEditable) {
            ((GEditable)((Object)glinkedshape)).activateEditPoints(false);
        }
        redrawArea = gelement.getRepaintBounds();
        if (highlight) {
            Rectangle2D redrawArea2 = this.highlightChainedLinks(gelement);
            redrawArea = GUtil.union(redrawArea, redrawArea2);
        }
        if (gelement instanceof GContainer) {
            Rectangle2D redrawArea3 = this.highlightContainerTargets((GContainer)((Object)gelement), false);
            redrawArea = GUtil.union(redrawArea, redrawArea3);
        }
        this.selectedVector.remove(gelement);
        Rectangle2D r = null;
        r = this.resetSelectedContainers();
        if (r != null) {
            redrawArea = GUtil.union(redrawArea, r);
        }
        this.notifyChange(gelement, 7, null);
        return redrawArea;
    }

    public synchronized void resetList() {
        Vector vector = (Vector)this.listeners.clone();
        int i = 0;
        while (i < vector.size()) {
            GStructureListener gstructurelistener = (GStructureListener)vector.elementAt(i);
            gstructurelistener.resetList(this.selectedVector);
            ++i;
        }
    }

    public synchronized void deselectAll() {
        Rectangle2D.Double redrawArea = null;
        int i = this.selectedVector.size() - 1;
        while (i >= 0) {
            GLinkedShape glinkedshape;
            GElement gelement = (GElement)this.selectedVector.remove(i);
            gelement.setHighlighted(false);
            if (gelement instanceof GResizable) {
                ((GResizable)((Object)gelement)).activateHandle(false);
            }
            if (gelement instanceof GLink && (glinkedshape = ((GLink)gelement).getGLinkedShape()) instanceof GEditable) {
                ((GEditable)((Object)glinkedshape)).activateEditPoints(false);
            }
            redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
            if (gelement instanceof GContainer) {
                Rectangle2D redrawArea2 = this.highlightContainerTargets((GContainer)((Object)gelement), false);
                redrawArea = GUtil.union(redrawArea, redrawArea2);
            }
            if (gelement instanceof GContainerTarget) {
                ((GContainerTarget)((Object)gelement)).setHighlightedAsTarget(false);
            }
            this.notifyChange(gelement, 7, null);
            --i;
        }
        this.selectedVector.clear();
        this.moveLinkList.clear();
        redrawArea = GUtil.union(this.deselect(this.links), redrawArea);
        i = 0;
        while (i < this.layers.size()) {
            LayerManager layer = (LayerManager)this.layers.get(i);
            if (layer.getId() == -99) {
                ArrayList layerTagFreeLines = layer.getListOfFreeLines();
                redrawArea = GUtil.union(this.deselect(layerTagFreeLines), redrawArea);
                break;
            }
            ++i;
        }
        this.notifyRepaint(redrawArea);
        this.notifyChange(null, 6, null);
    }

    private Rectangle2D deselect(List elements) {
        Rectangle2D.Double rect = null;
        int i = 0;
        while (i < elements.size()) {
            GContainerTarget containerTarget;
            GElement element = (GElement)elements.get(i);
            if (element.isHighlighted()) {
                GLinkedShape linkedShape;
                element.setHighlighted(false);
                if (element instanceof GResizable) {
                    ((GResizable)((Object)element)).activateHandle(false);
                } else if (element instanceof GLink && (linkedShape = ((GLink)element).getGLinkedShape()) instanceof GEditable) {
                    ((GEditable)((Object)linkedShape)).activateEditPoints(false);
                }
                rect = GUtil.union(element.getRepaintBounds(), rect);
            }
            if (element instanceof GContainerTarget && (containerTarget = (GContainerTarget)((Object)element)).isHighlightedAsTarget()) {
                containerTarget.setHighlightedAsTarget(false);
                rect = GUtil.union(element.getRepaintBounds(), rect);
            }
            ++i;
        }
        return rect;
    }

    private Rectangle2D deselectLowerChains(GElement gelement) {
        Rectangle2D.Double redrawArea = null;
        int i = this.links.size() - 1;
        while (i >= 0) {
            GLink glink = (GLink)this.links.get(i);
            if (gelement instanceof GLinkTarget && glink.isLinkOf((GLinkTarget)((Object)gelement))) {
                Rectangle2D r;
                if (this.selectedVector.contains(glink)) {
                    r = this.doDeselect(glink);
                    redrawArea = GUtil.union(redrawArea, r);
                }
                r = this.deselectLowerChains(glink);
                redrawArea = GUtil.union(redrawArea, r);
            }
            --i;
        }
        return redrawArea;
    }

    private Rectangle2D deselectLowerTargets(GContainer gcontainer) {
        Rectangle2D.Double redrawArea = null;
        Vector vector = gcontainer.getTargets();
        int i = 0;
        while (i < vector.size()) {
            GGroup ggroup;
            Rectangle2D r;
            GElement gelement = (GElement)vector.get(i);
            if (this.selectedVector.contains(gelement)) {
                r = this.doDeselect(gelement);
                redrawArea = GUtil.union(redrawArea, r);
            }
            if (gelement instanceof GGroupTarget && (ggroup = this.getParentGroup(gelement)) != null && this.selectedVector.contains(ggroup)) {
                r = this.doDeselect(ggroup);
                redrawArea = GUtil.union(redrawArea, r);
            }
            if (gelement instanceof GContainer) {
                r = this.deselectLowerTargets((GContainer)((Object)gelement));
                redrawArea = GUtil.union(redrawArea, r);
            }
            ++i;
        }
        return redrawArea;
    }

    private Rectangle2D deselectUpperChains(GLink glink) {
        Rectangle2D.Double redrawArea = null;
        GLinkTarget[] targets = glink.getTargets();
        int i = 0;
        while (i < targets.length) {
            Rectangle2D r;
            GLinkTarget glinktarget = targets[i];
            if (this.selectedVector.contains(glinktarget)) {
                r = this.doDeselect((GElement)((Object)glinktarget));
                redrawArea = GUtil.union(redrawArea, r);
            }
            if (glinktarget instanceof GLink) {
                r = this.deselectUpperChains((GLink)glinktarget);
                redrawArea = GUtil.union(redrawArea, r);
            }
            ++i;
        }
        return redrawArea;
    }

    private Rectangle2D deselectUpperContainers(GContainerTarget gcontainertarget) {
        Rectangle2D.Double redrawArea = null;
        GContainer gcontainer = gcontainertarget.getContainer();
        if (gcontainer != null) {
            Rectangle2D r;
            if (this.selectedVector.contains(gcontainer)) {
                r = this.doDeselect((GElement)((Object)gcontainer));
                redrawArea = GUtil.union(redrawArea, r);
            }
            if (gcontainer instanceof GContainerTarget) {
                r = this.deselectUpperContainers((GContainerTarget)((Object)gcontainer));
                redrawArea = GUtil.union(redrawArea, r);
            }
        }
        return redrawArea;
    }

    public void dispose() {
        this.painters.clear();
        this.painters = null;
        this.listeners.clear();
        this.listeners = null;
        this.recorder = null;
        this.selectedVector.clear();
        this.selectedVector = null;
        this.groups.clear();
        this.groups = null;
        this.links.clear();
        this.links = null;
        this.sortedLinks.clear();
        this.sortedLinks = null;
        this.containers.clear();
        this.containers = null;
        this.containeratoms.clear();
        this.containeratoms = null;
        this.atoms.clear();
        this.atoms = null;
        this.tmp = null;
        this.selectRect = null;
        this.maxArea = null;
        this.layers.clear();
        this.layers = null;
        if (this.currentInformationShowersControlFrame != null) {
            this.currentInformationShowersControlFrame.dispose();
            this.currentInformationShowersControlFrame = null;
        }
    }

    public Vector getLayers() {
        return this.layers;
    }

    protected Rectangle2D doMoveMain(GElement element, double x, double y) {
        return this.doMoveMain(element, x, y, false);
    }

    protected Rectangle2D doMoveMain(GElement element, double x, double y, boolean updateLinks) {
        GEditable geditable;
        double xNew = x;
        double yNew = y;
        GLogicGate gate = GStructure.isGLogicGateHeaderPoint(element);
        if (gate != null) {
            double size;
            Point2D.Double newPnt;
            ReactionLink rl;
            boolean isMoveOne = false;
            if (this.selectedVector != null && this.selectedVector.size() == 1 && this.selectedVector.get(0) instanceof ReactionLink && (rl = (ReactionLink)this.selectedVector.get(0)).getGLinkedShape() == gate) {
                isMoveOne = true;
            }
            if (isMoveOne && (newPnt = GStructure.givePntInValidArea(this.maxArea, size = GStructure.getGLogicGateDIAMETER(gate), size, x, y)) != null) {
                xNew = newPnt.x;
                yNew = newPnt.y;
            }
        }
        Vector contained1 = null;
        boolean containableState = GStructure.inContainableState(element);
        if (containableState) {
            contained1 = this.getInsides((GContainer)((Object)element));
        }
        if (element instanceof GFramed) {
            if (element instanceof NameImage) {
                Point2D.Double nearestPoint = ((NameImage)element).getNearestPointInParent(new Point2D.Double(x, y));
                x = nearestPoint.x;
                y = nearestPoint.y;
                if (x < 0.0) {
                    x = 0.0;
                }
                if (y < 0.0) {
                    y = 0.0;
                }
            }
            if (element instanceof InformationBox) {
                double newX = x;
                double newY = y;
                Point2D.Double posTmp = ((InformationBox)element).getCenterPoint();
                Point2D.Double deltaPoint = ((InformationBox)element).getDeltaPoint2DUsingOnlyByMoving();
                if (posTmp != null && deltaPoint != null) {
                    newX = posTmp.x + deltaPoint.x;
                    newY = posTmp.y + deltaPoint.y;
                } else if (posTmp != null) {
                    newX = posTmp.x;
                    newY = posTmp.y;
                }
                ((InformationBox)element).setFramePosition(newX, newY);
                ((InformationBox)element).clearDeltaPoint2DUsingOnlyByMoving();
            } else {
                ((GFramed)((Object)element)).setFramePosition(x, y);
            }
        } else if (element instanceof GPointed) {
            OpenedCompartmentAlias compartment;
            NameImage nameImage;
            if (element instanceof OpenedCompartmentAlias && (nameImage = (compartment = (OpenedCompartmentAlias)element).getCompartmentNameImage()) != null) {
                if (nameImage.getUndoRedoFlg()) {
                    compartment.restoreNameImagePosition();
                } else {
                    compartment.resetNameImagePosition();
                }
            }
            ((GPointed)((Object)element)).setPoint(x, y);
        } else if (element instanceof GLink) {
            ((GLink)element).setRepresentPosition(x, y);
        }
        Rectangle2D redrawArea = element.update();
        if (redrawArea == null) {
            redrawArea = element.getRepaintBounds();
        }
        if (element instanceof ComplexSpeciesAlias) {
            this.changeComplexOrder(element, ((GFramed)((Object)element)).getFrameBounds());
        }
        if (containableState) {
            boolean gpointed = element instanceof GPointed;
            Rectangle2D tempRedrawArea = this.moveTargetsOf((GContainer)((Object)element), x, y, gpointed);
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
        }
        if (element instanceof GLinkHandlePointForUndo) {
            ((GLinkHandlePointForUndo)element).processForMove(x, y);
            updateLinks = false;
            Vector<GLink> v = new Vector<GLink>();
            v.addElement(((GLinkHandlePointForUndo)element).getTargetGLink());
            Rectangle2D tempRedrawArea = this.updateLinksAfterShapesMoving(v, false);
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
        } else if (element instanceof GEditPoint && (geditable = ((GEditPoint)element).getOwner()) != null) {
            Rectangle2D.Double tempRedrawArea = geditable.moveEditPoint((GEditPoint)element, xNew, yNew);
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
        }
        Rectangle2D tempLayerRedrawArea = this.updateLayerTextLinks();
        redrawArea = GUtil.union(redrawArea, tempLayerRedrawArea);
        Rectangle2D tempLayerSpeciesRedrawArea = this.updateLayerSpeciesLinks();
        redrawArea = GUtil.union(redrawArea, tempLayerSpeciesRedrawArea);
        if (updateLinks) {
            Rectangle2D tempRedrawArea = this.updateLinks();
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
        }
        if (containableState && element.isHighlighted() && (!(element instanceof GContainableAtom) || ((GAtom)element).getCurrentView() != 1)) {
            Vector contained2 = this.getInsides((GContainer)((Object)element));
            Rectangle2D.Double tempRedrawArea = this.changeTargetHighlights(contained1, contained2);
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
        }
        return redrawArea;
    }

    private void reOrderShapes(Vector elementvec) {
        Vector elvec = GPaintOrder.getOrderedElements();
        int ii = 0;
        while (ii < elvec.size()) {
            GElement element = (GElement)elvec.elementAt(ii);
            int flg = GPaintOrder.getOrderFlg();
            if (element instanceof GGroup) {
                GGroup group = (GGroup)element;
                Vector menbers = group.getMembers();
                Vector<GElement> membersFound = new Vector<GElement>();
                ListIterator li = elementvec.listIterator(elementvec.size());
                block1: while (li.hasPrevious()) {
                    GElement el = (GElement)li.previous();
                    int j = 0;
                    while (j < menbers.size()) {
                        if (menbers.elementAt(j) == el) {
                            li.remove();
                            membersFound.addElement(el);
                            continue block1;
                        }
                        ++j;
                    }
                }
                Vector addvector = new Vector(membersFound.size());
                int k = membersFound.size() - 1;
                while (k >= 0) {
                    addvector.addElement(membersFound.elementAt(k));
                    --k;
                }
                if (flg == 2) {
                    elementvec.addAll(0, addvector);
                } else {
                    elementvec.addAll(addvector);
                }
            } else {
                int i = 0;
                while (i < elementvec.size()) {
                    GElement el = (GElement)elementvec.elementAt(i);
                    if (el == element) {
                        elementvec.removeElementAt(i);
                        if (flg == 2) {
                            elementvec.insertElementAt(el, 0);
                            break;
                        }
                        elementvec.addElement(el);
                        break;
                    }
                    ++i;
                }
            }
            ++ii;
        }
    }

    public void draw(Graphics2D g2) {
        GLink glink;
        if (this.bBypassDraw) {
            return;
        }
        if (GPaintOrder.checkOrderMode() == 2) {
            this.reOrderShapes(this.containers);
            this.reOrderShapes(this.atoms);
            this.reOrderShapes(this.groups);
            GPaintOrder.setOrderMode(0);
        }
        this.doingSomethingBeforeDraw();
        Rectangle clip = g2.getClipBounds();
        this.draw(g2, clip, this.containers);
        Vector vBaseContaineratoms = new Vector();
        int i = 0;
        while (i < this.containeratoms.size()) {
            GContainer container = ((ComplexSpeciesAlias)this.containeratoms.get(i)).getContainer();
            if (container == null || !(container instanceof ComplexSpeciesAlias)) {
                vBaseContaineratoms.add(this.containeratoms.get(i));
            }
            ++i;
        }
        Vector vAllMembersofBaseContaineratoms = new Vector();
        int i2 = 0;
        while (i2 < vBaseContaineratoms.size()) {
            vAllMembersofBaseContaineratoms.add(vBaseContaineratoms.get(i2));
            vAllMembersofBaseContaineratoms.addAll(((ComplexSpeciesAlias)vBaseContaineratoms.get(i2)).getAllTargetsInMe(true));
            ++i2;
        }
        Vector vNeedsDrawContaineratoms = new Vector();
        int i3 = 0;
        while (i3 < vAllMembersofBaseContaineratoms.size()) {
            if (vAllMembersofBaseContaineratoms.get(i3) instanceof ComplexSpeciesAlias) {
                vNeedsDrawContaineratoms.add(vAllMembersofBaseContaineratoms.get(i3));
            }
            ++i3;
        }
        Vector<Vector> vAllSelectedSpecies = new Vector<Vector>();
        if (this.selectedVector != null && this.selectedVector.size() != 0) {
            int i4 = 0;
            while (i4 < this.selectedVector.size()) {
                GElement ge = (GElement)this.selectedVector.get(i4);
                if (ge instanceof ComplexSpeciesAlias && !vAllSelectedSpecies.contains(ge)) {
                    vAllSelectedSpecies.add(((ComplexSpeciesAlias)ge).getAllTargetsInMe(true));
                }
                ++i4;
            }
        }
        Vector vNeedsDrawContaineratoms_notbeenselected = new Vector();
        Vector vNeedsDrawContaineratoms_havebeenselected = new Vector();
        int i5 = 0;
        while (i5 < vNeedsDrawContaineratoms.size()) {
            if (!vAllSelectedSpecies.contains(vNeedsDrawContaineratoms.get(i5))) {
                vNeedsDrawContaineratoms_notbeenselected.add(vNeedsDrawContaineratoms.get(i5));
            } else {
                vNeedsDrawContaineratoms_havebeenselected.add(vNeedsDrawContaineratoms.get(i5));
            }
            ++i5;
        }
        this.draw(g2, clip, vNeedsDrawContaineratoms_notbeenselected);
        this.draw(g2, clip, this.atoms);
        this.draw(g2, clip, this.groups);
        this.drawLayers(g2, clip, this.layers);
        this.drawShowers(g2, clip, this.informationShowers);
        if (this.isClossLineON) {
            ArrayList<GLink> linkList = new ArrayList<GLink>();
            int i6 = 0;
            while (i6 < this.sortedLinks.size()) {
                List list = (List)this.sortedLinks.get(i6);
                linkList.clear();
                int j = 0;
                while (j < list.size()) {
                    glink = (GLink)list.get(j);
                    if (!(clip == null || !clip.intersects(glink.getBounds()) || this.moveMode && this.moveLinkList.contains(glink) || this.linkMoveMode && this.selectedVector.contains(glink))) {
                        glink.drawWhiteBase(g2);
                        linkList.add(glink);
                    }
                    ++j;
                }
                if (linkList.size() != 0) {
                    GLink glink2;
                    Vector<GLink> vOther = new Vector<GLink>();
                    int j2 = 0;
                    while (j2 < linkList.size()) {
                        GLink glink3 = (GLink)linkList.get(j2);
                        if (glink3.getGLinkedShape() instanceof GLinkedCurveLine || glink3.getGLinkedShape() instanceof GLinkedCurveAndLine) {
                            if (!glink3.isHighlighted()) {
                                glink3.draw(g2);
                            } else {
                                vOther.add(glink3);
                            }
                        } else {
                            vOther.add(glink3);
                        }
                        ++j2;
                    }
                    Vector<GLink> vGate = new Vector<GLink>();
                    int j3 = 0;
                    while (j3 < vOther.size()) {
                        glink2 = (GLink)vOther.get(j3);
                        if (glink2.getGLinkedShape() instanceof GLogicGate) {
                            vGate.add(glink2);
                        } else {
                            glink2.draw(g2);
                        }
                        ++j3;
                    }
                    j3 = 0;
                    while (j3 < vGate.size()) {
                        glink2 = (GLink)vGate.get(j3);
                        glink2.draw(g2);
                        ++j3;
                    }
                }
                ++i6;
            }
        } else {
            Vector<GLink> vPaintA = new Vector<GLink>();
            Vector<GLink> vOther = new Vector<GLink>();
            Vector<GLink> vGate = new Vector<GLink>();
            int j = 0;
            while (j < this.links.size()) {
                glink = (GLink)this.links.get(j);
                if (glink.getGLinkedShape() instanceof GLinkedCurveLine || glink.getGLinkedShape() instanceof GLinkedCurveAndLine) {
                    if (!glink.isHighlighted()) {
                        vPaintA.add(glink);
                    } else {
                        vOther.add(glink);
                    }
                } else if (glink.getGLinkedShape() instanceof GLogicGate) {
                    vGate.add(glink);
                } else {
                    vOther.add(glink);
                }
                ++j;
            }
            this.draw(g2, clip, vPaintA);
            this.draw(g2, clip, vOther);
            this.draw(g2, clip, vGate);
        }
        this.drawLink(g2);
        if (this.tmp != null) {
            this.tmp.draw(g2);
        }
        if (this.vectOutputingImgInDebug != null) {
            Color colorBak = g2.getColor();
            int i7 = 0;
            while (i7 < this.vectOutputingImgInDebug.size()) {
                try {
                    Rectangle2D recFrame = (Rectangle2D)this.vectOutputingImgInDebug.get(i7);
                    g2.setColor(Color.BLUE);
                    g2.draw(recFrame);
                    g2.setColor(new Color(192, 192, 192, 112));
                    g2.fill(recFrame);
                    if (i7 == this.vectOutputingImgInDebug.size() - 1) {
                        g2.setColor(Color.RED);
                    } else {
                        g2.setColor(Color.ORANGE);
                    }
                    g2.drawString("" + i7, (int)recFrame.getX(), (int)(recFrame.getY() + recFrame.getHeight()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i7;
            }
            g2.setColor(colorBak);
        }
    }

    public void setVectOutputingImgInDebug(Vector vectInput) {
        this.vectOutputingImgInDebug = vectInput;
    }

    public void draw(Graphics2D g2, List elementList) {
        this.draw(g2, g2.getClipBounds(), elementList);
    }

    public void draw(Graphics2D g2, Rectangle2D clip, List elementList) {
        if (clip == null) {
            throw new IllegalArgumentException("clip bounds is null");
        }
        double x = clip.getX();
        double y = clip.getY();
        double w = clip.getWidth();
        double h = clip.getHeight();
        int size = elementList.size();
        int i = 0;
        while (i < size) {
            GElement element = (GElement)elementList.get(i);
            if (element.getRepaintBounds().intersects(x, y, w, h)) {
                element.draw(g2);
            }
            ++i;
        }
    }

    public void drawLayers(Graphics2D g2, Rectangle2D clip, List elementList) {
        if (clip == null) {
            throw new IllegalArgumentException("clip bounds is null");
        }
        int size = elementList.size();
        int i = 0;
        while (i < size) {
            LayerManager layer = (LayerManager)elementList.get(i);
            if (layer.isVisible()) {
                this.draw(g2, clip, layer.getListOfTexts());
                this.draw(g2, clip, layer.getListOfFreeLines());
                this.draw(g2, clip, layer.getListOfSquares());
            }
            ++i;
        }
    }

    public void drawSelectRect(Graphics2D g2) {
        if (this.isSelectMode() && this.selectRect != null) {
            g2.setColor(Color.BLUE);
            Stroke stroke = g2.getStroke();
            g2.setStroke(XOR_STROKE);
            g2.draw(this.selectRect);
            g2.setPaintMode();
            g2.setStroke(stroke);
        }
    }

    public void drawLink(Graphics2D g2) {
        GLink link;
        if (this.bBypassDraw) {
            return;
        }
        Vector<GLink> vGate = new Vector<GLink>();
        int size = this.moveLinkList.size();
        int i = 0;
        while (i < size) {
            link = (GLink)this.moveLinkList.get(i);
            if (link.getGLinkedShape() instanceof GLogicGate) {
                vGate.add(link);
            } else {
                link.draw(g2);
            }
            ++i;
        }
        if (this.selectedVector != null) {
            i = 0;
            while (i < this.selectedVector.size()) {
                if (this.selectedVector.get(i) instanceof GLink && (this.moveLinkList == null || !this.moveLinkList.contains(this.selectedVector.get(i)))) {
                    link = (GLink)this.selectedVector.get(i);
                    if (link.getGLinkedShape() instanceof GLogicGate) {
                        vGate.add(link);
                    } else {
                        link.draw(g2);
                    }
                }
                ++i;
            }
        }
        int j = 0;
        while (j < vGate.size()) {
            GLink glink = (GLink)vGate.get(j);
            glink.draw(g2);
            ++j;
        }
    }

    public void drawLoupeSymbol(Graphics2D graphics2d, double ratio) {
        float cy;
        float cx;
        Rectangle2D.Double bounds;
        GElement gelement;
        int radius = 20;
        Color originalcolor = graphics2d.getColor();
        int i = 0;
        while (i < this.atoms.size()) {
            gelement = (GElement)this.atoms.elementAt(i);
            bounds = gelement.getBounds();
            cx = (float)bounds.getCenterX();
            cy = (float)bounds.getCenterY();
            if (gelement.isHighlighted()) {
                graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
                graphics2d.fillOval((int)(cx - (float)radius), (int)(cy - (float)radius), radius * 2, radius * 2);
                graphics2d.setColor(originalcolor);
            } else {
                graphics2d.fillOval((int)(cx - (float)radius), (int)(cy - (float)radius), radius * 2, radius * 2);
            }
            ++i;
        }
        i = 0;
        while (i < this.groups.size()) {
            gelement = (GElement)this.groups.elementAt(i);
            bounds = gelement.getBounds();
            cx = (float)bounds.getCenterX();
            cy = (float)bounds.getCenterY();
            if (gelement.isHighlighted()) {
                graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
                graphics2d.fillOval((int)(cx - (float)radius), (int)(cy - (float)radius), radius * 2, radius * 2);
                graphics2d.setColor(originalcolor);
            } else {
                graphics2d.fillOval((int)(cx - (float)radius), (int)(cy - (float)radius), radius * 2, radius * 2);
            }
            ++i;
        }
    }

    public void drawLoupeSymbol(Graphics2D graphics2d, AffineTransform transform) {
        int radius = (int)(20.0 * transform.getScaleX());
        if (radius < 1) {
            radius = 1;
        }
        Vector[] allatoms = new Vector[]{this.containeratoms, this.atoms};
        Color originalcolor = graphics2d.getColor();
        int a = 0;
        while (a < allatoms.length) {
            int i = 0;
            while (i < allatoms[a].size()) {
                GElement gelement = (GElement)allatoms[a].elementAt(i);
                if (a != 1 || ((GAtom)gelement).getCurrentView() != 1) {
                    Rectangle2D.Double bounds = gelement.getBounds();
                    Point2D.Double p = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    transform.transform(p, p);
                    int cx = (int)p.x;
                    int cy = (int)p.y;
                    if (gelement.isHighlighted()) {
                        graphics2d.setColor(GColor.editAssistFG);
                        graphics2d.fillOval(cx - radius, cy - radius, radius * 2, radius * 2);
                        graphics2d.setColor(originalcolor);
                    } else {
                        graphics2d.fillOval(cx - radius, cy - radius, radius * 2, radius * 2);
                    }
                }
                ++i;
            }
            ++a;
        }
    }

    public void dump(PrintStream printstream) {
        String string;
        printstream.println("[GStructure] start dump------------");
        int catoms = 0;
        while (catoms < this.atoms.size()) {
            GGroup ggroup;
            GElement gelement = (GElement)this.atoms.elementAt(catoms);
            String string2 = "atoms(" + catoms + ") name=" + gelement.getName();
            GContainer gcontainer = ((GContainerTarget)((Object)gelement)).getContainer();
            if (gcontainer != null) {
                string2 = String.valueOf(string2) + " parentContainer=" + ((GElement)((Object)gcontainer)).getName();
            }
            if ((ggroup = this.getParentGroup(gelement)) != null) {
                string2 = String.valueOf(string2) + " parentGroup=" + ggroup.getName();
            }
            printstream.println(string2);
            ++catoms;
        }
        printstream.println("atoms size = " + catoms);
        int ccontainers = 0;
        while (ccontainers < this.containers.size()) {
            GElement element = (GElement)this.containers.elementAt(ccontainers);
            String string3 = "containers(" + ccontainers + ") name=" + element.getName();
            GContainer parentcontainer = ((GContainerTarget)((Object)element)).getContainer();
            if (parentcontainer != null) {
                string3 = String.valueOf(string3) + " parentContainer=" + ((GElement)((Object)parentcontainer)).getName();
            }
            GContainer elemAsContainer = (GContainer)((Object)element);
            Vector targets = elemAsContainer.getTargets();
            int targetSize = targets.size();
            string3 = String.valueOf(string3) + " targetSize=" + targetSize + " target=";
            int i = 0;
            while (i < targets.size()) {
                GElement target = (GElement)targets.elementAt(i);
                string3 = String.valueOf(string3) + " " + target.getName();
                ++i;
            }
            printstream.println(string3);
            ++ccontainers;
        }
        printstream.println("containers size = " + ccontainers);
        int clinks = 0;
        while (clinks < this.links.size()) {
            GLink glink = (GLink)this.links.elementAt(clinks);
            int targetSize = glink.targetSize();
            string = "links(" + clinks + ") name=" + glink.getName() + " targetSize=" + targetSize + " target=";
            int i = 0;
            while (i < targetSize) {
                try {
                    GElement gelement = (GElement)((Object)glink.getTargetAt(i));
                    string = String.valueOf(string) + " " + gelement.getName();
                }
                catch (Exception exception) {
                    string = String.valueOf(string) + " " + exception.getMessage();
                }
                ++i;
            }
            printstream.println(string);
            ++clinks;
        }
        printstream.println("links size = " + clinks);
        int cgroup = 0;
        while (cgroup < this.groups.size()) {
            GElement element = (GElement)this.groups.elementAt(cgroup);
            string = "groups(" + cgroup + ") name=" + element.getName();
            GGroup elemAsGroup = (GGroup)element;
            Vector groupMember = elemAsGroup.getMembers();
            int membersize = groupMember.size();
            string = String.valueOf(string) + " membersSize=" + membersize + " member=";
            int i = 0;
            while (i < groupMember.size()) {
                GElement memeber = (GElement)groupMember.elementAt(i);
                string = String.valueOf(string) + " " + memeber.getName();
                ++i;
            }
            printstream.println(string);
            ++cgroup;
        }
        printstream.println("groups size = " + cgroup);
        printstream.println("[GStructure] end dump------------");
    }

    public Vector getAtoms() {
        return this.atoms;
    }

    public Vector getContainableAtoms() {
        return this.containeratoms;
    }

    public Vector getContainers() {
        return this.containers;
    }

    protected GElement getElement(double x, double y) {
        return this.getEventAvailableNeastNodeFrom(this.getElement(x, y, null));
    }

    private GLinkPositionInfo getPointedLinkableGAtom(double x, double y, Vector ignoreElementVec, GLink creatingGLink, int linkedCnt) {
        GLinkedShape shape = null;
        if (creatingGLink != null) {
            shape = creatingGLink.getGLinkedShape();
        }
        Vector[] allatoms = new Vector[]{this.atoms, this.containeratoms};
        int j = 0;
        while (j < allatoms.length) {
            Vector oneatoms = allatoms[j];
            int i = oneatoms.size() - 1;
            while (i >= 0) {
                block8: {
                    SpeciesAlias alias;
                    GElement ge = (GElement)oneatoms.elementAt(i);
                    if (!(!(ge instanceof GLinkTarget) || ignoreElementVec.contains(ge) || !creatingGLink.isLinkable((GLinkTarget)((Object)ge), linkedCnt) || ge instanceof GBasicAtom && ((GBasicAtom)ge).getCurrentView() == 1 || shape != null && ge instanceof SpeciesAlias && !creatingGLink.isLinkOf(alias = (SpeciesAlias)ge) && GMouseInterpreter.aliasCanNotBeUsedByReaction(shape, alias))) {
                        GLinkPositionInfo lpi;
                        block7: {
                            try {
                                SpeciesSymbol sbm;
                                ElementSpeciesAlias selected;
                                GFramedShape gfshp;
                                if (!(ge instanceof ElementSpeciesAlias) || !((gfshp = (selected = (ElementSpeciesAlias)ge).getGFramedShape()) instanceof MonoSpeciesShape) || !((sbm = ((MonoSpeciesShape)gfshp).getSpeciesSymbol()) instanceof Tag)) break block7;
                                break block8;
                            }
                            catch (Exception selected) {
                                // empty catch block
                            }
                        }
                        if ((lpi = ((GLinkTarget)((Object)ge)).getPointedLinkPosition(x, y)) != null) {
                            lpi.setElement(ge);
                            return lpi;
                        }
                    }
                }
                --i;
            }
            ++j;
        }
        return null;
    }

    private GLinkPositionInfo getPointedLinkableGLink(double x, double y, Vector ignoreElementVec, GLink creatingGLink, int linkedCnt) {
        GElement gelement = null;
        GLinkPositionInfo lpi = null;
        int count = 0;
        int i = this.links.size() - 1;
        while (i >= 0) {
            block7: {
                GElement ge = (GElement)this.links.elementAt(i);
                if (ge instanceof GLinkTarget && !ignoreElementVec.contains(ge)) {
                    GLinkPositionInfo lpi1;
                    block6: {
                        try {
                            if (ge.getBounds().contains(x, y)) break block6;
                            break block7;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (creatingGLink.isLinkable((GLinkTarget)((Object)ge), linkedCnt) && (lpi1 = ((GLinkTarget)((Object)ge)).getPointedLinkPosition(x, y)) != null) {
                        gelement = ge;
                        if (count++ != 0 && !(lpi1.getDistanceSq() < lpi.getDistanceSq())) break;
                        lpi = lpi1;
                        lpi.setElement(gelement);
                        break;
                    }
                }
            }
            --i;
        }
        if (lpi != null) {
            return lpi;
        }
        return null;
    }

    protected GLinkPositionInfo getPointedLinkableElement(double x, double y, Vector ignoreElementVec, GLink creatingGLink, int linkedCnt) {
        GLinkPositionInfo lpi;
        if (ignoreElementVec == null) {
            ignoreElementVec = new Vector(0);
        }
        if ((lpi = this.getPointedLinkableGLink(x, y, ignoreElementVec, creatingGLink, linkedCnt)) != null) {
            return lpi;
        }
        lpi = this.getPointedLinkableGAtom(x, y, ignoreElementVec, creatingGLink, linkedCnt);
        if (lpi != null) {
            return lpi;
        }
        return null;
    }

    protected GElement getElement(double x, double y, Vector skipElements) {
        GElement temp;
        GElement gelement = null;
        int i = 0;
        while (i < this.selectedVector.size()) {
            GResizeHandle gresizehandle;
            GEditPoint geditpoint;
            GLinkedShape linkedShape;
            GElement selected = (GElement)this.selectedVector.elementAt(i);
            if (selected instanceof GLink && (linkedShape = ((GLink)selected).getGLinkedShape()) instanceof GEditable && (geditpoint = ((GEditable)((Object)linkedShape)).getEditPoint(x, y)) != null) {
                gelement = geditpoint;
                break;
            }
            if (selected instanceof GResizable && (gresizehandle = ((GResizable)((Object)selected)).getHandle(x, y)) != null) {
                gelement = gresizehandle;
                break;
            }
            ++i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.links.size() - 1;
        while (i >= 0) {
            GElement link = (GElement)this.links.elementAt(i);
            boolean skip = false;
            if (skipElements != null) {
                int j = 0;
                while (j < skipElements.size()) {
                    temp = (GElement)skipElements.elementAt(j);
                    if (link == temp) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skip && gelement == null && link.inShape(x, y)) {
                GEditPoint geditpoint;
                gelement = link;
                GGroup ggroup = this.getSurroundingGroup((GLink)gelement);
                if (ggroup != null) {
                    gelement = ggroup;
                    break;
                }
                GLinkedShape glinkedshape = ((GLink)link).getGLinkedShape();
                if (!(glinkedshape instanceof GEditable) || (geditpoint = ((GEditable)((Object)glinkedshape)).getEditPoint(x, y)) == null) break;
                gelement = geditpoint;
                break;
            }
            --i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.atoms.size() - 1;
        while (i >= 0) {
            GElement atom = (GElement)this.atoms.elementAt(i);
            if (((GAtom)atom).getCurrentView() != 1) {
                boolean skip = false;
                if (skipElements != null) {
                    int j = 0;
                    while (j < skipElements.size()) {
                        temp = (GElement)skipElements.elementAt(j);
                        if (atom == temp) {
                            skip = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!skip && gelement == null && atom.inShape(x, y)) {
                    gelement = atom;
                    GGroup ggroup = null;
                    ggroup = ((GBasicAtom)atom).getContainer() instanceof GContainableAtom ? this.getParentGroup((GContainableAtom)((GBasicAtom)atom).getContainer()) : this.getParentGroup(atom);
                    if (ggroup == null || !this.groups.contains(ggroup)) break;
                    gelement = ggroup;
                    break;
                }
            }
            --i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.containeratoms.size() - 1;
        while (i >= 0) {
            GElement containeratom = (GElement)this.containeratoms.elementAt(i);
            boolean skip = false;
            if (skipElements != null) {
                int j = 0;
                while (j < skipElements.size()) {
                    temp = (GElement)skipElements.elementAt(j);
                    if (containeratom == temp) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skip && gelement == null && containeratom.inShape(x, y)) {
                GContainer container;
                gelement = containeratom;
                if (gelement instanceof ComplexSpeciesAlias && (container = ((ComplexSpeciesAlias)gelement).getContainer()) != null && container instanceof ComplexSpeciesAlias && (((ComplexSpeciesAlias)container).getCurrentView() == 1 || ((ComplexSpeciesAlias)container).getCurrentView() == 3)) {
                    gelement = null;
                } else {
                    GGroup ggroup = this.getParentGroup(containeratom);
                    if (ggroup == null || !this.groups.contains(ggroup)) break;
                    gelement = ggroup;
                    break;
                }
            }
            --i;
        }
        if (gelement != null) {
            return gelement;
        }
        i = this.containers.size() - 1;
        while (i >= 0) {
            GElement container = (GElement)this.containers.elementAt(i);
            boolean skip = false;
            if (skipElements != null) {
                int j = 0;
                while (j < skipElements.size()) {
                    temp = (GElement)skipElements.elementAt(j);
                    if (container == temp) {
                        skip = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skip && container.onEdge(x, y)) {
                if (gelement == null) {
                    gelement = container;
                } else if (((GContainer)((Object)gelement)).includes((GContainerTarget)((Object)container)) > 0) {
                    gelement = container;
                }
            }
            --i;
        }
        i = this.layers.size() - 1;
        while (i >= 0) {
            LayerManager m = (LayerManager)this.layers.get(i);
            if (!m.isLock() && m.isVisible()) {
                ArrayList listOfTexts = m.getListOfTexts();
                int k = 0;
                while (k < listOfTexts.size()) {
                    GElement atom = (GElement)listOfTexts.get(k);
                    boolean skip = false;
                    if (skipElements != null) {
                        int j = 0;
                        while (j < skipElements.size()) {
                            GElement temp2 = (GElement)skipElements.elementAt(j);
                            if (atom == temp2) {
                                skip = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!skip && gelement == null && atom.inShape(x, y)) {
                        gelement = atom;
                        GGroup ggroup = null;
                        ggroup = ((GBasicAtom)atom).getContainer() instanceof GContainableAtom ? this.getParentGroup((GContainableAtom)((GBasicAtom)atom).getContainer()) : this.getParentGroup(atom);
                        if (ggroup == null || !this.groups.contains(ggroup)) break;
                        gelement = ggroup;
                        break;
                    }
                    ++k;
                }
                ArrayList listOfSquares = m.getListOfSquares();
                int k2 = 0;
                while (k2 < listOfSquares.size()) {
                    GElement container = (GElement)listOfSquares.get(k2);
                    boolean skip = false;
                    if (skipElements != null) {
                        int j = 0;
                        while (j < skipElements.size()) {
                            GElement temp3 = (GElement)skipElements.elementAt(j);
                            if (container == temp3) {
                                skip = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!skip && container.onEdge(x, y) && gelement == null) {
                        gelement = container;
                    }
                    ++k2;
                }
                ArrayList listOfFreeLines = m.getListOfFreeLines();
                int k3 = 0;
                while (k3 < listOfFreeLines.size()) {
                    GElement link = (GElement)listOfFreeLines.get(k3);
                    boolean skip = false;
                    if (skipElements != null) {
                        int j = 0;
                        while (j < skipElements.size()) {
                            GElement temp4 = (GElement)skipElements.elementAt(j);
                            if (link == temp4) {
                                skip = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!skip && gelement == null && link.inShape(x, y)) {
                        GEditPoint geditpoint;
                        gelement = link;
                        GGroup ggroup = this.getSurroundingGroup((GLink)gelement);
                        if (ggroup != null) {
                            gelement = ggroup;
                            break;
                        }
                        GLinkedShape glinkedshape = ((GLink)link).getGLinkedShape();
                        if (!(glinkedshape instanceof GEditable) || (geditpoint = ((GEditable)((Object)glinkedshape)).getEditPoint(x, y)) == null) break;
                        gelement = geditpoint;
                        break;
                    }
                    ++k3;
                }
            }
            --i;
        }
        return gelement;
    }

    protected Vector getElements(Rectangle2D.Double selectArea, List skips) {
        GElement skipelement;
        int j;
        boolean skipflag;
        GElement gelement;
        Vector<GElement> overwraps = new Vector<GElement>();
        int i = this.links.size() - 1;
        while (i >= 0) {
            gelement = (GElement)this.links.elementAt(i);
            if (((GLink)gelement).getGLinkedShape() != null && ((GLink)gelement).getGLinkedShape() instanceof GLogicGate && selectArea.contains(((GLogicGate)((GLink)gelement).getGLinkedShape()).getHeaderPoint().getPosition())) {
                this.selectedVector.remove(((GLogicGate)((GLink)gelement).getGLinkedShape()).getHeaderPoint());
                this.selectedVector.add(((GLogicGate)((GLink)gelement).getGLinkedShape()).getHeaderPoint());
            }
            skipflag = false;
            if (skips != null && !skips.isEmpty()) {
                j = 0;
                while (j < skips.size()) {
                    skipelement = (GElement)skips.get(j);
                    if (gelement == skipelement) {
                        skipflag = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skipflag && gelement.intersects(selectArea)) {
                overwraps.add(gelement);
            }
            --i;
        }
        i = this.atoms.size() - 1;
        while (i >= 0) {
            gelement = (GElement)this.atoms.elementAt(i);
            skipflag = false;
            if (skips != null && !skips.isEmpty()) {
                j = 0;
                while (j < skips.size()) {
                    skipelement = (GElement)skips.get(j);
                    if (gelement == skipelement) {
                        skipflag = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skipflag && gelement.intersects(selectArea)) {
                GGroup group;
                boolean inGroup = false;
                if (gelement instanceof GGroupTarget && (group = this.getParentGroup(gelement)) != null && this.groups.contains(group)) {
                    inGroup = true;
                    if (!overwraps.contains(group) && !skips.contains(group)) {
                        overwraps.add(group);
                    }
                }
                if (!inGroup) {
                    overwraps.add(gelement);
                }
            }
            --i;
        }
        i = this.containeratoms.size() - 1;
        while (i >= 0) {
            GElement ge;
            gelement = (GElement)this.containeratoms.elementAt(i);
            gelement = ge = this.getEventAvailableNeastNodeFrom(gelement);
            boolean skipflag2 = false;
            if (skips != null && !skips.isEmpty()) {
                int j2 = 0;
                while (j2 < skips.size()) {
                    GElement skipelement2 = (GElement)skips.get(j2);
                    if (gelement == skipelement2) {
                        skipflag2 = true;
                        break;
                    }
                    ++j2;
                }
            }
            if (!skipflag2 && gelement.intersects(selectArea)) {
                GGroup group;
                boolean inGroup = false;
                if (gelement instanceof GGroupTarget && (group = this.getParentGroup(gelement)) != null && this.groups.contains(group)) {
                    inGroup = true;
                    if (!overwraps.contains(group) && !skips.contains(group)) {
                        overwraps.add(group);
                    }
                }
                if (!inGroup) {
                    overwraps.add(gelement);
                }
            }
            --i;
        }
        i = this.containers.size() - 1;
        while (i >= 0) {
            gelement = (GElement)this.containers.elementAt(i);
            boolean skipflag3 = false;
            if (skips != null && !skips.isEmpty()) {
                j = 0;
                while (j < skips.size()) {
                    GElement skipelement3 = (GElement)skips.get(j);
                    if (gelement == skipelement3) {
                        skipflag3 = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!skipflag3 && gelement.intersects(selectArea)) {
                overwraps.add(gelement);
            }
            --i;
        }
        i = this.layers.size() - 1;
        while (i >= 0) {
            LayerManager m = (LayerManager)this.layers.get(i);
            if (!m.isLock() && m.isVisible()) {
                ArrayList listOfTexts = m.getListOfTexts();
                int k = 0;
                while (k < listOfTexts.size()) {
                    GElement atom = (GElement)listOfTexts.get(k);
                    boolean skip = false;
                    if (skips != null) {
                        int j3 = 0;
                        while (j3 < skips.size()) {
                            GElement temp = (GElement)skips.get(j3);
                            if (atom == temp) {
                                skip = true;
                                break;
                            }
                            ++j3;
                        }
                    }
                    if (!skip && atom.intersects(selectArea)) {
                        overwraps.add(atom);
                    }
                    ++k;
                }
                ArrayList listOfSquares = m.getListOfSquares();
                int k2 = 0;
                while (k2 < listOfSquares.size()) {
                    GElement container = (GElement)listOfSquares.get(k2);
                    boolean skip = false;
                    if (skips != null) {
                        int j4 = 0;
                        while (j4 < skips.size()) {
                            GElement temp = (GElement)skips.get(j4);
                            if (container == temp) {
                                skip = true;
                                break;
                            }
                            ++j4;
                        }
                    }
                    if (!skip && container.intersects(selectArea)) {
                        overwraps.add(container);
                    }
                    ++k2;
                }
                ArrayList listOfFreeLines = m.getListOfFreeLines();
                int k3 = 0;
                while (k3 < listOfFreeLines.size()) {
                    GElement link = (GElement)listOfFreeLines.get(k3);
                    boolean skip = false;
                    if (skips != null) {
                        int j5 = 0;
                        while (j5 < skips.size()) {
                            GElement temp = (GElement)skips.get(j5);
                            if (link == temp) {
                                skip = true;
                                break;
                            }
                            ++j5;
                        }
                    }
                    if (!skip && link.intersects(selectArea)) {
                        GLinkedShape glinkedshape = ((GLink)link).getGLinkedShape();
                        GLinkedCreaseLine line = (GLinkedCreaseLine)glinkedshape;
                        if (!(glinkedshape instanceof LayerTagFreeLineSymbol)) {
                            line.starttemp = (Point2D.Double)line.lines[0].start.clone();
                            line.endtemp = (Point2D.Double)line.lines[0].end.clone();
                            overwraps.add(link);
                        }
                    }
                    ++k3;
                }
            }
            --i;
        }
        return overwraps;
    }

    public Vector getGroups() {
        return this.groups;
    }

    public Vector getInsides(GContainer container) {
        GContainerTarget target;
        if (container instanceof ComplexSpeciesAlias && (((GAtom)((Object)container)).getCurrentView() == 1 || ((GAtom)((Object)container)).getCurrentView() == 3)) {
            return container.getTargets();
        }
        Vector<GContainerTarget> contained = new Vector<GContainerTarget>();
        int i = 0;
        while (i < this.containers.size()) {
            target = (GContainerTarget)this.containers.elementAt(i);
            if (container != target && container.includes(target) != 0) {
                contained.add(target);
            }
            ++i;
        }
        i = 0;
        while (i < this.containeratoms.size()) {
            target = (GContainerTarget)this.containeratoms.elementAt(i);
            if (container != target && container.includes(target) != 0) {
                contained.add(target);
            }
            ++i;
        }
        i = 0;
        while (i < this.atoms.size()) {
            target = (GContainerTarget)this.atoms.elementAt(i);
            if (container.includes(target) != 0) {
                contained.add(target);
            }
            ++i;
        }
        return contained;
    }

    public Vector getLinks() {
        return this.links;
    }

    public void ResetSortedLinks() {
        this.sortLinks();
    }

    protected static Vector getLowerTargets(GContainer gcontainer) {
        Vector<GElement> lowers = new Vector<GElement>();
        Vector targets = gcontainer.getTargets();
        int i = 0;
        while (i < targets.size()) {
            GElement gelement = (GElement)targets.get(i);
            lowers.add(gelement);
            if (gelement instanceof GContainer) {
                lowers.addAll(GStructure.getLowerTargets((GContainer)((Object)gelement)));
            }
            ++i;
        }
        return lowers;
    }

    public Rectangle2D.Double getMaxDrawSize() {
        return this.maxArea;
    }

    public GContainer getOutside(GContainerTarget gcontainertarget) {
        int i;
        GContainer gcontainer = null;
        if (gcontainertarget instanceof ComplexSpeciesAlias) {
            gcontainer = this.getOutsideForComplex((ComplexSpeciesAlias)gcontainertarget);
        }
        if (gcontainer != null) {
            return gcontainer;
        }
        if (gcontainertarget instanceof GBasicAtom) {
            i = this.containeratoms.size() - 1;
            while (i >= 0) {
                GContainer containeratom = (GContainer)this.containeratoms.elementAt(i);
                if ((!(containeratom instanceof ComplexSpeciesAlias) || ((GAtom)((Object)containeratom)).getCurrentView() != 1 && ((GAtom)((Object)containeratom)).getCurrentView() != 3) && containeratom != gcontainertarget && containeratom.includes(gcontainertarget) != 0) {
                    if (gcontainer == null) {
                        gcontainer = containeratom;
                    } else if (gcontainer.includes((GContainerTarget)((Object)containeratom)) != 0) {
                        gcontainer = containeratom;
                    }
                }
                --i;
            }
            if (gcontainer != null) {
                return gcontainer;
            }
        }
        i = this.containers.size() - 1;
        while (i >= 0) {
            GContainer container = (GContainer)this.containers.elementAt(i);
            if (container != gcontainertarget && container.includes(gcontainertarget) != 0) {
                if (gcontainer == null) {
                    gcontainer = container;
                } else if (gcontainer.includes((GContainerTarget)((Object)container)) != 0) {
                    gcontainer = container;
                }
            }
            --i;
        }
        return gcontainer;
    }

    private GContainer getOutsideForComplex(ComplexSpeciesAlias containertarget) {
        Vector<GContainer> containers = new Vector<GContainer>();
        int i = 0;
        while (i < this.containeratoms.size()) {
            GContainer containeratom = (GContainer)this.containeratoms.elementAt(i);
            if (!(containeratom.equals(containertarget) || containeratom.includes(containertarget) == 0 || containeratom instanceof ComplexSpeciesAlias && this.checkComplexInComplex(containertarget, (ComplexSpeciesAlias)containeratom))) {
                containers.add(containeratom);
            }
            ++i;
        }
        if (containers.size() == 0) {
            return null;
        }
        GContainer minContainer = (GContainer)containers.elementAt(0);
        int i2 = 1;
        while (i2 < containers.size()) {
            if (containers.elementAt(i2) instanceof GContainerTarget && minContainer.includes((GContainerTarget)containers.elementAt(i2)) != 0) {
                minContainer = (GContainer)containers.elementAt(i2);
            }
            ++i2;
        }
        if (minContainer != null) {
            return minContainer;
        }
        return null;
    }

    private boolean checkComplexInComplex(ComplexSpeciesAlias container, ComplexSpeciesAlias containerTarget) {
        Vector targets = container.getTargets();
        if (targets.contains(containerTarget)) {
            return true;
        }
        int i = 0;
        while (i < targets.size()) {
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias && this.checkComplexInComplex((ComplexSpeciesAlias)targets.elementAt(i), containerTarget)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GLink getOwnerLink(GEditPoint geditpoint) {
        if (geditpoint == null) {
            return null;
        }
        GEditable geditable = geditpoint.getOwner();
        int i = 0;
        while (i < this.links.size()) {
            GLink glink = (GLink)this.links.elementAt(i);
            GLinkedShape glinkedshape = glink.getGLinkedShape();
            if (glinkedshape == geditable) {
                return glink;
            }
            if (glinkedshape instanceof GLinkedLineComplex3) {
                GLinkedLine[] lines = ((GLinkedLineComplex3)glinkedshape).getLines();
                int j = 0;
                while (j < lines.length) {
                    if (lines[j] == geditable) {
                        return glink;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.layers.size()) {
            LayerManager m = (LayerManager)this.layers.get(i);
            ArrayList listOfLines = m.getListOfFreeLines();
            int k = 0;
            while (k < listOfLines.size()) {
                GLink glink = (GLink)listOfLines.get(k);
                GLinkedShape glinkedshape = glink.getGLinkedShape();
                if (glinkedshape == geditable) {
                    return glink;
                }
                if (glinkedshape instanceof GLinkedLineComplex3) {
                    GLinkedLine[] lines = ((GLinkedLineComplex3)glinkedshape).getLines();
                    int j = 0;
                    while (j < lines.length) {
                        if (lines[j] == geditable) {
                            return glink;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
        return null;
    }

    public GLink getOwnerLink(GLinkedShape shape) {
        int i = 0;
        while (i < this.links.size()) {
            GLink link = (GLink)this.links.get(i);
            GLinkedShape shape2 = link.getGLinkedShape();
            if (shape.equals(shape2)) {
                return link;
            }
            if (shape2 instanceof GLinkedLineComplex3) {
                GLinkedLine[] lines = ((GLinkedLineComplex3)shape2).getLines();
                int j = 0;
                while (j < lines.length) {
                    if (shape.equals(lines[j])) {
                        return link;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public GGroup getParentGroup(GElement gelement) {
        if (!(gelement instanceof GGroupTarget)) {
            return null;
        }
        GGroup ggroup = null;
        int i = 0;
        while (i < this.groups.size()) {
            GGroup group = (GGroup)this.groups.elementAt(i);
            Vector vector = group.getMembers();
            if (vector.contains(gelement)) {
                ggroup = group;
                break;
            }
            ++i;
        }
        return ggroup;
    }

    public static Point2D.Double getPosition(GElement gelement) {
        if (gelement instanceof GFramed) {
            return (Point2D.Double)((GFramed)((Object)gelement)).getFramePosition().clone();
        }
        if (gelement instanceof GPointed) {
            return (Point2D.Double)((GPointed)((Object)gelement)).getPoint().clone();
        }
        if (gelement instanceof GLink) {
            return (Point2D.Double)((GLink)gelement).getRepresentPosition(isTemp).clone();
        }
        if (gelement instanceof GEditPoint) {
            return (Point2D.Double)((GEditPoint)gelement).getPosition().clone();
        }
        return null;
    }

    public Vector getSelecteds() {
        return this.selectedVector;
    }

    private GGroup getSurroundingGroup(GLink glink) {
        GGroup ggroup = null;
        int i = 0;
        while (i < glink.targetSize()) {
            GGroup group;
            block9: {
                GLinkTarget glinktarget;
                block8: {
                    glinktarget = glink.getTargetAt(i);
                    if (glinktarget instanceof GGroupTarget) break block8;
                    return null;
                }
                group = this.getParentGroup((GElement)((Object)glinktarget));
                if (group != null) break block9;
                return null;
            }
            try {
                if (ggroup == null) {
                    ggroup = group;
                } else if (ggroup != group) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return ggroup;
    }

    private GLink getTargetLink(GLink glink) {
        Object object = null;
        int i = 0;
        while (i < glink.targetSize()) {
            try {
                GLinkTarget glinktarget = glink.getTargetAt(i);
                if (glinktarget instanceof GLink) {
                    return (GLink)glinktarget;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public String groupNametag() {
        return this.groupTag;
    }

    protected Rectangle2D showLinkAnchors(GLinkTarget target, GLinkPositionInfo lpi, boolean drawOnlyActive) {
        return this.showLinkAnchors(target, lpi, drawOnlyActive, true);
    }

    protected Rectangle2D showLinkAnchors(GLinkTarget target, GLinkPositionInfo lpi, boolean drawOnlyActive, boolean repaint) {
        target.showLinkAnchors(lpi, drawOnlyActive);
        Rectangle2D.Double redrawArea = ((GElement)((Object)target)).getRepaintBounds();
        if (repaint) {
            this.notifyRepaint(redrawArea);
        }
        return redrawArea;
    }

    protected Rectangle2D hideLinkAnchors(GLinkTarget target) {
        return this.hideLinkAnchors(target, true);
    }

    protected Rectangle2D hideLinkAnchors(GLinkTarget target, boolean repaint) {
        target.hideLinkAnchors();
        Rectangle2D.Double redrawArea = ((GElement)((Object)target)).getRepaintBounds();
        if (repaint) {
            this.notifyRepaint(redrawArea);
        }
        return redrawArea;
    }

    protected Rectangle2D highlightModification(ModificationShape mShape, boolean highlight, boolean repaint) {
        mShape.setSoloHighlighted(highlight);
        Rectangle2D.Double redrawArea = mShape.getCircleBounds();
        if (repaint) {
            this.notifyRepaint(redrawArea);
        }
        return redrawArea;
    }

    protected Rectangle2D highlightAsTarget(GElement gelement) {
        return this.highlightAsTarget(gelement, true);
    }

    protected Rectangle2D highlightAsTarget(GElement gelement, boolean flag) {
        return this.highlightAsTarget(gelement, flag, true);
    }

    protected Rectangle2D highlightAsTarget(GElement element, boolean highlight, boolean repaint) {
        element.setHighlighted(highlight);
        Rectangle2D.Double redrawArea = element.getRepaintBounds();
        if (repaint) {
            this.notifyRepaint(redrawArea);
        }
        return redrawArea;
    }

    private Rectangle2D highlightChainedLinks(GElement gelement) {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.links.size()) {
            GLink glink = (GLink)this.links.get(i);
            if (glink != gelement) {
                boolean highlight = glink.isHighlighted();
                boolean highlightLinkTarget = false;
                if (this.selectedVector.contains(glink)) {
                    highlightLinkTarget = true;
                } else {
                    GLinkTarget[] targets = glink.getTargets();
                    int j = 0;
                    while (j < targets.length) {
                        GContainer containable;
                        GElement linkTarget = (GElement)((Object)targets[j]);
                        if (linkTarget.isHighlighted()) {
                            highlightLinkTarget = true;
                            break;
                        }
                        if (linkTarget instanceof GBasicAtom && (containable = ((GBasicAtom)linkTarget).getContainer()) instanceof GContainableAtom && ((GElement)((Object)containable)).isHighlighted()) {
                            highlightLinkTarget = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (highlightLinkTarget != highlight) {
                    glink.setHighlighted(highlightLinkTarget);
                    redrawArea = GUtil.union(redrawArea, glink.getRepaintBounds());
                }
            }
            ++i;
        }
        return redrawArea;
    }

    public Rectangle2D highlightChainedLinks() {
        Rectangle2D.Double rect = null;
        int i = 0;
        while (i < this.links.size()) {
            GLink link = (GLink)this.links.get(i);
            GLinkTarget[] targets = link.getTargets();
            boolean highlight = link.isHighlighted();
            boolean highlightLinkTarget = false;
            int j = 0;
            while (j < targets.length) {
                GContainer containable;
                GElement element = (GElement)((Object)targets[j]);
                if (element.isHighlighted()) {
                    highlightLinkTarget = true;
                    break;
                }
                if (element instanceof GBasicAtom && (containable = ((GBasicAtom)element).getContainer()) instanceof GContainableAtom && ((GElement)((Object)containable)).isHighlighted()) {
                    highlightLinkTarget = true;
                    break;
                }
                ++j;
            }
            if (highlightLinkTarget != highlight) {
                link.setHighlighted(highlightLinkTarget);
                rect = GUtil.union(rect, link.getRepaintBounds());
            }
            ++i;
        }
        try {
            i = 0;
            while (i < this.layers.size()) {
                LayerManager layer = (LayerManager)this.layers.get(i);
                if (layer.getId() == -99) {
                    ArrayList layerTagFreeLines = layer.getListOfFreeLines();
                    int j = 0;
                    while (j < layerTagFreeLines.size()) {
                        LayerReactionLink layerLink = (LayerReactionLink)layerTagFreeLines.get(j);
                        boolean highlight = layerLink.isHighlighted();
                        boolean highlightLinkTarget = false;
                        GLinkTarget linkSource = layerLink.getTargetAt(0);
                        GLinkTarget linkTarget = layerLink.getTargetAt(1);
                        if (linkSource instanceof LayerSpeciesAlias && (linkTarget instanceof ElementSpeciesAlias || linkTarget instanceof ComplexSpeciesAlias)) {
                            if (linkTarget instanceof ElementSpeciesAlias) {
                                if (((LayerSpeciesAlias)linkSource).isHighlighted && ((ElementSpeciesAlias)linkTarget).isHighlighted) {
                                    highlightLinkTarget = true;
                                }
                            } else if (linkTarget instanceof ComplexSpeciesAlias && ((LayerSpeciesAlias)linkSource).isHighlighted && ((ComplexSpeciesAlias)linkTarget).isHighlighted) {
                                highlightLinkTarget = true;
                            }
                        }
                        if (highlightLinkTarget != highlight) {
                            layerLink.setHighlighted(highlightLinkTarget);
                            rect = GUtil.union(rect, layerLink.getRepaintBounds());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    private Rectangle2D highlightContainerTargets(GContainer gcontainer, boolean highlight) {
        Vector vector = GStructure.getLowerTargets(gcontainer);
        return this.highlightContainerTargets(vector, highlight);
    }

    private Rectangle2D highlightContainerTargets(List targetList, boolean highlight) {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < targetList.size()) {
            GContainerTarget containertarget = (GContainerTarget)targetList.get(i);
            containertarget.setHighlightedAsTarget(highlight);
            Rectangle2D.Double containerBounds = ((GElement)((Object)containertarget)).getRepaintBounds();
            redrawArea = GUtil.union(redrawArea, containerBounds);
            ++i;
        }
        return redrawArea;
    }

    private boolean isAbleToAdd(GLink glink) {
        if (GLogicGate.isModification(glink.getGLinkedShape()) || glink.getGLinkedShape() instanceof GLogicGate) {
            return true;
        }
        int i = 0;
        while (i < glink.targetSize()) {
            try {
                GElement gelement = (GElement)((Object)glink.getTargetAt(i));
                if (!this.contains(gelement)) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isClossLineON() {
        return this.isClossLineON;
    }

    private boolean isLowerChainedLink(GLinkTarget glinktarget, GLink glink) {
        if (glink.isLinkOf(glinktarget)) {
            return true;
        }
        boolean lower = false;
        int i = 0;
        while (i < glink.targetSize()) {
            try {
                GLinkTarget templinktarget = glink.getTargetAt(i);
                if (templinktarget == glinktarget) {
                    lower = true;
                    break;
                }
                if (templinktarget instanceof GLink && (lower = this.isLowerChainedLink(glinktarget, (GLink)templinktarget))) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return lower;
    }

    protected boolean isSelected(GElement gelement) {
        return this.selectedVector.contains(gelement);
    }

    public String linkNametag() {
        return this.linkTag;
    }

    public Rectangle2D move(List elements, List positions) {
        return this.move(elements, positions, true);
    }

    public Rectangle2D move(List elements, List positions, boolean repaint) {
        Debug.outputDebugMessage("f", "\tcurrentTimeMillis 111 @ GStructure move(List elements, List positions, boolean repaint): " + System.currentTimeMillis(), 0);
        Rectangle2D.Double redrawArea = null;
        if (elements.size() == positions.size()) {
            boolean updateLinks = moveLinkMode;
            Vector<Object> moveElements = new Vector<Object>();
            Vector<Object> movePositions = new Vector<Object>();
            int size = elements.size();
            int i = 0;
            while (i < size) {
                GElement gelement = (GElement)elements.get(i);
                Point2D.Double temppos = (Point2D.Double)positions.get(i);
                if (gelement instanceof LayerReactionLink) {
                    GLink link = (GLink)gelement;
                    GLinkedCreaseLine shape = (GLinkedCreaseLine)link.getGLinkedShape();
                    Vector listOfPoint = new Vector();
                    Vector<Object> oldPoint = new Vector<Object>();
                    oldPoint.addElement(shape.starttemp.clone());
                    oldPoint.addElement(shape.endtemp.clone());
                    Vector<Object> newPoint = new Vector<Object>();
                    newPoint.addElement(shape.lines[0].start.clone());
                    newPoint.addElement(shape.lines[0].end.clone());
                    listOfPoint.add(oldPoint);
                    listOfPoint.add(newPoint);
                    this.moveLayerLine(gelement, temppos.x, temppos.y, 502, false);
                    shape.starttemp = new Point2D.Double(shape.starttemp.x + temppos.x, shape.starttemp.y + temppos.y);
                    shape.endtemp = new Point2D.Double(shape.endtemp.x + temppos.x, shape.endtemp.y + temppos.y);
                    moveElements.add(gelement);
                    movePositions.add(listOfPoint);
                } else {
                    Object[] objects = this.moveElement(gelement, temppos.x, temppos.y, updateLinks);
                    if (redrawArea != null) {
                        redrawArea = GUtil.union(redrawArea, (Rectangle2D)objects[2]);
                    } else {
                        Rectangle2D r = (Rectangle2D)objects[2];
                        if (r != null) {
                            redrawArea = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                        }
                    }
                    if (objects[0] instanceof Vector) {
                        moveElements.addAll((Vector)objects[0]);
                        movePositions.addAll((Vector)objects[1]);
                    } else {
                        moveElements.add(objects[0]);
                        movePositions.add(objects[1]);
                    }
                }
                ++i;
            }
            if (!updateLinks) {
                redrawArea = GUtil.union(redrawArea, this.updateLinksAfterShapesMoving(elements, repaint));
            }
            long beforePaint = System.currentTimeMillis();
            if (Preference.isDebug) {
                Debug.outputDebugMessage("f", "\tcurrentTimeMillis 222 @ GStructure move(List elements, List positions, boolean repaint): " + System.currentTimeMillis(), 0);
                if (redrawArea != null) {
                    Debug.outputDebugMessage("f", "\tredrawArea.x @ GStructure move(List elements, List positions, boolean repaint): " + ((RectangularShape)redrawArea).getX(), 0);
                    Debug.outputDebugMessage("f", "\tredrawArea.y @ GStructure move(List elements, List positions, boolean repaint): " + ((RectangularShape)redrawArea).getY(), 0);
                    Debug.outputDebugMessage("f", "\tredrawArea.w @ GStructure move(List elements, List positions, boolean repaint): " + ((RectangularShape)redrawArea).getWidth(), 0);
                    Debug.outputDebugMessage("f", "\tredrawArea.h @ GStructure move(List elements, List positions, boolean repaint): " + ((RectangularShape)redrawArea).getHeight(), 0);
                }
            }
            if (repaint) {
                this.notifyRepaint(redrawArea);
            }
            long startTime = System.currentTimeMillis();
            if (Preference.isDebug) {
                long afterePaint = System.currentTimeMillis();
                Debug.outputDebugMessage("f", "\telapsed   @ GStructure repaint . move(List elements, List positions, boolean repaint): " + (afterePaint - beforePaint) + " ms   <<========", 0);
            }
            this.notifyChange(moveElements, 9, movePositions);
            long endTime = System.currentTimeMillis();
            if (Preference.isDebug) {
                long ms = endTime - startTime;
                Debug.outputDebugMessage("f", "\telapsed   @ GStructure move(List elements, List positions, boolean repaint): " + ms + " ms   <<========", 0);
            }
        }
        return redrawArea;
    }

    public void move(GElement gelement, double x, double y) {
        boolean updateLinks = moveLinkMode;
        Object[] objects = this.moveElement(gelement, x, y, updateLinks);
        this.notifyRepaint((Rectangle2D)objects[2]);
        if (objects[0] instanceof Vector) {
            this.notifyChange((Vector)objects[0], 9, (Vector)objects[1]);
        } else {
            this.notifyChange((GElement)objects[0], 8, (Point2D.Double)objects[1]);
        }
    }

    public Rectangle2D moveLayerLine(GElement gelement, double xpos, double ypos, int id, boolean event) {
        Rectangle2D rect1;
        GLink link = (GLink)gelement;
        GLinkedCreaseLine shape = (GLinkedCreaseLine)link.getGLinkedShape();
        try {
            if (gelement instanceof LayerReactionLink && shape.starttemp == null) {
                shape.starttemp = (Point2D.Double)shape.getLine((int)0).starttemp.clone();
                shape.endtemp = (Point2D.Double)shape.getLine((int)0).endtemp.clone();
            }
            rect1 = this.doMoveMain(gelement, shape.starttemp.x + xpos, shape.endtemp.y + ypos, false);
        }
        catch (Exception exception) {
            return null;
        }
        if (id == 502) {
            if (event) {
                shape.lines[0].start = new Point2D.Double(shape.starttemp.x + xpos, shape.starttemp.y + ypos);
                shape.lines[0].end = new Point2D.Double(shape.endtemp.x + xpos, shape.endtemp.y + ypos);
                Vector listOfPoint = new Vector();
                Vector<Object> oldPoint = new Vector<Object>();
                oldPoint.addElement(shape.starttemp.clone());
                oldPoint.addElement(shape.endtemp.clone());
                Vector<Object> newPoint = new Vector<Object>();
                newPoint.addElement(shape.lines[0].start.clone());
                newPoint.addElement(shape.lines[0].end.clone());
                listOfPoint.add(oldPoint);
                listOfPoint.add(newPoint);
                this.moveLayerLineTarget((GLink)gelement, shape.sHandlePoint, shape.lines[0].start.x, shape.lines[0].start.y, 506);
                this.moveLayerLineTarget((GLink)gelement, shape.eHandlePoint, shape.lines[0].end.x, shape.lines[0].end.y, 506);
                this.notifyChange(gelement, 8, listOfPoint);
            } else {
                shape.lines[0].start = new Point2D.Double(shape.starttemp.x + xpos, shape.starttemp.y + ypos);
                shape.lines[0].end = new Point2D.Double(shape.endtemp.x + xpos, shape.endtemp.y + ypos);
                this.moveLayerLineTarget((GLink)gelement, shape.sHandlePoint, shape.lines[0].start.x, shape.lines[0].start.y, 506);
                this.moveLayerLineTarget((GLink)gelement, shape.eHandlePoint, shape.lines[0].end.x, shape.lines[0].end.y, 506);
            }
        } else {
            shape.starttempX = shape.lines[0].start.x;
            shape.starttempY = shape.lines[0].start.y;
            shape.lines[0].start = new Point2D.Double(shape.starttemp.x + xpos, shape.starttemp.y + ypos);
            shape.lines[0].end = new Point2D.Double(shape.endtemp.x + xpos, shape.endtemp.y + ypos);
            shape.sHandlePoint.setPosition(shape.lines[0].start);
            shape.eHandlePoint.setPosition(shape.lines[0].end);
        }
        Rectangle2D.Double rect = null;
        rect = GUtil.union(rect, rect1);
        this.notifyRepaint(rect);
        shape.updateLine();
        shape.sHandlePoint.update();
        shape.eHandlePoint.update();
        return rect;
    }

    public Rectangle2D moveLayerLineForUndoRedo(GElement gelement, Point2D.Double start, Point2D.Double end) {
        GLink link = (GLink)gelement;
        GLinkedCreaseLine shape = (GLinkedCreaseLine)link.getGLinkedShape();
        Rectangle2D rect1 = this.doMoveMain(gelement, start.x - 5.0, end.y + 5.0, false);
        shape.lines[0].start = new Point2D.Double(start.x, start.y);
        shape.lines[0].end = new Point2D.Double(end.x, end.y);
        Vector listOfPoint = new Vector();
        Vector<Object> oldPoint = new Vector<Object>();
        oldPoint.addElement(shape.starttemp.clone());
        oldPoint.addElement(shape.endtemp.clone());
        Vector<Object> newPoint = new Vector<Object>();
        newPoint.addElement(shape.lines[0].start.clone());
        newPoint.addElement(shape.lines[0].end.clone());
        listOfPoint.add(oldPoint);
        listOfPoint.add(newPoint);
        this.notifyChange(gelement, 8, listOfPoint);
        this.moveLayerLineTarget((GLink)gelement, shape.sHandlePoint, shape.lines[0].start.x, shape.lines[0].start.y, 506);
        this.moveLayerLineTarget((GLink)gelement, shape.eHandlePoint, shape.lines[0].end.x, shape.lines[0].end.y, 506);
        Rectangle2D.Double rect = null;
        rect = GUtil.union(rect, rect1);
        this.notifyRepaint(rect);
        shape.sHandlePoint.update();
        shape.eHandlePoint.update();
        return rect;
    }

    public Rectangle2D moveLayerLineTarget(GLink gelement, GLinkHandlePoint handle, double dx, double dy, int id) {
        Rectangle2D rect1 = this.doMoveMain(handle, handle.getPosition().x + dx, handle.getPosition().y + dy, false);
        handle.setPosition(new Point2D.Double(dx, dy));
        GLinkedCreaseLine shape = (GLinkedCreaseLine)gelement.getGLinkedShape();
        Point2D.Double oldPoint = null;
        if (shape.sHandlePoint == handle) {
            shape.lines[0].start = new Point2D.Double(dx, dy);
            oldPoint = (Point2D.Double)shape.starttemp.clone();
        } else if (shape.eHandlePoint == handle) {
            shape.lines[0].end = new Point2D.Double(dx, dy);
            oldPoint = (Point2D.Double)shape.endtemp.clone();
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(shape.lines[0].start.x, shape.lines[0].start.y, shape.lines[0].end.x, shape.lines[0].end.y);
        rect = GUtil.union(rect, rect1);
        this.notifyRepaint(rect);
        if (id == 502) {
            this.notifyChange(handle, 8, oldPoint);
            if (shape.sHandlePoint == handle) {
                shape.starttemp = new Point2D.Double(dx, dy);
            } else if (shape.eHandlePoint == handle) {
                shape.endtemp = new Point2D.Double(dx, dy);
            }
        }
        return rect;
    }

    public Rectangle2D moveLayerLineTarget(GLinkedCreaseLine shape, GLinkHandlePoint handle, double dx, double dy, int id) {
        Rectangle2D rect1 = this.doMoveMain(handle, handle.getPosition().x + dx, handle.getPosition().y + dy, false);
        handle.setPosition(new Point2D.Double(dx, dy));
        if (shape.sHandlePoint == handle) {
            shape.lines[0].start = new Point2D.Double(dx, dy);
        } else if (shape.eHandlePoint == handle) {
            shape.lines[0].end = new Point2D.Double(dx, dy);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(shape.lines[0].start.x, shape.lines[0].start.y, shape.lines[0].end.x, shape.lines[0].end.y);
        rect = GUtil.union(rect, rect1);
        this.notifyRepaint(rect);
        if (id == 502) {
            this.notifyChange(handle, 8, handle.getPosition());
            if (shape.sHandlePoint == handle) {
                shape.starttemp = new Point2D.Double(dx, dy);
            } else if (shape.eHandlePoint == handle) {
                shape.endtemp = new Point2D.Double(dx, dy);
            }
        }
        return rect;
    }

    public Rectangle2D move(GElement element, double x, double y, boolean updateLinks) {
        Object[] objects = this.moveElement(element, x, y, updateLinks);
        if (objects[0] instanceof Vector) {
            this.notifyChange((Vector)objects[0], 9, (Vector)objects[1]);
        } else {
            this.notifyChange((GElement)objects[0], 8, (Point2D)objects[1]);
        }
        return (Rectangle2D)objects[2];
    }

    public Rectangle2D move(GElement element, double x, double y, boolean updateLinks, Vector elementList, Vector pointList) {
        Object[] objects = this.moveElement(element, x, y, updateLinks);
        if (objects[0] instanceof Vector) {
            elementList.addAll((Vector)objects[0]);
            pointList.addAll((Vector)objects[1]);
        } else {
            elementList.add(objects[0]);
            pointList.add(objects[1]);
        }
        return (Rectangle2D)objects[2];
    }

    private Object[] moveElement(GElement element, double x, double y, boolean updateLinks) {
        int i;
        Point2D.Double position = GStructure.getPosition(element);
        boolean movingContainerWithElem = false;
        Vector<GElement> elementVector = null;
        Vector positionVector = null;
        Vector contained = null;
        Vector<Point2D.Double> containedPosition = null;
        if (element instanceof GContainer) {
            elementVector = new Vector<GElement>();
            positionVector = new Vector();
            contained = ((GContainer)((Object)element)).getTargets();
            containedPosition = new Vector<Point2D.Double>();
            int i2 = 0;
            while (i2 < contained.size()) {
                containedPosition.add(GStructure.getPosition((GElement)contained.elementAt(i2)));
                ++i2;
            }
        }
        Rectangle2D redrawArea = null;
        redrawArea = element instanceof LayerReactionLink ? this.moveLayerLine(element, x, y, 502, true) : this.doMoveMain(element, x, y, updateLinks);
        if (GStructure.inContainableState(element)) {
            this.resetContainer((GContainer)((Object)element));
        }
        if (element instanceof GContainerTarget) {
            this.resetContainerOf((GContainerTarget)((Object)element));
        }
        if (element instanceof GGroup) {
            Vector groupmember = ((GGroup)element).getMembers();
            i = 0;
            while (i < groupmember.size()) {
                GElement groupelem = (GElement)groupmember.elementAt(i);
                if (groupelem instanceof GContainerTarget) {
                    this.resetContainerOf((GContainerTarget)((Object)groupelem));
                }
                ++i;
            }
        }
        if (element instanceof GContainer) {
            Vector containerTarget = ((GContainer)((Object)element)).getTargets();
            i = 0;
            while (i < contained.size()) {
                GElement prevContained = (GElement)contained.elementAt(i);
                if (!containerTarget.contains(prevContained)) {
                    elementVector.add(prevContained);
                    positionVector.add(containedPosition.elementAt(i));
                }
                ++i;
            }
            i = 0;
            while (i < containerTarget.size()) {
                GElement containedElem = (GElement)containerTarget.elementAt(i);
                if (!contained.contains(containedElem)) {
                    elementVector.add(containedElem);
                    positionVector.add(GStructure.getPosition(containedElem));
                }
                ++i;
            }
            if (elementVector.size() > 0) {
                movingContainerWithElem = true;
                elementVector.add(element);
                positionVector.add(position);
            }
        }
        if (movingContainerWithElem) {
            return new Object[]{elementVector, positionVector, redrawArea};
        }
        return new Object[]{element, position, redrawArea};
    }

    public boolean isTemp() {
        return isTemp;
    }

    public void setTemp(boolean isTemp) {
        GStructure.isTemp = isTemp;
    }

    public double getTemp_dx() {
        return this.temp_dx;
    }

    public void setTemp_dx(double temp_dx) {
        this.temp_dx = temp_dx;
    }

    public double getTemp_dy() {
        return this.temp_dy;
    }

    public void setTemp_dy(double temp_dy) {
        this.temp_dy = temp_dy;
    }

    protected Rectangle2D.Double moveSelectedElements(GElement element, double x, double y) {
        Point2D.Double pos = GStructure.getPosition(element);
        double dx = x - ((Point2D)pos).getX();
        double dy = y - ((Point2D)pos).getY();
        if (element instanceof LayerReactionLink) {
            this.temp_startx = dx;
            this.temp_starty = dy;
        }
        Rectangle2D.Double rect = null;
        boolean updateLinks = moveLinkMode;
        int i = 0;
        while (i < this.selectedVector.size()) {
            GElement e = (GElement)this.selectedVector.get(i);
            pos = GStructure.getPosition(e);
            Rectangle2D rect1 = null;
            if (e instanceof LayerReactionLink) {
                rect1 = this.moveLayerLine(e, this.temp_dx, this.temp_dy, 506, true);
            } else {
                Debug.outputDebugMessage("f", "currentTimeMillis 111 @ GStructure protected Rectangle2D.Double moveSelectedElements(GElement element,: " + System.currentTimeMillis(), 0);
                rect1 = this.doMoveMain(e, ((Point2D)pos).getX() + dx, ((Point2D)pos).getY() + dy, updateLinks);
            }
            rect = GUtil.union(rect, rect1);
            ++i;
        }
        Debug.outputDebugMessage("f", "currentTimeMillis 222 @ GStructure protected Rectangle2D.Double moveSelectedElements(GElement element,: " + System.currentTimeMillis(), 0);
        if (!updateLinks) {
            Rectangle2D redrawArea = this.updateLinksAfterShapesMoving(this.selectedVector, false);
            if (!this.moveMode) {
                rect = GUtil.union(rect, redrawArea);
            }
        }
        return rect;
    }

    public Rectangle2D notifyMoveSelecteds(GElement element, double x, double y) {
        return this.moveSelecteds(element, x, y, true);
    }

    protected Rectangle2D moveSelecteds(GElement element, double x, double y) {
        return this.moveSelecteds(element, x, y, true);
    }

    protected Rectangle2D moveSelecteds(GElement element, double x, double y, boolean repaint) {
        Point2D.Double position = GStructure.getPosition(element);
        double dx = x - position.x;
        double dy = y - position.y;
        if (this.isTemp()) {
            dx = this.temp_startx * -1.0;
            dy = this.temp_starty * -1.0;
        }
        return this.moveSelecteds2(dx, dy, repaint);
    }

    public Rectangle2D moveSelecteds2(double dx, double dy) {
        return this.moveSelecteds2(dx, dy, true);
    }

    public Rectangle2D moveSelecteds2(double dx, double dy, boolean repaint) {
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i = 0;
        while (i < this.selectedVector.size()) {
            GElement element = (GElement)this.selectedVector.get(i);
            Point2D.Double pos = GStructure.getPosition(element);
            if (element instanceof LayerReactionLink) {
                vector.add(new Point2D.Double(this.temp_dx, this.temp_dy));
            } else {
                vector.add(new Point2D.Double(((Point2D)pos).getX() + dx, ((Point2D)pos).getY() + dy));
            }
            ++i;
        }
        return this.move(this.selectedVector, vector, repaint);
    }

    public void moveSelectedElements(double x, double y) {
        Rectangle2D redrawArea = null;
        boolean updateLinks = moveLinkMode;
        boolean move = true;
        Vector<GElement> elementList = new Vector<GElement>();
        Vector<Point2D.Double> posList = new Vector<Point2D.Double>();
        int i = 0;
        while (i < this.selectedVector.size()) {
            double yy;
            Rectangle2D rect;
            Point2D pos;
            GElement element = (GElement)this.selectedVector.get(i);
            if (element instanceof GLink) {
                if (element instanceof LayerReactionLink) {
                    elementList.add(element);
                    posList.add(new Point2D.Double(x, y));
                } else {
                    GLinkedShape linkedShape = ((GLink)element).getGLinkedShape();
                    if (linkedShape != null && linkedShape instanceof GEditable) {
                        GEditPoint[] editPoints = ((GEditable)((Object)linkedShape)).getEditPoints();
                        if (editPoints == null) {
                            move = false;
                            break;
                        }
                        int j = 0;
                        while (j < editPoints.length) {
                            Point2D.Double pos2 = editPoints[j].getPosition();
                            double xx = ((Point2D)pos2).getX() + x;
                            double yy2 = ((Point2D)pos2).getY() + y;
                            if (xx < this.maxArea.getX() || xx > this.maxArea.getMaxX() || yy2 < this.maxArea.getY() || yy2 > this.maxArea.getMaxY()) {
                                move = false;
                                break;
                            }
                            elementList.add(editPoints[j]);
                            posList.add(new Point2D.Double(((Point2D)pos2).getX() + x, ((Point2D)pos2).getY() + y));
                            ++j;
                        }
                    }
                }
            } else if (element instanceof GPointed) {
                pos = ((GPointed)((Object)element)).getPoint();
                Point2D posPosBak = (Point2D)pos.clone();
                if (element instanceof OpenedCompartmentAlias && (rect = ((OpenedCompartmentAlias)element).getCompartmentMaxRepaintBoundsWithoutOpenedCompartmentAliasBounds()) != null) {
                    pos = new Point2D.Double(rect.getX(), rect.getY());
                    double xx = pos.getX() + x;
                    yy = pos.getY() + y;
                    if (xx < this.maxArea.getX() || xx + rect.getWidth() > this.maxArea.getMaxX() || yy < this.maxArea.getY() || yy + rect.getHeight() > this.maxArea.getMaxY()) {
                        move = false;
                        break;
                    }
                    pos = posPosBak;
                }
                elementList.add(element);
                posList.add(new Point2D.Double(pos.getX() + x, pos.getY() + y));
            } else {
                pos = GStructure.getPosition(element);
                if (element instanceof GFramed) {
                    rect = ((GFramed)((Object)element)).getFrameBounds();
                } else {
                    if (element instanceof GCreasePoint) {
                        element.update();
                    }
                    rect = element.getBounds();
                }
                Point2D posPosBak = (Point2D)pos.clone();
                if (element instanceof CompartmentAlias) {
                    rect = ((CompartmentAlias)((Object)element)).getCompartmentMaxRepaintBounds();
                    pos = new Point2D.Double(rect.getX(), rect.getY());
                }
                double xx = pos.getX() + x;
                yy = pos.getY() + y;
                if (xx < this.maxArea.getX() || xx + rect.getWidth() > this.maxArea.getMaxX() || yy < this.maxArea.getY() || yy + rect.getHeight() > this.maxArea.getMaxY()) {
                    move = false;
                    break;
                }
                pos = posPosBak;
                elementList.add(element);
                posList.add(new Point2D.Double(pos.getX() + x, pos.getY() + y));
            }
            ++i;
        }
        if (move) {
            redrawArea = this.move(elementList, posList);
        }
    }

    private Rectangle2D decideMoveLinks(List shapesOrig) {
        int j;
        GLinkTarget[] targets;
        Vector<GElement> shapes = new Vector<GElement>(shapesOrig);
        for (GElement gelement : shapesOrig) {
            if (gelement instanceof GContainer) {
                Vector vec1 = GStructure.getLowerTargets((GContainer)((Object)gelement));
                shapes.addAll(vec1);
                continue;
            }
            if (!(gelement instanceof GGroup)) continue;
            Vector members = ((GGroup)gelement).getMembers();
            int i = 0;
            while (i < members.size()) {
                GElement mem = (GElement)members.get(i);
                if (mem instanceof GContainableAtom) {
                    shapes.addAll(((GContainableAtom)mem).getTargets());
                }
                shapes.add(mem);
                ++i;
            }
        }
        this.moveLinkList.clear();
        Rectangle2D.Double redrawArea = null;
        ArrayList<GLink> moveLinks = new ArrayList<GLink>();
        int i = 0;
        while (i < this.links.size()) {
            GLink link = (GLink)this.links.get(i);
            link.setMoveLinkMode(moveLinkMode);
            if (link.isHighlighted() || shapes.contains(link)) {
                moveLinks.add(link);
            } else {
                targets = link.getTargets();
                j = 0;
                while (j < targets.length) {
                    if (shapes.contains(targets[j]) || moveLinks.contains(targets[j])) {
                        moveLinks.add(link);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.links.size()) {
            GLink link = (GLink)this.links.get(i);
            if (!moveLinks.contains(link)) {
                targets = link.getTargets();
                j = 0;
                while (j < targets.length) {
                    if (moveLinks.contains(targets[j])) {
                        moveLinks.add(link);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < moveLinks.size()) {
            GLink link = (GLink)moveLinks.get(i);
            link.setMoveLinkMode(true);
            targets = link.getTargets();
            int j2 = 0;
            while (j2 < targets.length) {
                LinkedCreaseLineMixedNotation mixednotation;
                LinkedCreaseLineModification modificationLine;
                if (!(link.getGLinkedShape() instanceof LinkedCreaseLineModification && (modificationLine = (LinkedCreaseLineModification)link.getGLinkedShape()).isMemberofBooleanLogicGate() && shapes.contains(targets[0]) && (shapes.contains(targets[1]) || moveLinks.contains(targets[1])) || link.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation && (mixednotation = (LinkedCreaseLineMixedNotation)link.getGLinkedShape()).isMemberofBooleanLogicGate() && shapes.contains(targets[0]) && (shapes.contains(targets[1]) || moveLinks.contains(targets[1])))) {
                    int index = moveLinks.indexOf(targets[j2]);
                    if (index != -1 && !((GLink)moveLinks.get(index)).isMoveLinkMode()) {
                        link.setMoveLinkMode(moveLinkMode);
                        break;
                    }
                    if (!shapes.contains(targets[j2]) && !moveLinks.contains(targets[j2])) {
                        link.setMoveLinkMode(moveLinkMode);
                        break;
                    }
                }
                ++j2;
            }
            Rectangle2D.Double r = link.update(link.isMoveLinkMode());
            redrawArea = GUtil.union(r, redrawArea);
            redrawArea = GUtil.union(link.getRepaintBounds(), redrawArea);
            ++i;
        }
        this.moveLinkList.addAll(moveLinks);
        return redrawArea;
    }

    private Rectangle2D updateLinksWithMoveLinks(List moveLinks) {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < moveLinks.size()) {
            GLink link = (GLink)moveLinks.get(i);
            Rectangle2D.Double r = link.update(link.isMoveLinkMode());
            redrawArea = GUtil.union(redrawArea, r);
            if (r == null) {
                redrawArea = GUtil.union(redrawArea, link.getRepaintBounds());
            }
            ++i;
        }
        return redrawArea;
    }

    public Rectangle2D updateLinksAfterShapesMoving(List shapes, boolean repaint) {
        Rectangle2D rect = null;
        Rectangle2D.Double rect20 = null;
        if (!this.isMoveMode()) {
            rect = this.decideMoveLinks(shapes);
            if (this.moveLinkList != null) {
                int i = 0;
                while (i < this.moveLinkList.size()) {
                    Debug.outputDebugMessage("f", "\tcurrentTimeMillis 111 @ GStructure public Rectangle2D updateLinksAfterShapesMoving(List shapes, boolean repaint): " + System.currentTimeMillis(), 0);
                    GLink link = (GLink)this.moveLinkList.get(i);
                    if (link.getGLinkedShape() instanceof GLogicGate) {
                        GLogicGate gate = (GLogicGate)link.getGLinkedShape();
                        gate.getRealLine().updateLine(false);
                    } else if (link.getGLinkedShape() instanceof StateTransition) {
                        ((StateTransition)link.getGLinkedShape()).updateLine(false);
                        rect20 = GUtil.union(rect20, this.repaintLinkandAllLinksWhichlinkingtome((ReactionLink)link, false));
                    } else if (link.getGLinkedShape() instanceof LinkedCreaseLineModification) {
                        ((LinkedCreaseLineModification)link.getGLinkedShape()).updateLine(false);
                    } else if (link.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation) {
                        ((LinkedCreaseLineMixedNotation)link.getGLinkedShape()).updateLine(false);
                    }
                    ++i;
                }
                if (rect20 != null) {
                    rect = GUtil.union(rect, rect20);
                }
            }
        } else {
            rect = this.updateLinksWithMoveLinks(this.moveLinkList);
            this.setRepaintArea(rect);
        }
        Debug.outputDebugMessage("f", "\tcurrentTimeMillis 222 @ GStructure public Rectangle2D updateLinksAfterShapesMoving(List shapes, boolean repaint): " + System.currentTimeMillis(), 0);
        Rectangle2D tempLayerRedrawArea = this.updateLayerTextLinks();
        rect = GUtil.union(rect, tempLayerRedrawArea);
        Rectangle2D tempLayerSpeciesRedrawArea = this.updateLayerSpeciesLinks();
        rect = GUtil.union(rect, tempLayerSpeciesRedrawArea);
        Debug.outputDebugMessage("f", "\tcurrentTimeMillis 333 @ GStructure public Rectangle2D updateLinksAfterShapesMoving(List shapes, boolean repaint): " + System.currentTimeMillis(), 0);
        return rect;
    }

    private Rectangle2D moveTargetsOf(GContainer container, double x, double y, boolean gpointed) {
        Rectangle2D.Double redrawArea = null;
        Vector contained = container.getTargets();
        int i = 0;
        while (i < contained.size()) {
            GGroup ggroup;
            GElement element = (GElement)contained.get(i);
            Point2D.Double relativePosition = ((GContainerTarget)((Object)element)).getInnerPosition();
            boolean fit = false;
            if (element instanceof GFramed) {
                Rectangle2D.Double r;
                GFramed framed = (GFramed)((Object)element);
                framed.setFramePosition(x + relativePosition.x, y + relativePosition.y);
                if (gpointed && !this.maxArea.contains(r = framed.getFrameBounds())) {
                    double xx = ((RectangularShape)r).getX();
                    double yy = ((RectangularShape)r).getY();
                    double ww = ((RectangularShape)r).getWidth();
                    double hh = ((RectangularShape)r).getHeight();
                    if (xx < this.maxArea.getX()) {
                        xx = this.maxArea.getX();
                    } else if (xx + ww > this.maxArea.getMaxX()) {
                        xx = this.maxArea.getMaxX() - ww;
                    }
                    if (yy < this.maxArea.getY()) {
                        yy = this.maxArea.getY();
                    } else if (yy + hh > this.maxArea.getMaxY()) {
                        yy = this.maxArea.getMaxY() - hh;
                    }
                    framed.setFramePosition(xx, yy);
                    fit = true;
                }
            } else if (element instanceof GPointed) {
                ((GPointed)((Object)element)).setPoint(x + relativePosition.x, y + relativePosition.y);
            }
            redrawArea = GUtil.union(element.update(), redrawArea);
            if (element instanceof GGroupTarget && (ggroup = this.getParentGroup(element)) != null) {
                ggroup.updatePositions();
                ggroup.update();
            }
            if (element instanceof GContainer) {
                double x2 = x + relativePosition.x;
                double y2 = y + relativePosition.y;
                if (fit && element instanceof GContainableAtom) {
                    x2 = ((GFramed)((Object)element)).getFramePosition().x;
                    y2 = ((GFramed)((Object)element)).getFramePosition().y;
                }
                Rectangle2D innerRedrawArea = this.moveTargetsOf((GContainer)((Object)element), x2, y2, gpointed);
                redrawArea = GUtil.union(innerRedrawArea, redrawArea);
            }
            ++i;
        }
        return redrawArea;
    }

    public void notifyChangeSelected() {
        this.notifyChange(null, 6, null);
    }

    public void notifyChagenVectorMove(Vector elements, Vector positions) {
        this.notifyChange(elements, 9, positions);
    }

    protected void notifyChange(Object obj, int flag, Object param) {
        SpeciesAlias alias;
        int i = 0;
        while (i < this.listeners.size()) {
            GStructureListener gstructurelistener = (GStructureListener)this.listeners.get(i);
            switch (flag) {
                case 0: {
                    gstructurelistener.elementCreated((GElement)obj);
                    break;
                }
                case 1: {
                    gstructurelistener.elementAdded((GElement)obj);
                    break;
                }
                case 2: {
                    gstructurelistener.elementRemoved((GElement)obj);
                    break;
                }
                case 3: {
                    gstructurelistener.elementsAdded((Vector)obj);
                    break;
                }
                case 11: {
                    gstructurelistener.elementsPasted((Vector)obj, (Dimension)param);
                    break;
                }
                case 4: {
                    gstructurelistener.elementsRemoved((Vector)obj);
                    break;
                }
                case 5: {
                    gstructurelistener.elementsAddedAndRemoved((Vector)obj, (Vector)param);
                    break;
                }
                case 6: {
                    if (this.selectedVector.size() >= 1) {
                        gstructurelistener.elementsSelected(this.selectedVector);
                        break;
                    }
                    gstructurelistener.elementSelected((GElement)obj);
                    break;
                }
                case 7: {
                    gstructurelistener.elementDeselected((GElement)obj);
                    break;
                }
                case 8: {
                    if (param instanceof Point2D.Double) {
                        gstructurelistener.elementMoved((GElement)obj, (Point2D.Double)param);
                        break;
                    }
                    if (!(param instanceof Vector)) break;
                    gstructurelistener.elementMoved((GElement)obj, (Vector)param);
                    break;
                }
                case 9: {
                    gstructurelistener.elementsMoved((Vector)obj, (Vector)param);
                    break;
                }
                case 10: {
                    gstructurelistener.elementResized((GElement)obj, (Rectangle2D.Double)param);
                    break;
                }
                case 12: {
                    gstructurelistener.reformSquareLinesBegan((GElement)obj);
                    break;
                }
                case 13: {
                    gstructurelistener.reformSquareLinesEnded((GElement)obj);
                    break;
                }
                case 14: {
                    gstructurelistener.squareLinesDirectionChanged((GElement)obj, (Vector)param);
                    break;
                }
                case -1: {
                    gstructurelistener.eventGroupBegan((GElement)obj);
                    break;
                }
                case -2: {
                    gstructurelistener.eventGroupEnded((GElement)obj);
                }
            }
            ++i;
        }
        if (this.atoms != null) {
            i = 0;
            while (i < this.atoms.size()) {
                alias = (SpeciesAlias)this.atoms.get(i);
                if (alias.isIncludedInComplex()) {
                    try {
                        alias.notifyObserver();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if (this.containeratoms != null) {
            i = 0;
            while (i < this.containeratoms.size()) {
                alias = (SpeciesAlias)this.containeratoms.get(i);
                if (alias.isIncludedInComplex()) {
                    try {
                        alias.notifyObserver();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if (this.recorder != null) {
            switch (flag) {
                case 1: {
                    this.recorder.record(1, (GElement)obj, null);
                    break;
                }
                case 2: {
                    this.recorder.record(3, (GElement)obj, null);
                    break;
                }
                case 3: {
                    this.recorder.record(2, (Vector)obj, null);
                    break;
                }
                case 11: {
                    this.recorder.record(9, (Vector)obj, null);
                    break;
                }
                case 4: {
                    this.recorder.record(4, (Vector)obj, null);
                    break;
                }
                case 5: {
                    this.recorder.record(5, (Vector)obj, (Vector)param, null);
                    break;
                }
                case 8: {
                    GElement element = (GElement)obj;
                    Point2D.Double oldPoint = (Point2D.Double)param;
                    GEventProperty geventproperty = new GEventProperty();
                    geventproperty.oldPoint = oldPoint;
                    geventproperty.newPoint = GStructure.getPosition(element);
                    this.recorder.record(6, element, geventproperty);
                    break;
                }
                case 9: {
                    Vector elements = (Vector)obj;
                    Vector points = (Vector)param;
                    GEventProperty geventproperty = new GEventProperty();
                    geventproperty.oldVector = points;
                    geventproperty.newVector = new Vector();
                    int j = 0;
                    while (j < elements.size()) {
                        GElement gelement = (GElement)elements.elementAt(j);
                        Point2D.Double newPoint = GStructure.getPosition(gelement);
                        geventproperty.newVector.add(newPoint);
                        ++j;
                    }
                    this.recorder.record(7, elements, geventproperty);
                    break;
                }
                case 10: {
                    GElement gelement = (GElement)obj;
                    Rectangle2D.Double oldBounds = (Rectangle2D.Double)param;
                    GEventProperty geventproperty = new GEventProperty();
                    geventproperty.oldBounds = oldBounds;
                    if (gelement instanceof GFramed) {
                        geventproperty.newBounds = ((GFramed)((Object)gelement)).getFrameBounds();
                    }
                    if (gelement instanceof GPointed) {
                        Point2D.Double newPoint = ((GPointed)((Object)gelement)).getPoint();
                        geventproperty.newBounds = new Rectangle2D.Double(newPoint.x, newPoint.y, 0.0, 0.0);
                    }
                    this.recorder.record(8, gelement, geventproperty);
                }
            }
        }
    }

    protected void notifyRepaint(Rectangle2D logicalArea) {
        if (logicalArea != null) {
            for (GStructurePainter painter : this.painters) {
                painter.needsRepaint(logicalArea);
            }
        }
    }

    protected void notifyRepaint(Rectangle2D logicalArea, boolean repaint) {
        if (logicalArea != null) {
            for (GStructurePainter painter : this.painters) {
                painter.needsRepaint(logicalArea, repaint);
            }
        }
    }

    public synchronized void paste(Vector elements) {
        this.paste(elements, null, true);
    }

    public synchronized void paste(Vector elements, Dimension size, boolean repaint) {
        if (elements != null && elements.size() != 0) {
            ComplexSpeciesAlias alias;
            Rectangle2D.Double redrawArea = null;
            Vector<GElement> addedElements = new Vector<GElement>();
            int i = 0;
            while (i < elements.size()) {
                GElement gelement = (GElement)elements.get(i);
                if (gelement != null) {
                    try {
                        if (!(gelement instanceof GCreasePoint) || !((GCreasePoint)gelement).isLogicGateHeaderPoint()) {
                            redrawArea = GUtil.union(redrawArea, this.addElement(gelement, true));
                            addedElements.add(gelement);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            i = 0;
            while (i < elements.size()) {
                if (elements.elementAt(i) instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias alias2 = (ComplexSpeciesAlias)elements.elementAt(i);
                    alias2.restoreChildren(this);
                }
                ++i;
            }
            Vector<ComplexSpeciesAlias> hasFoundBriefParents = new Vector<ComplexSpeciesAlias>();
            Vector<ComplexSpeciesAlias> otherComplexes = new Vector<ComplexSpeciesAlias>();
            int i2 = 0;
            while (i2 < elements.size()) {
                if (elements.elementAt(i2) instanceof ComplexSpeciesAlias) {
                    alias = (ComplexSpeciesAlias)elements.elementAt(i2);
                    if (alias.getCurrentView() == 3) {
                        ComplexSpeciesAlias parent = alias.findBriefParent();
                        if (!hasFoundBriefParents.contains(parent)) {
                            if (otherComplexes.contains(parent)) {
                                otherComplexes.remove(parent);
                            }
                            hasFoundBriefParents.addElement(parent);
                        }
                    } else if (!otherComplexes.contains(alias) && !hasFoundBriefParents.contains(alias)) {
                        otherComplexes.addElement(alias);
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < hasFoundBriefParents.size()) {
                ComplexSpeciesAlias parent = (ComplexSpeciesAlias)hasFoundBriefParents.elementAt(i2);
                this.changeComplexOrder(parent);
                parent.changeComplexView(new Integer(1));
                parent.update();
                ++i2;
            }
            i2 = 0;
            while (i2 < otherComplexes.size()) {
                alias = (ComplexSpeciesAlias)otherComplexes.elementAt(i2);
                this.changeComplexOrder(alias);
                ++i2;
            }
            if (addedElements.size() != 0) {
                redrawArea = GUtil.union(redrawArea, this.updateLinks());
                this.notifyChange(addedElements, 11, size);
                if (repaint) {
                    this.notifyRepaint(redrawArea);
                }
            }
        }
    }

    protected void releaseHighlight() {
        GElement gelement;
        Rectangle2D.Double redrawArea = null;
        int i = this.links.size() - 1;
        while (i >= 0) {
            GLink glink = (GLink)this.links.elementAt(i);
            if (glink.isHighlighted()) {
                redrawArea = GUtil.union(redrawArea, glink.getRepaintBounds());
            }
            glink.setHighlighted(false);
            --i;
        }
        i = this.atoms.size() - 1;
        while (i >= 0) {
            gelement = (GElement)this.atoms.elementAt(i);
            if (gelement.isHighlighted()) {
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
            }
            gelement.setHighlighted(false);
            --i;
        }
        i = this.containeratoms.size() - 1;
        while (i >= 0) {
            gelement = (GElement)this.containeratoms.elementAt(i);
            if (gelement.isHighlighted()) {
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
            }
            gelement.setHighlighted(false);
            --i;
        }
        i = this.containers.size() - 1;
        while (i >= 0) {
            gelement = (GElement)this.containers.elementAt(i);
            if (gelement.isHighlighted()) {
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
            }
            gelement.setHighlighted(false);
            --i;
        }
        this.notifyRepaint(redrawArea);
    }

    public synchronized void remove(Vector elements) {
        if (elements != null && elements.size() != 0) {
            Vector removeElements = new Vector();
            Rectangle2D.Double redrawArea = null;
            int i = 0;
            while (i < elements.size()) {
                if (elements.elementAt(i) instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias complex = (ComplexSpeciesAlias)elements.elementAt(i);
                    complex.backupChildren();
                }
                ++i;
            }
            i = 0;
            while (i < elements.size()) {
                GElement gelement = (GElement)elements.elementAt(i);
                if (gelement != null) {
                    redrawArea = GUtil.union(redrawArea, this.removeElement(gelement, removeElements));
                }
                ++i;
            }
            int size = removeElements.size();
            int i2 = 0;
            while (i2 < size) {
                GLogicGate baselinkgate;
                Vector childrenLink;
                ReactionLink link;
                if (removeElements.elementAt(i2) instanceof ReactionLink && (link = (ReactionLink)removeElements.elementAt(i2)).isBaseLinkGate() && (childrenLink = (baselinkgate = (GLogicGate)link.getGLinkedShape()).getChildrenLink()) != null && childrenLink.size() == 1 && i2 + 1 < size && childrenLink.get(0) == removeElements.elementAt(i2 + 1)) {
                    removeElements.remove(i2 + 1);
                    removeElements.add(i2, childrenLink.get(0));
                }
                ++i2;
            }
            this.notifyChange(removeElements, 4, null);
            this.notifyRepaint(redrawArea);
        }
    }

    public synchronized void remove(GElement gelement) {
        if (gelement != null) {
            Vector dummyvector = new Vector();
            Rectangle2D.Double redrawArea = this.removeElement(gelement, dummyvector);
            this.notifyChange(dummyvector, 4, null);
            this.notifyRepaint(redrawArea);
        }
    }

    private Rectangle2D.Double removeElement(GElement gelement, Vector removedVector) {
        Rectangle2D.Double redrawArea = null;
        int i = this.links.size() - 1;
        while (i >= 0) {
            GLink glink = (GLink)this.links.elementAt(i);
            if (glink == gelement) break;
            if (gelement instanceof GLinkTarget && this.isLowerChainedLink((GLinkTarget)((Object)gelement), glink)) {
                this.links.remove(glink);
                removedVector.add(glink);
                Rectangle2D.Double temp = this.deleteLayerTextReference(glink, removedVector);
                redrawArea = GUtil.union(temp, redrawArea);
                redrawArea = GUtil.union(redrawArea, glink.getRepaintBounds());
                if (this.selectedVector.remove(glink)) {
                    this.notifyChange(gelement, 7, null);
                }
            }
            --i;
        }
        if (this.selectedVector.contains(gelement)) {
            this.doDeselect(gelement);
        }
        if (gelement instanceof GBasicAtom) {
            if (gelement instanceof LayerSpeciesAlias) {
                this.layerRemove(gelement, removedVector);
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
            } else {
                this.atoms.remove(gelement);
                removedVector.add(gelement);
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
                Rectangle2D.Double tmp = this.deleteLayerTag(gelement, removedVector);
                redrawArea = GUtil.union(tmp, redrawArea);
                Rectangle2D.Double temp = this.deleteLayerTextReference(gelement, removedVector);
                redrawArea = GUtil.union(temp, redrawArea);
            }
        } else if (gelement instanceof GContainableAtom) {
            this.containeratoms.remove(gelement);
            removedVector.add(gelement);
            redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
        } else if (gelement instanceof GGroup) {
            this.groups.remove(gelement);
            removedVector.add(gelement);
            redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
        } else if (gelement instanceof GContainer) {
            if (gelement instanceof LayerCompartmentAlias) {
                this.layerRemove(gelement, removedVector);
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
            } else {
                this.containers.remove(gelement);
                removedVector.add(gelement);
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
                Rectangle2D.Double temp = this.deleteLayerTextReference(gelement, removedVector);
                redrawArea = GUtil.union(temp, redrawArea);
            }
        } else if (gelement instanceof GLink) {
            if (gelement instanceof LayerReactionLink) {
                this.layerRemove(gelement, removedVector);
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
                Rectangle2D.Double maxAr = this.getMaxDrawSize();
                if (maxAr != null) {
                    this.notifyRepaint((Rectangle2D.Double)maxAr.clone());
                }
            } else if (!removedVector.contains(gelement)) {
                this.links.remove(gelement);
                removedVector.add(gelement);
                redrawArea = GUtil.union(redrawArea, gelement.getRepaintBounds());
                Rectangle2D.Double temp = this.deleteLayerTextReference(gelement, removedVector);
                redrawArea = GUtil.union(temp, redrawArea);
                GLink gateLink = GLogicGate.getShouldBeRemovedGate((GLink)gelement);
                redrawArea = GUtil.union(redrawArea, GLogicGate.changeLinkBecauseGLogicGate((GLink)gelement, false));
                if (gateLink != null && !removedVector.contains(gateLink)) {
                    redrawArea = GUtil.union(redrawArea, this.removeElement(gateLink, removedVector));
                }
            }
        }
        if (gelement instanceof GContainer) {
            this.clearContainer((GContainer)((Object)gelement));
        }
        if (gelement instanceof GContainerTarget) {
            this.clearContainerOf((GContainerTarget)((Object)gelement));
        }
        if (gelement instanceof GCreasePointForUndo) {
            int index;
            Rectangle2D updateRect1;
            GCreasePoint cp = ((GCreasePointForUndo)gelement).getOriginal();
            GEditable owner = cp.getOwner();
            if (owner instanceof GLinkedCreaseLine) {
                int index2 = ((GCreasePointForUndo)gelement).getIndex();
                updateRect1 = ((GLinkedCreaseLine)owner).removeCreasePointWithoutNotify(cp, this, index2);
                if (updateRect1 != null) {
                    redrawArea = GUtil.union(redrawArea, updateRect1);
                }
            } else if (owner instanceof GLogicGate) {
                int index3 = ((GCreasePointForUndo)gelement).getIndex();
                updateRect1 = ((GLogicGate)owner).getRealLine().removeCreasePointWithoutNotify(cp, this, index3);
                if (updateRect1 != null) {
                    redrawArea = GUtil.union(redrawArea, updateRect1);
                }
            } else if (owner instanceof GLinkedCurveAndLine && (updateRect1 = ((GLinkedCurveAndLine)owner).removeCreasePointWithoutNotify(cp, this, index = ((GCreasePointForUndo)gelement).getIndex())) != null) {
                redrawArea = GUtil.union(redrawArea, updateRect1);
            }
        }
        if (gelement instanceof GLinkTarget && !(gelement instanceof GLink)) {
            int size = removedVector.size();
            int i2 = 0;
            while (i2 < size) {
                LinkedCreaseLine line;
                GLink link;
                if (removedVector.elementAt(i2) instanceof GLink && GLogicGate.isModification((link = (GLink)removedVector.elementAt(i2)).getGLinkedShape()) && !((LinkedCreaseLine)link.getGLinkedShape()).isSingleLine() && (line = (LinkedCreaseLine)link.getGLinkedShape()).getStartTarget() == gelement) {
                    GLink gateLink = GLogicGate.getShouldBeRemovedGate(link);
                    redrawArea = GUtil.union(redrawArea, GLogicGate.changeLinkBecauseGLogicGate(link, false));
                    if (gateLink != null && !removedVector.contains(gateLink)) {
                        redrawArea = GUtil.union(redrawArea, this.removeElement(gateLink, removedVector));
                    }
                }
                ++i2;
            }
        }
        this.sortLinks();
        return redrawArea;
    }

    private Rectangle2D.Double deleteLayerTextReference(GElement gelement, Vector removedVector) {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.layers.size()) {
            Rectangle2D.Double temp;
            Object s;
            LayerSpeciesAlias alias;
            int k;
            Vector<LayerSpeciesAlias> removeVector;
            Object target;
            LayerManager m = (LayerManager)this.layers.get(i);
            ArrayList listOfTexts = m.getListOfTexts();
            if (gelement instanceof SpeciesAlias) {
                target = (SpeciesAlias)gelement;
                removeVector = new Vector<LayerSpeciesAlias>();
                k = 0;
                while (k < listOfTexts.size()) {
                    alias = (LayerSpeciesAlias)listOfTexts.get(k);
                    if (alias.getTargetAlias() instanceof SpeciesAlias && (s = (SpeciesAlias)alias.getTargetAlias()).getName().equals(target.getName())) {
                        temp = alias.getRepaintBounds();
                        redrawArea = GUtil.union(redrawArea, temp);
                        removeVector.add(alias);
                        removedVector.add(alias);
                    }
                    ++k;
                }
                k = 0;
                while (k < removeVector.size()) {
                    listOfTexts.remove(removeVector.get(k));
                    ++k;
                }
            } else if (gelement instanceof CompartmentAlias) {
                target = (CompartmentAlias)((Object)gelement);
                removeVector = new Vector();
                k = 0;
                while (k < listOfTexts.size()) {
                    alias = (LayerSpeciesAlias)listOfTexts.get(k);
                    if (alias.getTargetAlias() instanceof CompartmentAlias && (s = (CompartmentAlias)alias.getTargetAlias()).getCompartmentName().equals(target.getCompartmentName())) {
                        temp = alias.getRepaintBounds();
                        redrawArea = GUtil.union(redrawArea, temp);
                        removeVector.add(alias);
                        removedVector.add(alias);
                    }
                    ++k;
                }
                k = 0;
                while (k < removeVector.size()) {
                    listOfTexts.remove(removeVector.get(k));
                    ++k;
                }
            } else if (gelement instanceof ReactionLink) {
                target = (ReactionLink)gelement;
                removeVector = new Vector();
                k = 0;
                while (k < listOfTexts.size()) {
                    alias = (LayerSpeciesAlias)listOfTexts.get(k);
                    if (alias.getTargetAlias() instanceof ReactionLink && ((GLink)(s = (ReactionLink)alias.getTargetAlias())).getName().equals(((GLink)target).getName())) {
                        temp = alias.getRepaintBounds();
                        redrawArea = GUtil.union(redrawArea, temp);
                        removeVector.add(alias);
                        removedVector.add(alias);
                    }
                    ++k;
                }
                k = 0;
                while (k < removeVector.size()) {
                    listOfTexts.remove(removeVector.get(k));
                    ++k;
                }
            }
            ++i;
        }
        return redrawArea;
    }

    private void layerRemove(GElement gelement, Vector removedVector) {
        int i = 0;
        while (i < this.layers.size()) {
            Object s;
            int k;
            LayerManager m = (LayerManager)this.layers.get(i);
            if (gelement instanceof LayerSpeciesAlias) {
                k = 0;
                while (k < m.getListOfTexts().size()) {
                    s = (LayerSpeciesAlias)m.getListOfTexts().get(k);
                    if (s == gelement) {
                        m.removeTexts(gelement);
                        removedVector.add(gelement);
                        return;
                    }
                    ++k;
                }
            } else if (gelement instanceof LayerCompartmentAlias) {
                k = 0;
                while (k < m.getListOfSquares().size()) {
                    s = (LayerCompartmentAlias)m.getListOfSquares().get(k);
                    if (s == gelement) {
                        m.removeSquares(gelement);
                        removedVector.add(gelement);
                        return;
                    }
                    ++k;
                }
            } else if (gelement instanceof LayerReactionLink) {
                k = 0;
                while (k < m.getListOfFreeLines().size()) {
                    s = (LayerReactionLink)m.getListOfFreeLines().get(k);
                    if (s == gelement) {
                        m.removeFreeLines(gelement);
                        removedVector.add(gelement);
                        return;
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void removeLayer(LayerManager layer) {
        Object redrawArea = null;
        this.layers.removeElement(layer);
        Rectangle2D.Double maxAr = this.getMaxDrawSize();
        if (maxAr != null) {
            this.notifyRepaint((Rectangle2D.Double)maxAr.clone());
        }
        SBEvent event = new SBEvent(33, layer, null);
        MainWindow.getLastInstance().getCurrentModel().getSBModel().getRecorder().record(event);
    }

    public void removeStructureListener(GStructureListener gstructurelistener) {
        this.listeners.remove(gstructurelistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStructurePainter(GStructurePainter gstructurepainter) {
        Vector vector = this.painters;
        synchronized (vector) {
            int i = 0;
            while (i < this.painters.size()) {
                GStructurePainter structurepainter = (GStructurePainter)this.painters.elementAt(i);
                if (structurepainter.equals(gstructurepainter)) {
                    this.painters.remove(structurepainter);
                    break;
                }
                ++i;
            }
        }
    }

    public void reset(GElement gelement) {
        if (GStructure.inContainableState(gelement)) {
            Vector targetsBefore = (Vector)((GContainer)((Object)gelement)).getTargets().clone();
            if (gelement.isHighlighted()) {
                targetsBefore = ((GContainer)((Object)gelement)).getTargets();
            }
            this.resetContainer((GContainer)((Object)gelement));
            if (gelement.isHighlighted()) {
                Vector targetAfter = (Vector)((GContainer)((Object)gelement)).getTargets().clone();
                this.changeTargetHighlights(targetsBefore, targetAfter);
            }
        }
        if (gelement instanceof GContainerTarget) {
            this.resetContainerOf((GContainerTarget)((Object)gelement));
        }
    }

    private void resetContainer(GContainer gcontainer) {
        this.clearContainer(gcontainer);
        if (gcontainer instanceof GContainableAtom) {
            GContainer parent;
            Vector<GElement> includeElements = new Vector<GElement>();
            int i = 0;
            while (i < this.containeratoms.size()) {
                GElement container = (GElement)this.containeratoms.elementAt(i);
                if (container != gcontainer && gcontainer.includes((GContainerTarget)((Object)container)) != 0) {
                    includeElements.add(container);
                }
                ++i;
            }
            i = 0;
            while (i < this.atoms.size()) {
                ComplexSpeciesAlias complex;
                GElement atom = (GElement)this.atoms.elementAt(i);
                if ((!(gcontainer instanceof ComplexSpeciesAlias) || !(complex = (ComplexSpeciesAlias)gcontainer).isContains(atom) || complex.getCurrentView() != 1 && complex.getCurrentView() != 3) && gcontainer.includes((GContainerTarget)((Object)atom)) != 0) {
                    parent = ((GContainerTarget)((Object)atom)).getContainer();
                    if (parent == null) {
                        GStructure.setContainerTarget(gcontainer, (GContainerTarget)((Object)atom));
                    } else if (!includeElements.contains(parent)) {
                        parent.removeTarget((GContainerTarget)((Object)atom));
                        GStructure.setContainerTarget(gcontainer, (GContainerTarget)((Object)atom));
                    }
                }
                ++i;
            }
            i = 0;
            while (i < includeElements.size()) {
                if (includeElements.elementAt(i) instanceof ComplexSpeciesAlias) {
                    ComplexSpeciesAlias complex = (ComplexSpeciesAlias)includeElements.elementAt(i);
                    parent = complex.getContainer();
                    if (parent == null) {
                        GStructure.setContainerTarget(gcontainer, complex);
                    } else if (!includeElements.contains(parent)) {
                        parent.removeTarget(complex);
                        GStructure.setContainerTarget(gcontainer, complex);
                    }
                }
                ++i;
            }
        } else {
            GContainer parent;
            Vector<GElement> includeElements = new Vector<GElement>();
            int i = 0;
            while (i < this.containers.size()) {
                GElement container = (GElement)this.containers.elementAt(i);
                if (container != gcontainer && gcontainer.includes((GContainerTarget)((Object)container)) != 0) {
                    includeElements.add(container);
                }
                ++i;
            }
            i = 0;
            while (i < includeElements.size()) {
                GContainerTarget gcontainertarget = (GContainerTarget)includeElements.elementAt(i);
                parent = gcontainertarget.getContainer();
                if (!includeElements.contains(parent)) {
                    if (parent != null) {
                        parent.removeTarget(gcontainertarget);
                    }
                    GStructure.setContainerTarget(gcontainer, gcontainertarget);
                }
                ++i;
            }
            i = 0;
            while (i < this.containeratoms.size()) {
                GElement containeratom = (GElement)this.containeratoms.elementAt(i);
                if (!(containeratom instanceof ComplexSpeciesAlias && (parent = ((ComplexSpeciesAlias)containeratom).getContainer()) != null && parent instanceof ComplexSpeciesAlias || gcontainer.includes((GContainerTarget)((Object)containeratom)) == 0)) {
                    parent = ((GContainerTarget)((Object)containeratom)).getContainer();
                    if (parent == null) {
                        GStructure.setContainerTarget(gcontainer, (GContainerTarget)((Object)containeratom));
                    } else if (!includeElements.contains(parent)) {
                        parent.removeTarget((GContainerTarget)((Object)containeratom));
                        GStructure.setContainerTarget(gcontainer, (GContainerTarget)((Object)containeratom));
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.atoms.size()) {
                GElement atom = (GElement)this.atoms.elementAt(i);
                parent = ((GContainerTarget)((Object)atom)).getContainer();
                if (!(parent instanceof GContainableAtom) && gcontainer.includes((GContainerTarget)((Object)atom)) != 0) {
                    if (parent == null) {
                        GStructure.setContainerTarget(gcontainer, (GContainerTarget)((Object)atom));
                    } else if (!includeElements.contains(parent)) {
                        parent.removeTarget((GContainerTarget)((Object)atom));
                        GStructure.setContainerTarget(gcontainer, (GContainerTarget)((Object)atom));
                    }
                }
                ++i;
            }
        }
    }

    private void resetContainerOf(GContainerTarget gcontainertarget) {
        this.clearContainerOf(gcontainertarget);
        GContainer gcontainer = this.getOutside(gcontainertarget);
        if (gcontainer != null) {
            GStructure.setContainerTarget(gcontainer, gcontainertarget);
        }
    }

    private void resetContainerOfForResetGroupMember(GContainerTarget gcontainertarget) {
        this.clearContainerOf(gcontainertarget);
        GContainer gcontainer = this.getOutside(gcontainertarget);
        if (gcontainer != null) {
            GStructure.setContainerTarget(gcontainer, gcontainertarget);
        }
    }

    private void resetMaxArea() {
        int i = 0;
        while (i < this.containers.size()) {
            GElement container = (GElement)this.containers.elementAt(i);
            if (container instanceof GPointed) {
                ((GPointed)((Object)container)).setMaxArea(this.maxArea);
                container.update();
            }
            ++i;
        }
    }

    public void resize(GElement element, double x, double y, double width, double height) {
        Rectangle2D.Double prevbounds = null;
        if (element instanceof GFramed) {
            prevbounds = ((GFramed)((Object)element)).getFrameBounds();
        }
        if (element instanceof GPointed) {
            Point2D.Double prevpoints = ((GPointed)((Object)element)).getPoint();
            prevbounds = new Rectangle2D.Double(prevpoints.x, prevpoints.y, 0.0, 0.0);
        }
        Rectangle2D redrawArea = this.resizeElement(element, x, y, width, height);
        this.notifyRepaint(redrawArea);
        if (GStructure.inContainableState(element)) {
            this.resetContainer((GContainer)((Object)element));
        }
        if (element instanceof GContainerTarget) {
            this.resetContainerOf((GContainerTarget)((Object)element));
        }
        if (element instanceof GGroup) {
            Vector memeber = ((GGroup)element).getMembers();
            int i = 0;
            while (i < memeber.size()) {
                GElement elem = (GElement)memeber.elementAt(i);
                if (elem instanceof GContainerTarget) {
                    this.resetContainerOf((GContainerTarget)((Object)elem));
                }
                ++i;
            }
        }
        if (element instanceof ComplexSpeciesAlias) {
            this.changeComplexOrder((ComplexSpeciesAlias)element);
        }
        this.notifyChange(element, 10, prevbounds);
    }

    protected Rectangle2D resizeElement(GElement element, double x, double y, double width, double height) {
        Rectangle2D redrawArea;
        CompartmentAlias compartent;
        NameImage nameImage;
        if (element instanceof LayerSpeciesAlias || element instanceof LayerCompartmentAlias || element instanceof LayerReactionLink) {
            int id = -1;
            if (element instanceof LayerSpeciesAlias) {
                id = ((LayerSpeciesAlias)element).getBelong_layer_id();
            } else if (element instanceof LayerCompartmentAlias) {
                id = ((LayerCompartmentAlias)((Object)element)).getBelong_layer_id();
            } else if (element instanceof LayerReactionLink) {
                id = ((LayerReactionLink)element).getBelong_layer_id();
            }
            LayerManager m = LayerManager.getSelectedLayerManager(this.layers, id);
            if (m != null && m.isLock()) {
                return null;
            }
        }
        boolean updateLinks = moveLinkMode;
        Vector insideElements = null;
        if (GStructure.inContainableState(element)) {
            insideElements = this.getInsides((GContainer)((Object)element));
        }
        if (element instanceof GFramed) {
            Point2D.Double pnt = null;
            try {
                pnt = (Point2D.Double)((ClosedCompartmentAlias)element).getCompartmentNameImage().getFramePosition().clone();
            }
            catch (Exception myErr) {
                pnt = null;
            }
            ((GFramed)((Object)element)).setFramePosition(x, y);
            ((GFramed)((Object)element)).setFrameSize(width, height);
            if (element instanceof ClosedCompartmentAlias && pnt != null) {
                ((ClosedCompartmentAlias)element).recalCompartmentNameDisplayPostion(new Point2D.Double(pnt.x, pnt.y));
            }
        }
        if (element instanceof GPointed) {
            ((GPointed)((Object)element)).setPoint(x, y);
        }
        Rectangle2D elementUpdatedArea = element.update();
        if (element instanceof CompartmentAlias && (nameImage = (compartent = (CompartmentAlias)((Object)element)).getCompartmentNameImage()) != null) {
            Rectangle2D nameImageRectangle = null;
            if (nameImage.getUndoRedoFlg()) {
                nameImageRectangle = nameImage.restorePosition();
                nameImage.setUndoRedoFlg(false);
            } else {
                nameImageRectangle = nameImage.resetPosition();
            }
            elementUpdatedArea = GUtil.union(elementUpdatedArea, nameImageRectangle);
        }
        if (updateLinks) {
            Rectangle2D linkUpdateArea = this.updateLinks();
            redrawArea = GUtil.union(elementUpdatedArea, linkUpdateArea);
        } else {
            redrawArea = elementUpdatedArea;
        }
        if (element instanceof GContainer && element.isHighlighted() && GStructure.inContainableState(element)) {
            Vector insideElementsAfter = this.getInsides((GContainer)((Object)element));
            Rectangle2D.Double containerUpdateArea = this.changeTargetHighlights(insideElements, insideElementsAfter);
            redrawArea = GUtil.union(redrawArea, containerUpdateArea);
        }
        if (!updateLinks) {
            boolean repaint = false;
            Vector<GElement> v = new Vector<GElement>();
            v.add(element);
            Rectangle2D rect1 = this.updateLinksAfterShapesMoving(v, repaint);
            return GUtil.union(redrawArea, rect1);
        }
        return redrawArea;
    }

    public synchronized void selectAll() {
        GElement element;
        this.deselectAll();
        ArrayList deselectList = new ArrayList();
        int i = 0;
        while (i < this.groups.size()) {
            element = (GElement)this.groups.get(i);
            Vector members = ((GGroup)element).getMembers();
            deselectList.addAll(members);
            element.setHighlighted(true);
            if (element instanceof GResizable) {
                ((GResizable)((Object)element)).activateHandle(true);
            }
            this.selectedVector.add(element);
            ++i;
        }
        i = 0;
        while (i < this.containeratoms.size()) {
            GContainer container;
            element = (GElement)this.containeratoms.get(i);
            if (!(element instanceof ComplexSpeciesAlias) || (container = ((ComplexSpeciesAlias)element).getContainer()) == null || !(container instanceof ComplexSpeciesAlias)) {
                if (!deselectList.contains(element)) {
                    element.setHighlighted(true);
                    if (element instanceof GResizable) {
                        ((GResizable)((Object)element)).activateHandle(true);
                    }
                    Vector targetList = GStructure.getLowerTargets((GContainer)((Object)element));
                    this.highlightContainerTargets(targetList, true);
                    deselectList.addAll(targetList);
                    this.selectedVector.add(element);
                } else {
                    deselectList.addAll(GStructure.getLowerTargets((GContainer)((Object)element)));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.atoms.size()) {
            element = (GElement)this.atoms.get(i);
            if (!deselectList.contains(element)) {
                element.setHighlighted(true);
                if (element instanceof GResizable) {
                    ((GResizable)((Object)element)).activateHandle(true);
                }
                this.selectedVector.add(element);
            }
            ++i;
        }
        i = 0;
        while (i < this.links.size()) {
            GLink link = (GLink)this.links.get(i);
            if (link.getGLinkedShape() != null && link.getGLinkedShape() instanceof GLogicGate) {
                this.selectedVector.remove(((GLogicGate)link.getGLinkedShape()).getHeaderPoint());
                this.selectedVector.add(((GLogicGate)link.getGLinkedShape()).getHeaderPoint());
            }
            link.setHighlighted(true);
            ++i;
        }
        this.selectAllLayer();
        this.notifyChange(null, 6, null);
    }

    private synchronized void selectAllLayer() {
        int k = 0;
        while (k < this.layers.size()) {
            GElement element;
            LayerManager selectedLayer = (LayerManager)this.layers.get(k);
            int i = 0;
            while (i < selectedLayer.getListOfTexts().size()) {
                element = (GElement)selectedLayer.getListOfTexts().get(i);
                element.setHighlighted(true);
                if (element instanceof GResizable) {
                    ((GResizable)((Object)element)).activateHandle(true);
                }
                this.selectedVector.add(element);
                ++i;
            }
            i = 0;
            while (i < selectedLayer.getListOfSquares().size()) {
                element = (GElement)selectedLayer.getListOfSquares().get(i);
                element.setHighlighted(true);
                if (element instanceof GResizable) {
                    ((GResizable)((Object)element)).activateHandle(true);
                }
                this.selectedVector.add(element);
                ++i;
            }
            i = 0;
            while (i < selectedLayer.getListOfFreeLines().size()) {
                GLink link = (GLink)selectedLayer.getListOfFreeLines().get(i);
                link.setHighlighted(true);
                GLinkedShape glinkedshape = link.getGLinkedShape();
                if (!(glinkedshape instanceof LayerTagFreeLineSymbol)) {
                    this.selectedVector.add(link);
                }
                ++i;
            }
            ++k;
        }
    }

    public synchronized void selectAll(LayerManager selectedLayer) {
        Rectangle2D.Double redrawArea2;
        GElement element;
        this.deselectAll();
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < selectedLayer.getListOfTexts().size()) {
            element = (GElement)selectedLayer.getListOfTexts().get(i);
            element.setHighlighted(true);
            if (element instanceof GResizable) {
                ((GResizable)((Object)element)).activateHandle(true);
            }
            redrawArea2 = element.getRepaintBounds();
            redrawArea = GUtil.union(redrawArea, redrawArea2);
            this.selectedVector.add(element);
            ++i;
        }
        i = 0;
        while (i < selectedLayer.getListOfSquares().size()) {
            element = (GElement)selectedLayer.getListOfSquares().get(i);
            element.setHighlighted(true);
            if (element instanceof GResizable) {
                ((GResizable)((Object)element)).activateHandle(true);
            }
            redrawArea2 = element.getRepaintBounds();
            redrawArea = GUtil.union(redrawArea, redrawArea2);
            this.selectedVector.add(element);
            ++i;
        }
        i = 0;
        while (i < selectedLayer.getListOfFreeLines().size()) {
            GLink link = (GLink)selectedLayer.getListOfFreeLines().get(i);
            link.setHighlighted(true);
            redrawArea2 = link.getRepaintBounds();
            redrawArea = GUtil.union(redrawArea, redrawArea2);
            this.selectedVector.add(link);
            ++i;
        }
        this.notifyChange(null, 6, null);
        this.notifyRepaint(redrawArea);
    }

    public synchronized Rectangle2D select(GElement gelement) {
        return this.select(gelement, false);
    }

    public synchronized Rectangle2D select(GElement gelement, boolean repaint) {
        return this.select(gelement, repaint, true);
    }

    public synchronized Rectangle2D select(GElement gelement, boolean repaint, boolean change) {
        return this.select(gelement, repaint, change, true);
    }

    public synchronized Rectangle2D select(GElement element, boolean repaint, boolean change, boolean linkHighlight) {
        Rectangle2D redrawArea = null;
        if (element != null && this.contains(element)) {
            redrawArea = this.doSelect(element, linkHighlight);
            if (change) {
                this.notifyChange(element, 6, null);
            }
            if (repaint) {
                this.notifyRepaint(redrawArea);
            }
        }
        return redrawArea;
    }

    private synchronized Rectangle2D doSelect(GElement gelement) {
        return this.doSelect(gelement, true);
    }

    private synchronized Rectangle2D resetSelectedContainers() {
        Rectangle2D.Double redrawArea = null;
        if (this.selectedVector != null) {
            int i = 0;
            while (i < this.selectedVector.size()) {
                if (this.selectedVector.get(i) instanceof GContainer) {
                    GContainer container = (GContainer)this.selectedVector.get(i);
                    Rectangle2D r = this.deselectLowerTargets(container);
                    redrawArea = GUtil.union(redrawArea, r);
                    r = this.highlightContainerTargets(container, true);
                    redrawArea = GUtil.union(redrawArea, r);
                }
                ++i;
            }
        }
        return redrawArea;
    }

    private synchronized Rectangle2D doSelect(GElement gelement, boolean linkHighlight) {
        Rectangle2D r;
        GContainer container;
        Rectangle2D.Double redrawArea = null;
        Vector<GContainer> parentNodes = new Vector<GContainer>();
        if (gelement instanceof ComplexSpeciesAlias) {
            this.foundAllParentComplexNodes((ComplexSpeciesAlias)gelement, parentNodes);
        } else if (gelement instanceof ElementSpeciesAlias && (container = ((ElementSpeciesAlias)gelement).getContainer()) != null && container instanceof ComplexSpeciesAlias) {
            parentNodes.add(container);
            this.foundAllParentComplexNodes((ComplexSpeciesAlias)container, parentNodes);
        }
        if (parentNodes != null && parentNodes.size() > 0) {
            int c = 0;
            while (c < parentNodes.size()) {
                if (this.selectedVector.contains(parentNodes.get(c))) {
                    return null;
                }
                ++c;
            }
        }
        if (gelement instanceof GContainerTarget) {
            if (gelement instanceof GBasicAtom && ((GAtom)gelement).getCurrentView() == 1) {
                return redrawArea;
            }
            r = this.deselectUpperContainers((GContainerTarget)((Object)gelement));
            redrawArea = GUtil.union(redrawArea, r);
        }
        if (gelement instanceof GContainer) {
            r = this.deselectLowerTargets((GContainer)((Object)gelement));
            redrawArea = GUtil.union(redrawArea, r);
        } else if (gelement instanceof GLink && !(gelement instanceof LayerReactionLink)) {
            r = this.deselectUpperChains((GLink)gelement);
            redrawArea = GUtil.union(redrawArea, r);
        }
        if (gelement instanceof GLinkTarget) {
            r = this.deselectLowerChains(gelement);
            redrawArea = GUtil.union(redrawArea, r);
        }
        if (gelement instanceof GGroup) {
            Vector member = ((GGroup)gelement).getMembers();
            int i = 0;
            while (i < member.size()) {
                GElement element = (GElement)member.get(i);
                if (element instanceof GContainerTarget) {
                    r = this.deselectUpperContainers((GContainerTarget)((Object)element));
                    redrawArea = GUtil.union(redrawArea, r);
                }
                ++i;
            }
        }
        gelement.setHighlighted(true);
        if (gelement instanceof GResizable) {
            ((GResizable)((Object)gelement)).activateHandle(true);
        }
        r = gelement.getRepaintBounds();
        redrawArea = GUtil.union(redrawArea, r);
        if (linkHighlight) {
            r = this.highlightChainedLinks(gelement);
            redrawArea = GUtil.union(redrawArea, r);
        }
        if (gelement instanceof GLink) {
            r = ((GLink)gelement).update();
            redrawArea = GUtil.union(redrawArea, r);
            GLinkedShape glinkedshape = ((GLink)gelement).getGLinkedShape();
            if (glinkedshape instanceof GEditable) {
                ((GEditable)((Object)glinkedshape)).activateEditPoints(true);
            }
        } else if (gelement instanceof GContainer) {
            r = this.highlightContainerTargets((GContainer)((Object)gelement), true);
            redrawArea = GUtil.union(redrawArea, r);
        }
        if (!this.selectedVector.contains(gelement)) {
            this.selectedVector.add(gelement);
        }
        if ((r = this.resetSelectedContainers()) != null) {
            redrawArea = GUtil.union(redrawArea, r);
        }
        return redrawArea;
    }

    public void setAtomNametag(String name) {
        this.atomTag = name;
    }

    public void setContainableAtomNametag(String name) {
        this.containerAtomTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAtoms(Vector elements) {
        Vector vector = this.atoms;
        synchronized (vector) {
            int countMax = 0;
            this.atoms.clear();
            this.atomCnt = 0;
            int i = 0;
            while (i < elements.size()) {
                GElement gelement = (GElement)elements.elementAt(i);
                this.atoms.add(gelement);
                gelement.update();
                ++this.atomCnt;
                String name = gelement.getName();
                try {
                    String serialNumber = name.substring(this.atomNametag().length());
                    int number = Integer.parseInt(serialNumber);
                    if (number > countMax) {
                        countMax = number;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (this.atomCnt < countMax) {
                this.atomCnt = countMax;
            }
            this.resetMaxArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainableAtoms(Vector elements) {
        Vector vector = this.containeratoms;
        synchronized (vector) {
            int countMax = 0;
            this.containeratoms.clear();
            this.containerAtomCnt = 0;
            int i = 0;
            while (i < elements.size()) {
                GElement gelement = (GElement)elements.elementAt(i);
                this.containeratoms.add(gelement);
                gelement.update();
                ++this.containerAtomCnt;
                String name = gelement.getName();
                try {
                    String serialNumber = name.substring(this.containerAtomtag().length());
                    int number = Integer.parseInt(serialNumber);
                    if (number > countMax) {
                        countMax = number;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (this.containerAtomCnt < countMax) {
                this.containerAtomCnt = countMax;
            }
            this.resetMaxArea();
        }
    }

    public void setClossLineON(boolean crosslineon) {
        this.isClossLineON = crosslineon;
    }

    public void setContainerNametag(String name) {
        this.containerTag = name;
    }

    public static void setContainerTarget(GContainer gcontainer, GContainerTarget gcontainertarget) {
        if (gcontainertarget instanceof LayerSpeciesAlias || gcontainertarget instanceof LayerCompartmentAlias) {
            return;
        }
        gcontainer.addTarget(gcontainertarget);
        gcontainertarget.setContainer(gcontainer);
        Point2D.Double containerPosition = null;
        if (gcontainer instanceof GFramed) {
            containerPosition = ((GFramed)((Object)gcontainer)).getFramePosition();
        }
        if (gcontainer instanceof GPointed) {
            containerPosition = ((GPointed)((Object)gcontainer)).getPoint();
        }
        Point2D.Double targetPosition = null;
        if (gcontainertarget instanceof GFramed) {
            targetPosition = ((GFramed)((Object)gcontainertarget)).getFramePosition();
        }
        if (gcontainertarget instanceof GPointed) {
            targetPosition = ((GPointed)((Object)gcontainertarget)).getPoint();
        }
        if (containerPosition != null && targetPosition != null) {
            Point2D.Double innerPosition = new Point2D.Double(targetPosition.x - containerPosition.x, targetPosition.y - containerPosition.y);
            gcontainertarget.setInnerPosition(innerPosition);
        }
    }

    public void setContainerTargetInnerPoint(GContainerTarget target) {
        GContainer container = target.getContainer();
        if (container != null) {
            Point2D.Double containerPosition = null;
            if (container instanceof GFramed) {
                containerPosition = ((GFramed)((Object)container)).getFramePosition();
            } else if (container instanceof GPointed) {
                containerPosition = ((GPointed)((Object)container)).getPoint();
            }
            Point2D.Double targetPosition = null;
            if (target instanceof GFramed) {
                targetPosition = ((GFramed)((Object)target)).getFramePosition();
            } else if (target instanceof GPointed) {
                targetPosition = ((GPointed)((Object)target)).getPoint();
            }
            if (containerPosition != null && targetPosition != null) {
                Point2D.Double innerPosition = new Point2D.Double(((Point2D)targetPosition).getX() - ((Point2D)containerPosition).getX(), ((Point2D)targetPosition).getY() - ((Point2D)containerPosition).getY());
                target.setInnerPosition(innerPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainers(Vector elements) {
        Vector vector = this.containers;
        synchronized (vector) {
            int countMax = 0;
            this.containers.clear();
            this.containerCnt = 0;
            int i = 0;
            while (i < elements.size()) {
                GElement gelement = (GElement)elements.elementAt(i);
                this.containers.add(gelement);
                gelement.update();
                ++this.containerCnt;
                String name = gelement.getName();
                String serialNumber = name.substring(this.containerNametag().length());
                try {
                    int number = Integer.parseInt(serialNumber);
                    if (number > countMax) {
                        countMax = number;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (this.containerCnt < countMax) {
                this.containerCnt = countMax;
            }
            this.resetMaxArea();
        }
    }

    public void setGroupNametag(String name) {
        this.groupTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(Vector groupVector) {
        Vector vector = this.groups;
        synchronized (vector) {
            int currentMax = 0;
            this.groups.clear();
            this.groupCnt = 0;
            int i = 0;
            while (i < groupVector.size()) {
                GElement gelement = (GElement)groupVector.elementAt(i);
                this.groups.add(gelement);
                gelement.update();
                ++this.groupCnt;
                String name = gelement.getName();
                String numberString = name.substring(this.groupNametag().length());
                try {
                    int numberInt = Integer.parseInt(numberString);
                    if (numberInt > currentMax) {
                        currentMax = numberInt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (this.groupCnt < currentMax) {
                this.groupCnt = currentMax;
            }
        }
    }

    public void setLinkNametag(String name) {
        this.linkTag = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinks(Vector linksVector) {
        Vector vector = this.links;
        synchronized (vector) {
            int currentMax = 0;
            this.links.clear();
            this.linkCnt = 0;
            int i = 0;
            while (i < linksVector.size()) {
                GElement gelement = (GElement)linksVector.elementAt(i);
                this.links.add(gelement);
                gelement.update();
                ++this.linkCnt;
                String name = gelement.getName();
                try {
                    String numberString = name.substring(this.linkNametag().length());
                    int numberInt = Integer.parseInt(numberString);
                    if (numberInt > currentMax) {
                        currentMax = numberInt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (this.linkCnt < currentMax) {
                this.linkCnt = currentMax;
            }
            this.sortLinks();
            this.resetMaxArea();
        }
    }

    public void setMaxDrawSize(Rectangle2D.Double area) {
        this.maxArea = area;
        this.resetMaxArea();
    }

    public void setRecorder(GEventRecorder geventrecorder) {
        this.recorder = geventrecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReportingListener(GStructureListener gstructurelistener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.insertElementAt(gstructurelistener, 0);
        }
    }

    protected void setSelectRect(Rectangle2D.Double area) {
        this.selectRect = area;
    }

    public Rectangle2D getSelectRect() {
        return this.selectRect;
    }

    public void setTemporalGElement(GElement gelement) {
        if (gelement != null) {
            this.tmp = gelement;
        } else if (this.tmp != null) {
            Rectangle2D.Double redrawArea = this.tmp.getRepaintBounds();
            if (this.tmp instanceof GContainer) {
                Vector insideElems = this.getInsides((GContainer)((Object)this.tmp));
                Rectangle2D.Double changeHLArea = this.changeTargetHighlights(insideElems, new Vector());
                redrawArea = GUtil.union(redrawArea, changeHLArea);
            }
            this.tmp = null;
            this.notifyRepaint(redrawArea);
        }
    }

    private void sortLinks() {
        this.sortedLinks.removeAllElements();
        int i = 0;
        while (i < this.links.size()) {
            GLink glink = (GLink)this.links.elementAt(i);
            this.sortLinks(glink);
            ++i;
        }
    }

    private void sortLinks(GLink link) {
        GLink targetLink = this.getTargetLink(link);
        if (targetLink == null) {
            Vector<GLink> v = new Vector<GLink>();
            v.add(link);
            this.sortedLinks.add(v);
        } else {
            int i = 0;
            while (i < this.sortedLinks.size()) {
                Vector v = (Vector)this.sortedLinks.get(i);
                if (v.contains(targetLink)) {
                    v.add(link);
                    break;
                }
                ++i;
            }
        }
    }

    public Rectangle2D updateLinks() {
        return this.updateLinks(false);
    }

    public Rectangle2D updateLinks(boolean ajustLinkLineConn) {
        return this.updateLinks(ajustLinkLineConn, true);
    }

    public Rectangle2D updateLinks(boolean ajustLinkLineConn, boolean moveCreasePoints) {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.links.size()) {
            ReactionLink gelement = (ReactionLink)this.links.get(i);
            Rectangle2D.Double tempRedrawArea = gelement.update(moveCreasePoints);
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
            if (ajustLinkLineConn && gelement instanceof ReactionLink) {
                Rectangle2D ar = this.autoAjustLinkLineConn(gelement);
                redrawArea = GUtil.union(redrawArea, ar);
            }
            ++i;
        }
        Rectangle2D tempLayerRedrawArea = this.updateLayerTextLinks();
        redrawArea = GUtil.union(redrawArea, tempLayerRedrawArea);
        Rectangle2D tempLayerSpeciesRedrawArea = this.updateLayerSpeciesLinks();
        redrawArea = GUtil.union(redrawArea, tempLayerSpeciesRedrawArea);
        return redrawArea;
    }

    public Rectangle2D updateLayerTextLinks() {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.layers.size()) {
            LayerManager m = (LayerManager)this.layers.get(i);
            ArrayList listOfTexts = m.getListOfTexts();
            int k = 0;
            while (k < listOfTexts.size()) {
                LayerSpeciesAlias alias = (LayerSpeciesAlias)listOfTexts.get(k);
                Rectangle2D tempRedrawArea = alias.updateLink();
                redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                ++k;
            }
            ++i;
        }
        return redrawArea;
    }

    public void setLayers(Vector layers) {
        this.layers = layers;
    }

    public Rectangle2D updateLinks(GLink link) {
        Rectangle2D redrawArea = null;
        redrawArea = link.update();
        if (redrawArea == null) {
            redrawArea = link.getRepaintBounds();
        }
        Rectangle2D tempLayerRedrawArea = this.updateLayerTextLinks();
        redrawArea = GUtil.union(redrawArea, tempLayerRedrawArea);
        Rectangle2D tempLayerSpeciesRedrawArea = this.updateLayerSpeciesLinks();
        redrawArea = GUtil.union(redrawArea, tempLayerSpeciesRedrawArea);
        return redrawArea;
    }

    public synchronized void create(GElement gelement) {
        if (gelement != null) {
            this.notifyChange(gelement, 0, null);
        }
    }

    private static boolean inContainableState(GElement element) {
        if (element instanceof GContainer) {
            if (element instanceof LayerCompartmentAlias) {
                return false;
            }
            if (element instanceof ComplexSpeciesAlias) {
                try {
                    int iview = ((ComplexSpeciesAlias)element).getCurrentView();
                    return iview == 0 || iview == 2;
                }
                catch (Exception myErr) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void setContainerTarget(GContainer container, List elementList, List positionList) {
        Vector targets = container.getTargets();
        int i = 0;
        while (i < targets.size()) {
            GElement element = (GElement)targets.get(i);
            Point2D.Double point = GStructure.getPosition(element);
            if (element instanceof GContainer) {
                this.setContainerTarget((GContainer)((Object)element), elementList, positionList);
            }
            elementList.add(element);
            positionList.add(point);
            ++i;
        }
    }

    public Rectangle2D getSelectedVectorRepaint() {
        Rectangle2D.Double rect = null;
        int i = 0;
        while (i < this.selectedVector.size()) {
            GElement element = (GElement)this.selectedVector.get(i);
            rect = GUtil.union(element.getRepaintBounds(), rect);
            ++i;
        }
        return rect;
    }

    public Rectangle2D getRepaintArea() {
        return this.repaintArea;
    }

    public void setRepaintArea(Rectangle2D repaintArea) {
        this.repaintArea = repaintArea;
    }

    public boolean isMoveMode() {
        return this.moveMode;
    }

    public void setMoveMode(boolean moveMode) {
        this.moveMode = moveMode;
        if (!moveMode) {
            this.moveLinkList.clear();
        }
    }

    public boolean isLinkMoveMode() {
        return this.linkMoveMode;
    }

    public void setLinkMoveMode(boolean linkMoveMode) {
        this.linkMoveMode = linkMoveMode;
    }

    public boolean isSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(boolean selectMode) {
        this.selectMode = selectMode;
    }

    public List getMoveLinkList() {
        return this.moveLinkList;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D.Double bounds = null;
        bounds = GUtil.union(this.getBoundingBox(this.containers), bounds);
        bounds = GUtil.union(this.getBoundingBox(this.containeratoms), bounds);
        bounds = GUtil.union(this.getBoundingBox(this.atoms), bounds);
        bounds = GUtil.union(this.getBoundingBox(this.links), bounds);
        return bounds;
    }

    private Rectangle2D getBoundingBox(List list) {
        Rectangle2D.Double bounds = null;
        int i = 0;
        while (i < list.size()) {
            GElement e = (GElement)list.get(i);
            bounds = GUtil.union(e.getBounds(), bounds);
            ++i;
        }
        return bounds;
    }

    public void setElementBounds(GElement element, Rectangle2D bounds) {
        if (element instanceof GFramed) {
            GFramed framed = (GFramed)((Object)element);
            framed.setFramePosition(bounds.getX(), bounds.getY());
            framed.setFrameSize(bounds.getWidth(), bounds.getHeight());
            if (element instanceof GGroup) {
                Vector v = ((GGroup)element).getMembers();
                ((GGroup)element).setMembers(v);
            }
            if (element instanceof GContainableAtom) {
                ((GContainableAtom)element).update2();
            } else {
                element.update();
            }
        }
    }

    public void updateReactionTargetsCallbyAutoLayerout(ReactionLink l, List lst0, List lst1) {
        try {
            if (l.getGLinkedShape() instanceof LinkedLineComplex3) {
                GLinkedLineIndex gIdx1;
                GLinkPositionInfo gInfo1;
                GLinkedLineIndex gIdx0;
                GLinkPositionInfo gInfo0;
                if (lst0.get(0) instanceof GLinkPositionInfo) {
                    gInfo0 = (GLinkPositionInfo)lst0.get(0);
                    l.setTargetAt(l.getTargetAt(0), 0, gInfo0);
                } else if (lst0.get(0) instanceof GLinkedLineIndex) {
                    gIdx0 = (GLinkedLineIndex)lst0.get(0);
                    l.setTargetAt(l.getTargetAt(0), 0, gIdx0);
                } else {
                    l.setTargetAt(l.getTargetAt(0), 0, (GLinkPositionInfo)null);
                }
                if (lst0.size() == 2) {
                    if (lst0.get(1) instanceof GLinkPositionInfo) {
                        gInfo1 = (GLinkPositionInfo)lst0.get(1);
                        l.setTargetAt(l.getTargetAt(1), 1, gInfo1);
                    } else if (lst0.get(1) instanceof GLinkedLineIndex) {
                        gIdx1 = (GLinkedLineIndex)lst0.get(1);
                        l.setTargetAt(l.getTargetAt(1), 1, gIdx1);
                    } else {
                        l.setTargetAt(l.getTargetAt(1), 1, (GLinkPositionInfo)null);
                    }
                    if (lst1.get(0) instanceof GLinkPositionInfo) {
                        gInfo1 = (GLinkPositionInfo)lst1.get(0);
                        l.setTargetAt(l.getTargetAt(2), 2, gInfo1);
                    } else if (lst1.get(0) instanceof GLinkedLineIndex) {
                        gIdx1 = (GLinkedLineIndex)lst1.get(0);
                        l.setTargetAt(l.getTargetAt(2), 2, gIdx1);
                    } else {
                        l.setTargetAt(l.getTargetAt(2), 2, (GLinkPositionInfo)null);
                    }
                } else if (lst1.size() == 2) {
                    if (lst1.get(0) instanceof GLinkPositionInfo) {
                        gInfo0 = (GLinkPositionInfo)lst1.get(0);
                        l.setTargetAt(l.getTargetAt(1), 1, gInfo0);
                    } else if (lst1.get(0) instanceof GLinkedLineIndex) {
                        gIdx0 = (GLinkedLineIndex)lst1.get(0);
                        l.setTargetAt(l.getTargetAt(1), 1, gIdx0);
                    } else {
                        l.setTargetAt(l.getTargetAt(1), 1, (GLinkPositionInfo)null);
                    }
                    if (lst1.get(1) instanceof GLinkPositionInfo) {
                        gInfo1 = (GLinkPositionInfo)lst1.get(1);
                        l.setTargetAt(l.getTargetAt(2), 2, gInfo1);
                    } else if (lst1.get(1) instanceof GLinkedLineIndex) {
                        gIdx1 = (GLinkedLineIndex)lst1.get(1);
                        l.setTargetAt(l.getTargetAt(2), 2, gIdx1);
                    } else {
                        l.setTargetAt(l.getTargetAt(2), 2, (GLinkPositionInfo)null);
                    }
                }
            } else {
                if (lst0 != null) {
                    if (lst0.get(0) instanceof GLinkPositionInfo) {
                        GLinkPositionInfo gInfo0 = (GLinkPositionInfo)lst0.get(0);
                        l.setTargetAt(l.getTargetAt(0), 0, gInfo0);
                    } else if (lst0.get(0) instanceof GLinkedLineIndex) {
                        GLinkedLineIndex gIdx0 = (GLinkedLineIndex)lst0.get(0);
                        l.setTargetAt(l.getTargetAt(0), 0, gIdx0);
                    } else {
                        l.setTargetAt(l.getTargetAt(0), 0, (GLinkPositionInfo)null);
                    }
                }
                if (lst1 != null) {
                    if (lst1.get(0) instanceof GLinkPositionInfo) {
                        GLinkPositionInfo gInfo1 = (GLinkPositionInfo)lst1.get(0);
                        l.setTargetAt(l.getTargetAt(1), 1, gInfo1);
                    } else if (lst1.get(0) instanceof GLinkedLineIndex) {
                        GLinkedLineIndex gIdx1 = (GLinkedLineIndex)lst1.get(0);
                        l.setTargetAt(l.getTargetAt(1), 1, gIdx1);
                    } else {
                        l.setTargetAt(l.getTargetAt(1), 1, (GLinkPositionInfo)null);
                    }
                }
            }
            l.update();
        }
        catch (Exception e) {
            return;
        }
    }

    public void setLinkPosition(GLink link, int connectPolicy, List creasePoint, List positionInfo, Point2D midCreasePoint) {
        GLinkedShape shape = link.getGLinkedShape();
        if (shape instanceof GLinkedCreaseLine) {
            GLinkedCreaseLine line = (GLinkedCreaseLine)shape;
            line.removeCreasePoint(this);
            try {
                int i = 0;
                while (i < positionInfo.size()) {
                    Object obj = positionInfo.get(i);
                    if (obj instanceof GLinkPositionInfo) {
                        link.setTargetAt(link.getTargetAt(i), i, (GLinkPositionInfo)((GLinkPositionInfo)obj).clone());
                    } else if (obj instanceof GLinkedLineIndex) {
                        link.setTargetAt(link.getTargetAt(i), i, ((GLinkedLineIndex)obj).createCopy());
                    } else if (obj instanceof GLinkTarget) {
                        link.setTargetAt((GLinkTarget)obj, i, (GLinkPositionInfo)null);
                    }
                    ++i;
                }
                i = 0;
                while (i < creasePoint.size()) {
                    GCreasePointForUndo undo = (GCreasePointForUndo)creasePoint.get(i);
                    ((GLinkedCreaseLine)undo.getOriginal().getOwner()).addCreasePointWithoutNotify(undo.getOriginal(), this, i);
                    ++i;
                }
                line.setConnectPolicy(connectPolicy);
                if (connectPolicy == 1) {
                    line.initLinesDirection();
                }
            }
            catch (Exception i) {}
        } else if (shape instanceof GLinkedLineComplex3) {
            GLinkedLineComplex3 line = (GLinkedLineComplex3)shape;
            line.removeCreasePoint(this);
            try {
                int i22 = 0;
                while (i22 < positionInfo.size()) {
                    Object obj = positionInfo.get(i22);
                    if (obj instanceof GLinkPositionInfo) {
                        link.setTargetAt(link.getTargetAt(i22), i22, (GLinkPositionInfo)((GLinkPositionInfo)obj).clone());
                    } else if (obj instanceof GLinkedLineIndex) {
                        link.setTargetAt(link.getTargetAt(i22), i22, ((GLinkedLineIndex)obj).createCopy());
                    } else if (obj instanceof GLinkTarget) {
                        link.setTargetAt((GLinkTarget)obj, i22, (GLinkPositionInfo)null);
                    }
                    ++i22;
                }
                try {
                    line.setMidCreasePoint(midCreasePoint.getX(), midCreasePoint.getY());
                }
                catch (Exception i22) {
                    // empty catch block
                }
                int i = 0;
                while (i < creasePoint.size()) {
                    GCreasePointForUndo undo = (GCreasePointForUndo)creasePoint.get(i);
                    this.addElement(undo, false);
                    ++i;
                }
                line.setConnectPolicy(connectPolicy);
                if (connectPolicy == 1) {
                    line.initLinesDirection();
                }
            }
            catch (Exception i) {}
        } else if (shape instanceof GLinkedCurveAndLine) {
            GLinkedCurveAndLine line = (GLinkedCurveAndLine)shape;
            try {
                int i = 0;
                while (i < positionInfo.size()) {
                    Object obj = positionInfo.get(i);
                    if (obj instanceof GLinkPositionInfo) {
                        link.setTargetAt(link.getTargetAt(i), i, (GLinkPositionInfo)((GLinkPositionInfo)obj).clone());
                    } else if (obj instanceof GLinkedLineIndex) {
                        link.setTargetAt(link.getTargetAt(i), i, ((GLinkedLineIndex)obj).createCopy());
                    } else if (obj instanceof GLinkTarget) {
                        link.setTargetAt((GLinkTarget)obj, i, (GLinkPositionInfo)null);
                    }
                    ++i;
                }
            }
            catch (Exception i) {}
        } else if (shape instanceof GLogicGate) {
            GLogicGate gate = (GLogicGate)shape;
            LinkedCreaseLine line = gate.getRealLine();
            line.removeCreasePoint(this);
            try {
                int i = 0;
                while (i < positionInfo.size()) {
                    Object obj = positionInfo.get(i);
                    if (obj instanceof GLinkPositionInfo) {
                        link.setTargetAt(link.getTargetAt(i), i, (GLinkPositionInfo)((GLinkPositionInfo)obj).clone());
                    } else if (obj instanceof GLinkedLineIndex) {
                        link.setTargetAt(link.getTargetAt(i), i, ((GLinkedLineIndex)obj).createCopy());
                    } else if (obj instanceof GLinkTarget) {
                        link.setTargetAt((GLinkTarget)obj, i, (GLinkPositionInfo)null);
                    }
                    ++i;
                }
                i = 0;
                while (i < creasePoint.size()) {
                    GCreasePointForUndo undo = (GCreasePointForUndo)creasePoint.get(i);
                    GEditable own = undo.getOriginal().getOwner();
                    if (own instanceof GLogicGate) {
                        LinkedCreaseLine cl = ((GLogicGate)own).getRealLine();
                        cl.addCreasePointWithoutNotify(undo.getOriginal(), this, i);
                    } else if (own instanceof GLinkedCreaseLine) {
                        ((GLinkedCreaseLine)own).addCreasePointWithoutNotify(undo.getOriginal(), this, i);
                    }
                    ++i;
                }
                gate.setConnectPolicy(connectPolicy);
                if (connectPolicy == 1) {
                    gate.initLinesDirection();
                }
                this.setGateHeadPosition(gate, new Point2D.Double(line.start.x, line.start.y));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setGateHeadPosition(GLogicGate gate, Point2D headPoint) {
        gate.getHeaderPoint().setPosition((Point2D.Double)headPoint);
        gate.getHeaderPoint().setLocalPosition((Point2D.Double)headPoint);
    }

    private void changeComplexOrder(ComplexSpeciesAlias complex1, ComplexSpeciesAlias complex2) {
        boolean posBoolean;
        if (this.containeratoms == null) {
            return;
        }
        if (!this.containeratoms.contains(complex1)) {
            return;
        }
        if (!this.containeratoms.contains(complex2)) {
            return;
        }
        Point2D.Double size1 = complex1.getFrameSize();
        Point2D.Double size2 = complex2.getFrameSize();
        int pos1 = this.containeratoms.indexOf(complex1);
        int pos2 = this.containeratoms.indexOf(complex2);
        boolean sizeBoolean = size1.x * size1.y <= size2.x * size2.y;
        boolean bl = posBoolean = pos1 >= pos2;
        if (sizeBoolean ^ posBoolean) {
            this.containeratoms.insertElementAt(complex2, pos1);
            this.containeratoms.removeElementAt(pos1 + 1);
            this.containeratoms.insertElementAt(complex1, pos2);
            this.containeratoms.removeElementAt(pos2 + 1);
        }
    }

    public void changeComplexOrder(GElement element, Rectangle2D rect) {
        if (!(element instanceof ComplexSpeciesAlias)) {
            return;
        }
        if (this.containeratoms == null) {
            return;
        }
        if (!this.containeratoms.contains(element)) {
            return;
        }
        Vector<ComplexSpeciesAlias> comparedComplexes = new Vector<ComplexSpeciesAlias>();
        int size = this.containeratoms.size();
        int k = 0;
        while (k < size) {
            ComplexSpeciesAlias complex = (ComplexSpeciesAlias)this.containeratoms.get(k);
            if (complex.equals(element)) {
                ++k;
                continue;
            }
            if (comparedComplexes.contains(complex)) {
                ++k;
                continue;
            }
            if (complex.getCurrentView() == 3) {
                ++k;
                continue;
            }
            if (complex.getFrameBounds().intersects(rect)) {
                this.changeComplexOrder((ComplexSpeciesAlias)element, complex);
                comparedComplexes.add(complex);
                k = 0;
                continue;
            }
            ++k;
        }
    }

    public void changeComplexOrder(ComplexSpeciesAlias complex1, ComplexSpeciesAlias complex2, boolean complex1AboveComplex2) {
        int pos2;
        boolean posBoolean;
        if (this.containeratoms == null) {
            return;
        }
        if (!this.containeratoms.contains(complex1)) {
            return;
        }
        if (!this.containeratoms.contains(complex2)) {
            return;
        }
        int pos1 = this.containeratoms.indexOf(complex1);
        boolean bl = posBoolean = pos1 > (pos2 = this.containeratoms.indexOf(complex2));
        if (complex1AboveComplex2 ^ posBoolean) {
            this.containeratoms.insertElementAt(complex2, pos1);
            this.containeratoms.removeElementAt(pos1 + 1);
            this.containeratoms.insertElementAt(complex1, pos2);
            this.containeratoms.removeElementAt(pos2 + 1);
        }
    }

    private Vector getChildrenComplexesWithOrder(ComplexSpeciesAlias parent) {
        Vector<ComplexSpeciesAlias> allComplexes = new Vector<ComplexSpeciesAlias>();
        Vector target = parent.getTargets();
        int size = target.size();
        int i = 0;
        while (i < size) {
            boolean remove = false;
            if (target.elementAt(i) instanceof ComplexSpeciesAlias) {
                if (!this.getContainableAtoms().contains(target.elementAt(i))) {
                    remove = true;
                }
            } else {
                remove = true;
            }
            if (remove) {
                target.removeElementAt(i);
            } else {
                ++i;
            }
            size = target.size();
        }
        if (parent.getCurrentView() == 1 || parent.getCurrentView() == 3) {
            allComplexes.add(parent);
            i = 0;
            while (i < size) {
                allComplexes.addAll(this.getChildrenComplexesWithOrder((ComplexSpeciesAlias)target.elementAt(i)));
                ++i;
            }
        } else {
            i = 0;
            while (i < size) {
                allComplexes.addAll(this.getChildrenComplexesWithOrder((ComplexSpeciesAlias)target.elementAt(i)));
                ++i;
            }
            allComplexes.add(parent);
        }
        return allComplexes;
    }

    public void changeComplexOrder(ComplexSpeciesAlias parent) {
        Vector allComplexes = this.getChildrenComplexesWithOrder(parent);
        int size = allComplexes.size();
        int[] positions = new int[size];
        int j = 0;
        while (j < size) {
            positions[j] = this.getContainableAtoms().indexOf(allComplexes.elementAt(j));
            ++j;
        }
        Arrays.sort(positions);
        j = 0;
        while (j < size) {
            this.getContainableAtoms().insertElementAt(allComplexes.elementAt(size - j - 1), positions[j]);
            this.getContainableAtoms().removeElementAt(positions[j] + 1);
            ++j;
        }
    }

    private void clearComplexContainer(ComplexSpeciesAlias complex) {
        if (complex.getCurrentView() == 1 || complex.getCurrentView() == 3) {
            return;
        }
        Vector targets = complex.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            GContainerTarget gcontainertarget = (GContainerTarget)targets.elementAt(i);
            GContainer gcontainer = this.getOutside(gcontainertarget);
            if (gcontainer == null) {
                this.clearContainerOf(gcontainertarget);
                complex.removeTarget(gcontainertarget);
            } else if (gcontainer != complex) {
                GStructure.setContainerTarget(gcontainer, gcontainertarget);
                complex.removeTarget(gcontainertarget);
            }
            if (targets.elementAt(i) instanceof ComplexSpeciesAlias) {
                this.clearComplexContainer((ComplexSpeciesAlias)targets.elementAt(i));
            } else if (targets.elementAt(i) instanceof GContainer) {
                this.clearContainer((GContainer)targets.elementAt(i));
            }
            ++i;
        }
    }

    public void callbyuserRepaint(Rectangle2D area) {
        if (area == null) {
            return;
        }
        this.notifyRepaint(area);
    }

    public Rectangle2D repaintLinkandAllLinksWhichlinkingtome(GLink ME, boolean bPaint) {
        return this.repaintLinkandAllLinksWhichlinkingtome(ME, true, bPaint);
    }

    public Rectangle2D repaintLinkandAllLinksWhichlinkingtome(GLink ME, boolean updateLink, boolean bPaint) {
        if (!(ME instanceof ReactionLink)) {
            return null;
        }
        try {
            Rectangle2D updateRect = ME.update();
            Vector musttoUpdateLinks = this.getReactionLinksWhichislinkingtoME((ReactionLink)ME);
            int i = 0;
            while (i < musttoUpdateLinks.size()) {
                Vector vObjs = (Vector)musttoUpdateLinks.get(i);
                int j = 0;
                while (j < vObjs.size()) {
                    ReactionLink sonLink = (ReactionLink)vObjs.get(j);
                    updateRect = updateLink ? GUtil.union(updateRect, sonLink.update()) : GUtil.union(updateRect, sonLink.getRepaintBounds());
                    ++j;
                }
                ++i;
            }
            if (bPaint) {
                this.callbyuserRepaint(updateRect);
            }
            return updateRect;
        }
        catch (Exception myErr) {
            return new Rectangle2D.Double();
        }
    }

    public void repaintLinkandAllLinksWhichlinkingtome(ReactionLink ME) {
        this.repaintLinkandAllLinksWhichlinkingtome(ME, true, true);
    }

    public void repaintLinkandAllLinksWhichlinkingtome(GLinkedLineComplex3 shape) {
        if (shape == null) {
            return;
        }
        if (!(shape instanceof GLinkedLineComplex3)) {
            return;
        }
        this.repaintLinkandAllLinksWhichlinkingtome((ReactionLink)shape.getReactionLink(this));
    }

    public Vector getReactionLinksWhichislinkingtoME(ReactionLink ME) {
        Vector vGates = new Vector();
        Vector vReactants = new Vector();
        Vector vProductors = new Vector();
        Vector vModifications = new Vector();
        Vector vOthers = new Vector();
        Vector rtn = new Vector();
        if (ME == null) {
            return rtn;
        }
        if (!ME.isBaseLink()) {
            return rtn;
        }
        Vector vLinks = this.getLinks();
        int i = 0;
        while (i < vLinks.size()) {
            GLink link = (GLink)vLinks.get(i);
            GLinkedShape shape = link.getGLinkedShape();
            if (shape instanceof GLogicGate) {
                this.addLinkWhenTargetisME(vGates, link, ME);
            } else if (shape instanceof AddReactant) {
                this.addLinkWhenTargetisME(vReactants, link, ME);
            } else if (shape instanceof AddProduct) {
                this.addLinkWhenTargetisME(vProductors, link, ME);
            } else if (GLogicGate.isModification(shape)) {
                this.addLinkWhenTargetisME(vModifications, link, ME);
            } else {
                this.addLinkWhenTargetisME(vOthers, link, ME);
            }
            ++i;
        }
        rtn.add(vGates);
        rtn.add(vReactants);
        rtn.add(vProductors);
        rtn.add(vModifications);
        rtn.add(vOthers);
        return rtn;
    }

    private void addLinkWhenTargetisME(Vector vect, GLink link, ReactionLink ME) {
        try {
            int j = 0;
            while (j < link.getTargets().length) {
                GLinkTarget target = link.getTargetAt(j);
                if (target == ME) {
                    vect.add(link);
                    break;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getGatesWhichislinkingtoME(ReactionLink ME) {
        return (Vector)this.getReactionLinksWhichislinkingtoME(ME).get(0);
    }

    public Vector getReactantsWhichislinkingtoME(ReactionLink ME) {
        return (Vector)this.getReactionLinksWhichislinkingtoME(ME).get(1);
    }

    public Vector getProductorWhichislinkingtoME(ReactionLink ME) {
        return (Vector)this.getReactionLinksWhichislinkingtoME(ME).get(2);
    }

    public Vector getModificationsWhichislinkingtoME(ReactionLink ME) {
        return (Vector)this.getReactionLinksWhichislinkingtoME(ME).get(3);
    }

    public ReactionLink getBaseLinkOf(ReactionLink rlink) {
        if (rlink == null) {
            return null;
        }
        if (rlink.isBaseLink()) {
            return rlink;
        }
        try {
            int l = 0;
            while (l < this.links.size()) {
                ReactionLink rlinktemp = (ReactionLink)this.links.get(l);
                if (rlinktemp.isBaseLink()) {
                    Vector subLinks = this.getReactionLinksWhichislinkingtoME(rlinktemp);
                    int m = 0;
                    while (m < subLinks.size()) {
                        Vector vObjs = (Vector)subLinks.get(m);
                        int n = 0;
                        while (n < vObjs.size()) {
                            ReactionLink sonLink = (ReactionLink)vObjs.get(n);
                            if (sonLink == rlink) {
                                return rlinktemp;
                            }
                            ++n;
                        }
                        ++m;
                    }
                }
                ++l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public GElement getEventAvailableNeastNodeFrom(GElement gelement) {
        if (gelement == null) {
            return gelement;
        }
        if (!(gelement instanceof ElementSpeciesAlias) && !(gelement instanceof ComplexSpeciesAlias)) {
            return gelement;
        }
        GContainer container = null;
        if (gelement instanceof ComplexSpeciesAlias) {
            container = ((ComplexSpeciesAlias)gelement).getContainer();
        } else if (gelement instanceof ElementSpeciesAlias) {
            container = ((ElementSpeciesAlias)gelement).getContainer();
        }
        if (container == null || !(container instanceof ComplexSpeciesAlias)) {
            return gelement;
        }
        Vector<GContainer> parentNodes = new Vector<GContainer>();
        parentNodes.add(container);
        this.foundAllParentComplexNodes((ComplexSpeciesAlias)container, parentNodes);
        int cnt = 0;
        int i = 0;
        while (i < parentNodes.size()) {
            ComplexSpeciesAlias cmp = (ComplexSpeciesAlias)parentNodes.get(i);
            if (cmp.getCurrentView() == -1 || cmp.getCurrentView() == 1 || cmp.getCurrentView() == 3) {
                ++cnt;
            }
            ++i;
        }
        if (cnt == 0) {
            return gelement;
        }
        ComplexSpeciesAlias rtn = null;
        int i2 = 0;
        while (i2 < parentNodes.size()) {
            ComplexSpeciesAlias cmp = (ComplexSpeciesAlias)parentNodes.get(i2);
            if (cmp.getCurrentView() == 0 || cmp.getCurrentView() == 1 || cmp.getCurrentView() == 2) {
                rtn = cmp;
                break;
            }
            ++i2;
        }
        return rtn;
    }

    public Vector foundAllParentComplexNodes(ComplexSpeciesAlias complex, Vector v) {
        if (complex.getContainer() != null && complex.getContainer() instanceof ComplexSpeciesAlias) {
            v.add((ComplexSpeciesAlias)complex.getContainer());
            return this.foundAllParentComplexNodes((ComplexSpeciesAlias)complex.getContainer(), v);
        }
        return v;
    }

    public Vector getAllDirectSingleLineLinks() {
        Vector rtn = new Vector();
        if (this.links == null) {
            return rtn;
        }
        int i = 0;
        while (i < this.links.size()) {
            GLinkedShape lnkshp = ((GLink)this.links.get(i)).getGLinkedShape();
            if (lnkshp instanceof DirectSingleLine) {
                rtn.add(this.links.get(i));
            }
            ++i;
        }
        return rtn;
    }

    public Vector getAllDirectSingleLineLinksTo(Object targetAlias) {
        Vector<GLink> rtn = new Vector<GLink>();
        if (this.links == null) {
            return rtn;
        }
        if (targetAlias == null) {
            return rtn;
        }
        if (!(targetAlias instanceof ElementSpeciesAlias) && !(targetAlias instanceof ComplexSpeciesAlias)) {
            return rtn;
        }
        Vector allDirectSingleLineLinks = this.getAllDirectSingleLineLinks();
        int i = 0;
        while (i < allDirectSingleLineLinks.size()) {
            GLink link = (GLink)allDirectSingleLineLinks.get(i);
            GLinkTarget linktarget = null;
            try {
                linktarget = link.getTargetAt(1);
            }
            catch (Exception e) {
                linktarget = null;
            }
            if (linktarget != null && linktarget == targetAlias) {
                rtn.add(link);
            }
            ++i;
        }
        return rtn;
    }

    public Rectangle2D repaintAllDirectSingleLineLinks(boolean bPaint) {
        try {
            Rectangle2D.Double updateRect = null;
            Vector allLinks = this.getAllDirectSingleLineLinks();
            if (allLinks == null) {
                return new Rectangle2D.Double();
            }
            int i = 0;
            while (i < allLinks.size()) {
                ReactionLink aLink = (ReactionLink)allLinks.get(i);
                updateRect = GUtil.union(updateRect, aLink.update());
                ++i;
            }
            if (bPaint) {
                this.callbyuserRepaint(updateRect);
            }
            return updateRect;
        }
        catch (Exception myErr) {
            return new Rectangle2D.Double();
        }
    }

    public boolean isSourceOfDirectSingleLine(ElementSpeciesAlias alias) {
        SpeciesSymbol sbm;
        if (alias == null) {
            return false;
        }
        if (this.links == null) {
            return false;
        }
        GFramedShape gfshp = alias.getGFramedShape();
        if (gfshp instanceof MonoSpeciesShape && (sbm = ((MonoSpeciesShape)gfshp).getSpeciesSymbol()) instanceof Tag) {
            int i = 0;
            while (i < this.links.size()) {
                GLinkedShape lnkshp = ((GLink)this.links.get(i)).getGLinkedShape();
                if (lnkshp instanceof DirectSingleLine) {
                    try {
                        if (((GLink)this.links.get(i)).getTargetAt(0) == alias) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public Vector getSameIDAndViewComplexAlias(ComplexSpeciesAlias csa) {
        Vector<ComplexSpeciesAlias> sameIDAndViewComplex = new Vector<ComplexSpeciesAlias>();
        Vector sameIDComplexAlias = this.getSameIDComplex(csa);
        int i = 0;
        while (i < sameIDComplexAlias.size()) {
            ComplexSpeciesAlias tmpCsa = (ComplexSpeciesAlias)sameIDComplexAlias.get(i);
            if (tmpCsa.getCurrentView() == csa.getCurrentView()) {
                sameIDAndViewComplex.add(tmpCsa);
            }
            ++i;
        }
        return sameIDAndViewComplex;
    }

    public Vector getSameIDComplex(ComplexSpeciesAlias csa) {
        Vector<ComplexSpeciesAlias> sameIDComplex = new Vector<ComplexSpeciesAlias>();
        int i = 0;
        while (i < this.containeratoms.size()) {
            ComplexSpeciesAlias tmpCsa;
            if (this.containeratoms.get(i) instanceof ComplexSpeciesAlias && (tmpCsa = (ComplexSpeciesAlias)this.containeratoms.get(i)).getOriginalSpecies().getId().equals(csa.getOriginalSpecies().getId())) {
                sameIDComplex.add(tmpCsa);
            }
            ++i;
        }
        return sameIDComplex;
    }

    public Vector getSameIDElementSpeciesAliases(ElementSpeciesAlias sa) {
        Vector<ElementSpeciesAlias> sameIDElementSpeciesAliases = new Vector<ElementSpeciesAlias>();
        int i = 0;
        while (i < this.atoms.size()) {
            ElementSpeciesAlias tmpSa;
            if (this.atoms.get(i) instanceof ElementSpeciesAlias && (tmpSa = (ElementSpeciesAlias)this.atoms.get(i)).getOriginalSpecies().getId().equals(sa.getOriginalSpecies().getId())) {
                sameIDElementSpeciesAliases.add(tmpSa);
            }
            ++i;
        }
        return sameIDElementSpeciesAliases;
    }

    public static final Point2D.Double makeGElementLeftTopPointInDrawAreaDimension(Dimension dimsion, GElement gElement, Point2D.Double inputPnt, Dimension drawareaDimsion) {
        Dimension imageSize;
        double newY;
        double newX;
        block15: {
            if (dimsion == null) {
                return inputPnt;
            }
            if (gElement == null) {
                return inputPnt;
            }
            if (inputPnt == null) {
                return inputPnt;
            }
            if (drawareaDimsion == null) {
                return inputPnt;
            }
            newX = inputPnt.x;
            newY = inputPnt.y;
            imageSize = null;
            try {
                if (gElement instanceof NameImage) {
                    imageSize = ((NameImage)gElement).getNameImageSize();
                    break block15;
                }
                if (gElement instanceof ClosedCompartmentAlias) {
                    Rectangle2D.Double myBounds = ((ClosedCompartmentAlias)gElement).getFrameBounds();
                    imageSize = new Dimension((int)myBounds.width, (int)myBounds.height);
                    break block15;
                }
                return inputPnt;
            }
            catch (Exception myErr) {
                return inputPnt;
            }
        }
        Dimension realImageSize = (Dimension)imageSize.clone();
        if (gElement instanceof NameImage) {
            if (imageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
                imageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
            }
        } else {
            boolean cfr_ignored_0 = gElement instanceof ClosedCompartmentAlias;
        }
        Dimension movableImageSize = (Dimension)imageSize.clone();
        double dMinX = 0.0;
        double dMaxX = dimsion.getWidth() - (double)realImageSize.width;
        double dMinY = 0.0;
        double dMaxY = dimsion.getHeight() - (double)realImageSize.height;
        if (newX > dMaxX) {
            newX = dMaxX;
        }
        if (newX < dMinX) {
            newX = dMinX;
        }
        if (newY > dMaxY) {
            newY = dMaxY;
        }
        if (newY < dMinY) {
            newY = dMinY;
        }
        return new Point2D.Double(newX, newY);
    }

    public static final Point2D.Double makePointInDrawAreaDimension(Dimension dimsion, Point2D.Double inputPnt) {
        if (dimsion == null) {
            return inputPnt;
        }
        if (inputPnt == null) {
            return inputPnt;
        }
        double newX = inputPnt.x;
        double newY = inputPnt.y;
        double dMinX = 0.0;
        double dMaxX = dimsion.getWidth();
        double dMinY = 0.0;
        double dMaxY = dimsion.getHeight();
        if (newX > dMaxX) {
            newX = dMaxX;
        }
        if (newX < dMinX) {
            newX = dMinX;
        }
        if (newY > dMaxY) {
            newY = dMaxY;
        }
        if (newY < dMinY) {
            newY = dMinY;
        }
        return new Point2D.Double(newX, newY);
    }

    public boolean isHaveCannotbeMovedCompartment(Rectangle2D editSize, GElement movingelement, double mouseDownX, double mouseDownY, double newX, double newY) {
        boolean rtn = false;
        Point2D.Double pos = GStructure.getPosition(movingelement);
        double dNewDX = newX - ((Point2D)pos).getX();
        double dNewDY = newY - ((Point2D)pos).getY();
        Vector<GElement> vecSelecteds = new Vector<GElement>();
        if (movingelement != null) {
            vecSelecteds.add(movingelement);
        }
        if (this.getSelecteds() != null) {
            vecSelecteds.addAll(this.getSelecteds());
        }
        int i = 0;
        while (i < vecSelecteds.size()) {
            ClosedCompartmentAlias cmpt;
            Rectangle2D.Double oldfrmpos;
            Rectangle2D.Double newmaxfrmpos;
            if (vecSelecteds.elementAt(i) instanceof ClosedCompartmentAlias && !editSize.contains(newmaxfrmpos = new Rectangle2D.Double((oldfrmpos = (cmpt = (ClosedCompartmentAlias)vecSelecteds.elementAt(i)).getCompartmentMaxRepaintBounds()).getBounds().getX() + dNewDX, oldfrmpos.getBounds().getY() + dNewDY, oldfrmpos.getBounds().getWidth(), oldfrmpos.getBounds().getHeight()))) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    private void doingSomethingBeforeDraw() {
        this.resetCurrentInformationShowersControlFrameStatus();
        this.resetPaintSymbolFrameUsingSpecifiedColorFlg(false);
    }

    public void reconfirmSameIDAutoTagNeedToPaint() {
        Vector vectMembersgroup = this.divideSpeciesIntoGroupsBySameSID();
        this.confirm25PercentShadeNeedToDraw((Vector)vectMembersgroup.get(0));
        this.confirm25PercentShadeNeedToDraw((Vector)vectMembersgroup.get(1));
        this.confirm25PercentShadeInComplexNeedNotToDraw((Vector)vectMembersgroup.get(1));
    }

    private Vector divideSpeciesIntoGroupsBySameSID() {
        SpeciesAlias alias;
        int i;
        Vector vectMembersgroup = new Vector();
        Vector vectAtomMembersgroup = new Vector();
        Vector vectContaineratomMembersgroup = new Vector();
        if (this.atoms != null) {
            i = 0;
            while (i < this.atoms.size()) {
                alias = (SpeciesAlias)this.atoms.get(i);
                this.joinintoGroupOfSameSpeciesID(vectAtomMembersgroup, alias);
                ++i;
            }
        }
        if (this.containeratoms != null) {
            i = 0;
            while (i < this.containeratoms.size()) {
                alias = (SpeciesAlias)this.containeratoms.get(i);
                this.joinintoGroupOfSameSpeciesID(vectContaineratomMembersgroup, alias);
                ++i;
            }
        }
        vectMembersgroup.add(vectAtomMembersgroup);
        vectMembersgroup.add(vectContaineratomMembersgroup);
        return vectMembersgroup;
    }

    private void joinintoGroupOfSameSpeciesID(Vector groups, SpeciesAlias alias) {
        if (groups == null) {
            return;
        }
        if (alias == null) {
            return;
        }
        if (alias.getOriginalSpecies() == null) {
            return;
        }
        SpeciesShape shape = (SpeciesShape)((Object)alias.getGFramedShape());
        String strCurrOrgID = alias.getOriginalSpecies().getId();
        String strCurrType = ((MonoSpeciesProperty)shape.getProperty()).getType();
        if (strCurrOrgID == null || strCurrType == null) {
            return;
        }
        GroupOfSameSpeciesID group = null;
        int j = 0;
        while (j < groups.size()) {
            GroupOfSameSpeciesID groupTmp = (GroupOfSameSpeciesID)groups.get(j);
            if (groupTmp.getSID().equals(strCurrOrgID) && groupTmp.getTYPE().equals(strCurrType)) {
                group = groupTmp;
                break;
            }
            ++j;
        }
        if (group == null) {
            GroupOfSameSpeciesID newgroup = new GroupOfSameSpeciesID();
            newgroup.setSID(strCurrOrgID);
            newgroup.setType(strCurrType);
            newgroup.addMember(alias);
            groups.add(newgroup);
        } else {
            group.getMEMBERS().add(alias);
        }
    }

    private void confirmSpeciesTagNeedToDraw(Vector groups) {
        int i = 0;
        while (i < groups.size()) {
            block10: {
                Vector members;
                String strSID;
                block11: {
                    GroupOfSameSpeciesID group = (GroupOfSameSpeciesID)groups.get(i);
                    String type = group.getTYPE();
                    if (!"PROTEIN".equals(type) && !"COMPLEX".equals(type) && !"COMPLEX_PACKED".equals(type)) break block10;
                    strSID = group.getSID();
                    members = group.getMEMBERS();
                    if (members.size() <= 0) break block10;
                    if (members.size() != 1) break block11;
                    SpeciesAlias alias = (SpeciesAlias)members.get(0);
                    MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
                    Vector shapes = shape.getMShapes();
                    if (shapes == null) break block10;
                    ModificationShape mAutoTagShape = null;
                    int k = 0;
                    while (k < shapes.size()) {
                        ModificationShape mShape = (ModificationShape)shapes.get(k);
                        if (mShape.getSameIDAutoTag() != null) {
                            mAutoTagShape = mShape;
                            break;
                        }
                        ++k;
                    }
                    if (mAutoTagShape == null) break block10;
                    mAutoTagShape.getSameIDAutoTag().setSID("");
                    mAutoTagShape.rebulidTagShape();
                    break block10;
                }
                int j = 0;
                while (j < members.size()) {
                    SpeciesAlias alias = (SpeciesAlias)members.get(j);
                    MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
                    Vector shapes = shape.getMShapes();
                    if (shapes == null) {
                        ModificationShape mShape = new ModificationShape();
                        mShape.setSpeciesSymbol(shape.getSpeciesSymbol());
                        shape.getSameIDAutoTag().setSID(strSID);
                        mShape.setSameIDAutoTag(shape.getSameIDAutoTag());
                        mShape.rebulidTagShape();
                        shape.addMShapesMember(mShape);
                    } else {
                        ModificationShape mAutoTagShape = null;
                        int k = 0;
                        while (k < shapes.size()) {
                            ModificationShape mShape = (ModificationShape)shapes.get(k);
                            if (mShape.getSameIDAutoTag() != null) {
                                mAutoTagShape = mShape;
                                break;
                            }
                            ++k;
                        }
                        if (mAutoTagShape == null) {
                            ModificationShape mShape = new ModificationShape();
                            mShape.setSpeciesSymbol(shape.getSpeciesSymbol());
                            shape.getSameIDAutoTag().setSID(strSID);
                            mShape.setSameIDAutoTag(shape.getSameIDAutoTag());
                            mShape.rebulidTagShape();
                            shape.addMShapesMember(mShape);
                        } else {
                            mAutoTagShape.getSameIDAutoTag().setSID(strSID);
                            mAutoTagShape.rebulidTagShape();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void confirm25PercentShadeNeedToDraw(Vector groups) {
        int i = 0;
        while (i < groups.size()) {
            Vector members = ((GroupOfSameSpeciesID)groups.get(i)).getMEMBERS();
            int speciesNum = members.size();
            boolean isShade = false;
            if (speciesNum > 1) {
                isShade = true;
            }
            int j = 0;
            while (j < speciesNum) {
                SpeciesSymbol sSymbol = ((MonoSpeciesShape)((SpeciesAlias)members.get(j)).getGFramedShape()).getSpeciesSymbol();
                if (sSymbol instanceof SpeciesShadeSymbol) {
                    if (isShade) {
                        ((SpeciesShadeSymbol)((Object)sSymbol)).setIsDrawShade(true);
                    } else {
                        ((SpeciesShadeSymbol)((Object)sSymbol)).setIsDrawShade(false);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void confirm25PercentShadeInComplexNeedNotToDraw(Vector groups) {
        try {
            int i = 0;
            while (i < groups.size()) {
                Vector members = ((GroupOfSameSpeciesID)groups.get(i)).getMEMBERS();
                int speciesNum = members.size();
                int j = 0;
                while (j < speciesNum) {
                    if (members.get(j) instanceof ComplexSpeciesAlias) {
                        SpeciesSymbol sSymbol = ((MonoSpeciesShape)((ComplexSpeciesAlias)members.get(j)).getGFramedShape()).getSpeciesSymbol();
                        Vector innerSpecies = ((ComplexSpeciesAlias)members.get(j)).getTargets();
                        if (innerSpecies != null) {
                            int k = 0;
                            while (innerSpecies.size() > 0 && k < innerSpecies.size()) {
                                SpeciesSymbol innerSymbol = ((MonoSpeciesShape)((SpeciesAlias)innerSpecies.get(k)).getGFramedShape()).getSpeciesSymbol();
                                if (innerSymbol instanceof SpeciesShadeSymbol) {
                                    ((SpeciesShadeSymbol)((Object)innerSymbol)).setIsDrawShade(false);
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getReactionLinksWhichislinkingtoME(PluginReaction ME) {
        Vector rtn = new Vector();
        if (ME == null) {
            return rtn;
        }
        return this.getReactionLinksWhichislinkingtoME(ME.getId());
    }

    public Vector getReactionLinksWhichislinkingtoME(String ME) {
        Vector rtn = new Vector();
        if (ME == null) {
            return rtn;
        }
        Vector vLinks = this.getLinks();
        if (vLinks == null || vLinks.size() == 0) {
            return rtn;
        }
        ReactionLink rlinkMe = null;
        int i = 0;
        while (i < vLinks.size()) {
            ReactionLink link = (ReactionLink)vLinks.get(i);
            if (link.isBaseLink() && link.getName().equals(ME)) {
                rlinkMe = link;
                break;
            }
            ++i;
        }
        if (rlinkMe == null) {
            return rtn;
        }
        return this.getReactionLinksWhichislinkingtoME(rlinkMe);
    }

    public ReactionLink getReactionLinkUsingPluginReaction(PluginReaction pReaction) {
        if (pReaction == null) {
            return null;
        }
        return this.getReactionLinkUsingPluginReaction(pReaction.getId());
    }

    public ReactionLink getReactionLinkUsingPluginReaction(String strReactionId) {
        if (strReactionId == null) {
            return null;
        }
        try {
            int i = 0;
            while (i < this.links.size()) {
                try {
                    ReactionLink link = (ReactionLink)this.links.get(i);
                    if (link.isBaseLink() && link.getParentReaction().getId().equals(strReactionId)) {
                        return link;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void drawShowers(Graphics2D g2, Rectangle2D clip, List elementList) {
        if (clip == null) {
            return;
        }
        if (g2 == null) {
            return;
        }
        if (elementList == null || elementList.size() == 0) {
            return;
        }
        int size = elementList.size();
        int i = 0;
        while (i < size) {
            Vector vectDisplayers;
            InformationShowerImpl shower = (InformationShowerImpl)elementList.get(i);
            if (shower.isVisible(null, this) && (vectDisplayers = shower.getListOfDisplayers()) != null && vectDisplayers.size() > 0) {
                this.draw(g2, clip, vectDisplayers);
            }
            ++i;
        }
    }

    public void resetPaintSymbolFrameUsingSpecifiedColorFlg(boolean resetToNormalStateAndColor) {
        boolean bControlledByCurrentInformationShowersControlFrame;
        boolean bl = bControlledByCurrentInformationShowersControlFrame = this.currentInformationShowersControlFrame != null && this.currentInformationShowersControlFrame.isVisible() && this.currentInformationShowersControlFrame.isEnabled();
        if (this.currentInformationShowersControlFrame instanceof MappingArrayMassShowerMainWinFrm) {
            boolean flag = ((MappingArrayMassShowerMainWinFrm)this.currentInformationShowersControlFrame).haveInputedData();
            boolean bl2 = bControlledByCurrentInformationShowersControlFrame = bControlledByCurrentInformationShowersControlFrame && flag;
        }
        if (resetToNormalStateAndColor || !bControlledByCurrentInformationShowersControlFrame) {
            SpeciesSymbolImpl symbol;
            MonoSpeciesShape monoshape;
            int j;
            if (this.atoms != null) {
                j = 0;
                while (j < this.atoms.size()) {
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)this.atoms.get(j)).getGFramedShape();
                    symbol = (SpeciesSymbolImpl)monoshape.getSpeciesSymbol();
                    symbol.setPaintSymbolFrameUsingSpecifiedColorFlg(false);
                    ++j;
                }
            }
            if (this.containeratoms != null) {
                j = 0;
                while (j < this.containeratoms.size()) {
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)this.containeratoms.get(j)).getGFramedShape();
                    symbol = (SpeciesSymbolImpl)monoshape.getSpeciesSymbol();
                    symbol.setPaintSymbolFrameUsingSpecifiedColorFlg(false);
                    ++j;
                }
            }
        }
    }

    public JFrame getCurrentInformationShowersControlFrame() {
        return this.currentInformationShowersControlFrame;
    }

    public void setCurrentInformationShowersControlFrame(JFrame frame) {
        this.currentInformationShowersControlFrame = frame;
    }

    public Vector getInformationShowers() {
        return this.informationShowers;
    }

    public void addInformationShower(InformationShowerImpl shower) {
        if (this.informationShowers == null) {
            this.informationShowers = new Vector();
        }
        this.informationShowers.add(shower);
    }

    public void removeInformationShower(InformationShowerImpl shower) {
        if (this.informationShowers == null || this.informationShowers.size() == 0) {
            return;
        }
        this.informationShowers.removeElement(shower);
    }

    public void removeInformationShower(JFrame jfrmShowerUIController) {
        if (this.informationShowers == null || this.informationShowers.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.informationShowers.size()) {
            JFrame controller;
            if (this.informationShowers.get(i) instanceof InformationShowerMappingArrayMass && (controller = ((InformationShowerMappingArrayMass)this.informationShowers.get(i)).getFrmController()) != null && controller == jfrmShowerUIController) {
                this.informationShowers.removeElement(i);
                return;
            }
            ++i;
        }
    }

    public void setInformationShowers(Vector vect) {
        this.informationShowers = vect;
    }

    public boolean havehadInformationShowerID(long id) {
        return this.havehadInformationShowerID("" + id);
    }

    public boolean havehadInformationShowerID(String id) {
        if (this.informationShowers == null || this.informationShowers.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this.informationShowers.size()) {
            if (((InformationShowerImpl)this.informationShowers.get(i)).getInformationShowerReadOnlyPK().equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector recreateMappingArrayMassDisplayers(String[][] strInputDataFromFile, String[][] strAuxDatas, int percent, int iPtr, Color colorstart, Color colormid, Color colorend, double minControlValue, double maxControlValue) {
        Vector vectRtn = new Vector();
        if (!this.isRecreateMappingArrayMassDisplayersInputParaValidate(strInputDataFromFile, percent, iPtr, colorstart, colormid, colorend)) {
            return vectRtn;
        }
        Color[] colorStart = new Color[strInputDataFromFile.length];
        int i = 1;
        while (i < colorStart.length) {
            colorStart[i] = colorstart;
            ++i;
        }
        Color[] colorMid = new Color[strInputDataFromFile.length];
        int i2 = 1;
        while (i2 < colorMid.length) {
            colorMid[i2] = colormid;
            ++i2;
        }
        Color[] colorEnd = new Color[strInputDataFromFile.length];
        int i3 = 1;
        while (i3 < colorEnd.length) {
            colorEnd[i3] = colorend;
            ++i3;
        }
        vectRtn = this.recreateMappingArrayMassDisplayers(strInputDataFromFile, strAuxDatas, percent, iPtr, colorStart, colorMid, colorEnd, minControlValue, maxControlValue);
        return vectRtn;
    }

    public Vector recreateMappingArrayMassDisplayers(String[][] strInputDataFromFile, String[][] strAuxDatas, int percent, int iPtr, Color[] colorstart, Color[] colormid, Color[] colorend, double minControlValue, double maxControlValue) {
        if (percent <= 1) {
            percent = 1;
        } else if (percent >= 100) {
            percent = 100;
        }
        Vector vectRtn = new Vector();
        if (!this.isRecreateMappingArrayMassDisplayersInputParaValidate(strInputDataFromFile, percent, iPtr, colorstart, colormid, colorend)) {
            return vectRtn;
        }
        this.resetPaintSymbolFrameUsingSpecifiedColorFlg(true);
        double lMax = maxControlValue;
        double lMin = minControlValue;
        double lDeltaOfMaxAndMin = lMax - lMin;
        int i = 1;
        while (i < strInputDataFromFile.length) {
            block27: {
                SpeciesAlias alisa;
                int j;
                String strInputSID = strAuxDatas[i][6];
                double lCurrQuant = 0.0;
                try {
                    double dbl;
                    lCurrQuant = dbl = Double.parseDouble(strInputDataFromFile[i][iPtr]);
                }
                catch (Exception myErr) {
                    break block27;
                }
                double lDeltaOfCurrQuantAndMin = lCurrQuant - lMin;
                double dPercentOfQuant = 0.0;
                if (lDeltaOfMaxAndMin != 0.0) {
                    dPercentOfQuant = lDeltaOfCurrQuantAndMin / lDeltaOfMaxAndMin;
                }
                if (dPercentOfQuant < 0.0) {
                    dPercentOfQuant = 0.0;
                } else if (dPercentOfQuant > 1.0) {
                    dPercentOfQuant = 1.0;
                }
                Color colorCurr = null;
                if (dPercentOfQuant <= 0.0) {
                    colorCurr = colorstart[i];
                } else if (dPercentOfQuant > 0.0 && dPercentOfQuant < 0.5) {
                    colorCurr = GStructure.getGradientColor(colorstart[i], colormid[i], dPercentOfQuant * 2.0);
                } else if (dPercentOfQuant == 0.5) {
                    colorCurr = colormid[i];
                } else if (dPercentOfQuant > 0.5 && dPercentOfQuant < 1.0) {
                    colorCurr = GStructure.getGradientColor(colormid[i], colorend[i], (dPercentOfQuant - 0.5) * 2.0);
                } else if (dPercentOfQuant >= 1.0) {
                    colorCurr = colorend[i];
                }
                Vector<SpeciesAlias> vectSameAsThisIDSpeciesList = new Vector<SpeciesAlias>();
                if (this.atoms != null) {
                    j = 0;
                    while (j < this.atoms.size()) {
                        if (this.atoms.get(j) instanceof ElementSpeciesAlias && ((ElementSpeciesAlias)(alisa = (ElementSpeciesAlias)this.atoms.get(j))).getOriginalSpecies().getId().equals(strInputSID)) {
                            vectSameAsThisIDSpeciesList.add(alisa);
                        }
                        ++j;
                    }
                }
                if (this.containeratoms != null) {
                    j = 0;
                    while (j < this.containeratoms.size()) {
                        if (this.containeratoms.get(j) instanceof ComplexSpeciesAlias && ((ComplexSpeciesAlias)(alisa = (ComplexSpeciesAlias)this.containeratoms.get(j))).getOriginalSpecies().getId().equals(strInputSID)) {
                            vectSameAsThisIDSpeciesList.add(alisa);
                        }
                        ++j;
                    }
                }
                j = 0;
                while (j < vectSameAsThisIDSpeciesList.size()) {
                    alisa = (SpeciesAlias)vectSameAsThisIDSpeciesList.get(j);
                    MonoSpeciesShape monoshape = (MonoSpeciesShape)alisa.getGFramedShape();
                    SpeciesSymbolImpl symbol = (SpeciesSymbolImpl)monoshape.getSpeciesSymbol();
                    symbol.setPaintSymbolFrameUsingSpecifiedColorFlg(true);
                    symbol.setUserSpecifiedColor(colorCurr);
                    ++j;
                }
            }
            ++i;
        }
        return vectRtn;
    }

    private boolean isRecreateMappingArrayMassDisplayersInputParaValidate(String[][] strInputDataFromFile, int percent, int iPtr, Object colorstart, Object colormid, Object colorend) {
        if (strInputDataFromFile == null || strInputDataFromFile.length == 1 || strInputDataFromFile[1].length == 1) {
            return false;
        }
        if (percent < 0 || percent > 100) {
            return false;
        }
        if (iPtr <= 0 || iPtr >= strInputDataFromFile[1].length) {
            return false;
        }
        if (colorstart == null || colormid == null || colorend == null) {
            return false;
        }
        if (!(colorstart instanceof Color && colormid instanceof Color && colorend instanceof Color)) {
            if (colorstart instanceof Color[] && colormid instanceof Color[] && colorend instanceof Color[]) {
                Color[] colorTmp = (Color[])colorstart;
                if (strInputDataFromFile.length != colorTmp.length) {
                    return false;
                }
                int i = 1;
                while (i < colorTmp.length) {
                    if (colorTmp[i] == null) {
                        return false;
                    }
                    ++i;
                }
                colorTmp = (Color[])colormid;
                if (strInputDataFromFile.length != colorTmp.length) {
                    return false;
                }
                i = 1;
                while (i < colorTmp.length) {
                    if (colorTmp[i] == null) {
                        return false;
                    }
                    ++i;
                }
                colorTmp = (Color[])colorend;
                if (strInputDataFromFile.length != colorTmp.length) {
                    return false;
                }
                i = 1;
                while (i < colorTmp.length) {
                    if (colorTmp[i] == null) {
                        return false;
                    }
                    ++i;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Object findMaxOrMinInArray(String[] strNum, Object type, int iFrom, int iTo, boolean bMax) {
        if (strNum == null) {
            return null;
        }
        if (iFrom < 0) {
            return null;
        }
        if (iTo >= strNum.length) {
            return null;
        }
        if (iFrom > iTo) {
            return null;
        }
        rtn /* !! */  = null;
        i = iFrom;
        while (i <= iTo) {
            if (type instanceof Long) {
                try {
                    input = Long.parseLong(strNum[i]);
                    if (rtn /* !! */  == null) {
                        rtn /* !! */  = new Long(input);
                    }
                    if (bMax) {
                        if ((Long)rtn /* !! */  >= input) ** GOTO lbl42
                        rtn /* !! */  = new Long(input);
                    }
                    if ((Long)rtn /* !! */  <= input) ** GOTO lbl42
                    rtn /* !! */  = new Long(input);
                }
                catch (Exception myErr) {
                    return null;
                }
            } else if (type instanceof Double) {
                try {
                    input = Double.parseDouble(strNum[i]);
                    if (rtn /* !! */  == null) {
                        rtn /* !! */  = new Double(input);
                    } else if (bMax) {
                        if ((Double)rtn /* !! */  < input) {
                            rtn /* !! */  = new Double(input);
                        }
                    } else if ((Double)rtn /* !! */  > input) {
                        rtn /* !! */  = new Double(input);
                    }
                }
                catch (Exception myErr) {
                    return null;
                }
            }
lbl42:
            // 10 sources

            ++i;
        }
        return rtn /* !! */ ;
    }

    public void resetCurrentInformationShowersControlFrameStatus() {
        try {
            MainWindow mainwin = MainWindow.getLastInstance();
            Vector sbmodelFrames = mainwin.getModels();
            int i = 0;
            while (i < sbmodelFrames.size()) {
                try {
                    SBModelFrame sbf = (SBModelFrame)sbmodelFrames.get(i);
                    GStructure gs = sbf.getSBModel().getGStructure();
                    if (gs.getCurrentInformationShowersControlFrame() instanceof MappingArrayMassShowerMainWinFrm) {
                        MappingArrayMassShowerMainWinFrm massShower = (MappingArrayMassShowerMainWinFrm)gs.getCurrentInformationShowersControlFrame();
                        if (gs != this) {
                            if (massShower.isVisible()) {
                                massShower.setVisible(false);
                            }
                        } else if (!massShower.isVisible()) {
                            massShower.setVisible(true);
                            if (mainwin.isActive()) {
                                massShower.setExtendedState(0);
                            } else {
                                massShower.setExtendedState(1);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Exception myErr) {
            return;
        }
    }

    public Vector getStructureListeners() {
        return this.listeners;
    }

    public void setStructureListeners(Vector vct) {
        this.listeners = vct;
    }

    public LayerManager getTaglayer() {
        if (this.layers == null) {
            this.layers = new Vector();
        }
        if (this.layers.size() > 0) {
            int i = 0;
            while (i < this.layers.size()) {
                LayerManager lm = (LayerManager)this.layers.get(i);
                if (lm != null && lm.getId() == -99) {
                    return lm;
                }
                ++i;
            }
        }
        LayerManager newlayer = new LayerManager("LayerForTag", -99);
        this.layers.addElement(newlayer);
        return newlayer;
    }

    public void setTaglayer(LayerManager lmg) {
        if (lmg != null && lmg.getId() == -99) {
            if (this.layers == null) {
                this.layers = new Vector();
            } else if (this.layers.size() > 0) {
                int i = 0;
                while (i < this.layers.size()) {
                    LayerManager lm = (LayerManager)this.layers.get(i);
                    if (lm != null && lm.getId() == -99) {
                        this.layers.remove(lm);
                        break;
                    }
                    ++i;
                }
            }
            this.layers.addElement(lmg);
            return;
        }
    }

    public Vector getLayerTagLinkLinesWhichLinksTo(Object targetAlias) {
        Vector<LayerReactionLink> rtn = new Vector<LayerReactionLink>();
        if (targetAlias == null) {
            return rtn;
        }
        if (!(targetAlias instanceof ElementSpeciesAlias) && !(targetAlias instanceof ComplexSpeciesAlias)) {
            return rtn;
        }
        LayerManager tagLayer = this.getTaglayer();
        ArrayList allLayerTagLinks = tagLayer.getListOfFreeLines();
        int i = 0;
        while (i < allLayerTagLinks.size()) {
            LayerReactionLink link = (LayerReactionLink)allLayerTagLinks.get(i);
            GLinkTarget linksource = null;
            GLinkTarget linktarget = null;
            try {
                linksource = link.getTargetAt(0);
                linktarget = link.getTargetAt(1);
            }
            catch (Exception e) {
                linksource = null;
                linktarget = null;
            }
            if (linksource != null && linksource instanceof LayerSpeciesAlias && linktarget != null && linktarget == targetAlias) {
                rtn.add(link);
            }
            ++i;
        }
        return rtn;
    }

    private boolean addLayerForTag() {
        Vector vlstLayers = this.getLayers();
        boolean bHave = false;
        int iLayerid = -99;
        if (vlstLayers == null) {
            vlstLayers = new Vector();
        }
        int j = 0;
        while (j < vlstLayers.size()) {
            LayerManager m = (LayerManager)vlstLayers.get(j);
            if (iLayerid == m.getId()) {
                bHave = true;
                break;
            }
            ++j;
        }
        if (bHave) {
            return false;
        }
        String strLayername = "LayerForTag";
        LayerNameInputDialog d = new LayerNameInputDialog(null, strLayername);
        LayerManager newlayer = new LayerManager(d.getText(), iLayerid);
        Vector listOfLayers = this.getLayers();
        listOfLayers.addElement(newlayer);
        return true;
    }

    public Rectangle2D updateLayerSpeciesLinks() {
        Rectangle2D.Double redrawArea = null;
        LayerManager m = this.getTaglayer();
        ArrayList listOfLink = m.getListOfFreeLines();
        int k = 0;
        while (k < listOfLink.size()) {
            LayerReactionLink alias = (LayerReactionLink)listOfLink.get(k);
            Rectangle2D tempRedrawArea = alias.update();
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
            ++k;
        }
        return redrawArea;
    }

    public Vector getLayerTagLinkLinesWhichLinksToTag(Object tagAlias) {
        Vector<LayerReactionLink> rtn = new Vector<LayerReactionLink>();
        if (tagAlias == null) {
            return rtn;
        }
        if (!(tagAlias instanceof LayerSpeciesAlias)) {
            return rtn;
        }
        LayerManager tagLayer = this.getTaglayer();
        if (tagLayer == null) {
            return rtn;
        }
        ArrayList allLayerTagLinks = tagLayer.getListOfFreeLines();
        int i = 0;
        while (i < allLayerTagLinks.size()) {
            LayerReactionLink link = (LayerReactionLink)allLayerTagLinks.get(i);
            GLinkTarget linksource = null;
            try {
                linksource = link.getTargetAt(0);
            }
            catch (Exception e) {
                linksource = null;
            }
            if (linksource != null && linksource == tagAlias) {
                rtn.add(link);
            }
            ++i;
        }
        return rtn;
    }

    public LayerSpeciesAlias getTagLineSource(Object tagLine) {
        LayerSpeciesAlias linksource = null;
        try {
            linksource = (LayerSpeciesAlias)((LayerReactionLink)tagLine).getTargetAt(0);
        }
        catch (Exception e) {
            linksource = null;
        }
        return linksource;
    }

    public static Color getGradientColor(Color colorstart, Color colorend, double dPercent) {
        if (colorstart == null || colorend == null) {
            return null;
        }
        if (dPercent < 0.0 || dPercent > 1.0) {
            return null;
        }
        int iDeltaStartRed = (int)((double)(colorend.getRed() - colorstart.getRed()) * dPercent);
        int iDeltaStartGreen = (int)((double)(colorend.getGreen() - colorstart.getGreen()) * dPercent);
        int iDeltaStartBlue = (int)((double)(colorend.getBlue() - colorstart.getBlue()) * dPercent);
        int iNewRed = colorstart.getRed() + iDeltaStartRed;
        int iNewGreen = colorstart.getGreen() + iDeltaStartGreen;
        int iNewBlue = colorstart.getBlue() + iDeltaStartBlue;
        return new Color(iNewRed, iNewGreen, iNewBlue);
    }

    public static final GLogicGate isGLogicGateHeaderPoint(GElement element) {
        GLogicGate gate;
        GEditable geditable;
        if (element instanceof GEditPoint && (geditable = ((GEditPoint)element).getOwner()) instanceof GLogicGate && element == (gate = (GLogicGate)geditable).getHeaderPoint()) {
            return gate;
        }
        return null;
    }

    public static final double getGLogicGateDIAMETER(GLogicGate gate) {
        double size = 11.0;
        if (gate != null && gate.isInSBGNViewer()) {
            size = 24.0;
        }
        return size;
    }

    public static final Point2D.Double givePntInValidArea(Rectangle2D.Double mxArea, double excludeW, double excludeH, double x, double y) {
        double xNew = x;
        double yNew = y;
        Rectangle2D.Double recValide = new Rectangle2D.Double(mxArea.x + excludeW / 2.0, mxArea.y + excludeH / 2.0, mxArea.width - excludeW / 2.0, mxArea.height - excludeH / 2.0);
        if (!recValide.contains(new Point2D.Double(x, y))) {
            if (xNew < recValide.x) {
                xNew = recValide.x;
            }
            if (xNew > recValide.width) {
                xNew = recValide.width;
            }
            if (yNew < recValide.y) {
                yNew = recValide.y;
            }
            if (yNew > recValide.height) {
                yNew = recValide.height;
            }
        }
        return new Point2D.Double(xNew, yNew);
    }

    public Rectangle2D autoAjustLinksLineConn() {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.links.size()) {
            ReactionLink lnk = (ReactionLink)this.links.get(i);
            Rectangle2D tempRedrawArea = this.autoAjustLinkLineConn(lnk);
            redrawArea = GUtil.union(redrawArea, tempRedrawArea);
            ++i;
        }
        return redrawArea;
    }

    public Rectangle2D autoAjustLinkLineConn(ReactionLink lnk) {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D tempRedrawArea = null;
        if (lnk == null || !lnk.isBaseLink()) {
            return redrawArea;
        }
        Vector alllnks = this.getReactionLinksWhichislinkingtoME(lnk);
        if (alllnks != null) {
            GLinkedCurveAndLine cvln;
            int j;
            Vector gts = (Vector)alllnks.get(0);
            Vector rts = (Vector)alllnks.get(1);
            Vector pds = (Vector)alllnks.get(2);
            Vector mds = (Vector)alllnks.get(3);
            Vector ots = (Vector)alllnks.get(4);
            if (gts != null) {
                j = 0;
                while (j < gts.size()) {
                    tempRedrawArea = null;
                    GLogicGate gt = (GLogicGate)((ReactionLink)gts.get(j)).getGLinkedShape();
                    if (gt != null && gt.getRealLine() != null) {
                        LinkedCreaseLine csln = gt.getRealLine();
                        if (gt.getConnectPolicy() == 0) {
                            tempRedrawArea = csln.recalLocalPositions(csln.start, csln.getEndTargetPoint());
                        } else if (gt.getConnectPolicy() == 1) {
                            tempRedrawArea = csln.autoAjustCreasePointUsingNewStartEndPnt(csln.start, csln.getEndTargetPoint());
                        }
                        redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                        Vector children = gt.getChildrenLink();
                        if (children != null) {
                            int k = 0;
                            while (k < children.size()) {
                                tempRedrawArea = null;
                                GLinkedCreaseLine gcsln = (GLinkedCreaseLine)((ReactionLink)children.get(k)).getGLinkedShape();
                                if (gt.getConnectPolicy() == 0) {
                                    tempRedrawArea = gcsln.recalLocalPositions(gcsln.start, gcsln.getEndTargetPoint());
                                } else if (gt.getConnectPolicy() == 1) {
                                    tempRedrawArea = gcsln.autoAjustCreasePointUsingNewStartEndPnt(gcsln.start, gcsln.getEndTargetPoint());
                                }
                                redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            if (rts != null) {
                j = 0;
                while (j < rts.size()) {
                    tempRedrawArea = null;
                    cvln = (GLinkedCurveAndLine)((ReactionLink)rts.get(j)).getGLinkedShape();
                    if (cvln != null) {
                        if (cvln.getConnectPolicy() == 0) {
                            tempRedrawArea = cvln.recalLocalPositions(cvln.start, cvln.getEndTargetPoint());
                        } else if (cvln.getConnectPolicy() == 1) {
                            tempRedrawArea = cvln.autoAjustCreasePointUsingNewStartEndPnt(cvln.start, cvln.getEndTargetPoint());
                        }
                        redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                        redrawArea = cvln.updateShape();
                        redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                    }
                    ++j;
                }
            }
            if (pds != null) {
                j = 0;
                while (j < pds.size()) {
                    tempRedrawArea = null;
                    cvln = (GLinkedCurveAndLine)((ReactionLink)pds.get(j)).getGLinkedShape();
                    if (cvln != null) {
                        if (cvln.getConnectPolicy() == 0) {
                            tempRedrawArea = cvln.recalLocalPositions(cvln.start, cvln.getEndTargetPoint());
                        } else if (cvln.getConnectPolicy() == 1) {
                            tempRedrawArea = cvln.autoAjustCreasePointUsingNewStartEndPnt(cvln.start, cvln.getEndTargetPoint());
                        }
                        redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                        redrawArea = cvln.updateShape();
                        redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                    }
                    ++j;
                }
            }
            if (mds != null) {
                j = 0;
                while (j < mds.size()) {
                    tempRedrawArea = null;
                    GLinkedCreaseLine gcsln = (GLinkedCreaseLine)((ReactionLink)mds.get(j)).getGLinkedShape();
                    if (gcsln != null) {
                        if (gcsln.getConnectPolicy() == 0) {
                            tempRedrawArea = gcsln.recalLocalPositions(gcsln.start, gcsln.getEndTargetPoint());
                        } else if (gcsln.getConnectPolicy() == 1) {
                            tempRedrawArea = gcsln.autoAjustCreasePointUsingNewStartEndPnt(gcsln.start, gcsln.getEndTargetPoint());
                        }
                        redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                    }
                    ++j;
                }
            }
            if (ots != null) {
                j = 0;
                while (j < ots.size()) {
                    tempRedrawArea = null;
                    ReactionLink rlk = (ReactionLink)ots.get(j);
                    if (rlk != null) {
                        if (rlk.getGLinkedShape() instanceof GLinkedCreaseLine) {
                            GLinkedCreaseLine gcsln = (GLinkedCreaseLine)rlk.getGLinkedShape();
                            if (gcsln != null) {
                                if (gcsln.getConnectPolicy() == 0) {
                                    tempRedrawArea = gcsln.recalLocalPositions(gcsln.start, gcsln.getEndTargetPoint());
                                } else if (gcsln.getConnectPolicy() == 1) {
                                    tempRedrawArea = gcsln.autoAjustCreasePointUsingNewStartEndPnt(gcsln.start, gcsln.getEndTargetPoint());
                                }
                                redrawArea = GUtil.union(redrawArea, tempRedrawArea);
                            }
                        } else {
                            rlk.update();
                        }
                    }
                    ++j;
                }
            }
        }
        return redrawArea;
    }

    private Rectangle2D.Double deleteLayerTag(GElement gelement, Vector removedVector) {
        Rectangle2D.Double redrawArea = null;
        Vector removes = this.getLayerTagLinkLinesWhichLinksTo(gelement);
        LayerManager taglmg = this.getTaglayer();
        ArrayList listOfTexts = taglmg.getListOfTexts();
        int k = 0;
        while (k < removes.size()) {
            listOfTexts.remove(removes.get(k));
            ++k;
        }
        ArrayList listOfLines = taglmg.getListOfFreeLines();
        int k2 = 0;
        while (k2 < removes.size()) {
            listOfLines.remove(removes.get(k2));
            ++k2;
        }
        removedVector.addAll(removes);
        return redrawArea;
    }

    public boolean haveGLinkInEditing() {
        if (this.moveLinkList != null && this.moveLinkList.size() > 0) {
            return true;
        }
        return this.selectedVector != null && this.selectedVector.size() > 0;
    }

    public boolean isBypassDraw() {
        return this.bBypassDraw;
    }

    public void setBypassDrawFlg(boolean bypassDraw) {
        this.bBypassDraw = bypassDraw;
    }

    public class GroupOfSameSpeciesID {
        private String SID = "";
        private String TYPE = "";
        private Vector MEMBERS = new Vector();

        public String getSID() {
            return this.SID;
        }

        public void setSID(String sid) {
            this.SID = sid;
        }

        public String getTYPE() {
            return this.TYPE;
        }

        public void setType(String type) {
            this.TYPE = type;
        }

        public Vector getMEMBERS() {
            return this.MEMBERS;
        }

        public void setMEMBERS(Vector members) {
            this.MEMBERS = members;
            if (this.MEMBERS == null) {
                this.MEMBERS = new Vector();
            }
        }

        public void addMember(GElement ge) {
            if (this.MEMBERS == null) {
                this.MEMBERS = new Vector();
            }
            this.MEMBERS.add(ge);
        }

        public void removeMember(GElement ge) {
            if (this.MEMBERS == null) {
                return;
            }
            this.MEMBERS.remove(ge);
        }
    }
}

