/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerShape;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GFramedContainer;
import jp.fric.graphics.draw.GPointHandle;
import jp.fric.graphics.draw.GPointed;
import jp.fric.graphics.draw.GPointedShape;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;

public class GPointedContainer
extends GElementImpl
implements GPointed,
GContainer,
GContainerTarget {
    private boolean isHighlighted = false;
    private String name = "";
    private Point2D.Double point = null;
    Rectangle2D.Double maxArea = null;
    private GPointedShape pointedShape = null;
    private Rectangle2D.Double bounds = null;
    private GPointHandle handle;
    private Vector contains = new Vector();
    private GContainer container = null;
    private Point2D.Double innerPosition = null;
    private boolean isHighlightedAsContainerTarget = false;

    public GPointedContainer() {
        this.handle = new GPointHandle(this);
    }

    @Override
    public void activateHandle(boolean active) {
        this.handle.setActive(active);
    }

    @Override
    public void addTarget(GContainerTarget containertarget) {
        this.contains.add(containertarget);
    }

    @Override
    public void clearTargets() {
        this.contains.clear();
    }

    @Override
    public int containizedSize() {
        return this.contains.size();
    }

    @Override
    public GElement createCopy() {
        GPointedContainer copy;
        Object object = null;
        try {
            copy = (GPointedContainer)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        if (this.pointedShape != null) {
            try {
                copy.setGPointedShape(this.pointedShape.createCopy());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.point != null) {
            copy.setPoint(this.point.x, this.point.y);
        }
        if (this.maxArea != null) {
            copy.setMaxArea(this.maxArea);
        }
        int i = 0;
        while (i < this.contains.size()) {
            GElement element = (GElement)this.contains.elementAt(i);
            GContainerTarget target = (GContainerTarget)((Object)element.createCopy());
            GStructure.setContainerTarget(copy, target);
            ++i;
        }
        copy.update();
        return copy;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (this.pointedShape != null) {
            int state = 1;
            if (this.isHighlighted) {
                state = 2;
            } else if (this.isHighlightedAsContainerTarget) {
                state = 3;
            }
            this.pointedShape.drawShape(graphics2d, state);
            if (this.isHighlighted) {
                this.handle.draw(graphics2d);
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public GContainer getContainer() {
        return this.container;
    }

    public GPointedShape getGPointedShape() {
        return this.pointedShape;
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        if (this.handle.getRect().contains(x, y)) {
            return this.handle;
        }
        return null;
    }

    @Override
    public Point2D.Double getInnerPosition() {
        return this.innerPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Point2D.Double getPoint() {
        return this.point;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.getBounds();
    }

    @Override
    public Vector getTargets() {
        return (Vector)this.contains.clone();
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.pointedShape == null) {
            return false;
        }
        return this.pointedShape.inShape(x, y);
    }

    @Override
    public boolean onEdge(double x, double y) {
        if (this.pointedShape == null) {
            return false;
        }
        return ((GContainerShape)((Object)this.pointedShape)).onEdge(x, y);
    }

    @Override
    public int includes(GContainerTarget containertarget) {
        Point2D.Double currentPoint = this.getPoint();
        if (this.pointedShape == null || currentPoint == null) {
            return 0;
        }
        if (!this.isContainable(containertarget)) {
            return 0;
        }
        if (containertarget instanceof GFramed) {
            return GFramedContainer.checkIncludes((GContainerShape)((Object)this.pointedShape), (GFramed)((Object)containertarget));
        }
        Point2D.Double targetPoint = null;
        if (containertarget instanceof GPointed) {
            targetPoint = ((GPointed)((Object)containertarget)).getPoint();
        }
        int handlelocation = this.pointedShape.getHandleLocation();
        int location = 0;
        switch (handlelocation) {
            case 1: {
                if (!(currentPoint.x < targetPoint.x) || !(currentPoint.y < targetPoint.y)) break;
                location = 4;
                break;
            }
            case 2: {
                if (!(currentPoint.x > targetPoint.x) || !(currentPoint.y < targetPoint.y)) break;
                location = 4;
                break;
            }
            case 3: {
                if (!(currentPoint.x < targetPoint.x) || !(currentPoint.y > targetPoint.y)) break;
                location = 4;
                break;
            }
            case 4: {
                if (!(currentPoint.x > targetPoint.x) || !(currentPoint.y > targetPoint.y)) break;
                location = 4;
                break;
            }
            case 5: {
                if (!(currentPoint.y < targetPoint.y)) break;
                location = 4;
                break;
            }
            case 7: {
                if (!(currentPoint.x < targetPoint.x)) break;
                location = 4;
                break;
            }
            case 8: {
                if (!(currentPoint.y > targetPoint.y)) break;
                location = 4;
                break;
            }
            case 6: {
                if (!(currentPoint.x > targetPoint.x)) break;
                location = 4;
            }
        }
        return location;
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        return false;
    }

    @Override
    public boolean isContainable(GContainerTarget containertarget) {
        if (containertarget instanceof GFramed) {
            if (containertarget instanceof GBasicAtom) {
                return ((GBasicAtom)containertarget).getCurrentView() != 1;
            }
            return true;
        }
        boolean containable = false;
        if (containertarget instanceof GPointedContainer) {
            int targetHandleLoc = ((GPointedContainer)containertarget).getGPointedShape().getHandleLocation();
            int thisHandlLoc = this.pointedShape.getHandleLocation();
            switch (thisHandlLoc) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    containable = thisHandlLoc == targetHandleLoc;
                    break;
                }
                case 5: {
                    containable = targetHandleLoc == 5 || targetHandleLoc == 1 || targetHandleLoc == 2;
                    break;
                }
                case 7: {
                    containable = targetHandleLoc == 7 || targetHandleLoc == 1 || targetHandleLoc == 3;
                    break;
                }
                case 8: {
                    containable = targetHandleLoc == 8 || targetHandleLoc == 3 || targetHandleLoc == 4;
                    break;
                }
                case 6: {
                    containable = targetHandleLoc == 6 || targetHandleLoc == 2 || targetHandleLoc == 4;
                }
            }
        }
        return containable;
    }

    @Override
    public boolean isContainerOf(GContainerTarget containertarget) {
        int i = 0;
        while (i < this.contains.size()) {
            Object object = this.contains.elementAt(i);
            if (object == containertarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public boolean isHighlightedAsTarget() {
        return this.isHighlightedAsContainerTarget;
    }

    @Override
    public void removeTarget(GContainerTarget gcontainertarget) {
        this.contains.remove(gcontainertarget);
    }

    @Override
    public void setContainer(GContainer container) {
        this.container = container;
    }

    public void setGPointedShape(GPointedShape pointedshape) throws Exception {
        if (!(pointedshape instanceof GContainerShape)) {
            throw new Exception("pointedShape must also to be GContainerShape");
        }
        this.pointedShape = pointedshape;
        this.handle.setLocation(pointedshape.getHandleLocation());
    }

    @Override
    public void setHighlighted(boolean highlight) {
        this.isHighlighted = highlight;
    }

    @Override
    public void setHighlightedAsTarget(boolean highlight) {
        this.isHighlightedAsContainerTarget = highlight;
    }

    @Override
    public void setInnerPosition(Point2D.Double innerPosition) {
        this.innerPosition = innerPosition;
    }

    public Rectangle2D.Double getMaxArea() {
        if (this.maxArea == null) {
            return null;
        }
        return (Rectangle2D.Double)this.maxArea.clone();
    }

    public void setMaxArea(Dimension newdimension) {
        if (newdimension == null) {
            return;
        }
        Rectangle2D.Double newarea = new Rectangle2D.Double(0.0, 0.0, newdimension.width, newdimension.height);
        this.setMaxArea(newarea);
    }

    @Override
    public void setMaxArea(Rectangle2D.Double area) {
        if (this.maxArea == null) {
            this.maxArea = new Rectangle2D.Double(area.x, area.y, area.width, area.height);
        } else {
            this.maxArea.x = area.x;
            this.maxArea.y = area.y;
            this.maxArea.width = area.width;
            this.maxArea.height = area.height;
        }
        if (this.pointedShape != null) {
            this.pointedShape.updateShape(this.point.x, this.point.y, this.maxArea);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPoint(double x, double y) {
        if (this.point == null) {
            this.point = new Point2D.Double(x, y);
        } else {
            this.point.x = x;
            this.point.y = y;
        }
    }

    @Override
    public Rectangle2D update() {
        if (this.point == null || this.pointedShape == null) {
            return null;
        }
        Rectangle2D.Double redrawArea = this.bounds;
        this.bounds = this.pointedShape.updateShape(this.point.x, this.point.y, this.maxArea);
        if (this.maxArea != null && this.bounds != null && !this.maxArea.contains(this.bounds)) {
            double x = this.point.x;
            double y = this.point.y;
            if (this.bounds.x < this.maxArea.x) {
                x += Math.abs(this.bounds.x - this.maxArea.x);
            } else if (this.bounds.getMaxX() > this.maxArea.getMaxX()) {
                x -= Math.abs(this.bounds.getMaxX() - this.maxArea.getMaxX());
            }
            if (this.bounds.y < this.maxArea.y) {
                y += Math.abs(this.bounds.y - this.maxArea.y);
            } else if (this.bounds.getMaxY() > this.maxArea.getMaxY()) {
                y -= Math.abs(this.bounds.getMaxY() - this.maxArea.getMaxY());
            }
            this.setPoint(x, y);
            this.bounds = this.pointedShape.updateShape(this.point.x, this.point.y, this.maxArea);
        }
        this.handle.updateRect();
        if (redrawArea == null) {
            return this.bounds;
        }
        if (redrawArea.equals(this.bounds)) {
            return null;
        }
        return GUtil.union(redrawArea, this.bounds);
    }
}

