/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.ElementAndPosition;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GCreaterResult;
import jp.fric.graphics.draw.GDefaultSizeGiven;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementFactory;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFrameHandle;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GFramedContainer;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GGroup;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkHandleMover;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedCurveEndLine;
import jp.fric.graphics.draw.GLinkedCurveStartLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GPointHandle;
import jp.fric.graphics.draw.GPointed;
import jp.fric.graphics.draw.GPointedContainer;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.util.Debug;
import jp.fric.util.LogFactory;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.NameImage;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionTargetDialog;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SelectResidueModificationDialog;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.symbol.creator.CreateLayerTagWithLine;
import jp.sbi.celldesigner.symbol.creator.Degradation;
import jp.sbi.celldesigner.symbol.creator.HomodimerFormation;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.KnownTransitionOmitted;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.Transport;
import jp.sbi.celldesigner.symbol.reaction.Truncation;
import jp.sbi.celldesigner.symbol.reaction.UnknownTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.PopupSettingDialog;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class GMouseInterpreter {
    public static final int MODE_SELECT = 1;
    public static final int MODE_CREATE = 2;
    public static final int MODE_CONTINUE = 100;
    public static final int MODE_NONCONTINUE = 0;
    protected static final int IGNORE_MOVE = 2;
    protected static final int IGNORE_CREATE = 5;
    private GStructure structure = null;
    private GElementFactory factory = null;
    private Rectangle2D.Double allArea;
    private String currentType = "";
    private boolean hasContext = false;
    private int currentMode = 1;
    private boolean isGridSnapON = false;
    private double gridWidth = 10.0;
    private double gridHeight = 10.0;
    private boolean isMultiSelectMode = false;
    private ElementSelector elementSelector;
    private GLinkCreater linkCreator = new GLinkCreater();
    private GFramedCreater frameCreater;
    private GMacroCreater01 macroCreater01;
    private GMacroCreater02 macroCreater02;
    private GMacroCreater03 macroCreater03;
    private GMacroCreater04 macroCreater04;
    private GMacroCreater05 macroCreater05;
    private GMacroCreater06 macroCreater06;
    private GMacroCreater07 macroCreater07;
    private GMacroCreater08 macroCreater08;
    private GMacroCreater09 macroCreater09;
    private GMacroCreater10 macroCreater10;
    private GMacroCreater11 macroCreater11;
    private GMacroCreater12 macroCreater12;
    private GMacroCreater13 macroCreater13;
    private GMacroCreater14 macroCreater14;
    private GMacroCreater15 macroCreater15;
    public static int macroCreatedObjCounter = 0;
    private GPointedCreater pointCreater;
    private GCreaterDriver createrDriver;
    private Line2D line = new Line2D.Double();
    public static final Color GRID_COLOR = new Color(0.8f, 0.8f, 0.8f);
    public static final Stroke GRID_STROKE = new BasicStroke(1.0f, 0, 0);
    int cursorstate = 0;
    private String tooltipString = null;
    private boolean isContinueMode = false;
    private Logger log = LogFactory.getLogger(GMouseInterpreter.class);
    private boolean popupMenuShowFlag = false;
    private static GMouseInterpreter mouseInterpreter;

    public static boolean isModification(GLinkedShape linkshape) {
        return linkshape instanceof LinkedCreaseLineModification || linkshape instanceof LinkedCreaseLineMixedNotation || linkshape instanceof GLogicGate;
    }

    public static boolean isLinkAbleByReactantProductModifications(GLinkedShape shape, GElement onMouseTarget, GLinkPositionInfo info) {
        if (onMouseTarget == null) {
            return true;
        }
        if (!(onMouseTarget instanceof GLink)) {
            return true;
        }
        if (onMouseTarget instanceof LayerReactionLink) {
            return true;
        }
        if (!(((GLink)onMouseTarget).getGLinkedShape() instanceof StateTransition)) {
            return true;
        }
        if (info == null) {
            return true;
        }
        if (!(info.getElement() instanceof GLink)) {
            return true;
        }
        if (GMouseInterpreter.isModification(shape)) {
            return info.getPosition() > 1 && info.getPosition() < 8;
        }
        if (shape instanceof AddProduct) {
            return info.getPosition() == 1;
        }
        if (shape instanceof AddReactant) {
            return info.getPosition() == 0;
        }
        return true;
    }

    public static void setOnMouseTargetAddingObjectFlag(GLink addingLink, GLinkTarget onMouseTarget) {
        if (addingLink == null) {
            return;
        }
        if (addingLink.getGLinkedShape() == null) {
            return;
        }
        if (onMouseTarget != null && onMouseTarget instanceof GLink && (((GLink)onMouseTarget).getGLinkedShape() instanceof StateTransition || ((GLink)onMouseTarget).getGLinkedShape() instanceof LinkedLineComplex3)) {
            GLinkedShape shape = addingLink.getGLinkedShape();
            if (((GLink)onMouseTarget).getGLinkedShape() instanceof StateTransition) {
                StateTransition onMouseTargetShape = (StateTransition)((GLink)onMouseTarget).getGLinkedShape();
                if (GMouseInterpreter.isModification(shape)) {
                    onMouseTargetShape.setAddingObjectFlag(3);
                } else if (shape instanceof AddProduct) {
                    onMouseTargetShape.setAddingObjectFlag(2);
                } else if (shape instanceof AddReactant) {
                    onMouseTargetShape.setAddingObjectFlag(1);
                }
            } else {
                LinkedLineComplex3 onMouseTargetShape = (LinkedLineComplex3)((GLink)onMouseTarget).getGLinkedShape();
                if (GMouseInterpreter.isModification(shape)) {
                    onMouseTargetShape.setAddingObjectFlag(3);
                } else if (shape instanceof AddProduct) {
                    onMouseTargetShape.setAddingObjectFlag(2);
                } else if (shape instanceof AddReactant) {
                    onMouseTargetShape.setAddingObjectFlag(1);
                }
            }
        }
    }

    public static void restoreOnMouseTargetAddingObjectFlag(GLinkTarget onMouseTarget) {
        if (onMouseTarget != null && onMouseTarget instanceof GLink && (((GLink)onMouseTarget).getGLinkedShape() instanceof StateTransition || ((GLink)onMouseTarget).getGLinkedShape() instanceof LinkedLineComplex3)) {
            if (((GLink)onMouseTarget).getGLinkedShape() instanceof StateTransition) {
                StateTransition onMouseTargetShape = (StateTransition)((GLink)onMouseTarget).getGLinkedShape();
                onMouseTargetShape.setAddingObjectFlag(0);
            } else {
                LinkedLineComplex3 onMouseTargetShape = (LinkedLineComplex3)((GLink)onMouseTarget).getGLinkedShape();
                onMouseTargetShape.setAddingObjectFlag(0);
            }
        }
    }

    private Point2D adjustmentMacroPosition(Rectangle2D editSize, double x, double y, double width, double height) {
        if (!editSize.contains(x, y, width, height)) {
            if (x < editSize.getX()) {
                x = editSize.getX();
            } else if (x + width > editSize.getMaxX() && (x = editSize.getMaxX() - width) < editSize.getX()) {
                x = editSize.getX();
            }
            if (y < editSize.getY()) {
                y = editSize.getY();
            } else if (y + height > editSize.getMaxY() && (y = editSize.getMaxY() - height) < editSize.getY()) {
                y = editSize.getY();
            }
        }
        return new Point2D.Double(x, y);
    }

    private int iniMacroCreatedObjCounter() {
        int iNextSpeciesId;
        MainWindow mWin = MainWindow.getLastInstance();
        try {
            iNextSpeciesId = Integer.parseInt(mWin.getCurrentModel().getSBModel().getNextSpeciesId().substring(1));
        }
        catch (Exception e) {
            iNextSpeciesId = 1;
        }
        return iNextSpeciesId;
    }

    public boolean chkHavingCorrespondingProtein(String name) {
        boolean having = false;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel(), null)).getListOfProteins();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            Protein p = sbModel.getProtein(s.getId());
            if (p.getName().equals(name)) {
                having = true;
                break;
            }
            ++i;
        }
        return having;
    }

    public boolean chkHavingCorrespondingRNA(String name) {
        try {
            boolean having = false;
            ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel(), null)).getListOfRNAs();
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            int i = 0;
            while ((long)i < list.size()) {
                try {
                    Species s = (Species)list.get((long)i);
                    RNA r = sbModel.getRNA(s.getId());
                    if (r.getName().equals(name) || s.getId().equals(name)) {
                        having = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            return having;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean chkHavingCorrespondingGene(String name) {
        try {
            boolean having = false;
            ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)MainWindow.getLastInstance().getCurrentModel().getSBModel().getModel(), null)).getListOfGenes();
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            int i = 0;
            while ((long)i < list.size()) {
                try {
                    Species s = (Species)list.get((long)i);
                    Gene g = sbModel.getGene(s.getId());
                    if (g.getName().equals(name) || s.getId().equals(name)) {
                        having = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            return having;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean chkHavingCorrespondingSpecies(String name, String symbolCode) {
        try {
            boolean having = false;
            Vector atom = this.structure.getAtoms();
            int i = 0;
            while (i < atom.size()) {
                try {
                    SpeciesAlias sa = (SpeciesAlias)atom.get(i);
                    SpeciesSymbol symbol = ((MonoSpeciesShape)sa.getGFramedShape()).getSpeciesSymbol();
                    if ((sa.getName().equals(name) || sa.getOriginalSpecies().getId().equals(name)) && ((SBSymbol)((Object)symbol)).getCode().equals(symbolCode)) {
                        having = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            return having;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean setMacroElementContainer(GElement target) {
        block18: {
            try {
                if (target != null) {
                    if (!(target instanceof GBasicAtom) && !(target instanceof GContainableAtom)) {
                        return false;
                    }
                    break block18;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        GContainer gct01 = this.structure.getOutside((GContainerTarget)((Object)target));
        if (gct01 != null) {
            if (gct01 instanceof GContainableAtom) {
                if (((GContainableAtom)gct01).currentView == 0 || ((GContainableAtom)gct01).currentView == 2) {
                    GStructure.setContainerTarget(gct01, (GContainerTarget)((Object)target));
                } else {
                    ((SpeciesAlias)target).getOriginalSpecies().setCompartment("default");
                    SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)target).getOriginalSpecies(), null);
                    sExt.setPositionToCompartment(4);
                }
            } else if (gct01 instanceof OpenedCompartmentAlias) {
                if (gct01.includes((GContainerTarget)((Object)target)) == 4) {
                    GStructure.setContainerTarget(gct01, (GContainerTarget)((Object)target));
                } else {
                    ((SpeciesAlias)target).getOriginalSpecies().setCompartment("default");
                    SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)target).getOriginalSpecies(), null);
                    sExt.setPositionToCompartment(4);
                }
            } else if (gct01 instanceof ClosedCompartmentAlias) {
                if (gct01.includes((GContainerTarget)((Object)target)) == 4) {
                    GStructure.setContainerTarget(gct01, (GContainerTarget)((Object)target));
                } else {
                    ((SpeciesAlias)target).getOriginalSpecies().setCompartment("default");
                    SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)target).getOriginalSpecies(), null);
                    sExt.setPositionToCompartment(4);
                }
            }
        } else {
            ((SpeciesAlias)target).getOriginalSpecies().setCompartment("default");
            SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)target).getOriginalSpecies(), null);
            sExt.setPositionToCompartment(4);
        }
        return true;
    }

    private double getAngleFromPosition(GLinkPositionInfo lpi) {
        double angle = Math.PI;
        if (lpi.getPosition() == 0) {
            angle = 1.5707963267948966;
        } else if (lpi.getPosition() == 1) {
            angle = 1.1780972450961724;
        } else if (lpi.getPosition() == 2) {
            angle = 0.7853981633974483;
        } else if (lpi.getPosition() == 3) {
            angle = 0.39269908169872414;
        } else if (lpi.getPosition() == 4) {
            angle = 0.0;
        } else if (lpi.getPosition() == 5) {
            angle = 5.890486225480862;
        } else if (lpi.getPosition() == 6) {
            angle = 5.497787143782138;
        } else if (lpi.getPosition() == 7) {
            angle = 5.105088062083414;
        } else if (lpi.getPosition() == 8) {
            angle = 4.71238898038469;
        } else if (lpi.getPosition() == 9) {
            angle = 4.319689898685965;
        } else if (lpi.getPosition() == 10) {
            angle = 3.9269908169872414;
        } else if (lpi.getPosition() == 11) {
            angle = 3.5342917352885173;
        } else if (lpi.getPosition() == 12) {
            angle = Math.PI;
        } else if (lpi.getPosition() == 13) {
            angle = 2.748893571891069;
        } else if (lpi.getPosition() == 14) {
            angle = 2.356194490192345;
        } else if (lpi.getPosition() == 15) {
            angle = 1.9634954084936207;
        }
        return angle;
    }

    public static GMouseInterpreter getInstance() {
        if (mouseInterpreter == null) {
            mouseInterpreter = new GMouseInterpreter();
        }
        return mouseInterpreter;
    }

    private GMouseInterpreter() {
        this.elementSelector = new ElementSelector(this);
        this.createrDriver = new GCreaterDriver(this);
        this.frameCreater = new GFramedCreater(this);
        this.macroCreater01 = new GMacroCreater01(this);
        this.macroCreater02 = new GMacroCreater02(this);
        this.macroCreater03 = new GMacroCreater03(this);
        this.macroCreater04 = new GMacroCreater04(this);
        this.macroCreater05 = new GMacroCreater05(this);
        this.macroCreater06 = new GMacroCreater06(this);
        this.macroCreater07 = new GMacroCreater07();
        this.macroCreater08 = new GMacroCreater08();
        this.macroCreater09 = new GMacroCreater09(this);
        this.macroCreater10 = new GMacroCreater10();
        this.macroCreater11 = new GMacroCreater11(this);
        this.macroCreater12 = new GMacroCreater12(this);
        this.macroCreater13 = new GMacroCreater13(this);
        this.macroCreater14 = new GMacroCreater14(this);
        this.macroCreater15 = new GMacroCreater15(this);
        this.pointCreater = new GPointedCreater(this);
        this.allArea = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public GElement getComplexForChangeView() {
        try {
            if (this.elementSelector.movingGElement instanceof ComplexSpeciesAlias) {
                return this.elementSelector.movingGElement;
            }
            return null;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public void setStartXStartYForChangeView(Point2D.Double point) {
        this.elementSelector.startX = point.getX();
        this.elementSelector.startY = point.getY();
    }

    public void deselectAll() {
        this.structure.deselectAll();
    }

    public void drawGrids(Graphics2D graphics2d) {
        double stY;
        Rectangle clip = graphics2d.getClipBounds();
        ((Rectangle2D)clip).setRect(((RectangularShape)clip).getX() - 10.0, ((RectangularShape)clip).getY() - 10.0, ((RectangularShape)clip).getWidth() + 20.0, ((RectangularShape)clip).getHeight() + 20.0);
        double width = this.allArea.width;
        double height = this.allArea.height;
        double stX = this.gridWidth * (double)((int)(((RectangularShape)clip).getX() / this.gridWidth));
        if (stX < 0.0) {
            stX = 0.0;
        }
        if ((stY = this.gridHeight * (double)((int)(((RectangularShape)clip).getY() / this.gridHeight))) < 0.0) {
            stY = 0.0;
        }
        width = clip.getMaxX() > width ? this.allArea.width : clip.getMaxX();
        height = clip.getMaxY() > height ? this.allArea.height : clip.getMaxY();
        graphics2d.setStroke(GRID_STROKE);
        graphics2d.setColor(GRID_COLOR);
        double y1 = ((RectangularShape)clip).getY() > 0.0 ? ((RectangularShape)clip).getY() : 0.0;
        double y2 = clip.getMaxY() < height ? clip.getMaxY() : height;
        double step = stX;
        while (step <= width) {
            this.line.setLine(step, y1, step, y2);
            graphics2d.draw(this.line);
            step += this.gridWidth;
        }
        double x1 = ((RectangularShape)clip).getX() > 0.0 ? ((RectangularShape)clip).getX() : 0.0;
        double x2 = clip.getMaxX() < width ? clip.getMaxX() : width;
        step = stY;
        while (step <= height) {
            this.line.setLine(x1, step, x2, step);
            graphics2d.draw(this.line);
            step += this.gridHeight;
        }
    }

    public double getGridHeight() {
        return this.gridHeight;
    }

    public double getGridWidth() {
        return this.gridWidth;
    }

    private void interruptTools() {
        this.linkCreator.interrupt();
        this.createrDriver.interrupt();
        this.frameCreater.interrupt();
        this.pointCreater.interrupt();
        this.macroCreater01.interrupt();
        this.macroCreater02.interrupt();
        this.macroCreater03.interrupt();
        this.macroCreater04.interrupt();
        this.macroCreater05.interrupt();
        this.macroCreater06.interrupt();
        this.macroCreater07.interrupt();
        this.macroCreater08.interrupt();
        this.macroCreater09.interrupt();
        this.macroCreater10.interrupt();
        this.macroCreater11.interrupt();
        this.macroCreater12.interrupt();
        this.macroCreater13.interrupt();
        this.macroCreater14.interrupt();
        this.macroCreater15.interrupt();
    }

    public void elementSelectorInterrupt() {
        this.elementSelector.interrupt();
    }

    public boolean isGridSnapON() {
        return this.isGridSnapON;
    }

    public boolean isMultiSelectMode() {
        return this.isMultiSelectMode;
    }

    public void mouseDrived(double x, double y, int i, MouseEvent e, boolean popupPreTrigger) {
        if (this.hasContext) {
            switch (this.currentMode) {
                case 1: {
                    this.elementSelector.interpret(x, y, e);
                    break;
                }
                case 2: {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        if (this.factory.isLinkable(this.currentType)) {
                            this.linkCreator.interrupt();
                            break;
                        }
                        if (this.currentType == null || this.currentType.length() < 5 || !this.currentType.substring(0, 5).toLowerCase().equals("macro")) break;
                        if (this.currentType.substring(5).equals("07")) {
                            this.macroCreater07.interrupt();
                            break;
                        }
                        if (this.currentType.substring(5).equals("08")) {
                            this.macroCreater08.interrupt();
                            break;
                        }
                        if (!this.currentType.substring(5).equals("10")) break;
                        this.macroCreater10.interrupt();
                        break;
                    }
                    if (this.factory.isLinkable(this.currentType)) {
                        this.linkCreator.interpret(x, y, i);
                        break;
                    }
                    if (this.factory.isFramed(this.currentType)) {
                        this.frameCreater.interpret(x, y, i);
                        break;
                    }
                    if (this.factory.isPointed(this.currentType)) {
                        this.pointCreater.interpret(x, y, i);
                        break;
                    }
                    if (this.factory.isCreater(this.currentType)) {
                        this.createrDriver.interpret(x, y, i);
                        break;
                    }
                    if (this.currentType == null || this.currentType.length() < 5 || !this.currentType.substring(0, 5).toLowerCase().equals("macro")) break;
                    if (this.currentType.substring(5).equals("01")) {
                        this.macroCreater01.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("02")) {
                        this.macroCreater02.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("03")) {
                        this.macroCreater03.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("04")) {
                        this.macroCreater04.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("05")) {
                        this.macroCreater05.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("06")) {
                        this.macroCreater06.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("07")) {
                        this.macroCreater07.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("08")) {
                        this.macroCreater08.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("09")) {
                        this.macroCreater09.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("10")) {
                        this.macroCreater10.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("11")) {
                        this.macroCreater11.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("12")) {
                        this.macroCreater12.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("13")) {
                        this.macroCreater13.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("14")) {
                        this.macroCreater14.interpret(x, y, i);
                    } else if (this.currentType.substring(5).equals("15")) {
                        this.macroCreater15.interpret(x, y, i);
                    }
                    if (e.getID() != 502) break;
                    MainWindow mWin = MainWindow.getLastInstance();
                    mWin.resetComboBox();
                }
            }
        }
    }

    public int getCorsorState() {
        return this.cursorstate;
    }

    public void setCursorstate(int cursorstate) {
        this.cursorstate = cursorstate;
    }

    public String getTooltipString() {
        return this.tooltipString;
    }

    public synchronized void releaseContext() {
        this.structure = null;
        this.factory = null;
        this.allArea.width = 0.0;
        this.allArea.height = 0.0;
        this.hasContext = false;
        this.elementSelector.setStructure(null);
    }

    public synchronized void setContext(GStructure gstructure, GElementFactory gelementfactory, Dimension dimension) {
        this.structure = gstructure;
        this.factory = gelementfactory;
        this.setEditSize(dimension);
        this.hasContext = false;
        if (gstructure != null && gelementfactory != null) {
            this.hasContext = true;
        }
        this.elementSelector.setStructure(gstructure);
        this.interruptTools();
    }

    public Rectangle2D getEditSize() {
        return this.allArea;
    }

    public void setEditSize(Dimension dimension) {
        this.allArea.width = dimension.width;
        this.allArea.height = dimension.height;
        if (this.structure != null) {
            this.structure.setMaxDrawSize(new Rectangle2D.Double(0.0, 0.0, dimension.width, dimension.height));
        }
    }

    public void setGridHeight(double height) {
        if (height > 0.0) {
            this.gridHeight = height;
        }
    }

    public void setGridSnapON(boolean gridOn) {
        this.isGridSnapON = gridOn;
    }

    public void setGridWidth(double width) {
        if (width > 0.0) {
            this.gridWidth = width;
        }
    }

    public void setMode(int i) {
        if (i > 100) {
            this.currentMode = i - 100;
            this.isContinueMode = true;
        } else {
            this.currentMode = i;
            this.isContinueMode = false;
        }
        this.interruptTools();
    }

    public int checkMode() {
        return this.currentMode;
    }

    public void setMultiSelectMode(boolean multiSelectOn) {
        this.isMultiSelectMode = multiSelectOn;
    }

    public void setType(String type) {
        this.currentType = type;
        this.interruptTools();
        if (this.hasContext) {
            this.structure.deselectAll();
        }
    }

    private double snapX(double x) {
        double slideX = x % this.gridWidth;
        if (slideX == 0.0) {
            return x;
        }
        if (slideX < this.gridWidth / 2.0) {
            return x - slideX;
        }
        return x + (this.gridWidth - slideX);
    }

    private double snapY(double y) {
        double slideY = y % this.gridHeight;
        if (slideY == 0.0) {
            return y;
        }
        if (slideY < this.gridHeight / 2.0) {
            return y - slideY;
        }
        return y + (this.gridHeight - slideY);
    }

    public void addLayerTextSymbol(Object selectedObj, LayerManager layer) {
        Object alias;
        this.structure.deselectAll();
        LayerSpeciesAlias creatingGFramed = (LayerSpeciesAlias)this.factory.createObject("LAYER_TEXT");
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        if (selectedObj instanceof SpeciesAlias) {
            alias = (SpeciesAlias)selectedObj;
            MonoSpeciesShape mono = (MonoSpeciesShape)alias.getGFramedShape();
            x = mono.getFrameBounds().x;
            y = mono.getFrameBounds().y;
            width = mono.getFrameBounds().width;
            height = mono.getFrameBounds().height;
        } else if (selectedObj instanceof CompartmentAlias) {
            GElementImpl cAlias;
            alias = (CompartmentAlias)selectedObj;
            if (alias instanceof ClosedCompartmentAlias) {
                cAlias = (ClosedCompartmentAlias)alias;
                x = ((GFramedContainer)cAlias).getFrameBounds().x;
                y = ((GFramedContainer)cAlias).getFrameBounds().y;
                width = ((GFramedContainer)cAlias).getFrameBounds().width;
                height = ((GFramedContainer)cAlias).getFrameBounds().height;
            } else if (alias instanceof OpenedCompartmentAlias) {
                cAlias = (OpenedCompartmentAlias)alias;
                x = ((GPointedContainer)cAlias).getBounds().x;
                y = ((GPointedContainer)cAlias).getBounds().y;
                width = ((GPointedContainer)cAlias).getBounds().width;
                height = ((GPointedContainer)cAlias).getBounds().height;
            }
        } else if (selectedObj instanceof ReactionLink) {
            ReactionLink link = (ReactionLink)selectedObj;
            x = link.getBounds().x;
            y = link.getBounds().y;
            width = link.getBounds().width;
            height = link.getBounds().height;
        }
        creatingGFramed.setTargetAlias(selectedObj);
        Point2D position = GMouseInterpreter.adjustmentPosition(x, y + height + 20.0, 100.0, 40.0);
        creatingGFramed.setFramePosition(position.getX(), position.getY());
        creatingGFramed.setFrameSize(100.0, 40.0);
        if (selectedObj instanceof ReactionLink) {
            Point2D.Double target = ((ReactionLink)selectedObj).getTargetPoint();
            if (target != null) {
                ((LayerMonoSpeciesShape)creatingGFramed.framedShape).setTargetPosition((int)target.getX(), (int)target.getY());
            } else {
                GLinkedShape linkShape = ((ReactionLink)selectedObj).getGLinkedShape();
                Point2D.Double point = null;
                try {
                    if (linkShape instanceof GLinkedLine) {
                        if (linkShape instanceof StateTransition) {
                            StateTransition shape = (StateTransition)linkShape;
                            point = (Point2D.Double)shape.getLines()[shape.getOmittedShapeIndex()].targetPoint().clone();
                        } else if (linkShape instanceof AddReactant || linkShape instanceof AddProduct) {
                            point = ((GLinkedCurveAndLine)linkShape).getLinkPoint();
                        } else {
                            GLinkedLine shape = (GLinkedLine)linkShape;
                            point = (Point2D.Double)shape.targetPoint().clone();
                        }
                    } else if (linkShape instanceof GLinkedLineComplex3) {
                        GLinkedLineComplex3 shape = (GLinkedLineComplex3)linkShape;
                        point = (Point2D.Double)shape.getMidPoint().clone();
                    } else if (linkShape instanceof GLogicGate) {
                        GLogicGate shape = (GLogicGate)linkShape;
                        point = (Point2D.Double)shape.getHeaderPoint().getPosition().clone();
                    }
                    ((LayerMonoSpeciesShape)creatingGFramed.framedShape).setTargetPosition((int)point.x, (int)point.y);
                }
                catch (Exception e) {
                    ((LayerMonoSpeciesShape)creatingGFramed.framedShape).setTargetPosition((int)x + (int)(width / 2.0), (int)y + (int)(height / 2.0) + 10);
                }
            }
        } else {
            ((LayerMonoSpeciesShape)creatingGFramed.framedShape).setTargetPosition((int)x + (int)(width / 2.0), (int)y + (int)(height / 2.0) + 10);
        }
        creatingGFramed.update();
        ((LayerMonoSpeciesShape)creatingGFramed.framedShape).updateShape(creatingGFramed.getFrameBounds().x, creatingGFramed.getFrameBounds().y, creatingGFramed.getFrameBounds().width, creatingGFramed.getFrameBounds().height);
        this.structure.notifyChange(creatingGFramed, 0, null);
        this.structure.notifyRepaint(((LayerMonoSpeciesShape)creatingGFramed.framedShape).getRepaintBounds());
    }

    public static Point2D adjustmentPosition(double x, double y, double width, double height) {
        GMouseInterpreter interpreter = GMouseInterpreter.getInstance();
        Rectangle2D editSize = interpreter.getEditSize();
        if (!editSize.contains(x, y, width, height)) {
            if (x < editSize.getX()) {
                x = editSize.getX();
            } else if (x + width > editSize.getMaxX()) {
                x = editSize.getMaxX() - width;
            }
            if (y < editSize.getY()) {
                y = editSize.getY();
            } else if (y + height > editSize.getMaxY()) {
                y = editSize.getMaxY() - height;
            }
        }
        return new Point2D.Double(x, y);
    }

    public static Point2D adjustmentPosition(Dimension documentSize, double x, double y, double width, double height) {
        if (x < 0.0) {
            x = 0.0;
        } else if (x + width > documentSize.getWidth() && (x = documentSize.getWidth() - width) < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        } else if (y + height > documentSize.getHeight() && (y = documentSize.getHeight() - height) < 0.0) {
            y = 0.0;
        }
        return new Point2D.Double(x, y);
    }

    public static final boolean aliasCanNotBeUsedByReaction(GLinkedShape shape, SpeciesAlias alias) {
        Species species;
        boolean bCanNotBeUsed = true;
        boolean bUnknow = false;
        if (shape != null && alias != null && (species = alias.getOriginalSpecies()) != null) {
            SBModel sbmd;
            boolean bBoundaryCondition = species.getBoundaryCondition();
            boolean bConstant = species.getConstant();
            if (!GMouseInterpreter.isModification(shape) && !bBoundaryCondition && bConstant) {
                return true;
            }
            if (!bBoundaryCondition && !bConstant && SBModel.isSpeciesBeUsedAsVariableByRule(sbmd = CelldUtil.getAimSBModel(species), species)) {
                return true;
            }
        }
        return false;
    }

    public void setTooltipString(InformationBox informationBox, SBase sbase) {
        if (informationBox == null || sbase == null) {
            return;
        }
        this.tooltipString = PopupSettingDialog.getPopupString(sbase);
        String info = InformationBox.getLabel(informationBox);
        this.tooltipString = CelldUtil.getHtmlText("&nbsp;" + StringTool.toEscape(info) + "&nbsp;");
    }

    public GElement getGelementForInformationBox(GElement gelementpat, double x, double y) {
        InformationBox gelement = null;
        if (gelementpat == null) {
            return gelement;
        }
        if (gelementpat instanceof CompartmentAlias) {
            CompartmentAlias compartment = (CompartmentAlias)((Object)gelementpat);
            if (compartment.getInfoBox() != null && !InformationBox.isEmptyState(compartment.getInfoBox().getStateString()) && compartment.getInfoBox().inShape(x, y)) {
                gelement = compartment.getInfoBox();
                return gelement;
            }
        } else if (gelementpat instanceof SpeciesAlias) {
            SpeciesAlias sp;
            Vector child;
            ComplexSpeciesAlias complexSpeciesAlias;
            if (gelementpat instanceof ComplexSpeciesAlias && ((complexSpeciesAlias = (ComplexSpeciesAlias)gelementpat).getCurrentView() == 0 || 2 == complexSpeciesAlias.getCurrentView()) && (child = complexSpeciesAlias.getAllTargetsInMe(false)) != null) {
                int c = 0;
                while (c < child.size()) {
                    SpeciesAlias childspeciesalias;
                    if (child.elementAt(c) instanceof SpeciesAlias && (childspeciesalias = (SpeciesAlias)child.elementAt(c)).getInfoBox() != null && !InformationBox.isEmptyState(childspeciesalias.getInfoBox().getStateString()) && childspeciesalias.getInfoBox().inShape(x, y)) {
                        gelement = childspeciesalias.getInfoBox();
                        return gelement;
                    }
                    ++c;
                }
            }
            if ((sp = (SpeciesAlias)gelementpat).getInfoBox() != null && !InformationBox.isEmptyState(sp.getInfoBox().getStateString()) && sp.getInfoBox().inShape(x, y)) {
                gelement = sp.getInfoBox();
                return gelement;
            }
        }
        return gelement;
    }

    public InformationBox getInformationBoxFromStructure(double x, double y) {
        Vector container;
        Vector containabel;
        InformationBox informationBox = null;
        Vector atoms = this.structure.getAtoms();
        if (atoms != null) {
            int cnt = atoms.size() - 1;
            while (cnt >= 0) {
                ElementSpeciesAlias elementSpeciesAlias = (ElementSpeciesAlias)atoms.elementAt(cnt);
                if (elementSpeciesAlias.getInfoBox() != null && !InformationBox.isEmptyState(elementSpeciesAlias.getInfoBox().getStateString()) && elementSpeciesAlias.getInfoBox().inShape(x, y)) {
                    GContainer container2 = elementSpeciesAlias.getContainer();
                    if (container2 != null && container2 instanceof ComplexSpeciesAlias) {
                        Vector<GContainer> parentNodes = new Vector<GContainer>();
                        parentNodes.add(container2);
                        this.structure.foundAllParentComplexNodes((ComplexSpeciesAlias)container2, parentNodes);
                        int tu = 0;
                        int i = 0;
                        while (i < parentNodes.size()) {
                            ComplexSpeciesAlias cmp = (ComplexSpeciesAlias)parentNodes.get(i);
                            if (cmp.getCurrentView() == -1 || cmp.getCurrentView() == 1 || cmp.getCurrentView() == 3) {
                                ++tu;
                            }
                            ++i;
                        }
                        if (tu == 0) {
                            informationBox = elementSpeciesAlias.getInfoBox();
                            return informationBox;
                        }
                    } else {
                        informationBox = elementSpeciesAlias.getInfoBox();
                        return informationBox;
                    }
                }
                --cnt;
            }
        }
        if ((containabel = this.structure.getContainableAtoms()) != null) {
            int con = 0;
            while (con < containabel.size()) {
                Vector vecchild;
                ComplexSpeciesAlias complexSpeciesAlias = (ComplexSpeciesAlias)containabel.elementAt(con);
                if ((complexSpeciesAlias.getCurrentView() == 0 || 2 == complexSpeciesAlias.getCurrentView()) && (vecchild = complexSpeciesAlias.getAllTargetsInMe(false)) != null) {
                    int c = 0;
                    while (c < vecchild.size()) {
                        SpeciesAlias childspeciesalias = (SpeciesAlias)vecchild.elementAt(c);
                        if (childspeciesalias.getInfoBox() != null && !InformationBox.isEmptyState(childspeciesalias.getInfoBox().getStateString()) && childspeciesalias.getInfoBox().inShape(x, y)) {
                            informationBox = childspeciesalias.getInfoBox();
                            return informationBox;
                        }
                        ++c;
                    }
                }
                if (complexSpeciesAlias.getInfoBox() != null && !InformationBox.isEmptyState(complexSpeciesAlias.getInfoBox().getStateString()) && complexSpeciesAlias.getInfoBox().inShape(x, y)) {
                    GContainer container3 = complexSpeciesAlias.getContainer();
                    if (container3 != null && container3 instanceof ComplexSpeciesAlias) {
                        Vector<GContainer> parentNodes = new Vector<GContainer>();
                        parentNodes.add(container3);
                        this.structure.foundAllParentComplexNodes((ComplexSpeciesAlias)container3, parentNodes);
                        int tu = 0;
                        int i = 0;
                        while (i < parentNodes.size()) {
                            ComplexSpeciesAlias cmp = (ComplexSpeciesAlias)parentNodes.get(i);
                            if (cmp.getCurrentView() == -1 || cmp.getCurrentView() == 1 || cmp.getCurrentView() == 3) {
                                ++tu;
                            }
                            ++i;
                        }
                        if (tu == 0) {
                            informationBox = complexSpeciesAlias.getInfoBox();
                            return informationBox;
                        }
                    } else {
                        informationBox = complexSpeciesAlias.getInfoBox();
                        return informationBox;
                    }
                }
                ++con;
            }
        }
        if ((container = this.structure.getContainers()) != null) {
            int size = container.size();
            int i = 0;
            while (i < size) {
                CompartmentAlias compartmentAlias;
                if (container.elementAt(i) instanceof CompartmentAlias && (compartmentAlias = (CompartmentAlias)container.elementAt(i)).getInfoBox() != null && !InformationBox.isEmptyState(compartmentAlias.getInfoBox().getStateString()) && compartmentAlias.getInfoBox().inShape(x, y)) {
                    informationBox = compartmentAlias.getInfoBox();
                    return informationBox;
                }
                ++i;
            }
        }
        return informationBox;
    }

    public GFramed creatSpecies(String strSpeciesType, String strNamecreatingSpecies, String strIDcreatingProtein, double dTargetPoint_x, double dTargetPoint_y) {
        GFramed creatingGFramed = (GFramed)this.factory.createObject("GENERIC");
        if (SBFactory.isProtein(strSpeciesType)) {
            Protein creatingProtein = new Protein();
            creatingProtein.setName(strNamecreatingSpecies);
            creatingProtein.setType(strSpeciesType);
            creatingProtein.setId(strIDcreatingProtein);
            creatingGFramed = (GFramed)this.factory.createObject(strSpeciesType);
            creatingGFramed.setFramePosition(dTargetPoint_x, dTargetPoint_y);
            SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(strSpeciesType));
            creatingGFramed.setFrameSize(briefSymbol.defaultSize().width, briefSymbol.defaultSize().height);
            MonoSpeciesShape mono = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed).getGFramedShape();
            MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
            property.setProtein(creatingProtein);
            property.setType("PROTEIN");
        } else if (SBFactory.isGene(strSpeciesType)) {
            Gene creatingGene = new Gene();
            creatingGene.setName(strNamecreatingSpecies);
            creatingGene.setType(strSpeciesType);
            creatingGene.setId(strIDcreatingProtein);
            creatingGFramed = (GFramed)this.factory.createObject(strSpeciesType);
            creatingGFramed.setFramePosition(dTargetPoint_x, dTargetPoint_y);
            SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(strSpeciesType));
            creatingGFramed.setFrameSize(briefSymbol.defaultSize().width, briefSymbol.defaultSize().height);
            MonoSpeciesShape mono = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed).getGFramedShape();
            MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
            property.setGene(creatingGene);
            property.setType(strSpeciesType);
        } else if (SBFactory.isRNA(strSpeciesType)) {
            RNA creatingRNA = new RNA();
            creatingRNA.setName(strNamecreatingSpecies);
            creatingRNA.setType(strSpeciesType);
            creatingRNA.setId(strIDcreatingProtein);
            creatingGFramed = (GFramed)this.factory.createObject(strSpeciesType);
            creatingGFramed.setFramePosition(dTargetPoint_x, dTargetPoint_y);
            SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(strSpeciesType));
            creatingGFramed.setFrameSize(briefSymbol.defaultSize().width, briefSymbol.defaultSize().height);
            MonoSpeciesShape mono = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed).getGFramedShape();
            MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
            property.setRNA(creatingRNA);
            property.setType(strSpeciesType);
        } else if (SBFactory.isAntiSenseRNA(strSpeciesType)) {
            AntiSenseRNA creatingARNA = new AntiSenseRNA();
            creatingARNA.setName(strNamecreatingSpecies);
            creatingARNA.setType(strSpeciesType);
            creatingARNA.setId(strIDcreatingProtein);
            creatingGFramed = (GFramed)this.factory.createObject(strSpeciesType);
            creatingGFramed.setFramePosition(dTargetPoint_x, dTargetPoint_y);
            SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(strSpeciesType));
            creatingGFramed.setFrameSize(briefSymbol.defaultSize().width, briefSymbol.defaultSize().height);
            MonoSpeciesShape mono = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed).getGFramedShape();
            MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
            property.setAntiSenseRNA(creatingARNA);
            property.setType(strSpeciesType);
        } else {
            creatingGFramed = (GFramed)this.factory.createObject(strSpeciesType);
            creatingGFramed.setFramePosition(dTargetPoint_x, dTargetPoint_y);
            SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(strSpeciesType));
            creatingGFramed.setFrameSize(briefSymbol.defaultSize().width, briefSymbol.defaultSize().height);
            MonoSpeciesShape mono = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed).getGFramedShape();
            MonoSpeciesProperty property = (MonoSpeciesProperty)mono.getProperty();
            property.setName(strNamecreatingSpecies);
            property.setType(strSpeciesType);
        }
        return creatingGFramed;
    }

    private class ElementSelector {
        private GFramed resizingGFramed = null;
        private GPointed resizingGPointed = null;
        private GResizeHandle resizingHandle = null;
        private GEditPoint movingGEditPoint = null;
        private GElement movingGElement = null;
        private double mouseDownX = 0.0;
        private double mouseDownY = 0.0;
        private double startX = 0.0;
        private double startY = 0.0;
        private double startWidth = 0.0;
        private double startHeight = 0.0;
        private Rectangle2D.Double selectRect = null;
        private Rectangle2D selectRectPre = null;
        private List dragSelecteds = new ArrayList();
        private List dragSelectSkips = new ArrayList();
        private Point2D.Double pntPressedGElementFrameBoundCenterPosBak = null;
        private GEditPoint movingGEditPoint2 = null;
        private GElement pressedGElement = null;
        private Vector startXYVec = new Vector();
        private GMouseInterpreter interpreter;
        private GLinkHandleMover linkHandleMover;
        private GStructure structure;
        private ElementPosition elpos;

        public ElementSelector(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
            this.elpos = new ElementPosition();
            this.linkHandleMover = new GLinkHandleMover();
        }

        public void setStructure(GStructure structure) {
            this.structure = structure;
        }

        private boolean isMove() {
            return this.movingGElement != null;
        }

        private boolean isSelect() {
            return this.selectRect != null;
        }

        private boolean isResize() {
            return this.resizingGFramed != null;
        }

        private boolean isMovePoint() {
            return this.movingGEditPoint != null;
        }

        private Rectangle2D clear() {
            Rectangle2D.Double redrawArea = null;
            try {
                if (this.movingGEditPoint.getOwner() instanceof GLinkedShape) {
                    GLink owner = this.structure.getOwnerLink(this.movingGEditPoint);
                    GLinkTarget[] targets = owner.getTargets();
                    int i = 0;
                    while (i < targets.length) {
                        if (targets[i] instanceof GElement) {
                            Rectangle2D area1 = this.structure.highlightAsTarget((GElement)((Object)targets[i]), false, false);
                            redrawArea = GUtil.union(area1, redrawArea);
                        }
                        Rectangle2D area2 = this.structure.hideLinkAnchors(targets[i], false);
                        redrawArea = GUtil.union(area2, redrawArea);
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.structure.setSelectRect(null);
            this.selectRect = null;
            this.selectRectPre = null;
            this.dragSelecteds.clear();
            this.dragSelectSkips.clear();
            this.resizingGFramed = null;
            this.resizingHandle = null;
            this.resizingGPointed = null;
            this.movingGEditPoint = null;
            this.movingGEditPoint2 = null;
            this.movingGElement = null;
            this.structure.setMovingElement(null);
            return redrawArea;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interpret(double x, double y, MouseEvent e) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                block21: {
                    Rectangle2D redrawArea = null;
                    if (GMouseInterpreter.this.popupMenuShowFlag) {
                        boolean bCancel = false;
                        switch (e.getID()) {
                            case 506: {
                                bCancel = true;
                                GMouseInterpreter.this.popupMenuShowFlag = false;
                                break;
                            }
                            case 502: {
                                bCancel = true;
                                GMouseInterpreter.this.popupMenuShowFlag = false;
                            }
                        }
                        if (bCancel) {
                            GMouseInterpreter.this.popupMenuShowFlag = false;
                            redrawArea = this.mousePressed(x, y, e);
                            this.structure.notifyRepaint(redrawArea);
                            return;
                        }
                    }
                    try {
                        try {
                            this.structure.setBypassDrawFlg(true);
                            switch (e.getID()) {
                                case 503: {
                                    this.mouseMoved(x, y, e);
                                    break;
                                }
                                case 506: {
                                    redrawArea = this.mouseDragged(x, y, e);
                                    break;
                                }
                                case 501: {
                                    redrawArea = this.mousePressed(x, y, e);
                                    break;
                                }
                                case 502: {
                                    long startTime = System.currentTimeMillis();
                                    Debug.outputDebugMessage("f", "startTime @ GMouseInterpreter interpret(double x, double y, MouseEvent e): " + startTime, 0);
                                    redrawArea = this.mouseReleased(x, y, e);
                                    if (!Preference.isDebug) break;
                                    long endTime = System.currentTimeMillis();
                                    Debug.outputDebugMessage("f", "endTime   @ GMouseInterpreter interpret(double x, double y, MouseEvent e): " + endTime, 0);
                                    long ms = endTime - startTime;
                                    Debug.outputDebugMessage("f", "elapsed   @ GMouseInterpreter interpret(double x, double y, MouseEvent e): " + ms + " ms   <<========", 0);
                                    int iseconds = (int)(ms / 1000L);
                                    String strMs = "" + ms;
                                    String strSecs = "000" + strMs;
                                    Debug.outputDebugMessage("f", "elapsed   @ GMouseInterpreter interpret(double x, double y, MouseEvent e): " + iseconds + "." + strSecs.substring(strSecs.length() - 3, strSecs.length() - 1) + " seconds", 0);
                                    Debug.outputDebugMessage("f", "", 0);
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.structure.setBypassDrawFlg(false);
                            SBModelFrame currentSBFrame = MainWindow.getLastInstance().getCurrentModel();
                            this.structure.callbyuserRepaint(currentSBFrame.getLogicalViewArea());
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        this.structure.setBypassDrawFlg(false);
                        SBModelFrame currentSBFrame = MainWindow.getLastInstance().getCurrentModel();
                        this.structure.callbyuserRepaint(currentSBFrame.getLogicalViewArea());
                        throw throwable;
                    }
                    this.structure.setBypassDrawFlg(false);
                    SBModelFrame currentSBFrame = MainWindow.getLastInstance().getCurrentModel();
                    this.structure.callbyuserRepaint(currentSBFrame.getLogicalViewArea());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D mouseDragged(double x, double y, MouseEvent e) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                block11: {
                    if (!SwingUtilities.isRightMouseButton(e)) break block11;
                    return null;
                }
                Object redrawArea = null;
                double dx = x - this.mouseDownX;
                double dy = y - this.mouseDownY;
                if (this.movingGElement instanceof InformationBox && ((InformationBox)this.movingGElement).getCenterPoint() != null && this.pntPressedGElementFrameBoundCenterPosBak != null) {
                    double dx1 = ((InformationBox)this.movingGElement).getCenterPoint().x - this.pntPressedGElementFrameBoundCenterPosBak.x;
                    double dy1 = ((InformationBox)this.movingGElement).getCenterPoint().y - this.pntPressedGElementFrameBoundCenterPosBak.y;
                    ((InformationBox)this.movingGElement).setDeltaPoint2DUsingOnlyByMoving(dx - dx1, dy - dy1);
                }
                if (!(this.isMove() || this.isResize() || this.isMovePoint() || this.resizingGPointed != null)) {
                    return this.doSelect(x, y);
                }
                if (this.isResize()) {
                    return this.resizeGFramed(x, y, dx, dy);
                }
                this.setGridSnapPosition(dx, dy);
                if (this.isMove()) {
                    GLinkedShape glinkedshape;
                    this.structure.setTemp_dx(dx);
                    this.structure.setTemp_dy(dy);
                    if (this.movingGElement instanceof GLink && !(glinkedshape = ((GLink)this.movingGElement).getGLinkedShape()).isMovable() && glinkedshape instanceof LayerReactionSymbol && !(glinkedshape instanceof LayerTagFreeLineSymbol)) {
                        return this.doMove(this.elpos.xpos, this.elpos.ypos, dx, dy);
                    }
                    return this.doMove(this.elpos.xpos, this.elpos.ypos);
                }
                if (this.resizingGPointed != null) {
                    return this.resizeGPointed(this.elpos.xpos, this.elpos.ypos);
                }
                if (this.isMovePoint()) {
                    return this.movePoint(this.elpos.xpos, this.elpos.ypos, e);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mouseMoved(double x, double y, MouseEvent e) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                GElement temp;
                GElement gelement = this.structure.getElement(x, y);
                if (gelement != null) {
                    gelement.getName();
                    gelement = this.structure.getElement(x, y);
                }
                GMouseInterpreter.this.cursorstate = 0;
                GMouseInterpreter.this.tooltipString = null;
                if (gelement != null && (temp = GMouseInterpreter.this.getGelementForInformationBox(gelement, x, y)) != null) {
                    gelement = temp;
                }
                if (gelement != null) {
                    Object alias;
                    InformationBox ib;
                    Object parent;
                    if (gelement instanceof GEditPoint || gelement instanceof GResizeHandle) {
                        GMouseInterpreter.this.cursorstate = 1;
                    }
                    if (gelement instanceof InformationBox && (parent = (ib = (InformationBox)gelement).getInfoParent()) != null) {
                        if (parent instanceof CompartmentAlias) {
                            CompartmentAlias compartmentAlias = (CompartmentAlias)parent;
                            GMouseInterpreter.this.setTooltipString(ib, (SBase)compartmentAlias.getOriginalCompartment());
                        } else if (parent instanceof SpeciesAlias) {
                            SpeciesAlias speciesAlias = (SpeciesAlias)parent;
                            GMouseInterpreter.this.setTooltipString(ib, (SBase)speciesAlias.getOriginalSpecies());
                        }
                    }
                    if (gelement instanceof GLink) {
                        GMouseInterpreter.this.cursorstate = 13;
                        if (gelement instanceof ReactionLink) {
                            ReactionLink link = (ReactionLink)gelement;
                            Reaction r = link.getParentReaction();
                            GMouseInterpreter.this.tooltipString = PopupSettingDialog.getPopupString((SBase)r);
                        }
                    }
                    if (gelement instanceof GAtom) {
                        Species s;
                        if (gelement instanceof SpeciesAlias && (s = (alias = (SpeciesAlias)gelement).getOriginalSpecies()) != null) {
                            ModificationShape mshp;
                            GMouseInterpreter.this.tooltipString = PopupSettingDialog.getPopupString((SBase)s);
                            GFramedShape gfshape = alias.getGFramedShape();
                            if (gfshape instanceof MonoSpeciesShape && (mshp = ((MonoSpeciesShape)gfshape).getModificationShapeOfSpeciesInformatBoxWhithPoint(x, y)) != null) {
                                String[][] strRtnTipArr = ModificationShape.getSpeciesInformatShowingInMouseTooltip(mshp);
                                String strRtnTip = null;
                                try {
                                    strRtnTip = strRtnTipArr[0][0];
                                }
                                catch (Exception myErr) {
                                    strRtnTip = null;
                                }
                                if (strRtnTip != null) {
                                    GMouseInterpreter.this.tooltipString = "<html>\t<body>" + strRtnTip + "\t</body>" + "</html>";
                                }
                            }
                        }
                    } else if (gelement instanceof GFramedContainer) {
                        Compartment c;
                        if (gelement instanceof CompartmentAlias && (c = (alias = (CompartmentAlias)((Object)gelement)).getOriginalCompartment()) != null) {
                            GMouseInterpreter.this.tooltipString = PopupSettingDialog.getPopupString((SBase)c);
                        }
                    } else if (gelement instanceof GGroup) {
                        GGroup group = (GGroup)gelement;
                        boolean hit = false;
                        int i = 0;
                        while (i < group.getMembers().size()) {
                            GElement member = (GElement)group.getMembers().get(i);
                            if (member.intersects(new Rectangle2D.Double(x, y, 1.0, 1.0))) {
                                Compartment c;
                                Object alias2;
                                if (member instanceof GAtom) {
                                    alias2 = (SpeciesAlias)member;
                                    Species s = alias2.getOriginalSpecies();
                                    if (s != null) {
                                        GMouseInterpreter.this.tooltipString = PopupSettingDialog.getPopupString((SBase)s);
                                        hit = true;
                                        break;
                                    }
                                } else if (member instanceof GFramedContainer && (c = (alias2 = (CompartmentAlias)((Object)member)).getOriginalCompartment()) != null) {
                                    GMouseInterpreter.this.tooltipString = PopupSettingDialog.getPopupString((SBase)c);
                                    hit = true;
                                    break;
                                }
                            }
                            ++i;
                        }
                        if (!hit) {
                            Vector listOfLinks = this.structure.getLinks();
                            int j = 0;
                            while (j < listOfLinks.size()) {
                                GLink glink = (GLink)listOfLinks.get(j);
                                if (glink.inShape(x, y)) {
                                    ReactionLink link = (ReactionLink)glink;
                                    Reaction r = link.getParentReaction();
                                    GMouseInterpreter.this.tooltipString = PopupSettingDialog.getPopupString((SBase)r);
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                } else {
                    Object parent;
                    InformationBox informationBox = GMouseInterpreter.this.getInformationBoxFromStructure(x, y);
                    if (informationBox != null && (parent = informationBox.getInfoParent()) != null) {
                        if (parent instanceof CompartmentAlias) {
                            CompartmentAlias comparent = (CompartmentAlias)parent;
                            GMouseInterpreter.this.setTooltipString(informationBox, (SBase)comparent.getOriginalCompartment());
                        } else if (parent instanceof SpeciesAlias) {
                            SpeciesAlias spparent = (SpeciesAlias)parent;
                            GMouseInterpreter.this.setTooltipString(informationBox, (SBase)spparent.getOriginalSpecies());
                        }
                    }
                }
            }
        }

        private void selectHeaderPointBySelectingCompartment(CompartmentAlias compartment) {
            Vector links = this.structure.getLinks();
            int size = links.size();
            int i = 0;
            while (i < size) {
                GLink link = (GLink)links.elementAt(i);
                if (link.getGLinkedShape() instanceof GLogicGate) {
                    Point2D.Double point = ((GLogicGate)link.getGLinkedShape()).getHeaderPoint().getPosition();
                    if (((GElement)((Object)compartment)).inShape(point.x, point.y)) {
                        this.structure.getSelecteds().remove(((GLogicGate)link.getGLinkedShape()).getHeaderPoint());
                        this.structure.getSelecteds().add(((GLogicGate)link.getGLinkedShape()).getHeaderPoint());
                    }
                }
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D mousePressed(double x, double y, MouseEvent e) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                GElement temp;
                block70: {
                    if (!this.showPopup(x, y, e)) break block70;
                    return null;
                }
                Rectangle2D r = null;
                this.mouseDownX = x;
                this.mouseDownY = y;
                this.resizingGFramed = null;
                this.resizingHandle = null;
                this.resizingGPointed = null;
                this.movingGEditPoint = null;
                this.movingGEditPoint2 = null;
                this.movingGElement = null;
                this.pressedGElement = null;
                this.pntPressedGElementFrameBoundCenterPosBak = null;
                GElement gelement = this.structure.getElement(x, y);
                if (gelement != null && (temp = GMouseInterpreter.this.getGelementForInformationBox(gelement, x, y)) != null) {
                    gelement = temp;
                }
                if (gelement != null) {
                    this.pressedGElement = gelement;
                    if (this.pressedGElement instanceof CompartmentAlias) {
                        CompartmentAlias compartment = (CompartmentAlias)((Object)this.pressedGElement);
                        compartment.backupNameImagePositionBeforeChangeCompartment();
                    }
                    Vector elements = this.structure.getSelecteds();
                    int i = 0;
                    while (elements != null && i < elements.size()) {
                        GElement element = (GElement)elements.get(i);
                        if (element instanceof CompartmentAlias) {
                            CompartmentAlias compartment = (CompartmentAlias)((Object)element);
                            compartment.backupNameImagePositionBeforeChangeCompartment();
                        }
                        ++i;
                    }
                    if (this.pressedGElement instanceof InformationBox) {
                        this.structure.deselectAll();
                        InformationBox ib = (InformationBox)this.pressedGElement;
                        this.movingGElement = ib;
                        this.movingGElement.setHighlighted(true);
                        r = this.structure.select(ib, false, false, false);
                        Point2D.Double point = GStructure.getPosition(ib);
                        this.startX = ((Point2D)point).getX();
                        this.startY = ((Point2D)point).getY();
                        this.startXYVec.clear();
                        this.startXYVec.add(new ElementAndPosition(ib, -1, point));
                        this.pntPressedGElementFrameBoundCenterPosBak = ((InformationBox)this.movingGElement).getCenterPoint();
                        ib.backupAngleBeforeChangeInfo();
                        this.selectRect = null;
                        return r;
                    }
                    if (gelement instanceof GLink) {
                        GLinkedShape glinkedshape = ((GLink)gelement).getGLinkedShape();
                        if (glinkedshape instanceof GLogicGate) {
                            glinkedshape = ((GLogicGate)glinkedshape).getRealLine();
                        }
                        if (glinkedshape.isMovable()) {
                            GEditPoint[] points;
                            GLinkedLineIndex index;
                            if (glinkedshape instanceof GLinkedCreaseLine) {
                                index = ((GLinkedCreaseLine)glinkedshape).getLineIndex(x, y);
                                int size = ((GLinkedCreaseLine)glinkedshape).getCreasePointsSize();
                                points = ((GLinkedCreaseLine)glinkedshape).getEditPoints();
                                if (index != null && index.line >= 0 && index.line <= size) {
                                    if (index.line == 0) {
                                        gelement = points[0];
                                    } else if (index.line == size) {
                                        gelement = points[size - 1];
                                    } else {
                                        gelement = points[index.line - 1];
                                        this.movingGEditPoint2 = points[index.line];
                                    }
                                }
                            } else if (glinkedshape instanceof GLinkedLineComplex3) {
                                index = ((GLinkedLineComplex3)glinkedshape).getLineIndex(x, y);
                                points = ((GLinkedLineComplex3)glinkedshape).getEditPoints();
                                int addIndex = 0;
                                int i2 = 0;
                                while (i2 < 3 && i2 < index.arm) {
                                    GLinkedLine line1 = ((GLinkedLineComplex3)glinkedshape).getLine(i2);
                                    int size1 = ((GEditable)((Object)line1)).getEditPoints().length;
                                    addIndex += size1;
                                    ++i2;
                                }
                                GLinkedLine line1 = ((GLinkedLineComplex3)glinkedshape).getLine(index.arm);
                                int size = ((GEditable)((Object)line1)).getEditPoints().length;
                                if (index != null && index.line >= 0 && index.line <= size) {
                                    if (index.line == 0) {
                                        gelement = points[points.length - 1];
                                        this.movingGEditPoint2 = points[addIndex + 0];
                                    } else if (index.line == size) {
                                        gelement = points[addIndex + size - 1];
                                    } else {
                                        gelement = points[addIndex + index.line - 1];
                                        this.movingGEditPoint2 = points[addIndex + index.line];
                                    }
                                }
                            } else if (glinkedshape instanceof GLinkedCurveAndLine) {
                                int lineIndex = ((GLinkedCurveAndLine)glinkedshape).getLineIndex(x, y);
                                int size = ((GLinkedCurveAndLine)glinkedshape).getCreasePointsSize();
                                points = ((GLinkedCurveAndLine)glinkedshape).getEditPoints();
                                if (lineIndex >= 0 && lineIndex <= size) {
                                    if (lineIndex == 0) {
                                        gelement = points[0];
                                    } else if (lineIndex == size) {
                                        gelement = points[size - 1];
                                    } else {
                                        gelement = points[lineIndex - 1];
                                        this.movingGEditPoint2 = points[lineIndex];
                                    }
                                }
                            }
                        }
                        if (gelement instanceof LayerReactionLink) {
                            GLinkedCreaseLine line = (GLinkedCreaseLine)glinkedshape;
                            line.starttemp = (Point2D.Double)line.lines[0].start.clone();
                            line.endtemp = (Point2D.Double)line.lines[0].end.clone();
                        }
                    }
                    if (gelement instanceof GResizeHandle) {
                        this.resizingHandle = (GResizeHandle)gelement;
                        if (gelement instanceof GFrameHandle) {
                            NameImage nameImage;
                            this.resizingGFramed = ((GFrameHandle)this.resizingHandle).getOwner();
                            Point2D.Double pos1 = this.resizingGFramed.getFramePosition();
                            this.startX = ((Point2D)pos1).getX();
                            this.startY = ((Point2D)pos1).getY();
                            this.startXYVec.clear();
                            this.startXYVec.add(new ElementAndPosition(gelement, -1, pos1));
                            Point2D.Double var_double_2_ = this.resizingGFramed.getFrameSize();
                            this.startWidth = ((Point2D)var_double_2_).getX();
                            this.startHeight = ((Point2D)var_double_2_).getY();
                            if (this.resizingGFramed instanceof CompartmentAlias && (nameImage = ((CompartmentAlias)((Object)this.resizingGFramed)).getCompartmentNameImage()) != null) {
                                nameImage.backupPosition();
                            }
                        } else if (gelement instanceof GPointHandle) {
                            NameImage nameImage;
                            this.resizingGPointed = ((GPointHandle)this.resizingHandle).getOwner();
                            Point2D.Double pos1 = this.resizingGPointed.getPoint();
                            this.startX = ((Point2D)pos1).getX();
                            this.startY = ((Point2D)pos1).getY();
                            this.startXYVec.clear();
                            this.startXYVec.add(new ElementAndPosition(gelement, -1, pos1));
                            if (this.resizingGPointed instanceof CompartmentAlias && (nameImage = ((CompartmentAlias)((Object)this.resizingGPointed)).getCompartmentNameImage()) != null) {
                                nameImage.backupPosition();
                            }
                        }
                    } else if (gelement instanceof GEditPoint) {
                        this.movingGEditPoint = (GEditPoint)gelement;
                        this.structure.setMovingElement(this.movingGEditPoint);
                        Point2D.Double pos1 = this.movingGEditPoint.getPosition();
                        this.startX = ((Point2D)pos1).getX();
                        this.startY = ((Point2D)pos1).getY();
                        this.startXYVec.clear();
                        this.movingGEditPoint.appendMovingPointAndPosition(this.startXYVec);
                        if (this.movingGEditPoint2 != null) {
                            pos1 = this.movingGEditPoint2.getPosition();
                            this.movingGEditPoint2.appendMovingPointAndPosition(this.startXYVec);
                        } else {
                            this.movingGEditPoint.appendAdditionalMovingPointAndPosition(this.startXYVec);
                        }
                        GLink glink = this.structure.getOwnerLink(this.movingGEditPoint);
                        if (glink == null) {
                            try {
                                if (this.movingGEditPoint != null && this.movingGEditPoint instanceof GCreasePoint && ((GCreasePoint)this.movingGEditPoint).getOwner() != null && ((GCreasePoint)this.movingGEditPoint).getOwner() instanceof LinkedCreaseLine) {
                                    LinkedCreaseLine memberodificationLine = (LinkedCreaseLine)((GCreasePoint)this.movingGEditPoint).getOwner();
                                    glink = this.structure.getOwnerLink(memberodificationLine.getLogicGate());
                                }
                            }
                            catch (Exception myErr) {
                                glink = null;
                            }
                        }
                        if (GMouseInterpreter.this.isMultiSelectMode && this.structure.isSelected(glink)) {
                            r = this.structure.deselect(glink);
                        } else {
                            if (!GMouseInterpreter.this.isMultiSelectMode && !this.structure.isSelected(glink)) {
                                this.structure.deselectAll();
                            }
                            if (!this.structure.isSelected(glink)) {
                                r = this.structure.select(glink);
                            }
                        }
                        if (this.movingGEditPoint instanceof GLinkHandlePoint) {
                            r = GUtil.union(this.linkHandleMover.init(this.structure, (GLinkHandlePoint)this.movingGEditPoint, x, y), r);
                        }
                    } else if (this.interpreter.isMultiSelectMode() && this.structure.isSelected(gelement)) {
                        r = this.structure.deselect(gelement);
                        this.structure.resetList();
                    } else {
                        if (!this.interpreter.isMultiSelectMode() && !this.structure.isSelected(gelement)) {
                            this.structure.deselectAll();
                        }
                        if (!this.structure.isSelected(gelement)) {
                            r = this.structure.select(gelement);
                        } else {
                            SpeciesAlias sa;
                            MainWindow.getLastInstance().getGeneralNotesAction().setEnabled(false);
                            MainWindow.getLastInstance().getProteinNotesAction().setEnabled(false);
                            String strNote = MainWindow.getLastInstance().getCurrentModel().getSelectedObjectsInfomation();
                            SBase selectedsbase = MainWindow.getLastInstance().getCurrentModel().getSelectedSBase();
                            MainWindow.getMiriamMainPanel().setDialogFromObject(selectedsbase);
                            if (strNote != null) {
                                MainWindow.getLastInstance().getNotesDisplayPanel().setInformation(strNote);
                                if (!strNote.equals("")) {
                                    MainWindow.getLastInstance().componentSelectionChanged();
                                }
                            } else {
                                MainWindow.getLastInstance().getNotesDisplayPanel().setInformation("");
                            }
                            if (gelement instanceof SpeciesAlias && (sa = (SpeciesAlias)gelement).getOriginalSpecies() != null && !SwingUtilities.isRightMouseButton(e) && 502 != e.getID()) {
                                MainWindow.getLastInstance().getCurrentModel().getSBModel().reNotifyModelHighlighter(1, sa.getOriginalSpecies());
                            }
                        }
                        this.movingGElement = gelement;
                        this.structure.setMovingElement(this.movingGElement);
                        if (gelement instanceof CompartmentAlias) {
                            this.selectHeaderPointBySelectingCompartment((CompartmentAlias)((Object)gelement));
                        }
                        Point2D.Double point = GStructure.getPosition(gelement);
                        this.startX = ((Point2D)point).getX();
                        this.startY = ((Point2D)point).getY();
                        this.startXYVec.clear();
                        this.startXYVec.add(new ElementAndPosition(gelement, -1, point));
                        if (this.movingGElement instanceof OpenedCompartmentAlias) {
                            ((OpenedCompartmentAlias)this.movingGElement).backupNameImagePosition();
                        }
                        this.selectRect = null;
                    }
                } else {
                    this.structure.deselectAll();
                    Vector container = this.structure.getContainers();
                    int size = container.size();
                    int i = 0;
                    while (i < size) {
                        CompartmentAlias compartmentAlias;
                        NameImage nameImage;
                        if (container.elementAt(i) instanceof CompartmentAlias && (nameImage = (compartmentAlias = (CompartmentAlias)container.elementAt(i)).getCompartmentNameImage()).inShape(x, y)) {
                            this.movingGElement = nameImage;
                            this.movingGElement.setHighlighted(true);
                            r = this.structure.select(nameImage, false, false, false);
                            Point2D.Double point = GStructure.getPosition(nameImage);
                            this.startX = ((Point2D)point).getX();
                            this.startY = ((Point2D)point).getY();
                            this.startXYVec.clear();
                            this.startXYVec.add(new ElementAndPosition(nameImage, -1, point));
                            this.selectRect = null;
                            return r;
                        }
                        ++i;
                    }
                    InformationBox informationBox = GMouseInterpreter.this.getInformationBoxFromStructure(x, y);
                    if (informationBox != null) {
                        this.movingGElement = informationBox;
                        this.movingGElement.setHighlighted(true);
                        r = this.structure.select(informationBox, false, false, false);
                        Point2D.Double point = GStructure.getPosition(informationBox);
                        this.startX = ((Point2D)point).getX();
                        this.startY = ((Point2D)point).getY();
                        this.startXYVec.clear();
                        this.startXYVec.add(new ElementAndPosition(informationBox, -1, point));
                        this.pntPressedGElementFrameBoundCenterPosBak = ((InformationBox)this.movingGElement).getCenterPoint();
                        informationBox.backupAngleBeforeChangeInfo();
                        this.selectRect = null;
                        return r;
                    }
                    this.selectRect = new Rectangle2D.Double(this.mouseDownX, this.mouseDownY, 0.0, 0.0);
                    this.structure.setSelectRect(this.selectRect);
                }
                return r;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D mouseReleased(double x, double y, MouseEvent e) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                double ypos;
                double xpos;
                Rectangle2D editSize;
                Rectangle2D redrawArea;
                double dy;
                double dx;
                block71: {
                    block70: {
                        if (this.structure.isMoveMode() || !this.showPopup(x, y, e)) break block70;
                        return null;
                    }
                    dx = x - this.mouseDownX;
                    dy = y - this.mouseDownY;
                    redrawArea = null;
                    editSize = this.interpreter.getEditSize();
                    xpos = this.elpos.xpos;
                    ypos = this.elpos.ypos;
                    if (!SwingUtilities.isRightMouseButton(e)) break block71;
                    if (this.structure.isMoveMode() || this.structure.isSelectMode()) {
                        this.structure.setMoveMode(false);
                        this.structure.setLinkMoveMode(false);
                        this.structure.setSelectMode(false);
                        Rectangle2D r = this.structure.getRepaintArea();
                        this.structure.setRepaintArea(null);
                        this.structure.deselectAll();
                        r = GUtil.union(this.clear(), r);
                        return r;
                    }
                    return null;
                }
                if (dx == 0.0 && dy == 0.0) {
                    if (this.movingGEditPoint != null) {
                        boolean cfr_ignored_0 = this.movingGEditPoint instanceof GLinkHandlePoint;
                    }
                    redrawArea = GUtil.union(this.clear(), redrawArea);
                    return redrawArea;
                }
                this.structure.setMoveMode(false);
                this.structure.setLinkMoveMode(false);
                this.structure.setRepaintArea(null);
                if (this.isMove()) {
                    Rectangle2D rect;
                    if (this.movingGElement instanceof GLink) {
                        GLinkedShape glinkedshape = ((GLink)this.movingGElement).getGLinkedShape();
                        if (glinkedshape instanceof LayerReactionSymbol) {
                            boolean cancel = false;
                            Vector elements = this.structure.getSelecteds();
                            Rectangle2D.Double rect2 = null;
                            int i = 0;
                            while (i < elements.size()) {
                                GElement element = (GElement)elements.get(i);
                                rect2 = element instanceof GFramed ? ((GFramed)((Object)element)).getFrameBounds() : element.getBounds();
                                if (!editSize.contains(rect2)) {
                                    cancel = true;
                                    break;
                                }
                                ++i;
                            }
                            if (Math.abs(x - this.mouseDownX) < 1.01 && Math.abs(y - this.mouseDownY) < 1.01) {
                                cancel = true;
                            }
                            rect2 = glinkedshape.getShapeBounds();
                            if (cancel || !editSize.contains(rect2)) {
                                GLinkedCreaseLine shape = (GLinkedCreaseLine)glinkedshape;
                                this.structure.setTemp_dx(0.0);
                                this.structure.setTemp_dy(0.0);
                                redrawArea = this.structure.moveSelectedElements(this.movingGElement, this.startX, this.startY);
                                return redrawArea;
                            }
                            this.structure.moveSelectedElements(this.movingGElement, this.startX, this.startY);
                            this.structure.setTemp(true);
                            this.structure.moveSelecteds(this.movingGElement, xpos, ypos);
                            this.structure.setTemp(false);
                        }
                        if (!glinkedshape.isMovable()) {
                            redrawArea = this.clear();
                            return redrawArea;
                        }
                    }
                    Debug.outputDebugMessage("f", "currentTimeMillis 111 @ GMouseInterpreter private Rectangle2D mouseReleased(double x, double y, MouseEvent e): " + System.currentTimeMillis(), 0);
                    boolean cancel = false;
                    if (Math.abs(x - this.mouseDownX) < 2.0 && Math.abs(y - this.mouseDownY) < 2.0) {
                        cancel = true;
                    } else {
                        Vector elements = this.structure.getSelecteds();
                        rect = null;
                        int i = 0;
                        while (i < elements.size()) {
                            GElement element = (GElement)elements.get(i);
                            if (element instanceof GFramed) {
                                rect = ((GFramed)((Object)element)).getFrameBounds();
                                if (element instanceof ClosedCompartmentAlias) {
                                    rect = ((ClosedCompartmentAlias)element).getCompartmentMaxRepaintBounds();
                                } else if (element instanceof SpeciesAlias) {
                                    rect = ((SpeciesAlias)element).getMaxRepaintBounds();
                                }
                            } else {
                                rect = element.getBounds();
                                if (element instanceof OpenedCompartmentAlias) {
                                    rect = ((OpenedCompartmentAlias)element).getCompartmentMaxRepaintBounds();
                                }
                            }
                            if (!editSize.contains(rect) && !(element instanceof NameImage)) {
                                cancel = true;
                                break;
                            }
                            this.structure.changeComplexOrder(element, rect);
                            ++i;
                        }
                    }
                    Debug.outputDebugMessage("f", "currentTimeMillis 222 @ GMouseInterpreter private Rectangle2D mouseReleased(double x, double y, MouseEvent e): " + System.currentTimeMillis(), 0);
                    if (cancel) {
                        this.structure.setTemp_dx(0.0);
                        this.structure.setTemp_dy(0.0);
                        redrawArea = this.structure.moveSelectedElements(this.movingGElement, this.startX, this.startY);
                        Vector elements = this.structure.getSelecteds();
                        rect = null;
                        if (this.movingGElement instanceof CompartmentAlias) {
                            CompartmentAlias compartment = (CompartmentAlias)((Object)this.movingGElement);
                            rect = compartment.restoreNameImagePositionAfterChangeCompartmentCancled();
                            redrawArea = GUtil.union(redrawArea, rect);
                        }
                        int i = 0;
                        while (elements != null && i < elements.size()) {
                            GElement element = (GElement)elements.get(i);
                            if (element instanceof CompartmentAlias) {
                                CompartmentAlias compartment = (CompartmentAlias)((Object)element);
                                rect = compartment.restoreNameImagePositionAfterChangeCompartmentCancled();
                                redrawArea = GUtil.union(redrawArea, rect);
                            }
                            ++i;
                        }
                        if (this.movingGElement instanceof InformationBox) {
                            InformationBox informationBox = (InformationBox)this.movingGElement;
                            rect = informationBox.restoreAngleAfterChangeInfoCancled();
                            redrawArea = GUtil.union(redrawArea, rect);
                        }
                    } else {
                        Rectangle2D.Double redrawAreaTmp = null;
                        try {
                            if (this.movingGElement instanceof ClosedCompartmentAlias) {
                                Rectangle2D redrawAreaTmp1 = (Rectangle2D)((ClosedCompartmentAlias)this.movingGElement).getCompartmentMaxRepaintBounds().clone();
                                redrawAreaTmp = GUtil.union(redrawAreaTmp, redrawAreaTmp1);
                            }
                            int i = 0;
                            while (this.structure.getSelecteds() != null && i < this.structure.getSelecteds().size()) {
                                if (this.structure.getSelecteds().get(i) instanceof ClosedCompartmentAlias) {
                                    Rectangle2D redrawAreaTmp2 = (Rectangle2D)((ClosedCompartmentAlias)this.structure.getSelecteds().get(i)).getCompartmentMaxRepaintBounds().clone();
                                    redrawAreaTmp = GUtil.union(redrawAreaTmp, redrawAreaTmp2);
                                }
                                ++i;
                            }
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                        if (this.movingGElement instanceof NameImage) {
                            Point2D.Double nearestPoint = ((NameImage)this.movingGElement).getNearestPointInParent(new Point2D.Double(xpos, ypos));
                            xpos = nearestPoint.x;
                            ypos = nearestPoint.y;
                        }
                        this.structure.moveSelectedElements(this.movingGElement, this.startX, this.startY);
                        Debug.outputDebugMessage("f", "currentTimeMillis 333 @ GMouseInterpreter private Rectangle2D mouseReleased(double x, double y, MouseEvent e): " + System.currentTimeMillis(), 0);
                        this.structure.moveSelecteds(this.movingGElement, xpos, ypos);
                        try {
                            Point2D.Double pnt = null;
                            if (this.movingGElement instanceof ClosedCompartmentAlias) {
                                Rectangle2D redrawAreaTmp1 = (Rectangle2D)((ClosedCompartmentAlias)this.movingGElement).getCompartmentMaxRepaintBounds().clone();
                                try {
                                    pnt = (Point2D.Double)((ClosedCompartmentAlias)this.movingGElement).getCompartmentNameImage().getFramePosition().clone();
                                    pnt = ((ClosedCompartmentAlias)this.movingGElement).recalCompartmentNameDisplayPostion(new Point2D.Double(pnt.x, pnt.y));
                                    ((ClosedCompartmentAlias)this.movingGElement).getCompartmentNameImage().setFramePositionWithoutRecalcPostion(pnt.x, pnt.y);
                                    Rectangle2D redrawAreaTmp2 = (Rectangle2D)((ClosedCompartmentAlias)this.movingGElement).getCompartmentMaxRepaintBounds().clone();
                                    redrawAreaTmp = GUtil.union(redrawAreaTmp, redrawAreaTmp2);
                                }
                                catch (Exception redrawAreaTmp2) {
                                    // empty catch block
                                }
                                redrawAreaTmp = GUtil.union(redrawAreaTmp, redrawAreaTmp1);
                            }
                            int i = 0;
                            while (this.structure.getSelecteds() != null && i < this.structure.getSelecteds().size()) {
                                if (this.structure.getSelecteds().get(i) instanceof ClosedCompartmentAlias) {
                                    Rectangle2D redrawAreaTmp1 = (Rectangle2D)((ClosedCompartmentAlias)this.structure.getSelecteds().get(i)).getCompartmentMaxRepaintBounds().clone();
                                    try {
                                        pnt = (Point2D.Double)((ClosedCompartmentAlias)this.structure.getSelecteds().get(i)).getCompartmentNameImage().getFramePosition().clone();
                                        pnt = ((ClosedCompartmentAlias)this.structure.getSelecteds().get(i)).recalCompartmentNameDisplayPostion(new Point2D.Double(pnt.x, pnt.y));
                                        Rectangle2D redrawAreaTmp2 = (Rectangle2D)((ClosedCompartmentAlias)this.structure.getSelecteds().get(i)).getCompartmentMaxRepaintBounds().clone();
                                        ((ClosedCompartmentAlias)this.structure.getSelecteds().get(i)).getCompartmentNameImage().setFramePositionWithoutRecalcPostion(pnt.x, pnt.y);
                                        redrawAreaTmp = GUtil.union(redrawAreaTmp, redrawAreaTmp2);
                                    }
                                    catch (Exception redrawAreaTmp2) {
                                        // empty catch block
                                    }
                                    redrawAreaTmp = GUtil.union(redrawAreaTmp, redrawAreaTmp1);
                                }
                                ++i;
                            }
                        }
                        catch (Exception pnt) {
                            // empty catch block
                        }
                        this.structure.callbyuserRepaint(redrawAreaTmp);
                    }
                } else if (this.isResize()) {
                    Rectangle2D size = null;
                    size = this.resizingGFramed instanceof SpeciesAlias ? ((SpeciesAlias)this.resizingGFramed).getMaxRepaintBounds() : (this.resizingGFramed instanceof CompartmentAlias ? ((CompartmentAlias)((Object)this.resizingGFramed)).getCompartmentMaxRepaintBounds() : this.resizingGFramed.getFrameBounds());
                    Rectangle2D.Double frameSize = this.resizingGFramed.getFrameBounds();
                    double newX = ((RectangularShape)frameSize).getX();
                    double newY = ((RectangularShape)frameSize).getY();
                    double newWidth = ((RectangularShape)frameSize).getWidth();
                    double newHeight = ((RectangularShape)frameSize).getHeight();
                    boolean cancel = false;
                    if (this.resizingGFramed instanceof GElement) {
                        this.structure.changeComplexOrder((GElement)((Object)this.resizingGFramed), frameSize);
                    }
                    if (Math.abs(x - this.mouseDownX) < 2.0 && Math.abs(y - this.mouseDownY) < 2.0 || !editSize.contains(size) || newWidth < 16.0 || newHeight < 16.0 || cancel) {
                        NameImage nameImage;
                        redrawArea = this.structure.resizeElement((GElement)((Object)this.resizingGFramed), this.startX, this.startY, this.startWidth, this.startHeight);
                        if (this.resizingGFramed instanceof CompartmentAlias && (nameImage = ((CompartmentAlias)((Object)this.resizingGFramed)).getCompartmentNameImage()) != null) {
                            redrawArea = GUtil.union(redrawArea, nameImage.restorePosition());
                        }
                    } else {
                        Point2D.Double pos = null;
                        NameImage nmimg = null;
                        if ((this.resizingGFramed instanceof ClosedCompartmentAlias || this.resizingGFramed instanceof OpenedCompartmentAlias) && (nmimg = ((CompartmentAlias)((Object)this.resizingGFramed)).getCompartmentNameImage()) != null) {
                            pos = (Point2D.Double)nmimg.getFramePosition().clone();
                        }
                        this.structure.resizeElement((GElement)((Object)this.resizingGFramed), this.startX, this.startY, this.startWidth, this.startHeight);
                        this.structure.resize((GElement)((Object)this.resizingGFramed), newX, newY, newWidth, newHeight);
                        if (nmimg != null) {
                            nmimg.setFramePosition(pos.x, pos.y);
                            MainWindow.getLastInstance().getCurrentModel().repaintFrameContents();
                        }
                    }
                } else if (this.resizingGPointed != null) {
                    Rectangle2D r = null;
                    r = this.resizingGPointed instanceof CompartmentAlias ? ((CompartmentAlias)((Object)this.resizingGPointed)).getCompartmentMaxRepaintBounds() : ((GElement)((Object)this.resizingGPointed)).getBounds();
                    if (!editSize.contains(r) || Math.abs(x - this.mouseDownX) < 2.0 && Math.abs(y - this.mouseDownY) < 2.0) {
                        redrawArea = this.structure.resizeElement((GElement)((Object)this.resizingGPointed), this.startX, this.startY, 0.0, 0.0);
                    } else {
                        this.structure.resizeElement((GElement)((Object)this.resizingGPointed), this.startX, this.startY, 0.0, 0.0);
                        this.structure.resize((GElement)((Object)this.resizingGPointed), xpos, ypos, 0.0, 0.0);
                    }
                } else if (this.isMovePoint()) {
                    if (this.movingGEditPoint instanceof GLinkHandlePoint) {
                        redrawArea = this.linkHandleMover.processEvent(e.getID(), xpos, ypos);
                    } else {
                        boolean isNotGateHead;
                        int n = this.startXYVec.size();
                        GLogicGate gate = GStructure.isGLogicGateHeaderPoint(this.movingGEditPoint);
                        boolean bl = isNotGateHead = gate == null;
                        if (!this.containsGEditPoint(this.elpos.posList) && isNotGateHead || Math.abs(x - this.mouseDownX) < 2.0 && Math.abs(y - this.mouseDownY) < 2.0) {
                            ArrayList<GElement> list = new ArrayList<GElement>();
                            int i = 0;
                            while (i < n) {
                                ElementAndPosition eap = (ElementAndPosition)this.startXYVec.get(i);
                                Rectangle2D r = this.structure.doMoveMain(eap.getElement(), eap.getX(), eap.getY());
                                redrawArea = i == 0 ? r : GUtil.union(redrawArea, r);
                                if (!list.contains(eap.getElement())) {
                                    list.add(eap.getElement());
                                }
                                ++i;
                            }
                            redrawArea = GUtil.union(this.structure.updateLinksAfterShapesMoving(list, false), redrawArea);
                        } else {
                            ArrayList<GElement> gelements = new ArrayList<GElement>();
                            ArrayList<Point2D> pointList = new ArrayList<Point2D>();
                            List posvec = this.elpos.posList;
                            int i = 0;
                            while (i < n) {
                                ElementAndPosition eap = (ElementAndPosition)this.startXYVec.get(i);
                                Point2D p = (Point2D)posvec.get(i);
                                this.structure.doMoveMain(eap.getElement(), eap.getX(), eap.getY());
                                gelements.add(eap.getElement());
                                pointList.add(p);
                                ++i;
                            }
                            this.structure.move(gelements, pointList);
                        }
                    }
                } else if (this.isSelect()) {
                    redrawArea = GUtil.union(this.structure.getSelectedVectorRepaint(), this.selectRect);
                    redrawArea = GUtil.union(this.structure.highlightChainedLinks(), redrawArea);
                    this.structure.setSelectRect(null);
                    this.structure.setSelectMode(false);
                    this.structure.notifyChangeSelected();
                }
                redrawArea = GUtil.union(this.clear(), redrawArea);
                return redrawArea;
            }
        }

        private boolean containsGEditPoint(List pointList) {
            Rectangle2D editSize = this.interpreter.getEditSize();
            boolean isContains = true;
            int i = 0;
            while (i < pointList.size()) {
                Point2D point = (Point2D)pointList.get(i);
                if (!editSize.contains(point)) {
                    isContains = false;
                    break;
                }
                ++i;
            }
            return isContains;
        }

        private boolean showPopup(double x, double y, MouseEvent e) {
            GElement element;
            boolean enabled;
            SBModelFrame currentSBFrame = MainWindow.getLastInstance().getCurrentModel();
            if (currentSBFrame.getUIType() == 2 && !(enabled = MainWindow.getLastInstance().getMouseStatusForSBGNViewer(e.getID(), 2502))) {
                return false;
            }
            boolean rightClickFlag = System.getProperty("os.name").equals("Linux") ? e.getButton() == 3 && e.getID() == 502 : e.isPopupTrigger();
            if (rightClickFlag && this.pressedGElement != null && (element = this.structure.getElement(x, y)) != null && this.pressedGElement == element && this.pressedGElement.popupAvailable()) {
                this.pressedGElement.showPopup(e, x, y, this.structure);
                GMouseInterpreter.this.popupMenuShowFlag = true;
                this.pressedGElement = null;
                return true;
            }
            return false;
        }

        private void setGridSnapPosition(double x, double y) {
            Vector posvec;
            this.elpos.clear();
            double dx = x;
            double dy = y;
            double xpos = this.startX + dx;
            double ypos = this.startY + dy;
            if (this.isMovePoint()) {
                Point2D.Double p1 = this.movingGEditPoint.getPosition();
                double ddx1 = this.startX + dx - ((Point2D)p1).getX();
                double ddy1 = this.startY + dy - ((Point2D)p1).getY();
                Point2D.Double moveVec = new Point2D.Double(ddx1, ddy1);
                this.movingGEditPoint.restrictMoveVector(moveVec, this.movingGEditPoint2);
                dx = ((Point2D)p1).getX() + ((Point2D)moveVec).getX() - this.startX;
                dy = ((Point2D)p1).getY() + ((Point2D)moveVec).getY() - this.startY;
                xpos = this.startX + dx;
                ypos = this.startY + dy;
                posvec = this.movingGEditPoint.setMovedElementPosition(dx, dy, this.startXYVec);
            } else {
                posvec = GLinkedCreaseLine.setMovedElementPositionDefault(dx, dy, this.startXYVec);
            }
            if (GMouseInterpreter.this.isGridSnapON) {
                if (this.movingGElement != null && this.movingGElement instanceof GFramed) {
                    Point2D.Double framesize = ((GFramed)((Object)this.movingGElement)).getFrameSize();
                    double snappedX = this.interpreter.snapX(xpos + ((Point2D)framesize).getX() / 2.0);
                    double snappedY = this.interpreter.snapY(ypos + ((Point2D)framesize).getY() / 2.0);
                    xpos = snappedX - ((Point2D)framesize).getX() / 2.0;
                    ypos = snappedY - ((Point2D)framesize).getY() / 2.0;
                } else {
                    boolean snapy;
                    boolean snapx = !(Math.abs(dx) <= 0.5);
                    boolean bl = snapy = !(Math.abs(dy) <= 0.5);
                    if (snapx) {
                        xpos = this.interpreter.snapX(xpos);
                    }
                    if (snapy) {
                        ypos = this.interpreter.snapY(ypos);
                    }
                    int n = posvec.size();
                    int i = 0;
                    while (i < n) {
                        boolean snapy1;
                        Point2D p = (Point2D)posvec.get(i);
                        double px = p.getX();
                        double py = p.getY();
                        ElementAndPosition eap = (ElementAndPosition)this.startXYVec.get(i);
                        double dx1 = px - eap.getX();
                        double dy1 = py - eap.getY();
                        boolean snapx1 = !(Math.abs(dx1) <= 0.5);
                        boolean bl2 = snapy1 = !(Math.abs(dy1) <= 0.5);
                        if (snapx1) {
                            px = this.interpreter.snapX(px);
                        }
                        if (snapy1) {
                            py = this.interpreter.snapY(py);
                        }
                        p.setLocation(px, py);
                        ++i;
                    }
                }
            }
            this.elpos.dx = dx;
            this.elpos.dy = dy;
            this.elpos.xpos = xpos;
            this.elpos.ypos = ypos;
            this.elpos.posList = posvec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D doMove(double xpos, double ypos) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                Rectangle2D.Double redrawArea;
                block5: {
                    GLinkedShape glinkedshape;
                    redrawArea = null;
                    if (!(this.movingGElement instanceof GLink) || (glinkedshape = ((GLink)this.movingGElement).getGLinkedShape()).isMovable()) break block5;
                    return null;
                }
                redrawArea = this.structure.moveSelectedElements(this.movingGElement, xpos, ypos);
                if (!this.structure.isMoveMode()) {
                    this.structure.setMoveMode(true);
                    this.structure.setRepaintArea(redrawArea);
                }
                return redrawArea;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D doMove(double xpos, double ypos, double xposForline, double yposForline) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                Rectangle2D.Double redrawArea = null;
                redrawArea = this.structure.moveSelectedElements(this.movingGElement, xpos, ypos);
                if (!this.structure.isMoveMode()) {
                    this.structure.setMoveMode(true);
                    this.structure.setRepaintArea(redrawArea);
                }
                return redrawArea;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D doSelect(double x, double y) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                if (this.selectRect == null) {
                    this.selectRect = new Rectangle2D.Double(this.mouseDownX, this.mouseDownY, 1.0, 1.0);
                }
                Rectangle2D.Double redrawArea = null;
                double bboxX = Math.min(this.mouseDownX, x);
                double bboxY = Math.min(this.mouseDownY, y);
                double bboxXMax = Math.max(this.mouseDownX, x);
                double bboxYMax = Math.max(this.mouseDownY, y);
                bboxX = Math.max(0.0, bboxX);
                bboxY = Math.max(0.0, bboxY);
                bboxXMax = Math.min(bboxXMax, ((GMouseInterpreter)GMouseInterpreter.this).allArea.width);
                bboxYMax = Math.min(bboxYMax, ((GMouseInterpreter)GMouseInterpreter.this).allArea.height);
                this.selectRect.x = bboxX;
                this.selectRect.y = bboxY;
                this.selectRect.width = bboxXMax - bboxX;
                this.selectRect.height = bboxYMax - bboxY;
                Vector selecteds = this.structure.getElements(this.selectRect, this.dragSelectSkips);
                Rectangle2D.Double clip = null;
                Iterator it = this.dragSelecteds.iterator();
                while (it.hasNext()) {
                    GElement element = (GElement)it.next();
                    if (selecteds.contains(element)) continue;
                    clip = GUtil.union(this.structure.deselect(element, false, false, false), clip);
                    it.remove();
                }
                for (GElement element : selecteds) {
                    if (this.dragSelecteds.contains(element)) continue;
                    clip = GUtil.union(this.structure.select(element, false, false, false), clip);
                    this.dragSelecteds.add(element);
                }
                redrawArea = clip;
                this.selectRectPre = clip;
                this.structure.setRepaintArea(redrawArea);
                this.structure.setSelectRect(this.selectRect);
                if (!this.structure.isSelectMode()) {
                    this.structure.setSelectMode(true);
                }
                return redrawArea;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Rectangle2D resizeGFramed(double x, double y, double dx, double dy) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                Rectangle2D redrawArea = null;
                boolean resizeflag = false;
                double newX = 0.0;
                double newY = 0.0;
                double newWidth = 0.0;
                double newHeight = 0.0;
                int location = this.resizingHandle.getLocation();
                switch (location) {
                    case 1: {
                        if (!(x < this.startX + this.startWidth) || !(y < this.startY + this.startHeight)) break;
                        resizeflag = true;
                        newX = this.startX + dx;
                        newY = this.startY + dy;
                        if (GMouseInterpreter.this.isGridSnapON) {
                            newX = this.interpreter.snapX(newX);
                            newY = this.interpreter.snapY(newY);
                        }
                        newWidth = this.startX + this.startWidth - newX;
                        newHeight = this.startY + this.startHeight - newY;
                        break;
                    }
                    case 2: {
                        double snappedX;
                        if (!(x > this.startX) || !(y < this.startY + this.startHeight)) break;
                        resizeflag = true;
                        newX = this.startX;
                        newY = this.startY + dy;
                        if (GMouseInterpreter.this.isGridSnapON) {
                            newY = this.interpreter.snapY(newY);
                        }
                        newWidth = this.startWidth + dx;
                        if (GMouseInterpreter.this.isGridSnapON) {
                            snappedX = this.interpreter.snapX(newX + newWidth);
                            newWidth = snappedX - newX;
                        }
                        newHeight = this.startY + this.startHeight - newY;
                        break;
                    }
                    case 3: {
                        if (!(x < this.startX + this.startWidth) || !(y > this.startY)) break;
                        resizeflag = true;
                        newX = this.startX + dx;
                        if (GMouseInterpreter.this.isGridSnapON) {
                            newX = this.interpreter.snapX(newX);
                        }
                        newY = this.startY;
                        newWidth = this.startX + this.startWidth - newX;
                        newHeight = this.startHeight + dy;
                        if (!GMouseInterpreter.this.isGridSnapON) break;
                        double snappedY = this.interpreter.snapY(newY + newHeight);
                        newHeight = snappedY - newY;
                        break;
                    }
                    case 4: {
                        if (!(x > this.startX) || !(y > this.startY)) break;
                        resizeflag = true;
                        newX = this.startX;
                        newY = this.startY;
                        newWidth = this.startWidth + dx;
                        newHeight = this.startHeight + dy;
                        if (!GMouseInterpreter.this.isGridSnapON) break;
                        double snappedX = this.interpreter.snapX(newX + newWidth);
                        double snappedY = this.interpreter.snapY(newY + newHeight);
                        newWidth = snappedX - newX;
                        newHeight = snappedY - newY;
                    }
                }
                if (!resizeflag) return redrawArea;
                if (!(this.resizingGFramed instanceof ClosedCompartmentAlias)) return this.structure.resizeElement((GElement)((Object)this.resizingGFramed), newX, newY, newWidth, newHeight);
                ClosedCompartmentAlias compartment = (ClosedCompartmentAlias)this.resizingGFramed;
                Dimension dimsion = null;
                try {
                    dimsion = MainWindow.getLastInstance().getCurrentModel().getModelSize();
                }
                catch (Exception myErr) {
                    return null;
                }
                double dMinX = 0.0;
                double dMaxX = dimsion.getWidth();
                double dMinY = 0.0;
                double dMaxY = dimsion.getHeight();
                Rectangle2D.Double rectCmpFrm = compartment.getFrameBounds();
                Rectangle2D.Double rectNmImgBounds = null;
                try {
                    rectNmImgBounds = compartment.getCompartmentNameImage().getBounds();
                }
                catch (Exception myErr) {
                    rectNmImgBounds = null;
                }
                Rectangle2D.Double rectOldCmpFrmBak = null;
                Rectangle2D.Double rectOldNmImgBoundsBak = null;
                if (rectCmpFrm == null) return this.structure.resizeElement((GElement)((Object)this.resizingGFramed), newX, newY, newWidth, newHeight);
                if (rectNmImgBounds == null) return this.structure.resizeElement((GElement)((Object)this.resizingGFramed), newX, newY, newWidth, newHeight);
                rectOldCmpFrmBak = (Rectangle2D.Double)rectCmpFrm.clone();
                rectOldNmImgBoundsBak = (Rectangle2D.Double)rectNmImgBounds.clone();
                if (rectNmImgBounds.x < rectCmpFrm.x) {
                    dMinX += rectCmpFrm.x - rectNmImgBounds.x;
                }
                if (rectNmImgBounds.y < rectCmpFrm.y) {
                    dMinY += rectCmpFrm.y - rectNmImgBounds.y;
                }
                if (rectNmImgBounds.x + rectNmImgBounds.width > rectCmpFrm.x + rectCmpFrm.width) {
                    dMaxX -= rectNmImgBounds.x + rectNmImgBounds.width - (rectCmpFrm.x + rectCmpFrm.width);
                }
                if (rectNmImgBounds.y + rectNmImgBounds.height > rectCmpFrm.y + rectCmpFrm.height) {
                    dMaxY -= rectNmImgBounds.y + rectNmImgBounds.height - (rectCmpFrm.y + rectCmpFrm.height);
                }
                boolean bWillBeRtn = false;
                if (newX < dMinX) {
                    bWillBeRtn = true;
                }
                if (newY < dMinY) {
                    bWillBeRtn = true;
                }
                if (newX > dMaxX) {
                    bWillBeRtn = true;
                }
                if (newY > dMaxY) {
                    bWillBeRtn = true;
                }
                if (newX + newWidth > dMaxX) {
                    bWillBeRtn = true;
                }
                if (newY + newHeight > dMaxY) {
                    bWillBeRtn = true;
                }
                if (!bWillBeRtn) return this.structure.resizeElement((GElement)((Object)this.resizingGFramed), newX, newY, newWidth, newHeight);
                Rectangle2D redrawAreaTmp1 = this.structure.resizeElement((GElement)((Object)this.resizingGFramed), newX, newY, newWidth, newHeight);
                Rectangle2D.Double rectCmpFrmTmp = compartment.getCompartmentMaxRepaintBounds();
                redrawArea = GUtil.union(redrawArea, redrawAreaTmp1);
                redrawArea = GUtil.union(redrawArea, rectCmpFrmTmp);
                if (!(rectCmpFrmTmp.x < 0.0 || rectCmpFrmTmp.y < 0.0 || rectCmpFrmTmp.x + rectCmpFrmTmp.width > dimsion.getWidth())) {
                    if (!(rectCmpFrmTmp.y + rectCmpFrmTmp.height > (double)dimsion.height)) return redrawArea;
                }
                try {
                    Rectangle2D redrawAreaTmp2 = this.structure.resizeElement((GElement)((Object)this.resizingGFramed), rectOldCmpFrmBak.x, rectOldCmpFrmBak.y, rectOldCmpFrmBak.width, rectOldCmpFrmBak.height);
                    Rectangle2D redrawAreaTmp3 = (Rectangle2D)compartment.getCompartmentMaxRepaintBounds().clone();
                    compartment.getCompartmentNameImage().setFramePosition(rectOldNmImgBoundsBak.x, rectOldNmImgBoundsBak.y);
                    Rectangle2D redrawAreaTmp4 = (Rectangle2D)compartment.getCompartmentMaxRepaintBounds().clone();
                    redrawArea = GUtil.union(redrawArea, redrawAreaTmp2);
                    redrawArea = GUtil.union(redrawArea, redrawAreaTmp3);
                    return GUtil.union(redrawArea, redrawAreaTmp4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return redrawArea;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D resizeGPointed(double x, double y) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                Rectangle2D redrawArea = null;
                if (this.resizingGPointed != null) {
                    redrawArea = this.structure.resizeElement((GElement)((Object)this.resizingGPointed), x, y, 0.0, 0.0);
                }
                return redrawArea;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Rectangle2D movePoint(double x, double y, MouseEvent e) {
            ElementSelector elementSelector = this;
            synchronized (elementSelector) {
                Rectangle2D redrawArea = null;
                if (this.movingGEditPoint instanceof GLinkHandlePoint) {
                    return this.linkHandleMover.processEvent(e.getID(), x, y);
                }
                Vector<GLink> vec = new Vector<GLink>();
                vec.add(this.structure.getOwnerLink(this.movingGEditPoint));
                int n = this.startXYVec.size();
                redrawArea = null;
                int i = 0;
                while (i < n) {
                    ElementAndPosition eap = (ElementAndPosition)this.startXYVec.get(i);
                    Point2D p = (Point2D)this.elpos.posList.get(i);
                    Rectangle2D redrawArea2 = this.structure.doMoveMain(eap.getElement(), p.getX(), p.getY());
                    redrawArea = i != 0 ? GUtil.union(redrawArea, redrawArea2) : redrawArea2;
                    ++i;
                }
                Rectangle2D r = this.structure.updateLinksAfterShapesMoving(vec, false);
                redrawArea = GUtil.union(redrawArea, r);
                if (!this.structure.isMoveMode()) {
                    this.structure.setMoveMode(true);
                    this.structure.setLinkMoveMode(true);
                    this.structure.setRepaintArea(redrawArea);
                    return redrawArea;
                }
                return null;
            }
        }

        private void interrupt() {
            int x = (int)this.mouseDownX + 1;
            int y = (int)this.mouseDownY + 1;
            MouseEvent e = new MouseEvent(new JPanel(), 502, new Date().getTime(), 1, x, y, 1, false);
            this.interpret(x, y, e);
        }

        class ElementPosition {
            double dx;
            double dy;
            double xpos;
            double ypos;
            List posList = new ArrayList();

            public ElementPosition() {
                this.clear();
            }

            public void clear() {
                this.dx = 0.0;
                this.dy = 0.0;
                this.xpos = 0.0;
                this.ypos = 0.0;
                this.posList.clear();
            }
        }
    }

    private class GCreaterDriver {
        private GCreater drivingCreater;
        private GMouseInterpreter interpreter;
        private Vector skips = new Vector();
        private GElement selectedAsTarget = null;
        private GLinkPositionInfo selectedLpi = null;
        private GLinkTarget onMouseTarget = null;
        private GLinkPositionInfo onMouseTargetLinkPosition = null;

        public GCreaterDriver(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double x, double y, int eventId) {
            boolean active = false;
            GLinkPositionInfo lpiOld = null;
            GElement gcurrent = GMouseInterpreter.this.structure.getElement(x, y);
            if (gcurrent != null) {
                try {
                    boolean canTouch;
                    lpiOld = ((GLinkTarget)((Object)gcurrent)).getPointedLinkPosition(x, y);
                    if (this.drivingCreater == null) {
                        GMouseInterpreter.this.structure.deselectAll();
                        this.reset();
                        this.drivingCreater = (GCreater)GMouseInterpreter.this.factory.createObject(GMouseInterpreter.this.currentType);
                        if (this.drivingCreater == null) {
                            return;
                        }
                    }
                    if (canTouch = this.drivingCreater.isSelectable(gcurrent)) {
                        lpiOld.setElement(gcurrent);
                        active = canTouch;
                    } else {
                        gcurrent = null;
                        lpiOld = null;
                    }
                }
                catch (Exception myErr) {
                    gcurrent = null;
                    lpiOld = null;
                }
            }
            if (active) {
                if (this.onMouseTarget != gcurrent) {
                    if (this.onMouseTarget != null) {
                        GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                    }
                    this.onMouseTarget = (GLinkTarget)((Object)gcurrent);
                    this.onMouseTargetLinkPosition = lpiOld;
                } else if (!this.onMouseTargetLinkPosition.equals(lpiOld)) {
                    this.onMouseTargetLinkPosition = lpiOld;
                }
                GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpiOld, false);
                if (eventId == 501) {
                    GMouseInterpreter.this.structure.highlightAsTarget(gcurrent);
                    this.selectedAsTarget = gcurrent;
                    this.selectedLpi = lpiOld;
                } else if (eventId == 502) {
                    boolean iscancreate = false;
                    if (this.drivingCreater instanceof CreateLayerTagWithLine) {
                        if (this.selectedAsTarget == gcurrent && this.selectedLpi.getPosition() == lpiOld.getPosition()) {
                            iscancreate = true;
                        }
                    } else if (this.selectedAsTarget == gcurrent) {
                        iscancreate = true;
                    }
                    if (iscancreate) {
                        try {
                            if (this.drivingCreater instanceof CreateLayerTagWithLine) {
                                ((CreateLayerTagWithLine)this.drivingCreater).setPosinfTargetTmp(this.selectedLpi);
                            } else if (this.drivingCreater instanceof HomodimerFormation) {
                                ((HomodimerFormation)this.drivingCreater).setPosinfTargetTmp(this.selectedLpi);
                            } else if (this.drivingCreater instanceof Degradation) {
                                ((Degradation)this.drivingCreater).setPosinfTargetTmp(this.selectedLpi);
                            }
                            GCreaterResult gcreaterresult = this.drivingCreater.doCreate(this.selectedAsTarget);
                            if (gcreaterresult != null && !gcreaterresult.isEndedWithError()) {
                                GFramed framed = (GFramed)gcreaterresult.getAddingGElements().get(0);
                                Rectangle2D.Double r = framed.getFrameBounds();
                                Point2D pos = this.adjustmentPosition(((RectangularShape)r).getX(), ((RectangularShape)r).getY(), ((RectangularShape)r).getWidth(), ((RectangularShape)r).getHeight());
                                framed.setFramePosition(pos.getX(), pos.getY());
                                GMouseInterpreter.this.structure.addAndRemove(gcreaterresult.getAddingGElements(), gcreaterresult.getRemovingGElements());
                                GMouseInterpreter.this.structure.reconfirmSameIDAutoTagNeedToPaint();
                                MainWindow.getLastInstance().getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(MainWindow.getLastInstance().getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                                MainWindow.getLastInstance().resetComboBox();
                            }
                            this.reset();
                        }
                        catch (Exception myErr) {
                            this.interrupt();
                            return;
                        }
                    } else {
                        this.reset();
                    }
                }
            } else {
                this.reset();
            }
        }

        public void interrupt() {
            this.reset();
        }

        private void reset() {
            try {
                if (GMouseInterpreter.this.structure != null) {
                    GCreaterResult gcreaterresult;
                    if (this.drivingCreater != null && (gcreaterresult = this.drivingCreater.interrupt()) != null) {
                        GMouseInterpreter.this.structure.addAndRemove(gcreaterresult.getAddingGElements(), gcreaterresult.getRemovingGElements());
                    }
                    if (this.onMouseTarget != null) {
                        GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                    }
                    this.drivingCreater = null;
                    this.skips.clear();
                    this.onMouseTarget = null;
                    this.onMouseTargetLinkPosition = null;
                    this.selectedAsTarget = null;
                    GMouseInterpreter.this.structure.releaseHighlight();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Point2D adjustmentPosition(double x, double y, double width, double height) {
            Rectangle2D editSize = this.interpreter.getEditSize();
            if (!editSize.contains(x, y, width, height)) {
                if (x < editSize.getX()) {
                    x = editSize.getX();
                } else if (x + width > editSize.getMaxX()) {
                    x = editSize.getMaxX() - width;
                }
                if (y < editSize.getY()) {
                    y = editSize.getY();
                } else if (y + height > editSize.getMaxY()) {
                    y = editSize.getMaxY() - height;
                }
            }
            return new Point2D.Double(x, y);
        }
    }

    private class GFramedCreater {
        private GFramed creatingGFramed;
        private double mouseDownX = 0.0;
        private double mouseDownY = 0.0;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GFramedCreater(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            if (eventId == 501) {
                if (!editSize.contains(this.x, this.y)) {
                    return;
                }
                GMouseInterpreter.this.structure.deselectAll();
                this.creatingGFramed = (GFramed)GMouseInterpreter.this.factory.createObject(GMouseInterpreter.this.currentType);
                if (this.creatingGFramed != null) {
                    if (this.creatingGFramed instanceof GDefaultSizeGiven) {
                        Point2D.Double framedSize = ((GDefaultSizeGiven)((Object)this.creatingGFramed)).getDefaultSize();
                        double width = ((Point2D)framedSize).getX();
                        double height = ((Point2D)framedSize).getY();
                        double bboxX = this.x - width / 2.0;
                        double bboxY = this.y - height / 2.0;
                        Point2D pos = this.adjustmentPosition(bboxX, bboxY, width, height);
                        ((GElement)((Object)this.creatingGFramed)).setHighlighted(true);
                        this.creatingGFramed.setFramePosition(pos.getX(), pos.getY());
                        this.creatingGFramed.setFrameSize(width, height);
                        GMouseInterpreter.this.structure.setTemporalGElement((GElement)((Object)this.creatingGFramed));
                        Rectangle2D redrawArea = GMouseInterpreter.this.structure.resizeElement((GElement)((Object)this.creatingGFramed), pos.getX(), pos.getY(), width, height);
                        GMouseInterpreter.this.structure.notifyRepaint(redrawArea);
                    } else {
                        ((GElement)((Object)this.creatingGFramed)).setHighlighted(true);
                        this.creatingGFramed.setFramePosition(this.x, this.y);
                        GMouseInterpreter.this.structure.setTemporalGElement((GElement)((Object)this.creatingGFramed));
                    }
                }
                this.mouseDownX = this.x;
                this.mouseDownY = this.y;
            } else if (eventId == 506 && this.creatingGFramed != null) {
                if (this.creatingGFramed instanceof GDefaultSizeGiven) {
                    Point2D.Double framedSize = ((GDefaultSizeGiven)((Object)this.creatingGFramed)).getDefaultSize();
                    double width = ((Point2D)framedSize).getX();
                    double height = ((Point2D)framedSize).getY();
                    double bboxX = this.x - width / 2.0;
                    double bboxY = this.y - height / 2.0;
                    Point2D pos = this.adjustmentPosition(bboxX, bboxY, width, height);
                    Rectangle2D redrawArea = GMouseInterpreter.this.structure.resizeElement((GElement)((Object)this.creatingGFramed), pos.getX(), pos.getY(), width, height);
                    GMouseInterpreter.this.structure.notifyRepaint(redrawArea);
                } else {
                    double bboxX = Math.min(this.mouseDownX, this.x);
                    double bboxY = Math.min(this.mouseDownY, this.y);
                    double bboxXMax = Math.max(this.mouseDownX, this.x);
                    double bboxYMax = Math.max(this.mouseDownY, this.y);
                    bboxX = Math.max(0.0, bboxX);
                    bboxY = Math.max(0.0, bboxY);
                    bboxXMax = Math.min(bboxXMax, ((GMouseInterpreter)GMouseInterpreter.this).allArea.width);
                    bboxYMax = Math.min(bboxYMax, ((GMouseInterpreter)GMouseInterpreter.this).allArea.height);
                    Rectangle2D redrawArea = GMouseInterpreter.this.structure.resizeElement((GElement)((Object)this.creatingGFramed), bboxX, bboxY, bboxXMax - bboxX, bboxYMax - bboxY);
                    GMouseInterpreter.this.structure.notifyRepaint(redrawArea);
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                ((GElement)((Object)this.creatingGFramed)).setHighlighted(false);
                if (this.creatingGFramed instanceof GDefaultSizeGiven) {
                    GMouseInterpreter.this.structure.notifyChange((GElement)((Object)this.creatingGFramed), 0, null);
                } else if (!(Math.abs(this.x - this.mouseDownX) < 5.0) && !(Math.abs(this.y - this.mouseDownY) < 5.0)) {
                    GMouseInterpreter.this.structure.notifyChange((GElement)((Object)this.creatingGFramed), 0, null);
                }
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }

        private Point2D adjustmentPosition(double x, double y, double width, double height) {
            Rectangle2D editSize = this.interpreter.getEditSize();
            if (!editSize.contains(x, y, width, height)) {
                if (x < editSize.getX()) {
                    x = editSize.getX();
                } else if (x + width > editSize.getMaxX()) {
                    x = editSize.getMaxX() - width;
                }
                if (y < editSize.getY()) {
                    y = editSize.getY();
                } else if (y + height > editSize.getMaxY()) {
                    y = editSize.getMaxY() - height;
                }
            }
            return new Point2D.Double(x, y);
        }
    }

    private class GLinkCreater {
        private GLink creatingGLink;
        private int linkTargetSize = 0;
        private int linkedCnt = 0;
        private Vector skips = new Vector();
        private GLinkTarget onMouseTarget = null;
        private GLinkTarget selectedAsTarget = null;
        private GLinkPositionInfo onMouseTargetLinkPosition = null;
        private Vector connectingTargets = new Vector();
        private Vector connectingTargetsInfo = new Vector();
        private boolean pressed = false;
        private double mouseDownX;
        private double mouseDownY;

        private GLinkCreater() {
        }

        private void reset() {
            if (this.creatingGLink != null) {
                this.linkTargetSize = this.creatingGLink.targetSize();
            }
            this.linkedCnt = 0;
            this.skips.clear();
            if (this.onMouseTarget != null) {
                GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
            }
            if (this.connectingTargets != null) {
                int i = 0;
                while (i < this.connectingTargets.size()) {
                    GLinkTarget t = (GLinkTarget)this.connectingTargets.elementAt(i);
                    GMouseInterpreter.this.structure.hideLinkAnchors(t);
                    ++i;
                }
                this.connectingTargets.clear();
            }
            this.connectingTargetsInfo.clear();
            this.onMouseTarget = null;
            this.onMouseTargetLinkPosition = null;
            this.selectedAsTarget = null;
            this.pressed = false;
            if (GMouseInterpreter.this.structure != null) {
                GMouseInterpreter.this.structure.releaseHighlight();
            }
        }

        private void interpret(double x, double y, int id) {
            GElement gelement;
            if (this.creatingGLink == null) {
                GMouseInterpreter.this.structure.deselectAll();
                this.creatingGLink = (GLink)GMouseInterpreter.this.factory.createObject(GMouseInterpreter.this.currentType);
                if (this.creatingGLink != null) {
                    this.reset();
                } else {
                    return;
                }
            }
            GMouseInterpreter.setOnMouseTargetAddingObjectFlag(this.creatingGLink, this.onMouseTarget);
            GLinkPositionInfo lpi = GMouseInterpreter.this.structure.getPointedLinkableElement(x, y, this.skips, this.creatingGLink, this.linkedCnt);
            GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.onMouseTarget);
            boolean active = false;
            if (lpi != null) {
                active = lpi.hasActive();
            }
            GElement gElement = gelement = lpi != null ? lpi.getElement() : null;
            if (active) {
                active = this.canTouched(this.creatingGLink.getGLinkedShape(), gelement, this.connectingTargets);
            }
            if (active) {
                active = GMouseInterpreter.isLinkAbleByReactantProductModifications(this.creatingGLink.getGLinkedShape(), gelement, lpi);
            }
            if (active) {
                if (this.onMouseTarget != gelement) {
                    if (this.onMouseTarget != null && !this.connectingTargets.contains(this.onMouseTarget)) {
                        GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                    }
                    this.onMouseTarget = (GLinkTarget)((Object)gelement);
                    this.onMouseTargetLinkPosition = lpi;
                    if (!this.connectingTargets.contains(this.onMouseTarget)) {
                        GMouseInterpreter.setOnMouseTargetAddingObjectFlag(this.creatingGLink, this.onMouseTarget);
                        GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpi, false);
                        GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.onMouseTarget);
                    }
                } else if (!this.onMouseTargetLinkPosition.equals(lpi)) {
                    this.onMouseTargetLinkPosition = lpi;
                    if (!this.connectingTargets.contains(this.onMouseTarget)) {
                        GMouseInterpreter.setOnMouseTargetAddingObjectFlag(this.creatingGLink, this.onMouseTarget);
                        GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpi, false);
                        GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.onMouseTarget);
                    }
                }
                if (id == 501) {
                    this.pressed = true;
                    if (gelement instanceof GLinkTarget) {
                        GMouseInterpreter.setOnMouseTargetAddingObjectFlag(this.creatingGLink, (GLinkTarget)((Object)gelement));
                    }
                    GMouseInterpreter.this.structure.highlightAsTarget(gelement);
                    if (gelement instanceof GLinkTarget) {
                        GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag((GLinkTarget)((Object)gelement));
                    }
                    this.selectedAsTarget = (GLinkTarget)((Object)gelement);
                } else if (id == 502) {
                    this.pressed = false;
                    if (this.selectedAsTarget == gelement) {
                        this.connectingTargetsInfo.add(new TargetInfo(this.selectedAsTarget, x, y, lpi));
                        ++this.linkedCnt;
                        this.skips.add(this.selectedAsTarget);
                        this.connectingTargets.add(this.selectedAsTarget);
                        GMouseInterpreter.setOnMouseTargetAddingObjectFlag(this.creatingGLink, this.onMouseTarget);
                        GMouseInterpreter.this.structure.showLinkAnchors(this.selectedAsTarget, lpi, true);
                        GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.onMouseTarget);
                        if (this.multiCreate(this.creatingGLink, this.connectingTargetsInfo, gelement)) {
                            return;
                        }
                        this.selectedAsTarget = null;
                        if (this.linkedCnt == this.linkTargetSize) {
                            int policy = GLinkedLine.getDefaultConnectPolicy();
                            GLinkedShape shape = this.creatingGLink.getGLinkedShape();
                            if (shape instanceof GLinkConnectSchemeOwner) {
                                ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                            }
                            int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                            if (shape instanceof GLinkedCreaseLine) {
                                ((GLinkedCreaseLine)shape).resetCreaseLineNumber(n);
                            } else if (shape instanceof GLinkedLineComplex3) {
                                ((GLinkedLineComplex3)shape).resetCreaseLineNumber(n, n, n);
                            }
                            try {
                                int i = 0;
                                while (i < this.connectingTargets.size()) {
                                    TargetInfo ti = (TargetInfo)this.connectingTargetsInfo.get(i);
                                    GLinkTarget target = ti.getTarget();
                                    this.creatingGLink.setTargetAt(target, i, ti.getLpi());
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                return;
                            }
                            GLinkedShape shape2 = this.creatingGLink.getGLinkedShape();
                            if (shape2 instanceof GLinkedCurveAndLine) {
                                GLinkedCurveAndLine cl = (GLinkedCurveAndLine)shape2;
                                if (cl.getLineType() == 1) {
                                    n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                                    cl.resetCreaseLineNumber(n);
                                }
                                cl.updateShape();
                            }
                            GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget, false);
                            GMouseInterpreter.this.structure.notifyChange(this.creatingGLink, 0, null);
                            this.creatingGLink = null;
                            this.reset();
                            this.onMouseTarget = (GLinkTarget)((Object)gelement);
                        }
                    } else if (this.selectedAsTarget != null) {
                        GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
                        this.selectedAsTarget = null;
                    }
                }
            } else {
                if (this.onMouseTarget != null) {
                    if (!this.connectingTargets.contains(this.onMouseTarget)) {
                        GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                    }
                    this.onMouseTarget = null;
                }
                if (this.creatingGLink instanceof LayerReactionLink) {
                    GLinkedCreaseLine shape = (GLinkedCreaseLine)this.creatingGLink.getGLinkedShape();
                    shape.setLineWidth(5.0);
                    if (id == 501) {
                        this.creatingGLink.setHighlighted(true);
                        shape.lines[0].start = new Point2D.Double(x, y);
                        shape.lines[0].end = new Point2D.Double(x, y);
                        GMouseInterpreter.this.structure.setTemporalGElement(this.creatingGLink);
                        this.mouseDownX = x;
                        this.mouseDownY = y;
                    } else if (id == 506) {
                        double bboxX = Math.min(this.mouseDownX, x);
                        double bboxY = Math.min(this.mouseDownY, y);
                        double bboxXMax = Math.max(this.mouseDownX, x);
                        double bboxYMax = Math.max(this.mouseDownY, y);
                        bboxX = Math.max(0.0, bboxX);
                        bboxY = Math.max(0.0, bboxY);
                        bboxXMax = Math.min(bboxXMax, ((GMouseInterpreter)GMouseInterpreter.this).allArea.width);
                        bboxYMax = Math.min(bboxYMax, ((GMouseInterpreter)GMouseInterpreter.this).allArea.height);
                        Rectangle2D redrawArea = GMouseInterpreter.this.structure.resizeElement(this.creatingGLink, bboxX, bboxY, bboxXMax - bboxX, bboxYMax - bboxY);
                        shape.lines[0].end = new Point2D.Double(x, y);
                        GMouseInterpreter.this.structure.notifyRepaint(redrawArea);
                    } else if (id == 502) {
                        shape.lines[0].end = new Point2D.Double(x, y);
                        shape.sHandlePoint.setPosition(shape.lines[0].start);
                        shape.eHandlePoint.setPosition(shape.lines[0].end);
                        shape.sHandlePoint.update();
                        shape.eHandlePoint.update();
                        shape.sHandlePoint.setOwner(shape);
                        shape.eHandlePoint.setOwner(shape);
                        this.creatingGLink.setHighlighted(false);
                        GMouseInterpreter.this.structure.notifyChange(this.creatingGLink, 0, null);
                    }
                } else if (id == 501) {
                    this.pressed = true;
                } else if (id == 502) {
                    this.pressed = false;
                    if (this.selectedAsTarget != null) {
                        GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
                        this.selectedAsTarget = null;
                    }
                }
            }
        }

        public void interrupt() {
            if (this.creatingGLink != null) {
                this.creatingGLink = null;
            }
            this.reset();
        }

        private boolean isReaction(GLinkedShape linkshape) {
            return linkshape instanceof StateTransition || linkshape instanceof KnownTransitionOmitted || linkshape instanceof UnknownTransition || linkshape instanceof Transport || linkshape instanceof DimerFormation || linkshape instanceof Dissociation || linkshape instanceof Truncation || linkshape instanceof LinkedCreaseLineMixedNotation || linkshape instanceof GLogicGate;
        }

        private Vector getAllModifiers(GLink baseLink) {
            Vector<GLinkTarget> modificationObjects = new Vector<GLinkTarget>();
            Vector links = GMouseInterpreter.this.structure.getLinks();
            int size = links.size();
            int i = 0;
            while (i < size) {
                GLink link = (GLink)links.elementAt(i);
                if (GLogicGate.isModification(link.getGLinkedShape())) {
                    if (((LinkedCreaseLine)link.getGLinkedShape()).getEndTarget() == baseLink) {
                        modificationObjects.add(((LinkedCreaseLine)link.getGLinkedShape()).getStartTarget());
                    }
                } else if (link.getGLinkedShape() instanceof GLogicGate) {
                    if (((GLogicGate)link.getGLinkedShape()).getRealLine().getEndTarget() == baseLink) {
                        modificationObjects.addAll(((GLogicGate)link.getGLinkedShape()).getTargetElement());
                    }
                } else if (link.getGLinkedShape() instanceof AddProduct) {
                    if (((AddProduct)link.getGLinkedShape()).getStartTarget() == baseLink) {
                        modificationObjects.add(((AddProduct)link.getGLinkedShape()).getEndTarget());
                    }
                } else if (link.getGLinkedShape() instanceof AddReactant && ((AddReactant)link.getGLinkedShape()).getEndTarget() == baseLink) {
                    modificationObjects.add(((AddReactant)link.getGLinkedShape()).getStartTarget());
                }
                ++i;
            }
            return modificationObjects;
        }

        private Vector getAllReactants(SpeciesAlias species) {
            Vector<GLinkTarget> modificationObjects = new Vector<GLinkTarget>();
            Vector links = GMouseInterpreter.this.structure.getLinks();
            int size = links.size();
            int i = 0;
            while (i < size) {
                GLink link = (GLink)links.elementAt(i);
                if (GLogicGate.isModification(link.getGLinkedShape())) {
                    if (((LinkedCreaseLine)link.getGLinkedShape()).getEndTarget() == species) {
                        modificationObjects.add(((LinkedCreaseLine)link.getGLinkedShape()).getStartTarget());
                    }
                } else if (link.getGLinkedShape() instanceof GLogicGate && ((GLogicGate)link.getGLinkedShape()).getRealLine().getEndTarget() == species) {
                    modificationObjects.addAll(((GLogicGate)link.getGLinkedShape()).getTargetElement());
                }
                ++i;
            }
            return modificationObjects;
        }

        private boolean canTouched(GLinkedShape createdLink, GElement ge, Vector connectingObjects) {
            SpeciesAlias alias;
            if (createdLink != null && ge instanceof SpeciesAlias && GMouseInterpreter.aliasCanNotBeUsedByReaction(createdLink, alias = (SpeciesAlias)ge)) {
                return false;
            }
            if (GMouseInterpreter.isModification(createdLink)) {
                if (ge instanceof GLink) {
                    int i;
                    GLinkedShape shape = ((GLink)ge).getGLinkedShape();
                    Vector<GLinkTarget> exitObjects = new Vector<GLinkTarget>();
                    if (GLogicGate.isModification(shape)) {
                        if (this.isAutocatalysisORisFeedbackModificationType((GLink)ge, "")) {
                            return false;
                        }
                        exitObjects.add(((LinkedCreaseLine)shape).getStartTarget());
                        if (((LinkedCreaseLine)shape).isSingleLine()) {
                            boolean isMixedNotationLink = false;
                            boolean isMixedNotationBaseLink = false;
                            isMixedNotationLink = shape instanceof LinkedCreaseLineMixedNotation;
                            if (isMixedNotationLink) {
                                isMixedNotationBaseLink = ((ReactionLink)ge).isBaseLink();
                            }
                            if (isMixedNotationBaseLink || ((LinkedCreaseLine)shape).getEndTarget() instanceof ReactionLink) {
                                ReactionLink reaction = null;
                                reaction = isMixedNotationBaseLink ? (ReactionLink)ge : (ReactionLink)((LinkedCreaseLine)shape).getEndTarget();
                                if (isMixedNotationBaseLink || reaction.isBaseLink()) {
                                    exitObjects.addAll(reaction.getSources());
                                    exitObjects.addAll(reaction.getDistinations());
                                    Vector modificationObjects = this.getAllModifiers(reaction);
                                    i = 0;
                                    while (i < connectingObjects.size()) {
                                        if (modificationObjects.contains(connectingObjects.elementAt(i))) {
                                            return false;
                                        }
                                        ++i;
                                    }
                                }
                            }
                        }
                    } else if (shape instanceof GLogicGate) {
                        ReactionLink reaction;
                        exitObjects.addAll(((GLogicGate)shape).getTargetElement());
                        if (((GLogicGate)shape).getRealLine().getEndTarget() instanceof ReactionLink && (reaction = (ReactionLink)((GLogicGate)shape).getRealLine().getEndTarget()).isBaseLink()) {
                            exitObjects.addAll(reaction.getSources());
                            exitObjects.addAll(reaction.getDistinations());
                            Vector modificationObjects = this.getAllModifiers(reaction);
                            int i2 = 0;
                            while (i2 < connectingObjects.size()) {
                                if (modificationObjects.contains(connectingObjects.elementAt(i2))) {
                                    return false;
                                }
                                ++i2;
                            }
                        }
                    } else {
                        GLink baseLink = (GLink)ge;
                        Vector modificationObjects = this.getAllModifiers(baseLink);
                        if (!GLogicGate.isModification(createdLink)) {
                            exitObjects.addAll(baseLink.getSources());
                            exitObjects.addAll(baseLink.getDistinations());
                        }
                        int cnt = connectingObjects.size();
                        boolean isModification = GLogicGate.isModification(createdLink);
                        if (isModification && modificationObjects != null && modificationObjects.contains(connectingObjects.elementAt(0))) {
                            Vector targetObjects = new Vector();
                            targetObjects.addAll(baseLink.getSources());
                            targetObjects.addAll(baseLink.getDistinations());
                            if (!targetObjects.contains(connectingObjects.elementAt(0))) {
                                return false;
                            }
                        }
                        i = 0;
                        while (!isModification && i < cnt) {
                            if (modificationObjects.contains(connectingObjects.elementAt(i))) {
                                return false;
                            }
                            ++i;
                        }
                    }
                    int exitCount = exitObjects.size();
                    int i3 = 0;
                    while (i3 < exitCount) {
                        if (connectingObjects.contains(exitObjects.elementAt(i3))) {
                            return false;
                        }
                        ++i3;
                    }
                } else if (ge instanceof SpeciesAlias && ((SpeciesAlias)ge).isPhenotype()) {
                    Vector modificationObjects = this.getAllReactants((SpeciesAlias)ge);
                    int i = 0;
                    while (i < connectingObjects.size()) {
                        if (modificationObjects.contains(connectingObjects.elementAt(i))) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            if (createdLink instanceof GLinkedCurveAndLine) {
                return true;
            }
            if (this.isReaction(createdLink) && ge instanceof SpeciesAlias) {
                return true;
            }
            int size = connectingObjects.size();
            if (createdLink instanceof GLogicGate) {
                GLinkedShape shape = ((GLink)ge).getGLinkedShape();
                if (!(shape instanceof GLogicGate) && size < 2) {
                    return false;
                }
                if (ge instanceof GLink && size > 0) {
                    return true;
                }
            }
            return GMouseInterpreter.isModification(createdLink) && (createdLink.targetSize() == size + 1 ? (ge instanceof SpeciesAlias ? ((SpeciesAlias)ge).isPhenotype() : ge instanceof GLink && this.canTouchMixedNotationLink((ReactionLink)ge, createdLink)) : ge instanceof SpeciesAlias);
        }

        private boolean canTouchMixedNotationLink(ReactionLink ge, GLinkedShape createdLink) {
            GLogicGate gt;
            boolean bIsGate1 = ge.getGLinkedShape() instanceof GLogicGate;
            boolean bIsGate2 = createdLink instanceof GLogicGate;
            boolean bIsMixedNotation1 = ge.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation;
            boolean bIsMixedNotation2 = createdLink instanceof LinkedCreaseLineMixedNotation;
            return bIsGate2 ? bIsMixedNotation1 && ge.isBaseLink() : (bIsGate1 ? (gt = (GLogicGate)ge.getGLinkedShape()).getRealLine() instanceof LinkedCreaseLineMixedNotation == bIsMixedNotation2 : (bIsMixedNotation1 ? ge.isBaseLink() : bIsMixedNotation1 == bIsMixedNotation2));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isAutocatalysisORisFeedbackModificationType(GLink gl, String action) {
            try {
                if (gl == null) {
                    return false;
                }
                GLinkedShape shape = gl.getGLinkedShape();
                if (!(shape instanceof LinkedCreaseLineModification)) {
                    return false;
                }
                LinkedCreaseLineModification modificationLine = (LinkedCreaseLineModification)shape;
                if (modificationLine.isMemberofBooleanLogicGate()) {
                    return false;
                }
                GLinkTarget modificationstartobj = modificationLine.getStartTarget();
                ReactionLink basereaction = (ReactionLink)modificationLine.getEndTarget();
                Vector targetObjects = new Vector();
                targetObjects.addAll(basereaction.getSources());
                targetObjects.addAll(basereaction.getDistinations());
                int i = 0;
                while (true) {
                    if (i >= targetObjects.size()) {
                        return false;
                    }
                    if (targetObjects.contains(modificationstartobj)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Exception myErr) {
                return false;
            }
        }

        private boolean multiCreate(GLink glink, Vector vTargetInfo, GElement gl) {
            if (!GMouseInterpreter.isModification(glink.getGLinkedShape())) {
                return false;
            }
            int size = vTargetInfo.size();
            if (size < 2) {
                return true;
            }
            int i = 0;
            while (i < size) {
                TargetInfo target = (TargetInfo)vTargetInfo.get(i);
                if (target.getTarget() instanceof ElementSpeciesAlias && !GMouseInterpreter.this.structure.getAtoms().contains(target.getTarget())) {
                    this.creatingGLink = null;
                    this.reset();
                    this.onMouseTarget = (GLinkTarget)((Object)gl);
                    MainWindow.getLastInstance().resetComboBox();
                    return true;
                }
                ++i;
            }
            boolean bIsAllSpecies = true;
            int i2 = 0;
            while (i2 < size) {
                TargetInfo target = (TargetInfo)vTargetInfo.get(i2);
                if (!(target.getTarget() instanceof ElementSpeciesAlias) && !(target.getTarget() instanceof ComplexSpeciesAlias)) {
                    bIsAllSpecies = false;
                    break;
                }
                ++i2;
            }
            boolean bCanCreateMixedNotationBaseLink = false;
            boolean bCanCreateSpeciesDestinationGate = false;
            if (bIsAllSpecies) {
                if (size == 2) {
                    bCanCreateMixedNotationBaseLink = true;
                }
                if (size == Preference.iGLogicGateSrcNums + 1) {
                    bCanCreateSpeciesDestinationGate = true;
                }
            }
            TargetInfo eti = (TargetInfo)vTargetInfo.get(vTargetInfo.size() - 1);
            GLinkTarget lastTarget = eti.getTarget();
            boolean isPhenotype = false;
            if (bCanCreateSpeciesDestinationGate) {
                if (((SpeciesAlias)lastTarget).isPhenotype()) {
                    isPhenotype = true;
                    bCanCreateSpeciesDestinationGate = false;
                } else {
                    isPhenotype = false;
                }
            } else if (!bCanCreateMixedNotationBaseLink && lastTarget instanceof SpeciesAlias) {
                return true;
            }
            boolean isGate = false;
            if (!(bCanCreateMixedNotationBaseLink || bCanCreateSpeciesDestinationGate || isPhenotype)) {
                if (!(lastTarget instanceof GLink)) {
                    return true;
                }
                isGate = ((GLink)lastTarget).getGLinkedShape() instanceof GLogicGate;
            }
            Vector<GLink> vclink = new Vector<GLink>();
            GLink createdLink = null;
            if (isGate) {
                GLogicGate gate = (GLogicGate)((GLink)lastTarget).getGLinkedShape();
                LinkedCreaseLine creaseLine = gate.getRealLine();
                String type = ((SBSymbol)((Object)creaseLine)).getCode();
                int i3 = 0;
                while (i3 < size - 1) {
                    createdLink = (GLink)GMouseInterpreter.this.factory.createObject(type);
                    GLinkedShape shape = createdLink.getGLinkedShape();
                    if (shape instanceof GLinkConnectSchemeOwner) {
                        int policy = GLinkedLine.getDefaultConnectPolicy();
                        ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                    }
                    if (shape instanceof GLinkedCreaseLine) {
                        int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                        ((GLinkedCreaseLine)shape).resetCreaseLineNumber(n);
                    }
                    this.setTargetInfo(createdLink, (TargetInfo)vTargetInfo.get(i3), eti);
                    vclink.add(createdLink);
                    ++i3;
                }
            } else {
                boolean isRealBaseLink = false;
                boolean isMixedNotationLink = false;
                boolean isMixedNotationBaseLink = false;
                boolean isDifferMixedNotationBaseLink = true;
                if (lastTarget instanceof ReactionLink) {
                    ReactionLink rl = (ReactionLink)lastTarget;
                    GLinkedShape shp = rl.getGLinkedShape();
                    isRealBaseLink = rl.isRealBaseLink();
                    isMixedNotationLink = shp instanceof LinkedCreaseLineMixedNotation;
                    if (isMixedNotationLink) {
                        isMixedNotationBaseLink = rl.isBaseLink();
                        try {
                            String cd1 = ((LinkedCreaseLineMixedNotation)shp).getCode();
                            if (this.creatingGLink.getGLinkedShape() instanceof GLogicGate) {
                                isDifferMixedNotationBaseLink = false;
                            } else {
                                String cd2 = ((LinkedCreaseLineMixedNotation)this.creatingGLink.getGLinkedShape()).getCode();
                                isDifferMixedNotationBaseLink = cd1.equals(cd2);
                            }
                        }
                        catch (Exception myErr) {
                            isDifferMixedNotationBaseLink = true;
                        }
                    }
                }
                if (size == 2) {
                    if (glink.getGLinkedShape() instanceof GLogicGate) {
                        return true;
                    }
                    boolean bCreateSignerLine = false;
                    if (isPhenotype) {
                        bCreateSignerLine = true;
                    } else if (isRealBaseLink) {
                        bCreateSignerLine = true;
                    } else if (!(glink.getGLinkedShape() instanceof GLogicGate) && bCanCreateMixedNotationBaseLink) {
                        bCreateSignerLine = true;
                    } else if (isMixedNotationBaseLink) {
                        bCreateSignerLine = true;
                    }
                    if (bCreateSignerLine) {
                        String type = GMouseInterpreter.this.currentType;
                        if (glink.getGLinkedShape() instanceof GLogicGate) {
                            GLogicGate gate = (GLogicGate)glink.getGLinkedShape();
                            LinkedCreaseLine creaseLine = gate.getRealLine();
                            type = ((SBSymbol)((Object)creaseLine)).getCode();
                        }
                        this.creatingGLink = (GLink)GMouseInterpreter.this.factory.createObject(type);
                        return false;
                    }
                }
                GLink booleanGate = null;
                booleanGate = glink.getGLinkedShape() instanceof GLogicGate ? glink : (GLink)GMouseInterpreter.this.factory.createObject("BOOLEAN_LOGIC_GATE_AND");
                GLogicGate gate = (GLogicGate)booleanGate.getGLinkedShape();
                if (isMixedNotationBaseLink) {
                    gate.setModificationType(GLogicGate.getDefaultMixedNotationType());
                } else if (!isPhenotype && bCanCreateSpeciesDestinationGate) {
                    gate.setModificationType(GLogicGate.getDefaultMixedNotationType());
                }
                if (!(isPhenotype || isRealBaseLink || isMixedNotationBaseLink || bCanCreateSpeciesDestinationGate)) {
                    gate.setModificationType(GLogicGate.getModificationType(((GLink)lastTarget).getGLinkedShape()));
                    gate.addChildLink((GLink)lastTarget);
                }
                double x = 0.0;
                double y = 0.0;
                Point2D.Double p = new Point2D.Double();
                if (!isPhenotype && (isRealBaseLink || isMixedNotationBaseLink)) {
                    int j = 0;
                    while (j < size) {
                        x += ((TargetInfo)vTargetInfo.get(j)).getX();
                        y += ((TargetInfo)vTargetInfo.get(j)).getY();
                        ++j;
                    }
                    x /= (double)size;
                    y /= (double)size;
                } else if (isPhenotype || bCanCreateSpeciesDestinationGate) {
                    p = ((SpeciesAlias)lastTarget).getSpeciesSymbol().getCoordinatesOfLinkPosition(eti.getLpi());
                    int j = 0;
                    while (j < size - 1) {
                        x += ((TargetInfo)vTargetInfo.get(j)).getX();
                        y += ((TargetInfo)vTargetInfo.get(j)).getY();
                        ++j;
                    }
                    x = (x + p.x) / (double)size;
                    y = (y + p.y) / (double)size;
                } else {
                    LinkedCreaseLine lines = (LinkedCreaseLine)((ReactionLink)lastTarget).getGLinkedShape();
                    GLinkedStraightLine straightLine = lines.getLines()[eti.getLpi().getPosition()];
                    x = straightLine.targetPoint().x;
                    y = straightLine.targetPoint().y;
                }
                gate.setStartPoint(new Point2D.Double(x, y));
                GLinkPositionInfo gatePointInfo = new GLinkPositionInfo(0, 0.0);
                gatePointInfo.setElement(booleanGate);
                GLinkPositionInfo pointPointInfo = new GLinkPositionInfo(0, 0.0);
                pointPointInfo.setElement(gate.getHeaderPoint());
                try {
                    booleanGate.setTargetAt(gate.getHeaderPoint(), 0, x, y, pointPointInfo);
                    if (isPhenotype || bCanCreateSpeciesDestinationGate) {
                        booleanGate.setTargetAt(lastTarget, 1, p.x, p.y, eti.getLpi());
                    } else if (isRealBaseLink || isMixedNotationBaseLink) {
                        booleanGate.setTargetAt(lastTarget, 1, eti.getX(), eti.getY(), eti.getLpi());
                    } else {
                        LinkedCreaseLine line = (LinkedCreaseLine)((ReactionLink)lastTarget).getGLinkedShape();
                        booleanGate.setTargetAt(line.getEndTarget(), 1, line.getEndPoint().x, line.getEndPoint().y, line.getEndLinkPositionInfo());
                    }
                }
                catch (Exception line) {
                    // empty catch block
                }
                vclink.add(booleanGate);
                LinkedCreaseLine creaseLine = gate.getRealLine();
                String type = ((SBSymbol)((Object)creaseLine)).getCode();
                int i4 = 0;
                while (i4 < size - 1) {
                    createdLink = (GLink)GMouseInterpreter.this.factory.createObject(type);
                    GLinkedShape shape = createdLink.getGLinkedShape();
                    if (shape instanceof GLinkConnectSchemeOwner) {
                        int policy = GLinkedLine.getDefaultConnectPolicy();
                        ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                    }
                    int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                    if (shape instanceof GLinkedCreaseLine) {
                        ((GLinkedCreaseLine)shape).resetCreaseLineNumber(n);
                    }
                    this.setTargetInfo(createdLink, (TargetInfo)vTargetInfo.get(i4), new TargetInfo(booleanGate, x, y, gatePointInfo));
                    vclink.add(createdLink);
                    ++i4;
                }
                gate.setColor(createdLink.getGLinkedShape().getColor());
                gate.setLineWidth(createdLink.getGLinkedShape().getLineWidth());
            }
            GMouseInterpreter.this.structure.add(vclink);
            int k = 0;
            while (k < vclink.size()) {
                GMouseInterpreter.this.structure.hideLinkAnchors((GLinkTarget)vclink.get(k), false);
                ++k;
            }
            this.creatingGLink = null;
            this.reset();
            this.onMouseTarget = (GLinkTarget)((Object)gl);
            MainWindow.getLastInstance().resetComboBox();
            return true;
        }

        private void setTargetInfo(GLink gl, TargetInfo sti, TargetInfo eti) {
            try {
                gl.setTargetAt(sti.getTarget(), 0, sti.getLpi());
                gl.setTargetAt(eti.getTarget(), 1, eti.getLpi());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class GMacroCreater01 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 150.0;
        String strNamePrefix = "s";
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater01(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 60.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 160.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 60.0;
            double dPOTEIN03TargetPoint_x = creatingPos.getX() + 80.0;
            double dPOTEIN03TargetPoint_y = creatingPos.getY() + 0.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiCATALYSISsrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiCATALYSISdest = new GLinkPositionInfo(2, 0.0);
            if (eventId == 501) {
                String strIDcreatingProtein01;
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein02 = strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strIDcreatingProtein03 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = strNamecreatingSpecies01;
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies03)) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "GENERIC";
                Protein creatingProtein01 = new Protein();
                creatingProtein01.setName(strNamecreatingSpecies01);
                creatingProtein01.setType(creatingType);
                creatingProtein01.setId(strIDcreatingProtein01);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingProtein01);
                property01.setType("PROTEIN");
                creatingType = "GENERIC";
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein01);
                property02.setType("PROTEIN");
                creatingType = "GENERIC";
                Protein creatingProtein03 = new Protein();
                creatingProtein03.setName(strNamecreatingSpecies03);
                creatingProtein03.setType(creatingType);
                creatingProtein03.setId(strIDcreatingProtein03);
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dPOTEIN03TargetPoint_x, dPOTEIN03TargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setProtein(creatingProtein03);
                property03.setType("PROTEIN");
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                ReactionLink rlCATALYSIS = (ReactionLink)GMouseInterpreter.this.factory.createObject("CATALYSIS");
                rlCATALYSIS.setParentReaction(creatingReaction);
                rlCATALYSIS.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiCATALYSISsrc);
                rlCATALYSIS.addDestination((GLinkTarget)rlSTATE_TRANSITION, glpiCATALYSISdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add(rlSTATE_TRANSITION);
                vGFrameSet.add(rlCATALYSIS);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater02 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 150.0;
        String strNamePrefix = "s";
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater02(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 60.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 160.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 60.0;
            double dPOTEIN03TargetPoint_x = creatingPos.getX() + 80.0;
            double dPOTEIN03TargetPoint_y = creatingPos.getY() + 0.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiINHIBITIONsrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiINHIBITIONdest = new GLinkPositionInfo(2, 0.0);
            if (eventId == 501) {
                String strIDcreatingProtein01;
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein02 = strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strIDcreatingProtein03 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = strNamecreatingSpecies01;
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies03)) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "GENERIC";
                Protein creatingProtein01 = new Protein();
                creatingProtein01.setName(strNamecreatingSpecies01);
                creatingProtein01.setType(creatingType);
                creatingProtein01.setId(strIDcreatingProtein01);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingProtein01);
                property01.setType("PROTEIN");
                creatingType = "GENERIC";
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein01);
                property02.setType("PROTEIN");
                creatingType = "GENERIC";
                Protein creatingProtein03 = new Protein();
                creatingProtein03.setName(strNamecreatingSpecies03);
                creatingProtein03.setType(creatingType);
                creatingProtein03.setId(strIDcreatingProtein03);
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dPOTEIN03TargetPoint_x, dPOTEIN03TargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setProtein(creatingProtein03);
                property03.setType("PROTEIN");
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                ReactionLink rlINHIBITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("INHIBITION");
                rlINHIBITION.setParentReaction(creatingReaction);
                rlINHIBITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiINHIBITIONsrc);
                rlINHIBITION.addDestination((GLinkTarget)rlSTATE_TRANSITION, glpiINHIBITIONdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add(rlSTATE_TRANSITION);
                vGFrameSet.add(rlINHIBITION);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater03 {
        double dMacroWidth = 270.0;
        double dMacroHeight = 130.0;
        String strNamePrefix = "s";
        double offset = 10.0;
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater03(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 10.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 70.0;
            double dPOTEIN03TargetPoint_x = creatingPos.getX() + 180.0;
            double dPOTEIN03TargetPoint_y = creatingPos.getY() + 10.0;
            double dPOTEIN04TargetPoint_x = creatingPos.getX() + 180.0;
            double dPOTEIN04TargetPoint_y = creatingPos.getY() + 60.0;
            double dComplex01TargetPoint_x = creatingPos.getX() + 170.0;
            double dComplex01TargetPoint_y = creatingPos.getY() + 0.0;
            GLinkPositionInfo glpiHETERODIMER_ASSOCIATIONsrc1 = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiHETERODIMER_ASSOCIATIONsrc2 = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiHETERODIMER_ASSOCIATIONdest = new GLinkPositionInfo(12, 0.0);
            if (eventId == 501) {
                try {
                    this.creatingGFramed = null;
                    MainWindow mWin = MainWindow.getLastInstance();
                    macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                    String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                    String strIDcreatingProtein02 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                    String strIDcreatingProtein03 = strIDcreatingProtein01;
                    String strIDcreatingProtein04 = strIDcreatingProtein02;
                    String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                        strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    }
                    String strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies02)) {
                        strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    }
                    String strNamecreatingSpecies03 = strNamecreatingSpecies01;
                    String strNamecreatingSpecies04 = strNamecreatingSpecies02;
                    String strNamecreatingSpecies05 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies05)) {
                        strNamecreatingSpecies05 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    }
                    String creatingType = "GENERIC";
                    Protein creatingProtein01 = new Protein();
                    creatingProtein01.setName(strNamecreatingSpecies01);
                    creatingProtein01.setType(creatingType);
                    creatingProtein01.setId(strIDcreatingProtein01);
                    GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                    SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed01).setOriginalSpecies(creatingProtein01);
                    MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                    MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                    property01.setProtein(creatingProtein01);
                    property01.setType("PROTEIN");
                    creatingType = "GENERIC";
                    Protein creatingProtein02 = new Protein();
                    creatingProtein02.setName(strNamecreatingSpecies02);
                    creatingProtein02.setType(creatingType);
                    creatingProtein02.setId(strIDcreatingProtein02);
                    GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                    SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed02).setOriginalSpecies(creatingProtein02);
                    MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                    MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                    property02.setProtein(creatingProtein02);
                    property02.setType("PROTEIN");
                    creatingType = "GENERIC";
                    GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed03.setFramePosition(dPOTEIN03TargetPoint_x, dPOTEIN03TargetPoint_y);
                    SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed03).setOriginalSpecies(creatingProtein01);
                    ((SpeciesAlias)creatingGFramed03).getOriginalSpecies().setCompartment("");
                    MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                    MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                    property03.setProtein(creatingProtein01);
                    property03.setType("PROTEIN");
                    creatingType = "GENERIC";
                    GFramed creatingGFramed04 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed04.setFramePosition(dPOTEIN04TargetPoint_x, dPOTEIN04TargetPoint_y);
                    SpeciesSymbol briefSymbol04 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed04.setFrameSize(briefSymbol04.defaultSize().width, briefSymbol04.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed04).setOriginalSpecies(creatingProtein02);
                    ((SpeciesAlias)creatingGFramed04).getOriginalSpecies().setCompartment("");
                    MonoSpeciesShape mono04 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                    MonoSpeciesProperty property04 = (MonoSpeciesProperty)mono04.getProperty();
                    property04.setProtein(creatingProtein02);
                    property04.setType("PROTEIN");
                    creatingType = "COMPLEX";
                    GFramed creatingGFramed05 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed05.setFramePosition(dComplex01TargetPoint_x, dComplex01TargetPoint_y);
                    SpeciesSymbol briefSymbol05 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed05.setFrameSize(briefSymbol05.defaultSize().width, briefSymbol05.defaultSize().height);
                    MonoSpeciesShape mono05 = (MonoSpeciesShape)((ComplexSpeciesAlias)creatingGFramed05).getGFramedShape();
                    ComplexProperty property05 = (ComplexProperty)mono05.getProperty();
                    property05.setType(creatingType);
                    property05.setName(strNamecreatingSpecies05);
                    ((ComplexSpeciesAlias)creatingGFramed05).clearTargets();
                    ((ComplexSpeciesAlias)creatingGFramed05).addTarget((GContainerTarget)((Object)creatingGFramed03));
                    ((ComplexSpeciesAlias)creatingGFramed05).addTarget((GContainerTarget)((Object)creatingGFramed04));
                    Vector vctMacroTargets = ((ComplexSpeciesAlias)creatingGFramed05).getTargets();
                    Vector<MonoSpeciesProperty> properties = new Vector<MonoSpeciesProperty>();
                    properties.addElement(property03);
                    properties.addElement(property04);
                    property05.setMonoProperties(properties);
                    int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                    GLinkedLine.setDefaultConnectPolicy(0);
                    int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                    GLinkedLine.setDefaultCreasePointNumber(0);
                    GLink glHETERODIMER_ASSOCIATION = (GLink)GMouseInterpreter.this.factory.createObject("HETERODIMER_ASSOCIATION");
                    int policy = GLinkedLine.getDefaultConnectPolicy();
                    GLinkedShape shape = glHETERODIMER_ASSOCIATION.getGLinkedShape();
                    if (shape instanceof GLinkConnectSchemeOwner) {
                        ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                    }
                    int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                    ((GLinkedLineComplex3)shape).resetCreaseLineNumber(n, n, n);
                    glHETERODIMER_ASSOCIATION.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed01))), 0, glpiHETERODIMER_ASSOCIATIONsrc1);
                    glHETERODIMER_ASSOCIATION.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed02))), 1, glpiHETERODIMER_ASSOCIATIONsrc2);
                    glHETERODIMER_ASSOCIATION.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed05))), 2, glpiHETERODIMER_ASSOCIATIONdest);
                    MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed05).getGFramedShape();
                    monoshape.resetShape();
                    Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                    vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                    vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                    vGFrameSet.add((ComplexSpeciesAlias)creatingGFramed05);
                    vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                    vGFrameSet.add((SpeciesAlias)creatingGFramed04);
                    vGFrameSet.add(glHETERODIMER_ASSOCIATION);
                    try {
                        try {
                            mWin.getCurrentModel().getSBModel().getGStructure().setInMacroProcessingFlg(true);
                            mWin.getCurrentModel().getSBModel().getGStructure().setMacroTargets(vctMacroTargets);
                            mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                            Point2D.Double newMidPntPosition = ((GLinkedLineComplex3)shape).getMidPoint();
                            ((GLinkedLineComplex3)shape).setMidCreasePoint(newMidPntPosition.x - this.offset, newMidPntPosition.y);
                        }
                        catch (Exception e) {
                            this.interrupt();
                            mWin.getCurrentModel().getSBModel().getGStructure().setMacroTargets(new Vector());
                            mWin.getCurrentModel().getSBModel().getGStructure().setInMacroProcessingFlg(false);
                            GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                            GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                            return;
                        }
                    }
                    finally {
                        mWin.getCurrentModel().getSBModel().getGStructure().setMacroTargets(new Vector());
                        mWin.getCurrentModel().getSBModel().getGStructure().setInMacroProcessingFlg(false);
                        GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                        GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                    }
                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed05));
                    Vector currentInners = new Vector();
                    currentInners.add(creatingGFramed01);
                    currentInners.add(creatingGFramed02);
                    currentInners.add(creatingGFramed05);
                    mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                    currentInners = new Vector();
                    mWin.getCurrentModel().getSBModel().getGStructure();
                    GStructure.setContainerTarget((ComplexSpeciesAlias)creatingGFramed05, (GContainerTarget)((Object)creatingGFramed03));
                    mWin.getCurrentModel().getSBModel().getGStructure();
                    GStructure.setContainerTarget((ComplexSpeciesAlias)creatingGFramed05, (GContainerTarget)((Object)creatingGFramed04));
                    currentInners = (Vector)((GContainer)((Object)creatingGFramed05)).getTargets().clone();
                    mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                    mWin.getCurrentModel().getSBModel().allPanelUpdate();
                    if (mWin.getCurrentModel().getSBModel().getGStructure() == null) return;
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
                catch (Exception e) {
                    this.interrupt();
                    return;
                }
            }
            if (eventId != 502 || this.creatingGFramed == null) return;
            GMouseInterpreter.this.structure.setTemporalGElement(null);
            this.creatingGFramed = null;
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater04 {
        double dMacroWidth = 270.0;
        double dMacroHeight = 130.0;
        String strNamePrefix = "s";
        double offset = 10.0;
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater04(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 190.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 10.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 190.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 70.0;
            double dPOTEIN03TargetPoint_x = creatingPos.getX() + 10.0;
            double dPOTEIN03TargetPoint_y = creatingPos.getY() + 10.0;
            double dPOTEIN04TargetPoint_x = creatingPos.getX() + 10.0;
            double dPOTEIN04TargetPoint_y = creatingPos.getY() + 60.0;
            double dComplex01TargetPoint_x = creatingPos.getX() + 0.0;
            double dComplex01TargetPoint_y = creatingPos.getY() + 0.0;
            GLinkPositionInfo glpiDISSOCIATIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiDISSOCIATIONdest1 = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiDISSOCIATIONdest2 = new GLinkPositionInfo(12, 0.0);
            if (eventId == 501) {
                try {
                    this.creatingGFramed = null;
                    MainWindow mWin = MainWindow.getLastInstance();
                    macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                    String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                    String strIDcreatingProtein02 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                    String strIDcreatingProtein03 = strIDcreatingProtein01;
                    String strIDcreatingProtein04 = strIDcreatingProtein02;
                    String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                        strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    }
                    String strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies02)) {
                        strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    }
                    String strNamecreatingSpecies03 = strNamecreatingSpecies01;
                    String strNamecreatingSpecies04 = strNamecreatingSpecies02;
                    String strNamecreatingSpecies05 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies05)) {
                        strNamecreatingSpecies05 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                    }
                    String creatingType = "GENERIC";
                    Protein creatingProtein01 = new Protein();
                    creatingProtein01.setName(strNamecreatingSpecies01);
                    creatingProtein01.setType(creatingType);
                    creatingProtein01.setId(strIDcreatingProtein01);
                    GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                    SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed01).setOriginalSpecies(creatingProtein01);
                    MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                    MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                    property01.setProtein(creatingProtein01);
                    property01.setType("PROTEIN");
                    creatingType = "GENERIC";
                    Protein creatingProtein02 = new Protein();
                    creatingProtein02.setName(strNamecreatingSpecies02);
                    creatingProtein02.setType(creatingType);
                    creatingProtein02.setId(strIDcreatingProtein02);
                    GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                    SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed02).setOriginalSpecies(creatingProtein02);
                    MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                    MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                    property02.setProtein(creatingProtein02);
                    property02.setType("PROTEIN");
                    creatingType = "GENERIC";
                    GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed03.setFramePosition(dPOTEIN03TargetPoint_x, dPOTEIN03TargetPoint_y);
                    SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed03).setOriginalSpecies(creatingProtein01);
                    MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                    MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                    property03.setProtein(creatingProtein01);
                    property03.setType("PROTEIN");
                    creatingType = "GENERIC";
                    GFramed creatingGFramed04 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed04.setFramePosition(dPOTEIN04TargetPoint_x, dPOTEIN04TargetPoint_y);
                    SpeciesSymbol briefSymbol04 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed04.setFrameSize(briefSymbol04.defaultSize().width, briefSymbol04.defaultSize().height);
                    ((SpeciesAlias)creatingGFramed04).setOriginalSpecies(creatingProtein02);
                    MonoSpeciesShape mono04 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                    MonoSpeciesProperty property04 = (MonoSpeciesProperty)mono04.getProperty();
                    property04.setProtein(creatingProtein02);
                    property04.setType("PROTEIN");
                    creatingType = "COMPLEX";
                    GFramed creatingGFramed05 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                    creatingGFramed05.setFramePosition(dComplex01TargetPoint_x, dComplex01TargetPoint_y);
                    SpeciesSymbol briefSymbol05 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                    creatingGFramed05.setFrameSize(briefSymbol05.defaultSize().width, briefSymbol05.defaultSize().height);
                    MonoSpeciesShape mono05 = (MonoSpeciesShape)((ComplexSpeciesAlias)creatingGFramed05).getGFramedShape();
                    ComplexProperty property05 = (ComplexProperty)mono05.getProperty();
                    property05.setType(creatingType);
                    property05.setName(strNamecreatingSpecies05);
                    ((ComplexSpeciesAlias)creatingGFramed05).clearTargets();
                    ((ComplexSpeciesAlias)creatingGFramed05).addTarget((GContainerTarget)((Object)creatingGFramed03));
                    ((ComplexSpeciesAlias)creatingGFramed05).addTarget((GContainerTarget)((Object)creatingGFramed04));
                    Vector vctMacroTargets = ((ComplexSpeciesAlias)creatingGFramed05).getTargets();
                    Vector<MonoSpeciesProperty> properties = new Vector<MonoSpeciesProperty>();
                    properties.addElement(property03);
                    properties.addElement(property04);
                    property05.setMonoProperties(properties);
                    int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                    GLinkedLine.setDefaultConnectPolicy(0);
                    int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                    GLinkedLine.setDefaultCreasePointNumber(0);
                    GLink glDISSOCIATION = (GLink)GMouseInterpreter.this.factory.createObject("DISSOCIATION");
                    int policy = GLinkedLine.getDefaultConnectPolicy();
                    GLinkedShape shape = glDISSOCIATION.getGLinkedShape();
                    if (shape instanceof GLinkConnectSchemeOwner) {
                        ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                    }
                    int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                    ((GLinkedLineComplex3)shape).resetCreaseLineNumber(n, n, n);
                    glDISSOCIATION.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed05))), 0, glpiDISSOCIATIONsrc);
                    glDISSOCIATION.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed01))), 1, glpiDISSOCIATIONdest1);
                    glDISSOCIATION.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed02))), 2, glpiDISSOCIATIONdest2);
                    MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                    monoshape.resetShape();
                    monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed05).getGFramedShape();
                    monoshape.resetShape();
                    Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                    vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                    vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                    vGFrameSet.add((ComplexSpeciesAlias)creatingGFramed05);
                    vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                    vGFrameSet.add((SpeciesAlias)creatingGFramed04);
                    vGFrameSet.add(glDISSOCIATION);
                    try {
                        try {
                            mWin.getCurrentModel().getSBModel().getGStructure().setInMacroProcessingFlg(true);
                            mWin.getCurrentModel().getSBModel().getGStructure().setMacroTargets(vctMacroTargets);
                            mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                            Point2D.Double newMidPntPosition = ((GLinkedLineComplex3)shape).getMidPoint();
                            ((GLinkedLineComplex3)shape).setMidCreasePoint(newMidPntPosition.x + this.offset, newMidPntPosition.y);
                        }
                        catch (Exception e) {
                            this.interrupt();
                            mWin.getCurrentModel().getSBModel().getGStructure().setMacroTargets(new Vector());
                            mWin.getCurrentModel().getSBModel().getGStructure().setInMacroProcessingFlg(false);
                            GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                            GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                            return;
                        }
                    }
                    finally {
                        mWin.getCurrentModel().getSBModel().getGStructure().setMacroTargets(new Vector());
                        mWin.getCurrentModel().getSBModel().getGStructure().setInMacroProcessingFlg(false);
                        GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                        GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                    }
                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed05));
                    Vector currentInners = new Vector();
                    currentInners.add(creatingGFramed01);
                    currentInners.add(creatingGFramed02);
                    currentInners.add(creatingGFramed05);
                    mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                    currentInners = new Vector();
                    mWin.getCurrentModel().getSBModel().getGStructure();
                    GStructure.setContainerTarget((ComplexSpeciesAlias)creatingGFramed05, (GContainerTarget)((Object)creatingGFramed03));
                    mWin.getCurrentModel().getSBModel().getGStructure();
                    GStructure.setContainerTarget((ComplexSpeciesAlias)creatingGFramed05, (GContainerTarget)((Object)creatingGFramed04));
                    currentInners = (Vector)((GContainer)((Object)creatingGFramed05)).getTargets().clone();
                    mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                    mWin.getCurrentModel().getSBModel().allPanelUpdate();
                    if (mWin.getCurrentModel().getSBModel().getGStructure() == null) return;
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                        return;
                    }
                    catch (Exception exception) {}
                    return;
                }
                catch (Exception e) {
                    this.interrupt();
                    return;
                }
            }
            if (eventId != 502 || this.creatingGFramed == null) return;
            GMouseInterpreter.this.structure.setTemporalGElement(null);
            this.creatingGFramed = null;
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater05 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 80.0;
        String strNamePrefix = "s";
        double offset = 10.0;
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater05(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 40.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 210.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 40.0;
            double dATPTargetPoint_x = creatingPos.getX() + 50.0;
            double dATPTargetPoint_y = creatingPos.getY() + 0.0;
            double dADPTargetPoint_x = creatingPos.getX() + 180.0;
            double dADPTargetPoint_y = creatingPos.getY() + 0.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiATPsrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiADPsrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiADDREACTANTdest = new GLinkPositionInfo(0, 0.0);
            GLinkPositionInfo glpiADDPRODUCTsrc = new GLinkPositionInfo(1, 0.0);
            if (eventId == 501) {
                String strIDcreatingProtein01;
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein02 = strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = strNamecreatingSpecies01;
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies03)) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies04 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies04)) {
                    strNamecreatingSpecies04 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "GENERIC";
                Protein creatingProtein01 = new Protein();
                creatingProtein01.setName(strNamecreatingSpecies01);
                creatingProtein01.setType(creatingType);
                creatingProtein01.setId(strIDcreatingProtein01);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingProtein01);
                property01.setType("PROTEIN");
                creatingType = "GENERIC";
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein01);
                property02.setType("PROTEIN");
                creatingType = "SIMPLE_MOLECULE";
                Species originSpecies03 = new Species(creatingType);
                originSpecies03.setName(strNamecreatingSpecies03);
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dATPTargetPoint_x, dATPTargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setName("ATP");
                creatingType = "SIMPLE_MOLECULE";
                Species originSpecies04 = new Species(creatingType);
                originSpecies04.setName(strNamecreatingSpecies04);
                GFramed creatingGFramed04 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed04.setFramePosition(dADPTargetPoint_x, dADPTargetPoint_y);
                SpeciesSymbol briefSymbol04 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed04.setFrameSize(briefSymbol04.defaultSize().width, briefSymbol04.defaultSize().height);
                MonoSpeciesShape mono04 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                MonoSpeciesProperty property04 = (MonoSpeciesProperty)mono04.getProperty();
                property04.setName("ADP");
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(2);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                ReactionLink rlADD_REACTANT = (ReactionLink)GMouseInterpreter.this.factory.createObject("ADD_REACTANT");
                GLinkedCurveEndLine addreactantshape = (GLinkedCurveEndLine)rlADD_REACTANT.getGLinkedShape();
                addreactantshape.setLineType(0);
                rlADD_REACTANT.setParentReaction(creatingReaction);
                rlADD_REACTANT.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiATPsrc);
                rlADD_REACTANT.addDestination((GLinkTarget)rlSTATE_TRANSITION, glpiADDREACTANTdest);
                ReactionLink rlADD_PRODUCT = (ReactionLink)GMouseInterpreter.this.factory.createObject("ADD_PRODUCT");
                GLinkedCurveStartLine addproductshape = (GLinkedCurveStartLine)rlADD_PRODUCT.getGLinkedShape();
                addproductshape.setLineType(0);
                rlADD_PRODUCT.setParentReaction(creatingReaction);
                rlADD_PRODUCT.addSource((GLinkTarget)rlSTATE_TRANSITION, glpiADDPRODUCTsrc);
                rlADD_PRODUCT.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed04), glpiADPsrc);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add((SpeciesAlias)creatingGFramed04);
                vGFrameSet.add(rlSTATE_TRANSITION);
                vGFrameSet.add(rlADD_REACTANT);
                vGFrameSet.add(rlADD_PRODUCT);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                try {
                    StateTransition st = (StateTransition)rlSTATE_TRANSITION.getGLinkedShape();
                    GLinkedLineIndex index = new GLinkedLineIndex();
                    index.line = 0;
                    GCreasePoint newPoint = st.createNewCreasePoint(st.getEditPoints()[0].getPosition().x - this.offset, st.getEditPoints()[0].getPosition().y, index);
                    st.getEditPoints()[0].setPosition((Point2D.Double)newPoint.getPosition().clone());
                    st.getEditPoints()[0].setLocalPosition((Point2D.Double)newPoint.getLocalPosition().clone());
                    index.line = 1;
                    newPoint = st.createNewCreasePoint(st.getEditPoints()[1].getPosition().x + this.offset, st.getEditPoints()[1].getPosition().y, index);
                    st.getEditPoints()[1].setPosition((Point2D.Double)newPoint.getPosition().clone());
                    st.getEditPoints()[1].setLocalPosition((Point2D.Double)newPoint.getLocalPosition().clone());
                    rlSTATE_TRANSITION.update();
                    rlADD_REACTANT.update();
                    rlADD_PRODUCT.update();
                    Rectangle2D.Double rec = new Rectangle2D.Double(this.x, this.y, this.dMacroWidth, this.dMacroHeight);
                    mWin.getCurrentModel().getSBModel().getGStructure().callbyuserRepaint(rec);
                }
                catch (Exception st) {
                    // empty catch block
                }
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed04));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                currentInners.add(creatingGFramed04);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater06 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 80.0;
        String strNamePrefix = "s";
        double offset = 10.0;
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater06(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 40.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 210.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 40.0;
            double dGTPTargetPoint_x = creatingPos.getX() + 50.0;
            double dGTPTargetPoint_y = creatingPos.getY() + 0.0;
            double dGDPTargetPoint_x = creatingPos.getX() + 180.0;
            double dGDPTargetPoint_y = creatingPos.getY() + 0.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiGTPsrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiGDPsrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiADDREACTANTdest = new GLinkPositionInfo(0, 0.0);
            GLinkPositionInfo glpiADDPRODUCTsrc = new GLinkPositionInfo(1, 0.0);
            if (eventId == 501) {
                String strIDcreatingProtein01;
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein02 = strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = strNamecreatingSpecies01;
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies03)) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies04 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies04)) {
                    strNamecreatingSpecies04 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "GENERIC";
                Protein creatingProtein01 = new Protein();
                creatingProtein01.setName(strNamecreatingSpecies01);
                creatingProtein01.setType(creatingType);
                creatingProtein01.setId(strIDcreatingProtein01);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingProtein01);
                property01.setType("PROTEIN");
                creatingType = "GENERIC";
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein01);
                property02.setType("PROTEIN");
                creatingType = "SIMPLE_MOLECULE";
                Species originSpecies03 = new Species(creatingType);
                originSpecies03.setName(strNamecreatingSpecies03);
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dGTPTargetPoint_x, dGTPTargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setName("GTP");
                creatingType = "SIMPLE_MOLECULE";
                Species originSpecies04 = new Species(creatingType);
                originSpecies04.setName(strNamecreatingSpecies04);
                GFramed creatingGFramed04 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed04.setFramePosition(dGDPTargetPoint_x, dGDPTargetPoint_y);
                SpeciesSymbol briefSymbol04 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed04.setFrameSize(briefSymbol04.defaultSize().width, briefSymbol04.defaultSize().height);
                MonoSpeciesShape mono04 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                MonoSpeciesProperty property04 = (MonoSpeciesProperty)mono04.getProperty();
                property04.setName("GDP");
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(2);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                ReactionLink rlADD_REACTANT = (ReactionLink)GMouseInterpreter.this.factory.createObject("ADD_REACTANT");
                GLinkedCurveEndLine addreactantshape = (GLinkedCurveEndLine)rlADD_REACTANT.getGLinkedShape();
                addreactantshape.setLineType(0);
                rlADD_REACTANT.setParentReaction(creatingReaction);
                rlADD_REACTANT.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiGTPsrc);
                rlADD_REACTANT.addDestination((GLinkTarget)rlSTATE_TRANSITION, glpiADDREACTANTdest);
                ReactionLink rlADD_PRODUCT = (ReactionLink)GMouseInterpreter.this.factory.createObject("ADD_PRODUCT");
                GLinkedCurveStartLine addproductshape = (GLinkedCurveStartLine)rlADD_PRODUCT.getGLinkedShape();
                addproductshape.setLineType(0);
                rlADD_PRODUCT.setParentReaction(creatingReaction);
                rlADD_PRODUCT.addSource((GLinkTarget)rlSTATE_TRANSITION, glpiADDPRODUCTsrc);
                rlADD_PRODUCT.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed04), glpiGDPsrc);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add((SpeciesAlias)creatingGFramed04);
                vGFrameSet.add(rlSTATE_TRANSITION);
                vGFrameSet.add(rlADD_REACTANT);
                vGFrameSet.add(rlADD_PRODUCT);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                try {
                    StateTransition st = (StateTransition)rlSTATE_TRANSITION.getGLinkedShape();
                    GLinkedLineIndex index = new GLinkedLineIndex();
                    index.line = 0;
                    GCreasePoint newPoint = st.createNewCreasePoint(st.getEditPoints()[0].getPosition().x - this.offset, st.getEditPoints()[0].getPosition().y, index);
                    st.getEditPoints()[0].setPosition((Point2D.Double)newPoint.getPosition().clone());
                    st.getEditPoints()[0].setLocalPosition((Point2D.Double)newPoint.getLocalPosition().clone());
                    index.line = 1;
                    newPoint = st.createNewCreasePoint(st.getEditPoints()[1].getPosition().x + this.offset, st.getEditPoints()[1].getPosition().y, index);
                    st.getEditPoints()[1].setPosition((Point2D.Double)newPoint.getPosition().clone());
                    st.getEditPoints()[1].setLocalPosition((Point2D.Double)newPoint.getLocalPosition().clone());
                    rlSTATE_TRANSITION.update();
                    rlADD_REACTANT.update();
                    rlADD_PRODUCT.update();
                    Rectangle2D.Double rec = new Rectangle2D.Double(this.x, this.y, this.dMacroWidth, this.dMacroHeight);
                    mWin.getCurrentModel().getSBModel().getGStructure().callbyuserRepaint(rec);
                }
                catch (Exception st) {
                    // empty catch block
                }
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed04));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                currentInners.add(creatingGFramed04);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater07 {
        private String sMacro07Type = "CATALYSIS";
        private int iMacro07LinktargetSize = 1;
        String strNamePrefix = "s";
        private GLink creatingMacro07GLink;
        private Vector skips = new Vector();
        private GLinkTarget onMouseTarget = null;
        private GLinkTarget selectedAsTarget = null;
        private GLinkPositionInfo onMouseTargetLinkPosition = null;
        private Vector connectingTargets = new Vector();
        private Vector connectingTargetsInfo = new Vector();
        double dMacroWidth = 80.0;
        double dMacroHeight = 70.0;
        private boolean bisUP = true;

        private void reset() {
            this.skips.clear();
            if (this.onMouseTarget != null) {
                GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
            }
            if (this.connectingTargets != null) {
                int i = 0;
                while (i < this.connectingTargets.size()) {
                    GLinkTarget t = (GLinkTarget)this.connectingTargets.elementAt(i);
                    GMouseInterpreter.this.structure.hideLinkAnchors(t);
                    ++i;
                }
                this.connectingTargets.clear();
            }
            this.connectingTargetsInfo.clear();
            this.onMouseTarget = null;
            this.onMouseTargetLinkPosition = null;
            this.selectedAsTarget = null;
            if (GMouseInterpreter.this.structure != null) {
                GMouseInterpreter.this.structure.releaseHighlight();
            }
        }

        private void interpret(double pointX, double pointY, int id) {
            block48: {
                GLinkPositionInfo glpiCATALYSISsrcU = new GLinkPositionInfo(8, 0.0);
                GLinkPositionInfo glpiCATALYSISsrcD = new GLinkPositionInfo(0, 0.0);
                if (this.creatingMacro07GLink == null) {
                    GMouseInterpreter.this.structure.deselectAll();
                    this.creatingMacro07GLink = (GLink)GMouseInterpreter.this.factory.createObject(this.sMacro07Type);
                    if (this.creatingMacro07GLink != null) {
                        this.reset();
                    } else {
                        return;
                    }
                }
                GLinkPositionInfo lpi = GMouseInterpreter.this.structure.getPointedLinkableElement(pointX, pointY, this.skips, this.creatingMacro07GLink, this.iMacro07LinktargetSize);
                boolean active = false;
                GElement gelement = null;
                if (lpi != null) {
                    gelement = lpi.getElement();
                    if (gelement instanceof ReactionLink) {
                        if (((ReactionLink)gelement).isBaseLink()) {
                            GLinkedShape glinkedshape = ((GLink)gelement).getGLinkedShape();
                            if (glinkedshape instanceof GLinkedLineComplex3) {
                                if (lpi.getPosition() >= 2 && lpi.getPosition() <= 7) {
                                    active = lpi.hasActive();
                                } else {
                                    lpi.setPosition(2);
                                    active = lpi.hasActive();
                                }
                            } else if (glinkedshape instanceof GLogicGate) {
                                gelement = null;
                            } else if (glinkedshape instanceof StateTransition) {
                                if (lpi.getPosition() >= 2 && lpi.getPosition() <= 7) {
                                    active = lpi.hasActive();
                                } else {
                                    lpi.setPosition(2);
                                    active = lpi.hasActive();
                                }
                            } else {
                                gelement = null;
                            }
                        }
                    } else {
                        gelement = null;
                    }
                }
                if (active) {
                    if (this.onMouseTarget != gelement) {
                        if (this.onMouseTarget != null && !this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                        }
                        this.onMouseTarget = (GLinkTarget)((Object)gelement);
                        this.onMouseTargetLinkPosition = lpi;
                        if (!this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpi, false);
                        }
                    } else if (!this.onMouseTargetLinkPosition.equals(lpi)) {
                        this.onMouseTargetLinkPosition = lpi;
                        if (!this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpi, false);
                        }
                    }
                    if (id == 501) {
                        GMouseInterpreter.this.structure.highlightAsTarget(gelement);
                        this.selectedAsTarget = (GLinkTarget)((Object)gelement);
                    } else if (id == 502) {
                        if (this.selectedAsTarget == gelement) {
                            this.connectingTargetsInfo.add(new TargetInfo(this.selectedAsTarget, pointX, pointY, lpi));
                            this.skips.add(this.selectedAsTarget);
                            this.connectingTargets.add(this.selectedAsTarget);
                            GMouseInterpreter.this.structure.showLinkAnchors(this.selectedAsTarget, lpi, true);
                            this.selectedAsTarget = null;
                            int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                            GLinkedLine.setDefaultConnectPolicy(0);
                            int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                            GLinkedLine.setDefaultCreasePointNumber(0);
                            int policy = GLinkedLine.getDefaultConnectPolicy();
                            GLinkedShape shape = this.creatingMacro07GLink.getGLinkedShape();
                            ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                            int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                            ((GLinkedCreaseLine)shape).resetCreaseLineNumber(n);
                            try {
                                try {
                                    double dPOTEIN01TargetPoint_y;
                                    double dPOTEIN01TargetPoint_x;
                                    Point2D creatingPos;
                                    double x = ((GLink)gelement).getCoordinatesOfLinkPosition((GLinkPositionInfo)lpi).x;
                                    double y = ((GLink)gelement).getCoordinatesOfLinkPosition((GLinkPositionInfo)lpi).y;
                                    Rectangle2D editSize = GMouseInterpreter.this.getEditSize();
                                    if (y >= this.dMacroHeight) {
                                        this.bisUP = true;
                                        creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, x - this.dMacroWidth / 2.0, y - this.dMacroHeight, this.dMacroWidth, this.dMacroHeight);
                                    } else {
                                        this.bisUP = false;
                                        creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, x - this.dMacroWidth / 2.0, y, this.dMacroWidth, this.dMacroHeight);
                                    }
                                    x = creatingPos.getX();
                                    y = creatingPos.getY();
                                    if (this.bisUP) {
                                        dPOTEIN01TargetPoint_x = x;
                                        dPOTEIN01TargetPoint_y = y;
                                    } else {
                                        dPOTEIN01TargetPoint_x = x;
                                        dPOTEIN01TargetPoint_y = y + 30.0;
                                    }
                                    MainWindow mWin = MainWindow.getLastInstance();
                                    macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                                    String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                                    String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                                        strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                                    }
                                    String creatingType = "GENERIC";
                                    Protein creatingProtein01 = new Protein();
                                    creatingProtein01.setName(strNamecreatingSpecies01);
                                    creatingProtein01.setType(creatingType);
                                    creatingProtein01.setId(strIDcreatingProtein01);
                                    GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                                    creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                                    SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                                    creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                                    MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                                    MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                                    property01.setProtein(creatingProtein01);
                                    property01.setType("PROTEIN");
                                    MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                                    monoshape.resetShape();
                                    if (this.bisUP) {
                                        this.creatingMacro07GLink.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed01))), 0, glpiCATALYSISsrcU);
                                    } else {
                                        this.creatingMacro07GLink.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed01))), 0, glpiCATALYSISsrcD);
                                    }
                                    TargetInfo ti = (TargetInfo)this.connectingTargetsInfo.get(0);
                                    GLinkTarget target = ti.getTarget();
                                    this.creatingMacro07GLink.setTargetAt(target, 1, pointX, pointY, ti.getLpi());
                                    Vector<Object> vGFrameSet = new Vector<Object>();
                                    vGFrameSet.add(creatingGFramed01);
                                    vGFrameSet.add(this.creatingMacro07GLink);
                                    GMouseInterpreter.this.structure.add(vGFrameSet);
                                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                                    Vector<GFramed> currentInners = new Vector<GFramed>();
                                    currentInners.add(creatingGFramed01);
                                    mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                                    mWin.getCurrentModel().getSBModel().allPanelUpdate();
                                    if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                                        try {
                                            mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                                            mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget, false);
                                    this.creatingMacro07GLink = null;
                                    this.reset();
                                    break block48;
                                }
                                catch (Exception e) {
                                    this.interrupt();
                                    GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                                    GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                                    return;
                                }
                            }
                            finally {
                                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                            }
                        }
                        if (this.selectedAsTarget != null) {
                            GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
                            this.selectedAsTarget = null;
                        }
                    }
                } else {
                    if (this.onMouseTarget != null) {
                        if (!this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                        }
                        this.onMouseTarget = null;
                    }
                    if (id == 502 && this.selectedAsTarget != null) {
                        GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
                        this.selectedAsTarget = null;
                    }
                }
            }
        }

        public void interrupt() {
            this.creatingMacro07GLink = null;
            this.reset();
        }
    }

    public class GMacroCreater08 {
        private String sMacro08Type = "INHIBITION";
        private int iMacro08LinktargetSize = 1;
        String strNamePrefix = "s";
        private GLink creatingMacro08GLink;
        private Vector skips = new Vector();
        private GLinkTarget onMouseTarget = null;
        private GLinkTarget selectedAsTarget = null;
        private GLinkPositionInfo onMouseTargetLinkPosition = null;
        private Vector connectingTargets = new Vector();
        private Vector connectingTargetsInfo = new Vector();
        double dMacroWidth = 80.0;
        double dMacroHeight = 70.0;
        private boolean bisUP = true;

        private void reset() {
            this.skips.clear();
            if (this.onMouseTarget != null) {
                GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
            }
            if (this.connectingTargets != null) {
                int i = 0;
                while (i < this.connectingTargets.size()) {
                    GLinkTarget t = (GLinkTarget)this.connectingTargets.elementAt(i);
                    GMouseInterpreter.this.structure.hideLinkAnchors(t);
                    ++i;
                }
                this.connectingTargets.clear();
            }
            this.connectingTargetsInfo.clear();
            this.onMouseTarget = null;
            this.onMouseTargetLinkPosition = null;
            this.selectedAsTarget = null;
            if (GMouseInterpreter.this.structure != null) {
                GMouseInterpreter.this.structure.releaseHighlight();
            }
        }

        private void interpret(double pointX, double pointY, int id) {
            block48: {
                GLinkPositionInfo glpiCATALYSISsrcU = new GLinkPositionInfo(8, 0.0);
                GLinkPositionInfo glpiCATALYSISsrcD = new GLinkPositionInfo(0, 0.0);
                if (this.creatingMacro08GLink == null) {
                    GMouseInterpreter.this.structure.deselectAll();
                    this.creatingMacro08GLink = (GLink)GMouseInterpreter.this.factory.createObject(this.sMacro08Type);
                    if (this.creatingMacro08GLink != null) {
                        this.reset();
                    } else {
                        return;
                    }
                }
                GLinkPositionInfo lpi = GMouseInterpreter.this.structure.getPointedLinkableElement(pointX, pointY, this.skips, this.creatingMacro08GLink, this.iMacro08LinktargetSize);
                boolean active = false;
                GElement gelement = null;
                if (lpi != null) {
                    gelement = lpi.getElement();
                    if (gelement instanceof ReactionLink) {
                        if (((ReactionLink)gelement).isBaseLink()) {
                            GLinkedShape glinkedshape = ((GLink)gelement).getGLinkedShape();
                            if (glinkedshape instanceof GLinkedLineComplex3) {
                                if (lpi.getPosition() >= 2 && lpi.getPosition() <= 7) {
                                    active = lpi.hasActive();
                                } else {
                                    lpi.setPosition(2);
                                    active = lpi.hasActive();
                                }
                            } else if (glinkedshape instanceof GLogicGate) {
                                gelement = null;
                            } else if (glinkedshape instanceof StateTransition) {
                                if (lpi.getPosition() >= 2 && lpi.getPosition() <= 7) {
                                    active = lpi.hasActive();
                                } else {
                                    lpi.setPosition(2);
                                    active = lpi.hasActive();
                                }
                            } else {
                                gelement = null;
                            }
                        }
                    } else {
                        gelement = null;
                    }
                }
                if (active) {
                    if (this.onMouseTarget != gelement) {
                        if (this.onMouseTarget != null && !this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                        }
                        this.onMouseTarget = (GLinkTarget)((Object)gelement);
                        this.onMouseTargetLinkPosition = lpi;
                        if (!this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpi, false);
                        }
                    } else if (!this.onMouseTargetLinkPosition.equals(lpi)) {
                        this.onMouseTargetLinkPosition = lpi;
                        if (!this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpi, false);
                        }
                    }
                    if (id == 501) {
                        GMouseInterpreter.this.structure.highlightAsTarget(gelement);
                        this.selectedAsTarget = (GLinkTarget)((Object)gelement);
                    } else if (id == 502) {
                        if (this.selectedAsTarget == gelement) {
                            this.connectingTargetsInfo.add(new TargetInfo(this.selectedAsTarget, pointX, pointY, lpi));
                            this.skips.add(this.selectedAsTarget);
                            this.connectingTargets.add(this.selectedAsTarget);
                            GMouseInterpreter.this.structure.showLinkAnchors(this.selectedAsTarget, lpi, true);
                            this.selectedAsTarget = null;
                            int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                            GLinkedLine.setDefaultConnectPolicy(0);
                            int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                            GLinkedLine.setDefaultCreasePointNumber(0);
                            int policy = GLinkedLine.getDefaultConnectPolicy();
                            GLinkedShape shape = this.creatingMacro08GLink.getGLinkedShape();
                            ((GLinkConnectSchemeOwner)((Object)shape)).setConnectPolicy(policy);
                            int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
                            ((GLinkedCreaseLine)shape).resetCreaseLineNumber(n);
                            try {
                                try {
                                    double dPOTEIN01TargetPoint_y;
                                    double dPOTEIN01TargetPoint_x;
                                    Point2D creatingPos;
                                    double x = ((GLink)gelement).getCoordinatesOfLinkPosition((GLinkPositionInfo)lpi).x;
                                    double y = ((GLink)gelement).getCoordinatesOfLinkPosition((GLinkPositionInfo)lpi).y;
                                    Rectangle2D editSize = GMouseInterpreter.this.getEditSize();
                                    if (y >= this.dMacroHeight) {
                                        this.bisUP = true;
                                        creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, x - this.dMacroWidth / 2.0, y - this.dMacroHeight, this.dMacroWidth, this.dMacroHeight);
                                    } else {
                                        this.bisUP = false;
                                        creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, x - this.dMacroWidth / 2.0, y, this.dMacroWidth, this.dMacroHeight);
                                    }
                                    x = creatingPos.getX();
                                    y = creatingPos.getY();
                                    if (this.bisUP) {
                                        dPOTEIN01TargetPoint_x = x;
                                        dPOTEIN01TargetPoint_y = y;
                                    } else {
                                        dPOTEIN01TargetPoint_x = x;
                                        dPOTEIN01TargetPoint_y = y + 30.0;
                                    }
                                    MainWindow mWin = MainWindow.getLastInstance();
                                    macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                                    String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                                    String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                                    while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                                        strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                                    }
                                    String creatingType = "GENERIC";
                                    Protein creatingProtein01 = new Protein();
                                    creatingProtein01.setName(strNamecreatingSpecies01);
                                    creatingProtein01.setType(creatingType);
                                    creatingProtein01.setId(strIDcreatingProtein01);
                                    GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                                    creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                                    SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                                    creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                                    MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                                    MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                                    property01.setProtein(creatingProtein01);
                                    property01.setType("PROTEIN");
                                    MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                                    monoshape.resetShape();
                                    if (this.bisUP) {
                                        this.creatingMacro08GLink.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed01))), 0, glpiCATALYSISsrcU);
                                    } else {
                                        this.creatingMacro08GLink.setTargetAt((GLinkTarget)((Object)((GElement)((Object)creatingGFramed01))), 0, glpiCATALYSISsrcD);
                                    }
                                    TargetInfo ti = (TargetInfo)this.connectingTargetsInfo.get(0);
                                    GLinkTarget target = ti.getTarget();
                                    this.creatingMacro08GLink.setTargetAt(target, 1, pointX, pointY, ti.getLpi());
                                    Vector<Object> vGFrameSet = new Vector<Object>();
                                    vGFrameSet.add(creatingGFramed01);
                                    vGFrameSet.add(this.creatingMacro08GLink);
                                    GMouseInterpreter.this.structure.add(vGFrameSet);
                                    GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                                    Vector<GFramed> currentInners = new Vector<GFramed>();
                                    currentInners.add(creatingGFramed01);
                                    mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                                    mWin.getCurrentModel().getSBModel().allPanelUpdate();
                                    if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                                        try {
                                            mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                                            mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget, false);
                                    this.creatingMacro08GLink = null;
                                    this.reset();
                                    break block48;
                                }
                                catch (Exception e) {
                                    this.interrupt();
                                    GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                                    GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                                    return;
                                }
                            }
                            finally {
                                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                            }
                        }
                        if (this.selectedAsTarget != null) {
                            GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
                            this.selectedAsTarget = null;
                        }
                    }
                } else {
                    if (this.onMouseTarget != null) {
                        if (!this.connectingTargets.contains(this.onMouseTarget)) {
                            GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                        }
                        this.onMouseTarget = null;
                    }
                    if (id == 502 && this.selectedAsTarget != null) {
                        GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
                        this.selectedAsTarget = null;
                    }
                }
            }
        }

        public void interrupt() {
            this.creatingMacro08GLink = null;
            this.reset();
        }
    }

    public class GMacroCreater09 {
        double dMacroWidth = 230.0;
        double dMacroHeight = 50.0;
        double dResidueAngle = 2.4;
        String strNamePrefix = "s";
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater09(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 5.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 5.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 155.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 5.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            if (eventId == 501) {
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = strNamecreatingSpecies01;
                String creatingType = "GENERIC";
                Protein creatingProtein01 = new Protein();
                creatingProtein01.setName(strNamecreatingSpecies01);
                creatingProtein01.setType(creatingType);
                creatingProtein01.setId(strIDcreatingProtein01);
                ModificationResidue mResidue01 = new ModificationResidue();
                mResidue01.setId("rs1");
                mResidue01.setName("rs1");
                mResidue01.setSide("none");
                mResidue01.setAngle(this.dResidueAngle);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                mono01.resetShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingProtein01);
                property01.setType("PROTEIN");
                Modification modification01 = new Modification();
                modification01.setResidue(mResidue01.getId());
                Vector<Modification> vctModification01 = new Vector<Modification>();
                vctModification01.add(modification01);
                property01.getProtein().getListOfModificationResidues().add(mResidue01);
                property01.getModifications().add(modification01);
                creatingType = "GENERIC";
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                mono02.resetShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein01);
                property02.setType("PROTEIN");
                Modification modification02 = new Modification();
                modification02.setResidue(mResidue01.getId());
                modification02.setState("phosphorylated");
                Vector<Modification> vctModification02 = new Vector<Modification>();
                vctModification02.add(modification02);
                property02.getModifications().add(modification02);
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add(rlSTATE_TRANSITION);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    public class GMacroCreater10 {
        String strNamePrefix = "s";
        final int maxDif = 3;
        MainWindow mWin = MainWindow.getLastInstance();
        private GLinkPositionInfo selectedLpi = null;
        private ModificationShape onMouseShape = null;
        private ModificationShape selectedShape = null;
        private GLinkTarget onMouseTarget = null;
        private GLinkTarget selectedAsTarget = null;
        private GLinkPositionInfo onMouseTargetLinkPosition = null;

        private void reset() {
            if (this.onMouseShape != null) {
                GMouseInterpreter.this.structure.highlightModification(this.onMouseShape, false, true);
            }
            this.onMouseShape = null;
            this.selectedShape = null;
            if (this.onMouseTarget != null) {
                GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
            }
            this.onMouseTarget = null;
            this.onMouseTargetLinkPosition = null;
            this.selectedAsTarget = null;
            if (GMouseInterpreter.this.structure != null) {
                GMouseInterpreter.this.structure.releaseHighlight();
            }
        }

        private void interpret(double pointX, double pointY, int id) {
            MonoSpeciesProperty propertyNew;
            MonoSpeciesProperty propertyOld;
            ModificationShape mShape;
            GElement geOld;
            GLinkPositionInfo lpiOld;
            boolean active;
            block58: {
                active = false;
                lpiOld = null;
                geOld = GMouseInterpreter.this.structure.getElement(pointX, pointY);
                GElement geNew = null;
                mShape = null;
                MonoSpeciesShape monoshapeOld = null;
                propertyOld = null;
                MonoSpeciesShape monoshapeNew = null;
                propertyNew = null;
                if (geOld != null) {
                    try {
                        lpiOld = ((GLinkTarget)((Object)geOld)).getPointedLinkPosition(pointX, pointY);
                        monoshapeOld = (MonoSpeciesShape)((SpeciesAlias)geOld).getGFramedShape();
                        propertyOld = (MonoSpeciesProperty)monoshapeOld.getProperty();
                        if (propertyOld.getType().equals("PROTEIN") || propertyOld.getType().equals("GENERIC")) {
                            mShape = monoshapeOld.getSelectedModificationResidueShape();
                            lpiOld.setElement(geOld);
                            geNew = geOld.createCopy();
                            monoshapeNew = (MonoSpeciesShape)((SpeciesAlias)geNew).getGFramedShape().createCopy();
                            propertyNew = (MonoSpeciesProperty)monoshapeNew.getProperty().deepClone();
                            if (mShape == null) {
                                active = lpiOld.hasActive();
                            } else {
                                SelectResidueModificationDialog residueModificationDialog = this.mWin.getSelectResidueModificationDialog();
                                String state = residueModificationDialog.getSelectedModification();
                                if (state.equals(mShape.getModification().getState())) {
                                    mShape = null;
                                    active = lpiOld.hasActive();
                                } else {
                                    active = true;
                                }
                            }
                            if (!active || mShape != null) break block58;
                            Point2D.Double co = monoshapeOld.getCoordinatesOfLinkPosition(lpiOld);
                            Vector mShapes = monoshapeOld.getMShapes();
                            if (mShapes == null) break block58;
                            int i = 0;
                            while (i < mShapes.size()) {
                                ModificationShape ms = (ModificationShape)mShapes.get(i);
                                if (ms.getModificationResidue() != null && ms.inShape(co.getX(), co.getY())) {
                                    double cx = ms.getCircleBounds().getCenterX();
                                    double cy = ms.getCircleBounds().getCenterY();
                                    double difx = Math.abs(co.getX() - cx);
                                    double dify = Math.abs(co.getY() - cy);
                                    if (!(difx > 3.0) && !(dify > 3.0)) {
                                        lpiOld.setPosition(-1);
                                        break block58;
                                    }
                                }
                                ++i;
                            }
                            break block58;
                        }
                        mShape = null;
                        geOld = null;
                        lpiOld = null;
                    }
                    catch (Exception e) {
                        mShape = null;
                        geOld = null;
                        lpiOld = null;
                    }
                }
            }
            if (active) {
                if (this.onMouseTarget != geOld) {
                    if (this.onMouseTarget != null) {
                        GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                    }
                    if (this.onMouseShape != null) {
                        GMouseInterpreter.this.structure.highlightModification(this.onMouseShape, false, true);
                    }
                    this.onMouseShape = mShape;
                    this.onMouseTarget = (GLinkTarget)((Object)geOld);
                    this.onMouseTargetLinkPosition = lpiOld;
                } else {
                    if (this.onMouseShape != mShape) {
                        if (this.onMouseShape != null) {
                            GMouseInterpreter.this.structure.highlightModification(this.onMouseShape, false, true);
                        }
                        this.onMouseShape = mShape;
                    }
                    if (!this.onMouseTargetLinkPosition.equals(lpiOld)) {
                        this.onMouseTargetLinkPosition = lpiOld;
                    }
                }
                if (this.onMouseShape != null) {
                    GMouseInterpreter.this.structure.highlightModification(this.onMouseShape, true, true);
                    GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                } else {
                    GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpiOld, false);
                }
                if (id == 501) {
                    this.selectedShape = mShape;
                    if (this.selectedShape == null) {
                        GMouseInterpreter.this.structure.highlightAsTarget(geOld);
                    }
                    this.selectedAsTarget = (GLinkTarget)((Object)geOld);
                    this.selectedLpi = lpiOld;
                } else if (id == 502) {
                    boolean isSameResidue = false;
                    try {
                        if (this.selectedShape == null && mShape == null) {
                            isSameResidue = true;
                        } else if (this.selectedShape == null || mShape == null) {
                            isSameResidue = false;
                        } else if (this.selectedShape == mShape) {
                            isSameResidue = true;
                        }
                    }
                    catch (Exception myErr) {
                        isSameResidue = false;
                    }
                    if (lpiOld.getPosition() >= 0 && this.selectedAsTarget == geOld && isSameResidue && this.selectedLpi.getPosition() == lpiOld.getPosition()) {
                        try {
                            SBModel sbModel = this.mWin.getCurrentModel().getSBModel();
                            SelectResidueModificationDialog residueModificationDialog = this.mWin.getSelectResidueModificationDialog();
                            int iChgFlg = 3;
                            sbModel.eventGroupBegan(null);
                            if (mShape != null && this.selectedShape == mShape) {
                                String residue = mShape.getModificationResidue().getId();
                                String state = residueModificationDialog.getSelectedModification();
                                Modification modification = propertyNew.findModification(residue);
                                if (modification != null) {
                                    modification.setState(state);
                                } else {
                                    propertyNew.getModifications().add(new Modification(residue, state));
                                }
                                Vector aliases = propertyOld.getProtein().getReferences();
                                iChgFlg = aliases.size() > 1 ? 2 : 3;
                                sbModel.changeSpeciesProperty((SpeciesAlias)geOld, propertyNew, iChgFlg);
                            } else {
                                GMouseInterpreter.this.structure.showLinkAnchors(this.selectedAsTarget, lpiOld, true);
                                ModificationResidue mResidue = new ModificationResidue();
                                Vector vOldListOfModificationResidues = propertyNew.getProtein().getListOfModificationResidues();
                                String sTmpId = "";
                                boolean bFound = false;
                                try {
                                    int iLoopA = 1;
                                    while (true) {
                                        sTmpId = "rs" + iLoopA;
                                        bFound = false;
                                        int i = 0;
                                        while (i < vOldListOfModificationResidues.size()) {
                                            if (((ModificationResidue)vOldListOfModificationResidues.get(i)).getId().equals(sTmpId)) {
                                                bFound = true;
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (bFound) {
                                            ++iLoopA;
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    sTmpId = "rs999";
                                }
                                mResidue.setId(sTmpId);
                                mResidue.setSide("none");
                                mResidue.setAngle(GMouseInterpreter.this.getAngleFromPosition(lpiOld));
                                propertyNew.getProtein().getListOfModificationResidues().add(mResidue);
                                sbModel.proteinUpdated(propertyOld.getProtein(), propertyNew.getProtein());
                                String state = residueModificationDialog.getSelectedModification();
                                if (!state.equals("empty")) {
                                    Modification modification;
                                    String residue = mResidue.getId();
                                    Species species = ((SpeciesAlias)geOld).getOriginalSpecies();
                                    int speciesAliasRefCount = 0;
                                    Vector atoms = GMouseInterpreter.this.structure.getAtoms();
                                    int i = 0;
                                    while (i < atoms.size()) {
                                        ElementSpeciesAlias esa;
                                        String esaId;
                                        if (atoms.get(i) instanceof ElementSpeciesAlias && (esaId = (esa = (ElementSpeciesAlias)atoms.get(i)).getOriginalSpecies().getId()).equals(species.getId())) {
                                            ++speciesAliasRefCount;
                                        }
                                        ++i;
                                    }
                                    if (speciesAliasRefCount > 1) {
                                        iChgFlg = 2;
                                    }
                                    if ((modification = propertyNew.findModification(residue)) != null) {
                                        modification.setState(state);
                                    } else {
                                        propertyNew.getModifications().add(new Modification(residue, state));
                                    }
                                    sbModel.changeSpeciesProperty((SpeciesAlias)geOld, propertyNew, iChgFlg);
                                }
                            }
                            sbModel.eventGroupEnded(null);
                            if (this.mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                                try {
                                    this.mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                                    this.mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(this.mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.reset();
                        }
                        catch (Exception e) {
                            this.interrupt();
                            return;
                        }
                    }
                    this.cancelSelectedTarget();
                }
            } else {
                if (this.onMouseTarget != null) {
                    GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                    this.onMouseTarget = null;
                }
                if (this.onMouseShape != null) {
                    GMouseInterpreter.this.structure.highlightModification(this.onMouseShape, false, true);
                    this.onMouseShape = null;
                }
                if (id == 502) {
                    this.cancelSelectedTarget();
                }
            }
        }

        private void cancelSelectedTarget() {
            if (this.selectedAsTarget != null) {
                GMouseInterpreter.this.structure.highlightAsTarget((GElement)((Object)this.selectedAsTarget), false);
            }
            if (this.selectedShape != null) {
                GMouseInterpreter.this.structure.highlightModification(this.selectedShape, false, true);
            }
            this.selectedShape = null;
            this.selectedAsTarget = null;
            this.selectedLpi = null;
        }

        public void interrupt() {
            this.reset();
        }
    }

    private class GMacroCreater11 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 40.0;
        String strNamePrefix = "s";
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater11(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX();
            double dPOTEIN01TargetPoint_y = creatingPos.getY();
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 160.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY();
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            if (eventId == 501) {
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "GENERIC";
                Protein creatingProtein01 = new Protein();
                creatingProtein01.setName(strNamecreatingSpecies01);
                creatingProtein01.setType(creatingType);
                creatingProtein01.setId(strIDcreatingProtein01);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingProtein01);
                property01.setType("PROTEIN");
                creatingType = "GENERIC";
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein01);
                property02.setType("PROTEIN");
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add(rlSTATE_TRANSITION);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    private class GMacroCreater12 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 150.0;
        String strNamePrefix = "s";
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater12(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 0.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 150.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 3.0;
            double dPOTEIN03TargetPoint_x = creatingPos.getX() + 59.0;
            double dPOTEIN03TargetPoint_y = creatingPos.getY() + 75.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiTRIGGERsrc = new GLinkPositionInfo(0, 0.0);
            GLinkPositionInfo glpiTRIGGERdest = new GLinkPositionInfo(3, 0.0);
            if (eventId == 501) {
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingRNA02 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewRNAId();
                String strIDcreatingGene03 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewGeneId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingSpecies(strNamecreatingSpecies01, "DEGRADED")) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingRNA(strNamecreatingSpecies02)) {
                    strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingGene(strNamecreatingSpecies03)) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "DEGRADED";
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setName(strNamecreatingSpecies01);
                property01.setType(creatingType);
                creatingType = "RNA";
                RNA creatingRNA02 = new RNA();
                creatingRNA02.setName(strNamecreatingSpecies02);
                creatingRNA02.setType(creatingType);
                creatingRNA02.setId(strIDcreatingRNA02);
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setRNA(creatingRNA02);
                property02.setType(creatingType);
                creatingType = "GENE";
                Gene creatingGene03 = new Gene();
                creatingGene03.setName(strNamecreatingSpecies03);
                creatingGene03.setType(creatingType);
                creatingGene03.setId(strIDcreatingGene03);
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dPOTEIN03TargetPoint_x, dPOTEIN03TargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setGene(creatingGene03);
                property03.setType(creatingType);
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                ReactionLink rlTRIGGER = (ReactionLink)GMouseInterpreter.this.factory.createObject("TRIGGER");
                rlTRIGGER.setParentReaction(creatingReaction);
                rlTRIGGER.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiTRIGGERsrc);
                rlTRIGGER.addDestination((GLinkTarget)rlSTATE_TRANSITION, glpiTRIGGERdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add(rlSTATE_TRANSITION);
                vGFrameSet.add(rlTRIGGER);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    private class GMacroCreater13 {
        double dMacroWidth = 300.0;
        double dMacroHeight = 150.0;
        String strNamePrefix = "s";
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater13(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dPOTEIN01TargetPoint_x = creatingPos.getX() + 0.0;
            double dPOTEIN01TargetPoint_y = creatingPos.getY() + 5.0;
            double dPOTEIN02TargetPoint_x = creatingPos.getX() + 159.0;
            double dPOTEIN02TargetPoint_y = creatingPos.getY() + 0.0;
            double dPOTEIN03TargetPoint_x = creatingPos.getX() + 51.0;
            double dPOTEIN03TargetPoint_y = creatingPos.getY() + 75.0;
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiTRIGGERsrc = new GLinkPositionInfo(15, 0.0);
            GLinkPositionInfo glpiTRIGGERdest = new GLinkPositionInfo(3, 0.0);
            if (eventId == 501) {
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein02 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strIDcreatingRNA03 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewRNAId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingSpecies(strNamecreatingSpecies01, "DEGRADED")) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies02)) {
                    strNamecreatingSpecies02 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingRNA(strNamecreatingSpecies03)) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "DEGRADED";
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dPOTEIN01TargetPoint_x, dPOTEIN01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setName(strNamecreatingSpecies01);
                property01.setType(creatingType);
                creatingType = "GENERIC";
                Protein creatingProtein02 = new Protein();
                creatingProtein02.setName(strNamecreatingSpecies02);
                creatingProtein02.setType(creatingType);
                creatingProtein02.setId(strIDcreatingProtein02);
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dPOTEIN02TargetPoint_x, dPOTEIN02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingProtein02);
                property02.setType("PROTEIN");
                creatingType = "RNA";
                RNA creatingRNA03 = new RNA();
                creatingRNA03.setName(strNamecreatingSpecies03);
                creatingRNA03.setType(creatingType);
                creatingRNA03.setId(strIDcreatingRNA03);
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dPOTEIN03TargetPoint_x, dPOTEIN03TargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setRNA(creatingRNA03);
                property03.setType(creatingType);
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction = new Reaction();
                ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITIONsrc);
                rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITIONdest);
                ReactionLink rlTRIGGER = (ReactionLink)GMouseInterpreter.this.factory.createObject("TRIGGER");
                rlTRIGGER.setParentReaction(creatingReaction);
                rlTRIGGER.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiTRIGGERsrc);
                rlTRIGGER.addDestination((GLinkTarget)rlSTATE_TRANSITION, glpiTRIGGERdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add(rlSTATE_TRANSITION);
                vGFrameSet.add(rlTRIGGER);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    private class GMacroCreater14 {
        double dMacroWidth = 260.0;
        double dMacroHeight = 180.0;
        String strNamePrefix = "s";
        double offset = 10.0;
        private GFramed creatingGFramed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater14(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            Point2D creatingPos = GMouseInterpreter.this.adjustmentMacroPosition(editSize, this.x, this.y, this.dMacroWidth, this.dMacroHeight);
            double dIonChannel01TargetPoint_x = creatingPos.getX() + 0.0;
            double dIonChannel01TargetPoint_y = creatingPos.getY() + 60.0;
            double dIonChannel02TargetPoint_x = creatingPos.getX() + 160.0;
            double dIonChannel02TargetPoint_y = creatingPos.getY() + 60.0;
            double dIon03TargetPoint_x = creatingPos.getX() + 200.0;
            double dIon03TargetPoint_y = creatingPos.getY() + 0.0;
            double dIon04TargetPoint_x = creatingPos.getX() + 200.0;
            double dIon04TargetPoint_y = creatingPos.getY() + 130.0;
            GLinkPositionInfo glpiSTATE_TRANSITION01src = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITION01dest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo glpiTransport02src = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiTransport02dest = new GLinkPositionInfo(0, 0.0);
            GLinkPositionInfo glpiCatalysissrc = new GLinkPositionInfo(8, 0.0);
            GLinkPositionInfo glpiCatalysisdest = new GLinkPositionInfo(7, 0.0);
            if (eventId == 501) {
                this.creatingGFramed = null;
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strIDcreatingProtein02 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingProtein01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingProtein01)) {
                    strNamecreatingProtein01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingSpecies(strNamecreatingSpecies03, "ION")) {
                    strNamecreatingSpecies03 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                String creatingType = "ION_CHANNEL";
                Protein creatingIonChannel01 = new Protein();
                creatingIonChannel01.setName(strNamecreatingProtein01);
                creatingIonChannel01.setType(creatingType);
                creatingIonChannel01.setId(strIDcreatingProtein01);
                GFramed creatingGFramed01 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed01.setFramePosition(dIonChannel01TargetPoint_x, dIonChannel01TargetPoint_y);
                SpeciesSymbol briefSymbol01 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed01.setFrameSize(briefSymbol01.defaultSize().width, briefSymbol01.defaultSize().height);
                MonoSpeciesShape mono01 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                MonoSpeciesProperty property01 = (MonoSpeciesProperty)mono01.getProperty();
                property01.setProtein(creatingIonChannel01);
                property01.setType("PROTEIN");
                GFramed creatingGFramed02 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed02.setFramePosition(dIonChannel02TargetPoint_x, dIonChannel02TargetPoint_y);
                SpeciesSymbol briefSymbol02 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed02.setFrameSize(briefSymbol02.defaultSize().width, briefSymbol02.defaultSize().height);
                SpeciesAlias alias = (SpeciesAlias)creatingGFramed02;
                alias.setActive(true);
                MonoSpeciesShape mono02 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                MonoSpeciesProperty property02 = (MonoSpeciesProperty)mono02.getProperty();
                property02.setProtein(creatingIonChannel01);
                property02.setType("PROTEIN");
                creatingType = "ION";
                GFramed creatingGFramed03 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed03.setFramePosition(dIon03TargetPoint_x, dIon03TargetPoint_y);
                SpeciesSymbol briefSymbol03 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed03.setFrameSize(briefSymbol03.defaultSize().width, briefSymbol03.defaultSize().height);
                MonoSpeciesShape mono03 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                MonoSpeciesProperty property03 = (MonoSpeciesProperty)mono03.getProperty();
                property03.setName(strNamecreatingSpecies03);
                property03.setType(creatingType);
                GFramed creatingGFramed04 = (GFramed)GMouseInterpreter.this.factory.createObject(creatingType);
                creatingGFramed04.setFramePosition(dIon04TargetPoint_x, dIon04TargetPoint_y);
                SpeciesSymbol briefSymbol04 = (SpeciesSymbol)((Object)SBFactory.createSymbol(creatingType));
                creatingGFramed04.setFrameSize(briefSymbol04.defaultSize().width, briefSymbol04.defaultSize().height);
                MonoSpeciesShape mono04 = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                MonoSpeciesProperty property04 = (MonoSpeciesProperty)mono04.getProperty();
                property04.setName(strNamecreatingSpecies03);
                property04.setType(creatingType);
                MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed01).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed02).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed03).getGFramedShape();
                monoshape.resetShape();
                monoshape = (MonoSpeciesShape)((SpeciesAlias)creatingGFramed04).getGFramedShape();
                monoshape.resetShape();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                Reaction creatingReaction01 = new Reaction();
                ReactionLink rlSTATE_TRANSITION01 = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                rlSTATE_TRANSITION01.setParentReaction(creatingReaction01);
                rlSTATE_TRANSITION01.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed01), glpiSTATE_TRANSITION01src);
                rlSTATE_TRANSITION01.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiSTATE_TRANSITION01dest);
                GLinkedLine.setDefaultCreasePointNumber(2);
                Reaction creatingReaction02 = new Reaction();
                ReactionLink rlTRANSPORT02 = (ReactionLink)GMouseInterpreter.this.factory.createObject("TRANSPORT");
                rlTRANSPORT02.setParentReaction(creatingReaction02);
                rlTRANSPORT02.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed03), glpiTransport02src);
                rlTRANSPORT02.addDestination((GLinkTarget)((SpeciesAlias)creatingGFramed04), glpiTransport02dest);
                GLinkedLine.setDefaultCreasePointNumber(0);
                ReactionLink rlCatalysis = (ReactionLink)GMouseInterpreter.this.factory.createObject("CATALYSIS");
                rlCatalysis.setParentReaction(creatingReaction02);
                rlCatalysis.addSource((GLinkTarget)((SpeciesAlias)creatingGFramed02), glpiCatalysissrc);
                rlCatalysis.addDestination((GLinkTarget)rlTRANSPORT02, glpiCatalysisdest);
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                vGFrameSet.add((SpeciesAlias)creatingGFramed01);
                vGFrameSet.add((SpeciesAlias)creatingGFramed02);
                vGFrameSet.add((SpeciesAlias)creatingGFramed03);
                vGFrameSet.add((SpeciesAlias)creatingGFramed04);
                vGFrameSet.add(rlSTATE_TRANSITION01);
                vGFrameSet.add(rlTRANSPORT02);
                vGFrameSet.add(rlCatalysis);
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                try {
                    Transport st = (Transport)rlTRANSPORT02.getGLinkedShape();
                    GLinkedLineIndex index = new GLinkedLineIndex();
                    index.line = 0;
                    GCreasePoint newPoint = st.createNewCreasePoint(st.getEditPoints()[0].getPosition().x, dIonChannel01TargetPoint_y - this.offset, index);
                    st.getEditPoints()[0].setPosition((Point2D.Double)newPoint.getPosition().clone());
                    st.getEditPoints()[0].setLocalPosition((Point2D.Double)newPoint.getLocalPosition().clone());
                    index.line = 1;
                    newPoint = st.createNewCreasePoint(st.getEditPoints()[1].getPosition().x, dIonChannel01TargetPoint_y + (double)briefSymbol02.defaultSize().height, index);
                    st.getEditPoints()[1].setPosition((Point2D.Double)newPoint.getPosition().clone());
                    st.getEditPoints()[1].setLocalPosition((Point2D.Double)newPoint.getLocalPosition().clone());
                    rlTRANSPORT02.update();
                    rlCatalysis.update();
                    Rectangle2D.Double rec = new Rectangle2D.Double(this.x, this.y, this.dMacroWidth, this.dMacroHeight);
                    mWin.getCurrentModel().getSBModel().getGStructure().callbyuserRepaint(rec);
                }
                catch (Exception st) {
                    // empty catch block
                }
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed01));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed02));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed03));
                GMouseInterpreter.this.setMacroElementContainer((GElement)((Object)creatingGFramed04));
                Vector<GFramed> currentInners = new Vector<GFramed>();
                currentInners.add(creatingGFramed01);
                currentInners.add(creatingGFramed02);
                currentInners.add(creatingGFramed03);
                currentInners.add(creatingGFramed04);
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502 && this.creatingGFramed != null) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGFramed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGFramed != null) {
                this.creatingGFramed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    private class GMacroCreater15 {
        String strNamePrefix = "s";
        double Distance = 150.0;
        MainWindow mWin = MainWindow.getLastInstance();
        private GLinkTarget onMouseTarget = null;
        private GLinkPositionInfo onMouseTargetLinkPosition = null;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GMacroCreater15(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            ReactionTargetDialog reactionTarget = this.mWin.getReactionTargetDialog();
            String strSelectedSpeciesType = reactionTarget.getSelectedSpeciesType().toUpperCase();
            String strSelectedReactionCount = reactionTarget.getSelectedReactionCount();
            GLinkPositionInfo glpiSTATE_TRANSITIONsrc = new GLinkPositionInfo(4, 0.0);
            GLinkPositionInfo glpiSTATE_TRANSITIONdest = new GLinkPositionInfo(12, 0.0);
            GLinkPositionInfo lpiOld = null;
            GElement geOld = GMouseInterpreter.this.structure.getElement(pointX, pointY);
            MonoSpeciesShape monoshapeSelected = null;
            if (geOld != null && geOld instanceof SpeciesAlias) {
                try {
                    lpiOld = ((GLinkTarget)((Object)geOld)).getPointedLinkPosition(pointX, pointY);
                    monoshapeSelected = (MonoSpeciesShape)((SpeciesAlias)geOld).getGFramedShape();
                    if (this.onMouseTarget != geOld) {
                        if (this.onMouseTarget != null) {
                            GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                        }
                        this.onMouseTarget = (GLinkTarget)((Object)geOld);
                        this.onMouseTargetLinkPosition = lpiOld;
                    } else if (this.onMouseTargetLinkPosition != null && !this.onMouseTargetLinkPosition.equals(lpiOld)) {
                        this.onMouseTargetLinkPosition = lpiOld;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (monoshapeSelected == null) {
                if (this.onMouseTarget != null) {
                    GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
                }
            } else {
                GMouseInterpreter.this.structure.showLinkAnchors(this.onMouseTarget, lpiOld, false);
            }
            if (eventId == 501) {
                boolean fromPoint = false;
                if (lpiOld != null) {
                    Point2D.Double co = monoshapeSelected.getCoordinatesOfLinkPosition(lpiOld);
                    this.x = co.getX();
                    this.y = co.getY();
                    fromPoint = true;
                }
                MainWindow mWin = MainWindow.getLastInstance();
                macroCreatedObjCounter = GMouseInterpreter.this.iniMacroCreatedObjCounter();
                String strIDcreatingProtein01 = mWin.getCurrentModel().getSBModel().getSbframe().getSBModel().createNewProteinId();
                String strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                while (GMouseInterpreter.this.chkHavingCorrespondingProtein(strNamecreatingSpecies01)) {
                    strNamecreatingSpecies01 = String.valueOf(this.strNamePrefix) + macroCreatedObjCounter++;
                }
                int reactioncount = 0;
                try {
                    reactioncount = Integer.parseInt(strSelectedReactionCount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SpeciesSymbol tem = (SpeciesSymbol)((Object)SBFactory.createSymbol(strSelectedSpeciesType));
                double width = tem.defaultSize().getWidth();
                double hight = tem.defaultSize().getHeight();
                if (lpiOld != null) {
                    this.y -= tem.defaultSize().getHeight() / 2.0;
                }
                if (!fromPoint && (this.x < 0.0 || this.y < 0.0 || this.x > editSize.getWidth() || this.y > editSize.getHeight())) {
                    this.cancelSelectedTarget();
                    mWin.resetComboBox();
                    JOptionPane.showMessageDialog(mWin, "Please click in the Drawing Area. ", "Error", 0);
                    return;
                }
                if (fromPoint) {
                    if (this.y < 0.0 || this.y + hight > editSize.getHeight()) {
                        this.cancelSelectedTarget();
                        mWin.resetComboBox();
                        JOptionPane.showMessageDialog(mWin, "The height is not enough to create species. ", "Error", 0);
                        return;
                    }
                } else if (this.y + hight > editSize.getHeight()) {
                    this.cancelSelectedTarget();
                    mWin.resetComboBox();
                    JOptionPane.showMessageDialog(mWin, "The height is not enough to create species. ", "Error", 0);
                    return;
                }
                if (fromPoint) {
                    if (width + this.Distance * (double)reactioncount + this.x > editSize.getWidth()) {
                        this.cancelSelectedTarget();
                        mWin.resetComboBox();
                        JOptionPane.showMessageDialog(mWin, "The length is not enough to create species. ", "Error", 0);
                        return;
                    }
                } else if (width + this.Distance * (double)reactioncount + this.x > editSize.getWidth()) {
                    this.cancelSelectedTarget();
                    mWin.resetComboBox();
                    JOptionPane.showMessageDialog(mWin, "The length is not enough to create species. ", "Error", 0);
                    return;
                }
                double dPOTEIN01TargetPoint_x = this.x;
                double dPOTEIN01TargetPoint_y = this.y;
                Vector<GFramed> frames = new Vector<GFramed>();
                int i = 0;
                while (i < reactioncount + 1) {
                    if (i != 0 || !fromPoint) {
                        GFramed gframe = GMouseInterpreter.this.creatSpecies(strSelectedSpeciesType, strNamecreatingSpecies01, strIDcreatingProtein01, dPOTEIN01TargetPoint_x + this.Distance * (double)i, dPOTEIN01TargetPoint_y);
                        frames.add(gframe);
                    }
                    ++i;
                }
                if (frames.size() > 0) {
                    MonoSpeciesShape monoshape = (MonoSpeciesShape)((SpeciesAlias)frames.get(0)).getGFramedShape();
                    monoshape.resetShape();
                    int ui = 1;
                    while (ui < frames.size()) {
                        monoshape = (MonoSpeciesShape)((SpeciesAlias)frames.get(ui)).getGFramedShape();
                        monoshape.resetShape();
                        ++ui;
                    }
                }
                Vector<ReactionLink> reactions = new Vector<ReactionLink>();
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                int cntFrame = 0;
                int tu = 0;
                while (tu < reactioncount) {
                    Reaction creatingReaction = new Reaction();
                    ReactionLink rlSTATE_TRANSITION = (ReactionLink)GMouseInterpreter.this.factory.createObject("STATE_TRANSITION");
                    rlSTATE_TRANSITION.setParentReaction(creatingReaction);
                    if (tu == 0 && fromPoint) {
                        rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)geOld), lpiOld);
                    } else {
                        rlSTATE_TRANSITION.addSource((GLinkTarget)((SpeciesAlias)frames.get(cntFrame++)), glpiSTATE_TRANSITIONsrc);
                    }
                    rlSTATE_TRANSITION.addDestination((GLinkTarget)((SpeciesAlias)frames.get(cntFrame++)), glpiSTATE_TRANSITIONdest);
                    reactions.add(rlSTATE_TRANSITION);
                    ++tu;
                }
                Vector<GLinkTarget> vGFrameSet = new Vector<GLinkTarget>();
                int cnt = 0;
                while (cnt < frames.size()) {
                    vGFrameSet.add((SpeciesAlias)frames.get(cnt));
                    ++cnt;
                }
                int cut = 0;
                while (cut < reactions.size()) {
                    vGFrameSet.add((ReactionLink)reactions.get(cut));
                    ++cut;
                }
                mWin.getCurrentModel().getSBModel().getGStructure().add(vGFrameSet);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
                int cnt1 = 0;
                while (cnt1 < frames.size()) {
                    GMouseInterpreter.this.setMacroElementContainer((GElement)frames.get(cnt1));
                    ++cnt1;
                }
                Vector currentInners = new Vector();
                int cnt2 = 0;
                while (cnt2 < frames.size()) {
                    currentInners.add(frames.get(cnt2));
                    ++cnt2;
                }
                mWin.getCurrentModel().getSBModel().ResetCompartmentOrOutsideOf(currentInners);
                mWin.getCurrentModel().getSBModel().allPanelUpdate();
                if (mWin.getCurrentModel().getSBModel().getGStructure() != null) {
                    try {
                        mWin.getCurrentModel().getSBModel().getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        mWin.getCurrentModel().getSBModel().getSbframe().repaintLogicalArea(mWin.getCurrentModel().getSBModel().getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {}
                }
            } else if (eventId == 502) {
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.cancelSelectedTarget();
            }
        }

        private void cancelSelectedTarget() {
            if (this.onMouseTarget != null) {
                GMouseInterpreter.this.structure.hideLinkAnchors(this.onMouseTarget);
            }
            this.onMouseTarget = null;
        }

        public void interrupt() {
        }
    }

    private class GPointedCreater {
        private GPointed creatingGPointed;
        private double x;
        private double y;
        private GMouseInterpreter interpreter;

        public GPointedCreater(GMouseInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        private void interpret(double pointX, double pointY, int eventId) {
            if (GMouseInterpreter.this.isGridSnapON) {
                this.x = this.interpreter.snapX(pointX);
                this.y = this.interpreter.snapY(pointY);
            } else {
                this.x = pointX;
                this.y = pointY;
            }
            Rectangle2D editSize = this.interpreter.getEditSize();
            if (eventId == 501) {
                if (!editSize.contains(this.x, this.y)) {
                    return;
                }
                GMouseInterpreter.this.structure.deselectAll();
                this.creatingGPointed = (GPointed)GMouseInterpreter.this.factory.createObject(GMouseInterpreter.this.currentType);
                if (this.creatingGPointed != null) {
                    this.creatingGPointed.setPoint(this.x, this.y);
                    this.creatingGPointed.setMaxArea(GMouseInterpreter.this.structure.getMaxDrawSize());
                    ((GElement)((Object)this.creatingGPointed)).setHighlighted(true);
                    GMouseInterpreter.this.structure.setTemporalGElement((GElement)((Object)this.creatingGPointed));
                    Rectangle2D redrawArea = GMouseInterpreter.this.structure.resizeElement((GElement)((Object)this.creatingGPointed), this.x, this.y, 0.0, 0.0);
                    GMouseInterpreter.this.structure.notifyRepaint(redrawArea);
                }
            } else if (eventId == 506 && this.creatingGPointed != null) {
                Rectangle2D redrawArea = GMouseInterpreter.this.structure.resizeElement((GElement)((Object)this.creatingGPointed), this.x, this.y, 0.0, 0.0);
                GMouseInterpreter.this.structure.notifyRepaint(redrawArea);
            } else if (eventId == 502 && this.creatingGPointed != null) {
                ((GElement)((Object)this.creatingGPointed)).setHighlighted(false);
                GMouseInterpreter.this.structure.notifyChange((GElement)((Object)this.creatingGPointed), 0, null);
                GMouseInterpreter.this.structure.setTemporalGElement(null);
                this.creatingGPointed = null;
            }
        }

        public void interrupt() {
            if (this.creatingGPointed != null) {
                this.creatingGPointed = null;
                GMouseInterpreter.this.structure.setTemporalGElement(null);
            }
        }
    }

    private class TargetInfo {
        private GLinkTarget target;
        private double x;
        private double y;
        private GLinkPositionInfo lpi;

        public GLinkPositionInfo getLpi() {
            return this.lpi;
        }

        public GLinkTarget getTarget() {
            return this.target;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public TargetInfo(GLinkTarget target, double x, double y, GLinkPositionInfo lpi) {
            this.target = target;
            this.x = x;
            this.y = y;
            this.lpi = lpi;
        }
    }
}

