/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GLinkPoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.symbol.species.Drug;
import jp.sbi.celldesigner.symbol.species.IonChannel;

public class GLinkedStraightLine
extends GLinkedLine {
    Line2D.Double line = null;
    Line2D.Double whiteline = null;
    Rectangle2D.Double bounds = null;
    protected Color color = new Color(0, 0, 0);
    protected double lineWidth = 1.0;
    public static final int UNDEFINED_DIRECTION = 0;
    public static final int VERTICAL_DIRECTION = 1;
    public static final int HORIZONTAL_DIRECTION = 2;
    private int direction = 0;
    private boolean isLayerLine;

    public void setIsLayerLine(boolean isLayerLine) {
        this.isLayerLine = isLayerLine;
    }

    public void setStartAndEndPoint(Point2D.Double ps, Point2D.Double pe) {
        this.start = ps;
        this.end = pe;
        this.updateLineWithStartAndEndPoint(null);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    private static void calcStartAndEndWithLinkPositionInfos(Point2D.Double[] points, GLinkTarget startTarget, GLinkPositionInfo startLinkPositionInfo, GLinkTarget endTarget, GLinkPositionInfo endLinkPositionInfo) {
        if (startLinkPositionInfo != null && startLinkPositionInfo.getPosition() != -1) {
            points[0] = startTarget.getCoordinatesOfLinkPosition(startLinkPositionInfo);
        }
        if (endLinkPositionInfo != null && endLinkPositionInfo.getPosition() != -1) {
            points[1] = endTarget.getCoordinatesOfLinkPosition(endLinkPositionInfo);
        }
        if (points != null && points[0] != null && points[1] != null && !(endTarget instanceof GLinkPoint) && !(startTarget instanceof GLinkPoint)) {
            Point2D.Double delta = GUtil.createDiff(points[0].x, points[0].y, points[1].x, points[1].y);
            double dx = delta.x;
            double dy = delta.y;
            points[2] = new Point2D.Double(dx, dy);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Point2D.Double[] calcStartAndEndWithoutLinkPositionInfos(GLinkTarget startTarget, GLinkTarget endTarget, double offsetX, double offsetY) {
        block53: {
            block57: {
                block56: {
                    block52: {
                        block55: {
                            block54: {
                                points = new Point2D.Double[3];
                                points[0] = null;
                                points[1] = null;
                                if (startTarget == null || endTarget == null) {
                                    return points;
                                }
                                startTargetPoint = startTarget.targetPoint();
                                endTargetPoint = endTarget.targetPoint();
                                if (startTargetPoint == null) {
                                    return points;
                                }
                                if (endTargetPoint == null) {
                                    return points;
                                }
                                startPoint = new Point2D.Double(startTargetPoint.x, startTargetPoint.y);
                                endPoint = new Point2D.Double(endTargetPoint.x, endTargetPoint.y);
                                diff = GUtil.createDiff(0.0, 0.0, offsetX, offsetY);
                                if (diff.x != 0.0 || diff.y != 0.0) {
                                    norm = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
                                    if (startTarget instanceof GFramed) {
                                        startRect = ((GElement)startTarget).getRepaintBounds();
                                        if (startRect != null) {
                                            moveX = 0.0;
                                            moveY = 0.0;
                                            step = 0.0;
                                            while (startRect.contains(startPoint.x, startPoint.y) && step <= norm) {
                                                startPoint.x += diff.x;
                                                startPoint.y += diff.y;
                                                step = Math.sqrt((moveX += diff.x) * moveX + (moveY += diff.y) * moveY);
                                            }
                                            if (step > norm) {
                                                startPoint.x -= diff.x;
                                                startPoint.y -= diff.y;
                                            }
                                            while (!startTarget.inShapeAsTarget(startPoint.x, startPoint.y)) {
                                                startPoint.x -= diff.x;
                                                startPoint.y -= diff.y;
                                            }
                                        }
                                    } else if (startTarget instanceof GEditPoint) {
                                        startPoint.x += offsetX;
                                        startPoint.y += offsetY;
                                    }
                                    if (endTarget instanceof GFramed) {
                                        endRect = ((GElement)endTarget).getRepaintBounds();
                                        if (endRect != null) {
                                            moveX = 0.0;
                                            moveY = 0.0;
                                            step = 0.0;
                                            while (endRect.contains(endPoint.x, endPoint.y) && step <= norm) {
                                                endPoint.x += diff.x;
                                                endPoint.y += diff.y;
                                                step = Math.sqrt((moveX += diff.x) * moveX + (moveY += diff.y) * moveY);
                                            }
                                            if (step > norm) {
                                                endPoint.x -= diff.x;
                                                endPoint.y -= diff.y;
                                            }
                                            while (!endTarget.inShapeAsTarget(endPoint.x, endPoint.y)) {
                                                endPoint.x -= diff.x;
                                                endPoint.y -= diff.y;
                                            }
                                        }
                                    } else if (endTarget instanceof GEditPoint) {
                                        endPoint.x += offsetX;
                                        endPoint.y += offsetY;
                                    }
                                }
                                points[0] = startPoint;
                                points[1] = endPoint;
                                if (startPoint.x == endPoint.x && startPoint.y == endPoint.y) {
                                    points[2] = new Point2D.Double(0.0, 0.0);
                                    return points;
                                }
                                delta = GUtil.createDiff(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
                                dx = delta.x;
                                dy = delta.y;
                                points[2] = new Point2D.Double(dx, dy);
                                if (dx == 0.0 && dy == 0.0) {
                                    return points;
                                }
                                if (!(startTarget instanceof GFramed)) ** GOTO lbl138
                                startRect = ((GElement)startTarget).getRepaintBounds();
                                isIonChannelActive = false;
                                ionChannelActiveBounds = new Rectangle2D.Double();
                                isDrug = false;
                                areaDurg = new Area();
                                if (startTarget instanceof SpeciesAlias) {
                                    alias = (SpeciesAlias)startTarget;
                                    symbol = alias.getSpeciesSymbol();
                                    if (symbol instanceof IonChannel) {
                                        mono = (MonoSpeciesShape)alias.getGFramedShape();
                                        if (mono.isActive()) {
                                            isIonChannelActive = true;
                                            ionChannelActiveBounds = mono.getFrameBounds();
                                        }
                                    } else if (symbol instanceof Drug) {
                                        isDrug = true;
                                        drug = (Drug)symbol;
                                        areaDurg = drug.getOutterShape();
                                    }
                                }
                                if (startRect == null || !startRect.contains(startPoint.x, startPoint.y)) break block52;
                                max = (int)Math.max(startRect.width, startRect.height);
                                i = 0;
                                if (!isDrug) ** GOTO lbl105
                                while (areaDurg.contains(startPoint)) {
                                    startPoint.x += dx;
                                    startPoint.y += dy;
                                    if (++i <= max) continue;
                                    return points;
                                }
                                break block54;
lbl-1000:
                                // 1 sources

                                {
                                    startPoint.x += dx;
                                    startPoint.y += dy;
                                    if (++i <= max) continue;
                                    return points;
lbl105:
                                    // 2 sources

                                    ** while (startRect.contains((double)startPoint.x, (double)startPoint.y))
                                }
                            }
                            i = 0;
                            if (!isIonChannelActive) break block55;
                            while (!ionChannelActiveBounds.contains(startPoint.x, startPoint.y)) {
                                startPoint.x -= dx;
                                startPoint.y -= dy;
                                if (++i > max) {
                                    return points;
                                }
                                if (startRect.contains(startPoint.x, startPoint.y)) {
                                    continue;
                                }
                                break block52;
                            }
                            break block52;
                        }
                        if (!isDrug) ** GOTO lbl134
                        while (!areaDurg.getBounds2D().contains(startPoint)) {
                            startPoint.x -= dx;
                            startPoint.y -= dy;
                            if (++i > max) {
                                return points;
                            }
                            if (startRect.contains(startPoint)) {
                                continue;
                            }
                            break block52;
                        }
                        break block52;
lbl-1000:
                        // 1 sources

                        {
                            startPoint.x -= dx;
                            startPoint.y -= dy;
                            if (++i > max) {
                                return points;
                            }
                            if (!startRect.contains(startPoint.x, startPoint.y)) break block52;
lbl134:
                            // 2 sources

                            ** while (!startTarget.inShapeAsTarget((double)startPoint.x, (double)startPoint.y))
                        }
lbl135:
                        // 1 sources

                        break block52;
lbl-1000:
                        // 1 sources

                        {
                            startPoint.x += dx;
                            startPoint.y += dy;
lbl138:
                            // 2 sources

                            ** while (startTarget.inShapeAsTarget((double)startPoint.x, (double)startPoint.y))
                        }
                    }
                    if (!(endTarget instanceof GFramed)) ** GOTO lbl206
                    endRect = ((GElement)endTarget).getRepaintBounds();
                    if (endRect == null || !endRect.contains(endPoint.x, endPoint.y)) break block53;
                    isIonChannelActive = false;
                    ionChannelActiveBounds = new Rectangle2D.Double();
                    isDrug = false;
                    areaDurg = new Area();
                    if (endTarget instanceof SpeciesAlias) {
                        alias = (SpeciesAlias)endTarget;
                        symbol = alias.getSpeciesSymbol();
                        if (symbol instanceof IonChannel) {
                            mono = (MonoSpeciesShape)alias.getGFramedShape();
                            if (mono.isActive()) {
                                isIonChannelActive = true;
                                ionChannelActiveBounds = mono.getFrameBounds();
                            }
                        } else if (symbol instanceof Drug) {
                            isDrug = true;
                            drug = (Drug)symbol;
                            areaDurg = drug.getOutterShape();
                        }
                    }
                    max = (int)Math.max(endRect.width, endRect.height);
                    i = 0;
                    if (!isDrug) ** GOTO lbl173
                    while (areaDurg.contains(endPoint)) {
                        endPoint.x -= dx;
                        endPoint.y -= dy;
                        if (++i <= max) continue;
                        return points;
                    }
                    break block56;
lbl-1000:
                    // 1 sources

                    {
                        endPoint.x -= dx;
                        endPoint.y -= dy;
                        if (++i <= max) continue;
                        return points;
lbl173:
                        // 2 sources

                        ** while (endRect.contains((double)endPoint.x, (double)endPoint.y))
                    }
                }
                i = 0;
                if (!isIonChannelActive) break block57;
                while (!ionChannelActiveBounds.contains(endPoint.x, endPoint.y)) {
                    endPoint.x += dx;
                    endPoint.y += dy;
                    if (++i > max) {
                        return points;
                    }
                    if (endRect.contains(endPoint.x, endPoint.y)) {
                        continue;
                    }
                    break block53;
                }
                break block53;
            }
            if (!isDrug) ** GOTO lbl202
            while (!areaDurg.contains(endPoint.x, endPoint.y)) {
                endPoint.x += dx;
                endPoint.y += dy;
                if (++i > max) {
                    return points;
                }
                if (areaDurg.contains(endPoint.x, endPoint.y)) {
                    continue;
                }
                break block53;
            }
            break block53;
lbl-1000:
            // 1 sources

            {
                endPoint.x += dx;
                endPoint.y += dy;
                if (++i > max) {
                    return points;
                }
                if (!endRect.contains(endPoint.x, endPoint.y)) break block53;
lbl202:
                // 2 sources

                ** while (!endTarget.inShapeAsTarget((double)endPoint.x, (double)endPoint.y))
            }
lbl203:
            // 1 sources

            break block53;
lbl-1000:
            // 1 sources

            {
                endPoint.x -= dx;
                endPoint.y -= dy;
lbl206:
                // 2 sources

                ** while (endTarget.inShapeAsTarget((double)endPoint.x, (double)endPoint.y))
            }
        }
        points[0] = startTargetPoint.distance(startPoint) <= startTargetPoint.distance(endTargetPoint) ? startPoint : startTargetPoint;
        points[1] = endTargetPoint.distance(endPoint) <= endTargetPoint.distance(startTargetPoint) ? endPoint : endTargetPoint;
        return points;
    }

    public static Point2D.Double[] calcStartAndEnd(GLinkTarget startTarget, GLinkPositionInfo startLinkPositionInfo, GLinkTarget endTarget, GLinkPositionInfo endLinkPositionInfo, double offsetX, double offsetY) {
        Point2D.Double[] points = GLinkedStraightLine.calcStartAndEndWithoutLinkPositionInfos(startTarget, endTarget, offsetX, offsetY);
        GLinkedStraightLine.calcStartAndEndWithLinkPositionInfos(points, startTarget, startLinkPositionInfo, endTarget, endLinkPositionInfo);
        return points;
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedStraightLine copy = null;
        try {
            copy = (GLinkedStraightLine)this.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        copy.setIsLayerLine(this.isLayerLine);
        return copy;
    }

    @Override
    public void drawBaseWhiteLine(Graphics2D graphics2d) {
        if (this.whiteline != null) {
            graphics2d.draw(this.whiteline);
        }
    }

    @Override
    public void drawLine(Graphics2D graphics2d) {
        if (this.line != null) {
            Line2D.Double modifiedLine = new Line2D.Double();
            modifiedLine.setLine(this.line);
            int n = this.lineModifications.size();
            int i = 0;
            while (i < n) {
                GLinkedLineModificationShape ms = (GLinkedLineModificationShape)this.lineModifications.elementAt(i);
                if (ms.isVisible()) {
                    modifiedLine = ms.modifyLine(modifiedLine);
                }
                ++i;
            }
            graphics2d.draw(modifiedLine);
        }
    }

    @Override
    public Rectangle2D.Double getLineBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public boolean inLine(double x, double y) {
        if (this.line == null) {
            return false;
        }
        double extention = 4.0;
        Rectangle2D.Double area = new Rectangle2D.Double(x - 4.0, y - 4.0, 8.0, 8.0);
        return this.line.intersects(area);
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        double radius = 0.0;
        Point2D.Double target = this.targetPoint();
        if (target == null) {
            return false;
        }
        return (x - target.x) * (x - target.x) + (y - target.y) * (y - target.y) <= 0.0;
    }

    @Override
    public Point2D.Double targetPoint() {
        if (this.start != null && this.end != null) {
            return new Point2D.Double((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
        }
        return null;
    }

    private Rectangle2D.Double updateLineWithStartAndEndPoint(Point2D.Double offset) {
        Rectangle2D.Double oldBounds = this.bounds;
        if (this.line == null) {
            this.line = new Line2D.Double();
        }
        if (this.whiteline == null) {
            this.whiteline = new Line2D.Double();
        }
        Point2D.Double lineStart = (Point2D.Double)this.start.clone();
        Point2D.Double lineEnd = (Point2D.Double)this.end.clone();
        Point2D.Double whiteStart = (Point2D.Double)this.start.clone();
        Point2D.Double whiteEnd = (Point2D.Double)this.end.clone();
        double whitelineoffset = Math.ceil((0.5 * this.lineWidth + 2.0) * Math.sqrt(10.0));
        if (offset != null) {
            double offsetabsw;
            double offsetabsl;
            double offx = offset.x;
            double offy = offset.y;
            double offabsinv = 1.0 / Math.sqrt(offx * offx + offy * offy);
            if (this.startTarget instanceof GAtom) {
                offsetabsl = this.lineWidth;
                offsetabsl *= 0.5 * offabsinv;
                offsetabsl = Math.ceil(offsetabsl);
                lineStart.x += offx * offsetabsl;
                lineStart.y += offy * offsetabsl;
                offsetabsw = this.lineWidth + ((GAtom)this.startTarget).getGFramedShape().getLineWidth();
                offsetabsw *= 0.5 * offabsinv;
                offsetabsw = Math.ceil(offsetabsw) + whitelineoffset;
                whiteStart.x += offx * offsetabsw;
                whiteStart.y += offy * offsetabsw;
            }
            if (this.endTarget instanceof GAtom) {
                offsetabsl = this.lineWidth;
                offsetabsl *= 0.5 * offabsinv;
                offsetabsl = Math.ceil(offsetabsl);
                lineEnd.x -= offx * offsetabsl;
                lineEnd.y -= offy * offsetabsl;
                offsetabsw = this.lineWidth + ((GAtom)this.endTarget).getGFramedShape().getLineWidth();
                offsetabsw *= 0.5 * offabsinv;
                offsetabsw = Math.ceil(offsetabsw) + whitelineoffset;
                whiteEnd.x -= offx * offsetabsw;
                whiteEnd.y -= offy * offsetabsw;
            }
        }
        this.line.setLine(lineStart, lineEnd);
        if (!(this.endTarget instanceof GLinkPoint)) {
            this.whiteline.setLine(whiteStart, whiteEnd);
        }
        double extend = Math.ceil(0.5 * this.lineWidth);
        double newStartX = Math.min(this.start.x, this.end.x) - extend;
        double newStartY = Math.min(this.start.y, this.end.y) - extend;
        double newEndX = Math.max(this.start.x, this.end.x) + extend;
        double newEndY = Math.max(this.start.y, this.end.y) + extend;
        this.bounds = new Rectangle2D.Double(newStartX, newStartY, newEndX - newStartX, newEndY - newStartY);
        if (oldBounds == null) {
            return this.bounds;
        }
        if (oldBounds.equals(this.bounds)) {
            return null;
        }
        return GUtil.union(oldBounds, this.bounds);
    }

    @Override
    public Rectangle2D.Double updateLine() {
        Rectangle2D.Double oldBounds = this.bounds;
        if (this.isLayerLine) {
            Point2D.Double[] pointArray = new Point2D.Double[3];
            Point2D.Double delta = GUtil.createDiff(this.start.x, this.start.y, this.end.x, this.end.y);
            double dx = delta.x;
            double dy = delta.y;
            pointArray[2] = new Point2D.Double(dx, dy);
            return this.updateLineWithStartAndEndPoint(pointArray[2]);
        }
        Point2D.Double[] pointArray = GLinkedStraightLine.calcStartAndEnd(this.startTarget, this.startLinkPositionInfo, this.endTarget, this.endLinkPositionInfo, this.offsetX, this.offsetY);
        if (pointArray[0] == null || pointArray[1] == null) {
            return oldBounds;
        }
        this.start = pointArray[0];
        this.end = pointArray[1];
        return this.updateLineWithStartAndEndPoint(pointArray[2]);
    }

    @Override
    public int getTargetIndex(GEditPoint ep) {
        throw new UnsupportedOperationException();
    }

    public Point2D.Double getLinkTargetPoint() {
        double x = (this.line.x1 + this.line.x2) * 0.5;
        double y = (this.line.y1 + this.line.y2) * 0.5;
        return new Point2D.Double(x, y);
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        throw new RuntimeException();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    @Override
    public void setupAfterAllTargetsSetted() {
    }

    @Override
    public Point2D.Double getAnchorPointByIndex(int index) {
        return null;
    }
}

