/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import jp.fric.graphics.draw.ElementAndPosition;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedLineIndexPossesive;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLineForComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.GModificationRectangle;
import jp.sbi.celldesigner.symbol.reaction.Truncation;
import jp.sbi.sbml.util.LibSBMLUtil;

public abstract class GLinkedLineComplex3
implements GLinkedShape,
GEditable,
GLinkedLineIndexPossesive,
GLinkConnectSchemeOwner {
    protected GLinkedLine[] lines = new GLinkedLine[3];
    protected GCreasePoint midCreasePoint = null;
    private Rectangle2D.Double bounds = null;
    private AffineTransform localAT = new AffineTransform();
    private AffineTransform inverse = new AffineTransform();
    protected GLinkedCreaseLine line1;
    protected GLinkedCreaseLine line2;
    protected GLinkedCreaseLine line3;
    protected GLinkedLineModificationShape arrowShape13 = new GLinkedLineArrowShape(3);
    protected GLinkedLineModificationShape arrowShape23 = new GLinkedLineArrowShape(3);
    protected GLinkedLineModificationShape arrowShape33 = new GLinkedLineArrowShape(3);
    protected int showLinkAnchorMode = 0;
    protected GLinkPositionInfo linkPositionInfo = null;
    protected int connectPolicy = 0;
    private double lineWidth = 1.0;
    private Color color = new Color(0, 0, 0);
    protected GModificationRectangle rectangShape;
    private static final String NODISPLAY_MARK = "";
    private static final String DIMERFORMATION_MARK = "";
    private static final String DISSOCIATION_MARK = "";
    private static final String TRUNCATION_MARK = "";
    protected int iProcessNodeIndex = 0;
    private int addingObjectFlg = 0;
    private boolean isInSBGNViewer = false;
    public static final double dLengthOfSBGNMidPoint = 20.0;

    public abstract int getTheArmIDwhichProcessNodeIn();

    public void setProcessNodeIndex(int i) {
        this.iProcessNodeIndex = i;
    }

    public int getProcessNodeIndex() {
        return this.iProcessNodeIndex;
    }

    public abstract boolean getChangeRightLeftFLGofProcessNode();

    public void setAddingObjectFlag(int flg) {
        this.addingObjectFlg = flg;
    }

    public int getAddingObjectFlag() {
        return this.addingObjectFlg;
    }

    public GLinkedLineComplex3() {
        this.connectPolicy = GLinkedLine.getDefaultConnectPolicy();
        this.rectangShape = new GModificationRectangle();
        this.rectangShape.setMarkString("");
        this.resetProcessNode(this, 0);
    }

    public void resetProcessNode(Object son, int idx) {
        if (idx < 0) {
            idx = 0;
        }
        if (son instanceof DimerFormation) {
            this.setPositionAndNameOFthisProcessNode("", idx, this.line3);
        } else if (son instanceof Dissociation) {
            this.setPositionAndNameOFthisProcessNode("", idx, this.line1);
        } else if (son instanceof Truncation) {
            this.setPositionAndNameOFthisProcessNode("", idx, this.line1);
        } else {
            this.rectangShape.setMarkString("");
            this.rectangShape.setVisible(false);
        }
        if (this.getProcessNode() != null) {
            this.getProcessNode().setOwnerOfThisProcessNode(son);
        }
    }

    private void setPositionAndNameOFthisProcessNode(String mark, int idx, GLinkedCreaseLine lineX) {
        if (lineX == null) {
            return;
        }
        if (this.line1 == null || this.line2 == null || this.line3 == null) {
            return;
        }
        if (this.line1 != lineX && this.line2 != lineX && this.line3 != lineX) {
            return;
        }
        if (idx < 0 || idx >= lineX.getLineSize()) {
            idx = 0;
        }
        this.rectangShape.setMarkString(mark);
        this.unloadProcessnode();
        lineX.getLine(idx).addModificationShape(this.rectangShape);
        this.setProcessNodeIndex(idx);
        this.rectangShape.updateModification(lineX.getLine(idx).getEndPoint(), lineX.getLine(idx).getStartPoint(), lineX.getLineWidth());
        this.rectangShape.setVisible(true);
    }

    private void unloadProcessnode() {
        int j = 0;
        while (j < this.lines.length) {
            Vector v = this.lines[j].getLineModifications();
            if (v != null && v.size() > 0) {
                Vector tmpVec2 = new Vector();
                int m = 0;
                while (m < v.size()) {
                    if (v.get(m) instanceof GModificationRectangle) {
                        tmpVec2.add(v.get(m));
                    }
                    ++m;
                }
                m = 0;
                while (m < tmpVec2.size()) {
                    v.remove(tmpVec2.get(m));
                    ++m;
                }
            }
            GLinkedStraightLine[] vGsl = ((GLinkedCreaseLine)this.lines[j]).getLines();
            int i = 0;
            while (i < vGsl.length) {
                v = vGsl[i].getLineModifications();
                if (v != null && v.size() > 0) {
                    Vector tmpVec2 = new Vector();
                    int m = 0;
                    while (m < v.size()) {
                        if (v.get(m) instanceof GModificationRectangle) {
                            tmpVec2.add(v.get(m));
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < tmpVec2.size()) {
                        v.remove(tmpVec2.get(m));
                        ++m;
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    private void initLines(GLinkedStraightLine[] a, int n) {
        int i = 0;
        while (i < n) {
            a[i] = new GLinkedStraightLine();
            ++i;
        }
    }

    public void resetCreaseLineNumber(int num0, int num1, int num2) {
        this.init(num0, num1, num2);
    }

    protected void init(int num0, int num1, int num2) {
        GLinkedStraightLine[] lines1 = new GLinkedStraightLine[num0];
        GLinkedStraightLine[] lines2 = new GLinkedStraightLine[num1];
        GLinkedStraightLine[] lines3 = new GLinkedStraightLine[num2];
        this.initLines(lines1, num0);
        this.initLines(lines2, num1);
        this.initLines(lines3, num2);
        int arm = 0;
        this.line1 = this.createLinkedCreaseLine(arm++);
        try {
            this.line1.setLines(lines1);
            this.line1.setDefaultTargetLineIndex(num0 / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.line2 = this.createLinkedCreaseLine(arm++);
        try {
            this.line2.setLines(lines2);
            this.line2.setDefaultTargetLineIndex(num1 / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.line3 = this.createLinkedCreaseLine(arm++);
        try {
            this.line3.setLines(lines3);
            this.line3.setDefaultTargetLineIndex(num2 / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.line1.setcomplex3Parent(this);
        this.line2.setcomplex3Parent(this);
        this.line3.setcomplex3Parent(this);
        this.setLine(this.line1, this.line2, this.line3);
    }

    protected void init() {
        int n = GLinkedLine.getDefaultCreasePointNumber() + 1;
        this.init(n, n, n);
    }

    public abstract GLinkedCreaseLine createLinkedCreaseLine(int var1);

    public abstract GCreasePoint createCreasePoint();

    @Override
    public void activateEditPoints(boolean bool) {
        int i = 0;
        while (i < 3) {
            if (this.lines[i] instanceof GEditable) {
                ((GEditable)((Object)this.lines[i])).activateEditPoints(bool);
            }
            ++i;
        }
        this.midCreasePoint.setActive(bool);
    }

    @Override
    public boolean contains(GEditPoint geditpoint) {
        int i = 0;
        while (i < 3) {
            boolean bool;
            if (this.lines[i] instanceof GEditable && (bool = ((GEditable)((Object)this.lines[i])).contains(geditpoint))) {
                return true;
            }
            ++i;
        }
        return this.midCreasePoint == geditpoint;
    }

    @Override
    public GLinkedShape createCopy() {
        GLinkedLineComplex3 copy = null;
        GLinkedLine copy1 = null;
        GLinkedLine copy2 = null;
        GLinkedLine copy3 = null;
        try {
            copy = (GLinkedLineComplex3)this.getClass().newInstance();
            copy1 = (GLinkedLine)this.lines[0].createCopy();
            copy2 = (GLinkedLine)this.lines[1].createCopy();
            copy3 = (GLinkedLine)this.lines[2].createCopy();
            copy1.setArm(0);
            copy2.setArm(1);
            copy3.setArm(2);
            ((GLinkedCreaseLine)copy1).setcomplex3Parent(copy);
            ((GLinkedCreaseLine)copy2).setcomplex3Parent(copy);
            ((GLinkedCreaseLine)copy3).setcomplex3Parent(copy);
            copy.resetProcessNode(copy, this.iProcessNodeIndex);
        }
        catch (Exception exception) {
            return copy;
        }
        copy.setLine1Line2Line3(copy1, copy2, copy3);
        copy.resetLineArrow();
        copy.setConnectPolicy(this.connectPolicy);
        copy.setColor(new Color(this.color.getRGB()));
        copy.setLineWidth(this.lineWidth);
        GEditPoint[] geditpoints = copy.getEditPoints();
        GEditPoint[] geditpoints_1_ = this.getEditPoints();
        int i = 0;
        while (i < geditpoints_1_.length) {
            Point2D.Double lp = geditpoints_1_[i].getLocalPosition();
            Point2D.Double p = geditpoints_1_[i].getPosition();
            geditpoints[i].setLocalPosition((Point2D.Double)lp.clone());
            geditpoints[i].setPosition((Point2D.Double)p.clone());
            ++i;
        }
        return copy;
    }

    protected void drawLinkAnchors(Graphics2D g2, boolean drawOnlyActive) {
        int arm = this.linkPositionInfo.getArm();
        if (this instanceof DimerFormation) {
            this.line3.drawLinkAnchors(g2, this.linkPositionInfo, drawOnlyActive, this.setupLinkAnchorCoord(), true);
        } else if (this instanceof Dissociation) {
            this.line1.drawLinkAnchors(g2, this.linkPositionInfo, drawOnlyActive, this.setupLinkAnchorCoord(), true);
        } else if (this instanceof Truncation) {
            this.line1.drawLinkAnchors(g2, this.linkPositionInfo, drawOnlyActive, this.setupLinkAnchorCoord(), true);
        }
    }

    public Point2D.Double getAddReactantAddProductCurvePoint(GLinkedShape shp) {
        try {
            GModificationRectangle processnode = this.getProcessNode();
            Point2D.Double[] arrTemp = this.changeLeftRightAnchorPoints(processnode.getAnchorsInLineEnd(), this.getChangeRightLeftFLGofProcessNode());
            if (arrTemp == null || arrTemp.length != 8) {
                return new Point2D.Double();
            }
            if (shp != null && shp instanceof AddReactant) {
                return arrTemp[0];
            }
            if (shp != null && shp instanceof AddProduct) {
                return arrTemp[1];
            }
            return new Point2D.Double();
        }
        catch (Exception myErr) {
            return new Point2D.Double();
        }
    }

    public Point2D.Double[] setupLinkAnchorCoord() {
        Point2D.Double[] arrTemp = new Point2D.Double[]{};
        if (this.rectangShape != null) {
            GLinkedStraightLine ls;
            if (this.isInSBGNViewer && !(this instanceof Truncation)) {
                this.setProcessNodeIndex(0);
            }
            if ((ls = this.getTheSubGLinkedStraightLineHavingProcessNode()) != null) {
                Point2D.Double pEd;
                Point2D.Double pSt = ls.getStartPoint();
                Point2D.Double pNewEd = pEd = ls.getEndPoint();
                if (this.isInSBGNViewer) {
                    pNewEd = GLinkedLineComplex3.getPointNotFarThanGaveLen(pSt, pEd, 20.0);
                    if (pSt == null) {
                        return null;
                    }
                }
                this.rectangShape.updateModification(pNewEd, pSt, ls.getLineWidth());
                if (this instanceof DimerFormation) {
                    arrTemp = this.rectangShape.getAnchors(this.iProcessNodeIndex == 0 || this.iProcessNodeIndex == this.line3.getLineSize() - 1);
                } else if (this instanceof Dissociation) {
                    arrTemp = this.rectangShape.getAnchors(this.iProcessNodeIndex == 0 || this.iProcessNodeIndex == this.line1.getLineSize() - 1);
                } else if (this instanceof Truncation) {
                    arrTemp = this.rectangShape.getAnchors(this.iProcessNodeIndex == 0 || this.iProcessNodeIndex == this.line1.getLineSize() - 1);
                }
                return this.changeLeftRightAnchorPoints(arrTemp, this.getChangeRightLeftFLGofProcessNode());
            }
            return arrTemp;
        }
        return null;
    }

    private Point2D.Double[] changeLeftRightAnchorPoints(Point2D.Double[] arrIn, boolean change) {
        if (arrIn == null || arrIn.length != 8) {
            return null;
        }
        if (!change) {
            return arrIn;
        }
        Point2D.Double[] arrRtn = new Point2D.Double[8];
        if (this instanceof DimerFormation) {
            arrRtn[0] = arrIn[1];
            arrRtn[1] = arrIn[0];
            arrRtn[2] = arrIn[3];
            arrRtn[3] = arrIn[2];
            arrRtn[4] = arrIn[7];
            arrRtn[5] = arrIn[6];
            arrRtn[6] = arrIn[5];
            arrRtn[7] = arrIn[4];
        } else {
            if (this instanceof Dissociation) {
                return arrIn;
            }
            if (this instanceof Truncation) {
                return arrIn;
            }
        }
        return arrRtn;
    }

    public void drawCenterMark(Graphics2D g2) {
    }

    @Override
    public final void drawShape(Graphics2D graphics2d) {
        this.reconfirmProcessNodeIndex();
        int i = 0;
        while (i < 3) {
            this.lines[i].setLineWidth(this.getLineWidth());
            this.lines[i].setColor(this.getColor());
            this.lines[i].drawShape(graphics2d);
            ++i;
        }
        Color oldcolor = graphics2d.getColor();
        if (oldcolor != GColor.HIGHLIGHTED_COLOR) {
            graphics2d.setColor(this.getColor());
        }
        this.rectangShape.drawModification(graphics2d);
        graphics2d.setColor(oldcolor);
        this.drawCenterMark(graphics2d);
        if (this.midCreasePoint.isActive()) {
            this.midCreasePoint.draw(graphics2d);
        }
        if (this.showLinkAnchorMode != 0) {
            boolean drawOnlyActive = this.showLinkAnchorMode == 2;
            this.drawLinkAnchors(graphics2d, drawOnlyActive);
        }
    }

    public void reconfirmProcessNodeIndex() {
        int iProcessnodeRefCnt = 0;
        int j = 0;
        while (j < this.lines.length) {
            GLinkedStraightLine[] vGsl = ((GLinkedCreaseLine)this.lines[j]).getLines();
            int i = 0;
            while (i < vGsl.length) {
                Vector v = vGsl[i].getLineModifications();
                if (v != null && v.contains(this.rectangShape)) {
                    ++iProcessnodeRefCnt;
                }
                ++i;
            }
            ++j;
        }
        int arm = 0;
        boolean mustChangeProcessNodeIdx = false;
        if (this instanceof DimerFormation) {
            arm = 2;
        } else if (this instanceof Dissociation) {
            arm = 0;
        } else if (this instanceof Truncation) {
            arm = 0;
        }
        boolean bl = mustChangeProcessNodeIdx = !this.processnodeInThisArmThisIndex(arm, this.iProcessNodeIndex);
        if (iProcessnodeRefCnt != 1 || mustChangeProcessNodeIdx) {
            this.resetProcessNode(this, this.iProcessNodeIndex);
        }
        GLinkedStraightLine line = ((GLinkedCreaseLine)this.lines[arm]).getLines()[this.iProcessNodeIndex];
        this.rectangShape.updateModification(line.getEndPoint(), line.getStartPoint(), ((GLinkedLine)line).getLineWidth());
    }

    public boolean processnodeInThisArmThisIndex(int arm, int index) {
        boolean rtn = false;
        try {
            rtn = ((GLinkedCreaseLine)this.lines[arm]).getLines()[this.iProcessNodeIndex].getLineModifications().contains(this.rectangShape);
        }
        catch (Exception e) {
            rtn = false;
        }
        return rtn;
    }

    @Override
    public void drawWhiteBaseShape(Graphics2D graphics2d) {
        BasicStroke org_stroke = new BasicStroke();
        org_stroke = (BasicStroke)graphics2d.getStroke();
        BasicStroke tmp_stroke = new BasicStroke((float)this.getLineWidth() + 4.0f, 1, 1);
        graphics2d.setStroke(tmp_stroke);
        Color color = graphics2d.getColor();
        graphics2d.setColor(GLinkedLine.WHITE_COLOR);
        int i = 0;
        while (i < 3) {
            this.lines[i].drawBaseWhiteLine(graphics2d);
            ++i;
        }
        graphics2d.setColor(color);
        graphics2d.setStroke(org_stroke);
    }

    @Override
    public int getCurveBindingIndex() {
        return 0;
    }

    @Override
    public GLinkedLineIndex getDefaultLineIndex() {
        GLinkedLineIndex glinkedlineindex = new GLinkedLineIndex();
        return glinkedlineindex;
    }

    @Override
    public GEditPoint getEditPoint(double x, double y) {
        int i = 0;
        while (i < 3) {
            GEditPoint geditpoint;
            if (this.lines[i] instanceof GEditable && (geditpoint = ((GEditable)((Object)this.lines[i])).getEditPoint(x, y)) != null) {
                return geditpoint;
            }
            ++i;
        }
        if (this.midCreasePoint.inShape(x, y)) {
            return this.midCreasePoint;
        }
        return null;
    }

    @Override
    public GEditPoint[] getEditPoints() {
        int countEditPoints = 0;
        int i = 0;
        while (i < 3) {
            if (this.lines[i] instanceof GEditable) {
                countEditPoints += ((GEditable)((Object)this.lines[i])).getEditPoints().length;
            }
            ++i;
        }
        GEditPoint[] geditpoints = new GEditPoint[++countEditPoints];
        int index = 0;
        int i2 = 0;
        while (i2 < 3) {
            if (this.lines[i2] instanceof GEditable) {
                GEditPoint[] tmpEditPoints = ((GEditable)((Object)this.lines[i2])).getEditPoints();
                int j = 0;
                while (j < tmpEditPoints.length) {
                    geditpoints[index] = tmpEditPoints[j];
                    ++index;
                    ++j;
                }
            }
            ++i2;
        }
        geditpoints[index] = this.midCreasePoint;
        return geditpoints;
    }

    @Override
    public GLinkedLineIndex getGLinkedLineIndexAt(int index) {
        if (index == 0 || index == 1 || index == 2) {
            return this.lines[index].getEndLineIndex();
        }
        return null;
    }

    public GLinkedLine[] getLines() {
        return this.lines;
    }

    public GLinkedLine getLine(int index) {
        if (index < 0 || index > 2) {
            return null;
        }
        return this.lines[index];
    }

    @Override
    public GLinkedLine getLine(GLinkedLineIndex glinkedlineindex) {
        int armIndex = glinkedlineindex.arm;
        if (armIndex == -1) {
            armIndex = 0;
        }
        if (this.lines[armIndex] instanceof GLinkedLineIndexPossesive) {
            return ((GLinkedLineIndexPossesive)((Object)this.lines[armIndex])).getLine(glinkedlineindex);
        }
        return this.lines[armIndex];
    }

    @Override
    public GLinkedLineIndex getLineIndex(double x, double y) {
        GLinkedLineIndex glinkedlineindex = new GLinkedLineIndex();
        int i = 0;
        while (i < 3) {
            if (this.lines[i].inShape(x, y)) {
                glinkedlineindex.arm = i;
                if (!(this.lines[i] instanceof GLinkedLineIndexPossesive)) break;
                GLinkedLineIndex tmpglinkedlineindex = ((GLinkedLineIndexPossesive)((Object)this.lines[i])).getLineIndex(x, y);
                glinkedlineindex.line = tmpglinkedlineindex.line;
                break;
            }
            ++i;
        }
        return glinkedlineindex;
    }

    public Point2D.Double getMidPoint() {
        return this.midCreasePoint.getPosition();
    }

    @Override
    public Point2D.Double getOffset() {
        return this.lines[0].getOffset();
    }

    @Override
    public Rectangle2D.Double getShapeBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public boolean inShape(double x, double y) {
        int i = 0;
        while (i < 3) {
            if (this.lines[i].inShape(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        int i = 0;
        while (i < 3) {
            try {
                if (this.lines[i].inShapeAsTarget(x, y)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        return false;
    }

    private boolean isCrossing(Vector posVec) {
        int j = 0;
        while (j < 3) {
            GLinkTarget t = this.lines[j].getEndTarget();
            Rectangle2D.Double r = t.getBoundsAsTarget();
            int n = posVec.size();
            int i = 0;
            while (i < n - 1) {
                Point2D.Double p1 = (Point2D.Double)posVec.elementAt(i);
                Point2D.Double p2 = (Point2D.Double)posVec.elementAt(i + 1);
                if ((i != 0 || !r.contains(p1)) && r.intersectsLine(p1.x, p1.y, p2.x, p2.y)) {
                    return true;
                }
                ++i;
            }
            ++j;
        }
        return false;
    }

    private Point2D.Double calcInitialMidCreasePointPosition() {
        Point2D.Double[] pArray = new Point2D.Double[3];
        Rectangle2D.Double[] rArray = new Rectangle2D.Double[3];
        Vector[] vArray = new Vector[3];
        int i = 0;
        while (i < 3) {
            GLinkTarget t = this.lines[i].getEndTarget();
            pArray[i] = this.lines[i].getEndTargetPoint();
            GLinkPositionInfo lpi = this.lines[i].getEndLinkPositionInfo();
            rArray[i] = lpi != null ? t.getBoundsAsTarget() : new Rectangle2D.Double(pArray[i].x, pArray[i].y, 0.0, 0.0);
            vArray[i] = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(t, pArray[i], lpi);
            ++i;
        }
        TreeSet posSet = new TreeSet(new MyComparator());
        int i2 = 0;
        while (i2 < 3) {
            int j = (i2 + 1) % 3;
            try {
                Vector posVec = GLinkedCreaseLine.getInitialCreasePointsForSquare(pArray[i2], pArray[j], rArray[i2], rArray[j], vArray[i2], vArray[j], true);
                int k = 1;
                while (k < posVec.size() - 1) {
                    posSet.add(posVec.elementAt(k));
                    ++k;
                }
            }
            catch (RuntimeException e) {
                return null;
            }
            ++i2;
        }
        double penalty = 10000.0;
        int i3 = 0;
        while (i3 < 3) {
            int j = (i3 + 1) % 3;
            penalty += pArray[i3].distance(pArray[j]);
            ++i3;
        }
        penalty *= 1024.0;
        Point2D mp0 = null;
        Point2D mp = null;
        int loop = 0;
        do {
            ++loop;
            TreeSet posSet1 = null;
            double length1 = 0.0;
            int count1 = 0;
            mp = null;
            for (Point2D.Double mp1 : posSet) {
                Vector<Point2D.Double> nextV = new Vector<Point2D.Double>(4);
                nextV.addElement(new Point2D.Double(mp1.x + 1.0, mp1.y));
                nextV.addElement(new Point2D.Double(mp1.x - 1.0, mp1.y));
                nextV.addElement(new Point2D.Double(mp1.x, mp1.y + 1.0));
                nextV.addElement(new Point2D.Double(mp1.x, mp1.y - 1.0));
                double length2 = 0.0;
                int count2 = 0;
                Vector[] posVec = new Vector[3];
                int i4 = 0;
                while (i4 < 3) {
                    try {
                        posVec[i4] = GLinkedCreaseLine.getInitialCreasePointsForSquare(pArray[i4], mp1, rArray[i4], null, vArray[i4], nextV, false);
                    }
                    catch (RuntimeException e) {
                        posVec[i4] = null;
                    }
                    if (posVec[i4] == null) {
                        mp1 = null;
                        break;
                    }
                    double len = GLinkedCreaseLine.calcCreasePointsPathLength(posVec[i4]);
                    if (this.isCrossing(posVec[i4])) {
                        len += penalty;
                    }
                    length2 += len;
                    count2 += posVec[i4].size();
                    ++i4;
                }
                if (mp1 == null || mp != null && !(length2 < length1 + GLinkedCreaseLine.eps) && (!(length2 <= length1 + GLinkedCreaseLine.eps) || count2 >= count1)) continue;
                mp = mp1;
                count1 = count2;
                length1 = length2;
                posSet1 = new TreeSet(new MyComparator());
                i4 = 0;
                while (i4 < 3) {
                    int j = 1;
                    while (j < posVec[i4].size()) {
                        posSet1.add(posVec[i4].elementAt(j));
                        ++j;
                    }
                    ++i4;
                }
            }
            if (mp == null) break;
            posSet = posSet1;
            posSet.add(mp);
            if (mp0 == null) {
                mp0 = mp;
                continue;
            }
            if (mp0.distance(mp) < GLinkedCreaseLine.eps) break;
            mp0 = mp;
        } while (loop < 10);
        return mp0;
    }

    private void initMidCreasePointPosition() {
        try {
            if (this.lines[0].getEndTarget() != null && this.lines[1].getEndTarget() != null && this.lines[2].getEndTarget() != null) {
                Point2D.Double endPoint0 = this.lines[0].getEndTarget().targetPoint();
                Point2D.Double endPoint1 = this.lines[1].getEndTarget().targetPoint();
                Point2D.Double endPoint2 = this.lines[2].getEndTarget().targetPoint();
                Point2D.Double midPoint = new Point2D.Double();
                if (endPoint0 == null || endPoint1 == null || endPoint2 == null) {
                    return;
                }
                midPoint.x = (endPoint0.x + endPoint1.x + endPoint2.x) / 3.0;
                midPoint.y = (endPoint0.y + endPoint1.y + endPoint2.y) / 3.0;
                Point2D.Double mp1 = this.calcInitialMidCreasePointPosition();
                if (mp1 != null) {
                    midPoint = mp1;
                }
                GUtil.createLocalTransform(endPoint0, endPoint1, endPoint2, this.localAT);
                this.midCreasePoint.setPosition(midPoint);
                Point2D.Double localPosition = new Point2D.Double();
                if (this.localAT.getDeterminant() != 0.0) {
                    this.inverse = this.localAT.createInverse();
                    this.inverse.transform(midPoint, localPosition);
                }
                this.midCreasePoint.setLocalPosition(localPosition);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    @Override
    public Rectangle2D.Double moveEditPoint(GEditPoint geditpoint, double x, double y) {
        int i = 0;
        while (i < 3) {
            boolean bool;
            if (this.lines[i] instanceof GEditable && (bool = ((GEditable)((Object)this.lines[i])).contains(geditpoint))) {
                return ((GEditable)((Object)this.lines[i])).moveEditPoint(geditpoint, x, y);
            }
            ++i;
        }
        if (this.midCreasePoint == geditpoint) {
            Point2D.Double localPos1 = new Point2D.Double();
            Point2D.Double pos1 = new Point2D.Double(x, y);
            this.inverse.transform(pos1, localPos1);
            this.midCreasePoint.setLocalPosition(localPos1);
            this.midCreasePoint.setPosition(pos1);
            return this.updateShape(false);
        }
        return null;
    }

    private void setLine(GLinkedLine line1, GLinkedLine line2, GLinkedLine line3) {
        this.lines[0] = line1;
        this.lines[1] = line2;
        this.lines[2] = line3;
        this.midCreasePoint = this.createCreasePoint();
        this.midCreasePoint.setOwner(this);
        try {
            this.lines[0].setTargetAt((GLinkTarget)this.midCreasePoint, 0, (GLinkPositionInfo)null);
            this.lines[1].setTargetAt((GLinkTarget)this.midCreasePoint, 0, (GLinkPositionInfo)null);
            this.lines[2].setTargetAt((GLinkTarget)this.midCreasePoint, 0, (GLinkPositionInfo)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initMidCreasePointPosition();
    }

    private void setLine1Line2Line3(GLinkedLine line1, GLinkedLine line2, GLinkedLine line3) {
        this.line1 = (GLinkedCreaseLine)line1;
        this.line2 = (GLinkedCreaseLine)line2;
        this.line3 = (GLinkedCreaseLine)line3;
        this.setLine(line1, line2, line3);
    }

    @Override
    public void setOffset(double x, double y) {
        int i = 0;
        while (i < 3) {
            this.lines[i].setOffset(x, y);
            ++i;
        }
        this.midCreasePoint.setVisualOffset(x, y);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkPositionInfo lpi) throws Exception {
        if (index < 0 || index > 3) {
            throw new Exception("index must 0 or 1 or 2");
        }
        this.lines[index].setTargetAt(glinktarget, 1, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, double x, double y, GLinkPositionInfo lpi) throws Exception {
        if (index < 0 || index > 3) {
            throw new Exception("index must 0 or 1 or 2");
        }
        this.lines[index].setTargetAt(glinktarget, 1, x, y, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkedLineIndex glinkedlineindex) throws Exception {
        if (index < 0 || index > 3) {
            throw new Exception("index must 0 or 1 or 2");
        }
        this.lines[index].setTargetAt(glinktarget, 1, glinkedlineindex);
    }

    @Override
    public Point2D.Double targetPoint() {
        return this.midCreasePoint.getPosition();
    }

    @Override
    public int targetSize() {
        return 3;
    }

    @Override
    public Rectangle2D.Double updateShape() {
        return this.updateShape(true);
    }

    @Override
    public Rectangle2D.Double updateShape(boolean moveCreasePoints) {
        Rectangle2D.Double redrawArea = null;
        if (this.lines[0].getEndTarget() == null || this.lines[1].getEndTarget() == null || this.lines[2].getEndTarget() == null) {
            return null;
        }
        Point2D.Double endPoint0 = this.lines[0].getEndTarget().targetPoint();
        Point2D.Double endPoint1 = this.lines[1].getEndTarget().targetPoint();
        Point2D.Double endPoint2 = this.lines[2].getEndTarget().targetPoint();
        GUtil.createLocalTransform(endPoint0, endPoint1, endPoint2, this.localAT);
        if (this.midCreasePoint != null && this.midCreasePoint.getLocalPosition() == null) {
            this.initMidCreasePointPosition();
        }
        if (moveCreasePoints) {
            Point2D.Double localPosition = this.midCreasePoint.getLocalPosition();
            Point2D.Double position = this.midCreasePoint.getPosition();
            this.localAT.transform(localPosition, position);
        } else {
            Point2D.Double pos1 = this.midCreasePoint.getPosition();
            Point2D.Double localPos1 = new Point2D.Double();
            try {
                this.inverse = this.localAT.createInverse();
                this.inverse.transform(pos1, localPos1);
                this.midCreasePoint.setLocalPosition(localPos1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bounds = null;
        Rectangle2D tmpRedrawArea = this.midCreasePoint.update();
        Rectangle2D.Double tmpBounds = this.midCreasePoint.getBounds();
        if (this.midCreasePoint.isActive()) {
            this.bounds = GUtil.union(this.bounds, tmpBounds);
            redrawArea = GUtil.union(redrawArea, tmpRedrawArea);
        }
        int i = 0;
        while (i < 3) {
            this.lines[i].setLineWidth(this.lineWidth);
            this.lines[i].setColor(this.color);
            tmpRedrawArea = this.lines[i].updateShape(moveCreasePoints);
            tmpBounds = this.lines[i].getShapeBounds();
            this.bounds = GUtil.union(this.bounds, tmpBounds);
            redrawArea = GUtil.union(redrawArea, tmpRedrawArea);
            ++i;
        }
        this.setupLinkAnchorCoord();
        return redrawArea;
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        if (this.inShape(x, y)) {
            GLinkPositionInfo lpi;
            int arm;
            if (this instanceof DimerFormation) {
                arm = 2;
                lpi = this.line3.getPointedLinkPosition(x, y);
            } else if (this instanceof Dissociation) {
                arm = 0;
                lpi = this.line1.getPointedLinkPosition(x, y);
            } else if (this instanceof Truncation) {
                arm = 0;
                lpi = this.line1.getPointedLinkPosition(x, y);
            } else {
                return null;
            }
            if (lpi != null) {
                lpi.setArm(arm);
            }
            return lpi;
        }
        return null;
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.showLinkAnchorMode = drawOnlyActive ? 2 : 1;
        this.linkPositionInfo = (GLinkPositionInfo)lpi.clone();
    }

    @Override
    public void hideLinkAnchors() {
        this.showLinkAnchorMode = 0;
        this.linkPositionInfo = null;
    }

    @Override
    public int getTargetIndex(GEditPoint ep) {
        int i = 0;
        while (i < 3) {
            if (((GLinkedCreaseLine)this.lines[i]).getEndHandlePoint() == ep) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        return this.lines[i].getEndLinkPositionInfo();
    }

    @Override
    public int getConnectPolicy() {
        return this.connectPolicy;
    }

    @Override
    public void setConnectPolicy(int policy) {
        this.connectPolicy = policy;
        int i = 0;
        while (i < 3) {
            ((GLinkedCreaseLine)this.lines[i]).setConnectPolicy(policy);
            ++i;
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setCreasePointsInitialized(boolean b) {
        int i = 0;
        while (i < 3) {
            ((GLinkedCreaseLine)this.lines[i]).setCreasePointsInitialized(b);
            ++i;
        }
    }

    @Override
    public GLink getReactionLink(GStructure structure) {
        Vector links = structure.getLinks();
        for (GLink rl : links) {
            GLinkedShape link1 = rl.getGLinkedShape();
            if (!(link1 instanceof GLinkedLineComplex3) || link1 != this) continue;
            return rl;
        }
        return null;
    }

    @Override
    public void restrictEditPointMoveVector(GEditPoint ep1, GEditPoint ep2, Point2D.Double dxdy) {
    }

    @Override
    public void appendMovingPointAndPosition(GEditPoint ep1, Vector startXYVec) {
        int i1 = -1;
        startXYVec.addElement(new ElementAndPosition(ep1, i1, ep1.getPosition()));
    }

    @Override
    public void appendAdditionalMovingPointAndPosition(GEditPoint point, Vector startXYVec) {
    }

    @Override
    public Vector setMovedElementPosition(double dx, double dy, Vector startXYVec) {
        if (this.connectPolicy == 1 && startXYVec.size() > 1) {
            startXYVec.setSize(1);
        }
        return GLinkedCreaseLine.setMovedElementPositionDefault(dx, dy, startXYVec);
    }

    protected void reformSquareLines(GStructure structure, boolean needToSaveCurrentPolicy) {
        Rectangle2D.Double updateRect = null;
        Rectangle2D updateRect1 = null;
        Rectangle2D updateRect2 = null;
        int iOldProcessNodeIdx = this.getProcessNodeIndex();
        Point2D.Double mp1 = this.calcInitialMidCreasePointPosition();
        GLink gl = this.getReactionLink(structure);
        GLink eventLink = this.getReactionLink(structure);
        SBModel sbmodel = null;
        GLinkedShape oldshape = null;
        GLinkedShape newshape = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        }
        catch (Exception myErr) {
            sbmodel = null;
        }
        if (sbmodel != null) {
            oldshape = eventLink.getGLinkedShape();
            sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy", oldshape, oldshape);
        }
        if (needToSaveCurrentPolicy) {
            structure.notifyChange(gl, 12, null);
        }
        boolean policyChange = false;
        if (this.connectPolicy == 1) {
            policyChange = true;
            int pol = 0;
            this.setConnectPolicy(pol);
        }
        Vector<GCreasePoint> gelements = new Vector<GCreasePoint>();
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        gelements.addElement(this.midCreasePoint);
        v.add(mp1);
        structure.move(gelements, v);
        int i = 0;
        while (i < 3) {
            ((GLinkedCreaseLine)this.lines[i]).reformSquareLinesProtected(gl, structure);
            ++i;
        }
        if (policyChange) {
            int pol = 1;
            this.setConnectPolicy(pol);
        }
        this.initLinesDirection();
        this.resetProcessNode(this, iOldProcessNodeIdx);
        structure.notifyChange(gl, 13, null);
        if (sbmodel != null) {
            newshape = eventLink.getGLinkedShape();
            sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy", newshape, newshape);
        }
        if (gl instanceof ReactionLink) {
            updateRect1 = structure.autoAjustLinkLineConn((ReactionLink)gl);
        }
        updateRect2 = structure.repaintLinkandAllLinksWhichlinkingtome((ReactionLink)gl, false);
        updateRect = GUtil.union(updateRect, updateRect1);
        updateRect = GUtil.union(updateRect, updateRect2);
        structure.callbyuserRepaint(updateRect);
    }

    @Override
    public void reformSquareLines(GStructure structure) {
        this.reformSquareLines(structure, true);
    }

    @Override
    public void initLinesDirection() {
        int i = 0;
        while (i < 3) {
            ((GLinkedCreaseLine)this.lines[i]).initLinesDirection();
            ++i;
        }
    }

    @Override
    public void setlinesDirection(Vector vec) {
        int i = (Integer)vec.elementAt(0);
        ((GLinkedCreaseLine)this.lines[i]).setlinesDirection(vec);
    }

    @Override
    public void toggleConnectPolicy(GStructure structure) {
        if (this.connectPolicy == 0) {
            int pol = 1;
            this.setConnectPolicy(pol);
            this.reformSquareLines(structure, false);
        } else {
            GLink gl = this.getReactionLink(structure);
            structure.notifyChange(gl, 12, null);
            int pol = 0;
            this.setConnectPolicy(pol);
        }
    }

    @Override
    public boolean canTogglePolicy(GStructure structure) {
        int i = 0;
        while (i < 3) {
            boolean bool = ((GLinkedCreaseLine)this.lines[i]).canTogglePolicy();
            if (!bool) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void setupAfterAllTargetsSetted() {
        if (this.connectPolicy == 1) {
            this.initLinesDirection();
        }
    }

    protected Point2D.Double[] getPointsForPrview(Rectangle bounds) {
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        Point2D.Double pt3 = new Point2D.Double();
        Point2D.Double ptc = new Point2D.Double();
        pt1.x = (double)bounds.x + (double)bounds.width * 0.2;
        pt1.y = (double)bounds.y + (double)bounds.height * 0.5;
        pt2.x = (double)bounds.x + (double)bounds.width * 0.8;
        pt2.y = (double)bounds.y + (double)bounds.height * 0.3;
        pt3.x = (double)bounds.x + (double)bounds.width * 0.8;
        pt3.y = (double)bounds.y + (double)bounds.height * 0.7;
        ptc.x = (double)bounds.x + (double)bounds.width * 0.5;
        ptc.y = (double)bounds.y + (double)bounds.height * 0.5;
        Point2D.Double[] array = new Point2D.Double[]{pt1, pt2, pt3, ptc};
        return array;
    }

    public void drawPreview(Graphics2D g2, Rectangle bounds, Color color, double width) {
        Point2D.Double[] array = this.getPointsForPrview(bounds);
        Point2D.Double pt1 = array[0];
        Point2D.Double pt2 = array[1];
        Point2D.Double pt3 = array[2];
        Point2D.Double ptc = array[3];
        GLinkedStraightLine sl = (GLinkedStraightLine)this.line1.getLine(0);
        sl.setStartAndEndPoint(ptc, pt1);
        sl = (GLinkedStraightLine)this.line2.getLine(0);
        sl.setStartAndEndPoint(ptc, pt2);
        sl = (GLinkedStraightLine)this.line3.getLine(0);
        sl.setStartAndEndPoint(ptc, pt3);
        this.midCreasePoint.setPosition(ptc);
        this.setColor(color);
        this.setLineWidth(width);
        this.midCreasePoint.update();
        int i = 0;
        while (i < 3) {
            this.lines[i].setLineWidth(this.lineWidth);
            this.lines[i].setColor(color);
            this.lines[i].updateShape(true);
            ++i;
        }
        this.drawShape(g2);
    }

    public List removeCreasePoint(GStructure structure) {
        ArrayList undoList = new ArrayList();
        undoList.addAll(((GLinkedCreaseLine)this.lines[0]).removeCreasePoint(structure));
        undoList.addAll(((GLinkedCreaseLine)this.lines[1]).removeCreasePoint(structure));
        undoList.addAll(((GLinkedCreaseLine)this.lines[2]).removeCreasePoint(structure));
        this.resetProcessNode(this, 0);
        return undoList;
    }

    public void setMidCreasePoint(double x, double y) {
        this.midCreasePoint.getOwner().moveEditPoint(this.midCreasePoint, x, y);
    }

    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        Point2D.Double pt = null;
        try {
            pt = this.setupLinkAnchorCoord()[lpi.getPosition()];
        }
        catch (Exception e) {
            pt = null;
        }
        return pt;
    }

    public Rectangle2D.Double getBoundsAsTarget() {
        return null;
    }

    @Override
    public int getLineType() {
        return 1;
    }

    @Override
    public void setLineType(int type) {
    }

    public void setRectangleIndex(int index) {
        this.resetProcessNode(this, index);
    }

    public GModificationRectangle getProcessNode() {
        return this.rectangShape;
    }

    public GLinkedStraightLine getTheSubGLinkedStraightLineHavingProcessNode() {
        GLinkedStraightLine[] ls = null;
        if (this instanceof DimerFormation) {
            ls = this.line3.getLines();
        } else if (this instanceof Dissociation) {
            ls = this.line1.getLines();
        } else if (this instanceof Truncation) {
            ls = this.line1.getLines();
        }
        if (ls != null) {
            block11: {
                block10: {
                    try {
                        if (this.iProcessNodeIndex >= 0) break block10;
                        return null;
                    }
                    catch (Exception myErr) {
                        return null;
                    }
                }
                if (this.iProcessNodeIndex <= ls.length - 1) break block11;
                return null;
            }
            return ls[this.iProcessNodeIndex];
        }
        return null;
    }

    private void resetLineArrow() {
        try {
            int j = 0;
            while (j < this.lines.length) {
                Vector v = this.lines[j].getLineModifications();
                if (v != null && v.size() > 0) {
                    Vector tmpVec2 = new Vector();
                    int m = 0;
                    while (m < v.size()) {
                        if (v.get(m) instanceof GLinkedLineArrowShape) {
                            tmpVec2.add(v.get(m));
                        }
                        ++m;
                    }
                    m = 0;
                    while (m < tmpVec2.size()) {
                        v.remove(tmpVec2.get(m));
                        ++m;
                    }
                }
                GLinkedStraightLine[] vGsl = ((GLinkedCreaseLine)this.lines[j]).getLines();
                int i = 0;
                while (i < vGsl.length) {
                    v = vGsl[i].getLineModifications();
                    if (v != null && v.size() > 0) {
                        Vector tmpVec2 = new Vector();
                        int m = 0;
                        while (m < v.size()) {
                            if (v.get(m) instanceof GLinkedLineArrowShape) {
                                tmpVec2.add(v.get(m));
                            }
                            ++m;
                        }
                        m = 0;
                        while (m < tmpVec2.size()) {
                            v.remove(tmpVec2.get(m));
                            ++m;
                        }
                    }
                    ++i;
                }
                ++j;
            }
            ((LinkedCreaseLineForComplex3)this.line1).setArrowShape(this.arrowShape13);
            ((LinkedCreaseLineForComplex3)this.line2).setArrowShape(this.arrowShape23);
            ((LinkedCreaseLineForComplex3)this.line3).setArrowShape(this.arrowShape33);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setIsInSBGNViewer(boolean flag) {
        this.isInSBGNViewer = flag;
    }

    @Override
    public boolean isInSBGNViewer() {
        return this.isInSBGNViewer;
    }

    public static final Point2D.Double getPointNotFarThanGaveLen(Point2D.Double pStart, Point2D.Double pEnd, double r) {
        if (pStart == null || pEnd == null) {
            return null;
        }
        if (r < 0.01) {
            return null;
        }
        Point2D.Double pNewEd = pEnd;
        double dL = pEnd.distance(pStart);
        if (dL > r) {
            Ellipse2D.Double ell = new Ellipse2D.Double(pStart.x - r, pStart.y - r, r * 2.0, r * 2.0);
            Area areaSearching = new Area(ell);
            pNewEd = LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, pNewEd, 0.5, 1);
        }
        return pNewEd;
    }

    class MyComparator
    implements Comparator {
        MyComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Point2D.Double p1 = (Point2D.Double)obj1;
            Point2D.Double p2 = (Point2D.Double)obj2;
            if (p1.x > p2.x) {
                return 1;
            }
            if (p1.x < p2.x) {
                return -1;
            }
            if (p1.y > p2.y) {
                return 1;
            }
            if (p1.y < p2.y) {
                return -1;
            }
            return 0;
        }
    }
}

