/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.MarkInendofModificationLine;
import jp.sbi.celldesigner.LinkedCreaseLine;

public class GLinkedLineArrowShape
implements GLinkedLineModificationShape {
    public static final int TYPE_FILL = 1;
    public static final int TYPE_DRAW = 2;
    public static final int TYPE_WITHLINE = 3;
    public static final int TYPE_NOTFILLBUTHAVELINE = 4;
    private Line2D.Double l = null;
    private Rectangle2D.Double lineBounds = null;
    private double width = 4.0;
    private double length = 15.0;
    private Polygon p = null;
    private GeneralPath poutter = null;
    private GeneralPath pinner = null;
    private Rectangle2D.Double polygonBounds = null;
    private int type = 1;
    private boolean isVisible = true;
    private boolean isReversed = false;
    private Point2D modifiedPoint;
    private int index = 0;

    public GLinkedLineArrowShape() {
    }

    public GLinkedLineArrowShape(int index) {
        this.index = index;
    }

    @Override
    public GLinkedLineModificationShape createCopy() {
        GLinkedLineArrowShape copy = null;
        try {
            copy = (GLinkedLineArrowShape)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return copy;
        }
        copy.setType(this.type);
        copy.setLength(this.length);
        copy.setWidth(this.width);
        copy.setReversed(this.isReversed);
        copy.setVisible(this.isVisible);
        copy.setIndex(this.index);
        return copy;
    }

    public Polygon createPolygon(Point2D.Double p1, Point2D.Double p2, Point2D.Double tip, double height, double base, int type, double lwidth) {
        double xshift = 0.0;
        if (type == 2) {
            xshift = lwidth;
        }
        AffineTransform affinetransform = new AffineTransform();
        affinetransform.translate(tip.x, tip.y);
        GUtil.addRotateAT(affinetransform, p1, p2);
        Point2D.Double top = new Point2D.Double(-xshift, 0.0);
        Point2D.Double bottomR = new Point2D.Double(-height - xshift, base);
        Point2D.Double bottomL = new Point2D.Double(-height - xshift, -base);
        Point2D.Double topTransformed = new Point2D.Double();
        Point2D.Double bottomRTransformed = new Point2D.Double();
        Point2D.Double bottomLTransformed = new Point2D.Double();
        affinetransform.transform(top, topTransformed);
        affinetransform.transform(bottomR, bottomRTransformed);
        affinetransform.transform(bottomL, bottomLTransformed);
        Polygon polygon = new Polygon();
        polygon.addPoint((int)topTransformed.x, (int)topTransformed.y);
        polygon.addPoint((int)bottomRTransformed.x, (int)bottomRTransformed.y);
        polygon.addPoint((int)bottomLTransformed.x, (int)bottomLTransformed.y);
        polygon.addPoint((int)topTransformed.x, (int)topTransformed.y);
        if (type == 4) {
            this.poutter = new GeneralPath();
            this.poutter.reset();
            this.poutter.moveTo((float)topTransformed.x, (float)topTransformed.y);
            this.poutter.lineTo((float)bottomRTransformed.x, (float)bottomRTransformed.y);
            this.poutter.lineTo((float)bottomLTransformed.x, (float)bottomLTransformed.y);
            this.poutter.lineTo((float)topTransformed.x, (float)topTransformed.y);
            this.poutter.closePath();
            Point2D.Double topinner = new Point2D.Double(-xshift - lwidth * 2.0, 0.0);
            Point2D.Double bottominnerR = new Point2D.Double(-height - xshift + lwidth, base - lwidth);
            Point2D.Double bottominnerL = new Point2D.Double(-height - xshift + lwidth, -base + lwidth);
            Point2D.Double topinnerTransformed = new Point2D.Double();
            Point2D.Double bottominnerRTransformed = new Point2D.Double();
            Point2D.Double bottominnerLTransformed = new Point2D.Double();
            affinetransform.transform(topinner, topinnerTransformed);
            affinetransform.transform(bottominnerR, bottominnerRTransformed);
            affinetransform.transform(bottominnerL, bottominnerLTransformed);
            this.pinner = new GeneralPath();
            this.pinner.reset();
            this.pinner.moveTo((float)topinnerTransformed.x, (float)topinnerTransformed.y);
            this.pinner.lineTo((float)bottominnerRTransformed.x, (float)bottominnerRTransformed.y);
            this.pinner.lineTo((float)bottominnerLTransformed.x, (float)bottominnerLTransformed.y);
            this.pinner.lineTo((float)topinnerTransformed.x, (float)topinnerTransformed.y);
            this.pinner.closePath();
        }
        return polygon;
    }

    public Line2D.Double createLine(Point2D.Double start, Point2D.Double end, Point2D.Double tip, double length, double height, double lineWidth) {
        AffineTransform affinetransform = new AffineTransform();
        affinetransform.translate(tip.x, tip.y);
        GUtil.addRotateAT(affinetransform, start, end);
        Point2D.Double top = new Point2D.Double(-length - 4.0 - lineWidth, -height * 0.5 - 2.0);
        Point2D.Double bottom = new Point2D.Double(-length - 4.0 - lineWidth, height * 0.5 + 2.0);
        Point2D.Double translatedTop = new Point2D.Double();
        Point2D.Double translatedBottom = new Point2D.Double();
        affinetransform.transform(top, translatedTop);
        affinetransform.transform(bottom, translatedBottom);
        Line2D.Double line = new Line2D.Double(translatedTop, translatedBottom);
        return line;
    }

    @Override
    public void drawModification(Graphics2D graphics2d) {
        if (this.p != null && this.isVisible) {
            if (this.type == 1) {
                graphics2d.fill(this.p);
            } else if (this.type == 3) {
                graphics2d.fill(this.p);
                graphics2d.draw(this.l);
            } else if (this.type == 4) {
                Color color = graphics2d.getColor();
                graphics2d.fill(this.poutter);
                graphics2d.draw(this.l);
                graphics2d.setColor(Color.white);
                graphics2d.fill(this.pinner);
                graphics2d.setColor(color);
            } else {
                Color color = graphics2d.getColor();
                graphics2d.setColor(Color.white);
                graphics2d.fill(this.p);
                graphics2d.setColor(color);
                graphics2d.draw(this.p);
            }
        }
    }

    @Override
    public Rectangle2D.Double getModificationBounds() {
        return GUtil.union(this.polygonBounds, this.lineBounds);
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setReversed(boolean reversed) {
        this.isReversed = reversed;
    }

    public void setType(int i) {
        this.type = i;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    @Override
    public Rectangle2D.Double updateModification(Point2D.Double start, Point2D.Double end, double lineWidth) {
        return this.updateModification(null, start, end, lineWidth);
    }

    public Rectangle2D.Double updateModification(LinkedCreaseLine parent, Point2D.Double start, Point2D.Double end, double lineWidth) {
        Rectangle2D rectangle2d;
        double extend;
        Point2D.Double ep;
        Point2D.Double sp;
        Rectangle2D.Double redrawArea = GUtil.union(this.lineBounds, this.polygonBounds);
        if (start == null || end == null) {
            return null;
        }
        this.width = lineWidth + 4.0;
        this.length = this.width * 3.0;
        Point2D.Double modifyPoint = null;
        double offset = lineWidth / 2.0 * 0.6;
        modifyPoint = MarkInendofModificationLine.calcNewTargetPoint(parent, offset);
        if (!this.isReversed) {
            sp = start;
            ep = this.type == 4 && modifyPoint != null ? modifyPoint : end;
        } else {
            sp = end;
            ep = start;
        }
        this.p = this.createPolygon(sp, ep, ep, this.length, this.width, this.type, lineWidth);
        if (this.p != null) {
            extend = Math.ceil(Math.sqrt(10.0) * 0.5 * lineWidth);
            rectangle2d = this.p.getBounds2D();
            this.polygonBounds = new Rectangle2D.Double(rectangle2d.getX() - extend, rectangle2d.getY() - extend, rectangle2d.getWidth() + 2.0 * extend, rectangle2d.getHeight() + 2.0 * extend);
        }
        if (this.type == 3 || this.type == 4) {
            this.l = this.createLine(sp, ep, ep, this.length, this.width, lineWidth);
            if (this.l != null) {
                extend = Math.ceil(Math.sqrt(10.0) * 0.5 * lineWidth);
                rectangle2d = this.l.getBounds2D();
                this.lineBounds = new Rectangle2D.Double(rectangle2d.getX() - extend, rectangle2d.getY() - extend, rectangle2d.getWidth() + 2.0 * extend, rectangle2d.getHeight() + 2.0 * extend);
            }
        }
        AffineTransform at = new AffineTransform();
        at.translate(ep.x, ep.y);
        GUtil.addRotateAT(at, sp, ep);
        Point2D.Double p1 = new Point2D.Double(-this.length * 0.9, 0.0);
        Point2D.Double sp1 = new Point2D.Double();
        at.transform(p1, sp1);
        this.modifiedPoint = sp1;
        return GUtil.union(GUtil.union(redrawArea, this.polygonBounds), this.lineBounds);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public static Line2D.Double modifyLineStatic(boolean reverse, Point2D pos, Line2D.Double modifiedLine) {
        Line2D.Double line = new Line2D.Double();
        line.setLine(modifiedLine);
        if (pos != null) {
            if (reverse) {
                line.x1 = pos.getX();
                line.y1 = pos.getY();
            } else {
                line.x2 = pos.getX();
                line.y2 = pos.getY();
            }
        }
        return line;
    }

    @Override
    public Line2D.Double modifyLine(Line2D.Double line) {
        return GLinkedLineArrowShape.modifyLineStatic(this.isReversed, this.modifiedPoint, line);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int indx) {
        this.index = indx;
    }

    public Point2D getModifiedPoint() {
        return (Point2D)this.modifiedPoint.clone();
    }
}

