/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GAtomImpl;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedLineIndexPossesive;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.symbol.species.Tag;

public abstract class GLinkedLine
implements GLinkedShape,
GLinkTarget {
    private static int defaultCreasePointNumber = 0;
    public static final int CONNECT_POLICY_DIRECT = 0;
    public static final int CONNECT_POLICY_SQUARE = 1;
    private static int defaultConnectPolicy = 0;
    protected GLinkTarget startTarget = null;
    protected GLinkTarget endTarget = null;
    protected GLinkPositionInfo startLinkPositionInfo = null;
    protected GLinkPositionInfo endLinkPositionInfo = null;
    protected Point2D.Double start = null;
    protected Point2D.Double end = null;
    protected double offsetX = 0.0;
    protected double offsetY = 0.0;
    protected int curveBindingIndex = 0;
    protected GLinkedLineIndex startLineIndex = null;
    protected GLinkedLineIndex endLineIndex = null;
    protected Vector lineModifications = new Vector();
    protected Stroke stroke = null;
    protected boolean isAntiAliasON = false;
    public static final Color WHITE_COLOR = Color.white;
    public Point2D.Double starttemp = null;
    public Point2D.Double endtemp = null;
    public double starttempX = -1.0;
    public double starttempY = -1.0;
    public static final double minWidthOfLineHavingInnerWhiteLine = 2.2;
    public static final double widthOfMarklineInLineHavingInnerWhiteLine = 1.0;
    private boolean isInSBGNViewer = false;
    private boolean bDrawLineCenter = false;
    private int addingObjectFlg = 0;

    public static void setDefaultCreasePointNumber(int value) {
        defaultCreasePointNumber = value;
    }

    public static int getDefaultCreasePointNumber() {
        return defaultCreasePointNumber;
    }

    public void resetCreaseLineNumber(int newCreaseLineNumber) {
    }

    public void addModificationShape(GLinkedLineModificationShape glinkedlinemodificationshape) {
        this.lineModifications.add(glinkedlinemodificationshape);
    }

    public abstract GLinkedLine createCopiedLine();

    public Vector getLineModifications() {
        return this.lineModifications;
    }

    public void clearLineModifications() {
        this.lineModifications = new Vector();
    }

    protected void restoreLineModifications() {
    }

    @Override
    public GLinkedShape createCopy() {
        GLinkedLine copy = this.createCopiedLine();
        if (copy == null) {
            return copy;
        }
        int i = 0;
        while (i < this.lineModifications.size()) {
            GLinkedLineModificationShape glinkedlinemodificationshape = (GLinkedLineModificationShape)this.lineModifications.elementAt(i);
            copy.addModificationShape(glinkedlinemodificationshape.createCopy());
            ++i;
        }
        if (this.startLineIndex != null) {
            copy.startLineIndex = this.startLineIndex.createCopy();
        }
        if (this.endLineIndex != null) {
            copy.endLineIndex = this.endLineIndex.createCopy();
        }
        if (this.start != null) {
            copy.start = (Point2D.Double)this.start.clone();
        }
        if (this.end != null) {
            copy.end = (Point2D.Double)this.end.clone();
        }
        copy.setStroke(this.stroke);
        copy.setAntiAliasON(this.isAntiAliasON);
        copy.setCurveBindingIndex(this.curveBindingIndex);
        copy.setColor(new Color(this.getColor().getRGB()));
        copy.setLineWidth(this.getLineWidth());
        return copy;
    }

    public abstract void drawBaseWhiteLine(Graphics2D var1);

    public abstract void drawLine(Graphics2D var1);

    @Override
    public void drawShape(Graphics2D graphics2d) {
        BasicStroke tmp_stroke;
        Stroke stroke = null;
        if (this.stroke != null) {
            stroke = graphics2d.getStroke();
            graphics2d.setStroke(this.stroke);
        }
        BasicStroke org_stroke = new BasicStroke();
        org_stroke = (BasicStroke)graphics2d.getStroke();
        if (org_stroke.getDashArray() == null) {
            tmp_stroke = new BasicStroke((float)this.getLineWidth(), 1, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            graphics2d.setStroke(tmp_stroke);
        } else {
            tmp_stroke = new BasicStroke((float)this.getLineWidth(), org_stroke.getEndCap(), org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
            graphics2d.setStroke(tmp_stroke);
        }
        Color org_color = graphics2d.getColor();
        if (org_color != GColor.HIGHLIGHTED_COLOR) {
            graphics2d.setColor(this.getColor());
        }
        RenderingHints renderinghints = null;
        if (this.isAntiAliasON) {
            renderinghints = graphics2d.getRenderingHints();
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawLine(graphics2d);
        if (this.bDrawLineCenter) {
            this.drawCenterLine(graphics2d);
        }
        if (this.stroke != null) {
            graphics2d.setStroke(stroke);
        }
        if (this.isAntiAliasON) {
            graphics2d.setRenderingHints(renderinghints);
        }
        int i = 0;
        while (i < this.lineModifications.size()) {
            GLinkedLineModificationShape glinkedlinemodificationshape = (GLinkedLineModificationShape)this.lineModifications.elementAt(i);
            glinkedlinemodificationshape.drawModification(graphics2d);
            ++i;
        }
        graphics2d.setColor(org_color);
        graphics2d.setStroke(org_stroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawShape(Graphics2D graphics2d, boolean bDrawCenter) {
        GLinkedLine gLinkedLine = this;
        synchronized (gLinkedLine) {
            block9: {
                if (graphics2d == null) {
                    return;
                }
                boolean bDrawLineCenterBak = this.bDrawLineCenter;
                this.bDrawLineCenter = bDrawCenter;
                try {
                    try {
                        this.drawShape(graphics2d);
                    }
                    catch (Exception exception) {
                        this.bDrawLineCenter = bDrawLineCenterBak;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.bDrawLineCenter = bDrawLineCenterBak;
                    throw throwable;
                }
                this.bDrawLineCenter = bDrawLineCenterBak;
            }
        }
    }

    public void drawCenterLine(Graphics2D g2) {
        Color colorBak = g2.getColor();
        BasicStroke org_strokeBak = (BasicStroke)g2.getStroke();
        if (this.getLineWidth() >= 2.2) {
            g2.setColor(new Color(255, 255, 255, 255));
            g2.setStroke(new BasicStroke((float)(this.getLineWidth() - 2.0)));
            this.drawLine(g2);
        }
        g2.setStroke(org_strokeBak);
        g2.setColor(colorBak);
    }

    @Override
    public void drawWhiteBaseShape(Graphics2D graphics2d) {
        BasicStroke org_stroke = new BasicStroke();
        org_stroke = (BasicStroke)graphics2d.getStroke();
        BasicStroke tmp_stroke = new BasicStroke((float)this.getLineWidth() + 4.0f, 1, 1);
        graphics2d.setStroke(tmp_stroke);
        Color color = graphics2d.getColor();
        graphics2d.setColor(WHITE_COLOR);
        this.drawBaseWhiteLine(graphics2d);
        graphics2d.setColor(color);
        graphics2d.setStroke(org_stroke);
    }

    @Override
    public Rectangle2D.Double getBoundsAsTarget() {
        return this.getLineBounds();
    }

    @Override
    public int getCurveBindingIndex() {
        return this.curveBindingIndex;
    }

    public GLinkedLineIndex getEndLineIndex() {
        return this.endLineIndex;
    }

    public Point2D.Double getEndPoint() {
        return this.end;
    }

    public GLinkTarget getEndTarget() {
        return this.endTarget;
    }

    @Override
    public GLinkedLineIndex getGLinkedLineIndexAt(int index) {
        if (index == 0) {
            return this.getStartLineIndex();
        }
        if (index == 1) {
            return this.getEndLineIndex();
        }
        return null;
    }

    public abstract Rectangle2D.Double getLineBounds();

    @Override
    public Point2D.Double getOffset() {
        return new Point2D.Double(this.offsetX, this.offsetY);
    }

    @Override
    public Rectangle2D.Double getShapeBounds() {
        Rectangle2D.Double bounds = this.getLineBounds();
        int i = 0;
        while (i < this.lineModifications.size()) {
            GLinkedLineModificationShape glinkedlinemodificationshape = (GLinkedLineModificationShape)this.lineModifications.elementAt(i);
            Rectangle2D.Double modificationBounds = glinkedlinemodificationshape.getModificationBounds();
            bounds = GUtil.union(bounds, modificationBounds);
            ++i;
        }
        return bounds;
    }

    public GLinkedLineIndex getStartLineIndex() {
        return this.startLineIndex;
    }

    public Point2D.Double getStartPoint() {
        return this.start;
    }

    public GLinkTarget getStartTarget() {
        return this.startTarget;
    }

    public abstract boolean inLine(double var1, double var3);

    @Override
    public boolean inShape(double x, double y) {
        return this.inLine(x, y);
    }

    @Override
    public abstract boolean inShapeAsTarget(double var1, double var3);

    @Override
    public boolean isMovable() {
        return true;
    }

    public void setAntiAliasON(boolean aliasOn) {
        this.isAntiAliasON = aliasOn;
    }

    public void setCurveBindingIndex(int index) {
        this.curveBindingIndex = index;
    }

    @Override
    public void setOffset(double x, double y) {
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkPositionInfo lpi) throws Exception {
        if (index == 0) {
            if (glinktarget instanceof GLink) {
                GLinkedLineIndex glinkedlineindex;
                GLinkedLineIndexPossesive glinkedlineindexpossesive;
                GLinkedLine glinkedline;
                GLinkedShape glinkedshape = ((GLink)glinktarget).getGLinkedShape();
                if (glinkedshape instanceof StateTransition || glinkedshape instanceof LinkedCreaseLineModification || glinkedshape instanceof LinkedCreaseLineMixedNotation || glinkedshape instanceof GLinkedLineComplex3) {
                    GLinkedLineIndex glinkedlineindex2 = new GLinkedLineIndex();
                    if (lpi != null) {
                        glinkedlineindex2.arm = lpi.getArm();
                        glinkedlineindex2.line = lpi.getPosition();
                    }
                    this.startLineIndex = glinkedlineindex2;
                    this.startTarget = glinktarget;
                    this.startLinkPositionInfo = lpi;
                    return;
                }
                if (glinkedshape instanceof GLinkedLineIndexPossesive && !(glinkedshape instanceof GLogicGate) && (glinkedline = (glinkedlineindexpossesive = (GLinkedLineIndexPossesive)((Object)glinkedshape)).getLine(glinkedlineindex = glinkedlineindexpossesive.getDefaultLineIndex())) != null) {
                    this.startTarget = glinkedline;
                    this.startLineIndex = glinkedlineindex;
                    return;
                }
            }
            this.startTarget = glinktarget;
            this.startLinkPositionInfo = lpi;
            if (this.startLineIndex != null) {
                this.startLineIndex.line = lpi != null ? lpi.getPosition() : -1;
            }
        } else if (index == 1) {
            if (glinktarget instanceof GLink) {
                GLinkedLineIndex glinkedlineindex;
                GLinkedLineIndexPossesive glinkedlineindexpossesive;
                GLinkedLine glinkedline;
                GLinkedShape glinkedshape = ((GLink)glinktarget).getGLinkedShape();
                if (glinkedshape instanceof StateTransition || glinkedshape instanceof LinkedCreaseLineModification || glinkedshape instanceof LinkedCreaseLineMixedNotation || glinkedshape instanceof GLinkedLineComplex3) {
                    GLinkedLineIndex glinkedlineindex3 = new GLinkedLineIndex();
                    if (lpi != null) {
                        glinkedlineindex3.arm = lpi.getArm();
                        glinkedlineindex3.line = lpi.getPosition();
                    }
                    this.endLineIndex = glinkedlineindex3;
                    this.endTarget = glinktarget;
                    this.endLinkPositionInfo = lpi;
                    return;
                }
                if (glinkedshape instanceof GLinkedLineIndexPossesive && !(glinkedshape instanceof GLogicGate) && (glinkedline = (glinkedlineindexpossesive = (GLinkedLineIndexPossesive)((Object)glinkedshape)).getLine(glinkedlineindex = glinkedlineindexpossesive.getDefaultLineIndex())) != null) {
                    this.endTarget = glinkedline;
                    this.endLineIndex = glinkedlineindex;
                    return;
                }
            }
            this.endTarget = glinktarget;
            this.endLinkPositionInfo = lpi;
            if (this.endLineIndex != null) {
                this.endLineIndex.line = lpi != null ? lpi.getPosition() : -1;
            }
        } else {
            throw new Exception("Index must 0 or 1.");
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, double x, double y, GLinkPositionInfo lpi) throws Exception {
        if (index == 0) {
            GLinkedLineIndex glinkedlineindex = new GLinkedLineIndex();
            if (lpi != null) {
                glinkedlineindex.arm = lpi.getArm();
                glinkedlineindex.line = lpi.getPosition();
            }
            this.startLineIndex = glinkedlineindex;
            this.startTarget = glinktarget;
            this.startLinkPositionInfo = lpi;
            if (lpi != null && lpi.getPosition() < 0) {
                this.startLinkPositionInfo = null;
            }
        } else if (index == 1) {
            GLinkedLineIndex glinkedlineindex = new GLinkedLineIndex();
            if (lpi != null) {
                glinkedlineindex.arm = lpi.getArm();
                glinkedlineindex.line = lpi.getPosition();
            }
            this.endLineIndex = glinkedlineindex;
            this.endTarget = glinktarget;
            this.endLinkPositionInfo = lpi;
            if (lpi != null && lpi.getPosition() < 0) {
                this.endLinkPositionInfo = null;
            }
        } else {
            throw new Exception("Index must 0 or 1.");
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkedLineIndex glinkedlineindex) throws Exception {
        GLinkedLineIndex glnindex = new GLinkedLineIndex();
        glnindex.arm = -1;
        glnindex.line = -1;
        if (glinkedlineindex != null) {
            glnindex = glinkedlineindex;
        }
        if (index == 0) {
            GLinkPositionInfo lpi = new GLinkPositionInfo(-1, 0.0);
            lpi.setArm(glnindex.arm);
            lpi.setPosition(glnindex.line);
            this.startLineIndex = glnindex;
            this.startTarget = glinktarget;
            this.startLinkPositionInfo = lpi;
            return;
        }
        if (index == 1) {
            GLinkPositionInfo lpi = new GLinkPositionInfo(-1, 0.0);
            lpi.setArm(glnindex.arm);
            lpi.setPosition(glnindex.line);
            this.endLineIndex = glnindex;
            this.endTarget = glinktarget;
            this.endLinkPositionInfo = lpi;
            return;
        }
        throw new Exception("Index must 0 or 1.");
    }

    @Override
    public abstract Point2D.Double targetPoint();

    @Override
    public int targetSize() {
        return 2;
    }

    public abstract Rectangle2D.Double updateLine();

    @Override
    public final Rectangle2D.Double updateShape() {
        return this.updateShape(true);
    }

    public Rectangle2D.Double updateLine(boolean moveCreasePoints) {
        return this.updateLine();
    }

    @Override
    public final Rectangle2D.Double updateShape(boolean moveCreasePoints) {
        Rectangle2D.Double redrawArea = this.updateLine(moveCreasePoints);
        int i = 0;
        while (i < this.lineModifications.size()) {
            GLinkedLineModificationShape glinkedlinemodificationshape = (GLinkedLineModificationShape)this.lineModifications.elementAt(i);
            Rectangle2D.Double updateArea = glinkedlinemodificationshape.updateModification(this.start, this.end, this.getLineWidth());
            redrawArea = GUtil.union(redrawArea, updateArea);
            ++i;
        }
        if (this instanceof DirectSingleLine) {
            try {
                GAtomImpl ge;
                GFramedShape gfshp;
                GLinkTarget target = ((DirectSingleLine)this).getStartTarget();
                if (target != null && target instanceof GAtomImpl && (gfshp = (ge = (GAtomImpl)target).getGFramedShape()) instanceof MonoSpeciesShape) {
                    double frameWidth = ((MonoSpeciesShape)gfshp).getFrameBounds().width;
                    double frameHeight = ((MonoSpeciesShape)gfshp).getFrameBounds().height;
                    SpeciesSymbol sbm = ((MonoSpeciesShape)gfshp).getSpeciesSymbol();
                    if (sbm instanceof Tag) {
                        redrawArea = GUtil.union(redrawArea, ge.getBounds());
                        Tag tag = (Tag)sbm;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return redrawArea;
    }

    public int getArm() {
        return -1;
    }

    public void setArm(int arm) {
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        System.out.println("GLinkedLine:showLinkAnchors:not supported now.:" + this);
    }

    @Override
    public void hideLinkAnchors() {
        System.out.println("GLinkedLine:hideLinkAnchors:not supported now.:" + this);
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        throw new UnsupportedOperationException();
    }

    public GLinkPositionInfo getEndLinkPositionInfo() {
        return this.endLinkPositionInfo;
    }

    public GLinkPositionInfo getStartLinkPositionInfo() {
        return this.startLinkPositionInfo;
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        Point2D.Double repot = null;
        try {
            repot = this.getAnchorPointByIndex(lpi.getPosition());
        }
        catch (Exception myErr) {
            try {
                repot = this.getAnchorPointByIndex(-1);
            }
            catch (Exception myErr2) {
                repot = null;
            }
        }
        if (repot != null) {
            return repot;
        }
        double x1 = (this.start.x + this.end.x) * 0.5;
        double y1 = (this.start.y + this.end.y) * 0.5;
        return new Point2D.Double(x1, y1);
    }

    protected Point2D.Double getStartTargetPoint() {
        if (this.startLinkPositionInfo != null) {
            if (this.startLinkPositionInfo.getPosition() >= 0) {
                return this.startTarget.getCoordinatesOfLinkPosition(this.startLinkPositionInfo);
            }
            return this.startTarget.targetPoint();
        }
        return this.startTarget.targetPoint();
    }

    protected Point2D.Double getEndTargetPoint() {
        if (this.endLinkPositionInfo != null) {
            if (this.endLinkPositionInfo.getPosition() >= 0) {
                return this.endTarget.getCoordinatesOfLinkPosition(this.endLinkPositionInfo);
            }
            return this.endTarget.targetPoint();
        }
        return this.endTarget.targetPoint();
    }

    public static int getDefaultConnectPolicy() {
        return defaultConnectPolicy;
    }

    public static void setDefaultConnectPolicy(int policy) {
        defaultConnectPolicy = policy;
    }

    @Override
    public abstract Color getColor();

    @Override
    public abstract double getLineWidth();

    @Override
    public abstract void setColor(Color var1);

    @Override
    public abstract void setLineWidth(double var1);

    public abstract Point2D.Double getAnchorPointByIndex(int var1);

    public void setAddingObjectFlag(int flg) {
        this.addingObjectFlg = flg;
    }

    public int getAddingObjectFlag() {
        return this.addingObjectFlg;
    }

    @Override
    public int getLineType() {
        return 1;
    }

    @Override
    public void setLineType(int type) {
    }

    @Override
    public void setIsInSBGNViewer(boolean flag) {
        this.isInSBGNViewer = flag;
    }

    @Override
    public boolean isInSBGNViewer() {
        return this.isInSBGNViewer;
    }
}

