/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GCurvePointGenerator;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.CreasePoint;
import jp.sbi.celldesigner.LinkedCreaseLineForComplex3;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;

public class GLinkedCurveStartLine
extends GLinkedCurveAndLine
implements GCurvePointGenerator {
    public GLinkedCurveStartLine() {
        this.arrowShape = new GLinkedLineArrowShape();
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkPositionInfo lpi) throws Exception {
        super.setTargetAt(glinktarget, index, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, double x, double y, GLinkPositionInfo lpi) throws Exception {
        super.setTargetAt(glinktarget, index, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkedLineIndex glinkedlineindex) throws Exception {
        super.setTargetAt(glinktarget, index, glinkedlineindex);
    }

    @Override
    public int getLineType() {
        Shape shape = (Shape)this.lines.get(0);
        if (shape instanceof Line2D.Double) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setLineType(int type) {
        Shape shape = (Shape)this.lines.get(0);
        switch (type) {
            case 0: {
                if (!(shape instanceof Line2D.Double)) break;
                this.lines.setElementAt(new QuadCurve2D.Double(), 0);
                break;
            }
            case 1: {
                if (shape instanceof Line2D.Double) break;
                this.lines.setElementAt(new Line2D.Double(), 0);
            }
        }
    }

    @Override
    public Rectangle2D.Double updateLine() {
        int index;
        GLink glink;
        Rectangle2D.Double redrawArea = null;
        GLinkTarget stTarget = this.startTarget;
        if (stTarget == null) {
            return redrawArea;
        }
        GLinkTarget edTarget = this.endTarget;
        if (edTarget == null) {
            return redrawArea;
        }
        GLinkedShape shp = null;
        GLinkedLineComplex3 cmp3 = null;
        if (stTarget instanceof GLink) {
            glink = (GLink)stTarget;
            shp = glink.getGLinkedShape();
            if (shp instanceof GLinkedLineComplex3) {
                cmp3 = (GLinkedLineComplex3)shp;
            } else if (shp instanceof LinkedCreaseLineForComplex3) {
                cmp3 = ((LinkedCreaseLineForComplex3)shp).getcomplex3Parent();
            }
        }
        if (stTarget instanceof GLinkedLine) {
            GLinkedLine glinkedline = (GLinkedLine)stTarget;
            index = glinkedline.getCurveBindingIndex();
            this.curvePoint = index == 0 ? glinkedline.getEndPoint() : glinkedline.getStartPoint();
        } else if (cmp3 != null) {
            this.curvePoint = cmp3.getAddReactantAddProductCurvePoint(this);
        } else if (shp instanceof StateTransition) {
            StateTransition st = (StateTransition)shp;
            this.curvePoint = st.getAddReactantAddProductCurvePoint(this);
        } else if (stTarget instanceof GLink) {
            glink = (GLink)stTarget;
            index = glink.getCurveBindingIndex();
            index = index == 0 ? 1 : 0;
            try {
                GLinkTarget target = glink.getTargetAt(index);
                this.curvePoint = target.targetPoint();
            }
            catch (Exception exception) {
                return redrawArea;
            }
        } else {
            return redrawArea;
        }
        int iMax = this.lines.size() - 1;
        Point2D.Double point1 = this.end;
        if (iMax > 0) {
            point1 = ((GCreasePoint)this.creasePoints.elementAt(0)).getPosition();
        }
        if (this.getLineType() == 1) {
            this.linkPoint.setPosition((point1.x + this.start.x) / 2.0, (point1.y + this.start.y) / 2.0);
        } else {
            this.linkPoint.setPosition((point1.x + this.curvePoint.x) / 2.0, (point1.y + this.curvePoint.y) / 2.0);
        }
        Point2D.Double linkPosition = this.linkPoint.getPosition();
        int i = 0;
        while (i <= iMax) {
            Shape shape = (Shape)this.lines.get(i);
            if (shape instanceof Line2D.Double) {
                Line2D.Double line = (Line2D.Double)shape;
                if (i == iMax) {
                    GLinkTarget sTarget = stTarget;
                    GLinkPositionInfo sLinkPositionInfo = this.startLinkPositionInfo;
                    if (i > 0) {
                        sTarget = (GLinkTarget)this.creasePoints.elementAt(i - 1);
                        sLinkPositionInfo = null;
                    }
                    Line2D.Double whiteLine = new Line2D.Double();
                    Rectangle2D.Double sideBounds = GLinkedCurveStartLine.refine2Lines(sTarget, sLinkPositionInfo, this.endTarget, this.endLinkPositionInfo, this.lineWidth, this.offsetX, this.offsetY, line, whiteLine);
                    this.sideWhiteLine = whiteLine;
                    redrawArea = GUtil.union(redrawArea, sideBounds);
                    Point2D.Double p1 = new Point2D.Double(line.x1, line.y1);
                    Point2D.Double p2 = new Point2D.Double(line.x2, line.y2);
                    Rectangle2D.Double arrowArea = this.arrowShape.updateModification(p1, p2, this.lineWidth);
                    redrawArea = GUtil.union(redrawArea, arrowArea);
                    line = this.arrowShape.modifyLine(line);
                    this.lines.setElementAt(line, i);
                } else {
                    Point2D.Double p1 = this.start;
                    if (i > 0) {
                        p1 = ((GCreasePoint)this.creasePoints.elementAt(i - 1)).getPosition();
                    }
                    Point2D.Double p2 = ((GCreasePoint)this.creasePoints.elementAt(i)).getPosition();
                    line.x1 = p1.x;
                    line.y1 = p1.y;
                    line.x2 = p2.x;
                    line.y2 = p2.y;
                    redrawArea = GUtil.union(redrawArea, line.getBounds2D());
                }
            } else if (i == 0) {
                Line2D.Double line1 = new Line2D.Double(linkPosition.x, linkPosition.y, point1.x, point1.y);
                Line2D.Double whiteLine1 = new Line2D.Double(point1.x, point1.y, linkPosition.x, linkPosition.y);
                if (i == iMax) {
                    CreasePoint sTarget = new CreasePoint();
                    this.moveEditPoint(sTarget, linkPosition.x, linkPosition.y);
                    Rectangle2D.Double sideBounds = GLinkedCurveStartLine.refine2Lines(sTarget, null, this.endTarget, this.endLinkPositionInfo, this.lineWidth, this.offsetX, this.offsetY, line1, whiteLine1);
                    redrawArea = GUtil.union(redrawArea, sideBounds);
                    Point2D.Double p1 = new Point2D.Double(line1.x1, line1.y1);
                    Point2D.Double p2 = new Point2D.Double(line1.x2, line1.y2);
                    Rectangle2D.Double arrowArea = this.arrowShape.updateModification(p1, p2, this.lineWidth);
                    redrawArea = GUtil.union(redrawArea, arrowArea);
                    line1 = this.arrowShape.modifyLine(line1);
                }
                QuadCurve2D.Double quad = new QuadCurve2D.Double();
                quad.setCurve(this.start, this.curvePoint, linkPosition);
                GeneralPath curvePath = new GeneralPath(quad);
                curvePath.append(line1, true);
                this.lines.removeElementAt(i);
                this.lines.insertElementAt(curvePath, i);
                redrawArea = GUtil.union(redrawArea, curvePath.getBounds2D());
                if (i == iMax) {
                    this.sideWhiteLine = new GeneralPath(quad);
                    ((GeneralPath)this.sideWhiteLine).append(whiteLine1, true);
                }
                if (Line2D.Double.ptLineDist(this.start.x, this.start.y, point1.x, point1.y, this.curvePoint.x, this.curvePoint.y) < 1.0) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo((float)this.start.x - 1.0f, (float)this.start.y - 1.0f);
                    path.lineTo((float)point1.x - 1.0f, (float)point1.y - 1.0f);
                    path.lineTo((float)this.curvePoint.x - 1.0f, (float)this.curvePoint.y - 1.0f);
                    path.lineTo((float)this.curvePoint.x + 1.0f, (float)this.curvePoint.y + 3.0f);
                    path.lineTo((float)point1.x + 2.0f, (float)point1.y + 1.0f);
                    path.moveTo((float)this.start.x + 1.0f, (float)this.start.y + 2.0f);
                    path.closePath();
                    this.curveArea = new Area(path);
                } else {
                    double dx = (this.start.x + linkPosition.x) / 2.0 - this.curvePoint.x;
                    double dy = (this.start.y + linkPosition.y) / 2.0 - this.curvePoint.y;
                    double dd = Math.pow(dx * dx + dy * dy, 0.5);
                    if (dd == 0.0) {
                        this.curveArea = new Area();
                    } else {
                        dx = 3.0 * dx / dd;
                        dy = 3.0 * dy / dd;
                        Line2D.Double auxLine1 = new Line2D.Double(linkPosition.x + dx, linkPosition.y + dy, point1.x + dx, point1.y + dy);
                        QuadCurve2D.Double auxQuad = new QuadCurve2D.Double(this.start.x + dx, this.start.y + dy, this.curvePoint.x + dx, this.curvePoint.y + dy, linkPosition.x + dx, linkPosition.y + dy);
                        GeneralPath auxCurvePath = new GeneralPath(auxQuad);
                        auxCurvePath.append(auxLine1, true);
                        this.curveArea = new Area(curvePath);
                        this.curveArea.subtract(new Area(auxCurvePath));
                    }
                }
            }
            ++i;
        }
        i = 0;
        int iMax2 = this.creasePoints.size();
        while (i < iMax2) {
            redrawArea = this.updateCreasePoint(redrawArea, false, (GEditPoint)this.creasePoints.elementAt(i));
            ++i;
        }
        this.bounds = new Rectangle2D.Double(redrawArea.x, redrawArea.y, redrawArea.width, redrawArea.height);
        redrawArea = this.updateStartEndRect(redrawArea);
        return redrawArea;
    }

    @Override
    public void drawBaseWhiteLine(Graphics2D graphics2d) {
        int i = 0;
        int iMax = this.lines.size() - 2;
        while (i <= iMax) {
            graphics2d.draw((Shape)this.lines.elementAt(i));
            ++i;
        }
        graphics2d.draw(this.sideWhiteLine);
    }
}

