/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GCurvePointGenerator;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GUtil;

public class GLinkedCurveLine
extends GLinkedLine {
    QuadCurve2D.Double quad = null;
    Rectangle2D.Double bounds = null;
    private Point2D.Double control = null;
    GCurvePointGenerator cpg = null;
    protected Color color = new Color(0, 0, 0);
    protected double lineWidth = 1.0;

    public GLinkedCurveLine() {
    }

    public GLinkedCurveLine(GCurvePointGenerator gcurvepointgenerator) {
        this.cpg = gcurvepointgenerator;
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedCurveLine copy = null;
        try {
            copy = (GLinkedCurveLine)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return copy;
        }
        copy.setGCurvePointGenerator(this.cpg);
        return copy;
    }

    @Override
    public void drawBaseWhiteLine(Graphics2D graphics2d) {
        if (this.quad != null) {
            graphics2d.draw(this.quad);
        }
    }

    @Override
    public void drawLine(Graphics2D graphics2d) {
        if (this.quad != null) {
            graphics2d.draw(this.quad);
        }
    }

    @Override
    public Rectangle2D.Double getLineBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public boolean inLine(double x, double y) {
        if (this.quad == null) {
            return false;
        }
        double expansion = 3.0;
        Rectangle2D.Double area = new Rectangle2D.Double(x - 3.0, y - 3.0, 6.0, 6.0);
        return this.quad.intersects(area);
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        return false;
    }

    public void setGCurvePointGenerator(GCurvePointGenerator gcurvepointgenerator) {
        this.cpg = gcurvepointgenerator;
    }

    @Override
    public Point2D.Double targetPoint() {
        return null;
    }

    @Override
    public Rectangle2D.Double updateLine() {
        Rectangle2D.Double redrawArea = this.bounds;
        Point2D.Double[] startAndEnd = GLinkedStraightLine.calcStartAndEnd(this.startTarget, this.startLinkPositionInfo, this.endTarget, this.endLinkPositionInfo, this.offsetX, this.offsetY);
        if (startAndEnd[0] == null || startAndEnd[1] == null) {
            return redrawArea;
        }
        this.start = startAndEnd[0];
        this.end = startAndEnd[1];
        this.control = this.cpg != null ? this.cpg.getCurvePoint() : new Point2D.Double((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
        if (this.control == null) {
            this.control = new Point2D.Double((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
        }
        if (this.quad == null) {
            this.quad = new QuadCurve2D.Double();
        }
        this.quad.setCurve(this.start, this.control, this.end);
        this.bounds = (Rectangle2D.Double)this.quad.getBounds2D();
        this.bounds.x -= this.lineWidth / 2.0;
        this.bounds.y -= this.lineWidth / 2.0;
        this.bounds.height += this.lineWidth;
        this.bounds.width += this.lineWidth;
        if (redrawArea == null) {
            return this.bounds;
        }
        if (redrawArea.equals(this.bounds)) {
            return null;
        }
        return GUtil.union(redrawArea, this.bounds);
    }

    @Override
    public int getTargetIndex(GEditPoint ep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        throw new RuntimeException();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public void setupAfterAllTargetsSetted() {
    }

    @Override
    public Point2D.Double getAnchorPointByIndex(int index) {
        return null;
    }
}

