/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GCurvePointGenerator;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.CreasePoint;
import jp.sbi.celldesigner.LinkedCreaseLineForComplex3;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;

public class GLinkedCurveEndLine
extends GLinkedCurveAndLine
implements GCurvePointGenerator {
    @Override
    public void setTargetAt(GLinkTarget glinktarget, int i, GLinkPositionInfo lpi) throws Exception {
        super.setTargetAt(glinktarget, i, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int i, double x, double y, GLinkPositionInfo lpi) throws Exception {
        super.setTargetAt(glinktarget, i, lpi);
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int i, GLinkedLineIndex glinkedlineindex) throws Exception {
        super.setTargetAt(glinktarget, i, glinkedlineindex);
    }

    @Override
    public int getLineType() {
        Shape shape = (Shape)this.lines.get(this.lines.size() - 1);
        if (shape instanceof Line2D.Double) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setLineType(int type) {
        Shape shape = (Shape)this.lines.get(this.lines.size() - 1);
        switch (type) {
            case 0: {
                if (!(shape instanceof Line2D.Double)) break;
                this.lines.setElementAt(new QuadCurve2D.Double(), this.lines.size() - 1);
                break;
            }
            case 1: {
                if (shape instanceof Line2D.Double) break;
                this.lines.setElementAt(new Line2D.Double(), this.lines.size() - 1);
            }
        }
    }

    @Override
    public Rectangle2D.Double updateLine() {
        int i;
        GLink glink;
        Rectangle2D.Double newBounds = null;
        GLinkTarget edTarget = this.endTarget;
        if (edTarget == null) {
            return newBounds;
        }
        GLinkTarget stTarget = this.startTarget;
        if (stTarget == null) {
            return newBounds;
        }
        GLinkedShape shp = null;
        GLinkedLineComplex3 cmp3 = null;
        if (edTarget instanceof GLink) {
            glink = (GLink)edTarget;
            shp = glink.getGLinkedShape();
            if (shp instanceof GLinkedLineComplex3) {
                cmp3 = (GLinkedLineComplex3)shp;
            } else if (shp instanceof LinkedCreaseLineForComplex3) {
                cmp3 = ((LinkedCreaseLineForComplex3)shp).getcomplex3Parent();
            }
        }
        if (edTarget instanceof GLinkedLine) {
            GLinkedLine glinkedline = (GLinkedLine)edTarget;
            i = glinkedline.getCurveBindingIndex();
            this.curvePoint = i == 0 ? glinkedline.getStartPoint() : glinkedline.getEndPoint();
        } else if (cmp3 != null) {
            this.curvePoint = cmp3.getAddReactantAddProductCurvePoint(this);
        } else if (shp instanceof StateTransition) {
            StateTransition st = (StateTransition)shp;
            this.curvePoint = st.getAddReactantAddProductCurvePoint(this);
        } else if (edTarget instanceof GLink) {
            glink = (GLink)edTarget;
            i = glink.getCurveBindingIndex();
            try {
                GLinkTarget tg = glink.getTargetAt(i);
                this.curvePoint = tg.targetPoint();
            }
            catch (Exception exception) {
                return newBounds;
            }
        } else {
            return newBounds;
        }
        int iMax = this.lines.size() - 1;
        Point2D.Double point1 = this.start;
        if (iMax > 0) {
            point1 = ((GCreasePoint)this.creasePoints.elementAt(iMax - 1)).getPosition();
        }
        if (this.getLineType() == 1) {
            this.linkPoint.setPosition((point1.x + this.end.x) / 2.0, (point1.y + this.end.y) / 2.0);
        } else {
            this.linkPoint.setPosition((point1.x + this.curvePoint.x) / 2.0, (point1.y + this.curvePoint.y) / 2.0);
        }
        Point2D.Double linkPosition = this.linkPoint.getPosition();
        int i2 = 0;
        while (i2 <= iMax) {
            Shape shape = (Shape)this.lines.get(i2);
            if (shape instanceof Line2D.Double) {
                Line2D.Double line = (Line2D.Double)shape;
                if (i2 == 0) {
                    GLinkTarget eTarget = this.endTarget;
                    GLinkPositionInfo eLinkPositionInfo = this.endLinkPositionInfo;
                    if (i2 < iMax) {
                        eTarget = (GLinkTarget)this.creasePoints.elementAt(i2);
                        eLinkPositionInfo = null;
                    }
                    Line2D.Double whiteLine = new Line2D.Double();
                    Rectangle2D.Double sideBounds = GLinkedCurveEndLine.refine2Lines(this.startTarget, this.startLinkPositionInfo, eTarget, eLinkPositionInfo, this.lineWidth, this.offsetX, this.offsetY, line, whiteLine);
                    this.sideWhiteLine = whiteLine;
                    newBounds = GUtil.union(newBounds, sideBounds);
                } else {
                    Point2D.Double p1 = ((GCreasePoint)this.creasePoints.elementAt(i2 - 1)).getPosition();
                    Point2D.Double p2 = this.end;
                    if (i2 < iMax) {
                        p2 = ((GCreasePoint)this.creasePoints.elementAt(i2)).getPosition();
                    }
                    line.x1 = p1.x;
                    line.y1 = p1.y;
                    line.x2 = p2.x;
                    line.y2 = p2.y;
                    newBounds = GUtil.union(newBounds, line.getBounds2D());
                }
            } else if (i2 == iMax) {
                Line2D.Double line2 = new Line2D.Double(point1.x, point1.y, linkPosition.x, linkPosition.y);
                Line2D.Double whiteLine2 = new Line2D.Double(point1.x, point1.y, linkPosition.x, linkPosition.y);
                if (i2 == 0) {
                    CreasePoint eTarget = new CreasePoint();
                    this.moveEditPoint(eTarget, linkPosition.x, linkPosition.y);
                    Rectangle2D.Double sideBounds = GLinkedCurveEndLine.refine2Lines(this.startTarget, this.startLinkPositionInfo, eTarget, null, this.lineWidth, this.offsetX, this.offsetY, line2, whiteLine2);
                    newBounds = GUtil.union(newBounds, sideBounds);
                }
                QuadCurve2D.Double quad = new QuadCurve2D.Double();
                quad.setCurve(linkPosition, this.curvePoint, this.end);
                GeneralPath curvePath = new GeneralPath(line2);
                curvePath.append(quad, true);
                this.lines.removeElementAt(i2);
                this.lines.insertElementAt(curvePath, i2);
                newBounds = GUtil.union(newBounds, curvePath.getBounds2D());
                if (i2 == 0) {
                    this.sideWhiteLine = new GeneralPath(whiteLine2);
                    ((GeneralPath)this.sideWhiteLine).append(quad, true);
                }
                if (Line2D.Double.ptLineDist(point1.x, point1.y, this.end.x, this.end.y, this.curvePoint.x, this.curvePoint.y) < 1.0) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo((float)point1.x - 1.0f, (float)point1.y - 1.0f);
                    path.lineTo((float)this.end.x - 1.0f, (float)this.end.y - 1.0f);
                    path.lineTo((float)this.curvePoint.x - 1.0f, (float)this.curvePoint.y - 1.0f);
                    path.lineTo((float)this.curvePoint.x + 1.0f, (float)this.curvePoint.y + 3.0f);
                    path.lineTo((float)this.end.x + 2.0f, (float)this.end.y + 1.0f);
                    path.moveTo((float)point1.x + 1.0f, (float)point1.y + 2.0f);
                    path.closePath();
                    this.curveArea = new Area(path);
                } else {
                    double dx = (linkPosition.x + this.end.x) / 2.0 - this.curvePoint.x;
                    double dy = (linkPosition.y + this.end.y) / 2.0 - this.curvePoint.y;
                    double dd = Math.pow(dx * dx + dy * dy, 0.5);
                    if (dd == 0.0) {
                        this.curveArea = new Area();
                    } else {
                        dx = 3.0 * dx / dd;
                        dy = 3.0 * dy / dd;
                        Line2D.Double auxLine2 = new Line2D.Double(point1.x + dx, point1.y + dy, linkPosition.x + dx, linkPosition.y + dy);
                        QuadCurve2D.Double auxQuad = new QuadCurve2D.Double(linkPosition.x + dx, linkPosition.y + dy, this.curvePoint.x + dx, this.curvePoint.y + dy, this.end.x + dx, this.end.y + dy);
                        GeneralPath auxCurvePath = new GeneralPath(auxLine2);
                        auxCurvePath.append(auxQuad, true);
                        this.curveArea = new Area(curvePath);
                        this.curveArea.subtract(new Area(auxCurvePath));
                    }
                }
            }
            ++i2;
        }
        this.bounds = new Rectangle2D.Double(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
        newBounds = this.updateStartEndRect(newBounds);
        return newBounds;
    }

    @Override
    public void drawBaseWhiteLine(Graphics2D graphics2d) {
        graphics2d.draw(this.sideWhiteLine);
        int i = 1;
        int iMax = this.lines.size() - 1;
        while (i <= iMax) {
            graphics2d.draw((Shape)this.lines.elementAt(i));
            ++i;
        }
    }
}

