/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jp.fric.graphics.draw.ElementAndPosition;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GCreasePointForUndo;
import jp.fric.graphics.draw.GCurvePointGenerator;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkPoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveEndLine;
import jp.fric.graphics.draw.GLinkedCurveStartLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineArrowShape;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.CreasePoint;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.symbol.reaction.GModificationRectangle;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;

public abstract class GLinkedCurveAndLine
extends GLinkedLine
implements GEditable,
GCurvePointGenerator,
GLinkConnectSchemeOwner {
    public static final int UNDEFINED_DIRECTION = 0;
    public static final int VERTICAL_DIRECTION = 1;
    public static final int HORIZONTAL_DIRECTION = 2;
    private static final int NEXT_POINT_DISTANCE = 15;
    protected static double eps = 0.001;
    protected static final double eps1 = 0.5;
    protected Color color = new Color(0, 0, 0);
    protected double lineWidth = 1.0;
    protected boolean active = false;
    protected Vector<GCreasePoint> creasePoints;
    protected GLinkedLineArrowShape arrowShape = null;
    protected GLinkPoint linkPoint;
    protected Point2D.Double curvePoint;
    protected int connectPolicy;
    private int firstDirection;
    protected Vector<Shape> lines;
    protected Shape sideWhiteLine;
    protected Area curveArea;
    protected Rectangle2D.Double bounds = null;
    private GLinkHandlePoint sHandlePoint = new GLinkHandlePoint();
    private GLinkHandlePoint eHandlePoint = new GLinkHandlePoint();

    public GLinkedCurveAndLine() {
        this.connectPolicy = GLinkedCurveAndLine.getDefaultConnectPolicy();
        this.lines = new Vector();
        this.creasePoints = new Vector();
        this.lines.add(new Line2D.Double());
        this.firstDirection = 0;
        this.curveArea = new Area();
        this.sideWhiteLine = new Line2D.Double();
        this.sHandlePoint.setOwner(this);
        this.eHandlePoint.setOwner(this);
        this.linkPoint = new GLinkPoint();
        this.curvePoint = new Point2D.Double();
    }

    @Override
    public void resetCreaseLineNumber(int newCreaseLineNumber) {
        if (this.startTarget == null || this.endTarget == null) {
            return;
        }
        if (this.startLinkPositionInfo == null) {
            this.startLinkPositionInfo = this instanceof GLinkedCurveStartLine ? new GLinkPositionInfo(-1, 1.0) : new GLinkPositionInfo(-1, 0.0);
            this.startLinkPositionInfo.setElement((GElement)((Object)this.startTarget));
        }
        try {
            if (this.start == null) {
                this.start = this.startTarget.getCoordinatesOfLinkPosition(this.startLinkPositionInfo);
            }
            if (this.end == null) {
                this.end = this.endTarget.getCoordinatesOfLinkPosition(this.endLinkPositionInfo);
            }
        }
        catch (Exception myErr) {
            return;
        }
        this.creasePoints.clear();
        int type = this.getLineType();
        this.lines.clear();
        this.lines.add(new Line2D.Double());
        if (this.connectPolicy == 1) {
            Point2D.Double[] posArray = this.getInitialCreasePointPositionForSquare(true);
            int i = 0;
            while (i < posArray.length) {
                Point2D.Double pos = posArray[i];
                this.lines.add(new Line2D.Double());
                CreasePoint creasePoint = new CreasePoint();
                creasePoint.setOwner(this);
                this.moveEditPoint(creasePoint, pos.x, pos.y);
                this.creasePoints.add(creasePoint);
                ++i;
            }
            this.initLinesDirection();
        } else {
            double dx = (this.end.x - this.start.x) / (double)newCreaseLineNumber;
            double dy = (this.end.y - this.start.y) / (double)newCreaseLineNumber;
            int i = 0;
            while (i < newCreaseLineNumber - 1) {
                this.lines.add(new Line2D.Double());
                CreasePoint creasePoint = new CreasePoint();
                creasePoint.setOwner(this);
                Point2D.Double pos = new Point2D.Double(this.start.x + dx * (double)(i + 1), this.start.y + dy * (double)(i + 1));
                this.moveEditPoint(creasePoint, pos.x, pos.y);
                this.creasePoints.add(creasePoint);
                ++i;
            }
        }
        this.setLineType(type);
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedCurveAndLine copy = null;
        try {
            copy = (GLinkedCurveAndLine)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return copy;
        }
        copy.setCurveBindingIndex(this.getCurveBindingIndex());
        GEditPoint[] geditpoints = this.getEditPoints();
        int i = 0;
        while (i < geditpoints.length) {
            CreasePoint creasePoint = new CreasePoint();
            creasePoint.setOwner(copy);
            creasePoint.setLocalPosition(geditpoints[i].getLocalPosition());
            creasePoint.setPosition(new Point2D.Double());
            copy.creasePoints.add(creasePoint);
            copy.lines.add(new Line2D.Double());
            ++i;
        }
        copy.firstDirection = this.firstDirection;
        if (copy.getConnectPolicy() != this.getConnectPolicy()) {
            copy.setConnectPolicy(this.getConnectPolicy());
        }
        if (copy.getLineType() != this.getLineType()) {
            copy.setLineType(this.getLineType());
        }
        return copy;
    }

    @Override
    public void drawBaseWhiteLine(Graphics2D graphics2d) {
        int i = 0;
        int iMax = this.lines.size() - 1;
        while (i <= iMax) {
            graphics2d.draw(this.lines.elementAt(i));
            ++i;
        }
    }

    @Override
    public void drawLine(Graphics2D graphics2d) {
        Color org_color = graphics2d.getColor();
        if (org_color != GColor.HIGHLIGHTED_COLOR) {
            graphics2d.setColor(this.getColor());
        }
        RenderingHints renderinghints = null;
        if (this.isAntiAliasON) {
            renderinghints = graphics2d.getRenderingHints();
            graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        BasicStroke org_stroke = (BasicStroke)graphics2d.getStroke();
        int i = 0;
        int iMax = this.lines.size();
        while (i < iMax) {
            if (org_stroke.getDashArray() == null && (i == 0 || i == this.lines.size() - 1)) {
                BasicStroke tmp_stroke = new BasicStroke((float)this.lineWidth, 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
                graphics2d.setStroke(tmp_stroke);
            }
            graphics2d.draw(this.lines.elementAt(i));
            ++i;
        }
        if (this.arrowShape != null) {
            this.arrowShape.drawModification(graphics2d);
        }
        i = 0;
        iMax = this.creasePoints.size();
        while (i < iMax) {
            this.creasePoints.elementAt(i).draw(graphics2d);
            ++i;
        }
        this.sHandlePoint.draw(graphics2d);
        this.eHandlePoint.draw(graphics2d);
        graphics2d.setColor(org_color);
        if (this.isAntiAliasON) {
            graphics2d.setRenderingHints(renderinghints);
        }
        graphics2d.setStroke(org_stroke);
    }

    @Override
    public Point2D.Double getCurvePoint() {
        return this.curvePoint;
    }

    public int getLineDirectionAt(int index) {
        if (index < 0 || index >= this.lines.size() || this.firstDirection == 0) {
            return 0;
        }
        if (index % 2 == 0) {
            return this.firstDirection;
        }
        if (this.firstDirection == 1) {
            return 2;
        }
        return 1;
    }

    @Override
    public Rectangle2D.Double getLineBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    public Point2D.Double getLinkPoint() {
        return (Point2D.Double)this.linkPoint.getPosition().clone();
    }

    @Override
    public int getConnectPolicy() {
        return this.connectPolicy;
    }

    @Override
    public void setConnectPolicy(int connectPolicy) {
        this.connectPolicy = connectPolicy;
    }

    @Override
    public boolean inLine(double x, double y) {
        double extention = 4.0;
        Rectangle2D.Double area = new Rectangle2D.Double(x - 4.0, y - 4.0, 8.0, 8.0);
        int i = 0;
        int iMax = this.lines.size();
        while (i < iMax) {
            Shape line = this.lines.elementAt(i);
            if (line instanceof Line2D.Double ? line.intersects(area) : this.curveArea.intersects(area)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        return false;
    }

    @Override
    public Point2D.Double targetPoint() {
        return this.curvePoint;
    }

    @Override
    public void activateEditPoints(boolean val) {
        this.active = val;
        this.sHandlePoint.setActive(val);
        this.eHandlePoint.setActive(val);
        int i = 0;
        int iMax = this.creasePoints.size();
        while (i < iMax) {
            this.creasePoints.get(i).setActive(val);
            ++i;
        }
    }

    @Override
    public boolean contains(GEditPoint editpoint) {
        if (this.sHandlePoint == editpoint || this.eHandlePoint == editpoint) {
            return true;
        }
        for (GCreasePoint p : this.creasePoints) {
            if (p != editpoint) continue;
            return true;
        }
        return false;
    }

    @Override
    public GEditPoint getEditPoint(double x, double y) {
        if (this.sHandlePoint.inShape(x, y)) {
            return this.sHandlePoint;
        }
        if (this.eHandlePoint.inShape(x, y)) {
            return this.eHandlePoint;
        }
        for (GCreasePoint p : this.creasePoints) {
            if (!p.inShape(x, y)) continue;
            return p;
        }
        return null;
    }

    public int getCreasePointsSize() {
        return this.creasePoints.size();
    }

    @Override
    public GEditPoint[] getEditPoints() {
        return this.creasePoints.toArray(new GCreasePoint[this.creasePoints.size()]);
    }

    public void setEditPoints(GEditPoint[] editPoints) {
        this.creasePoints.clear();
        int type = this.getLineType();
        this.lines.clear();
        this.lines.add(new Line2D.Double());
        int i = 0;
        int iMax = editPoints.length;
        while (i < iMax) {
            editPoints[i].setOwner(this);
            this.creasePoints.addElement((GCreasePoint)editPoints[i]);
            this.lines.add(new Line2D.Double());
            ++i;
        }
        this.setLineType(type);
    }

    @Override
    public boolean isMovable() {
        return this.creasePoints.size() > 0;
    }

    @Override
    public Rectangle2D.Double moveEditPoint(GEditPoint geditpoint, double x, double y) {
        Rectangle2D.Double redrawArea = null;
        try {
            Point2D.Double pos = new Point2D.Double();
            AffineTransform localAT = new AffineTransform();
            GUtil.createLocalTransform(this.start, this.end, localAT);
            AffineTransform inverse = localAT.createInverse();
            inverse.transform(new Point2D.Double(x, y), pos);
            geditpoint.setLocalPosition(pos);
            geditpoint.setPosition(new Point2D.Double(x, y));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return redrawArea;
    }

    @Override
    public abstract Rectangle2D.Double updateLine();

    @Override
    public Rectangle2D.Double updateLine(boolean moveCreasePoints) {
        Rectangle2D.Double newBounds = null;
        this.start = this.getStartTargetPoint();
        this.end = this.getEndTargetPoint();
        if (this.connectPolicy == 1 && !moveCreasePoints && this.lines.size() > 0 && this.creasePoints.size() > 0) {
            int add = this.lines.size() - 1;
            if (add <= 0) {
                add = 1;
            }
            int i = 0;
            while (i < this.lines.size()) {
                Point2D.Double p;
                Point2D.Double p0;
                int dir = this.getLineDirectionAt(i);
                int ip = i == 0 ? i : i - 1;
                Point2D.Double double_ = p0 = i == 0 ? this.start : this.end;
                if (dir == 2) {
                    p = this.creasePoints.get(ip).getPosition();
                    p.y = p0.y;
                } else if (dir == 1) {
                    p = this.creasePoints.get(ip).getPosition();
                    p.x = p0.x;
                }
                i += add;
            }
        }
        for (GCreasePoint creasePoint : this.creasePoints) {
            newBounds = this.updateCreasePoint(newBounds, moveCreasePoints, creasePoint);
        }
        newBounds = GUtil.union(newBounds, this.updateLine());
        return newBounds;
    }

    protected Rectangle2D.Double updateCreasePoint(Rectangle2D.Double newBounds, boolean moveCreasePoints, GEditPoint ep) {
        Point2D.Double localPos1;
        AffineTransform localAT = new AffineTransform();
        GUtil.createLocalTransform(this.start, this.end, localAT);
        Point2D.Double pos1 = ep.getPosition();
        if (moveCreasePoints) {
            localPos1 = ep.getLocalPosition();
            localAT.transform(localPos1, pos1);
        } else {
            localPos1 = new Point2D.Double();
            try {
                AffineTransform inverse = localAT.createInverse();
                inverse.transform(pos1, localPos1);
                ep.setLocalPosition(localPos1);
            }
            catch (NoninvertibleTransformException inverse) {
                // empty catch block
            }
        }
        Rectangle2D var_double_16_ = ep.update();
        Rectangle2D.Double var_double_17_ = ep.getBounds();
        this.bounds = GUtil.union(this.bounds, var_double_17_);
        newBounds = GUtil.union(newBounds, var_double_16_);
        return newBounds;
    }

    protected Rectangle2D.Double updateStartEndRect(Rectangle2D.Double newBounds) {
        if (this.startTarget != null && this.endTarget != null) {
            Point2D.Double pos1 = this.getStartTargetPoint();
            this.sHandlePoint.setPosition(new Point2D.Double(pos1.x, pos1.y));
            newBounds = this.updateCreasePoint(newBounds, false, this.sHandlePoint);
            pos1 = this.getEndTargetPoint();
            this.eHandlePoint.setPosition(new Point2D.Double(pos1.x, pos1.y));
            newBounds = this.updateCreasePoint(newBounds, false, this.eHandlePoint);
        }
        return newBounds;
    }

    @Override
    public int getTargetIndex(GEditPoint ep) {
        if (this.sHandlePoint == ep) {
            return 0;
        }
        if (this.eHandlePoint == ep) {
            return 1;
        }
        throw new RuntimeException();
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        if (i == 0) {
            return this.startLinkPositionInfo;
        }
        if (i == 1) {
            return this.endLinkPositionInfo;
        }
        throw new RuntimeException();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    private int getCreasePointIndex(GEditPoint ep) {
        int i = 0;
        int iMax = this.creasePoints.size();
        while (i < iMax) {
            if (this.creasePoints.get(i) == ep) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void restrictEditPointMoveVector(GEditPoint ep1, GEditPoint ep2, Point2D.Double dxdy) {
        if (this.connectPolicy != 1) {
            return;
        }
        int n = this.creasePoints.size();
        int i1 = this.getCreasePointIndex(ep1);
        if (n <= 0 || i1 < 0) {
            return;
        }
        if (ep2 == null) {
            int dir;
            if (i1 == 0) {
                dir = this.getLineDirectionAt(0);
                if (dir == 2) {
                    dxdy.y = 0.0;
                } else if (dir == 1) {
                    dxdy.x = 0.0;
                }
            }
            if (i1 == n - 1) {
                dir = this.getLineDirectionAt(n);
                if (dir == 2) {
                    dxdy.y = 0.0;
                } else if (dir == 1) {
                    dxdy.x = 0.0;
                }
            }
        } else {
            int i2 = this.getCreasePointIndex(ep2);
            if (i2 < 0) {
                return;
            }
            int dir = 0;
            if (i2 == i1 + 1) {
                dir = this.getLineDirectionAt(i2);
            } else if (i1 == i2 + 1) {
                dir = this.getLineDirectionAt(i1);
            } else {
                return;
            }
            if (dir == 2) {
                dxdy.x = 0.0;
            } else if (dir == 1) {
                dxdy.y = 0.0;
            }
        }
    }

    @Override
    public void appendMovingPointAndPosition(GEditPoint ep1, Vector startXYVec) {
        int i1 = this.getCreasePointIndex(ep1);
        startXYVec.addElement(new ElementAndPosition(ep1, i1, ep1.getPosition()));
    }

    @Override
    public void appendAdditionalMovingPointAndPosition(GEditPoint ep1, Vector startXYVec) {
        GCreasePoint p;
        if (this.connectPolicy != 1) {
            return;
        }
        int n = this.creasePoints.size();
        int i1 = this.getCreasePointIndex(ep1);
        if (n <= 0 || i1 < 0) {
            return;
        }
        if (i1 > 0) {
            p = this.creasePoints.get(i1 - 1);
            startXYVec.addElement(new ElementAndPosition(p, i1 - 1, p.getPosition()));
        }
        if (i1 < n - 1) {
            p = this.creasePoints.get(i1 + 1);
            startXYVec.addElement(new ElementAndPosition(p, i1 + 1, p.getPosition()));
        }
    }

    @Override
    public Vector setMovedElementPosition(double dx, double dy, Vector startXYVec) {
        if (this.connectPolicy != 1) {
            return GLinkedCreaseLine.setMovedElementPositionDefault(dx, dy, startXYVec);
        }
        int n = startXYVec.size();
        Vector<Point2D.Double> posvec = new Vector<Point2D.Double>(n);
        double x0 = 0.0;
        double y0 = 0.0;
        int i0 = 0;
        int creasePointsSize = this.creasePoints.size();
        int i = 0;
        while (i < n) {
            ElementAndPosition eap = (ElementAndPosition)startXYVec.elementAt(i);
            double newx = 0.0;
            double newy = 0.0;
            if (i == 0) {
                x0 = eap.getX();
                y0 = eap.getY();
                i0 = eap.getIndex();
                newx = x0 + dx;
                newy = y0 + dy;
            } else {
                double x = eap.getX();
                double y = eap.getY();
                int i1 = eap.getIndex();
                boolean setted = false;
                if (i0 >= 0 && i0 < creasePointsSize && i1 >= 0 && i1 < creasePointsSize) {
                    int dir = i1 == i0 + 1 ? this.getLineDirectionAt(i1) : (i0 == i1 + 1 ? this.getLineDirectionAt(i0) : 0);
                    if (dir == 2) {
                        newx = x;
                        newy = y0 + dy;
                        setted = true;
                    } else if (dir == 1) {
                        newx = x0 + dx;
                        newy = y;
                        setted = true;
                    }
                }
                if (!setted) {
                    newx = x + dx;
                    newy = y + dy;
                }
            }
            posvec.addElement(new Point2D.Double(newx, newy));
            ++i;
        }
        return posvec;
    }

    @Override
    public void setupAfterAllTargetsSetted() {
        if (this.connectPolicy == 1) {
            this.initLinesDirection();
        }
    }

    @Override
    public void initLinesDirection() {
        if (this.connectPolicy != 1 || this.lines.size() < 1 || this.start == null) {
            this.firstDirection = 0;
            return;
        }
        int lastDir = 1;
        Point2D.Double p1 = null;
        Point2D.Double p2 = this.start;
        int n = this.lines.size();
        int i = 0;
        while (i < n) {
            int dir;
            p1 = p2;
            Point2D.Double double_ = p2 = i == n - 1 ? this.end : this.creasePoints.get(i).getPosition();
            if (p2 == null) {
                return;
            }
            double w = Math.abs(p2.x - p1.x);
            double h = Math.abs(p2.y - p1.y);
            if (w > 0.5 && h <= 0.5) {
                dir = 2;
            } else if (h > 0.5 && w <= 0.5) {
                dir = 1;
            } else {
                int n2 = dir = lastDir == 1 ? 2 : 1;
            }
            if (i == 0) {
                this.firstDirection = dir;
                break;
            }
            lastDir = dir;
            ++i;
        }
    }

    @Override
    public Point2D.Double getStartPoint() {
        return this.sHandlePoint.getPosition();
    }

    @Override
    public Point2D.Double getEndPoint() {
        return this.eHandlePoint.getPosition();
    }

    @Override
    public Point2D.Double getAnchorPointByIndex(int index) {
        if (index < 0 || index > this.lines.size()) {
            return null;
        }
        Shape shape = this.lines.get(index);
        if (shape instanceof Line2D.Double) {
            Line2D.Double line = (Line2D.Double)shape;
            return new Point2D.Double((line.x1 + line.x2) / 2.0, (line.y1 + line.y2) / 2.0);
        }
        return (Point2D.Double)this.linkPoint.point.clone();
    }

    public List addCreasePoint(Point2D[] points, GStructure structure) {
        ArrayList<GCreasePointForUndo> undoList = new ArrayList<GCreasePointForUndo>();
        this.start = this.getStartTargetPoint();
        this.end = this.getEndTargetPoint();
        this.creasePoints.clear();
        int type = this.getLineType();
        this.lines.clear();
        this.lines.add(new Line2D.Double());
        int i = 0;
        while (i < points.length) {
            double x = points[i].getX();
            double y = points[i].getY();
            CreasePoint creasePoint = new CreasePoint();
            creasePoint.setOwner(this);
            this.moveEditPoint(creasePoint, x, y);
            this.creasePoints.add(creasePoint);
            GCreasePointForUndo undo = new GCreasePointForUndo(creasePoint, i, null);
            undoList.add(undo);
            this.lines.add(new Line2D.Double());
            ++i;
        }
        this.setLineType(type);
        return undoList;
    }

    public List removeCreasePoint(GStructure structure) {
        ArrayList<GCreasePointForUndo> undoList = new ArrayList<GCreasePointForUndo>();
        int i = this.creasePoints.size() - 1;
        while (i >= 0) {
            GCreasePointForUndo undo = new GCreasePointForUndo(this.creasePoints.get(i), i, null);
            undoList.add(undo);
            --i;
        }
        this.creasePoints.clear();
        int type = this.getLineType();
        this.lines.clear();
        this.lines.add(new Line2D.Double());
        this.setLineType(type);
        return undoList;
    }

    public Rectangle2D removeCreasePoint(GCreasePoint p, GStructure structure) {
        Rectangle2D updateRect = null;
        int index = this.getCreasePointIndex(p);
        if (index >= 0) {
            updateRect = this.removeCreasePointWithoutNotify(p, structure, index);
            GCreasePointForUndo p1 = new GCreasePointForUndo(p, index, null);
            structure.notifyChange(p1, 2, null);
        }
        Rectangle2D.Double newshprec = this.updateShape();
        updateRect = GUtil.union(updateRect, newshprec);
        return updateRect;
    }

    public Rectangle2D removeCreasePointWithoutNotify(GCreasePoint p, GStructure structure, int index) {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D.Double areaOld = this.calcBoundsUsingPoints();
        this.creasePoints.remove(index);
        if (this instanceof GLinkedCurveEndLine) {
            this.lines.remove(0);
        } else {
            this.lines.remove(index + 1);
        }
        Rectangle2D.Double areaNew = this.calcBoundsUsingPoints();
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }

    protected Rectangle2D.Double calcBoundsUsingPoints() {
        int cspcnt = this.creasePoints.size() + 2;
        Point2D.Double[] pnts = new Point2D.Double[cspcnt];
        pnts[0] = this.start;
        int i = 0;
        while (i < pnts.length - 2) {
            pnts[i + 1] = this.creasePoints.get(i).getPosition();
            ++i;
        }
        pnts[pnts.length - 1] = this.end;
        return GLinkedCreaseLine.calcBoundsUsingPoints(pnts);
    }

    public Rectangle2D addCreasePoint(double x, double y, GStructure structure) {
        int index = this.getLineIndex(x, y);
        GCreasePoint newPoint = this.createNewCreasePoint(x, y, index);
        Rectangle2D updateRect = this.addCreasePointWithoutNotify(newPoint, structure, index);
        GCreasePointForUndo p1 = new GCreasePointForUndo(newPoint, index, null);
        structure.notifyChange(p1, 1, null);
        Rectangle2D.Double newshprec = this.updateShape();
        updateRect = GUtil.union(updateRect, newshprec);
        return updateRect;
    }

    public Rectangle2D addCreasePointWithoutNotify(GCreasePoint newPoint, GStructure structure, int index) {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D.Double areaOld = this.calcBoundsUsingPoints();
        int size = this.lines.size();
        if (index >= size) {
            index = size == 0 ? 0 : size - 1;
        } else if (index < 0) {
            index = size - 1;
        }
        boolean active1 = structure.getSelecteds().size() != 0;
        newPoint.setActive(active1);
        Shape oldLine = this.lines.get(index);
        if (oldLine instanceof Line2D.Double) {
            this.lines.insertElementAt(new Line2D.Double(), index + 1);
            this.creasePoints.insertElementAt(newPoint, index);
        } else if (this instanceof GLinkedCurveEndLine) {
            this.lines.insertElementAt(new Line2D.Double(), index);
            this.creasePoints.insertElementAt(newPoint, index);
        } else {
            this.lines.insertElementAt(new Line2D.Double(), index + 1);
            this.creasePoints.insertElementAt(newPoint, index);
        }
        Rectangle2D.Double areaNew = this.calcBoundsUsingPoints();
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }

    public int getLineIndex(double x, double y) {
        int index = -1;
        double extention = 4.0;
        Rectangle2D.Double area = new Rectangle2D.Double(x - extention, y - extention, extention * 2.0, extention * 2.0);
        int i = 0;
        int iMax = this.lines.size();
        while (i < iMax) {
            Shape line = this.lines.elementAt(i);
            if (line instanceof Line2D.Double) {
                if (line.intersects(area)) {
                    index = i;
                    break;
                }
            } else if (this.curveArea.intersects(area)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private GCreasePoint createNewCreasePoint(double x, double y, int index) {
        CreasePoint newPoint = new CreasePoint();
        newPoint.setOwner(this);
        Point2D.Double localPos1 = new Point2D.Double();
        Point2D.Double pos1 = this.getFootOfAPerpendicular(x, y, index);
        try {
            AffineTransform localAT = new AffineTransform();
            GUtil.createLocalTransform(this.start, this.end, localAT);
            AffineTransform inverse = localAT.createInverse();
            inverse.transform(pos1, localPos1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        newPoint.setLocalPosition(localPos1);
        newPoint.setPosition(pos1);
        return newPoint;
    }

    private Point2D.Double getFootOfAPerpendicular(double x, double y, int index) {
        Point2D.Double p = new Point2D.Double();
        boolean processed = false;
        try {
            Line2D.Double line = (Line2D.Double)this.lines.get(index);
            double a = line.y2 - line.y1;
            double b = line.x1 - line.x2;
            double c = line.x1 * line.y2 - line.y1 * line.x2;
            double ab = a * b;
            double aa = a * a;
            double bb = b * b;
            double div = 1.0 / (aa + bb);
            p.x = div * (a * c + bb * x - ab * y);
            p.y = div * (b * c - ab * x + aa * y);
            processed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!processed) {
            p.x = x;
            p.y = y;
        }
        return p;
    }

    @Override
    public void reformSquareLines(GStructure structure) {
        ReactionLink eventLink = (ReactionLink)this.getReactionLink(structure);
        SBModel sbmodel = null;
        GLinkedShape oldshape = null;
        GLinkedShape newshape = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        }
        catch (Exception myErr) {
            sbmodel = null;
        }
        if (sbmodel != null) {
            oldshape = eventLink.getGLinkedShape();
            sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy", oldshape, oldshape);
        }
        this.reformSquareLines(structure, true);
        if (sbmodel != null) {
            newshape = eventLink.getGLinkedShape();
            sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy", newshape, newshape);
        }
    }

    @Override
    public void setlinesDirection(Vector vec) {
        if (vec.size() > 0) {
            this.firstDirection = (Integer)vec.elementAt(0);
        }
    }

    @Override
    public void toggleConnectPolicy(GStructure structure) {
        ReactionLink eventLink = (ReactionLink)this.getReactionLink(structure);
        SBModel sbmodel = null;
        GLinkedShape oldshape = null;
        GLinkedShape newshape = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        }
        catch (Exception myErr) {
            sbmodel = null;
        }
        if (sbmodel != null) {
            oldshape = eventLink.getGLinkedShape();
            sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy", oldshape, oldshape);
        }
        if (this.connectPolicy == 0) {
            int pol = 1;
            this.setConnectPolicy(pol);
            this.reformSquareLines(structure, false);
        } else {
            GLink gl = this.getReactionLink(structure);
            structure.notifyChange(gl, 12, null);
            int pol = 0;
            this.setConnectPolicy(pol);
            gl.update();
        }
        if (sbmodel != null) {
            newshape = eventLink.getGLinkedShape();
            sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy", newshape, newshape);
        }
    }

    @Override
    public boolean canTogglePolicy(GStructure structure) {
        return this.getLineType() != 0;
    }

    @Override
    public GLink getReactionLink(GStructure structure) {
        Vector links = structure.getLinks();
        for (GLink rl : links) {
            GLinkedShape link1 = rl.getGLinkedShape();
            if (link1 != this) continue;
            return rl;
        }
        return null;
    }

    protected void reformSquareLines(GStructure structure, boolean needToSaveCurrentPolicy) {
        int pol;
        Rectangle2D.Double updateRect = null;
        Rectangle2D updateRect1 = null;
        Rectangle2D updateRect2 = null;
        ReactionLink gl = (ReactionLink)this.getReactionLink(structure);
        if (needToSaveCurrentPolicy) {
            structure.notifyChange(gl, 12, null);
        }
        boolean policyChange = false;
        if (this.connectPolicy == 1) {
            policyChange = true;
            pol = 0;
            this.setConnectPolicy(pol);
        }
        this.reformSquareLinesProtected(gl, structure);
        if (policyChange) {
            pol = 1;
            this.setConnectPolicy(pol);
        }
        this.initLinesDirection();
        structure.notifyChange(gl, 13, null);
        updateRect1 = structure.autoAjustLinkLineConn(gl);
        updateRect2 = structure.repaintLinkandAllLinksWhichlinkingtome(gl, false);
        updateRect = GUtil.union(updateRect, updateRect1);
        updateRect = GUtil.union(updateRect, updateRect2);
        structure.callbyuserRepaint(updateRect);
    }

    protected void reformSquareLinesProtected(GLink gl, GStructure structure) {
        int index;
        int i;
        Vector<Integer> v = new Vector<Integer>(1);
        v.addElement(new Integer(this.getLineDirectionAt(0)));
        structure.notifyChange(gl, 14, v);
        boolean recalcPointNumber = true;
        Point2D.Double[] posArray = this.getInitialCreasePointPositionForSquare(recalcPointNumber);
        if (posArray.length > this.creasePoints.size()) {
            int nAdd = posArray.length - this.creasePoints.size();
            i = 0;
            while (i < nAdd) {
                double x = posArray[i].x;
                double y = posArray[i].y;
                index = 0;
                GCreasePoint newPoint = this.createNewCreasePoint(x, y, index);
                Rectangle2D updateRect = this.addCreasePointWithoutNotify(newPoint, structure, index);
                if (updateRect != null) {
                    GCreasePointForUndo p1 = new GCreasePointForUndo(newPoint, index, null);
                    structure.notifyChange(p1, 1, null);
                }
                ++i;
            }
        } else if (posArray.length < this.creasePoints.size()) {
            int nRemove = this.creasePoints.size() - posArray.length;
            i = 0;
            while (i < nRemove) {
                index = 0;
                GCreasePoint p = this.creasePoints.get(0);
                this.removeCreasePointWithoutNotify(p, structure, index);
                GCreasePointForUndo p1 = new GCreasePointForUndo(p, index, null);
                structure.notifyChange(p1, 2, null);
                ++i;
            }
        }
        Vector<GCreasePoint> gelements = new Vector<GCreasePoint>();
        Vector<Point2D.Double> v2 = new Vector<Point2D.Double>();
        int n = posArray.length;
        int i2 = 0;
        while (i2 < n) {
            gelements.addElement(this.creasePoints.get(i2));
            v2.add(posArray[i2]);
            ++i2;
        }
        structure.move(gelements, v2);
    }

    private Point2D.Double[] getInitialCreasePointPositionForSquare(boolean recalcPointNumber) {
        Rectangle2D.Double recte;
        Vector nexteVec;
        Rectangle2D.Double rects;
        Vector nextsVec;
        Point2D.Double temStart = (Point2D.Double)this.start.clone();
        Point2D.Double temEnd = (Point2D.Double)this.end.clone();
        GLinkPositionInfo lpis = null;
        boolean bProcessingSameAsGLinkedStraightLine = false;
        GLinkedStraightLine tagerSubLine = null;
        GModificationRectangle rectangShape = null;
        Rectangle2D.Double rectGModificationRectangle = null;
        try {
            if (this.startTarget instanceof ReactionLink) {
                GLinkedShape glshp = ((ReactionLink)this.startTarget).getGLinkedShape();
                if (glshp instanceof GLinkedLineComplex3) {
                    tagerSubLine = ((GLinkedLineComplex3)glshp).getTheSubGLinkedStraightLineHavingProcessNode();
                    rectangShape = ((GLinkedLineComplex3)glshp).getProcessNode();
                } else if (glshp instanceof StateTransition) {
                    int idx = ((StateTransition)glshp).getOmittedShapeIndex();
                    GLinkedLine glnkline = ((StateTransition)glshp).getLine(idx);
                    if (glnkline instanceof GLinkedStraightLine) {
                        tagerSubLine = (GLinkedStraightLine)glnkline;
                    }
                    rectangShape = ((StateTransition)glshp).getOmittedShape();
                }
                if (tagerSubLine != null && rectangShape != null) {
                    rectGModificationRectangle = rectangShape.getModificationBounds();
                }
                if (rectGModificationRectangle != null) {
                    bProcessingSameAsGLinkedStraightLine = true;
                }
            }
        }
        catch (Exception myErr) {
            bProcessingSameAsGLinkedStraightLine = false;
            tagerSubLine = null;
            rectGModificationRectangle = null;
        }
        if (this.startTarget instanceof GLinkedStraightLine) {
            nextsVec = this.getNextPointOfTheEnd((GLinkedStraightLine)this.startTarget, this.start);
            rects = new Rectangle2D.Double(this.start.x, this.start.y, 0.0, 0.0);
        } else if (bProcessingSameAsGLinkedStraightLine) {
            lpis = this.getStartLinkPositionInfo();
            nextsVec = this.getNextPointOfTheEnd(tagerSubLine, this.start);
            rects = new Rectangle2D.Double(this.start.x, this.start.y, 0.0, 0.0);
        } else {
            lpis = this.getStartLinkPositionInfo();
            if ((lpis == null || lpis.getPosition() == -1) && this.startTarget != null && this.startTarget.getBoundsAsTarget() != null) {
                temStart.x = this.startTarget.getBoundsAsTarget().getCenterX();
                temStart.y = this.startTarget.getBoundsAsTarget().getCenterY();
            }
            rects = (nextsVec = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(this.startTarget, temStart, lpis)).size() == 1 ? this.startTarget.getBoundsAsTarget() : null;
        }
        GLinkPositionInfo lpie = null;
        bProcessingSameAsGLinkedStraightLine = false;
        tagerSubLine = null;
        rectangShape = null;
        rectGModificationRectangle = null;
        try {
            if (this.endTarget instanceof ReactionLink) {
                GLinkedShape glshp = ((ReactionLink)this.endTarget).getGLinkedShape();
                if (glshp instanceof GLinkedLineComplex3) {
                    tagerSubLine = ((GLinkedLineComplex3)glshp).getTheSubGLinkedStraightLineHavingProcessNode();
                    rectangShape = ((GLinkedLineComplex3)glshp).getProcessNode();
                } else if (glshp instanceof StateTransition) {
                    int idx = ((StateTransition)glshp).getOmittedShapeIndex();
                    GLinkedLine glnkline = ((StateTransition)glshp).getLine(idx);
                    if (glnkline instanceof GLinkedStraightLine) {
                        tagerSubLine = (GLinkedStraightLine)glnkline;
                    }
                    rectangShape = ((StateTransition)glshp).getOmittedShape();
                }
                if (tagerSubLine != null && rectangShape != null) {
                    rectGModificationRectangle = rectangShape.getModificationBounds();
                }
                if (rectGModificationRectangle != null) {
                    bProcessingSameAsGLinkedStraightLine = true;
                }
            }
        }
        catch (Exception myErr) {
            bProcessingSameAsGLinkedStraightLine = false;
            tagerSubLine = null;
            rectGModificationRectangle = null;
        }
        if (this.endTarget instanceof GLinkedStraightLine) {
            nexteVec = this.getNextPointOfTheEnd((GLinkedStraightLine)this.endTarget, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else if (bProcessingSameAsGLinkedStraightLine) {
            lpie = this.getEndLinkPositionInfo();
            nexteVec = this.getNextPointOfTheEnd(tagerSubLine, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else {
            lpie = this.getEndLinkPositionInfo();
            if ((lpie == null || lpie.getPosition() == -1) && this.endTarget != null && this.endTarget.getBoundsAsTarget() != null) {
                temEnd.x = this.endTarget.getBoundsAsTarget().getCenterX();
                temEnd.y = this.endTarget.getBoundsAsTarget().getCenterY();
            }
            nexteVec = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(this.endTarget, temEnd, lpie);
            recte = this.endTarget.getBoundsAsTarget();
        }
        int n = recalcPointNumber ? GLinkedCreaseLine.calcCreasePointNumberForSquare(temStart, temEnd, rects, recte, nextsVec, nexteVec, null) : this.creasePoints.size();
        Point2D.Double[] posArray = new Point2D.Double[n];
        GLinkedCreaseLine.calcCreasePointNumberForSquare(temStart, temEnd, rects, recte, nextsVec, nexteVec, posArray);
        return posArray;
    }

    private Vector getNextPointOfTheEnd(GLinkedStraightLine line1, Point2D.Double pe) {
        double x = pe.x;
        double y = pe.y;
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        double sx = line1.start.x;
        double sy = line1.start.y;
        double ex = line1.end.x;
        double ey = line1.end.y;
        double dx = Math.abs(sx - ex);
        double dy = Math.abs(sy - ey);
        if (dx <= eps && dy <= eps) {
            v.addElement(new Point2D.Double(x + 15.0, y));
            v.addElement(new Point2D.Double(x - 15.0, y));
            v.addElement(new Point2D.Double(x, y + 15.0));
            v.addElement(new Point2D.Double(x, y - 15.0));
        } else if (dx <= eps || dy / dx > 8.0) {
            v.addElement(new Point2D.Double(x + 15.0, y));
            v.addElement(new Point2D.Double(x - 15.0, y));
        } else if (dy <= eps || dx / dy > 8.0) {
            v.addElement(new Point2D.Double(x, y + 15.0));
            v.addElement(new Point2D.Double(x, y - 15.0));
        } else {
            v.addElement(new Point2D.Double(x + 15.0, y));
            v.addElement(new Point2D.Double(x - 15.0, y));
            v.addElement(new Point2D.Double(x, y + 15.0));
            v.addElement(new Point2D.Double(x, y - 15.0));
        }
        return v;
    }

    protected static Rectangle2D.Double refine2Lines(GLinkTarget startTarget, GLinkPositionInfo startLinkPositionInfo, GLinkTarget endTarget, GLinkPositionInfo endLinkPositionInfo, double lineWidth, double offsetX, double offsetY, Line2D.Double line, Line2D.Double whiteline) {
        Point2D.Double[] pointArray = GLinkedStraightLine.calcStartAndEnd(startTarget, startLinkPositionInfo, endTarget, endLinkPositionInfo, offsetX, offsetY);
        if (pointArray[0] == null || pointArray[1] == null) {
            return null;
        }
        Point2D.Double start = pointArray[0];
        Point2D.Double end = pointArray[1];
        Point2D.Double offset = pointArray[2];
        if (line == null) {
            line = new Line2D.Double();
        }
        if (whiteline == null) {
            whiteline = new Line2D.Double();
        }
        Point2D.Double lineStart = (Point2D.Double)start.clone();
        Point2D.Double lineEnd = (Point2D.Double)end.clone();
        Point2D.Double whiteStart = (Point2D.Double)start.clone();
        Point2D.Double whiteEnd = (Point2D.Double)end.clone();
        double whitelineoffset = Math.ceil((0.5 * lineWidth + 2.0) * Math.sqrt(10.0));
        if (offset != null) {
            double offsetabsw;
            double offsetabsl;
            double offx = offset.x;
            double offy = offset.y;
            double offabsinv = 1.0 / Math.sqrt(offx * offx + offy * offy);
            if (startTarget instanceof GAtom) {
                offsetabsl = lineWidth;
                offsetabsl *= 0.5 * offabsinv;
                offsetabsl = Math.ceil(offsetabsl);
                lineStart.x += offx * offsetabsl;
                lineStart.y += offy * offsetabsl;
                offsetabsw = lineWidth + ((GAtom)startTarget).getGFramedShape().getLineWidth();
                offsetabsw *= 0.5 * offabsinv;
                offsetabsw = Math.ceil(offsetabsw) + whitelineoffset;
                whiteStart.x += offx * offsetabsw;
                whiteStart.y += offy * offsetabsw;
            }
            if (endTarget instanceof GAtom) {
                offsetabsl = lineWidth;
                offsetabsl *= 0.5 * offabsinv;
                offsetabsl = Math.ceil(offsetabsl);
                lineEnd.x -= offx * offsetabsl;
                lineEnd.y -= offy * offsetabsl;
                offsetabsw = lineWidth + ((GAtom)endTarget).getGFramedShape().getLineWidth();
                offsetabsw *= 0.5 * offabsinv;
                offsetabsw = Math.ceil(offsetabsw) + whitelineoffset;
                whiteEnd.x -= offx * offsetabsw;
                whiteEnd.y -= offy * offsetabsw;
            }
        }
        line.setLine(lineStart, lineEnd);
        if (!(endTarget instanceof GLinkPoint)) {
            whiteline.setLine(whiteStart, whiteEnd);
        }
        double extend = Math.ceil(0.5 * lineWidth);
        double newStartX = Math.min(start.x, end.x) - extend;
        double newStartY = Math.min(start.y, end.y) - extend;
        double newEndX = Math.max(start.x, end.x) + extend;
        double newEndY = Math.max(start.y, end.y) + extend;
        Rectangle2D.Double bounds = new Rectangle2D.Double(newStartX, newStartY, newEndX - newStartX, newEndY - newStartY);
        return bounds;
    }

    public Vector<Shape> getLines() {
        return this.lines;
    }

    public Rectangle2D autoAjustCreasePointUsingNewStartEndPnt() {
        if (this.lines == null) {
            return null;
        }
        return this.autoAjustCreasePointUsingNewStartEndPnt(this.start, this.end);
    }

    public Rectangle2D autoAjustCreasePointUsingNewStartEndPnt(Point2D.Double stPnt, Point2D.Double edPnt) {
        Rectangle2D.Double redrawArea = null;
        if (stPnt == null || edPnt == null) {
            return redrawArea;
        }
        if (this.connectPolicy != 1) {
            return redrawArea;
        }
        if (this.lines == null || this.lines.size() <= 1) {
            return redrawArea;
        }
        if (this.creasePoints == null) {
            return redrawArea;
        }
        Rectangle2D areaOld = (Rectangle2D)this.getShapeBounds().clone();
        this.start = stPnt;
        this.end = edPnt;
        try {
            AffineTransform localAT = new AffineTransform();
            GUtil.createLocalTransform(stPnt, edPnt, localAT);
            AffineTransform inverse = localAT.createInverse();
            int i = this.creasePoints.size() - 1;
            while (i >= 0) {
                GCreasePoint cspnt = this.creasePoints.get(i);
                Point2D.Double pnt = cspnt.getPosition();
                int dir = this.getLineDirectionAt(i + 1);
                if (dir == 2) {
                    pnt.y = i == this.creasePoints.size() - 1 ? edPnt.y : this.creasePoints.get((int)(i + 1)).getPosition().y;
                    if (i == 0) {
                        pnt.x = stPnt.x;
                    }
                } else if (dir == 1) {
                    pnt.x = i == this.creasePoints.size() - 1 ? edPnt.x : this.creasePoints.get((int)(i + 1)).getPosition().x;
                    if (i == 0) {
                        pnt.y = stPnt.y;
                    }
                }
                Point2D.Double pos1 = (Point2D.Double)pnt.clone();
                Point2D.Double localPos1 = new Point2D.Double();
                inverse.transform(pos1, localPos1);
                cspnt.setPosition(pos1);
                cspnt.setLocalPosition(localPos1);
                --i;
            }
        }
        catch (NoninvertibleTransformException e) {
            return redrawArea;
        }
        Rectangle2D areaNew = (Rectangle2D)this.getShapeBounds().clone();
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }

    public Rectangle2D recalLocalPositions() {
        if (this.lines == null) {
            return null;
        }
        return this.recalLocalPositions(this.start, this.end);
    }

    public Rectangle2D recalLocalPositions(Point2D.Double stPnt, Point2D.Double edPnt) {
        Rectangle2D.Double redrawArea = null;
        if (stPnt == null || edPnt == null) {
            return redrawArea;
        }
        if (this.connectPolicy != 0) {
            return redrawArea;
        }
        if (this.lines == null) {
            return redrawArea;
        }
        if (this.creasePoints == null) {
            return redrawArea;
        }
        Rectangle2D areaOld = (Rectangle2D)this.getShapeBounds().clone();
        this.start = stPnt;
        this.end = edPnt;
        try {
            AffineTransform localAT = new AffineTransform();
            GUtil.createLocalTransform(stPnt, edPnt, localAT);
            AffineTransform inverse = localAT.createInverse();
            int i = this.creasePoints.size() - 1;
            while (i >= 0) {
                GCreasePoint cspnt = this.creasePoints.get(i);
                Point2D.Double pos1 = (Point2D.Double)cspnt.getPosition().clone();
                Point2D.Double localPos1 = new Point2D.Double();
                inverse.transform(pos1, localPos1);
                cspnt.setPosition(pos1);
                cspnt.setLocalPosition(localPos1);
                --i;
            }
        }
        catch (NoninvertibleTransformException e) {
            return redrawArea;
        }
        Rectangle2D areaNew = (Rectangle2D)this.getShapeBounds().clone();
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }
}

