/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jp.fric.graphics.draw.ElementAndPosition;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GCreasePointForUndo;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedLineIndexPossesive;
import jp.fric.graphics.draw.GLinkedLineModificationShape;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GLinkedStraightLine;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.ShapeUtil;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.LinkedCreaseLineForComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.GModificationRectangle;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.Truncation;
import jp.sbi.celldesigner.symbol.reaction.UnknownCatalysis;
import jp.sbi.celldesigner.symbol.reaction.UnknownInhibition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.util.CelldUtil;

public abstract class GLinkedCreaseLine
extends GLinkedLine
implements GEditable,
GLinkedLineIndexPossesive,
GLinkConnectSchemeOwner {
    protected GLinkedStraightLine[] lines;
    private GCreasePoint[] creasePoints;
    private Rectangle2D.Double bounds = null;
    private int defaultTargetLineIndex = 0;
    private AffineTransform localAT = new AffineTransform();
    private AffineTransform inverse = new AffineTransform();
    private GLinkedStraightLine standardLine = new GLinkedStraightLine();
    protected GLinkHandlePoint sHandlePoint = new GLinkHandlePoint();
    protected GLinkHandlePoint eHandlePoint = new GLinkHandlePoint();
    protected Color color = new Color(0, 0, 0);
    protected double lineWidth = 1.0;
    protected int showLinkAnchorMode = 0;
    protected GLinkPositionInfo linkPositionInfo = null;
    protected int connectPolicy = GLinkedCreaseLine.getDefaultConnectPolicy();
    protected boolean creasePointsInitialized = false;
    private GLinkedLineComplex3 gLinkedlinecomplex3Parent = null;
    private static final int NEXT_POINT_DISTANCE = 15;
    private static final int NEXT_POINT_SMALL_DISTANCE = 3;
    protected static double eps = 0.001;
    protected static final double eps1 = 0.5;

    public void setcomplex3Parent(GLinkedLineComplex3 p) {
        this.gLinkedlinecomplex3Parent = p;
    }

    public GLinkedLineComplex3 getcomplex3Parent() {
        return this.gLinkedlinecomplex3Parent;
    }

    public GLinkedCreaseLine() {
        this.sHandlePoint.setOwner(this);
        this.eHandlePoint.setOwner(this);
        this.init(GLinkedCreaseLine.getDefaultCreasePointNumber() + 1);
    }

    @Override
    public final void resetCreaseLineNumber(int newCreaseLineNumber) {
        this.init(newCreaseLineNumber);
    }

    protected final void init(int newCreaseLineNumber) {
        this.creasePointsInitialized = false;
        this.init1(newCreaseLineNumber);
        this.init2(newCreaseLineNumber);
    }

    protected void init1(int newCreaseLineNumber) {
        this.lines = new GLinkedStraightLine[newCreaseLineNumber];
        int i = 0;
        while (i < newCreaseLineNumber) {
            this.lines[i] = new GLinkedStraightLine();
            ++i;
        }
    }

    protected void init2(int newCreaseLineNumber) {
        try {
            this.setLines(this.lines);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void activateEditPoints(boolean bool) {
        int i = 0;
        while (i < this.creasePoints.length) {
            this.creasePoints[i].setActive(bool);
            ++i;
        }
        if (this.sHandlePoint != null) {
            this.sHandlePoint.setActive(bool);
        }
        this.eHandlePoint.setActive(bool);
    }

    @Override
    public boolean contains(GEditPoint geditpoint) {
        int i = 0;
        while (i < this.creasePoints.length) {
            if (this.creasePoints[i] == geditpoint) {
                return true;
            }
            ++i;
        }
        if (this.sHandlePoint != null && this.sHandlePoint == geditpoint) {
            return true;
        }
        return this.eHandlePoint == geditpoint;
    }

    private void updateEditPoint(GEditPoint newPoint, GEditPoint oldPoint) {
        newPoint.setLocalPosition(oldPoint.getLocalPosition());
        newPoint.setPosition(new Point2D.Double());
    }

    @Override
    public GLinkedLine createCopiedLine() {
        GLinkedCreaseLine newline = null;
        try {
            newline = (GLinkedCreaseLine)this.getClass().newInstance();
        }
        catch (Exception exception) {
            if (this.gLinkedlinecomplex3Parent != null) {
                newline = new LinkedCreaseLineForComplex3();
            }
            return newline;
        }
        newline.setConnectPolicy(this.connectPolicy);
        newline.creasePointsInitialized = true;
        newline.setDefaultTargetLineIndex(this.defaultTargetLineIndex);
        GLinkedStraightLine[] glinkedstraightlines = new GLinkedStraightLine[this.lines.length];
        int i22 = 0;
        while (i22 < this.lines.length) {
            glinkedstraightlines[i22] = (GLinkedStraightLine)this.lines[i22].createCopy();
            if (glinkedstraightlines[i22] != null) {
                Vector modifications = glinkedstraightlines[i22].getLineModifications();
                int size = modifications.size();
                int k = 0;
                while (k < size) {
                    GLinkedLineModificationShape modificationShape = (GLinkedLineModificationShape)modifications.elementAt(k);
                    try {
                        Method m = modificationShape.getClass().getMethod("setParent", LinkedCreaseLine.class);
                        m.setAccessible(true);
                        m.invoke((Object)modificationShape, newline);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++k;
                }
            }
            ++i22;
        }
        try {
            newline.setLines(glinkedstraightlines);
        }
        catch (Exception i22) {
            // empty catch block
        }
        GEditPoint[] geditpoints = newline.getEditPoints();
        GEditPoint[] geditpoints_1_ = this.getEditPoints();
        int i = 0;
        while (i < geditpoints_1_.length) {
            this.updateEditPoint(geditpoints[i], geditpoints_1_[i]);
            ++i;
        }
        if (this.sHandlePoint != null) {
            this.updateEditPoint(newline.sHandlePoint, this.sHandlePoint);
        }
        this.updateEditPoint(newline.eHandlePoint, this.eHandlePoint);
        newline.initCreasePointPositionsDirect();
        return newline;
    }

    @Override
    public void drawBaseWhiteLine(Graphics2D graphics2d) {
        int i = 0;
        while (i < this.lines.length) {
            GLinkTarget startTarget = this.getStartTarget();
            GLinkTarget endTarget = this.getEndTarget();
            SpeciesAlias speiesAlias = null;
            boolean draw = false;
            if (this.lines[i].getStartTarget() instanceof SpeciesAlias && this.lines[i].getStartLinkPositionInfo() == null) {
                if (startTarget instanceof SpeciesAlias) {
                    speiesAlias = (SpeciesAlias)startTarget;
                }
                if (this.lines[i].getStartTarget() != startTarget) {
                    draw = true;
                } else if (speiesAlias == null || !speiesAlias.getFrameBounds().contains(this.lines[i].getEndPoint().x, this.lines[i].getEndPoint().y)) {
                    draw = true;
                }
            } else if (this.lines[i].getEndTarget() instanceof SpeciesAlias && this.lines[i].getEndLinkPositionInfo() == null) {
                if (endTarget instanceof SpeciesAlias) {
                    speiesAlias = (SpeciesAlias)endTarget;
                }
                if (this.lines[i].getEndTarget() != endTarget) {
                    draw = true;
                } else if (speiesAlias == null || !speiesAlias.getFrameBounds().contains(this.lines[i].getStartPoint().x, this.lines[i].getStartPoint().y)) {
                    draw = true;
                }
            } else {
                draw = true;
            }
            this.lines[i].setLineWidth(this.getLineWidth());
            this.lines[i].drawBaseWhiteLine(graphics2d);
            ++i;
        }
    }

    protected Point2D.Double[] setupLinkAnchorCoord() {
        if (this.gLinkedlinecomplex3Parent != null) {
            return this.gLinkedlinecomplex3Parent.setupLinkAnchorCoord();
        }
        if (this instanceof LinkedCreaseLine && ((LinkedCreaseLine)this).isLogicGate()) {
            try {
                Point2D.Double[] array = new Point2D.Double[1];
                GLogicGate gate = ((LinkedCreaseLine)this).getLogicGate();
                array[0] = gate.getHeaderPoint().getPosition();
                return array;
            }
            catch (Exception array) {
                // empty catch block
            }
        }
        Point2D.Double[] array = new Point2D.Double[this.lines.length];
        int i = 0;
        while (i < array.length) {
            Point2D.Double pos = this.lines[i].getLinkTargetPoint();
            array[i] = (Point2D.Double)pos.clone();
            ++i;
        }
        return array;
    }

    protected void drawLinkAnchors(Graphics2D g2, GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.drawLinkAnchors(g2, lpi, drawOnlyActive, this.setupLinkAnchorCoord(), this instanceof StateTransition);
    }

    protected void drawLinkAnchors(Graphics2D g2, GLinkPositionInfo lpi, boolean drawOnlyActive, Point2D.Double[] arrLinkAnchorCoord, boolean havePorcessNode) {
        Point2D.Double[] array = arrLinkAnchorCoord;
        int onlyUsingfordrawHighlightPositon = -1;
        if (havePorcessNode && lpi != null && array.length == 8) {
            int iAddingObjectFlag = 0;
            iAddingObjectFlag = this.gLinkedlinecomplex3Parent != null ? this.gLinkedlinecomplex3Parent.getAddingObjectFlag() : this.getAddingObjectFlag();
            if (iAddingObjectFlag != 0) {
                Point2D.Double[] dummyArray = null;
                switch (iAddingObjectFlag) {
                    case 2: {
                        dummyArray = new Point2D.Double[]{array[1]};
                        if (lpi == null) break;
                        lpi.setPosition(1);
                        onlyUsingfordrawHighlightPositon = 0;
                        break;
                    }
                    case 1: {
                        dummyArray = new Point2D.Double[]{array[0]};
                        if (lpi == null) break;
                        lpi.setPosition(0);
                        onlyUsingfordrawHighlightPositon = 0;
                        break;
                    }
                    case 3: {
                        dummyArray = new Point2D.Double[]{array[2], array[3], array[4], array[5], array[6], array[7]};
                        if (lpi == null) break;
                        if (lpi.getPosition() >= 2 && lpi.getPosition() <= 7) {
                            onlyUsingfordrawHighlightPositon = lpi.getPosition() - 2;
                            break;
                        }
                        lpi.setPosition(2);
                        onlyUsingfordrawHighlightPositon = 0;
                    }
                }
                if (dummyArray != null && dummyArray.length > 0) {
                    array = new Point2D.Double[dummyArray.length];
                    int i = 0;
                    while (i < dummyArray.length) {
                        array[i] = dummyArray[i];
                        ++i;
                    }
                }
            }
        }
        if (onlyUsingfordrawHighlightPositon == -1) {
            ShapeUtil.drawLinkAnchorsWithIndexStatic(g2, lpi == null ? -1 : lpi.getPosition(), array, drawOnlyActive);
        } else {
            ShapeUtil.drawLinkAnchorsWithIndexStatic(g2, onlyUsingfordrawHighlightPositon, array, drawOnlyActive);
        }
    }

    private void drawLinkAnchors(Graphics2D g2, boolean drawOnlyActive) {
        this.drawLinkAnchors(g2, this.linkPositionInfo, drawOnlyActive);
    }

    protected void drawLine(Graphics2D g2, Color color, double width) {
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i].setLineWidth(width);
            this.lines[i].setColor(color);
            BasicStroke org_stroke = new BasicStroke();
            org_stroke = (BasicStroke)g2.getStroke();
            if (org_stroke.getDashArray() == null && (i == 0 || i == this.lines.length - 1)) {
                BasicStroke tmp_stroke = new BasicStroke((float)width, 0, org_stroke.getLineJoin(), org_stroke.getMiterLimit(), org_stroke.getDashArray(), org_stroke.getDashPhase());
                g2.setStroke(tmp_stroke);
            }
            GLinkTarget startTarget = this.getStartTarget();
            GLinkTarget endTarget = this.getEndTarget();
            SpeciesAlias speiesAlias = null;
            boolean draw = false;
            if (this.lines[i].getStartTarget() instanceof SpeciesAlias && this.lines[i].getStartLinkPositionInfo() == null) {
                if (startTarget instanceof SpeciesAlias) {
                    speiesAlias = (SpeciesAlias)startTarget;
                }
                if (this.lines[i].getStartTarget() != startTarget) {
                    draw = true;
                } else if (speiesAlias == null || !speiesAlias.getFrameBounds().contains(this.lines[i].getEndPoint().x, this.lines[i].getEndPoint().y)) {
                    draw = true;
                }
            } else if (this.lines[i].getEndTarget() instanceof SpeciesAlias && this.lines[i].getEndLinkPositionInfo() == null) {
                if (endTarget instanceof SpeciesAlias) {
                    speiesAlias = (SpeciesAlias)endTarget;
                }
                if (this.lines[i].getEndTarget() != endTarget) {
                    draw = true;
                } else if (speiesAlias == null || !speiesAlias.getFrameBounds().contains(this.lines[i].getStartPoint().x, this.lines[i].getStartPoint().y)) {
                    draw = true;
                }
            } else {
                draw = true;
            }
            this.lines[i].drawShape(g2);
            g2.setStroke(org_stroke);
            ++i;
        }
        if (this instanceof StateTransition) {
            ((StateTransition)this).getOmittedShape().drawModification(g2);
            this.defaultTargetLineIndex = ((StateTransition)this).getOmittedShapeIndex();
        }
        i = 0;
        while (i < this.creasePoints.length) {
            this.creasePoints[i].draw(g2);
            ++i;
        }
        if (this.sHandlePoint != null) {
            this.sHandlePoint.draw(g2);
        }
        this.eHandlePoint.draw(g2);
        if (this.showLinkAnchorMode != 0) {
            boolean drawOnlyActive = this.showLinkAnchorMode == 2;
            this.drawLinkAnchors(g2, drawOnlyActive);
        }
    }

    @Override
    public void drawLine(Graphics2D g2) {
        Color color = this.getColor();
        if (MainWindow.getLastInstance().isShowingSBGNCompliant()) {
            if (this instanceof LinkedCreaseLineMixedNotation) {
                color = Preference.getNotCompliantSBGNViewerColor();
            } else if (this instanceof UnknownCatalysis) {
                color = Preference.getNotCompliantSBGNViewerColor();
            } else if (this instanceof UnknownInhibition) {
                color = Preference.getNotCompliantSBGNViewerColor();
            }
        }
        this.drawLine(g2, color, this.getLineWidth());
    }

    public int getCreasePointsSize() {
        return this.creasePoints.length;
    }

    @Override
    public GLinkedLineIndex getDefaultLineIndex() {
        GLinkedLineIndex glinkedlineindex = new GLinkedLineIndex();
        glinkedlineindex.line = this.defaultTargetLineIndex;
        return glinkedlineindex;
    }

    @Override
    public GEditPoint getEditPoint(double x, double y) {
        int i = 0;
        while (i < this.creasePoints.length) {
            if (this.creasePoints[i].inShape(x, y)) {
                return this.creasePoints[i];
            }
            ++i;
        }
        if (this.sHandlePoint != null && this.sHandlePoint.inShape(x, y)) {
            return this.sHandlePoint;
        }
        if (this.eHandlePoint.inShape(x, y)) {
            return this.eHandlePoint;
        }
        return null;
    }

    @Override
    public GEditPoint[] getEditPoints() {
        return this.creasePoints;
    }

    public void setEditPoints(GEditPoint[] creasePoints) {
        this.creasePoints = (GCreasePoint[])creasePoints;
    }

    public GLinkedStraightLine[] getLines() {
        return this.lines;
    }

    public GEditPoint getStartHandlePoint() {
        return this.sHandlePoint;
    }

    public GEditPoint getEndHandlePoint() {
        return this.eHandlePoint;
    }

    public GLinkedLine getLine(int index) {
        if (index == -1) {
            return this.lines[this.defaultTargetLineIndex];
        }
        if (index > -1 && index < this.lines.length) {
            return this.lines[index];
        }
        return this.lines[this.defaultTargetLineIndex];
    }

    @Override
    public GLinkedLine getLine(GLinkedLineIndex glinkedlineindex) {
        return this.getLine(glinkedlineindex.line);
    }

    @Override
    public Rectangle2D.Double getLineBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    public int getLineSize() {
        return this.lines.length;
    }

    @Override
    public int getArm() {
        return -1;
    }

    public GLinkedLineIndex getLineIndex(int line) {
        GLinkedLineIndex index = new GLinkedLineIndex();
        index.line = line;
        index.arm = this.getArm();
        return index;
    }

    @Override
    public GLinkedLineIndex getLineIndex(double x, double y) {
        GLinkedLineIndex glinkedlineindex = new GLinkedLineIndex();
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].inShape(x, y)) {
                glinkedlineindex.line = i;
                break;
            }
            ++i;
        }
        return glinkedlineindex;
    }

    @Override
    public boolean inLine(double x, double y) {
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i].inShape(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        try {
            return this.lines[this.defaultTargetLineIndex].inShapeAsTarget(x, y);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initCreasePointPositionsDirect() {
        this.startTarget = this.lines[0].getStartTarget();
        this.endTarget = this.lines[this.lines.length - 1].getEndTarget();
        if (this.startTarget != null && this.endTarget != null) {
            this.start = this.startTarget.targetPoint();
            this.end = this.endTarget.targetPoint();
            if (this.start != null && this.end != null) {
                try {
                    Point2D.Double pos1;
                    GUtil.createLocalTransform(this.start, this.end, this.localAT);
                    this.inverse = this.localAT.createInverse();
                    double dx = (this.end.x - this.start.x) / (double)this.lines.length;
                    double dy = (this.end.y - this.start.y) / (double)this.lines.length;
                    int i = 0;
                    while (i < this.creasePoints.length) {
                        Point2D.Double pos = new Point2D.Double(this.start.x + dx * (double)(i + 1), this.start.y + dy * (double)(i + 1));
                        this.creasePoints[i].setPosition(pos);
                        Point2D.Double pos12 = new Point2D.Double();
                        this.inverse.transform(pos, pos12);
                        this.creasePoints[i].setLocalPosition(pos12);
                        ++i;
                    }
                    if (this.sHandlePoint != null) {
                        Point2D.Double pos = new Point2D.Double(this.start.x, this.start.y);
                        this.sHandlePoint.setPosition(pos);
                        pos1 = new Point2D.Double();
                        this.inverse.transform(pos, pos1);
                        this.sHandlePoint.setLocalPosition(pos1);
                    }
                    Point2D.Double pos = new Point2D.Double(this.end.x, this.end.y);
                    this.eHandlePoint.setPosition(pos);
                    pos1 = new Point2D.Double();
                    this.inverse.transform(pos, pos1);
                    this.eHandlePoint.setLocalPosition(pos1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Point2D.Double[] getInitialCreasePointPositionForSquare(boolean recalcPointNumber) {
        Rectangle2D.Double recte;
        Vector nexteVec;
        Vector nextsVec;
        GLinkPositionInfo lpis = this.lines[0].getStartLinkPositionInfo();
        Point2D.Double temStart = (Point2D.Double)this.start.clone();
        Point2D.Double temEnd = (Point2D.Double)this.end.clone();
        if ((lpis == null || lpis.getPosition() == -1) && this.startTarget != null && this.startTarget.getBoundsAsTarget() != null) {
            temStart.x = this.startTarget.getBoundsAsTarget().getCenterX();
            temStart.y = this.startTarget.getBoundsAsTarget().getCenterY();
        }
        Rectangle2D.Double rects = (nextsVec = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(this.startTarget, temStart, lpis)).size() == 1 ? this.startTarget.getBoundsAsTarget() : null;
        GLinkPositionInfo lpie = null;
        boolean bProcessingSameAsGLinkedStraightLine = false;
        boolean bTargetIsGate = false;
        GLinkedStraightLine tagerSubLine = null;
        GModificationRectangle rectangShape = null;
        Rectangle2D.Double rectGModificationRectangle = null;
        try {
            if (this.endTarget instanceof ReactionLink) {
                GLinkedLine glnkline;
                GLinkedShape glshp = ((ReactionLink)this.endTarget).getGLinkedShape();
                if (glshp instanceof GLinkedLineComplex3) {
                    tagerSubLine = ((GLinkedLineComplex3)glshp).getTheSubGLinkedStraightLineHavingProcessNode();
                    rectangShape = ((GLinkedLineComplex3)glshp).getProcessNode();
                } else if (glshp instanceof StateTransition) {
                    int idx = ((StateTransition)glshp).getOmittedShapeIndex();
                    GLinkedLine glnkline2 = ((StateTransition)glshp).getLine(idx);
                    if (glnkline2 instanceof GLinkedStraightLine) {
                        tagerSubLine = (GLinkedStraightLine)glnkline2;
                    }
                    rectangShape = ((StateTransition)glshp).getOmittedShape();
                } else if (glshp instanceof GLogicGate && (glnkline = ((GLogicGate)glshp).getRealLine().getLine(0)) instanceof GLinkedStraightLine && (tagerSubLine = (GLinkedStraightLine)glnkline) != null) {
                    bTargetIsGate = true;
                }
                if (tagerSubLine != null && rectangShape != null) {
                    rectGModificationRectangle = rectangShape.getModificationBounds();
                }
                if (rectGModificationRectangle != null) {
                    bProcessingSameAsGLinkedStraightLine = true;
                }
            }
        }
        catch (Exception myErr) {
            bProcessingSameAsGLinkedStraightLine = false;
            bTargetIsGate = false;
            tagerSubLine = null;
            rectGModificationRectangle = null;
        }
        if (this.endTarget instanceof GLinkedStraightLine) {
            nexteVec = this.getNextPointOfTheEnd((GLinkedStraightLine)this.endTarget, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else if (bProcessingSameAsGLinkedStraightLine) {
            lpie = this.lines[this.lines.length - 1].getEndLinkPositionInfo();
            nexteVec = this.getNextPointOfTheEnd(tagerSubLine, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else if (bTargetIsGate) {
            GLinkedStraightLine gl = new GLinkedStraightLine();
            gl.setStartAndEndPoint((Point2D.Double)this.end.clone(), (Point2D.Double)this.end.clone());
            nexteVec = this.getNextPointOfTheEnd(gl, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else {
            lpie = this.lines[this.lines.length - 1].getEndLinkPositionInfo();
            temEnd = this.end;
            if ((lpie == null || lpie.getPosition() == -1) && this.endTarget != null && this.endTarget.getBoundsAsTarget() != null) {
                temEnd.x = this.endTarget.getBoundsAsTarget().getCenterX();
                temEnd.y = this.endTarget.getBoundsAsTarget().getCenterY();
            }
            nexteVec = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(this.endTarget, temEnd, lpie);
            recte = this.endTarget.getBoundsAsTarget();
        }
        int n = recalcPointNumber ? GLinkedCreaseLine.calcCreasePointNumberForSquare(temStart, temEnd, rects, recte, nextsVec, nexteVec, null) : this.creasePoints.length;
        Point2D.Double[] posArray = new Point2D.Double[n];
        GLinkedCreaseLine.calcCreasePointNumberForSquare(temStart, temEnd, rects, recte, nextsVec, nexteVec, posArray);
        return posArray;
    }

    private void initCreasePointPositionsSquare() {
        GLinkTarget startTarget1 = this.lines[0].getStartTarget();
        GLinkTarget endTarget1 = this.lines[this.lines.length - 1].getEndTarget();
        if (startTarget1 == null || endTarget1 == null) {
            return;
        }
        if (this.start != null && this.end != null) {
            try {
                Point2D.Double pos1;
                GUtil.createLocalTransform(this.start, this.end, this.localAT);
                this.inverse = this.localAT.createInverse();
                boolean recalcPointNumber = false;
                Point2D.Double[] posArray = this.getInitialCreasePointPositionForSquare(recalcPointNumber);
                int i = 0;
                while (i < this.creasePoints.length) {
                    Point2D.Double pos = posArray[i];
                    this.creasePoints[i].setPosition(pos);
                    Point2D.Double pos12 = new Point2D.Double();
                    this.inverse.transform(pos, pos12);
                    this.creasePoints[i].setLocalPosition(pos12);
                    ++i;
                }
                if (this.sHandlePoint != null) {
                    Point2D.Double pos = new Point2D.Double(this.start.x, this.start.y);
                    this.sHandlePoint.setPosition(pos);
                    pos1 = new Point2D.Double();
                    this.inverse.transform(pos, pos1);
                    this.sHandlePoint.setLocalPosition(pos1);
                }
                Point2D.Double pos = new Point2D.Double(this.end.x, this.end.y);
                this.eHandlePoint.setPosition(pos);
                pos1 = new Point2D.Double();
                this.inverse.transform(pos, pos1);
                this.eHandlePoint.setLocalPosition(pos1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initCreasePointPositions() {
        if (this.connectPolicy == 1) {
            this.initCreasePointPositionsSquare();
            this.initLinesDirection();
        } else {
            this.initCreasePointPositionsDirect();
        }
    }

    @Override
    public Rectangle2D.Double moveEditPoint(GEditPoint geditpoint, double x, double y) {
        try {
            this.inverse = this.localAT.createInverse();
        }
        catch (Exception exception) {
            return null;
        }
        Rectangle2D.Double redrawArea = null;
        Point2D.Double pos = new Point2D.Double();
        this.inverse.transform(new Point2D.Double(x, y), pos);
        geditpoint.setLocalPosition(pos);
        geditpoint.setPosition(new Point2D.Double(x, y));
        return redrawArea;
    }

    @Override
    public void setCurveBindingIndex(int index) {
        super.setCurveBindingIndex(index);
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i].setCurveBindingIndex(index);
            ++i;
        }
    }

    public void setDefaultTargetLineIndex(int index) {
        this.defaultTargetLineIndex = index;
    }

    private Point2D.Double getFootOfAPerpendicular(double x, double y, GLinkedLineIndex index) {
        Point2D.Double p = new Point2D.Double();
        boolean processed = false;
        try {
            GLinkedStraightLine l = this.lines[index.line];
            Point2D.Double p1 = l.start;
            Point2D.Double p2 = l.end;
            double a = p2.y - p1.y;
            double b = p1.x - p2.x;
            double c = p1.x * p2.y - p1.y * p2.x;
            double ab = a * b;
            double aa = a * a;
            double bb = b * b;
            double div = 1.0 / (aa + bb);
            p.x = div * (a * c + bb * x - ab * y);
            p.y = div * (b * c - ab * x + aa * y);
            processed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!processed) {
            p.x = x;
            p.y = y;
        }
        return p;
    }

    protected GCreasePoint createNewCreasePoint(double x, double y, GLinkedLineIndex index) {
        GCreasePoint newPoint = this.createCreasePoint();
        newPoint.setOwner(this);
        Point2D.Double localPos1 = new Point2D.Double();
        Point2D.Double pos1 = this.getFootOfAPerpendicular(x, y, index);
        try {
            this.inverse = this.localAT.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.inverse.transform(pos1, localPos1);
        newPoint.setLocalPosition(localPos1);
        newPoint.setPosition(pos1);
        return newPoint;
    }

    public GCreasePoint createmyNewCreasePoint(double x, double y, GLinkedLineIndex index) {
        if (this.start != null && this.end != null) {
            GUtil.createLocalTransform(this.start, this.end, this.localAT);
            return this.createNewCreasePoint(x, y, index);
        }
        return null;
    }

    public GCreasePoint createmyNewCreasePointWithoutAdjustingPostionOfPoint(double x, double y, GLinkedLineIndex index) {
        GCreasePoint newPoint = this.createCreasePoint();
        if (this.start != null && this.end != null) {
            GUtil.createLocalTransform(this.start, this.end, this.localAT);
            try {
                this.inverse = this.localAT.createInverse();
                Point2D.Double pos1 = new Point2D.Double(x, y);
                Point2D.Double localPos1 = new Point2D.Double();
                this.inverse.transform(pos1, localPos1);
                newPoint.setPosition(pos1);
                newPoint.setLocalPosition(localPos1);
                newPoint.setOwner(this);
            }
            catch (Exception myErr) {
                return null;
            }
            return newPoint;
        }
        return null;
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        boolean bDotInShape = false;
        bDotInShape = this.gLinkedlinecomplex3Parent != null ? this.gLinkedlinecomplex3Parent.inShape(x, y) : this.inShape(x, y);
        if (bDotInShape) {
            Point2D.Double[] array = this.setupLinkAnchorCoord();
            int iAddingObjectFlag = 0;
            iAddingObjectFlag = this.gLinkedlinecomplex3Parent != null ? this.gLinkedlinecomplex3Parent.getAddingObjectFlag() : this.getAddingObjectFlag();
            if (this.gLinkedlinecomplex3Parent != null || this instanceof StateTransition) {
                Point2D.Double[] arrayPara;
                switch (iAddingObjectFlag) {
                    case 1: {
                        arrayPara = new Point2D.Double[]{array[0]};
                        break;
                    }
                    case 2: {
                        arrayPara = new Point2D.Double[]{array[1]};
                        break;
                    }
                    case 3: {
                        arrayPara = new Point2D.Double[]{array[2], array[3], array[4], array[5], array[6], array[7]};
                        break;
                    }
                    default: {
                        arrayPara = array;
                    }
                }
                GLinkPositionInfo gInfo = ShapeUtil.getNearLinkAnchorPositionForLink(arrayPara, x, y);
                switch (iAddingObjectFlag) {
                    case 1: {
                        gInfo.setPosition(0);
                        break;
                    }
                    case 2: {
                        gInfo.setPosition(1);
                        break;
                    }
                    case 3: {
                        gInfo.setPosition(gInfo.getPosition() + 2);
                        break;
                    }
                }
                return gInfo;
            }
            return ShapeUtil.getNearLinkAnchorPositionForLink(array, x, y);
        }
        return null;
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.showLinkAnchorMode = drawOnlyActive ? 2 : 1;
        this.linkPositionInfo = (GLinkPositionInfo)lpi.clone();
    }

    @Override
    public void hideLinkAnchors() {
        this.showLinkAnchorMode = 0;
        this.linkPositionInfo = null;
    }

    @Override
    public GLink getReactionLink(GStructure structure) {
        Vector links = structure.getLinks();
        for (GLink rl : links) {
            GLinkedShape link1 = rl.getGLinkedShape();
            if (link1 == this) {
                return rl;
            }
            if (!(link1 instanceof GLogicGate) || ((GLogicGate)link1).getRealLine() != this) continue;
            return rl;
        }
        return null;
    }

    protected static double calcDistanceSq(GLinkedStraightLine line) {
        Point2D.Double pos1 = line.getStartTarget().targetPoint();
        Point2D.Double pos2 = line.getEndTarget().targetPoint();
        return pos1.distanceSq(pos2);
    }

    public void addCreasePointWithoutNotify(GCreasePoint newPoint, GStructure structure, int index) {
        int size = this.lines.length;
        if (index >= 0 && index < size) {
            GLinkedStraightLine oldLine = this.lines[index];
            Vector lineModVec = oldLine.getLineModifications();
            oldLine.clearLineModifications();
            GLinkedStraightLine newLine = (GLinkedStraightLine)oldLine.createCopy();
            try {
                newLine.setTargetAt((GLinkTarget)newPoint, 0, (GLinkPositionInfo)null);
                newLine.setTargetAt(oldLine.getEndTarget(), 1, oldLine.getEndLinkPositionInfo());
                oldLine.setTargetAt((GLinkTarget)newPoint, 1, (GLinkPositionInfo)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.insertCreasePoint(newPoint, index);
            this.insertLine(newLine, index + 1);
            this.setupNewLinesByAddPoint(lineModVec, index, oldLine, newLine, null);
            this.setDefaultTargetLineIndex((size + 1) / 2);
            this.updateLine();
        }
    }

    public Rectangle2D addCreasePointWithoutNotify(GCreasePoint newPoint, GStructure structure, int index, Map paramMap) {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D.Double areaOld = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        boolean mustConfirmProcessNodeIdx = false;
        int iOldProcessNodeIdx = -1;
        int iNewProcessNodeIdx = -1;
        GLinkedLineComplex3 parentComplex3 = this.getcomplex3Parent();
        if (parentComplex3 != null) {
            iOldProcessNodeIdx = parentComplex3.getProcessNodeIndex();
        } else if (this instanceof StateTransition) {
            StateTransition st = (StateTransition)this;
            iOldProcessNodeIdx = st.getOmittedShapeIndex();
        }
        int size = this.lines.length;
        if (index >= size) {
            index = size == 0 ? 0 : size - 1;
        } else if (index < 0) {
            index = size - 1;
        }
        boolean active1 = structure.getSelecteds().size() != 0;
        newPoint.setActive(active1);
        GLinkedStraightLine oldLine = this.lines[index];
        Vector lineModVec = oldLine.getLineModifications();
        oldLine.clearLineModifications();
        GLinkedStraightLine newLine = (GLinkedStraightLine)oldLine.createCopy();
        try {
            newLine.setTargetAt((GLinkTarget)newPoint, 0, (GLinkPositionInfo)null);
            newLine.setTargetAt(oldLine.getEndTarget(), 1, oldLine.getEndLinkPositionInfo());
            oldLine.setTargetAt((GLinkTarget)newPoint, 1, (GLinkPositionInfo)null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.insertCreasePoint(newPoint, index);
        this.insertLine(newLine, index + 1);
        this.setupNewLinesByAddPoint(lineModVec, index, oldLine, newLine, paramMap);
        if (parentComplex3 != null) {
            GLinkedLineIndex idx = parentComplex3.getLineIndex(newPoint.getPosition().x, newPoint.getPosition().y);
            if (parentComplex3 instanceof DimerFormation) {
                if (idx.arm == 2) {
                    mustConfirmProcessNodeIdx = true;
                }
            } else if (parentComplex3 instanceof Dissociation) {
                if (idx.arm == 0) {
                    mustConfirmProcessNodeIdx = true;
                }
            } else if (parentComplex3 instanceof Truncation && idx.arm == 0) {
                mustConfirmProcessNodeIdx = true;
            }
            double dLENofStartPointNewPoint = 0.0;
            double dLENofEndPointNewPoint = 0.0;
            try {
                dLENofStartPointNewPoint = this.getLine(idx).getStartPoint().distance(newPoint.getPosition().x, newPoint.getPosition().y);
                dLENofEndPointNewPoint = this.getLine(idx).getEndPoint().distance(newPoint.getPosition().x, newPoint.getPosition().y);
            }
            catch (Exception e) {
                dLENofStartPointNewPoint = 0.0;
                dLENofEndPointNewPoint = 0.0;
            }
            if (mustConfirmProcessNodeIdx) {
                if (iOldProcessNodeIdx >= idx.line) {
                    if (iOldProcessNodeIdx == idx.line) {
                        if (idx.line >= 0 && idx.line < this.getCreasePointsSize()) {
                            if (dLENofEndPointNewPoint > dLENofStartPointNewPoint) {
                                parentComplex3.resetProcessNode(parentComplex3, iOldProcessNodeIdx + 1);
                            } else {
                                parentComplex3.resetProcessNode(parentComplex3, iOldProcessNodeIdx);
                            }
                        } else {
                            parentComplex3.resetProcessNode(parentComplex3, 0);
                        }
                    } else {
                        parentComplex3.resetProcessNode(parentComplex3, iOldProcessNodeIdx + 1);
                    }
                }
                iNewProcessNodeIdx = parentComplex3.getProcessNodeIndex();
            }
        } else if (this instanceof StateTransition) {
            mustConfirmProcessNodeIdx = true;
            double dLENofStartPointNewPoint = 0.0;
            double dLENofEndPointNewPoint = 0.0;
            GLinkedLineIndex idx = this.getLineIndex(newPoint.getPosition().x, newPoint.getPosition().y);
            try {
                dLENofStartPointNewPoint = this.lines[idx.line].getStartPoint().distance(newPoint.getPosition().x, newPoint.getPosition().y);
                dLENofEndPointNewPoint = this.lines[idx.line].getEndPoint().distance(newPoint.getPosition().x, newPoint.getPosition().y);
            }
            catch (Exception e) {
                dLENofStartPointNewPoint = 0.0;
                dLENofEndPointNewPoint = 0.0;
            }
            iNewProcessNodeIdx = iOldProcessNodeIdx < idx.line ? iOldProcessNodeIdx : (iOldProcessNodeIdx == idx.line ? (idx.line >= 0 && idx.line < this.getCreasePointsSize() ? (dLENofEndPointNewPoint > dLENofStartPointNewPoint ? iOldProcessNodeIdx + 1 : iOldProcessNodeIdx) : 0) : iOldProcessNodeIdx + 1);
            ((StateTransition)this).resetPorcessNode(iNewProcessNodeIdx);
        }
        this.setDefaultTargetLineIndex((size + 1) / 2);
        if (mustConfirmProcessNodeIdx) {
            if (parentComplex3 != null) {
                parentComplex3.resetProcessNode(parentComplex3, iNewProcessNodeIdx);
            } else if (this instanceof StateTransition) {
                ((StateTransition)this).resetPorcessNode(iNewProcessNodeIdx);
            }
        }
        Rectangle2D.Double areaNew = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }

    public Rectangle2D addCreasePoint(double x, double y, GStructure structure) {
        GLink glink = this.getReactionLink(structure);
        HashMap mapOldLinkLineIndex = new HashMap();
        HashMap mapNewLinkLineIndex = new HashMap();
        int iOldProcessNodeIdx = -1;
        int iNewProcessNodeIdx = -1;
        GLinkedLineComplex3 parentComplex3 = this.getcomplex3Parent();
        if (parentComplex3 != null) {
            iOldProcessNodeIdx = parentComplex3.getProcessNodeIndex();
        } else if (this instanceof StateTransition) {
            StateTransition st = (StateTransition)this;
            iOldProcessNodeIdx = st.getOmittedShapeIndex();
        } else if (this instanceof LinkedCreaseLineMixedNotation) {
            mapOldLinkLineIndex = this.getAllLinksLinkingToLinkedCreaseLineMixedNotation(structure);
        }
        GLinkedLineIndex index = this.getLineIndex(x, y);
        GCreasePoint newPoint = this.createNewCreasePoint(x, y, index);
        Rectangle2D updateRect = this.addCreasePointWithoutNotify(newPoint, structure, index.line, null);
        if (parentComplex3 != null) {
            iNewProcessNodeIdx = parentComplex3.getProcessNodeIndex();
        } else if (this instanceof StateTransition) {
            StateTransition st = (StateTransition)this;
            iNewProcessNodeIdx = st.getOmittedShapeIndex();
        } else if (this instanceof LinkedCreaseLineMixedNotation) {
            mapNewLinkLineIndex = this.resetAllLinksLinkLineIndex(mapOldLinkLineIndex, glink, index.line, newPoint.getPosition(), true);
        }
        if (updateRect != null) {
            GCreasePointForUndo p1 = new GCreasePointForUndo(newPoint, index.line, null);
            p1.setOldProcessnodeIndex(iOldProcessNodeIdx);
            p1.setNewProcessnodeIndex(iNewProcessNodeIdx);
            GLinkedCreaseLine.removeNoChangedElement(mapOldLinkLineIndex, mapNewLinkLineIndex);
            p1.setOldLinkLineIndexMap(mapOldLinkLineIndex);
            p1.setNewLinkLineIndexMap(mapNewLinkLineIndex);
            structure.notifyChange(p1, 1, null);
        }
        Rectangle2D.Double newshprec = this.updateShape();
        updateRect = GUtil.union(updateRect, newshprec);
        return updateRect;
    }

    public Rectangle2D.Double calcOldBounds() {
        Rectangle2D.Double rect = null;
        int i = 0;
        while (i < this.creasePoints.length) {
            rect = GUtil.union(rect, this.creasePoints[i].getBounds());
            ++i;
        }
        return rect;
    }

    protected int decideIndexOfCreasePoint(GCreasePoint p) {
        int i = 0;
        while (i < this.creasePoints.length) {
            if (this.creasePoints[i] == p) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected MapAndRect removeCreasePointWithoutNotifyPrivate(GCreasePoint p, GStructure structure, int index) {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D.Double areaOld = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        int iOldProcessNodeIdx = 0;
        int iNewProcessNodeIdx = -1;
        boolean mustConfirmProcessNodeIdx = false;
        GLinkedLineComplex3 parentComplex3 = this.getcomplex3Parent();
        if (parentComplex3 != null) {
            iOldProcessNodeIdx = parentComplex3.getProcessNodeIndex();
            GLinkedStraightLine[] vGsl = this.getLines();
            int i = 0;
            while (i < vGsl.length) {
                Vector v = vGsl[i].getLineModifications();
                if (v != null && v.contains(parentComplex3.getProcessNode())) {
                    mustConfirmProcessNodeIdx = true;
                    break;
                }
                ++i;
            }
        } else if (this instanceof StateTransition) {
            mustConfirmProcessNodeIdx = true;
            StateTransition st = (StateTransition)this;
            iOldProcessNodeIdx = st.getOmittedShapeIndex();
        }
        GLinkedStraightLine oldLine1 = this.lines[index];
        GLinkedStraightLine oldLine2 = this.lines[index + 1];
        Vector lineModVec1 = oldLine1.getLineModifications();
        Vector lineModVec2 = oldLine2.getLineModifications();
        oldLine1.clearLineModifications();
        oldLine2.clearLineModifications();
        try {
            oldLine1.setTargetAt(oldLine2.getEndTarget(), 1, oldLine2.getEndLinkPositionInfo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeCreasePoint(index);
        this.removeLine(index + 1);
        Map paramMap = this.setupNewLinesByRemovePoint(lineModVec1, lineModVec2, index, oldLine1);
        if (mustConfirmProcessNodeIdx) {
            if (iOldProcessNodeIdx > index) {
                if (parentComplex3 != null) {
                    parentComplex3.resetProcessNode(parentComplex3, iOldProcessNodeIdx - 1);
                    iNewProcessNodeIdx = parentComplex3.getProcessNodeIndex();
                } else if (this instanceof StateTransition) {
                    StateTransition st = (StateTransition)this;
                    iNewProcessNodeIdx = iOldProcessNodeIdx - 1;
                    st.resetPorcessNode(iNewProcessNodeIdx);
                }
            } else {
                mustConfirmProcessNodeIdx = false;
            }
        }
        int size = this.lines.length;
        this.setDefaultTargetLineIndex(size / 2);
        if (mustConfirmProcessNodeIdx) {
            if (parentComplex3 != null) {
                parentComplex3.resetProcessNode(parentComplex3, iNewProcessNodeIdx);
            } else if (this instanceof StateTransition) {
                StateTransition st = (StateTransition)this;
                st.resetPorcessNode(iNewProcessNodeIdx);
            }
        }
        Rectangle2D.Double areaNew = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return new MapAndRect(paramMap, redrawArea);
    }

    public Rectangle2D removeCreasePointWithoutNotify(GCreasePoint p, GStructure structure, int index) {
        return this.removeCreasePointWithoutNotifyPrivate(p, structure, index).getRect();
    }

    public Rectangle2D removeCreasePoint(GCreasePoint p, GStructure structure) {
        GLink glink = this.getReactionLink(structure);
        HashMap mapOldLinkLineIndex = new HashMap();
        HashMap mapNewLinkLineIndex = new HashMap();
        Rectangle2D updateRect = null;
        int iOldProcessNodeIdx = -1;
        int iNewProcessNodeIdx = -1;
        GLinkedLineComplex3 parentComplex3 = this.getcomplex3Parent();
        if (parentComplex3 != null) {
            iOldProcessNodeIdx = parentComplex3.getProcessNodeIndex();
        } else if (this instanceof StateTransition) {
            StateTransition st = (StateTransition)this;
            iOldProcessNodeIdx = st.getOmittedShapeIndex();
        } else if (this instanceof LinkedCreaseLineMixedNotation) {
            mapOldLinkLineIndex = this.getAllLinksLinkingToLinkedCreaseLineMixedNotation(structure);
        }
        int index = this.decideIndexOfCreasePoint(p);
        if (index >= 0) {
            MapAndRect mAndR = this.removeCreasePointWithoutNotifyPrivate(p, structure, index);
            updateRect = mAndR.getRect();
            if (parentComplex3 != null) {
                iNewProcessNodeIdx = parentComplex3.getProcessNodeIndex();
            } else if (this instanceof StateTransition) {
                StateTransition st = (StateTransition)this;
                iNewProcessNodeIdx = st.getOmittedShapeIndex();
            } else if (this instanceof LinkedCreaseLineMixedNotation) {
                mapNewLinkLineIndex = this.resetAllLinksLinkLineIndex(mapOldLinkLineIndex, glink, index, null, false);
            }
            GCreasePointForUndo p1 = new GCreasePointForUndo(p, index, mAndR.getMap());
            p1.setOldProcessnodeIndex(iOldProcessNodeIdx);
            p1.setNewProcessnodeIndex(iNewProcessNodeIdx);
            GLinkedCreaseLine.removeNoChangedElement(mapOldLinkLineIndex, mapNewLinkLineIndex);
            p1.setOldLinkLineIndexMap(mapOldLinkLineIndex);
            p1.setNewLinkLineIndexMap(mapNewLinkLineIndex);
            structure.notifyChange(p1, 2, null);
        }
        Rectangle2D.Double newshprec = this.updateShape();
        updateRect = GUtil.union(updateRect, newshprec);
        return updateRect;
    }

    protected Map setupNewLinesByRemovePoint(Vector vec1, Vector vec2, int i, GLinkedStraightLine newLine) {
        for (GLinkedLineModificationShape m : vec1) {
            newLine.addModificationShape(m);
        }
        for (GLinkedLineModificationShape m : vec2) {
            newLine.addModificationShape(m);
        }
        return null;
    }

    private Object[] arrayShrink(Object[] array, Object[] oldArray, int index) {
        int size = oldArray.length - 1;
        int offset = 0;
        int i = 0;
        while (i < size + 1) {
            if (i != index) {
                array[offset++] = oldArray[i];
            }
            ++i;
        }
        return array;
    }

    private void removeLine(int index) {
        int size = this.lines.length - 1;
        Object[] array = new GLinkedStraightLine[size];
        this.lines = (GLinkedStraightLine[])this.arrayShrink(array, this.lines, index);
    }

    private void removeCreasePoint(int index) {
        int size = this.creasePoints.length - 1;
        Object[] array = new GCreasePoint[size];
        this.creasePoints = (GCreasePoint[])this.arrayShrink(array, this.creasePoints, index);
    }

    protected void setupNewLinesByAddPoint(Vector vec, int index, GLinkedStraightLine oldLine, GLinkedStraightLine newLine, Map paramMap) {
    }

    private Object[] arrayInsert(Object[] array, Object[] oldArray, Object obj, int index) {
        int offset = 0;
        int n = oldArray.length;
        int i = 0;
        while (i < n) {
            if (i == index) {
                array[i] = obj;
                offset = 1;
            }
            array[i + offset] = oldArray[i];
            ++i;
        }
        if (offset == 0) {
            array[n] = obj;
        }
        return array;
    }

    private void insertCreasePoint(GCreasePoint p, int index) {
        int n = this.creasePoints.length;
        Object[] array = new GCreasePoint[n + 1];
        this.creasePoints = (GCreasePoint[])this.arrayInsert(array, this.creasePoints, p, index);
    }

    private void insertLine(GLinkedStraightLine l, int index) {
        int n = this.lines.length;
        Object[] array = new GLinkedStraightLine[n + 1];
        this.lines = (GLinkedStraightLine[])this.arrayInsert(array, this.lines, l, index);
    }

    @Override
    public void initLinesDirection() {
        if (this.connectPolicy != 1 || this.lines.length < 1 || this.start == null) {
            return;
        }
        int lastDir = 1;
        Point2D.Double p1 = null;
        Point2D.Double p2 = this.start;
        int n = this.lines.length;
        int i = 0;
        while (i < n) {
            p1 = p2;
            Point2D.Double double_ = p2 = i == n - 1 ? this.end : this.creasePoints[i].getPosition();
            if (p2 == null) {
                return;
            }
            double w = Math.abs(p2.x - p1.x);
            double h = Math.abs(p2.y - p1.y);
            int dir = w > 0.5 && h <= 0.5 ? 2 : (h > 0.5 && w <= 0.5 ? 1 : (lastDir == 1 ? 2 : 1));
            this.lines[i].setDirection(dir);
            lastDir = dir;
            ++i;
        }
    }

    protected void setLines(GLinkedStraightLine[] glinkedstraightlines) throws Exception {
        if (glinkedstraightlines.length < 1) {
            throw new Exception("lines.length must >=1");
        }
        this.lines = glinkedstraightlines;
        this.creasePoints = new GCreasePoint[glinkedstraightlines.length - 1];
        int i = 0;
        while (i < this.creasePoints.length) {
            this.creasePoints[i] = this.createCreasePoint();
            this.creasePoints[i].setOwner(this);
            try {
                glinkedstraightlines[i].setTargetAt((GLinkTarget)this.creasePoints[i], 1, (GLinkPositionInfo)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                glinkedstraightlines[i + 1].setTargetAt((GLinkTarget)this.creasePoints[i], 0, (GLinkPositionInfo)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.initCreasePointPositions();
    }

    public abstract GCreasePoint createCreasePoint();

    @Override
    public void setOffset(double x, double y) {
        super.setOffset(x, y);
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i].setOffset(x, y);
            ++i;
        }
        i = 0;
        while (i < this.creasePoints.length) {
            this.creasePoints[i].setVisualOffset(x, y);
            ++i;
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int i, GLinkPositionInfo lpi) throws Exception {
        super.setTargetAt(glinktarget, i, lpi);
        if (i == 0) {
            this.lines[0].setTargetAt(glinktarget, 0, lpi);
            this.standardLine.setTargetAt(glinktarget, 0, lpi);
        } else if (i == 1) {
            this.lines[this.lines.length - 1].setTargetAt(glinktarget, 1, lpi);
            this.standardLine.setTargetAt(glinktarget, 1, lpi);
        } else {
            throw new Exception("index must 0 or 1");
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, double x, double y, GLinkPositionInfo lpi) throws Exception {
        super.setTargetAt(glinktarget, index, x, y, lpi);
        if (index == 0) {
            this.lines[0].setTargetAt(glinktarget, 0, x, y, lpi);
            this.standardLine.setTargetAt(glinktarget, 0, x, y, lpi);
        } else if (index == 1) {
            this.lines[this.lines.length - 1].setTargetAt(glinktarget, 1, x, y, lpi);
            this.standardLine.setTargetAt(glinktarget, 1, x, y, lpi);
        } else {
            throw new Exception("index must 0 or 1");
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int index, GLinkedLineIndex glinkedlineindex) throws Exception {
        super.setTargetAt(glinktarget, index, glinkedlineindex);
        if (index == 0) {
            this.lines[0].setTargetAt(glinktarget, 0, glinkedlineindex);
            this.standardLine.setTargetAt(glinktarget, 0, glinkedlineindex);
        } else if (index == 1) {
            this.lines[this.lines.length - 1].setTargetAt(glinktarget, 1, glinkedlineindex);
            this.standardLine.setTargetAt(glinktarget, 1, glinkedlineindex);
        } else {
            throw new Exception("index must 0 or 1");
        }
    }

    @Override
    public Point2D.Double targetPoint() {
        return this.lines[this.defaultTargetLineIndex].targetPoint();
    }

    @Override
    public Rectangle2D.Double updateLine() {
        return this.updateLine(true);
    }

    private Rectangle2D.Double updateCreasePoint(Rectangle2D.Double newBounds, boolean moveCreasePoints, GEditPoint ep) {
        Point2D.Double localPos1;
        Point2D.Double pos1 = ep.getPosition();
        if (moveCreasePoints) {
            localPos1 = ep.getLocalPosition();
            this.localAT.transform(localPos1, pos1);
        } else {
            localPos1 = new Point2D.Double();
            this.inverse.transform(pos1, localPos1);
            ep.setLocalPosition(localPos1);
        }
        Rectangle2D redrawArea = ep.update();
        Rectangle2D.Double editPointBnds = ep.getBounds();
        this.bounds = GUtil.union(this.bounds, editPointBnds);
        newBounds = GUtil.union(newBounds, redrawArea);
        return newBounds;
    }

    private Rectangle2D.Double updateCreasePoints(Rectangle2D.Double newBounds, boolean moveCreasePoints) {
        if (this.connectPolicy == 1 && !moveCreasePoints && this.lines.length > 0) {
            int add = this.lines.length - 1;
            if (add <= 0) {
                add = 1;
            }
            int i = 0;
            while (this.creasePoints != null && this.creasePoints.length > 0 && i < this.lines.length) {
                Point2D.Double p;
                Point2D.Double p0;
                int dir = this.lines[i].getDirection();
                int ip = i == 0 ? i : i - 1;
                Point2D.Double double_ = p0 = i == 0 ? this.start : this.end;
                if (dir == 2) {
                    p = this.creasePoints[ip].getPosition();
                    p.y = p0.y;
                } else if (dir == 1) {
                    p = this.creasePoints[ip].getPosition();
                    p.x = p0.x;
                }
                i += add;
            }
        }
        int i = 0;
        while (i < this.creasePoints.length) {
            try {
                newBounds = this.updateCreasePoint(newBounds, moveCreasePoints, this.creasePoints[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return newBounds;
    }

    protected static Vector getNextPointOfTheStartOrEnd(GLinkTarget target, Point2D.Double p, GLinkPositionInfo lpi) {
        Rectangle2D.Double bRect = target.getBoundsAsTarget();
        double w = 0.0;
        double h = 0.0;
        if (target.getBoundsAsTarget() != null) {
            w = target.getBoundsAsTarget().width;
            h = target.getBoundsAsTarget().height;
        }
        if (bRect == null || lpi == null) {
            Vector<Point2D.Double> v = new Vector<Point2D.Double>(4);
            double x = p.x;
            double y = p.y;
            v.addElement(new Point2D.Double(x + w / 2.0 + 15.0, y));
            v.addElement(new Point2D.Double(x - w / 2.0 - 15.0, y));
            v.addElement(new Point2D.Double(x, y + h / 2.0 + 15.0));
            v.addElement(new Point2D.Double(x, y - h / 2.0 - 15.0));
            return v;
        }
        Rectangle2D.Double r = GLinkedCreaseLine.getEnlargedRect(bRect, null);
        int lpiPos = lpi.getPositionForLink();
        double x = p.x;
        double y = p.y;
        switch (lpiPos) {
            case 0: 
            case 1: 
            case 2: 
            case 14: 
            case 15: {
                y = r.y;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                x = r.x + r.width;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                y = r.y + r.height;
                break;
            }
            default: {
                x = r.x;
            }
        }
        Vector<Point2D.Double> v = new Vector<Point2D.Double>(1);
        v.addElement(new Point2D.Double(x, y));
        return v;
    }

    private Vector getNextPointOfTheEnd(GLinkedStraightLine line1, Point2D.Double pe) {
        double x = pe.x;
        double y = pe.y;
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        double sx = line1.start.x;
        double sy = line1.start.y;
        double ex = line1.end.x;
        double ey = line1.end.y;
        double dx = Math.abs(sx - ex);
        double dy = Math.abs(sy - ey);
        if (dx <= eps && dy <= eps) {
            v.addElement(new Point2D.Double(x + 15.0, y));
            v.addElement(new Point2D.Double(x - 15.0, y));
            v.addElement(new Point2D.Double(x, y + 15.0));
            v.addElement(new Point2D.Double(x, y - 15.0));
        } else if (dx <= eps || dy / dx > 8.0) {
            v.addElement(new Point2D.Double(x + 15.0, y));
            v.addElement(new Point2D.Double(x - 15.0, y));
        } else if (dy <= eps || dx / dy > 8.0) {
            v.addElement(new Point2D.Double(x, y + 15.0));
            v.addElement(new Point2D.Double(x, y - 15.0));
        } else {
            v.addElement(new Point2D.Double(x + 15.0, y));
            v.addElement(new Point2D.Double(x - 15.0, y));
            v.addElement(new Point2D.Double(x, y + 15.0));
            v.addElement(new Point2D.Double(x, y - 15.0));
        }
        return v;
    }

    private static int unitVectorElement(double d) {
        if (d < -eps) {
            return -1;
        }
        return d > eps ? 1 : 0;
    }

    private static boolean isCrossing1(Rectangle2D.Double r, Point2D.Double p1, Point2D.Double p2) {
        Rectangle2D.Double r1 = new Rectangle2D.Double(r.x + 1.0, r.y + 1.0, r.width - 2.0, r.height - 2.0);
        return r1.intersectsLine(p1.x, p1.y, p2.x, p2.y);
    }

    private static Rectangle2D.Double getEnlargedRect(Rectangle2D.Double r, Point2D.Double vec) {
        if (r == null) {
            return null;
        }
        double x1 = vec != null && vec.x >= -eps ? 3 : 15;
        double x2 = vec != null && vec.x <= eps ? 3 : 15;
        double y1 = vec != null && vec.y >= -eps ? 3 : 15;
        double y2 = vec != null && vec.y <= eps ? 3 : 15;
        Rectangle2D.Double r1 = new Rectangle2D.Double(r.x - x1, r.y - y1, r.width + x1 + x2, r.height + y1 + y2);
        return r1;
    }

    private static Point2D.Double getRectangleCorner(Rectangle2D.Double r, int type) {
        double y;
        double x;
        int xflag = type % 3;
        int yflag = type / 3 * 3;
        switch (xflag) {
            case 0: {
                x = r.x;
                break;
            }
            case 2: {
                x = r.x + r.width;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (yflag) {
            case 0: {
                y = r.y;
                break;
            }
            case 6: {
                y = r.y + r.height;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new Point2D.Double(x, y);
    }

    private static Vector createNextCreasePointsCandidates(Point2D.Double p, Point2D.Double v, Rectangle2D.Double r) {
        Vector<Point2D.Double> vec = new Vector<Point2D.Double>();
        int xflag = Math.abs(p.x - r.x) <= eps ? 0 : (Math.abs(p.x - (r.x + r.width)) <= eps ? 2 : 1);
        int yflag = Math.abs(p.y - r.y) <= eps ? 0 : (Math.abs(p.y - (r.y + r.height)) <= eps ? 6 : 3);
        int pos = 0;
        if (xflag == 0 && yflag == 0) {
            pos = 0;
        } else if (xflag == 0 && yflag == 3) {
            pos = 3;
        } else if (xflag == 0 && yflag == 6) {
            pos = 6;
        } else if (xflag == 1 && yflag == 0) {
            pos = 1;
        } else if (xflag == 1 && yflag == 3) {
            pos = 1;
        } else if (xflag == 1 && yflag == 6) {
            pos = 7;
        } else if (xflag == 2 && yflag == 0) {
            pos = 2;
        } else if (xflag == 2 && yflag == 3) {
            pos = 5;
        } else if (xflag == 2 && yflag == 6) {
            pos = 8;
        }
        switch (pos) {
            case 0: {
                if (Math.abs(v.x) > eps) {
                    vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 6));
                    break;
                }
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 2));
                break;
            }
            case 1: {
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 0));
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 2));
                break;
            }
            case 2: {
                if (Math.abs(v.x) > eps) {
                    vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 8));
                    break;
                }
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 0));
                break;
            }
            case 3: {
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 0));
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 6));
                break;
            }
            case 5: {
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 2));
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 8));
                break;
            }
            case 6: {
                if (Math.abs(v.x) > eps) {
                    vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 0));
                    break;
                }
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 8));
                break;
            }
            case 7: {
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 6));
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 8));
                break;
            }
            case 8: {
                if (Math.abs(v.x) > eps) {
                    vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 2));
                    break;
                }
                vec.addElement(GLinkedCreaseLine.getRectangleCorner(r, 6));
            }
        }
        return vec;
    }

    protected static double calcCreasePointsPathLength(Vector points) {
        double length = 0.0;
        int n = points.size();
        Point2D.Double p1 = (Point2D.Double)points.elementAt(0);
        int i = 1;
        while (i < n) {
            Point2D.Double p2 = (Point2D.Double)points.elementAt(i);
            length += p1.distance(p2);
            p1 = p2;
            ++i;
        }
        return length;
    }

    private static Vector createCreasePointsCoordForSquareNotCrossing(Point2D.Double ps, Point2D.Double vs, Point2D.Double pe, Point2D.Double ve) {
        Vector<Point2D.Double> vec1 = new Vector<Point2D.Double>();
        int vecsx = GLinkedCreaseLine.unitVectorElement(vs.x);
        int vecsy = GLinkedCreaseLine.unitVectorElement(vs.y);
        int vecex = GLinkedCreaseLine.unitVectorElement(ve.x);
        int vecey = GLinkedCreaseLine.unitVectorElement(ve.y);
        if ((double)Math.abs(vecsx + vecex) <= eps && (double)Math.abs(vecsy + vecey) <= eps) {
            if ((double)Math.abs(vecsx) > eps) {
                if (Math.abs(ps.y - pe.y) > eps) {
                    double x1 = (ps.x + pe.x) * 0.5;
                    vec1.addElement(new Point2D.Double(x1, ps.y));
                    vec1.addElement(new Point2D.Double(x1, pe.y));
                }
            } else if (Math.abs(ps.x - pe.x) > eps) {
                double y1 = (ps.y + pe.y) * 0.5;
                vec1.addElement(new Point2D.Double(ps.x, y1));
                vec1.addElement(new Point2D.Double(pe.x, y1));
            }
        } else if ((double)Math.abs(vecsx - vecex) <= eps && (double)Math.abs(vecsy - vecey) <= eps) {
            if ((double)Math.abs(vecsx) > eps) {
                double x1 = vecsx > 0 ? (ps.x > pe.x ? ps.x : pe.x) : (ps.x < pe.x ? ps.x : pe.x);
                vec1.addElement(new Point2D.Double(x1 += (double)(vecsx * 15), ps.y));
                vec1.addElement(new Point2D.Double(x1, pe.y));
            } else {
                double y1 = vecsy > 0 ? (ps.y > pe.y ? ps.y : pe.y) : (ps.y < pe.y ? ps.y : pe.y);
                vec1.addElement(new Point2D.Double(ps.x, y1 += (double)(vecsy * 15)));
                vec1.addElement(new Point2D.Double(pe.x, y1));
            }
        } else {
            double y1;
            double x1;
            if ((double)Math.abs(vecsx) > eps) {
                x1 = pe.x;
                y1 = ps.y;
            } else {
                x1 = ps.x;
                y1 = pe.y;
            }
            vec1.addElement(new Point2D.Double(x1, y1));
        }
        return vec1;
    }

    private static Vector createCreasePointsCoordForSquare(Point2D.Double ps, Point2D.Double vs, Point2D.Double pe, Point2D.Double ve, Rectangle2D.Double rs, Rectangle2D.Double re, int nest) {
        Vector vec1 = null;
        if (++nest > 4) {
            return vec1;
        }
        boolean cross_s = rs == null ? false : GLinkedCreaseLine.isCrossing1(rs, ps, pe);
        boolean cross_e = re == null ? false : GLinkedCreaseLine.isCrossing1(re, ps, pe);
        double length1 = 0.0;
        int count1 = 0;
        if (cross_s && cross_e) {
            if (nest <= 2) {
                boolean checkPe;
                Vector vecCans = GLinkedCreaseLine.createNextCreasePointsCandidates(ps, vs, rs);
                Vector vecCane = GLinkedCreaseLine.createNextCreasePointsCandidates(pe, ve, re);
                if (vecCans.size() <= 0 || vecCane.size() <= 0) {
                    throw new RuntimeException();
                }
                boolean checkPs = vecCans.size() == 2;
                boolean bl = checkPe = vecCane.size() == 2;
                if (checkPs) {
                    vecCans.add(0, ps);
                }
                if (checkPe) {
                    vecCane.add(0, pe);
                }
                int i = 0;
                while (i < vecCans.size()) {
                    Point2D.Double p1 = (Point2D.Double)vecCans.elementAt(i);
                    Point2D.Double v1 = checkPs && i == 0 ? vs : new Point2D.Double(p1.x - ps.x, p1.y - ps.y);
                    int j = 0;
                    while (j < vecCane.size()) {
                        if (!checkPs || !checkPe || i != 0 || j != 0) {
                            Point2D.Double v2;
                            Point2D.Double p2 = (Point2D.Double)vecCane.elementAt(j);
                            Vector vec2 = GLinkedCreaseLine.createCreasePointsCoordForSquare(p1, v1, p2, v2 = checkPe && j == 0 ? ve : new Point2D.Double(p2.x - pe.x, p2.y - pe.y), rs, re, nest);
                            if (vec2 != null) {
                                if (!checkPs || i != 0) {
                                    vec2.add(0, ps);
                                }
                                if (!checkPe || j != 0) {
                                    vec2.addElement(pe);
                                }
                                double length2 = GLinkedCreaseLine.calcCreasePointsPathLength(vec2);
                                int count2 = vec2.size();
                                if (vec1 == null || length2 < length1 + eps || length2 <= length1 + eps && count2 < count1) {
                                    vec1 = vec2;
                                    length1 = length2;
                                    count1 = count2;
                                }
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        } else if (cross_s) {
            Vector vecCan = GLinkedCreaseLine.createNextCreasePointsCandidates(ps, vs, rs);
            if (vecCan.size() <= 0) {
                throw new RuntimeException();
            }
            int i = 0;
            while (i < vecCan.size()) {
                Point2D.Double v1;
                Point2D.Double p1 = (Point2D.Double)vecCan.elementAt(i);
                Vector vec2 = GLinkedCreaseLine.createCreasePointsCoordForSquare(p1, v1 = new Point2D.Double(p1.x - ps.x, p1.y - ps.y), pe, ve, rs, re, nest);
                if (vec2 != null) {
                    vec2.add(0, ps);
                    double length2 = GLinkedCreaseLine.calcCreasePointsPathLength(vec2);
                    int count2 = vec2.size();
                    if (vec1 == null || length2 < length1 + eps || length2 <= length1 + eps && count2 < count1) {
                        vec1 = vec2;
                        length1 = length2;
                        count1 = count2;
                    }
                }
                ++i;
            }
        } else if (cross_e) {
            Vector vecCan = GLinkedCreaseLine.createNextCreasePointsCandidates(pe, ve, re);
            if (vecCan.size() <= 0) {
                throw new RuntimeException();
            }
            int i = 0;
            while (i < vecCan.size()) {
                Point2D.Double v1;
                Point2D.Double p1 = (Point2D.Double)vecCan.elementAt(i);
                Vector vec2 = GLinkedCreaseLine.createCreasePointsCoordForSquare(ps, vs, p1, v1 = new Point2D.Double(p1.x - pe.x, p1.y - pe.y), rs, re, nest);
                if (vec2 != null) {
                    vec2.addElement(pe);
                    double length2 = GLinkedCreaseLine.calcCreasePointsPathLength(vec2);
                    int count2 = vec2.size();
                    if (vec1 == null || length2 < length1 + eps || length2 <= length1 + eps && count2 < count1) {
                        vec1 = vec2;
                        length1 = length2;
                        count1 = count2;
                    }
                }
                ++i;
            }
        } else {
            vec1 = GLinkedCreaseLine.createCreasePointsCoordForSquareNotCrossing(ps, vs, pe, ve);
            vec1.add(0, ps);
            vec1.addElement(pe);
        }
        return vec1;
    }

    private static void normalizeCreasePointVectorForSquare(Vector posVec) {
        int n = posVec.size();
        int i = 0;
        while (i < n - 2) {
            Point2D.Double p1 = (Point2D.Double)posVec.elementAt(i);
            Point2D.Double p2 = (Point2D.Double)posVec.elementAt(i + 1);
            Point2D.Double p3 = (Point2D.Double)posVec.elementAt(i + 2);
            if (Math.abs(p1.x - p2.x) <= eps && Math.abs(p2.x - p3.x) <= eps || Math.abs(p1.y - p2.y) <= eps && Math.abs(p2.y - p3.y) <= eps) {
                posVec.remove(i + 1);
                --i;
                n = posVec.size();
            }
            ++i;
        }
    }

    protected static Vector getInitialCreasePointsForSquare(Point2D.Double ps, Point2D.Double pe, Rectangle2D.Double rects, Rectangle2D.Double recte, Vector nextsVec, Vector nexteVec, boolean forceToGet) {
        Vector posVec = null;
        double length = 0.0;
        int count = 0;
        boolean considerRS = true;
        boolean considerRE = true;
        double penalty = 10000.0 + ps.distance(pe) * 1000.0;
        int j = 0;
        while (j < nextsVec.size()) {
            Point2D.Double nexts1 = (Point2D.Double)nextsVec.elementAt(j);
            Point2D.Double vecs1 = new Point2D.Double(nexts1.x - ps.x, nexts1.y - ps.y);
            Rectangle2D.Double rs = !considerRS ? null : GLinkedCreaseLine.getEnlargedRect(rects, vecs1);
            int i = 0;
            while (i < nexteVec.size()) {
                Point2D.Double nexte1 = (Point2D.Double)nexteVec.elementAt(i);
                Point2D.Double vece1 = new Point2D.Double(nexte1.x - pe.x, nexte1.y - pe.y);
                Rectangle2D.Double re = !considerRE ? null : GLinkedCreaseLine.getEnlargedRect(recte, vece1);
                Vector posVec1 = GLinkedCreaseLine.createCreasePointsCoordForSquare(nexts1, vecs1, nexte1, vece1, rs, re, 0);
                double penalty1 = 0.0;
                if (posVec1 == null) {
                    posVec1 = GLinkedCreaseLine.createCreasePointsCoordForSquareNotCrossing(nexts1, vecs1, nexte1, vece1);
                    posVec1.add(0, nexts1);
                    posVec1.addElement(nexte1);
                    penalty1 = penalty;
                }
                if (posVec1 != null) {
                    double length1 = GLinkedCreaseLine.calcCreasePointsPathLength(posVec1) + penalty1;
                    int count1 = posVec1.size();
                    if (posVec == null || length1 < length + eps || length1 == length + eps && count1 < count) {
                        posVec = posVec1;
                        length = length1;
                        count = count1;
                    }
                }
                ++i;
            }
            ++j;
        }
        posVec.add(0, ps);
        posVec.addElement(pe);
        GLinkedCreaseLine.normalizeCreasePointVectorForSquare(posVec);
        if (posVec.size() == 2) {
            double x = (ps.x + pe.x) * 0.5;
            double y = (ps.y + pe.y) * 0.5;
            posVec.add(1, new Point2D.Double(x, y));
            posVec.add(2, new Point2D.Double(x, y));
        }
        return posVec;
    }

    protected static int calcCreasePointNumberForSquare(Point2D.Double ps, Point2D.Double pe, Rectangle2D.Double rects, Rectangle2D.Double recte, Vector nextsVec, Vector nexteVec, Point2D.Double[] posArray) {
        Vector posVec = GLinkedCreaseLine.getInitialCreasePointsForSquare(ps, pe, rects, recte, nextsVec, nexteVec, false);
        if (posArray != null) {
            int n = posVec.size();
            int i = 1;
            while (i < n - 1) {
                posArray[i - 1] = (Point2D.Double)posVec.elementAt(i);
                ++i;
            }
        }
        return posVec.size() - 2;
    }

    private void initialSetupCreasePointsSquare() {
        Rectangle2D.Double recte;
        GLinkPositionInfo lpis = this.lines[0].getStartLinkPositionInfo();
        Vector nextsVec = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(this.startTarget, this.start, lpis);
        Rectangle2D.Double rects = nextsVec.size() == 1 ? this.startTarget.getBoundsAsTarget() : null;
        Vector nexteVec = null;
        GLinkedLineIndex llie = null;
        GLinkPositionInfo lpie = null;
        boolean bProcessingSameAsGLinkedStraightLine = false;
        boolean bTargetIsGate = false;
        GLinkedStraightLine tagerSubLine = null;
        GModificationRectangle rectangShape = null;
        Rectangle2D.Double rectGModificationRectangle = null;
        try {
            if (this.endTarget instanceof ReactionLink) {
                GLinkedLine glnkline;
                GLinkedShape glshp = ((ReactionLink)this.endTarget).getGLinkedShape();
                if (glshp instanceof GLinkedLineComplex3) {
                    tagerSubLine = ((GLinkedLineComplex3)glshp).getTheSubGLinkedStraightLineHavingProcessNode();
                    rectangShape = ((GLinkedLineComplex3)glshp).getProcessNode();
                } else if (glshp instanceof StateTransition) {
                    int idx = ((StateTransition)glshp).getOmittedShapeIndex();
                    GLinkedLine glnkline2 = ((StateTransition)glshp).getLine(idx);
                    if (glnkline2 instanceof GLinkedStraightLine) {
                        tagerSubLine = (GLinkedStraightLine)glnkline2;
                    }
                    rectangShape = ((StateTransition)glshp).getOmittedShape();
                } else if (glshp instanceof GLogicGate && (glnkline = ((GLogicGate)glshp).getRealLine().getLine(0)) instanceof GLinkedStraightLine && (tagerSubLine = (GLinkedStraightLine)glnkline) != null) {
                    bTargetIsGate = true;
                }
                if (tagerSubLine != null && rectangShape != null) {
                    rectGModificationRectangle = rectangShape.getModificationBounds();
                }
                if (rectGModificationRectangle != null) {
                    bProcessingSameAsGLinkedStraightLine = true;
                }
            }
        }
        catch (Exception myErr) {
            bProcessingSameAsGLinkedStraightLine = false;
            bTargetIsGate = false;
            tagerSubLine = null;
            rectGModificationRectangle = null;
        }
        if (this.endTarget instanceof GLinkedStraightLine) {
            llie = this.lines[this.lines.length - 1].getEndLineIndex();
            nexteVec = this.getNextPointOfTheEnd((GLinkedStraightLine)this.endTarget, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else if (bProcessingSameAsGLinkedStraightLine) {
            lpie = this.lines[this.lines.length - 1].getEndLinkPositionInfo();
            nexteVec = this.getNextPointOfTheEnd(tagerSubLine, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else if (bTargetIsGate) {
            GLinkedStraightLine gl = new GLinkedStraightLine();
            gl.setStartAndEndPoint((Point2D.Double)this.end.clone(), (Point2D.Double)this.end.clone());
            nexteVec = this.getNextPointOfTheEnd(gl, this.end);
            recte = new Rectangle2D.Double(this.end.x, this.end.y, 0.0, 0.0);
        } else {
            lpie = this.lines[this.lines.length - 1].getEndLinkPositionInfo();
            nexteVec = GLinkedCreaseLine.getNextPointOfTheStartOrEnd(this.endTarget, this.end, lpie);
            recte = this.endTarget.getBoundsAsTarget();
        }
        int n = GLinkedCreaseLine.calcCreasePointNumberForSquare(this.start, this.end, rects, recte, nextsVec, nexteVec, null);
        this.resetCreaseLineNumber(n + 1);
        try {
            this.setTargetAt(this.startTarget, 0, lpis);
            if (this.endTarget instanceof GLinkedStraightLine) {
                this.setTargetAt(this.endTarget, 1, llie);
            } else if (bProcessingSameAsGLinkedStraightLine) {
                this.setTargetAt(this.endTarget, 1, lpie);
            } else {
                this.setTargetAt(this.endTarget, 1, lpie);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.restoreLineModifications();
        this.initCreasePointPositions();
    }

    @Override
    public Rectangle2D.Double updateLine(boolean moveCreasePoints) {
        Rectangle2D.Double tmpBounds;
        Rectangle2D.Double tmpRedrawArea;
        Rectangle2D.Double newBounds = null;
        this.standardLine.updateLine();
        if (!(this instanceof LayerTagFreeLineSymbol) || this instanceof LayerTagFreeLineSymbol && this.standardLine.getStartPoint() != null && this.standardLine.getEndPoint() != null) {
            this.start = this.standardLine.getStartPoint();
            this.end = this.standardLine.getEndPoint();
            if ((this.standardLine.getStartLinkPositionInfo() == null || this.standardLine.getStartLinkPositionInfo().getPosition() == -1) && this.startTarget instanceof SpeciesAlias && this.startTarget.getBoundsAsTarget() != null) {
                this.start.x = this.startTarget.getBoundsAsTarget().getCenterX();
                this.start.y = this.startTarget.getBoundsAsTarget().getCenterY();
            }
            if ((this.standardLine.getEndLinkPositionInfo() == null || this.standardLine.getEndLinkPositionInfo().getPosition() == -1) && this.endTarget instanceof SpeciesAlias && this.endTarget.getBoundsAsTarget() != null) {
                this.end.x = this.endTarget.getBoundsAsTarget().getCenterX();
                this.end.y = this.endTarget.getBoundsAsTarget().getCenterY();
            }
        }
        GUtil.createLocalTransform(this.start, this.end, this.localAT);
        this.bounds = null;
        if (!this.creasePointsInitialized) {
            if (this.connectPolicy == 0) {
                this.initCreasePointPositions();
            } else {
                this.initialSetupCreasePointsSquare();
            }
            this.creasePointsInitialized = true;
        }
        if (!moveCreasePoints) {
            try {
                this.inverse = this.localAT.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        boolean bSuccessUpdatedCreasePoints = false;
        try {
            newBounds = this.updateCreasePoints(newBounds, moveCreasePoints);
            bSuccessUpdatedCreasePoints = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i].setLineWidth(this.lineWidth);
            if (this instanceof LayerTagFreeLineSymbol && this.start != null && this.end != null) {
                this.lines[i].setStartAndEndPoint(this.start, this.end);
            }
            tmpRedrawArea = this.lines[i].updateShape(moveCreasePoints);
            tmpBounds = this.lines[i].getShapeBounds();
            this.bounds = GUtil.union(this.bounds, tmpBounds);
            newBounds = GUtil.union(newBounds, tmpRedrawArea);
            ++i;
        }
        if (!bSuccessUpdatedCreasePoints) {
            try {
                newBounds = GUtil.union(newBounds, this.updateCreasePoints(newBounds, moveCreasePoints));
                i = 0;
                while (i < this.lines.length) {
                    this.lines[i].setLineWidth(this.lineWidth);
                    if (this instanceof LayerTagFreeLineSymbol) {
                        this.lines[i].setStartAndEndPoint(this.start, this.end);
                    }
                    tmpRedrawArea = this.lines[i].updateShape(moveCreasePoints);
                    tmpBounds = this.lines[i].getShapeBounds();
                    this.bounds = GUtil.union(this.bounds, tmpBounds);
                    newBounds = GUtil.union(newBounds, tmpRedrawArea);
                    ++i;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        if (this.startTarget != null && this.endTarget != null) {
            if (this.sHandlePoint != null) {
                Point2D.Double pos1 = this.getStartTargetPoint();
                this.sHandlePoint.setPosition(new Point2D.Double(pos1.x, pos1.y));
                newBounds = this.updateCreasePoint(newBounds, false, this.sHandlePoint);
            }
            Point2D.Double pos1 = this.getEndTargetPoint();
            this.eHandlePoint.setPosition(new Point2D.Double(pos1.x, pos1.y));
            newBounds = this.updateCreasePoint(newBounds, false, this.eHandlePoint);
        }
        return newBounds;
    }

    @Override
    public boolean isMovable() {
        if (this.creasePoints.length <= 0) {
            return false;
        }
        return super.isMovable();
    }

    @Override
    public int getTargetIndex(GEditPoint ep) {
        if (this.sHandlePoint != null && this.sHandlePoint == ep) {
            return 0;
        }
        if (this.eHandlePoint == ep) {
            return 1;
        }
        throw new RuntimeException();
    }

    @Override
    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        if (i == 0) {
            return this.startLinkPositionInfo;
        }
        if (i == 1) {
            return this.endLinkPositionInfo;
        }
        throw new RuntimeException();
    }

    @Override
    public int getConnectPolicy() {
        return this.connectPolicy;
    }

    @Override
    public void setConnectPolicy(int policy) {
        this.connectPolicy = policy;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public double getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setCreasePointsInitialized(boolean creasePointsInitialized) {
        this.creasePointsInitialized = creasePointsInitialized;
    }

    public int getCreasePointIndex(GEditPoint ep) {
        if (this.creasePoints != null) {
            int n = this.creasePoints.length;
            int i = 0;
            while (i < n) {
                if (this.creasePoints[i] == ep) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public void restrictEditPointMoveVector(GEditPoint ep1, GEditPoint ep2, Point2D.Double dxdy) {
        if (this.connectPolicy != 1) {
            return;
        }
        int n = this.creasePoints.length;
        int i1 = this.getCreasePointIndex(ep1);
        if (n <= 0 || i1 < 0) {
            return;
        }
        if (ep2 == null) {
            int dir;
            if (i1 == 0) {
                dir = this.lines[0].getDirection();
                if (dir == 2) {
                    dxdy.y = 0.0;
                } else if (dir == 1) {
                    dxdy.x = 0.0;
                }
            }
            if (i1 == n - 1) {
                dir = this.lines[n].getDirection();
                if (dir == 2) {
                    dxdy.y = 0.0;
                } else if (dir == 1) {
                    dxdy.x = 0.0;
                }
            }
        } else {
            int i2 = this.getCreasePointIndex(ep2);
            if (i2 < 0) {
                return;
            }
            int dir = 0;
            if (i2 == i1 + 1) {
                dir = this.lines[i2].getDirection();
            } else if (i1 == i2 + 1) {
                dir = this.lines[i1].getDirection();
            } else {
                return;
            }
            if (dir == 2) {
                dxdy.x = 0.0;
            } else if (dir == 1) {
                dxdy.y = 0.0;
            }
        }
    }

    @Override
    public void appendMovingPointAndPosition(GEditPoint ep1, Vector startXYVec) {
        int i1 = this.getCreasePointIndex(ep1);
        startXYVec.addElement(new ElementAndPosition(ep1, i1, ep1.getPosition()));
    }

    @Override
    public void appendAdditionalMovingPointAndPosition(GEditPoint ep1, Vector startXYVec) {
        GCreasePoint p;
        if (this.connectPolicy != 1) {
            return;
        }
        int n = this.creasePoints.length;
        int i1 = this.getCreasePointIndex(ep1);
        if (n <= 0 || i1 < 0) {
            return;
        }
        if (i1 > 0) {
            p = this.creasePoints[i1 - 1];
            startXYVec.addElement(new ElementAndPosition(p, i1 - 1, p.getPosition()));
        }
        if (i1 < n - 1) {
            p = this.creasePoints[i1 + 1];
            startXYVec.addElement(new ElementAndPosition(p, i1 + 1, p.getPosition()));
        }
    }

    public static Vector setMovedElementPositionDefault(double dx, double dy, Vector startXYVec) {
        int n = startXYVec.size();
        Vector<Point2D.Double> posvec = new Vector<Point2D.Double>(n);
        int i = 0;
        while (i < n) {
            ElementAndPosition eap = (ElementAndPosition)startXYVec.elementAt(i);
            posvec.addElement(new Point2D.Double(eap.getX() + dx, eap.getY() + dy));
            ++i;
        }
        return posvec;
    }

    @Override
    public Vector setMovedElementPosition(double dx, double dy, Vector startXYVec) {
        if (this.connectPolicy != 1) {
            return GLinkedCreaseLine.setMovedElementPositionDefault(dx, dy, startXYVec);
        }
        int n = startXYVec.size();
        Vector<Point2D.Double> posvec = new Vector<Point2D.Double>(n);
        double x0 = 0.0;
        double y0 = 0.0;
        int i0 = 0;
        int i = 0;
        while (i < n) {
            ElementAndPosition eap = (ElementAndPosition)startXYVec.elementAt(i);
            double newx = 0.0;
            double newy = 0.0;
            if (i == 0) {
                x0 = eap.getX();
                y0 = eap.getY();
                i0 = eap.getIndex();
                newx = x0 + dx;
                newy = y0 + dy;
            } else {
                double x = eap.getX();
                double y = eap.getY();
                int i1 = eap.getIndex();
                boolean setted = false;
                if (i0 >= 0 && i0 < this.creasePoints.length && i1 >= 0 && i1 < this.creasePoints.length) {
                    int dir = i1 == i0 + 1 ? this.lines[i1].getDirection() : (i0 == i1 + 1 ? this.lines[i0].getDirection() : 0);
                    if (dir == 2) {
                        newx = x;
                        newy = y0 + dy;
                        setted = true;
                    } else if (dir == 1) {
                        newx = x0 + dx;
                        newy = y;
                        setted = true;
                    }
                }
                if (!setted) {
                    newx = x + dx;
                    newy = y + dy;
                }
            }
            posvec.addElement(new Point2D.Double(newx, newy));
            ++i;
        }
        return posvec;
    }

    protected void reformSquareLinesProtected(GLink gl, GStructure structure) {
        int n = this.lines.length;
        Vector<Integer> v = new Vector<Integer>(n + 1);
        int arm = this.getArm();
        v.addElement(new Integer(arm));
        int i = 0;
        while (i < n) {
            int dir = this.lines[i].getDirection();
            v.addElement(new Integer(dir));
            ++i;
        }
        structure.notifyChange(gl, 14, v);
        boolean recalcPointNumber = true;
        Point2D.Double[] posArray = this.getInitialCreasePointPositionForSquare(recalcPointNumber);
        if (posArray.length > this.creasePoints.length) {
            int nAdd = posArray.length - this.creasePoints.length;
            i = 0;
            while (i < nAdd) {
                double x = posArray[i].x;
                double y = posArray[i].y;
                GLinkedLineIndex index = this.getLineIndex(0);
                GCreasePoint newPoint = this.createNewCreasePoint(x, y, index);
                Rectangle2D updateRect = this.addCreasePointWithoutNotify(newPoint, structure, index.line, null);
                if (updateRect != null) {
                    GCreasePointForUndo p1 = new GCreasePointForUndo(newPoint, index.line, null);
                    structure.notifyChange(p1, 1, null);
                }
                ++i;
            }
        } else if (posArray.length < this.creasePoints.length) {
            int nRemove = this.creasePoints.length - posArray.length;
            i = 0;
            while (i < nRemove) {
                int index = 0;
                GCreasePoint p = this.creasePoints[0];
                MapAndRect mAndR = this.removeCreasePointWithoutNotifyPrivate(p, structure, index);
                Rectangle2D updateRect = mAndR.getRect();
                GCreasePointForUndo p1 = new GCreasePointForUndo(p, index, mAndR.getMap());
                structure.notifyChange(p1, 2, null);
                ++i;
            }
        }
        Vector<GCreasePoint> gelements = new Vector<GCreasePoint>();
        Vector<Point2D.Double> v2 = new Vector<Point2D.Double>();
        int n2 = posArray.length;
        int i2 = 0;
        while (i2 < n2) {
            gelements.addElement(this.creasePoints[i2]);
            v2.add(posArray[i2]);
            ++i2;
        }
        structure.move(gelements, v2);
    }

    protected void reformSquareLines(GStructure structure, boolean needToSaveCurrentPolicy, HashMap mapLinkLineIndex) {
        int pol;
        GLogicGate gate;
        Rectangle2D.Double updateRect = null;
        Rectangle2D updateRect1 = null;
        Rectangle2D updateRect2 = null;
        GLink gl = this.getReactionLink(structure);
        if (gl == null && this instanceof LinkedCreaseLine && (gate = ((LinkedCreaseLine)this).getLogicGate()) != null) {
            gl = gate.getReactionLink(structure);
        }
        if (needToSaveCurrentPolicy) {
            structure.notifyChange(gl, 12, null);
        }
        boolean policyChange = false;
        if (this.connectPolicy == 1) {
            policyChange = true;
            pol = 0;
            this.setConnectPolicy(pol);
        }
        this.reformSquareLinesProtected(gl, structure);
        if (policyChange) {
            pol = 1;
            this.setConnectPolicy(pol);
        }
        this.initLinesDirection();
        if (this instanceof LinkedCreaseLineMixedNotation) {
            GLinkedCreaseLine.resetAllLinksLinkLineIndexAfterReformSquareLine(mapLinkLineIndex, (ReactionLink)gl);
        }
        structure.notifyChange(gl, 13, null);
        if (gl instanceof ReactionLink) {
            updateRect1 = structure.autoAjustLinkLineConn((ReactionLink)gl);
        }
        updateRect2 = structure.repaintLinkandAllLinksWhichlinkingtome((ReactionLink)gl, false);
        updateRect = GUtil.union(updateRect, updateRect1);
        updateRect = GUtil.union(updateRect, updateRect2);
        structure.callbyuserRepaint(updateRect);
    }

    @Override
    public void reformSquareLines(GStructure structure) {
        ReactionLink eventLink = (ReactionLink)this.getReactionLink(structure);
        SBModel sbmodel = null;
        GLinkedShape oldshape = null;
        GLinkedShape newshape = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        }
        catch (Exception myErr) {
            sbmodel = null;
        }
        HashMap mapOldLinkLineIndex = this.getAllLinksLinkingToLinkedCreaseLineMixedNotation(structure);
        if (sbmodel != null) {
            oldshape = eventLink.getGLinkedShape();
            Integer iOldIndex = null;
            try {
                iOldIndex = this.getEndLinkPositionInfo().getPosition();
            }
            catch (Exception myErr) {
                iOldIndex = -1;
            }
            if (this instanceof LinkedCreaseLineMixedNotation) {
                if (eventLink.isBaseLink()) {
                    sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy2", oldshape, oldshape, mapOldLinkLineIndex);
                } else {
                    sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy2", oldshape, oldshape, iOldIndex);
                }
            } else {
                sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy", oldshape, oldshape);
            }
        }
        this.reformSquareLines(structure, true, mapOldLinkLineIndex);
        if (sbmodel != null) {
            newshape = eventLink.getGLinkedShape();
            Integer iNewIndex = null;
            try {
                iNewIndex = this.getEndLinkPositionInfo().getPosition();
            }
            catch (Exception myErr) {
                iNewIndex = -1;
            }
            if (this instanceof LinkedCreaseLineMixedNotation) {
                if (eventLink.isBaseLink()) {
                    HashMap mapNewLinkLineIndex = this.getAllLinksLinkingToLinkedCreaseLineMixedNotation(structure);
                    sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy2", newshape, newshape, mapNewLinkLineIndex);
                } else {
                    sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy2", newshape, newshape, iNewIndex);
                }
            } else {
                sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy", newshape, newshape);
            }
        }
    }

    @Override
    public void setlinesDirection(Vector vec) {
        int n = this.lines.length;
        int i = 0;
        while (i < n) {
            int dir = (Integer)vec.elementAt(i + 1);
            this.lines[i].setDirection(dir);
            ++i;
        }
    }

    @Override
    public void toggleConnectPolicy(GStructure structure) {
        ReactionLink eventLink = (ReactionLink)this.getReactionLink(structure);
        SBModel sbmodel = null;
        GLinkedShape oldshape = null;
        GLinkedShape newshape = null;
        try {
            sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        }
        catch (Exception myErr) {
            sbmodel = null;
        }
        HashMap mapOldLinkLineIndex = this.getAllLinksLinkingToLinkedCreaseLineMixedNotation(structure);
        if (sbmodel != null) {
            oldshape = eventLink.getGLinkedShape();
            if (eventLink.isBaseLink() && this instanceof LinkedCreaseLineMixedNotation) {
                sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy2", oldshape, oldshape, mapOldLinkLineIndex);
            } else {
                sbmodel.eventGroupBegan(eventLink, "ChangeReactionConnectionPolicy", oldshape, oldshape);
            }
        }
        if (this.connectPolicy == 0) {
            int pol = 1;
            this.setConnectPolicy(pol);
            this.reformSquareLines(structure, false, mapOldLinkLineIndex);
        } else {
            GLink gl = this.getReactionLink(structure);
            structure.notifyChange(gl, 12, null);
            int pol = 0;
            this.setConnectPolicy(pol);
            gl.update();
        }
        if (sbmodel != null) {
            newshape = eventLink.getGLinkedShape();
            if (eventLink.isBaseLink() && this instanceof LinkedCreaseLineMixedNotation) {
                HashMap mapNewLinkLineIndex = this.getAllLinksLinkingToLinkedCreaseLineMixedNotation(structure);
                sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy2", newshape, newshape, mapNewLinkLineIndex);
            } else {
                sbmodel.eventGroupEnd(eventLink, "ChangeReactionConnectionPolicy", newshape, newshape);
            }
        }
    }

    protected boolean canTogglePolicy() {
        return true;
    }

    @Override
    public boolean canTogglePolicy(GStructure structure) {
        return this.canTogglePolicy();
    }

    @Override
    public void setupAfterAllTargetsSetted() {
        if (this.connectPolicy == 1) {
            this.initLinesDirection();
        }
    }

    public void drawPreview(Graphics2D g2, Rectangle bounds, Color color, double width) {
        Point2D.Double pt1 = new Point2D.Double();
        Point2D.Double pt2 = new Point2D.Double();
        pt1.x = (double)bounds.x + (double)bounds.width * 0.2;
        pt1.y = (double)bounds.y + (double)bounds.height * 0.5;
        pt2.x = (double)bounds.x + (double)bounds.width * 0.8;
        pt2.y = (double)bounds.y + (double)bounds.height * 0.5;
        GLinkedStraightLine sl = (GLinkedStraightLine)this.getLine(0);
        sl.setStartAndEndPoint(pt1, pt2);
        this.setColor(color);
        this.setLineWidth(width);
        if (this instanceof LayerTagFreeLineSymbol) {
            this.start = pt1;
            this.end = pt2;
        }
        this.updateShape(false);
        this.drawShape(g2);
    }

    public List addCreasePoint(Point2D[] points, GStructure structure) {
        ArrayList<GCreasePointForUndo> undoList = new ArrayList<GCreasePointForUndo>();
        int i = 0;
        while (i < points.length) {
            double x = points[i].getX();
            double y = points[i].getY();
            GLinkedLineIndex index = new GLinkedLineIndex();
            index.line = i++;
            GCreasePoint newPoint = this.createNewCreasePoint(x, y, index);
            this.addCreasePointWithoutNotify(newPoint, structure, index.line);
        }
        GEditPoint[] editPoints = this.getEditPoints();
        if (editPoints != null) {
            int i2 = 0;
            while (i2 < editPoints.length) {
                double x = points[i2].getX();
                double y = points[i2].getY();
                this.moveEditPoint(editPoints[i2], x, y);
                GLinkedLineIndex index = this.getLineIndex(x, y);
                GCreasePointForUndo undo = new GCreasePointForUndo((GCreasePoint)editPoints[i2], i2, null);
                undoList.add(undo);
                ++i2;
            }
        }
        return undoList;
    }

    public List removeCreasePoint(GStructure structure) {
        ArrayList<GCreasePointForUndo> undoList = new ArrayList<GCreasePointForUndo>();
        GCreasePoint[] creasePoints = (GCreasePoint[])this.getEditPoints();
        if (creasePoints != null) {
            int iLen = creasePoints.length;
            int i = iLen - 1;
            while (i >= 0) {
                int index = this.decideIndexOfCreasePoint(creasePoints[i]);
                if (index >= 0) {
                    MapAndRect mAndR = this.removeCreasePointWithoutNotifyPrivate(creasePoints[i], structure, index);
                    GCreasePointForUndo undo = new GCreasePointForUndo(creasePoints[i], index, mAndR.getMap());
                    undoList.add(undo);
                }
                --i;
            }
        }
        return undoList;
    }

    public List getPoints() {
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        int i = 0;
        while (i < this.creasePoints.length) {
            Point2D.Double point = this.creasePoints[i].getPosition();
            list.add(point);
            ++i;
        }
        return list;
    }

    public void setBounds(Rectangle2D.Double bounds) {
        this.bounds = bounds;
    }

    @Override
    public Point2D.Double getAnchorPointByIndex(int index) {
        Point2D.Double[] rtn = this.setupLinkAnchorCoord();
        if (index > 0 && index <= rtn.length - 1) {
            return rtn[index];
        }
        return rtn[0];
    }

    public Rectangle2D autoAjustCreasePointUsingNewStartEndPnt() {
        if (this.lines == null) {
            return null;
        }
        return this.autoAjustCreasePointUsingNewStartEndPnt(this.start, this.end);
    }

    public Rectangle2D autoAjustCreasePointUsingNewStartEndPnt(Point2D.Double stPnt, Point2D.Double edPnt) {
        Rectangle2D.Double redrawArea = null;
        if (stPnt == null || edPnt == null) {
            return redrawArea;
        }
        if (this.connectPolicy != 1) {
            return redrawArea;
        }
        if (this.lines == null || this.lines.length <= 1) {
            return redrawArea;
        }
        if (this.creasePoints == null) {
            return redrawArea;
        }
        try {
            AffineTransform at = new AffineTransform();
            GUtil.createLocalTransform(stPnt, edPnt, at);
            at.createInverse();
            GUtil.createLocalTransform(stPnt, edPnt, this.localAT);
            this.inverse = this.localAT.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return redrawArea;
        }
        Rectangle2D.Double areaOld = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        this.start = stPnt;
        this.end = edPnt;
        this.lines[0].start = stPnt;
        this.lines[this.lines.length - 1].end = edPnt;
        int i = this.creasePoints.length - 1;
        while (i >= 0) {
            GCreasePoint cspnt = this.creasePoints[i];
            GLinkedStraightLine sln1 = this.lines[i + 1];
            Point2D.Double st1 = sln1.getStartPoint();
            Point2D.Double ed1 = sln1.getEndPoint();
            GLinkedStraightLine sln0 = this.lines[i];
            Point2D.Double ed0 = sln0.getEndPoint();
            if (sln1.getDirection() == 2) {
                ed0.y = st1.y = ed1.y;
                if (i == 0) {
                    ed0.x = st1.x = stPnt.x;
                }
            } else if (sln1.getDirection() == 1) {
                ed0.x = st1.x = ed1.x;
                if (i == 0) {
                    ed0.y = st1.y = stPnt.y;
                }
            }
            Point2D.Double pos1 = (Point2D.Double)st1.clone();
            Point2D.Double localPos1 = new Point2D.Double();
            this.inverse.transform(pos1, localPos1);
            cspnt.setPosition(pos1);
            cspnt.setLocalPosition(localPos1);
            --i;
        }
        Rectangle2D.Double areaNew = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }

    public Rectangle2D recalLocalPositions() {
        if (this.lines == null) {
            return null;
        }
        return this.recalLocalPositions(this.start, this.end);
    }

    public Rectangle2D recalLocalPositions(Point2D.Double stPnt, Point2D.Double edPnt) {
        Rectangle2D.Double redrawArea = null;
        if (stPnt == null || edPnt == null) {
            return redrawArea;
        }
        if (this.connectPolicy != 0) {
            return redrawArea;
        }
        if (this.lines == null) {
            return redrawArea;
        }
        if (this.creasePoints == null) {
            return redrawArea;
        }
        try {
            AffineTransform at = new AffineTransform();
            GUtil.createLocalTransform(stPnt, edPnt, at);
            at.createInverse();
            GUtil.createLocalTransform(stPnt, edPnt, this.localAT);
            this.inverse = this.localAT.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return redrawArea;
        }
        Rectangle2D.Double areaOld = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        this.start = stPnt;
        this.end = edPnt;
        this.lines[0].start = stPnt;
        this.lines[this.lines.length - 1].end = edPnt;
        int i = this.creasePoints.length - 1;
        while (i >= 0) {
            GCreasePoint cspnt = this.creasePoints[i];
            GLinkedStraightLine sln1 = this.lines[i + 1];
            Point2D.Double st1 = sln1.getStartPoint();
            Point2D.Double pos1 = (Point2D.Double)st1.clone();
            Point2D.Double localPos1 = new Point2D.Double();
            this.inverse.transform(pos1, localPos1);
            cspnt.setPosition(pos1);
            cspnt.setLocalPosition(localPos1);
            --i;
        }
        Rectangle2D.Double areaNew = GLinkedCreaseLine.calcBoundsUsingPoints(this);
        redrawArea = GUtil.union(redrawArea, areaOld);
        redrawArea = GUtil.union(redrawArea, areaNew);
        return redrawArea;
    }

    public static final Rectangle2D.Double calcBoundsUsingPoints(GLinkedCreaseLine line) {
        try {
            int cspcnt = 2;
            if (line.creasePoints != null) {
                cspcnt = line.creasePoints.length + 2;
            }
            Point2D.Double[] pnts = new Point2D.Double[cspcnt];
            pnts[0] = line.start;
            if (line.creasePoints != null) {
                int i = 0;
                while (i < line.creasePoints.length) {
                    pnts[i + 1] = line.creasePoints[i].getPosition();
                    ++i;
                }
            }
            pnts[pnts.length - 1] = line.end;
            return GLinkedCreaseLine.calcBoundsUsingPoints(pnts);
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public static final Rectangle2D.Double calcBoundsUsingPoints(Point2D.Double[] pnts) {
        Rectangle2D.Double rect = null;
        if (pnts == null || pnts.length <= 0) {
            return rect;
        }
        int cnt = pnts.length;
        int i = 0;
        while (i < pnts.length) {
            if (pnts[i] == null) {
                --cnt;
            }
            ++i;
        }
        if (cnt <= 1) {
            return rect;
        }
        Point2D.Double[] newpnts = new Point2D.Double[cnt];
        int j = 0;
        int i2 = 0;
        while (i2 < pnts.length) {
            if (pnts[i2] != null) {
                newpnts[j++] = pnts[i2];
            }
            ++i2;
        }
        double minx = newpnts[0].x;
        double miny = newpnts[0].y;
        double maxx = newpnts[0].x;
        double maxy = newpnts[0].y;
        int i3 = 1;
        while (i3 < newpnts.length) {
            Point2D.Double pnt = newpnts[i3];
            if (pnt.x < minx) {
                minx = pnt.x;
            }
            if (pnt.y < miny) {
                miny = pnt.y;
            }
            if (pnt.x > maxx) {
                maxx = pnt.x;
            }
            if (pnt.y > maxy) {
                maxy = pnt.y;
            }
            ++i3;
        }
        rect = new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
        return rect;
    }

    private HashMap getAllLinksLinkingToLinkedCreaseLineMixedNotation(GStructure structure) {
        HashMap<ReactionLink, Integer> mapOldLinkLineIndex = new HashMap<ReactionLink, Integer>();
        if (!(this instanceof LinkedCreaseLineMixedNotation)) {
            return null;
        }
        Vector allLinksToMe = structure.getReactionLinksWhichislinkingtoME((ReactionLink)this.getReactionLink(structure));
        int i = 0;
        while (i < allLinksToMe.size()) {
            if ((i == 0 || i == 3) && allLinksToMe.get(i) != null) {
                Vector links = (Vector)allLinksToMe.get(i);
                int j = 0;
                while (j < links.size()) {
                    ReactionLink lk = (ReactionLink)links.get(j);
                    GLinkedShape linkedShape = lk.getGLinkedShape();
                    GLinkedLine ln = null;
                    if (linkedShape instanceof GLinkedLine) {
                        ln = (GLinkedLine)linkedShape;
                    } else if (linkedShape instanceof GLogicGate) {
                        ln = ((GLogicGate)linkedShape).getRealLine();
                    }
                    if (ln != null) {
                        try {
                            Integer iOldIndex = ln.getEndLinkPositionInfo().getPosition();
                            mapOldLinkLineIndex.put(lk, iOldIndex);
                        }
                        catch (Exception myErr) {
                            mapOldLinkLineIndex.put(lk, null);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return mapOldLinkLineIndex;
    }

    private HashMap resetAllLinksLinkLineIndex(HashMap<Object, Integer> mapOldLinkLineIndex, GLink glink, int index, Point2D.Double newPoint, boolean bAddPoint) {
        if (!(this instanceof LinkedCreaseLineMixedNotation)) {
            return null;
        }
        HashMap<ReactionLink, Integer> mapNewLinkLineIndex = new HashMap<ReactionLink, Integer>();
        for (ReactionLink reactionLink : mapOldLinkLineIndex.keySet()) {
            GLinkedShape linkedShape = reactionLink.getGLinkedShape();
            GLinkedCreaseLine ln = null;
            if (mapOldLinkLineIndex.get(reactionLink) == null) continue;
            if (linkedShape instanceof GLinkedCreaseLine) {
                ln = (GLinkedCreaseLine)linkedShape;
            } else if (linkedShape instanceof GLogicGate) {
                ln = ((GLogicGate)linkedShape).getRealLine();
            }
            int iOldIndex = mapOldLinkLineIndex.get(reactionLink);
            boolean bAdjust = false;
            if (bAddPoint) {
                Point2D.Double end;
                Point2D.Double start;
                if (iOldIndex > index) {
                    bAdjust = true;
                } else if (iOldIndex == index && CelldUtil.dotInWhereOfLine(start = this.getLine(index).getStartPoint(), end = this.getLine(index).getEndPoint(), newPoint) < 0) {
                    bAdjust = true;
                }
            } else if (iOldIndex > index) {
                bAdjust = true;
            }
            if (!bAdjust) continue;
            int iNewIndex = iOldIndex;
            iNewIndex = bAddPoint ? ++iNewIndex : --iNewIndex;
            try {
                ln.getEndLinkPositionInfo().setPosition(iNewIndex);
                reactionLink.setTargetAt((GLinkTarget)glink, 1, ln.getEndLinkPositionInfo());
                mapNewLinkLineIndex.put(reactionLink, iNewIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapNewLinkLineIndex;
    }

    private static final void removeNoChangedElement(HashMap<Object, Integer> mapOldLinkLineIndex, HashMap<Object, Integer> mapNewLinkLineIndex) {
        try {
            for (Object lk : mapOldLinkLineIndex.keySet()) {
                if (mapNewLinkLineIndex.get(lk) != null) continue;
                mapOldLinkLineIndex.remove(lk);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void resetAllLinksLinkLineIndex(HashMap<Object, Integer> mapLinkLineIndex, GLink glink) {
        for (ReactionLink reactionLink : mapLinkLineIndex.keySet()) {
            GLinkedShape linkedShape = reactionLink.getGLinkedShape();
            GLinkedCreaseLine ln = null;
            if (mapLinkLineIndex.get(reactionLink) == null) continue;
            if (linkedShape instanceof GLinkedCreaseLine) {
                ln = (GLinkedCreaseLine)linkedShape;
            } else if (linkedShape instanceof GLogicGate) {
                ln = ((GLogicGate)linkedShape).getRealLine();
            }
            try {
                int iIndex = mapLinkLineIndex.get(reactionLink);
                ln.getEndLinkPositionInfo().setPosition(iIndex);
                reactionLink.setTargetAt((GLinkTarget)glink, 1, ln.getEndLinkPositionInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final HashMap<Object, Integer> resetAllLinksLinkLineIndexAfterReformSquareLine(HashMap<Object, Integer> mapLinkLineIndex, ReactionLink glink) {
        HashMap<Object, Integer> mapNewLinkLineIndex = new HashMap<Object, Integer>();
        if (!glink.isBaseLink()) {
            return null;
        }
        if (!(glink.getGLinkedShape() instanceof GLinkedCreaseLine)) {
            return null;
        }
        int defaultTargetLineIndex = ((GLinkedCreaseLine)glink.getGLinkedShape()).getDefaultLineIndex().line;
        for (ReactionLink reactionLink : mapLinkLineIndex.keySet()) {
            GLinkedShape linkedShape = reactionLink.getGLinkedShape();
            GLinkedCreaseLine ln = null;
            if (linkedShape instanceof GLinkedCreaseLine) {
                ln = (GLinkedCreaseLine)linkedShape;
            } else if (linkedShape instanceof GLogicGate) {
                ln = ((GLogicGate)linkedShape).getRealLine();
            }
            try {
                ln.getEndLinkPositionInfo().setPosition(defaultTargetLineIndex);
                reactionLink.setTargetAt((GLinkTarget)glink, 1, ln.getEndLinkPositionInfo());
                mapNewLinkLineIndex.put(reactionLink, defaultTargetLineIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapNewLinkLineIndex;
    }

    protected class MapAndRect {
        private Map map;
        private Rectangle2D rect;

        MapAndRect(Map m, Rectangle2D r) {
            this.map = m;
            this.rect = r;
        }

        public Map getMap() {
            return this.map;
        }

        public Rectangle2D getRect() {
            return this.rect;
        }
    }
}

