/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLinkPosition;

public class GLinkPositionInfo {
    private int position;
    private int arm;
    private String name;
    private double distanceSq;
    private GLinkPositionInfo childInfo;
    private GElement element;

    public String getInnerIdForLink() {
        if (this.childInfo != null) {
            return this.childInfo.getName();
        }
        return "";
    }

    public int getPositionForLink() {
        if (this.childInfo != null) {
            return this.childInfo.getPosition();
        }
        return this.position;
    }

    public boolean hasActive() {
        if (this.element instanceof GBasicAtom && ((GAtom)this.element).getCurrentView() == 1) {
            return false;
        }
        if (this.position != 16) {
            return true;
        }
        if (this.childInfo != null) {
            return this.childInfo.hasActive();
        }
        return false;
    }

    public GLinkPositionInfo(int position, double distSq) {
        this.position = position;
        this.arm = -1;
        this.name = "";
        this.distanceSq = distSq;
        this.childInfo = null;
        this.element = null;
    }

    public GLinkPositionInfo(int position, String innerIdOfChild) {
        if (innerIdOfChild == null) {
            this.position = position;
            this.arm = -1;
            this.name = "";
            this.distanceSq = 0.0;
            this.childInfo = null;
            this.element = null;
        } else {
            this.position = 16;
            this.arm = -1;
            this.name = "";
            this.distanceSq = 0.0;
            this.childInfo = new GLinkPositionInfo(position, null);
            this.childInfo.setName(innerIdOfChild);
            this.element = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public double getDistanceSq() {
        return this.distanceSq;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GLinkPositionInfo getChildInfo() {
        return this.childInfo;
    }

    public void setChildInfo(GLinkPositionInfo childInfo) {
        this.childInfo = childInfo;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public GElement getElement() {
        return this.element;
    }

    public void setElement(GElement element) {
        this.element = element;
    }

    public Object clone() {
        GLinkPositionInfo lpi = new GLinkPositionInfo(this.position, this.distanceSq);
        lpi.setArm(this.arm);
        lpi.setElement(this.element);
        lpi.setName(this.name);
        GLinkPositionInfo lpi1 = this.childInfo == null ? null : (GLinkPositionInfo)this.childInfo.clone();
        lpi.setChildInfo(lpi1);
        return lpi;
    }

    public boolean equals(Object obj) {
        block11: {
            GLinkPositionInfo another;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                another = (GLinkPositionInfo)obj;
                                if (this.position == another.position) break block7;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (this.arm == another.arm) break block8;
                        return false;
                    }
                    if (this.name.equals(another.name)) break block9;
                    return false;
                }
                if (this.childInfo != null) break block10;
                if (another.childInfo != null) {
                    return false;
                }
                break block11;
            }
            if (this.childInfo.equals(another.childInfo)) break block11;
            return false;
        }
        return true;
    }

    public String getPositionStringForLink() {
        return GLinkPosition.getString(this.getPositionForLink());
    }

    public int getArm() {
        return this.arm;
    }

    public void setArm(int arm) {
        this.arm = arm;
    }

    public String toString() {
        return new StringBuffer().append(super.toString()).append("[position=").append(this.position).append(", arm=").append(this.arm).append(", name=").append(this.name).append(", distanceSq=").append(this.distanceSq).append(", childInfo=").append(this.childInfo).append(", element=").append(this.element).append("]").toString();
    }
}

