/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.geom.Point2D;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;

public class GLinkHandlePointForUndo
extends GLinkHandlePoint {
    private GLinkHandlePoint original;
    private GLink targetGLink;
    private int targetIndex;
    private GLinkTarget oldTarget;
    private GLinkTarget newTarget;
    private GLinkPositionInfo oldLpi;
    private GLinkPositionInfo newLpi;
    private double oldX;
    private double oldY;
    private double newX;
    private double newY;

    public GLinkHandlePointForUndo(GLinkHandlePoint orig, GLink targetGLink, int targetIndex, GLinkTarget oldTarget, GLinkTarget newTarget, GLinkPositionInfo oldLpi, GLinkPositionInfo newLpi, double oldX, double oldY, double newX, double newY) {
        this.original = orig;
        this.targetGLink = targetGLink;
        this.targetIndex = targetIndex;
        this.oldTarget = oldTarget;
        this.newTarget = newTarget;
        this.oldLpi = oldLpi;
        this.newLpi = newLpi;
        this.oldX = oldX;
        this.oldY = oldY;
        this.newX = newX;
        this.newY = newY;
    }

    public GLinkPositionInfo getNewLpi() {
        return this.newLpi;
    }

    public void setNewLpi(GLinkPositionInfo newLpi) {
        this.newLpi = newLpi;
    }

    public GLinkTarget getNewTarget() {
        return this.newTarget;
    }

    public void setNewTarget(GLinkTarget newTarget) {
        this.newTarget = newTarget;
    }

    public double getNewX() {
        return this.newX;
    }

    public double getNewY() {
        return this.newY;
    }

    public GLinkPositionInfo getOldLpi() {
        return this.oldLpi;
    }

    public void setOldLpi(GLinkPositionInfo oldLpi) {
        this.oldLpi = oldLpi;
    }

    public GLinkTarget getOldTarget() {
        return this.oldTarget;
    }

    public void setOldTarget(GLinkTarget oldTarget) {
        this.oldTarget = oldTarget;
    }

    public double getOldX() {
        return this.oldX;
    }

    public double getOldY() {
        return this.oldY;
    }

    public GLink getTargetGLink() {
        return this.targetGLink;
    }

    public int getTargetIndex() {
        return this.targetIndex;
    }

    @Override
    public Point2D.Double getPosition() {
        return this.original.getPosition();
    }

    public boolean isOldPoint(double x, double y) {
        return x == this.oldX && y == this.oldY;
    }

    public boolean isNewPoint(double x, double y) {
        return x == this.newX && y == this.newY;
    }

    public void processForMove(double x, double y) {
        try {
            this.targetGLink.setTargetAt(this.newTarget, this.targetIndex, x, y, this.newLpi);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GLinkHandlePointForUndo createShallowCopy() {
        return new GLinkHandlePointForUndo(this.original, this.targetGLink, this.targetIndex, this.oldTarget, this.newTarget, this.oldLpi, this.newLpi, this.oldX, this.oldY, this.newX, this.newY);
    }
}

