/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkHandlePoint;
import jp.fric.graphics.draw.GLinkHandlePointForUndo;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.LinkedCreaseLineForComplex3;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;

public class GLinkHandleMover {
    private GStructure structure;
    private GLink editingGLink;
    private GLinkHandlePoint handlePoint = null;
    private int targetIndex;
    private double startX;
    private double startY;
    private Vector skips;
    private GLinkTarget oldTarget;
    private GLinkPositionInfo oldLpi;
    private double oldX;
    private double oldY;
    private GLinkTarget startOnMouseTarget;
    private GLinkTarget onMouseTarget;
    private GLinkPositionInfo onMouseTargetLinkPosition;

    private Vector setupSkipsVector() {
        Vector<GLinkTarget> v = new Vector<GLinkTarget>();
        GLinkedShape linkshp = this.editingGLink.getGLinkedShape();
        if (this.oldTarget instanceof GLink || this.oldTarget instanceof SpeciesAlias && linkshp instanceof GLogicGate) {
            v.addAll(this.structure.getLinks());
            v.addAll(this.structure.getAtoms());
            v.addAll(this.structure.getContainableAtoms());
            v.remove(this.oldTarget);
        } else {
            v.addAll(this.structure.getLinks());
            int num = this.editingGLink.targetSize();
            int i = 0;
            while (i < num) {
                if (i != this.targetIndex) {
                    try {
                        GLinkTarget target = this.editingGLink.getTargetAt(i);
                        v.addElement(target);
                        if (target instanceof ReactionLink) {
                            if (((ReactionLink)target).getGLinkedShape() instanceof GLogicGate) {
                                GLinkTarget tg = ((GLogicGate)((ReactionLink)target).getGLinkedShape()).getRealLine().getEndTarget();
                                Vector links = this.structure.getLinks();
                                if (tg instanceof ReactionLink) {
                                    ReactionLink originalLink = (ReactionLink)tg;
                                    v.addAll(originalLink.getSources());
                                    v.addAll(originalLink.getDistinations());
                                    v.addAll(this.getAllModifiers(originalLink));
                                } else if (tg instanceof SpeciesAlias) {
                                    SpeciesAlias sa = (SpeciesAlias)tg;
                                    v.addAll(this.getAllModifiers(sa));
                                }
                            } else if (((ReactionLink)target).getGLinkedShape() instanceof StateTransition || ((ReactionLink)target).getGLinkedShape() instanceof LinkedCreaseLineMixedNotation || ((ReactionLink)target).getGLinkedShape() instanceof LinkedLineComplex3) {
                                if (this.editingGLink.getGLinkedShape() instanceof GLinkedCurveAndLine) {
                                    v.addAll(((ReactionLink)target).getSources());
                                    v.addAll(((ReactionLink)target).getDistinations());
                                } else {
                                    v.addAll(this.getAllModifiers((ReactionLink)target));
                                }
                            }
                        } else if (target instanceof SpeciesAlias) {
                            if (linkshp instanceof StateTransition || linkshp instanceof LinkedCreaseLineMixedNotation || linkshp instanceof GLinkedLineComplex3) {
                                v.addElement(target);
                            } else if (((SpeciesAlias)target).isPhenotype()) {
                                v.addAll(this.getAllModifiers((SpeciesAlias)target));
                            } else {
                                Vector atoms = this.structure.getAtoms();
                                int j = 0;
                                while (j < atoms.size()) {
                                    if (!((SpeciesAlias)atoms.get(j)).isPhenotype()) {
                                        v.add((GLinkTarget)atoms.get(j));
                                    }
                                    ++j;
                                }
                                v.addAll(this.structure.getContainableAtoms());
                            }
                        }
                        v.remove(this.oldTarget);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return v;
    }

    protected Rectangle2D init(GStructure st, GLinkHandlePoint hp, double x, double y) {
        this.structure = st;
        this.editingGLink = this.structure.getOwnerLink(hp);
        this.handlePoint = hp;
        Point2D.Double pos = hp.getPosition();
        this.oldX = pos.x;
        this.oldY = pos.y;
        this.startX = x;
        this.startY = y;
        this.onMouseTarget = null;
        this.startOnMouseTarget = null;
        this.onMouseTargetLinkPosition = null;
        this.targetIndex = this.editingGLink.getTargetIndex(this.handlePoint);
        try {
            this.oldTarget = this.editingGLink.getTargetAt(this.targetIndex);
            GLinkPositionInfo lpi = this.editingGLink.getTargetLinkPositionInfoAt(this.targetIndex);
            this.oldLpi = (GLinkPositionInfo)(lpi != null ? lpi.clone() : null);
        }
        catch (Exception lpi) {
            // empty catch block
        }
        this.skips = this.setupSkipsVector();
        Rectangle2D rect = this.processEvent(501, x, y);
        return rect;
    }

    protected void processEvent(int id) {
        this.processEvent(id, this.startX, this.startY);
    }

    private GLinkHandlePointForUndo setupUndoInfo(GLinkPositionInfo lpi) {
        Point2D.Double p = this.handlePoint.getPosition();
        return new GLinkHandlePointForUndo(this.handlePoint, this.editingGLink, this.targetIndex, this.oldTarget, this.onMouseTarget, this.oldLpi, lpi, this.oldX, this.oldY, p.x, p.y);
    }

    private Rectangle2D move1(GLinkTarget lt, double x, double y, GLinkPositionInfo lpi) {
        Rectangle2D rect = null;
        try {
            this.editingGLink.setTargetAt(lt, this.targetIndex, x, y, lpi);
            Vector<GLinkTarget> v = new Vector<GLinkTarget>();
            v.addElement(lt);
            rect = this.structure.updateLinksAfterShapesMoving(v, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rect;
    }

    protected Rectangle2D processEvent(int id, double x, double y) {
        GElement gelement;
        Rectangle2D redrawArea = null;
        GLinkPositionInfo lpi = this.structure.getPointedLinkableElement(x, y, this.skips, this.editingGLink, this.targetIndex);
        boolean active = lpi != null ? lpi.hasActive() : false;
        GElement gElement = gelement = lpi != null ? lpi.getElement() : null;
        if (active) {
            active = GMouseInterpreter.isLinkAbleByReactantProductModifications(this.editingGLink.getGLinkedShape(), gelement, lpi);
        }
        if (active && !(this.editingGLink instanceof LayerReactionLink)) {
            if (id == 506 || id == 501) {
                if (this.onMouseTarget != gelement) {
                    if (this.onMouseTarget != null) {
                        redrawArea = this.highlighAsTarget((GElement)((Object)this.onMouseTarget), false, redrawArea);
                    }
                    this.onMouseTarget = (GLinkTarget)((Object)gelement);
                    if (this.onMouseTarget != null) {
                        redrawArea = this.highlighAsTarget((GElement)((Object)this.onMouseTarget), true, redrawArea);
                    }
                    if (this.startOnMouseTarget == null) {
                        this.startOnMouseTarget = this.onMouseTarget;
                    }
                }
                if (this.onMouseTargetLinkPosition == null || this.onMouseTargetLinkPosition != null && this.onMouseTargetLinkPosition.getPosition() != lpi.getPosition()) {
                    this.onMouseTargetLinkPosition = lpi;
                    int iOldAddingType = -1;
                    try {
                        GLinkedShape lnkshape = ((GLink)this.onMouseTarget).getGLinkedShape();
                        if (lnkshape instanceof StateTransition || lnkshape instanceof LinkedLineComplex3) {
                            iOldAddingType = lnkshape instanceof StateTransition ? ((StateTransition)lnkshape).getAddingObjectFlag() : ((LinkedLineComplex3)lnkshape).getAddingObjectFlag();
                        }
                    }
                    catch (Exception lnkshape) {
                        // empty catch block
                    }
                    GMouseInterpreter.setOnMouseTargetAddingObjectFlag(this.editingGLink, this.onMouseTarget);
                    int iNewAddingType = -1;
                    try {
                        GLinkedShape lnkshape = ((GLink)this.onMouseTarget).getGLinkedShape();
                        if (lnkshape instanceof StateTransition || lnkshape instanceof LinkedLineComplex3) {
                            iNewAddingType = lnkshape instanceof StateTransition ? ((StateTransition)lnkshape).getAddingObjectFlag() : ((LinkedLineComplex3)lnkshape).getAddingObjectFlag();
                        }
                    }
                    catch (Exception lnkshape) {
                        // empty catch block
                    }
                    boolean bDoMoving = false;
                    bDoMoving = iOldAddingType == -1 && iNewAddingType == -1 ? true : iNewAddingType == iOldAddingType;
                    if (id == 506) {
                        Rectangle2D rect = this.move1(this.onMouseTarget, x, y, lpi);
                        redrawArea = GUtil.union(rect, redrawArea);
                    }
                    boolean drawOnlyActive = false;
                    redrawArea = GUtil.union(this.structure.showLinkAnchors(this.onMouseTarget, lpi, drawOnlyActive, false), redrawArea);
                }
            } else if (id == 502) {
                redrawArea = this.highlighAsTarget((GElement)((Object)this.onMouseTarget), false, redrawArea);
                GLinkHandlePointForUndo wrapperElem = this.setupUndoInfo(lpi);
                redrawArea = GUtil.union(this.move1(this.startOnMouseTarget, this.oldX, this.oldY, this.oldLpi), redrawArea);
                this.structure.move(wrapperElem, wrapperElem.getNewX(), wrapperElem.getNewY());
                GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.onMouseTarget);
            }
        } else {
            if (id == 506 && this.onMouseTarget != null && ((GElement)((Object)this.onMouseTarget)).isHighlighted()) {
                redrawArea = this.highlighAsTarget((GElement)((Object)this.onMouseTarget), false, redrawArea);
            } else if (id == 502 && this.onMouseTarget != null) {
                GLinkHandlePointForUndo wrapperElem = this.setupUndoInfo(this.onMouseTargetLinkPosition);
                redrawArea = GUtil.union(this.move1(this.startOnMouseTarget, this.oldX, this.oldY, this.oldLpi), redrawArea);
                this.structure.move(wrapperElem, wrapperElem.getNewX(), wrapperElem.getNewY());
                GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.onMouseTarget);
            } else if (this.canMoveGLinkHandlePointwhenOnMouseTargetIsNULL(id, this.handlePoint, this.editingGLink, this.targetIndex, this.oldTarget, this.onMouseTarget, this.oldLpi)) {
                try {
                    Point2D.Double p = this.handlePoint.getPosition();
                    GLinkHandlePointForUndo wrapperElem = new GLinkHandlePointForUndo(this.handlePoint, this.editingGLink, this.targetIndex, this.oldTarget, this.editingGLink.getTargetAt(this.targetIndex), this.oldLpi, this.editingGLink.getTargetLinkPositionInfoAt(this.targetIndex), this.oldX, this.oldY, p.x, p.y);
                    redrawArea = GUtil.union(this.move1(this.editingGLink.getTargetAt(this.targetIndex), this.oldX, this.oldY, this.oldLpi), redrawArea);
                    this.structure.move(wrapperElem, wrapperElem.getNewX(), wrapperElem.getNewY());
                    GMouseInterpreter.restoreOnMouseTargetAddingObjectFlag(this.editingGLink.getTargetAt(this.targetIndex));
                }
                catch (Exception p) {
                    // empty catch block
                }
            }
            this.onMouseTarget = null;
            this.onMouseTargetLinkPosition = null;
            if (this.editingGLink instanceof LayerReactionLink) {
                GLinkedCreaseLine crsline;
                if (id == 501) {
                    this.startX = x;
                    this.startY = y;
                }
                if (id == 502) {
                    if (!GMouseInterpreter.getInstance().getEditSize().contains(x, y, 5.0, 5.0)) {
                        redrawArea = this.structure.moveLayerLineTarget(this.editingGLink, this.handlePoint, this.startX, this.startY, id);
                        GLinkedCreaseLine shape = (GLinkedCreaseLine)this.editingGLink.getGLinkedShape();
                        shape.sHandlePoint.update();
                        shape.eHandlePoint.update();
                        this.editingGLink.update();
                    } else {
                        crsline = (GLinkedCreaseLine)this.editingGLink.getGLinkedShape();
                        if (crsline.sHandlePoint == this.handlePoint) {
                            if (crsline.starttemp == null) {
                                crsline.starttemp = (Point2D.Double)crsline.lines[0].start.clone();
                            }
                        } else if (crsline.eHandlePoint == this.handlePoint && crsline.endtemp == null) {
                            crsline.endtemp = (Point2D.Double)crsline.lines[0].end.clone();
                        }
                        this.structure.moveLayerLineTarget(this.editingGLink, this.handlePoint, x, y, id);
                    }
                } else {
                    crsline = (GLinkedCreaseLine)this.editingGLink.getGLinkedShape();
                    if (crsline.sHandlePoint == this.handlePoint) {
                        if (crsline.starttemp == null) {
                            crsline.starttemp = (Point2D.Double)crsline.lines[0].start.clone();
                        }
                    } else if (crsline.eHandlePoint == this.handlePoint && crsline.endtemp == null) {
                        crsline.endtemp = (Point2D.Double)crsline.lines[0].end.clone();
                    }
                    this.structure.moveLayerLineTarget(this.editingGLink, this.handlePoint, x, y, id);
                }
            }
        }
        return redrawArea;
    }

    private boolean canMoveGLinkHandlePointwhenOnMouseTargetIsNULL(int id, GLinkHandlePoint orig, GLink targetGLink, int targetIndex, GLinkTarget oldTarget, GLinkTarget newTarget, GLinkPositionInfo oldLpi) {
        if (id != 502) {
            return false;
        }
        if (orig == null) {
            return false;
        }
        if (targetGLink == null) {
            return false;
        }
        if (oldTarget == null) {
            return false;
        }
        if (newTarget != null) {
            return false;
        }
        if (orig.getOwner() instanceof GLinkedLine) {
            if (orig.getOwner() instanceof LinkedCreaseLineForComplex3 ? targetIndex != 0 && targetIndex != 1 && targetIndex != 2 : targetIndex != 0 && targetIndex != 1) {
                return false;
            }
        } else if (orig.getOwner() instanceof GLinkedLineComplex3) {
            if (targetIndex != 0 && targetIndex != 1 && targetIndex != 2) {
                return false;
            }
        } else {
            return false;
        }
        GLinkPositionInfo newInfo = targetGLink.getTargetLinkPositionInfoAt(targetIndex);
        if (oldLpi == null && newInfo == null) {
            return false;
        }
        return newInfo != oldLpi;
    }

    private Rectangle2D highlighAsTarget(GElement element, boolean highlight, Rectangle2D redrawArea) {
        if (element != null) {
            redrawArea = GUtil.union(this.structure.hideLinkAnchors((GLinkTarget)((Object)element), false), redrawArea);
            redrawArea = GUtil.union(this.structure.highlightAsTarget(element, highlight, false), redrawArea);
        }
        return redrawArea;
    }

    private Vector getAllModifiers(GLink baseLink) {
        Vector<GLinkTarget> modificationObjects = new Vector<GLinkTarget>();
        Vector links = this.structure.getLinks();
        int size = links.size();
        int i = 0;
        while (i < size) {
            GLink link = (GLink)links.elementAt(i);
            if (GLogicGate.isModification(link.getGLinkedShape())) {
                if (((LinkedCreaseLine)link.getGLinkedShape()).getEndTarget() == baseLink) {
                    modificationObjects.add(((LinkedCreaseLine)link.getGLinkedShape()).getStartTarget());
                }
            } else if (link.getGLinkedShape() instanceof GLogicGate && ((GLogicGate)link.getGLinkedShape()).getRealLine().getEndTarget() == baseLink) {
                modificationObjects.addAll(((GLogicGate)link.getGLinkedShape()).getTargetElement());
            }
            ++i;
        }
        return modificationObjects;
    }

    private Vector getAllModifiers(SpeciesAlias species) {
        Vector<GLinkTarget> modificationObjects = new Vector<GLinkTarget>();
        Vector links = this.structure.getLinks();
        int size = links.size();
        int i = 0;
        while (i < size) {
            GLink link = (GLink)links.elementAt(i);
            if (GLogicGate.isModification(link.getGLinkedShape())) {
                if (((LinkedCreaseLine)link.getGLinkedShape()).getEndTarget() == species) {
                    modificationObjects.add(((LinkedCreaseLine)link.getGLinkedShape()).getStartTarget());
                }
            } else if (link.getGLinkedShape() instanceof GLogicGate && ((GLogicGate)link.getGLinkedShape()).getRealLine().getEndTarget() == species) {
                modificationObjects.addAll(((GLogicGate)link.getGLinkedShape()).getTargetElement());
            }
            ++i;
        }
        return modificationObjects;
    }
}

