/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GEditPoint;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkable;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedCurveEndLine;
import jp.fric.graphics.draw.GLinkedCurveStartLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.species.Tag;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Reaction;

public class GLink
extends GElementImpl
implements GLinkable,
GLinkTarget {
    private boolean isHighlighted = false;
    private String name = "";
    private int targetSize;
    private GLinkTarget[] targets;
    private GLinkPositionInfo[] linkPositionInfos;
    private GLinkedShape linkedShape = null;
    private static final Stroke stroke = new BasicStroke(1.0f, 0, 0);
    private boolean moveLinkMode = false;
    private static final int NO_QUARTER = 0;
    private static final int FIRST_QUARTER = 1;
    private static final int SECOND_QUARTER = 2;
    private static final int THIRD_QUARTER = 3;
    private static final int FORTH_QUARTER = 4;
    private static final double NAME_IMAGE_XOFFSIDE = 8.0;
    private static final double NAME_IMAGE_YOFFSIDE = 3.0;
    private Rectangle2D.Double nameBound = null;
    public static final int NO_LOGIC_TYPE = 0;
    public static final int AND_LOGIC_TYPE = 1;
    public static final int OR_LOGIC_TYPE = 2;
    public static final int UNKNOWN_LOGIC_TYPE = 3;
    public static final int NOT_LOGIC_TYPE = 4;
    public static final int CATALYSIS_MODIFICATION_TYPE = 1;
    public static final int UNKNOWN_CATALYSIS_MODIFICATION_TYPE = 2;
    public static final int INHIBITION_MODIFICATION_TYPE = 3;
    public static final int UNKNOWN_INHIBITION_MODIFICATION_TYPE = 4;
    public static final int PHYSICAL_MODIFICATION_TYPE = 5;
    public static final int MODULATION_MODIFICATION_TYPE = 6;
    public static final int TRIGGER_MODIFICATION_TYPE = 11;
    public static final int POSITIVE_INFERENCE_TYPE = 12;
    public static final int NEGATIVE_INFERENCE_TYPE = 13;
    public static final int MIXED_PHYSICAL_STIMULATION_TYPE = 14;
    public static final int MIXED_MODULATION_TYPE = 15;
    public static final int MIXED_TRIGGER_TYPE = 16;
    public static final int UNKNOWN_POSITIVE_INFERENCE_TYPE = 17;
    public static final int UNKNOWN_NEGATIVE_INFERENCE_TYPE = 18;
    public static final int UNKNOWN_PHYSICAL_STIMULATION_TYPE = 19;
    public static final int UNKNOWN_MODULATION_TYPE = 20;
    public static final int UNKNOWN_TRIGGER_TYPE = 21;
    public static final int ADDING_REACTANT = 1;
    public static final int ADDING_PRODUCT = 2;
    public static final int ADDING_MODIFICATION = 3;
    public static final int ADDING_FLAG_NORMAL = 0;
    private Point2D.Double targetPosition;

    public Point2D.Double getTargetPoint() {
        return this.targetPosition;
    }

    public GLink() {
    }

    public GLink(int i) {
        this.setTargetSize(i);
    }

    @Override
    public GElement createCopy() {
        GLink copy = null;
        try {
            copy = (GLink)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return copy;
        }
        copy.setTargetSize(this.targetSize);
        try {
            if (this.linkedShape != null) {
                GLinkedShape glinkedshape = this.linkedShape.createCopy();
                copy.setGLinkedShape(glinkedshape);
                Point2D.Double offset = this.linkedShape.getOffset();
                glinkedshape.setOffset(offset.x, offset.y);
            }
            int i = 0;
            while (i < this.targetSize) {
                if (this.targets[i] != null) {
                    GLinkedLineIndex glinkedlineindex = this.linkedShape.getGLinkedLineIndexAt(i);
                    if (glinkedlineindex != null) {
                        copy.setTargetAt(this.targets[i], i, glinkedlineindex);
                    } else {
                        copy.setTargetAt(this.targets[i], i, this.linkPositionInfos[i]);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        copy.update();
        return copy;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (this.linkedShape != null) {
            Color org_color = graphics2d.getColor();
            if (this.isHighlighted) {
                graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
            }
            graphics2d.setStroke(stroke);
            this.linkedShape.drawShape(graphics2d);
            if (Preference.showReaction) {
                try {
                    ReactionLink link = (ReactionLink)this;
                    Reaction reaction = link.getParentReaction();
                    String id = reaction.getId();
                    if (this.linkedShape instanceof GLinkedLineComplex3 || this.linkedShape instanceof GLinkedLine && !(this.linkedShape instanceof DirectSingleLine)) {
                        Color backUpColor = graphics2d.getColor();
                        graphics2d.setColor(this.linkedShape.getColor());
                        if (this.isHighlighted) {
                            graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
                        }
                        this.nameBound = this.getNameBounds(graphics2d);
                        graphics2d.drawString(id, (int)this.nameBound.getX() + 20, (int)this.nameBound.getY() + 20);
                        graphics2d.setColor(backUpColor);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.isHighlighted) {
                graphics2d.setColor(org_color);
            }
        }
    }

    private Rectangle2D.Double getNameBounds(Graphics2D graphics2d) {
        Rectangle2D.Double bound = null;
        try {
            GLinkedLine shape;
            if (graphics2d == null) {
                graphics2d = (Graphics2D)MainWindow.getLastInstance().getCurrentModel().getGraphics();
            }
            ReactionLink link = (ReactionLink)this;
            Reaction reaction = link.getParentReaction();
            String id = reaction.getId();
            if (this.linkedShape instanceof GLinkedLineComplex3) {
                GLinkedLineComplex3 shape2 = (GLinkedLineComplex3)this.linkedShape;
                GLinkedCreaseLine[] lines = new GLinkedCreaseLine[]{shape2.line1, shape2.line2, shape2.line3};
                Point2D.Double endPoint = null;
                Point2D.Double startPoint = null;
                int i = 0;
                while (i < 3) {
                    SpeciesAlias sSpeciesAlias;
                    String speciesId;
                    if (lines[i].getEndTarget() instanceof SpeciesAlias && reaction.getReactant(speciesId = (sSpeciesAlias = (SpeciesAlias)lines[i].getEndTarget()).getOriginalSpecies().getId()) != null) {
                        endPoint = lines[i].getLine(lines[i].getLines().length - 1).getStartPoint();
                        startPoint = lines[i].getLine(lines[i].getLines().length - 1).getEndPoint();
                        int lineQuarter = this.getLineQuarter(lines[i].getEndPoint(), endPoint);
                        Dimension size = this.getNameImageSize(graphics2d, id);
                        Point2D.Double newPosition = new Point2D.Double(0.0, 0.0);
                        if (lines[i].getEndLinkPositionInfo() == null || lines[i].getEndLinkPositionInfo().getPosition() == -1) {
                            Point2D.Double newPos;
                            Rectangle2D.Double bounds = sSpeciesAlias.getFrameBounds();
                            Point2D.Double pntInClosedEdgeOfAreaBy1Pnts = new Point2D.Double(0.0, 0.0);
                            pntInClosedEdgeOfAreaBy1Pnts = startPoint == null ? LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(new Area(bounds), startPoint, endPoint, 0.5, 1) : (Point2D.Double)startPoint.clone();
                            Point2D.Double thlast2StartPoint = null;
                            if (lines[i].getLines().length > 1) {
                                thlast2StartPoint = lines[i].getLine(lines[i].getLines().length - 2).getEndPoint();
                            }
                            if ((newPos = this.adjustNameImgStartpointForDisplayReactionID(bounds, pntInClosedEdgeOfAreaBy1Pnts, size, thlast2StartPoint)) != null) {
                                newPosition = newPos;
                            }
                        } else {
                            int quarter = this.getQuarter(lineQuarter, lines[i].getEndLinkPositionInfo().getPosition());
                            newPosition = this.getPosition(lines[i].getEndPoint(), quarter, size);
                            Point2D.Double newPos = this.adjuststartpointusingfordisplayReactionID(this.getTargetAt(i), newPosition, lines[i].getEndLinkPositionInfo().getPosition(), quarter, lineQuarter, size);
                            if (newPos != null) {
                                newPosition = newPos;
                            }
                        }
                        bound = new Rectangle2D.Double(newPosition.getX() - 24.0, newPosition.getY() - 23.0, size.width + 30, size.height + 30);
                    }
                    ++i;
                }
            } else if (this.linkedShape instanceof GLinkedLine && (shape = (GLinkedLine)this.linkedShape).getStartTarget() instanceof SpeciesAlias) {
                GLinkedCurveAndLine cLine;
                SpeciesAlias sSpeciesAlias = (SpeciesAlias)shape.getStartTarget();
                Point2D.Double endPoint = null;
                Point2D.Double startPoint = null;
                if (this.linkedShape instanceof GLinkedCreaseLine) {
                    GLinkedCreaseLine creaseLine = (GLinkedCreaseLine)this.linkedShape;
                    endPoint = creaseLine.getLine(0).getEndPoint();
                    startPoint = creaseLine.getLine(0).getStartPoint();
                } else if (this.linkedShape instanceof GLinkedCurveEndLine) {
                    cLine = (GLinkedCurveEndLine)this.linkedShape;
                    if (cLine.getCreasePointsSize() >= 1) {
                        startPoint = cLine.getEditPoints()[0].getPosition();
                    }
                } else if (this.linkedShape instanceof GLinkedCurveStartLine) {
                    cLine = (GLinkedCurveStartLine)this.linkedShape;
                    if (cLine.getCreasePointsSize() >= 1) {
                        endPoint = cLine.getEditPoints()[cLine.getEditPoints().length - 1].getPosition();
                    }
                } else {
                    endPoint = shape.getEndPoint();
                }
                int lineQuarter = this.getLineQuarter(shape.getStartPoint(), endPoint);
                Dimension size = this.getNameImageSize(graphics2d, id);
                Point2D.Double newPosition = new Point2D.Double(0.0, 0.0);
                if (shape.getStartLinkPositionInfo() == null || shape.getStartLinkPositionInfo().getPosition() == -1) {
                    Point2D.Double newPos;
                    GLinkedCreaseLine creaseLine;
                    Rectangle2D.Double bounds = sSpeciesAlias.getFrameBounds();
                    Point2D.Double pntInClosedEdgeOfAreaBy1Pnts = new Point2D.Double(0.0, 0.0);
                    pntInClosedEdgeOfAreaBy1Pnts = startPoint == null ? LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(new Area(bounds), startPoint, endPoint, 0.5, 1) : (Point2D.Double)startPoint.clone();
                    Point2D.Double thlast2StartPoint = null;
                    if (this.linkedShape instanceof GLinkedCreaseLine && (creaseLine = (GLinkedCreaseLine)this.linkedShape).getLines().length > 1) {
                        thlast2StartPoint = creaseLine.getLine(1).getStartPoint();
                    }
                    if ((newPos = this.adjustNameImgStartpointForDisplayReactionID(bounds, pntInClosedEdgeOfAreaBy1Pnts, size, thlast2StartPoint)) != null) {
                        newPosition = newPos;
                    }
                } else {
                    int quarter = this.getQuarter(lineQuarter, shape.getStartLinkPositionInfo().getPosition());
                    newPosition = this.getPosition(shape.getStartPoint(), quarter, size);
                    Point2D.Double newPos = this.adjuststartpointusingfordisplayReactionID(this.getTargetAt(0), newPosition, shape.getStartLinkPositionInfo().getPosition(), quarter, lineQuarter, size);
                    if (newPos != null) {
                        newPosition = newPos;
                    }
                }
                bound = new Rectangle2D.Double(newPosition.getX() - 24.0, newPosition.getY() - 23.0, size.width + 30, size.height + 30);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bound;
    }

    private Point2D.Double adjuststartpointusingfordisplayReactionID(GLinkTarget target, Point2D.Double position, int linkposition, int quarter, int lineQuarter, Dimension size) {
        Point2D.Double newPosition;
        block6: {
            if (target == null || position == null || linkposition == -1 || size == null) {
                return null;
            }
            newPosition = (Point2D.Double)position.clone();
            Point2D.Double newPos = null;
            try {
                String code;
                SpeciesSymbol symbol;
                GFramedShape sp;
                if (!(target instanceof ElementSpeciesAlias) || !((sp = ((ElementSpeciesAlias)target).getGFramedShape()) instanceof MonoSpeciesShape) || (symbol = ((MonoSpeciesShape)sp).getSpeciesSymbol()) == null || !(code = ((SBSymbol)((Object)symbol)).getCode()).equals("TAG")) break block6;
                Tag tag = (Tag)symbol;
                if ((linkposition != 3 || lineQuarter != 1) && (linkposition != 5 && linkposition != 6 || lineQuarter == 1)) break block6;
                Rectangle2D.Double idstrrect = new Rectangle2D.Double(newPosition.x, newPosition.y - (double)size.height, size.width, size.height);
                boolean isinshape = tag.intersectsShape(idstrrect, true);
                if (isinshape) {
                    newPos = (Point2D.Double)newPosition.clone();
                    int m = 0;
                    while (m < 50) {
                        newPos.x += 3.0;
                        idstrrect = new Rectangle2D.Double(newPos.x, newPos.y - (double)size.height, size.width, size.height);
                        isinshape = tag.intersectsShape(idstrrect, true);
                        if (!isinshape) {
                            return newPos;
                        }
                        ++m;
                    }
                    break block6;
                }
                return newPosition;
            }
            catch (Exception myErr) {
                return null;
            }
        }
        return newPosition;
    }

    private int getQuarter(int lineQuarter, int pointPosition) {
        int curruentQuarter = 1;
        while (curruentQuarter < 5) {
            if (curruentQuarter != lineQuarter && this.isObjectNotInQuarter(pointPosition, curruentQuarter)) {
                return curruentQuarter;
            }
            ++curruentQuarter;
        }
        return 1;
    }

    private boolean isObjectNotInQuarter(int pointPosition, int quarter) {
        if (quarter == 0) {
            return true;
        }
        switch (pointPosition) {
            case 0: {
                return quarter == 1 || quarter == 2;
            }
            case 1: {
                return quarter == 1 || quarter == 2;
            }
            case 2: {
                return quarter != 3;
            }
            case 3: {
                return quarter == 1 || quarter == 4;
            }
            case 4: {
                return quarter == 1 || quarter == 4;
            }
            case 5: {
                return quarter == 1 || quarter == 4;
            }
            case 6: {
                return quarter != 2;
            }
            case 7: {
                return quarter == 3 || quarter == 4;
            }
            case 8: {
                return quarter == 3 || quarter == 4;
            }
            case 9: {
                return quarter == 3 || quarter == 4;
            }
            case 10: {
                return quarter != 1;
            }
            case 11: {
                return quarter == 2 || quarter == 3;
            }
            case 12: {
                return quarter == 2 || quarter == 3;
            }
            case 13: {
                return quarter == 2 || quarter == 3;
            }
            case 14: {
                return quarter != 4;
            }
            case 15: {
                return quarter == 1 || quarter == 2;
            }
        }
        return true;
    }

    private Point2D.Double getPosition(Point2D.Double originalPoint, int quarter, Dimension nameSize) {
        double x = originalPoint.getX();
        double y = originalPoint.getY();
        switch (quarter) {
            case 1: {
                x += 8.0;
                y -= 3.0;
                break;
            }
            case 2: {
                x = x - 8.0 - nameSize.getWidth();
                y -= 3.0;
                break;
            }
            case 3: {
                x = x - 8.0 - nameSize.getWidth();
                y += nameSize.getHeight();
                break;
            }
            case 4: {
                x += 8.0;
                y += nameSize.getHeight();
                break;
            }
        }
        if (x < 0.0) {
            x = 0.0;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        return new Point2D.Double(x, y);
    }

    private Dimension getNameImageSize(Graphics2D g2, String name) {
        FontMetrics fm = g2.getFontMetrics();
        char[] array = name.toCharArray();
        int height = fm.getAscent() + 4;
        int width = 0;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (c == '~') {
                height += height;
            } else if (c != '^' && c != '%' && c != '$') {
                width += fm.charWidth(c);
            }
            ++i;
        }
        return new Dimension(width, height);
    }

    private int getLineQuarter(Point2D.Double startPoint, Point2D.Double endPoint) {
        if (startPoint.getX() == endPoint.getX() || startPoint.getY() == endPoint.getY()) {
            return 0;
        }
        if (endPoint.getX() > startPoint.getX()) {
            if (endPoint.getY() > startPoint.getY()) {
                return 4;
            }
            return 1;
        }
        if (endPoint.getY() > startPoint.getY()) {
            return 3;
        }
        return 2;
    }

    public void drawWhiteBase(Graphics2D graphics2d) {
        if (this.linkedShape != null) {
            this.linkedShape.drawWhiteBaseShape(graphics2d);
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.linkedShape != null) {
            if (this.nameBound == null) {
                this.nameBound = this.getNameBounds(null);
            }
            return GUtil.union(this.nameBound, this.linkedShape.getShapeBounds());
        }
        return null;
    }

    @Override
    public Rectangle2D.Double getBoundsAsTarget() {
        return this.getBounds();
    }

    public int getCurveBindingIndex() {
        if (this.linkedShape == null) {
            return 0;
        }
        return this.linkedShape.getCurveBindingIndex();
    }

    public GLinkedShape getGLinkedShape() {
        return this.linkedShape;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.getBounds();
    }

    public Point2D.Double getRepresentPosition(boolean isTemp) {
        if (this.targets[0] == null || this.linkedShape == null) {
            if (this instanceof LayerReactionLink) {
                GLink link = this;
                GLinkedCreaseLine shape = (GLinkedCreaseLine)link.getGLinkedShape();
                if (shape.lines[0].starttemp == null && shape.lines[0].endtemp == null) {
                    shape.lines[0].starttemp = (Point2D.Double)shape.lines[0].start.clone();
                    shape.lines[0].endtemp = (Point2D.Double)shape.lines[0].end.clone();
                }
                if (isTemp) {
                    return new Point2D.Double((shape.lines[0].starttemp.x + shape.lines[0].endtemp.x) / 2.0, (shape.lines[0].starttemp.y + shape.lines[0].endtemp.y) / 2.0);
                }
                return new Point2D.Double((shape.lines[0].start.x + shape.lines[0].end.x) / 2.0, (shape.lines[0].start.y + shape.lines[0].end.y) / 2.0);
            }
            return null;
        }
        Point2D.Double targetPoint = this.targets[0].targetPoint();
        Point2D.Double offset = this.linkedShape.getOffset();
        double positionX = targetPoint.x + offset.x;
        double positionY = targetPoint.y + offset.y;
        return new Point2D.Double(positionX, positionY);
    }

    @Override
    public GLinkTarget getTargetAt(int i) throws Exception {
        if (i < 0 || i >= this.targetSize) {
            throw new Exception("OutOfArrayIndex. request=" + i + ", but size=" + this.targetSize);
        }
        return this.targets[i];
    }

    @Override
    public GLinkTarget[] getTargets() {
        return this.targets;
    }

    public GLinkPositionInfo getTargetLinkPositionInfoAt(int i) {
        return this.getGLinkedShape().getTargetLinkPositionInfoAt(i);
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.linkedShape != null) {
            return this.linkedShape.inShape(x, y);
        }
        return false;
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        if (this.linkedShape == null) {
            return false;
        }
        return this.linkedShape.inShapeAsTarget(x, y);
    }

    @Override
    public boolean intersects(Rectangle2D.Double area) {
        if (this instanceof LayerReactionLink) {
            return this.getBounds().intersects(area);
        }
        return false;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public boolean isLinkOf(GLinkTarget glinktarget) {
        boolean bool = false;
        int i = 0;
        while (i < this.targetSize) {
            if (this.targets[i] != null && this.targets[i] == glinktarget) {
                bool = true;
                break;
            }
            ++i;
        }
        return bool;
    }

    @Override
    public boolean isLinkable(GLinkTarget glinktarget, int i) {
        return i >= 0 && i < this.targetSize;
    }

    public void setGLinkedShape(GLinkedShape glinkedshape) throws Exception {
        if (this.targetSize != glinkedshape.targetSize()) {
            throw new Exception("targetSize is not equal, between GLink and GLinkedShape");
        }
        if (this.linkedShape != null) {
            Point2D.Double offset = this.linkedShape.getOffset();
            glinkedshape.setOffset(offset.x, offset.y);
        }
        this.linkedShape = glinkedshape;
        int i = 0;
        while (i < this.targetSize) {
            if (this.targets[i] != null) {
                glinkedshape.setTargetAt(this.targets[i], i, this.linkPositionInfos[i]);
            }
            ++i;
        }
    }

    @Override
    public void setHighlighted(boolean highlight) {
        this.isHighlighted = highlight;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setRepresentPosition(double x, double y) {
        if (this.targets[0] != null && this.linkedShape != null) {
            Point2D.Double targetPoint = this.targets[0].targetPoint();
            double repX = x - targetPoint.x;
            double repY = y - targetPoint.y;
            this.linkedShape.setOffset(repX, repY);
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int i, GLinkPositionInfo lpi) throws Exception {
        if (i < 0 || i >= this.targetSize) {
            throw new Exception("OutOfArrayIndex. request=" + i + ", but size=" + this.targetSize);
        }
        this.targets[i] = glinktarget;
        this.linkPositionInfos[i] = lpi;
        if (this.linkedShape != null) {
            this.linkedShape.setTargetAt(glinktarget, i, lpi);
        }
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int linkedCnt, double x, double y, GLinkPositionInfo lpi) throws Exception {
        if (linkedCnt < 0 || linkedCnt >= this.targetSize) {
            throw new Exception("OutOfArrayIndex. request=" + linkedCnt + ", but size=" + this.targetSize);
        }
        this.targets[linkedCnt] = glinktarget;
        this.linkPositionInfos[linkedCnt] = lpi;
        if (this.linkedShape != null) {
            this.linkedShape.setTargetAt(glinktarget, linkedCnt, x, y, lpi);
        }
    }

    private GLinkPositionInfo confirmedPostionInfo(GLinkPositionInfo lpi, GLinkTarget glinktarget) {
        return this.confirmedPostionInfo(lpi, glinktarget, this);
    }

    private GLinkPositionInfo confirmedPostionInfo(GLinkPositionInfo lpi, GLinkTarget glinktarget, GLink glink) {
        if (lpi == null) {
            return null;
        }
        if (glinktarget == null) {
            return null;
        }
        if (glink == null) {
            return null;
        }
        GLinkedShape targetshape = null;
        if (glinktarget instanceof GLink) {
            targetshape = ((GLink)glinktarget).getGLinkedShape();
        } else if (glinktarget instanceof GCreasePoint) {
            GCreasePoint cspnt = (GCreasePoint)glinktarget;
            GEditable geditable = cspnt.getOwner();
            if (geditable instanceof GLinkedCreaseLine) {
                GLinkedCreaseLine csln = (GLinkedCreaseLine)geditable;
                try {
                    GLink glk = csln.getReactionLink(MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure());
                    targetshape = glk.getGLinkedShape();
                }
                catch (Exception e) {
                    targetshape = null;
                }
            } else if (geditable instanceof GLinkedLineComplex3) {
                GLinkedLineComplex3 compx3 = (GLinkedLineComplex3)geditable;
                targetshape = compx3;
            }
        }
        GLinkedShape editshape = glink.getGLinkedShape();
        if (targetshape != null && (targetshape instanceof StateTransition || targetshape instanceof LinkedLineComplex3)) {
            if (GLogicGate.isModification(editshape)) {
                if (lpi.getPosition() < 2 || lpi.getPosition() > 7) {
                    lpi.setPosition(2);
                    return lpi;
                }
                return lpi;
            }
            if (editshape instanceof AddProduct) {
                if (lpi.getPosition() != 1) {
                    lpi.setPosition(1);
                    return lpi;
                }
                return lpi;
            }
            if (editshape instanceof AddReactant) {
                if (lpi.getPosition() != 0) {
                    lpi.setPosition(0);
                    return lpi;
                }
                return lpi;
            }
        } else {
            return lpi;
        }
        return lpi;
    }

    @Override
    public void setTargetAt(GLinkTarget glinktarget, int i, GLinkedLineIndex glinkedlineindex) throws Exception {
        if (i < 0 || i >= this.targetSize) {
            throw new Exception("OutOfArrayIndex. request=" + i + ", but size=" + this.targetSize);
        }
        this.targets[i] = glinktarget;
        this.linkPositionInfos[i] = null;
        if (this.linkedShape != null) {
            this.linkedShape.setTargetAt(glinktarget, i, glinkedlineindex);
        }
    }

    public void setTargetSize(int size) {
        this.targets = new GLinkTarget[size];
        this.linkPositionInfos = new GLinkPositionInfo[size];
        this.targetSize = size;
    }

    public GLinkPositionInfo[] getLinkPositionInfos() {
        return this.linkPositionInfos;
    }

    @Override
    public Point2D.Double targetPoint() {
        if (this.linkedShape == null) {
            return null;
        }
        return this.linkedShape.targetPoint();
    }

    @Override
    public int targetSize() {
        return this.targetSize;
    }

    @Override
    public Rectangle2D update() {
        if (this.linkedShape != null) {
            Rectangle2D.Double recShp = null;
            try {
                recShp = this.linkedShape.updateShape();
            }
            catch (Exception myErr) {
                return null;
            }
            try {
                this.nameBound = this.getNameBounds(null);
            }
            catch (Exception myErr) {
                return recShp;
            }
            return GUtil.union(recShp, this.nameBound);
        }
        return null;
    }

    public Rectangle2D.Double update(boolean moveCreasePoints) {
        if (this.linkedShape != null) {
            if (this.nameBound == null) {
                this.nameBound = this.getNameBounds(null);
            }
            return GUtil.union(this.nameBound, this.linkedShape.updateShape(moveCreasePoints));
        }
        return null;
    }

    public int getTargetIndex(GEditPoint ep) {
        return this.linkedShape.getTargetIndex(ep);
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.getGLinkedShape().showLinkAnchors(lpi, drawOnlyActive);
    }

    @Override
    public void hideLinkAnchors() {
        this.getGLinkedShape().hideLinkAnchors();
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        return this.getGLinkedShape().getPointedLinkPosition(x, y);
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        Point2D.Double pt = null;
        if (lpi != null) {
            if (lpi.getArm() > 3) {
                return pt;
            }
            if (lpi.getElement() instanceof GLink && ((GLink)lpi.getElement()).getGLinkedShape() instanceof GLogicGate) {
                return ((GLogicGate)((GLink)lpi.getElement()).getGLinkedShape()).getCoordinatesOfLinkPosition(lpi);
            }
        }
        if (this.getGLinkedShape() instanceof GLogicGate) {
            return ((GLogicGate)this.getGLinkedShape()).getCoordinatesOfLinkPosition(lpi);
        }
        if (this.getGLinkedShape() instanceof GLinkedLine) {
            return ((GLinkTarget)((Object)this.getGLinkedShape())).getCoordinatesOfLinkPosition(lpi);
        }
        return ((GLinkedLineComplex3)this.getGLinkedShape()).getCoordinatesOfLinkPosition(lpi);
    }

    public Vector getSources() {
        throw new UnsupportedOperationException();
    }

    public Vector getDistinations() {
        throw new UnsupportedOperationException();
    }

    public void setupAfterAllTargetsSetted() {
        this.getGLinkedShape().setupAfterAllTargetsSetted();
    }

    public boolean isMoveLinkMode() {
        return this.moveLinkMode;
    }

    public void setMoveLinkMode(boolean moveLinkMode) {
        this.moveLinkMode = moveLinkMode;
    }

    private Point2D.Double adjustNameImgStartpointForDisplayReactionID(Rectangle2D.Double bounds, Point2D.Double end, Dimension size, Point2D.Double thLast2StartPoint) {
        Point2D.Double newPosition = end;
        try {
            Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            Point2D.Double posTmp01 = new Point2D.Double(end.x - center.x, -(end.y - center.y));
            boolean bMinusWD = false;
            boolean bMinusHI = false;
            int iCreaseX = 0;
            int iCreaseY = 0;
            if (posTmp01.x == 0.0 && posTmp01.y == 0.0) {
                double disY;
                if (thLast2StartPoint == null) {
                    return newPosition;
                }
                double disX = Math.abs(thLast2StartPoint.x - center.x);
                if (disX >= (disY = Math.abs(thLast2StartPoint.y - center.y))) {
                    iCreaseX = thLast2StartPoint.x >= center.x ? 1 : -1;
                } else {
                    iCreaseY = thLast2StartPoint.y >= center.y ? -1 : 1;
                }
            } else if (posTmp01.x == 0.0 && posTmp01.y > 0.0) {
                bMinusWD = false;
                bMinusHI = false;
                iCreaseY = 1;
            } else if (posTmp01.x == 0.0 && posTmp01.y < 0.0) {
                bMinusWD = true;
                bMinusHI = true;
                iCreaseY = -1;
            } else if (posTmp01.y == 0.0 && posTmp01.x > 0.0) {
                bMinusWD = false;
                bMinusHI = false;
                iCreaseX = 1;
            } else if (posTmp01.y == 0.0 && posTmp01.x < 0.0) {
                bMinusWD = true;
                bMinusHI = true;
                iCreaseX = -1;
            } else if (posTmp01.x > 0.0 && posTmp01.y > 0.0) {
                if (Math.abs(posTmp01.x) > Math.abs(posTmp01.y)) {
                    bMinusWD = false;
                    bMinusHI = true;
                    iCreaseX = 1;
                } else {
                    bMinusWD = true;
                    bMinusHI = false;
                    iCreaseY = 1;
                }
            } else if (posTmp01.x > 0.0 && posTmp01.y < 0.0) {
                if (Math.abs(posTmp01.x) > Math.abs(posTmp01.y)) {
                    bMinusWD = false;
                    bMinusHI = false;
                    iCreaseX = 1;
                } else {
                    bMinusWD = true;
                    bMinusHI = true;
                    iCreaseY = -1;
                }
            } else if (posTmp01.x < 0.0 && posTmp01.y > 0.0) {
                if (Math.abs(posTmp01.x) > Math.abs(posTmp01.y)) {
                    bMinusWD = true;
                    bMinusHI = true;
                    iCreaseX = -1;
                } else {
                    bMinusWD = false;
                    bMinusHI = false;
                    iCreaseY = 1;
                }
            } else if (posTmp01.x < 0.0 && posTmp01.y < 0.0) {
                if (Math.abs(posTmp01.x) > Math.abs(posTmp01.y)) {
                    bMinusWD = true;
                    bMinusHI = false;
                    iCreaseX = -1;
                } else {
                    bMinusWD = false;
                    bMinusHI = true;
                    iCreaseY = -1;
                }
            }
            Point2D.Double posTmp02 = new Point2D.Double();
            if (bMinusWD && bMinusHI) {
                posTmp02.x = posTmp01.x - (double)size.width;
                posTmp02.y = posTmp01.y - (double)size.height;
            } else if (bMinusWD && !bMinusHI) {
                posTmp02.x = posTmp01.x - (double)size.width;
                posTmp02.y = posTmp01.y;
            } else if (!bMinusWD && bMinusHI) {
                posTmp02.x = posTmp01.x;
                posTmp02.y = posTmp01.y - (double)size.height;
            } else {
                posTmp02.x = posTmp01.x;
                posTmp02.y = posTmp01.y;
            }
            Point2D.Double posTmp03 = new Point2D.Double(posTmp02.x, posTmp02.y);
            int delta = 5;
            for (int max = 1000; max > 0; --max) {
                posTmp03 = new Point2D.Double(posTmp03.x + (double)(5 * iCreaseX), posTmp03.y + (double)(5 * iCreaseY));
                Point2D.Double posTmp04 = new Point2D.Double(posTmp03.x + center.x, -posTmp03.y + center.y);
                Rectangle2D.Double idstrrect = new Rectangle2D.Double(posTmp04.x, posTmp04.y - (double)size.height, size.width, size.height);
                if (bounds.intersects(idstrrect)) continue;
                newPosition = posTmp04;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Point2D.Double(newPosition.x + 4.0, newPosition.y + 3.0);
    }
}

