/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Vector;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFrameHandle;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GGroupTarget;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;

public class GGroup
extends GElementImpl
implements GFramed {
    private boolean isHighlighted = false;
    private String name = "";
    private Point2D.Double position = null;
    private Point2D.Double size = new Point2D.Double(0.0, 0.0);
    private Rectangle2D.Double bounds = null;
    private GFrameHandle[] handles = new GFrameHandle[4];
    private static final int N_HANDLES = 4;
    private static final double HANDLE_SIZE = 4.0;
    private Vector members = new Vector();
    private Vector innerPositions = new Vector();
    private Rectangle2D.Double midRect = new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0);

    public GGroup() {
        this.initHandles();
    }

    public GGroup(Vector elements) {
        this.initHandles();
        this.setMembers(elements);
    }

    @Override
    public void activateHandle(boolean bool) {
        this.handles[0].setActive(bool);
        this.handles[1].setActive(bool);
        this.handles[2].setActive(bool);
        this.handles[3].setActive(bool);
    }

    @Override
    public GElement createCopy() {
        GGroup group = null;
        try {
            group = (GGroup)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return group;
        }
        Vector<GElement> vector = new Vector<GElement>();
        int i = 0;
        while (i < this.members.size()) {
            GElement gelement = (GElement)this.members.elementAt(i);
            vector.add(gelement.createCopy());
            ++i;
        }
        group.setMembers(vector);
        return group;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        this.updateGateMemberofGroup();
        Paint paint = graphics2d.getPaint();
        if (this.isHighlighted) {
            graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
        } else {
            graphics2d.setColor(GColor.NORMAL_COLOR);
        }
        this.handles[0].draw(graphics2d);
        this.handles[1].draw(graphics2d);
        this.handles[2].draw(graphics2d);
        this.handles[3].draw(graphics2d);
        if (this.isHighlighted) {
            graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
            graphics2d.fill(this.midRect);
        }
        graphics2d.setPaint(paint);
    }

    public void updateGateMemberofGroup() {
        int i = 0;
        while (i < this.members.size()) {
            Object obj = this.members.get(i);
            if (obj instanceof GCreasePoint && ((GCreasePoint)obj).isLogicGateHeaderPoint()) {
                this.members.remove(i);
            }
            ++i;
        }
        try {
            this.addCreasePointMember(MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Point2D.Double getFramePosition() {
        return this.position;
    }

    @Override
    public Point2D.Double getFrameSize() {
        return this.size;
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        if (this.handles[0].getRect().contains(x, y)) {
            return this.handles[0];
        }
        if (this.handles[1].getRect().contains(x, y)) {
            return this.handles[1];
        }
        if (this.handles[2].getRect().contains(x, y)) {
            return this.handles[2];
        }
        if (this.handles[3].getRect().contains(x, y)) {
            return this.handles[3];
        }
        return null;
    }

    public Vector getMembers() {
        return (Vector)this.members.clone();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        Rectangle2D.Double bounds = null;
        int i = 0;
        while (i < this.members.size()) {
            GElement gelement = (GElement)this.members.elementAt(i);
            bounds = GUtil.union(bounds, gelement.getRepaintBounds());
            ++i;
        }
        return bounds;
    }

    @Override
    public boolean inShape(double x, double y) {
        return false;
    }

    private void initHandles() {
        this.handles[0] = new GFrameHandle(this);
        this.handles[1] = new GFrameHandle(this);
        this.handles[2] = new GFrameHandle(this);
        this.handles[3] = new GFrameHandle(this);
        this.handles[0].setLocation(1);
        this.handles[1].setLocation(2);
        this.handles[2].setLocation(3);
        this.handles[3].setLocation(4);
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        return false;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void releaseMembers() {
        this.members.clear();
    }

    @Override
    public void setFramePosition(double x, double y) {
        if (this.position == null) {
            this.position = new Point2D.Double(x, y);
        } else {
            this.position.x = x;
            this.position.y = y;
        }
    }

    @Override
    public void setFrameSize(double width, double height) {
        this.size.x = width;
        this.size.y = height;
    }

    @Override
    public void setHighlighted(boolean bool) {
        this.isHighlighted = bool;
        int i = 0;
        while (i < this.members.size()) {
            int j;
            Vector targets;
            GElement gelement = (GElement)this.members.elementAt(i);
            if (gelement instanceof ComplexSpeciesAlias) {
                targets = ((ComplexSpeciesAlias)gelement).getAllTargetsInMe(false);
                j = 0;
                while (j < targets.size()) {
                    ((GElement)targets.elementAt(j)).setHighlighted(bool);
                    ++j;
                }
                gelement.setHighlighted(bool);
            } else {
                if (gelement instanceof GContainableAtom) {
                    targets = ((GContainableAtom)gelement).getTargets();
                    j = 0;
                    while (j < targets.size()) {
                        ((GElement)targets.elementAt(j)).setHighlighted(bool);
                        ++j;
                    }
                }
                gelement.setHighlighted(bool);
            }
            ++i;
        }
    }

    public void setMembers(Vector vector) {
        this.members.clear();
        int i = 0;
        while (i < vector.size()) {
            GCreasePoint point;
            GLogicGate gate;
            if (vector.elementAt(i) instanceof GFramed) {
                GFramed gframed = (GFramed)vector.elementAt(i);
                if (gframed instanceof GGroupTarget) {
                    this.members.add(gframed);
                    this.innerPositions.add(new Point2D.Double());
                }
            } else if (vector.elementAt(i) instanceof GCreasePoint && ((GCreasePoint)vector.elementAt(i)).getOwner() == null) {
                this.members.add(vector.elementAt(i));
                this.innerPositions.add(new Point2D.Double());
            } else if (vector.elementAt(i) instanceof GCreasePoint && ((GCreasePoint)vector.elementAt(i)).isLogicGateHeaderPoint() && vector.containsAll((gate = (GLogicGate)(point = (GCreasePoint)vector.elementAt(i)).getOwner()).getTargetElement())) {
                boolean containAll = true;
                if (gate.getRealLine().getEndTarget() instanceof SpeciesAlias) {
                    if (!vector.contains((SpeciesAlias)gate.getRealLine().getEndTarget())) {
                        containAll = false;
                        break;
                    }
                } else {
                    GLink baseLink = (GLink)gate.getRealLine().getEndTarget();
                    int k = 0;
                    while (k < baseLink.getTargets().length) {
                        if (!vector.contains(baseLink.getTargets()[k])) {
                            containAll = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (containAll) {
                    this.members.add(point);
                    this.innerPositions.add(new Point2D.Double());
                }
            }
            ++i;
        }
        GStructure structure = null;
        try {
            structure = MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure();
            if (structure != null) {
                this.addCreasePointMember(structure);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePositions();
    }

    public void addCreasePointMember(GStructure structure) {
        Vector links = structure.getLinks();
        int i = 0;
        while (i < links.size()) {
            ReactionLink link = (ReactionLink)links.elementAt(i);
            if (link.getGLinkedShape() instanceof GLogicGate) {
                GLogicGate gate = (GLogicGate)link.getGLinkedShape();
                boolean containAll = true;
                if (link.isBaseLinkGate()) {
                    if (!this.members.contains((SpeciesAlias)gate.getRealLine().getEndTarget())) {
                        containAll = false;
                        break;
                    }
                } else {
                    ReactionLink baseLink = (ReactionLink)gate.getRealLine().getEndTarget();
                    int k = 0;
                    while (k < baseLink.getTargets().length) {
                        if (!this.members.contains(baseLink.getTargets()[k])) {
                            containAll = false;
                            break;
                        }
                        ++k;
                    }
                }
                if (containAll && this.members.containsAll(gate.getTargetElement()) && !this.members.contains(gate.getHeaderPoint())) {
                    this.members.add(gate.getHeaderPoint());
                    this.innerPositions.add(new Point2D.Double());
                }
            }
            ++i;
        }
        this.updatePositions();
    }

    public boolean isGateInSamegroup(GLogicGate gate, Vector vGroupmembers) {
        boolean rtn = true;
        if (vGroupmembers.containsAll(gate.getTargetElement())) {
            GLink baseLink = (GLink)gate.getRealLine().getEndTarget();
            int iSize = baseLink.getTargets().length;
            int k = 0;
            while (k < iSize) {
                if (!vGroupmembers.contains(baseLink.getTargets()[k])) {
                    rtn = false;
                    break;
                }
                ++k;
            }
        } else {
            rtn = false;
        }
        return rtn;
    }

    public static GGroup getGroupofGate(GLogicGate gate) {
        GGroup rtn = null;
        try {
            Vector groupList = MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure().getGroups();
            if (!groupList.isEmpty()) {
                for (GGroup group : groupList) {
                    Vector mbLst = group.getMembers();
                    for (Object obj : mbLst) {
                        GCreasePoint point;
                        GLogicGate gt;
                        if (!(obj instanceof GCreasePoint) || !((GCreasePoint)obj).isLogicGateHeaderPoint() || !(gt = (GLogicGate)(point = (GCreasePoint)obj).getOwner()).equals(gate)) continue;
                        return group;
                    }
                }
            }
        }
        catch (Exception e) {
            return rtn;
        }
        return rtn;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Rectangle2D update() {
        if (this.position == null || this.size == null) {
            return null;
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double(this.position.x, this.position.y, this.size.x, this.size.y);
        }
        Rectangle2D.Double oldbounds = (Rectangle2D.Double)this.bounds.clone();
        double w = this.bounds.width;
        double h = this.bounds.height;
        this.bounds.x = this.position.x;
        this.bounds.y = this.position.y;
        this.bounds.width = this.size.x;
        this.bounds.height = this.size.y;
        this.handles[0].updateRect();
        this.handles[1].updateRect();
        this.handles[2].updateRect();
        this.handles[3].updateRect();
        this.midRect.x = this.position.x + this.size.x / 2.0 - this.midRect.width / 2.0;
        this.midRect.y = this.position.y + this.size.y / 2.0 - this.midRect.height / 2.0;
        double rx = this.bounds.width / w;
        double ry = this.bounds.height / h;
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.members.size()) {
            if (this.members.elementAt(i) instanceof GFramed) {
                GFramed gframed = (GFramed)this.members.elementAt(i);
                Rectangle2D.Double framebounds = gframed.getFrameBounds();
                Point2D.Double innerPos = (Point2D.Double)this.innerPositions.elementAt(i);
                innerPos.x *= rx;
                innerPos.y *= ry;
                double newPosX = this.bounds.x + innerPos.x;
                double newPosY = this.bounds.y + innerPos.y;
                double newW = ((RectangularShape)framebounds).getWidth() * rx;
                double newH = ((RectangularShape)framebounds).getHeight() * ry;
                gframed.setFramePosition(newPosX, newPosY);
                gframed.setFrameSize(newW, newH);
                if (gframed instanceof ComplexSpeciesAlias) {
                    Rectangle2D redrawArea2;
                    ComplexSpeciesAlias complex = (ComplexSpeciesAlias)gframed;
                    if (complex.getCurrentView() != 1) {
                        redrawArea2 = this.updateComplexInGroup(complex, newPosX, newPosY, rx, ry);
                        redrawArea = GUtil.union(redrawArea, redrawArea2);
                    }
                    redrawArea2 = ((GElement)((Object)gframed)).update();
                    redrawArea = GUtil.union(redrawArea, redrawArea2);
                } else {
                    GContainableAtom catom;
                    if (gframed instanceof GContainableAtom && (catom = (GContainableAtom)gframed).getCurrentView() != 1) {
                        Vector targets = catom.getTargets();
                        int j = 0;
                        while (j < targets.size()) {
                            GAtom gf = (GAtom)targets.elementAt(j);
                            Rectangle2D.Double fbounds = gf.getFrameBounds();
                            Point2D.Double iPos = gf.getInnerPosition();
                            iPos.x *= rx;
                            iPos.y *= ry;
                            gf.setFramePosition(newPosX + iPos.x, newPosY + iPos.y);
                            gf.setFrameSize(fbounds.width * rx, fbounds.height * ry);
                            gf.update();
                            ++j;
                        }
                    }
                    Rectangle2D redrawArea2 = ((GElement)((Object)gframed)).update();
                    redrawArea = GUtil.union(redrawArea, redrawArea2);
                }
            } else if (this.members.elementAt(i) instanceof GCreasePoint) {
                GCreasePoint point = (GCreasePoint)this.members.elementAt(i);
                Point2D.Double innerPos = (Point2D.Double)this.innerPositions.elementAt(i);
                innerPos.x *= rx;
                innerPos.y *= ry;
                double newPosX = this.bounds.x + innerPos.x;
                double newPosY = this.bounds.y + innerPos.y;
                point.getPosition().setLocation(newPosX, newPosY);
                redrawArea = GUtil.union(redrawArea, point.update());
            }
            ++i;
        }
        if (oldbounds.equals(this.bounds)) {
            return null;
        }
        return redrawArea;
    }

    private Rectangle2D updateComplexInGroup(ComplexSpeciesAlias complex, double newPosx, double newPosy, double rx, double ry) {
        Rectangle2D redrawArea = null;
        Vector target = complex.getTargets();
        int size = target.size();
        int i = 0;
        while (i < size) {
            GAtom gf = (GAtom)target.elementAt(i);
            Rectangle2D.Double fbounds = gf.getFrameBounds();
            Point2D.Double iPos = gf.getInnerPosition();
            iPos.x *= rx;
            iPos.y *= ry;
            gf.setFramePosition(newPosx + iPos.x, newPosy + iPos.y);
            gf.setFrameSize(fbounds.width * rx, fbounds.height * ry);
            redrawArea = gf.update();
            if (gf instanceof ComplexSpeciesAlias) {
                Rectangle2D redrawArea2 = this.updateComplexInGroup((ComplexSpeciesAlias)gf, newPosx + iPos.x, newPosy + iPos.y, rx, ry);
                redrawArea = GUtil.union(redrawArea, redrawArea2);
            }
            ++i;
        }
        return redrawArea;
    }

    protected synchronized void updatePositions() {
        GCreasePoint point;
        GFramed gframed;
        this.bounds = null;
        int i = 0;
        while (i < this.members.size()) {
            if (this.members.elementAt(i) instanceof GFramed) {
                gframed = (GFramed)this.members.elementAt(i);
                this.bounds = GUtil.union(this.bounds, gframed.getFrameBounds());
            } else if (this.members.elementAt(i) instanceof GCreasePoint) {
                point = (GCreasePoint)this.members.elementAt(i);
                this.bounds = GUtil.union(this.bounds, point.getBounds());
            }
            ++i;
        }
        if (this.bounds != null) {
            i = 0;
            while (i < this.members.size()) {
                Point2D.Double innerPos;
                if (this.members.elementAt(i) instanceof GFramed) {
                    gframed = (GFramed)this.members.elementAt(i);
                    innerPos = (Point2D.Double)this.innerPositions.elementAt(i);
                    Rectangle2D.Double frameBounds = gframed.getFrameBounds();
                    innerPos.x = frameBounds.x - this.bounds.x;
                    innerPos.y = frameBounds.y - this.bounds.y;
                } else if (this.members.elementAt(i) instanceof GCreasePoint) {
                    point = (GCreasePoint)this.members.elementAt(i);
                    innerPos = (Point2D.Double)this.innerPositions.elementAt(i);
                    Point2D.Double pos = point.getPosition();
                    innerPos.x = pos.x - this.bounds.x;
                    innerPos.y = pos.y - this.bounds.y;
                }
                ++i;
            }
        }
        if (this.bounds != null) {
            this.position = new Point2D.Double(this.bounds.x, this.bounds.y);
            this.size = new Point2D.Double(this.bounds.width, this.bounds.height);
        }
    }
}

