/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerShape;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFrameHandle;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GPointed;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentAlias;

public class GFramedContainer
extends GElementImpl
implements GContainer,
GContainerTarget,
GFramed {
    private boolean isHighlighted = false;
    private String name = "";
    private Point2D.Double position = null;
    private Point2D.Double size = new Point2D.Double(0.0, 0.0);
    private GFramedShape framedShape = null;
    private Rectangle2D.Double bounds = null;
    private GFrameHandle[] handles = new GFrameHandle[4];
    private Vector contains = new Vector();
    private GContainer container = null;
    private Point2D.Double innerPosition = null;
    private boolean isHighlightedAsContainerTarget = false;
    private Rectangle2D.Double midRect = new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0);
    protected Rectangle2D.Double maxArea = null;

    public Rectangle2D.Double getMaxArea() {
        if (this.maxArea == null) {
            return null;
        }
        return (Rectangle2D.Double)this.maxArea.clone();
    }

    public void setMaxArea(Dimension newdimension) {
        if (newdimension == null) {
            return;
        }
        Rectangle2D.Double newarea = new Rectangle2D.Double(0.0, 0.0, newdimension.width, newdimension.height);
        this.setMaxArea(newarea);
    }

    public void setMaxArea(Rectangle2D.Double area) {
        this.maxArea = area == null ? null : (Rectangle2D.Double)area.clone();
    }

    public GFramedContainer() {
        this.handles[0] = new GFrameHandle(this);
        this.handles[1] = new GFrameHandle(this);
        this.handles[2] = new GFrameHandle(this);
        this.handles[3] = new GFrameHandle(this);
        this.handles[0].setLocation(1);
        this.handles[1].setLocation(2);
        this.handles[2].setLocation(3);
        this.handles[3].setLocation(4);
    }

    @Override
    public void activateHandle(boolean active) {
        this.handles[0].setActive(active);
        this.handles[1].setActive(active);
        this.handles[2].setActive(active);
        this.handles[3].setActive(active);
    }

    @Override
    public void addTarget(GContainerTarget gcontainertarget) {
        this.contains.add(gcontainertarget);
    }

    protected static int checkIncludes(GContainerShape gcontainershape, GFramed gframed) {
        GFramedShape gframedshape;
        if (gcontainershape == null) {
            return 0;
        }
        if (gframed instanceof GBasicAtom) {
            if (((GBasicAtom)gframed).getCurrentView() == 1) {
                return 0;
            }
            gframedshape = ((GAtom)gframed).getGFramedShape();
        } else if (gframed instanceof GContainableAtom) {
            gframedshape = ((GAtom)gframed).getGFramedShape();
        } else if (gframed instanceof GFramedContainer) {
            gframedshape = ((GFramedContainer)gframed).getGFramedShape();
        } else {
            return 0;
        }
        if (gframedshape == null) {
            return 0;
        }
        Point2D.Double[] edgePoints = gframedshape.getEdgePoints();
        if (edgePoints == null) {
            return 0;
        }
        int nInside = 0;
        int nMembrane = 0;
        int nOutside = 0;
        int j = 0;
        while (j < edgePoints.length) {
            Point2D.Double point = edgePoints[j];
            if (gcontainershape.inInsideOfEdge(point.x, point.y)) {
                ++nInside;
            } else if (gcontainershape.inOutsideOfEdge(point.x, point.y)) {
                ++nMembrane;
            } else {
                ++nOutside;
            }
            ++j;
        }
        if (gframed instanceof GAtom) {
            if (nInside == 0 && nMembrane == 0 && nOutside > 0) {
                return 0;
            }
            if (nInside > 0 && nMembrane == 0 && nOutside == 0) {
                return 4;
            }
            if (nInside == 0 && nMembrane > 0 && nOutside > 0) {
                return 1;
            }
            if (nInside > 0 && nMembrane > 0 && nOutside == 0) {
                return 3;
            }
            if (nInside > 0 && nOutside > 0) {
                return 2;
            }
            if (nInside == 0 && nMembrane > 0 && nOutside == 0) {
                return 5;
            }
            return 0;
        }
        if (nOutside == 0) {
            return 4;
        }
        return 0;
    }

    @Override
    public void clearTargets() {
        this.contains.clear();
    }

    @Override
    public int containizedSize() {
        return this.contains.size();
    }

    @Override
    public GElement createCopy() {
        GFramedContainer copy;
        try {
            copy = (GFramedContainer)this.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        if (this.framedShape != null) {
            try {
                copy.setGFramedShape(this.framedShape.createCopy());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.position != null) {
            copy.setFramePosition(this.position.x, this.position.y);
        }
        if (this.size != null) {
            copy.setFrameSize(this.size.x, this.size.y);
        }
        int i = 0;
        while (i < this.contains.size()) {
            GElement gelement = (GElement)this.contains.elementAt(i);
            GContainerTarget gcontainertarget = (GContainerTarget)((Object)gelement.createCopy());
            GStructure.setContainerTarget(copy, gcontainertarget);
            ++i;
        }
        copy.update();
        return copy;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (this.framedShape != null) {
            int state = 1;
            if (this.isHighlighted) {
                state = 2;
            } else if (this.isHighlightedAsContainerTarget) {
                state = 3;
            }
            this.framedShape.drawShape(graphics2d, state);
            if (this.isHighlighted) {
                this.handles[0].draw(graphics2d);
                this.handles[1].draw(graphics2d);
                this.handles[2].draw(graphics2d);
                this.handles[3].draw(graphics2d);
                graphics2d.setColor(GColor.editAssistFG);
                graphics2d.fill(this.midRect);
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public GContainer getContainer() {
        return this.container;
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return new Rectangle2D.Double(this.position.x, this.position.y, this.size.x, this.size.y);
    }

    @Override
    public Point2D.Double getFramePosition() {
        return this.position;
    }

    @Override
    public Point2D.Double getFrameSize() {
        return this.size;
    }

    public GFramedShape getGFramedShape() {
        return this.framedShape;
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        if (this.handles[0].getRect().contains(x, y)) {
            return this.handles[0];
        }
        if (this.handles[1].getRect().contains(x, y)) {
            return this.handles[1];
        }
        if (this.handles[2].getRect().contains(x, y)) {
            return this.handles[2];
        }
        if (this.handles[3].getRect().contains(x, y)) {
            return this.handles[3];
        }
        return null;
    }

    @Override
    public Point2D.Double getInnerPosition() {
        return this.innerPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.getBounds();
    }

    @Override
    public Vector getTargets() {
        return (Vector)this.contains.clone();
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.framedShape == null) {
            return false;
        }
        return this.framedShape.inShape(x, y);
    }

    @Override
    public boolean onEdge(double x, double y) {
        if (this.framedShape == null) {
            return false;
        }
        return ((GContainerShape)((Object)this.framedShape)).onEdge(x, y);
    }

    @Override
    public int includes(GContainerTarget gcontainertarget) {
        if (!this.isContainable(gcontainertarget)) {
            return 0;
        }
        return GFramedContainer.checkIncludes((GContainerShape)((Object)this.framedShape), (GFramed)((Object)gcontainertarget));
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        if (this instanceof LayerCompartmentAlias) {
            return this.getBounds().intersects(selectArea);
        }
        return false;
    }

    @Override
    public boolean isContainable(GContainerTarget gcontainertarget) {
        if (gcontainertarget instanceof GFramed) {
            if (gcontainertarget instanceof GBasicAtom) {
                return ((GBasicAtom)gcontainertarget).getCurrentView() != 1;
            }
            return true;
        }
        if (gcontainertarget instanceof GPointed) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isContainerOf(GContainerTarget gcontainertarget) {
        int i = 0;
        while (i < this.contains.size()) {
            Object object = this.contains.elementAt(i);
            if (object == gcontainertarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public boolean isHighlightedAsTarget() {
        return this.isHighlightedAsContainerTarget;
    }

    @Override
    public void removeTarget(GContainerTarget gcontainertarget) {
        this.contains.remove(gcontainertarget);
    }

    @Override
    public void setContainer(GContainer gcontainer) {
        this.container = gcontainer;
    }

    @Override
    public void setFramePosition(double x, double y) {
        if (this.position == null) {
            this.position = new Point2D.Double(x, y);
        } else {
            this.position.x = x;
            this.position.y = y;
        }
    }

    @Override
    public void setFrameSize(double width, double height) {
        this.size.x = width;
        this.size.y = height;
    }

    public void setGFramedShape(GFramedShape gframedshape) throws Exception {
        if (!(gframedshape instanceof GContainerShape)) {
            throw new Exception("framedShape must also to be GContainerShape");
        }
        this.framedShape = gframedshape;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        this.isHighlighted = highlighted;
    }

    @Override
    public void setHighlightedAsTarget(boolean highlight) {
        this.isHighlightedAsContainerTarget = highlight;
    }

    @Override
    public void setInnerPosition(Point2D.Double position) {
        this.innerPosition = position;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Rectangle2D update() {
        if (this.position == null || this.framedShape == null) {
            return null;
        }
        Rectangle2D.Double old_rect = this.bounds;
        this.bounds = this.framedShape.updateShape(this.position.x, this.position.y, this.size.x, this.size.y);
        this.handles[0].updateRect();
        this.handles[1].updateRect();
        this.handles[2].updateRect();
        this.handles[3].updateRect();
        this.midRect.x = this.position.x + this.size.x / 2.0 - this.midRect.width / 2.0;
        this.midRect.y = this.position.y + this.size.y / 2.0 - this.midRect.height / 2.0;
        if (old_rect == null) {
            return this.bounds;
        }
        return GUtil.union(old_rect, this.bounds);
    }
}

