/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GUtil;

public class GEditPoint
extends GElementImpl {
    protected static final double RECT_SIZE = 8.0;
    private GEditable owner = null;
    private boolean isActive = false;
    private Point2D.Double position = null;
    private Point2D.Double localPosition = null;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private Rectangle2D.Double rect = null;

    @Override
    public GElement createCopy() {
        return null;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (this.isActive && this.rect != null) {
            Color org_color = graphics2d.getColor();
            graphics2d.setColor(GColor.EDITPOINTS_COLOR);
            graphics2d.fill(this.rect);
            graphics2d.setColor(org_color);
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.rect;
    }

    public Point2D.Double getLocalPosition() {
        return this.localPosition;
    }

    @Override
    public String getName() {
        return "";
    }

    public GEditable getOwner() {
        return this.owner;
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.rect;
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.rect == null) {
            return false;
        }
        return this.rect.contains(x, y);
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        if (this.rect == null) {
            return false;
        }
        return this.rect.intersects(selectArea);
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isHighlighted() {
        return false;
    }

    public void setActive(boolean flag) {
        this.isActive = flag;
    }

    @Override
    public void setHighlighted(boolean flag) {
    }

    public void setLocalPosition(Point2D.Double localPosition) {
        this.localPosition = localPosition;
    }

    @Override
    public void setName(String name) {
    }

    public void setOwner(GEditable owner) {
        this.owner = owner;
    }

    public void setPosition(Point2D.Double position) {
        this.position = position;
    }

    public void setVisualOffset(double x, double y) {
    }

    @Override
    public Rectangle2D update() {
        if (this.position == null) {
            return null;
        }
        Rectangle2D oldBounds = null;
        if (this.rect != null) {
            oldBounds = (Rectangle2D)this.rect.clone();
        } else {
            this.rect = new Rectangle2D.Double(0.0, 0.0, 8.0, 8.0);
        }
        this.rect.x = this.position.x - 4.0 + this.offsetX;
        this.rect.y = this.position.y - 4.0 + this.offsetY;
        if (oldBounds == null) {
            return (Rectangle2D)this.rect.clone();
        }
        if (oldBounds.equals(this.rect)) {
            return null;
        }
        return GUtil.union(oldBounds, this.rect);
    }

    public final void restrictMoveVector(Point2D.Double dxdy, GEditPoint another) {
        this.owner.restrictEditPointMoveVector(this, another, dxdy);
    }

    public void appendMovingPointAndPosition(Vector startXYVec) {
        this.owner.appendMovingPointAndPosition(this, startXYVec);
    }

    public void appendAdditionalMovingPointAndPosition(Vector startXYVec) {
        this.owner.appendAdditionalMovingPointAndPosition(this, startXYVec);
    }

    public Vector setMovedElementPosition(double dx, double dy, Vector startXYVec) {
        return this.owner.setMovedElementPosition(dx, dy, startXYVec);
    }
}

