/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GAtomImpl;
import jp.fric.graphics.draw.GBasicAtom;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFrameHandle;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SpeciesShape;

public class GContainableAtom
extends GAtomImpl
implements GContainer {
    private Vector contains = new Vector();
    protected InformationBox infoBox = new InformationBox(this);

    public GContainableAtom() {
        int i = 0;
        while (i < 4) {
            this.handles[i] = new GFrameHandle(this);
            this.handles[i].setLocation(i + 1);
            ++i;
        }
    }

    @Override
    public GContainer getContainer() {
        return this.container;
    }

    @Override
    public boolean isHighlightedAsTarget() {
        return this.isHighlightedAsContainerTarget;
    }

    @Override
    public void setContainer(GContainer container) {
        if (this.container != null && container != null) {
            if (this.container != container) {
                this.container.removeTarget(this);
                this.container = container;
                return;
            }
        } else {
            if (this.container != null && container == null) {
                this.container.removeTarget(this);
                this.container = container;
                return;
            }
            if (this.container == null && container != null) {
                this.container = container;
                return;
            }
        }
        this.container = container;
    }

    @Override
    public void setHighlightedAsTarget(boolean val) {
        this.isHighlightedAsContainerTarget = val;
    }

    @Override
    public Object clone() {
        GContainableAtom copy = (GContainableAtom)super.clone();
        if (copy == null) {
            return null;
        }
        int i = 0;
        while (i < this.contains.size()) {
            GElement gelement = (GElement)this.contains.elementAt(i);
            GContainerTarget gcontainertarget = (GContainerTarget)((Object)gelement.createCopy());
            GStructure.setContainerTarget(copy, gcontainertarget);
            if (gcontainertarget instanceof ComplexSpeciesAlias && (this.getCurrentView() == 1 || this.getCurrentView() == 3)) {
                ((ComplexSpeciesAlias)gcontainertarget).currentView = 3;
            }
            ++i;
        }
        copy.update();
        return copy;
    }

    @Override
    public GElement createCopy() {
        return (GElement)this.clone();
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (this.framedShape != null) {
            if (this.container != null && this.container instanceof ComplexSpeciesAlias && (((ComplexSpeciesAlias)this.container).getCurrentView() == 1 || ((ComplexSpeciesAlias)this.container).getCurrentView() == 3)) {
                return;
            }
            int state = 1;
            if (this.isHighlighted) {
                state = 2;
            } else if (this.isHighlightedAsContainerTarget) {
                state = 3;
            }
            if (!(this instanceof ComplexSpeciesAlias) || this.getCurrentView() != 2) {
                ComplexSpeciesAlias csa;
                boolean drawFlg = true;
                GContainer gc = this.getContainer();
                if (gc != null && gc instanceof ComplexSpeciesAlias && ((csa = (ComplexSpeciesAlias)gc).getCurrentView() == 1 || csa.getCurrentView() == 3)) {
                    drawFlg = false;
                }
                if (!(this.framedShape instanceof MonoSpeciesShape)) {
                    this.framedShape.drawShape(graphics2d, state);
                } else {
                    ((MonoSpeciesShape)this.framedShape).drawShape(graphics2d, state, drawFlg);
                }
            }
            if (this.isHighlighted) {
                this.handles[0].draw(graphics2d);
                this.handles[1].draw(graphics2d);
                this.handles[2].draw(graphics2d);
                this.handles[3].draw(graphics2d);
                graphics2d.setColor(GColor.editAssistFG);
                graphics2d.fill(this.midRect);
            }
            if (this.infoBox != null) {
                this.infoBox.draw(graphics2d);
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.getBounds();
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.framedShape == null) {
            return false;
        }
        return this.framedShape.inShape(x, y);
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        if (this.bounds == null) {
            return false;
        }
        if (this instanceof ComplexSpeciesAlias) {
            SpeciesShape shape = (SpeciesShape)((Object)this.getGFramedShape());
            return ((MonoSpeciesShape)shape).getFrameBounds().intersects(selectArea);
        }
        return this.bounds.intersects(selectArea);
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public void setHighlighted(boolean val) {
        this.isHighlighted = val;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return new Rectangle2D.Double(this.position.x, this.position.y, this.size.x, this.size.y);
    }

    @Override
    public void activateHandle(boolean active) {
        int i = 0;
        while (i < 4) {
            this.handles[i].setActive(active);
            ++i;
        }
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        if (this.getCurrentView() != 0 && this.getCurrentView() != 1 && this.getCurrentView() != 2) {
            return null;
        }
        if (this.handles[0].getRect().contains(x, y)) {
            return this.handles[0];
        }
        if (this.handles[1].getRect().contains(x, y)) {
            return this.handles[1];
        }
        if (this.handles[2].getRect().contains(x, y)) {
            return this.handles[2];
        }
        if (this.handles[3].getRect().contains(x, y)) {
            return this.handles[3];
        }
        return null;
    }

    @Override
    public Rectangle2D.Double getBoundsAsTarget() {
        return this.getBounds();
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        if (this.framedShape == null) {
            return false;
        }
        return this.framedShape.inShape(x, y);
    }

    @Override
    public Point2D.Double targetPoint() {
        if (this.position == null) {
            return null;
        }
        return new Point2D.Double(this.position.x + this.size.x / 2.0, this.position.y + this.size.y / 2.0);
    }

    @Override
    public void addTarget(GContainerTarget gcontainertarget) {
        if (this.isContainable(gcontainertarget)) {
            this.contains.add(gcontainertarget);
        }
    }

    @Override
    public void clearTargets() {
        this.contains.clear();
    }

    @Override
    public int containizedSize() {
        return this.contains.size();
    }

    @Override
    public Vector getTargets() {
        return (Vector)this.contains.clone();
    }

    @Override
    public int includes(GContainerTarget gcontainertarget) {
        if (!this.isContainable(gcontainertarget)) {
            return 0;
        }
        return this.checkIncludes(this.framedShape, (GFramed)((Object)gcontainertarget));
    }

    protected int checkIncludes(GFramedShape gframedshape, GFramed gframed) {
        GFramedShape atomshape;
        if (gframedshape == null) {
            return 0;
        }
        if (gframed instanceof GBasicAtom) {
            if (this instanceof ComplexSpeciesAlias && this.currentView == 2 ? ((GAtom)gframed).getCurrentView() != 0 : this.currentView != ((GAtom)gframed).getCurrentView()) {
                return 0;
            }
            atomshape = ((GAtom)gframed).getGFramedShape();
        } else if (gframed instanceof ComplexSpeciesAlias) {
            if (this.currentView == 1 && ((GAtom)gframed).getCurrentView() != 1) {
                return 0;
            }
            if (this.currentView == 3 || this.currentView == 1) {
                return 0;
            }
            if (this.getFrameBounds().x == gframed.getFrameBounds().x && this.getFrameBounds().y == gframed.getFrameBounds().y && this.getFrameBounds().width == gframed.getFrameBounds().width && this.getFrameBounds().height == gframed.getFrameBounds().height) {
                return 0;
            }
            atomshape = ((GAtom)gframed).getGFramedShape();
        } else {
            return 0;
        }
        if (atomshape == null) {
            return 0;
        }
        Point2D.Double[] edgePoints = atomshape.getEdgePoints();
        if (edgePoints == null) {
            return 0;
        }
        int nInside = 0;
        int nOutside = 0;
        int j = 0;
        while (j < edgePoints.length) {
            Point2D.Double point = edgePoints[j];
            if (gframedshape.inShape(point.x, point.y)) {
                ++nInside;
            } else {
                ++nOutside;
            }
            ++j;
        }
        if (nOutside == 0) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean isContainable(GContainerTarget gcontainertarget) {
        if (gcontainertarget instanceof GBasicAtom) {
            return true;
        }
        return gcontainertarget instanceof ComplexSpeciesAlias;
    }

    @Override
    public boolean isContainerOf(GContainerTarget gcontainertarget) {
        int i = 0;
        while (i < this.contains.size()) {
            Object object = this.contains.elementAt(i);
            if (object == gcontainertarget) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void removeTarget(GContainerTarget gcontainertarget) {
        this.contains.remove(gcontainertarget);
    }

    @Override
    public void changeView() {
        super.changeView();
        if (this.contains == null || this.contains.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.contains.size()) {
            ((GAtom)this.contains.get(i)).changeView();
            ++i;
        }
    }

    @Override
    public Rectangle2D update() {
        Rectangle2D redrawArea = super.update();
        if (this.currentView != 1) {
            return redrawArea;
        }
        Rectangle2D redrawFromSuper = redrawArea;
        redrawArea = GUtil.union(redrawArea, this.updateChildren());
        if (redrawFromSuper == null) {
            return null;
        }
        return redrawArea;
    }

    private Rectangle2D updateChildren() {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.contains.size()) {
            GFramed gframed = (GFramed)this.contains.elementAt(i);
            Rectangle2D redrawArea2 = ((GElement)((Object)gframed)).update();
            if (redrawArea2 == null) {
                return null;
            }
            redrawArea = GUtil.union(redrawArea, redrawArea2);
            if (gframed instanceof GContainableAtom) {
                redrawArea = GUtil.union(redrawArea, ((GContainableAtom)gframed).updateChildren());
            }
            ++i;
        }
        return redrawArea;
    }

    private Rectangle2D update2Children() {
        Rectangle2D.Double redrawArea = null;
        int i = 0;
        while (i < this.contains.size()) {
            GFramed gframed = (GFramed)this.contains.elementAt(i);
            Point2D.Double point = ((GContainerTarget)((Object)gframed)).getInnerPosition();
            gframed.setFramePosition(this.position.x + ((Point2D)point).getX(), this.position.y + ((Point2D)point).getY());
            Rectangle2D redrawArea2 = ((GElement)((Object)gframed)).update();
            if (redrawArea2 == null) {
                return null;
            }
            redrawArea = GUtil.union(redrawArea, redrawArea2);
            if (gframed instanceof GContainableAtom) {
                redrawArea = GUtil.union(redrawArea, ((GContainableAtom)gframed).update2Children());
            }
            ++i;
        }
        return redrawArea;
    }

    public Rectangle2D update2() {
        Rectangle2D redrawArea;
        Rectangle2D redrawFromSuper = redrawArea = super.update();
        redrawArea = GUtil.union(redrawArea, this.update2Children());
        if (redrawFromSuper == null) {
            return null;
        }
        return redrawArea;
    }
}

