/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.fric.graphics.draw.GAtomImpl;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GContainableAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFrameHandle;
import jp.fric.graphics.draw.GResizeHandle;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;

public class GBasicAtom
extends GAtomImpl {
    protected InformationBox infoBox = new InformationBox(this);

    public GBasicAtom() {
        int i = 0;
        while (i < 4) {
            this.handles[i] = new GFrameHandle(this);
            this.handles[i].setLocation(i + 1);
            ++i;
        }
    }

    @Override
    public void activateHandle(boolean val) {
        int i = 0;
        while (i < 4) {
            this.handles[i].setActive(val);
            ++i;
        }
    }

    @Override
    public GElement createCopy() {
        return (GElement)this.clone();
    }

    @Override
    public Object clone() {
        GBasicAtom copy = (GBasicAtom)super.clone();
        if (copy == null) {
            return null;
        }
        copy.update();
        if (copy instanceof LayerSpeciesAlias) {
            LayerSpeciesAlias copyAlias = (LayerSpeciesAlias)copy;
            LayerSpeciesAlias thisAlias = (LayerSpeciesAlias)this;
            copyAlias.setTargetAlias(thisAlias.getTargetAlias());
            copyAlias.setText(thisAlias.getText());
            LayerMonoSpeciesShape mono = (LayerMonoSpeciesShape)copyAlias.getGFramedShape();
            LayerSpeciesSymbol symbol = mono.getSpeciesSymbol();
            symbol.setFontColor(((LayerMonoSpeciesShape)thisAlias.getGFramedShape()).getSpeciesSymbol().getFontColor());
        }
        return copy;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        if (this.framedShape != null) {
            if (this.container != null && this.container instanceof ComplexSpeciesAlias) {
                if (((ComplexSpeciesAlias)this.container).getCurrentView() == 1 || ((ComplexSpeciesAlias)this.container).getCurrentView() == 3) {
                    return;
                }
                if (((ComplexSpeciesAlias)this.container).getCurrentView() != 1 && ((ComplexSpeciesAlias)this.container).getCurrentView() != 3) {
                    this.changeView(new Integer(0));
                }
            }
            int state = 1;
            if (this.isHighlighted) {
                state = 2;
            } else if (this.isHighlightedAsContainerTarget) {
                state = 3;
            }
            this.framedShape.drawShape(graphics2d, state);
            if (this.isHighlighted) {
                this.handles[0].draw(graphics2d);
                this.handles[1].draw(graphics2d);
                this.handles[2].draw(graphics2d);
                this.handles[3].draw(graphics2d);
                graphics2d.setColor(GColor.editAssistFG);
                graphics2d.fill(this.midRect);
            }
            if (this.infoBox != null) {
                this.infoBox.draw(graphics2d);
            }
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return (Rectangle2D.Double)this.bounds.clone();
    }

    @Override
    public Rectangle2D.Double getBoundsAsTarget() {
        return this.getBounds();
    }

    @Override
    public GContainer getContainer() {
        return this.container;
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return new Rectangle2D.Double(this.position.x, this.position.y, this.size.x, this.size.y);
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        if (this.handles[0].getRect().contains(x, y)) {
            return this.handles[0];
        }
        if (this.handles[1].getRect().contains(x, y)) {
            return this.handles[1];
        }
        if (this.handles[2].getRect().contains(x, y)) {
            return this.handles[2];
        }
        if (this.handles[3].getRect().contains(x, y)) {
            return this.handles[3];
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        return this.getBounds();
    }

    @Override
    public boolean inShape(double x, double y) {
        if (this.framedShape == null) {
            return false;
        }
        return this.framedShape.inShape(x, y);
    }

    @Override
    public boolean inShapeAsTarget(double x, double y) {
        if (this.framedShape != null) {
            return this.framedShape.inShape(x, y);
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        if (this.bounds == null) {
            return false;
        }
        if (this.getContainer() instanceof GContainableAtom) {
            return false;
        }
        if (this instanceof ElementSpeciesAlias) {
            SpeciesShape shape = (SpeciesShape)((Object)this.getGFramedShape());
            return ((MonoSpeciesShape)shape).getFrameBounds().intersects(selectArea);
        }
        return this.bounds.intersects(selectArea);
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public boolean isHighlightedAsTarget() {
        return this.isHighlightedAsContainerTarget;
    }

    @Override
    public void setContainer(GContainer gcontainer) {
        this.container = gcontainer;
    }

    @Override
    public void setHighlighted(boolean val) {
        this.isHighlighted = val;
    }

    @Override
    public void setHighlightedAsTarget(boolean val) {
        this.isHighlightedAsContainerTarget = val;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point2D.Double targetPoint() {
        if (this.position == null) {
            return null;
        }
        return new Point2D.Double(this.position.x + this.size.x / 2.0, this.position.y + this.size.y / 2.0);
    }
}

