/*
 * Decompiled with CFR 0.152.
 */
package jp.fric.graphics.draw;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jp.fric.graphics.draw.GAtom;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFrameHandle;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class GAtomImpl
extends GElementImpl
implements GAtom {
    protected GFrameHandle[] handles = new GFrameHandle[4];
    protected GContainer container = null;
    protected Point2D.Double innerPosition = null;
    protected boolean isHighlightedAsContainerTarget = false;
    protected Point2D.Double position = null;
    protected Point2D.Double size = new Point2D.Double(0.0, 0.0);
    protected GFramedShape framedShape = null;
    protected boolean isHighlighted = false;
    protected Rectangle2D.Double midRect = new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0);
    protected Rectangle2D.Double bounds = null;
    protected String name = "";
    protected int currentView = 0;
    private static HashSet viewSet = null;
    private HashMap sizeReservoir = new HashMap();
    private HashMap innerPositionReservoir = new HashMap();
    private Vector<Object> vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
    private Vector<Object> vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
    public static final String DefaultCompartmentNameOfAutoCreatedDummyObject = "default";
    private boolean isAutoCreatedDummyObject = false;

    static {
        viewSet = new HashSet();
        viewSet.add(new Integer(0));
        viewSet.add(new Integer(1));
    }

    public boolean isAutoCreatedDummyObject() {
        return this.isAutoCreatedDummyObject;
    }

    public void setAutoCreatedDummyObjectFlg(boolean val) {
        this.isAutoCreatedDummyObject = val;
    }

    public GAtomImpl() {
        for (Integer key : viewSet) {
            this.sizeReservoir.put(key, new Point2D.Double(0.0, 0.0));
            this.innerPositionReservoir.put(key, new Point2D.Double(0.0, 0.0));
        }
    }

    public Object clone() {
        GAtom copy = null;
        try {
            copy = (GAtom)this.getClass().newInstance();
            if (copy instanceof GAtomImpl) {
                ((GAtomImpl)copy).setAutoCreatedDummyObjectFlg(this.isAutoCreatedDummyObject);
            }
        }
        catch (Exception exception) {
            return copy;
        }
        if (this.framedShape != null) {
            copy.setGFramedShape(this.framedShape.createCopy());
        }
        if (this.position != null) {
            copy.setFramePosition(this.position.x, this.position.y);
        }
        this.copyReservoirsTo((GAtomImpl)copy);
        if (this instanceof ComplexSpeciesAlias) {
            int tempView = this.currentView;
            if (tempView == 3) {
                tempView = 1;
            }
            ((ComplexSpeciesAlias)copy).changeComplexView(new Integer(tempView));
            return (ComplexSpeciesAlias)copy;
        }
        if (!(this instanceof ElementSpeciesAlias)) {
            copy.changeView(new Integer(this.currentView));
        }
        return copy;
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.getGFramedShape().showLinkAnchors(lpi, drawOnlyActive);
    }

    @Override
    public void hideLinkAnchors() {
        this.getGFramedShape().hideLinkAnchors();
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        return this.getGFramedShape().getPointedLinkPosition(x, y);
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        return this.getGFramedShape().getCoordinatesOfLinkPosition(lpi);
    }

    @Override
    public GFramedShape getGFramedShape() {
        return this.framedShape;
    }

    @Override
    public void setGFramedShape(GFramedShape framedShape) {
        this.framedShape = framedShape;
    }

    @Override
    public int getCurrentView() {
        return this.currentView;
    }

    @Override
    public String getCurrentViewString() {
        return this.getViewString(this.currentView);
    }

    @Override
    public String getViewString(int view) {
        switch (view) {
            case 0: {
                return "usual";
            }
            case 1: {
                return "brief";
            }
            case 2: {
                return "complexnoborder";
            }
            case 3: {
                return "complexparentbrief";
            }
        }
        return "none";
    }

    @Override
    public int getViewConstant(String viewString) {
        if (viewString.equals("usual")) {
            return 0;
        }
        if (viewString.equals("brief")) {
            return 1;
        }
        if (viewString.equals("complexnoborder")) {
            return 2;
        }
        if (viewString.equals("complexparentbrief")) {
            return 3;
        }
        return -1;
    }

    @Override
    public void changeView(Integer viewint) {
        this.currentView = viewint;
        if (this.currentView == 2) {
            this.size = (Point2D.Double)this.sizeReservoir.get(new Integer(0));
            this.innerPosition = (Point2D.Double)this.innerPositionReservoir.get(new Integer(0));
            return;
        }
        this.size = (Point2D.Double)this.sizeReservoir.get(viewint);
        this.innerPosition = (Point2D.Double)this.innerPositionReservoir.get(viewint);
    }

    @Override
    public void changeView() {
        Iterator it = viewSet.iterator();
        while (it.hasNext()) {
            Integer tmpInt = (Integer)it.next();
            if (tmpInt == this.currentView) break;
        }
        if (!it.hasNext()) {
            it = viewSet.iterator();
        }
        Integer key = (Integer)it.next();
        this.changeView(key);
    }

    @Override
    public Point2D.Double getFramePosition() {
        return this.position;
    }

    @Override
    public Point2D.Double getFrameSize() {
        return this.size;
    }

    @Override
    public Point2D.Double getFrameSize(int view) {
        return (Point2D.Double)this.sizeReservoir.get(new Integer(view));
    }

    @Override
    public void setFramePosition(double x, double y) {
        if (this.position == null) {
            this.position = new Point2D.Double(x, y);
        } else {
            this.position.x = x;
            this.position.y = y;
        }
    }

    @Override
    public void setFrameSize(double width, double height) {
        this.size.x = width;
        this.size.y = height;
        this.sizeReservoir.put(new Integer(this.currentView), this.size);
    }

    @Override
    public void setFrameSize(int view, double width, double height) {
        Point2D.Double stored = (Point2D.Double)this.sizeReservoir.get(new Integer(view));
        if (stored == null || stored.x != width || stored.y != height) {
            this.sizeReservoir.put(new Integer(view), new Point2D.Double(width, height));
        }
    }

    @Override
    public Rectangle2D update() {
        if (this.position == null || this.framedShape == null) {
            return null;
        }
        Rectangle2D.Double old_rect = this.bounds;
        this.bounds = this.framedShape.updateShape(this.position.x, this.position.y, this.size.x, this.size.y);
        this.handles[0].updateRect();
        this.handles[1].updateRect();
        this.handles[2].updateRect();
        this.handles[3].updateRect();
        this.midRect.x = this.position.x + (this.size.x - this.midRect.width) / 2.0;
        this.midRect.y = this.position.y + (this.size.y - this.midRect.height) / 2.0;
        if (old_rect == null) {
            return this.bounds;
        }
        if (old_rect.equals(this.bounds)) {
            return null;
        }
        return GUtil.union(old_rect, this.bounds);
    }

    @Override
    public Point2D.Double getInnerPosition() {
        return this.innerPosition;
    }

    @Override
    public void setInnerPosition(Point2D.Double innerPosition) {
        this.innerPosition = innerPosition;
        this.innerPositionReservoir.put(new Integer(this.currentView), innerPosition);
        if (this instanceof ComplexSpeciesAlias && innerPosition != null && this.currentView == 2) {
            this.setInnerPosition(0, innerPosition);
        }
    }

    @Override
    public Point2D.Double getInnerPosition(int view) {
        return (Point2D.Double)this.innerPositionReservoir.get(new Integer(view));
    }

    @Override
    public void setInnerPosition(int view, Point2D.Double innerPos) {
        Point2D.Double stored = (Point2D.Double)this.innerPositionReservoir.get(new Integer(view));
        if (stored == null || stored.x != innerPos.x || stored.y != innerPos.y) {
            this.innerPositionReservoir.put(new Integer(view), new Point2D.Double(innerPos.x, innerPos.y));
        }
    }

    private void copyReservoirsTo(GAtomImpl copy) {
        for (Integer key : this.sizeReservoir.keySet()) {
            Point2D.Double tmpSize = (Point2D.Double)this.sizeReservoir.get(key);
            copy.sizeReservoir.put(key, new Point2D.Double(tmpSize.x, tmpSize.y));
        }
        for (Integer key : this.innerPositionReservoir.keySet()) {
            Point2D.Double tmpInnerPos = (Point2D.Double)this.innerPositionReservoir.get(key);
            if (tmpInnerPos == null) {
                copy.innerPositionReservoir.put(key, null);
                continue;
            }
            copy.innerPositionReservoir.put(key, new Point2D.Double(tmpInnerPos.x, tmpInnerPos.y));
        }
    }

    public void addTempTagAlias(Object alias) {
        if (this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree == null) {
            this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
        }
        if (alias == null) {
            return;
        }
        this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree.addElement(alias);
    }

    public void removeTempTagAlias(Object alias) {
        if (this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree == null) {
            this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
        }
        if (alias == null) {
            return;
        }
        this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree.removeElement(alias);
    }

    public Vector getVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree() {
        if (this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree == null) {
            this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
        }
        return this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree;
    }

    public void clearVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree() {
        this.vectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
    }

    public void addTempTagLink(Object link) {
        if (this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree == null) {
            this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
        }
        if (link == null) {
            return;
        }
        this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree.addElement(link);
    }

    public void removeTempTagLink(Object link) {
        if (this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree == null) {
            this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
        }
        if (link == null) {
            return;
        }
        this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree.removeElement(link);
    }

    public Vector getVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree() {
        if (this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree == null) {
            this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
        }
        return this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree;
    }

    public void clearVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree() {
        this.vectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree = new Vector();
    }

    protected static void appendXMLTagOfTagLink(StringBuffer buf, Vector vTagLinks) {
        if (vTagLinks == null || vTagLinks.size() <= 0) {
            return;
        }
        if (buf == null) {
            buf = new StringBuffer();
        }
        buf.append("<celldesigner:listOfSpeciesTag>\n");
        int i = 0;
        while (i < vTagLinks.size()) {
            block5: {
                LayerReactionLink linkTag = null;
                LayerSpeciesAlias aliasTag = null;
                LayerMonoSpeciesShape monoTagShape = null;
                Rectangle2D.Double boundsTag = null;
                LayerTagSymbol tag = null;
                try {
                    linkTag = (LayerReactionLink)vTagLinks.get(i);
                    aliasTag = (LayerSpeciesAlias)linkTag.getTargetAt(0);
                    monoTagShape = (LayerMonoSpeciesShape)aliasTag.getGFramedShape();
                    boundsTag = monoTagShape.getFrameBounds();
                    tag = (LayerTagSymbol)monoTagShape.getSpeciesSymbol();
                }
                catch (Exception myErr) {
                    break block5;
                }
                buf.append("<celldesigner:SpeciesTag>\n");
                buf.append("<celldesigner:KeyInfo name=\"" + aliasTag.getText() + "\" " + "direct" + "=\"" + tag.getTagDirect() + "\"/>\n");
                buf.append("<celldesigner:TagBounds x=\"" + boundsTag.x + "\" y=\"" + boundsTag.y + "\" w=\"" + boundsTag.width + "\" h=\"" + boundsTag.height + "\"/>\n");
                buf.append("<celldesigner:TagEdgeLine width=\"" + monoTagShape.getSpeciesShapePainting().getLineWidth() + "\"/>\n");
                buf.append("<celldesigner:TagFramePaint color=\"" + Integer.toHexString(monoTagShape.getSpeciesShapePainting().getColor().getRGB()) + "\" scheme=\"" + monoTagShape.getSpeciesShapePainting().getPaintScheme().getCode() + "\"/>\n");
                buf.append("</celldesigner:SpeciesTag>\n");
            }
            ++i;
        }
        buf.append("</celldesigner:listOfSpeciesTag>\n");
    }

    protected void readSubXmlNodeOfDOMTreeFromAppVer4(GAtomImpl alias, NodeList childlist) {
        try {
            if (alias == null) {
                throw new Exception();
            }
            if (childlist == null) {
                throw new Exception();
            }
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                String localName;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && (localName = node.getLocalName()).equals("listOfSpeciesTag")) {
                    NodeList nodelistTagList = node.getChildNodes();
                    if (nodelistTagList != null && nodelistTagList.getLength() > 0) {
                        int j = 0;
                        while (j < nodelistTagList.getLength()) {
                            Node nodeTag = nodelistTagList.item(j);
                            NodeList nodeTagPropertyList = nodeTag.getChildNodes();
                            if (nodeTagPropertyList != null && nodeTagPropertyList.getLength() > 0) {
                                String temp = "";
                                String sid = "";
                                String name = "";
                                String direct = "";
                                double x = 0.0;
                                double y = 0.0;
                                double w = 0.0;
                                double h = 0.0;
                                double framelinewidth = 1.0;
                                String str_color = "";
                                String str_scheme = "";
                                int k = 0;
                                while (k < nodeTagPropertyList.getLength()) {
                                    Node nodeTagProperty = nodeTagPropertyList.item(k);
                                    if (nodeTagProperty.getNodeType() == 1 && nodeTagProperty.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                                        String localPropertyName = nodeTagProperty.getLocalName();
                                        if (localPropertyName.equals("KeyInfo")) {
                                            name = ((Element)nodeTagProperty).getAttributeNS(null, "name");
                                            direct = ((Element)nodeTagProperty).getAttributeNS(null, "direct");
                                        } else if (localPropertyName.equals("TagBounds")) {
                                            temp = ((Element)nodeTagProperty).getAttributeNS(null, "x");
                                            x = Double.parseDouble(temp);
                                            temp = ((Element)nodeTagProperty).getAttributeNS(null, "y");
                                            y = Double.parseDouble(temp);
                                            temp = ((Element)nodeTagProperty).getAttributeNS(null, "w");
                                            w = Double.parseDouble(temp);
                                            temp = ((Element)nodeTagProperty).getAttributeNS(null, "h");
                                            h = Double.parseDouble(temp);
                                        } else if (localPropertyName.equals("TagEdgeLine")) {
                                            temp = ((Element)nodeTagProperty).getAttributeNS(null, "width");
                                            framelinewidth = Double.parseDouble(temp);
                                        } else if (localPropertyName.equals("TagFramePaint")) {
                                            str_color = ((Element)nodeTagProperty).getAttributeNS(null, "color");
                                            str_scheme = ((Element)nodeTagProperty).getAttributeNS(null, "scheme");
                                        }
                                    }
                                    ++k;
                                }
                                LayerMonoSpeciesShape mono = new LayerMonoSpeciesShape("TAG");
                                mono.setLineWidth(framelinewidth);
                                LayerSpeciesAlias tag = new LayerSpeciesAlias();
                                tag.setGFramedShape(mono);
                                tag.setFramePosition(x, y);
                                tag.setFrameSize(w, h);
                                tag.setSid(sid);
                                tag.setName(name);
                                tag.setText(name);
                                tag.setTargetAlias(alias);
                                tag.setBelong_layer_id(-99);
                                tag.update();
                                LayerTagSymbol tagSymbol = (LayerTagSymbol)mono.getSpeciesSymbol();
                                tagSymbol.resetSymbolBounds(x, y, w, h, direct);
                                long l = Long.parseLong(str_color, 16);
                                mono.setColor(new Color((int)l, true));
                                mono.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme));
                                alias.addTempTagAlias(tag);
                                SBSymbol rSymbol = SBFactory.createSymbol("TAG_LINE");
                                int iS = ((LayerTagFreeLineSymbol)rSymbol).sourceSize();
                                int iT = ((LayerTagFreeLineSymbol)rSymbol).destinationSize();
                                LayerReactionLink taglink = new LayerReactionLink(iS, iT);
                                taglink.setSymbol(rSymbol);
                                GLinkPositionInfo linkPosition = new GLinkPositionInfo(4, 0.0);
                                GLinkPositionInfo posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
                                if (direct.equals("UP")) {
                                    linkPosition = new GLinkPositionInfo(8, 0.0);
                                    posinfTargetTmp = new GLinkPositionInfo(0, 0.0);
                                } else if (direct.equals("DOWN")) {
                                    linkPosition = new GLinkPositionInfo(0, 0.0);
                                    posinfTargetTmp = new GLinkPositionInfo(8, 0.0);
                                } else if (direct.equals("RIGHT")) {
                                    linkPosition = new GLinkPositionInfo(12, 0.0);
                                    posinfTargetTmp = new GLinkPositionInfo(4, 0.0);
                                } else if (direct.equals("LEFT")) {
                                    linkPosition = new GLinkPositionInfo(4, 0.0);
                                    posinfTargetTmp = new GLinkPositionInfo(12, 0.0);
                                }
                                taglink.setTargetAt((GLinkTarget)tag, 0, posinfTargetTmp);
                                taglink.setTargetAt((GLinkTarget)alias, 1, linkPosition);
                                taglink.setBelong_layer_id(-99);
                                alias.addTempTagLink(taglink);
                            }
                            ++j;
                        }
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception myErr) {
            alias.clearVectTagAliasUsingOnlyWhenBuidTagByReadFromDOMTree();
            alias.clearVectTagLinkUsingOnlyWhenBuidTagByReadFromDOMTree();
        }
    }
}

