/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.viewparts;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jp.co.mki.celldesigner.simulation.util.StringTool;

public class ColoredTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private boolean editStatus;
    private String tabName;

    public ColoredTableCellRenderer(String tabName, boolean editStatus) {
        this.editStatus = editStatus;
        this.tabName = tabName;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object val, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean RED = false;
        boolean GREEN = false;
        int BLUE = 120;
        int ALPHA = 25;
        if (((String)val).indexOf(",", 0) != -1) {
            val = StringTool.replaceString((String)val, ",", "");
        }
        this.setText((String)val);
        if (!this.editStatus) {
            if (isSelected) {
                this.setForeground(Color.WHITE);
                this.setBackground(Color.BLUE);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(Color.WHITE);
            }
        } else if (isSelected) {
            this.setForeground(Color.WHITE);
            this.setBackground(Color.BLUE);
        } else {
            this.setForeground(Color.BLACK);
            this.setBackground(new Color(0, 0, 120, 25));
        }
        boolean isNumeric = false;
        try {
            Double.parseDouble((String)val);
            isNumeric = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tabName.equals("Species")) {
            if (isNumeric) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        } else if (this.tabName.equals("Parameters")) {
            if (isNumeric) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        } else if (this.tabName.equals("ParameterScan")) {
            if (isNumeric) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        }
        this.validate();
        return this;
    }
}

