/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class StringTool {
    private static final int defaultDecimalPlace = 14;
    private static DecimalFormat decimalPlaceFormat = new DecimalFormat();

    public static String convertNumberFormat(byte value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(short value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(int value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(long value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(float value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(double value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(String value) {
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(Object value) {
        if (value instanceof String) {
            return StringTool.convertNumberFormat((String)value);
        }
        return StringTool.convertNumberFormat(value, 14);
    }

    public static String convertNumberFormat(byte value, int decimalPlace) {
        decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
        return StringTool.convertNumberFormat((Object)new Long(value), decimalPlaceFormat);
    }

    public static String convertNumberFormat(short value, int decimalPlace) {
        decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
        return StringTool.convertNumberFormat((Object)new Long(value), decimalPlaceFormat);
    }

    public static String convertNumberFormat(int value, int decimalPlace) {
        decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
        return StringTool.convertNumberFormat((Object)new Long(value), decimalPlaceFormat);
    }

    public static String convertNumberFormat(long value, int decimalPlace) {
        decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
        return StringTool.convertNumberFormat((Object)new Long(value), decimalPlaceFormat);
    }

    public static String convertNumberFormat(float value, int decimalPlace) {
        decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
        return StringTool.convertNumberFormat((Object)new Double(value), decimalPlaceFormat);
    }

    public static String convertNumberFormat(double value, int decimalPlace) {
        decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
        return StringTool.convertNumberFormat((Object)new Double(value), decimalPlaceFormat);
    }

    public static String convertNumberFormat(String value, int decimalPlace) {
        try {
            if (value.equals("NaN")) {
                return Double.toString(Double.NaN);
            }
            if (value.indexOf(",", 0) != -1) {
                value = StringTool.replaceString(value, ",", "");
            }
            decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
            return decimalPlaceFormat.format(Double.valueOf(value));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String convertNumberFormat(Object value, int decimalPlace) {
        try {
            decimalPlaceFormat.setMaximumFractionDigits(decimalPlace);
            return StringTool.convertNumberFormat(value, decimalPlaceFormat);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String convertNumberFormat(Object value, DecimalFormat decimalPlaceFormat) {
        try {
            String returnValue;
            Double valueS = (Double)value;
            if (valueS.toString().equals("NaN")) {
                return Double.toString(Double.NaN);
            }
            if (valueS.toString().indexOf(",", 0) != -1) {
                String s = StringTool.replaceString(valueS.toString(), ",", "");
                valueS = new Double(s);
            }
            if ((returnValue = decimalPlaceFormat.format(valueS)).indexOf(",", 0) != -1) {
                return StringTool.replaceString(returnValue, ",", "");
            }
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String replaceString(String orgStr, String oldStr, String newStr) {
        if (orgStr == null || orgStr.length() == 0) {
            return " ";
        }
        String partString = null;
        StringBuffer sBuff = new StringBuffer("");
        int i = 0;
        int offset = orgStr.indexOf(oldStr);
        if (offset == -1) {
            partString = new String(orgStr);
            return partString;
        }
        int len = orgStr.length();
        i = 0;
        while (i < len) {
            partString = orgStr.substring(i, offset);
            sBuff.append(partString);
            sBuff.append(newStr);
            i = offset + oldStr.length();
            offset = orgStr.indexOf(oldStr, i);
            if (offset == -1) break;
        }
        partString = orgStr.substring(i, len);
        sBuff.append(partString);
        orgStr = null;
        oldStr = null;
        newStr = null;
        partString = null;
        return sBuff.toString();
    }

    public static double round(double a, int n) {
        BigDecimal bg = new BigDecimal(a);
        String v = String.valueOf(bg.setScale(n, 6));
        return new Double(v);
    }

    public static int getScale(double a) {
        String s = String.valueOf(a);
        int scale = 0;
        if (s.indexOf("E") != -1) {
            String sc = s.substring(s.indexOf("E") + 1, s.length());
            scale = Math.abs(Integer.parseInt(sc));
        } else if (s.indexOf(".") != -1) {
            scale = s.length() - 1 - s.indexOf(".");
            if (s.substring(s.length() - 1, s.length()).equals("0")) {
                --scale;
            }
        }
        return scale;
    }

    public static int getScale(double a, double b) {
        int bi;
        int ai = StringTool.getScale(a);
        if (ai > (bi = StringTool.getScale(b))) {
            return ai;
        }
        if (ai < bi) {
            return bi;
        }
        return ai;
    }

    public static String substitute(String input, String pattern, String replacement) {
        int index = input.indexOf(pattern);
        if (index == -1) {
            return input;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(input.substring(0, index)) + replacement);
        if (index + pattern.length() < input.length()) {
            String rest = input.substring(index + pattern.length(), input.length());
            buffer.append(StringTool.substitute(rest, pattern, replacement));
        }
        return buffer.toString();
    }

    public static String toEscape(String input) {
        input = StringTool.substitute(input, "&", "&amp;");
        input = StringTool.substitute(input, "<", "&lt;");
        input = StringTool.substitute(input, ">", "&gt;");
        input = StringTool.substitute(input, "\"", "&quot;");
        return input;
    }

    public static String toNonEscape(String input) {
        input = StringTool.substitute(input, "&amp;", "&");
        input = StringTool.substitute(input, "&lt;", "<");
        input = StringTool.substitute(input, "&gt;", ">");
        input = StringTool.substitute(input, "&quot;", "\"");
        return input;
    }

    public static String insertString(String strOrginal, String strIn, int intCount) {
        if (strOrginal.length() <= intCount) {
            return String.valueOf(strOrginal) + strIn;
        }
        if (intCount == 0) {
            return String.valueOf(strIn) + strOrginal;
        }
        StringBuffer sbEdit = new StringBuffer("");
        int intLen = strOrginal.length();
        int intStart = 0;
        int intEnd = intCount;
        boolean flg = false;
        while (intEnd < intLen) {
            if (!flg) {
                sbEdit.append(strOrginal.substring(intStart, intEnd)).append(strIn);
            } else {
                sbEdit.append(strOrginal.substring(intStart, intEnd));
            }
            intStart += intCount;
            intEnd += intCount;
            flg = true;
        }
        sbEdit.append(strOrginal.substring(intStart));
        return sbEdit.toString();
    }
}

