/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.Preference;

public class SimulationProperties {
    private static SimulationProperties simulationProperties = null;
    private HashMap map = new HashMap();
    private static final String filePath = String.valueOf(Preference.prefDirPath) + System.getProperty("file.separator") + "simulation-" + Preference.cdVersion + ".properties";
    public static final String simDirPath = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "CellDesignerSim";

    private SimulationProperties() throws IOException, FileNotFoundException {
        boolean status;
        File dir = new File(simDirPath);
        if (!dir.isDirectory() && !(status = dir.mkdirs())) {
            JOptionPane.showOptionDialog(MainWindow.getLastInstance(), "Can't make directory " + simDirPath + ". Please check the directory permission.", "Can't make directory" + simDirPath, -1, 0, null, new Object[]{"OK"}, "Close");
            System.exit(1);
        }
        if (!new File(filePath).exists()) {
            SimulationProperties.createSimulationProperties(filePath);
        }
        BufferedReader br = new BufferedReader(new FileReader(filePath));
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer token = new StringTokenizer(line, "\t");
            if (token.countTokens() != 2) continue;
            String key = token.nextToken();
            String value = token.nextToken();
            this.map.put(key, value);
        }
    }

    public static synchronized SimulationProperties getInstance() {
        try {
            if (simulationProperties == null) {
                simulationProperties = new SimulationProperties();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return simulationProperties;
    }

    public String getInitParameter(String key) {
        return (String)this.map.get(key);
    }

    public static void createSimulationProperties(String outputPath) {
        if (!new File(outputPath).exists()) {
            try {
                OutputStreamWriter otw = new OutputStreamWriter(new FileOutputStream(outputPath));
                otw.write("#propertie file for simulation.\n");
                otw.write("#\n");
                otw.write("input_path\t" + simDirPath + System.getProperty("file.separator") + "input\n");
                otw.write("result_path\t" + simDirPath + System.getProperty("file.separator") + "result\n");
                otw.write("input_file_name\tinput.xml\n");
                otw.write("result_file_name\tresult.txt\n");
                otw.write("result_image_file_name\tresult_image.jpg\n");
                otw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

