/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SimulationCheck {
    public static final int CHECK_TYPE_INTEGER = 1;
    public static final int CHECK_TYPE_DOUBLE = 2;
    public static final int CHECK_TYPE_BOOLEAN = 3;

    public static boolean isBecomeToInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static boolean isBecomeToDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static int checkTableDataStorage(JPanel parent, String[][] table, int col, int rowSize, int checkType) {
        switch (checkType) {
            case 1: {
                int i = 0;
                while (i < rowSize) {
                    if (!SimulationCheck.isBecomeToInteger(table[i][col])) {
                        return i;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < rowSize) {
                    if (!SimulationCheck.isBecomeToDouble(table[i][col])) {
                        return i;
                    }
                    ++i;
                }
                break;
            }
        }
        return -1;
    }

    public static boolean checkExponentValue(Component parent, String[] tblDataStorage, int i, String value) {
        String sComp = tblDataStorage[i];
        if (sComp == null) {
            return true;
        }
        if (sComp.indexOf("E") != -1) {
            String bigExponent = "E" + sComp.split("E")[1];
            int result = value.indexOf(bigExponent, value.length() - bigExponent.length());
            if (result == -1) {
                JOptionPane.showMessageDialog(parent, "The thing to change the value of Exponent cannot be done.", "WARN", 0);
                return false;
            }
            return true;
        }
        if (sComp.indexOf("e") != -1) {
            String smallExponent = "e" + sComp.split("e")[1];
            int result = value.indexOf(smallExponent, value.length() - smallExponent.length());
            if (result == -1) {
                JOptionPane.showMessageDialog(parent, "The thing to change the value of Exponent cannot be done.", "WARN", 0);
                return false;
            }
            return true;
        }
        return true;
    }
}

