/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JProgressBar;

public class MyProgressBar
extends JProgressBar {
    private int drawStart = 0;
    private int direction = RIGHT;
    private int drawWidth = 30;
    private int drawInterval = 10;
    private String drawString;
    private boolean active = false;
    private static int RIGHT = 0;
    private static int LEFT = 1;

    public MyProgressBar(int min, int max) {
        super(min, max);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 8, 8);
        g.setColor(Color.GRAY);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
        if (!this.active) {
            return;
        }
        g.setColor(Color.CYAN);
        if (this.direction == RIGHT) {
            if (this.drawStart + this.drawWidth < this.getWidth()) {
                this.drawStart += this.drawInterval;
            } else {
                this.direction = LEFT;
            }
        } else if (this.direction == LEFT) {
            if (this.drawStart - this.drawInterval >= 0) {
                this.drawStart -= this.drawInterval;
            } else {
                this.direction = RIGHT;
            }
        }
        g.fillRoundRect(this.drawStart, 0, this.drawWidth, this.getHeight(), 4, 4);
        g.setColor(Color.GRAY);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
        g.setColor(Color.BLACK);
        g.drawString(this.drawString, this.getWidth() / 3 - 5, 13);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDrawWidth() {
        return this.drawWidth;
    }

    public void setDrawWidth(int drawWidth) {
        this.drawWidth = drawWidth;
    }

    public int getDrawStart() {
        return this.drawStart;
    }

    public void setDrawStart(int drawStart) {
        this.drawStart = drawStart;
    }

    public int getDrawInterval() {
        return this.drawInterval;
    }

    public void setDrawInterval(int drawInterval) {
        this.drawInterval = drawInterval;
    }

    public String getDrawString() {
        return this.drawString;
    }

    public void setDrawString(String drawString) {
        this.drawString = drawString;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

