/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.JAI;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jp.co.mki.celldesigner.simulation.util.ExtensionFileFilter;

public class ImageStore {
    private static String chooserPath = null;
    public static String BMP = "BMP";
    public static String JPEG = "JPEG";
    public static String PNG = "PNG";
    public static String TIFF = "TIFF";
    public static String PNM = "PNM";
    private static String DEFAULT_FORMAT = "JPEG";
    private static String BMP_EXTENSION = "bmp";
    private static String JPEG_EXTENSION = "jpg";
    private static String PNG_EXTENSION = "png";
    private static String TIFF_EXTENSION = "tif";
    private static String PNM_EXTENSION = "pnm";
    private static String DEFAULT_EXTENSION = "jpg";

    public void storeImage(Component c) {
        if (chooserPath == null) {
            chooserPath = "";
        }
        JFileChooser fileChooser = new JFileChooser(chooserPath);
        fileChooser.setDialogTitle("Save Image");
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter();
        bmpFilter.addExtension("bmp");
        bmpFilter.setDescription("BMP files(*.bmp)");
        fileChooser.addChoosableFileFilter(bmpFilter);
        ExtensionFileFilter pngFilter = new ExtensionFileFilter();
        pngFilter.addExtension("png");
        pngFilter.setDescription("PNG files(*.png)");
        fileChooser.addChoosableFileFilter(pngFilter);
        ExtensionFileFilter tiffFilter = new ExtensionFileFilter();
        tiffFilter.addExtension("tif");
        tiffFilter.setDescription("TIFF files(*.tif)");
        fileChooser.addChoosableFileFilter(tiffFilter);
        ExtensionFileFilter pnmFilter = new ExtensionFileFilter();
        pnmFilter.addExtension("pnm");
        pnmFilter.setDescription("PNM files(*.pnm)");
        fileChooser.addChoosableFileFilter(pnmFilter);
        ExtensionFileFilter jpegFilter = new ExtensionFileFilter();
        jpegFilter.addExtension("jpg");
        jpegFilter.setDescription("JPEG files(*.jpg)");
        fileChooser.addChoosableFileFilter(jpegFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        while (fileChooser.showSaveDialog(c) == 0) {
            String path;
            chooserPath = path = fileChooser.getSelectedFile().getAbsolutePath();
            String format = null;
            FileFilter selectedFilter = fileChooser.getFileFilter();
            if (selectedFilter.equals(bmpFilter)) {
                path = ImageStore.makePath(path, BMP_EXTENSION);
                format = BMP;
            } else if (selectedFilter.equals(jpegFilter)) {
                path = ImageStore.makePath(path, JPEG_EXTENSION);
                format = JPEG;
            } else if (selectedFilter.equals(pngFilter)) {
                path = ImageStore.makePath(path, PNG_EXTENSION);
                format = PNG;
            } else if (selectedFilter.equals(tiffFilter)) {
                path = ImageStore.makePath(path, TIFF_EXTENSION);
                format = TIFF;
            } else if (selectedFilter.equals(pnmFilter)) {
                path = ImageStore.makePath(path, PNM_EXTENSION);
                format = PNM;
            } else {
                String extension = ImageStore.getExtensionFromPath(path);
                format = ImageStore.getFormatFromExtension(extension);
                path = ImageStore.makePath(path, extension);
            }
            if (new File(path).exists() && JOptionPane.showConfirmDialog(c, "\"" + path + "\" already exists. Do you overwrite?", "overwrite?", 0) == 1) continue;
            ImageStore.storeImage(c, path, format);
            break;
        }
    }

    public static void storeImage(Component c, String path, String format) {
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 4);
        Graphics g = image.getGraphics();
        c.paintAll(g);
        JAI.create((String)"FileStore", (RenderedImage)image, (Object)path, (Object)format);
        System.gc();
    }

    private static String makePath(String path, String extension) {
        File filename = new File(path);
        if (filename.exists()) {
            return path;
        }
        return String.valueOf(path) + "." + extension;
    }

    private static String getFormatFromPath(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1 || index + 1 >= path.length()) {
            return DEFAULT_FORMAT;
        }
        String extension = path.substring(index + 1, path.length()).toLowerCase();
        if (extension.equals(BMP_EXTENSION)) {
            return BMP;
        }
        if (extension.equals(JPEG_EXTENSION)) {
            return JPEG;
        }
        if (extension.equals(PNG_EXTENSION)) {
            return PNG;
        }
        if (extension.equals(TIFF_EXTENSION)) {
            return TIFF;
        }
        if (extension.equals(PNM_EXTENSION)) {
            return PNM;
        }
        return DEFAULT_FORMAT;
    }

    private static String getFormatFromExtension(String extension) {
        if (extension.equals(BMP_EXTENSION)) {
            return BMP;
        }
        if (extension.equals(JPEG_EXTENSION)) {
            return JPEG;
        }
        if (extension.equals(PNG_EXTENSION)) {
            return PNG;
        }
        if (extension.equals(TIFF_EXTENSION)) {
            return TIFF;
        }
        if (extension.equals(PNM_EXTENSION)) {
            return PNM;
        }
        if (extension.equals(DEFAULT_EXTENSION)) {
            return DEFAULT_FORMAT;
        }
        return null;
    }

    private static String getExtensionFromPath(String path) {
        int index = path.lastIndexOf(".");
        if (index == -1 || index + 1 >= path.length()) {
            return DEFAULT_EXTENSION;
        }
        String extension = path.substring(index + 1, path.length()).toLowerCase();
        if (extension.equals(BMP_EXTENSION) || extension.equals(JPEG_EXTENSION) || extension.equals(PNG_EXTENSION) || extension.equals(TIFF_EXTENSION) || extension.equals(PNM_EXTENSION)) {
            return extension;
        }
        return DEFAULT_EXTENSION;
    }

    private static String getExtensionFromFormat(String format) {
        if (format.equals(BMP)) {
            return BMP_EXTENSION;
        }
        if (format.equals(JPEG)) {
            return JPEG_EXTENSION;
        }
        if (format.equals(PNG)) {
            return PNG_EXTENSION;
        }
        if (format.equals(TIFF)) {
            return TIFF_EXTENSION;
        }
        if (format.equals(PNM)) {
            return PNM_EXTENSION;
        }
        if (format.equals(DEFAULT_FORMAT)) {
            return DEFAULT_EXTENSION;
        }
        return null;
    }
}

