/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import jp.co.mki.celldesigner.simulation.util.CommandThread;

public final class ExecuteCommand {
    private String m_command = null;
    private boolean m_wait = false;
    private long m_timeout = 0L;
    private boolean m_out = false;
    private String m_message = null;
    private String m_errorMessage = null;
    private int m_exitValue = -1;
    public static final int COMPLETE = 0;
    public static final int ERROR = 1;
    public static final int TIME_OUT = 4;

    public String getCommand() {
        return this.m_command;
    }

    public boolean getWait() {
        return this.m_wait;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public boolean getOut() {
        return this.m_out;
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public int getExitValue() {
        return this.m_exitValue;
    }

    public void setCommand(String cmd) {
        this.m_command = cmd;
    }

    public ExecuteCommand() {
    }

    public ExecuteCommand(boolean wait, boolean out) {
        this();
        this.m_wait = wait;
        this.m_out = out;
    }

    public ExecuteCommand(boolean wait, boolean out, long timeout) {
        this();
        this.m_wait = wait;
        this.m_out = out;
        this.m_timeout = timeout;
    }

    public int execute(boolean wait) {
        this.m_wait = wait;
        return this.execute();
    }

    public int execute(boolean out, boolean wait) {
        this.m_out = out;
        this.m_wait = wait;
        return this.execute();
    }

    public int execute(String cmd, boolean out, boolean wait) {
        this.m_out = out;
        this.m_wait = wait;
        this.m_command = cmd;
        return this.execute();
    }

    public int execute(String cmd) {
        this.m_command = cmd;
        return this.execute();
    }

    private int execute() {
        int result = 1;
        if (this.m_command == null || this.m_command.length() < 1) {
            result = 0;
        } else {
            try {
                CommandThread thread = new CommandThread(this.m_command, this.m_out);
                thread.start();
                if (this.m_wait) {
                    thread.join(this.m_timeout);
                    if (thread.isAlive()) {
                        result = 4;
                        thread.destroy();
                    } else {
                        result = 0;
                        if (this.m_out) {
                            this.m_message = thread.getStandardOutput();
                            this.m_errorMessage = thread.getStandardErrorOutput();
                            this.m_exitValue = thread.getExitValue();
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        return result;
    }
}

