/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.co.mki.celldesigner.simulation.util.InnerThread;
import jp.co.mki.celldesigner.simulation.util.SystemInfo;

public class CommandThread
extends Thread {
    private String m_command;
    private String m_standardOutput;
    private String m_standardErrorOutput;
    private boolean m_getOutput;
    private int m_exitValue;
    private Process process;
    private boolean flag;

    public CommandThread(String command, boolean getOutput) {
        this.m_command = command;
        this.m_standardOutput = null;
        this.m_standardErrorOutput = null;
        this.m_getOutput = getOutput;
        this.m_exitValue = 4;
        this.process = null;
        this.flag = true;
    }

    @Override
    public void run() {
        try {
            this.process = Runtime.getRuntime().exec(this.m_command);
            InputStream is = this.process.getInputStream();
            InnerThread th = new InnerThread(is);
            th.start();
            if (this.flag) {
                if (this.m_getOutput) {
                    this.m_standardOutput = this.getStringFromInputStream(this.process.getInputStream());
                    this.m_standardErrorOutput = this.getStringFromInputStream(this.process.getErrorStream());
                }
                this.m_exitValue = this.process.exitValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.flag = false;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public String getCommand() {
        return this.m_command;
    }

    public String getStandardOutput() {
        return this.m_standardOutput;
    }

    public String getStandardErrorOutput() {
        return this.m_standardErrorOutput;
    }

    public int getExitValue() {
        return this.m_exitValue;
    }

    public void setCommand(String string) {
        this.m_command = string;
    }

    private String getStringFromInputStream(InputStream is) throws Exception {
        StringBuffer sb = new StringBuffer();
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        boolean flag = false;
        while ((line = br.readLine()) != null) {
            if (flag) {
                sb.append(SystemInfo.getLineSepalator());
            }
            sb.append(line);
            flag = true;
        }
        return sb.toString();
    }
}

