/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.sedml.util;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.controlpanel.ChangeAmount;
import jp.co.mki.celldesigner.simulation.controlpanel.ErrorTolerance;
import jp.co.mki.celldesigner.simulation.controlpanel.InteractiveSimulation;
import jp.co.mki.celldesigner.simulation.controlpanel.ParameterScan;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationInfo;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SliderValue;
import jp.co.mki.celldesigner.simulation.controlpanel.Solver;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesColorSet;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesVisible;
import jp.co.mki.celldesigner.simulation.controlpanel.TimeSpan;
import jp.co.mki.celldesigner.simulation.jlibsedml.util.CreateSedml;
import jp.co.mki.celldesigner.simulation.sedml.databean.SEDBase;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAttribute;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlCurve;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlDataGenerator;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlGraphInfo;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlInteractiveSimulation;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlModel;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPaint;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPlot2D;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimCondition;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSliderValue;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlTask;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlUniformTimeCourse;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlVariable;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Species;
import org.sedml.SEDMLDocument;
import org.sedml.SedML;
import org.sedml.SedMLError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmlUtil {
    public static final int iCurrLevel = 1;
    public static final int iCurrVersion = 1;
    private static final int iMaxNumbersOfTabInPrintString = 20;
    public static final String strNameSpacePerfix = "xmlns";
    public static final String strSchemaLocationPerfix = "schemaLocation";
    public static final String strLevelPerfix = "level";
    public static final String strVersionPerfix = "version";
    public static final String strCelldExtXmlnsPrefix = "celldesigner";
    public static final String strCelldExtXmlns = "celldesigner:extension";
    public static final String strExtXmlns = "extension";
    public static final String strCelldXmlns = "xmlns:celldesigner";
    public static final String strNotesNameSpace = "http://www.w3.org/1999/xhtml";
    public static final String strCelldNameSpace = "http://www.sbml.org/2001/ns/celldesigner";
    public static final String strCelldMath = "http://www.w3.org/1998/Math/MathML";

    public static void main(String[] argv) {
        try {
            File sourceFileB = new File("C:\\TestFile\\sedml_3.xml");
            File targetFileD = new File("C:\\TestFile\\sedmlOutputTest11.xml");
            SmlSimCondition conditionC = SmlUtil.getValueFromXmlFile(sourceFileB);
            SmlUtil.savetoXmlFile(targetFileD, conditionC);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            return;
        }
    }

    public static final SmlSimCondition getValueFromXmlFile(File sourceFile) throws Exception {
        SmlSimCondition rtnSedml = new SmlSimCondition();
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            if (sourceFile == null) {
                throw new Exception();
            }
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(sourceFile);
            if (doc == null) {
                throw new Exception();
            }
            Element root = doc.getDocumentElement();
            if (root instanceof Node) {
                Debug.outputDebugMessage("f", "******************** Print [node] starting ... ********************", 0);
                SmlUtil.quickviewerNode(root);
                Debug.outputDebugMessage("f", "******************** Print [node] End.         ********************", 0);
            }
            SmlSimCondition.setValueByReadingDOMTree(rtnSedml, root);
            String validate = SmlUtil.RunValidate(rtnSedml);
            if (validate != null) {
                JOptionPane.showMessageDialog(null, validate);
                throw new Exception(validate);
            }
        }
        catch (Exception myErr) {
            rtnSedml = null;
            throw new Exception("Can not read your file.");
        }
        return rtnSedml;
    }

    public static final void savetoXmlFile(File targetFile, SmlSimCondition smlSimCondition) throws Exception {
        try {
            SedML sedml = CreateSedml.createPersistenceSedmlData(smlSimCondition);
            SEDMLDocument sdoc = new SEDMLDocument(sedml);
            sdoc.validate();
            StringBuffer bufOutput = new StringBuffer();
            for (SedMLError error : sdoc.getErrors()) {
                bufOutput.append(error.toString());
                bufOutput.append("\r\n");
            }
            if (!bufOutput.toString().equals("")) {
                JOptionPane.showMessageDialog(null, bufOutput.toString());
                throw new Exception(bufOutput.toString());
            }
            sdoc.writeDocument(targetFile);
        }
        catch (Exception myErr) {
            throw new Exception("Can not write your file.");
        }
    }

    public static final void setListValueByReadingDOMTree(ArrayList<Object> listTarget, Element sourcedoc) throws Exception {
        SmlUtil.setListValueByReadingDOMTree(listTarget, sourcedoc, null);
    }

    public static final void setListValueByReadingDOMTree(ArrayList<Object> listTarget, Element sourcedoc, String parentTag) throws Exception {
        NodeList childlist2 = sourcedoc.getChildNodes();
        int childsize2 = childlist2.getLength();
        if (childsize2 <= 0) {
            return;
        }
        int j = 0;
        while (j < childsize2) {
            Node node2 = childlist2.item(j);
            if (node2.getNodeType() == 1) {
                SEDBase onerow;
                Element elem2 = (Element)node2;
                String nodename2 = node2.getNodeName();
                if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "uniformTimeCourse")) {
                    onerow = new SmlUniformTimeCourse();
                    SmlUniformTimeCourse.readingDOMTree(onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "model")) {
                    onerow = new SmlModel();
                    SmlModel.readingDOMTree((SmlModel)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "task")) {
                    onerow = new SmlTask();
                    SmlTask.readingDOMTree((SmlTask)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "dataGenerator")) {
                    onerow = new SmlDataGenerator();
                    SmlDataGenerator.readingDOMTree((SmlDataGenerator)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "plot2D")) {
                    onerow = new SmlPlot2D();
                    SmlPlot2D.readingDOMTree((SmlPlot2D)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "curve")) {
                    onerow = new SmlCurve();
                    SmlCurve.readingDOMTree((SmlCurve)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "variable")) {
                    onerow = new SmlVariable();
                    SmlVariable.readingDOMTree((SmlVariable)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "changeAttribute")) {
                    onerow = new SmlChangeAttribute();
                    SmlChangeAttribute.readingDOMTree((SmlChangeAttribute)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:parameterscan")) {
                    onerow = new SmlSimParameterScan();
                    SmlSimParameterScan.readingDOMTree((SmlSimParameterScan)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:value") && parentTag != null && CelldUtil.issameIgnoreCaseIgnoreSpace(parentTag, "celldesigner:initialvalue")) {
                    onerow = new SmlSliderValue();
                    SmlSliderValue.readingDOMTree((SmlSliderValue)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:value") && parentTag != null && CelldUtil.issameIgnoreCaseIgnoreSpace(parentTag, "celldesigner:initialvalue")) {
                    onerow = new SmlSliderValue();
                    SmlSliderValue.readingDOMTree((SmlSliderValue)onerow, elem2);
                    listTarget.add(onerow);
                } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:value") && parentTag != null && CelldUtil.issameIgnoreCaseIgnoreSpace(parentTag, "celldesigner:valuelist")) {
                    onerow = new SmlAmount();
                    SmlAmount.readingDOMTree((SmlAmount)onerow, elem2);
                    listTarget.add(onerow);
                }
            }
            ++j;
        }
    }

    public static final void readNotSupportedAnnotationFromDOMTree(Element srcdoc, StringBuffer bufAnnotation) throws Exception {
        String nodename = srcdoc.getNodeName();
        if (!CelldUtil.issameIgnoreCaseIgnoreSpace(nodename, "annotation")) {
            bufAnnotation.append("<" + nodename);
            NamedNodeMap map = srcdoc.getAttributes();
            if (map.getLength() > 0) {
                Node node = map.item(0);
                bufAnnotation.append(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                int i = 1;
                while (i < map.getLength()) {
                    node = map.item(i);
                    bufAnnotation.append(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                    ++i;
                }
            }
            bufAnnotation.append(">\n");
        }
        NodeList children = srcdoc.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node pNode = children.item(j);
            if (pNode.getNodeType() == 1) {
                SmlUtil.readNotSupportedAnnotationFromDOMTree((Element)pNode, bufAnnotation);
            } else if (pNode.getNodeValue() != null && !pNode.getNodeValue().trim().equals("") && !pNode.getNodeValue().trim().equals("\n")) {
                bufAnnotation.append(pNode.getNodeValue().trim());
            }
            ++j;
        }
        if (!CelldUtil.issameIgnoreCaseIgnoreSpace(nodename, "annotation")) {
            bufAnnotation.append("</" + nodename + ">\n");
        }
    }

    public static final void quickviewerNode(Node node) {
        SmlUtil.quickviewerNode(node, 0);
    }

    private static final void quickviewerNode(Node node, int indent) {
        if (node == null) {
            Debug.outputDebugMessage("f", "There are nothing in [node].", 0);
        }
        String nodeName = node.getNodeName();
        String nodeValue = SmlUtil.getElementValue(node);
        NamedNodeMap attributes = node.getAttributes();
        Debug.outputDebugMessage("f", String.valueOf(SmlUtil.givePrefixSpaces(indent)) + "nodeName :[" + nodeName + "], nodeValue :[" + nodeValue + "]", 0);
        int iAttrLen = attributes.getLength();
        int i = 0;
        while (i < iAttrLen) {
            Node attribute = attributes.item(i);
            Debug.outputDebugMessage("f", String.valueOf(SmlUtil.givePrefixSpaces(indent + 3)) + "attrName :[" + attribute.getNodeName() + "], attrValue :[" + attribute.getNodeValue() + "]", 0);
            ++i;
        }
        NodeList kids = node.getChildNodes();
        int iKidsSize = kids.getLength();
        int i2 = 0;
        while (i2 < iKidsSize) {
            Node child = kids.item(i2);
            if (child.getNodeType() == 1) {
                SmlUtil.quickviewerNode(child, indent + 1);
            }
            ++i2;
        }
    }

    public static final String getElementValue(Node elem) {
        if (elem != null && elem.hasChildNodes()) {
            Node kid = elem.getFirstChild();
            while (kid != null) {
                if (kid.getNodeType() == 3) {
                    return kid.getNodeValue();
                }
                kid = kid.getNextSibling();
            }
        }
        return "";
    }

    private static final String givePrefixSpaces(int iTabIndex) {
        String strTabs = "";
        if (iTabIndex <= 0) {
            iTabIndex = 0;
        } else if (iTabIndex >= 20) {
            iTabIndex = 20;
        }
        int i = 0;
        while (i < iTabIndex) {
            strTabs = String.valueOf(strTabs) + "\t";
            ++i;
        }
        return strTabs;
    }

    public static final String getIdOfSmlChangeAttribute(SmlChangeAttribute smlChangeAttribute) {
        String target = smlChangeAttribute.getTarget();
        return target.substring(target.lastIndexOf("[@id='") + 6, target.lastIndexOf("']"));
    }

    public static final String getTypeOfSmlChangeAttribute(SmlChangeAttribute smlChangeAttribute) {
        String target = smlChangeAttribute.getTarget();
        return target.substring(target.lastIndexOf(":") + 1, target.lastIndexOf("["));
    }

    public static final String getItemTypeOfSmlChangeAttribute(SmlChangeAttribute smlChangeAttribute) {
        String target = smlChangeAttribute.getTarget();
        return target.substring(target.lastIndexOf("@") + 1, target.length());
    }

    public static final String getNewModelId(SmlSimCondition smlSimCondition) {
        ArrayList<Object> modelList = smlSimCondition.getListOfModels();
        String modelIdHeader = "m";
        String newModelId = null;
        int i = 1;
        while (true) {
            boolean generated = true;
            newModelId = String.valueOf(modelIdHeader) + String.valueOf(i);
            int j = 0;
            while (j < modelList.size()) {
                if (newModelId.equals(((SmlModel)modelList.get(j)).getId())) {
                    generated = false;
                    break;
                }
                ++j;
            }
            if (generated) break;
            ++i;
        }
        return newModelId;
    }

    public static final String getNewSimulationId(SmlSimCondition smlSimCondition) {
        ArrayList<Object> simulationList = smlSimCondition.getListOfSimulation();
        String simulationIdHeader = "s";
        String newSimulationId = null;
        int i = 1;
        while (true) {
            boolean generated = true;
            newSimulationId = String.valueOf(simulationIdHeader) + String.valueOf(i);
            int j = 0;
            while (j < simulationList.size()) {
                if (newSimulationId.equals(((SmlUniformTimeCourse)simulationList.get(j)).getId())) {
                    generated = false;
                }
                ++j;
            }
            if (generated) break;
            ++i;
        }
        return newSimulationId;
    }

    public static final String getNewTaskId(SmlSimCondition smlSimCondition) {
        ArrayList<Object> taskList = smlSimCondition.getListOfTasks();
        String taskIdHeader = "t";
        String newTaskId = null;
        int i = 1;
        while (true) {
            boolean generated = true;
            newTaskId = String.valueOf(taskIdHeader) + String.valueOf(i);
            int j = 0;
            while (j < taskList.size()) {
                if (newTaskId.equals(((SmlTask)taskList.get(j)).getId())) {
                    generated = false;
                }
                ++j;
            }
            if (generated) break;
            ++i;
        }
        return newTaskId;
    }

    public static final String getNewTaskName(SmlSimCondition smlSimCondition) {
        ArrayList<Object> taskList = smlSimCondition.getListOfTasks();
        String taskNameHeader = "expt";
        String newTaskName = null;
        int i = 1;
        while (true) {
            boolean generated = true;
            newTaskName = String.valueOf(taskNameHeader) + String.valueOf(i);
            int j = 0;
            while (j < taskList.size()) {
                if (newTaskName.equals(((SmlTask)taskList.get(j)).getName())) {
                    generated = false;
                }
                ++j;
            }
            if (generated) break;
            ++i;
        }
        return newTaskName;
    }

    public static final String getNewPlotId(SmlSimCondition smlSimCondition) {
        ArrayList<Object> plotList = smlSimCondition.getListOfOutputs();
        String plotIdHeader = "p";
        String newPlotId = null;
        int i = 1;
        while (true) {
            boolean generated = true;
            newPlotId = String.valueOf(plotIdHeader) + String.valueOf(i);
            int j = 0;
            while (j < plotList.size()) {
                if (newPlotId.equals(((SmlPlot2D)plotList.get(j)).getId())) {
                    generated = false;
                }
                ++j;
            }
            if (generated) break;
            ++i;
        }
        return newPlotId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean deleteDir(File dir) {
        try {
            if (dir.isDirectory()) {
                String[] children = dir.list();
                int i = 0;
                while (i < children.length) {
                    boolean success = SmlUtil.deleteDir(new File(dir, children[i]));
                    if (!success) {
                        return false;
                    }
                    ++i;
                }
            }
            return dir.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String SubString(String strObject1, String strObject2) {
        String strReturn = "";
        if (strObject1 == null || strObject2 == null) {
            return strObject1;
        }
        strReturn = strObject1.endsWith(strObject2) ? strObject1.substring(0, strObject1.length() - strObject2.length()) : strObject1;
        return strReturn;
    }

    public static final boolean updateSmlSimCondition(SmlSimCondition smlSimCondition, SmlTask smlTask, SimulationInfo simulationInfo, String modelName, String modelPath, ArrayList listOfResult, String path) {
        SmlPlot2D plot2d;
        int j;
        if (smlSimCondition == null) {
            smlSimCondition = new SmlSimCondition();
        }
        ArrayList<Object> taskList = smlSimCondition.getListOfTasks();
        ArrayList<Object> simulationList = smlSimCondition.getListOfSimulation();
        ArrayList<Object> modelList = smlSimCondition.getListOfModels();
        ArrayList<Object> dataGeneratorsList = smlSimCondition.getListOfDataGenerators();
        ArrayList<Object> outputList = smlSimCondition.getListOfOutputs();
        int indexOfTask = 0;
        indexOfTask = 0;
        while (indexOfTask < taskList.size()) {
            if (smlTask.getId().equals(((SmlTask)taskList.get(indexOfTask)).getId())) {
                taskList.remove(indexOfTask);
                break;
            }
            ++indexOfTask;
        }
        taskList.add(indexOfTask, smlTask);
        TimeSpan timeSpan = (TimeSpan)simulationInfo.getSimulationInfo(0);
        ChangeAmount changeAmount = (ChangeAmount)simulationInfo.getSimulationInfo(1);
        ParameterScan parameterScan = (ParameterScan)simulationInfo.getSimulationInfo(2);
        InteractiveSimulation interactiveSimulation = (InteractiveSimulation)simulationInfo.getSimulationInfo(3);
        ErrorTolerance errorTolerance = (ErrorTolerance)simulationInfo.getSimulationInfo(4);
        Solver solver = (Solver)simulationInfo.getSimulationInfo(5);
        ArrayList listOfOriginSpecies = simulationInfo.getListOfOriginSpecies();
        ArrayList listOfOriginReactions = simulationInfo.getListOfOriginReactions();
        ArrayList listOfOriginGlobalParameters = simulationInfo.getListOfOriginGlobalParameters();
        SBMLPanelLists sbmlPanelLists = simulationInfo.getSbmlPanelLists();
        ListOf listOfSpecies = sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        ListOf listOfReaction = sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        ListOf listOfParameters = sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        SmlUniformTimeCourse smlSimulation = new SmlUniformTimeCourse();
        smlSimulation.setId(smlTask.getSimulationReference());
        smlSimulation.setOutputEndTime(timeSpan.getSpan());
        String step = timeSpan.getStep();
        smlSimulation.setNumberOfPoints((int)Double.parseDouble(step));
        smlSimulation.setErrortolerance((int)Math.log10(Double.parseDouble(errorTolerance.getRelativeTolerance())));
        smlSimulation.setAlgorithm(solver.getSolverName());
        smlSimulation.setSolver(solver.getSolverName());
        int indexOfSimulation = 0;
        while (indexOfSimulation < simulationList.size()) {
            if (smlSimulation.getId().equals(((SmlUniformTimeCourse)simulationList.get(indexOfSimulation)).getId())) {
                simulationList.remove(indexOfSimulation);
                break;
            }
            ++indexOfSimulation;
        }
        simulationList.add(indexOfSimulation, smlSimulation);
        SmlModel smlModel = new SmlModel();
        smlModel.setId(smlTask.getModelReference());
        smlModel.setName(modelName);
        smlModel.setLanguage("SBML");
        smlModel.setSource(modelPath);
        ArrayList<Object> listOfChanges = new ArrayList<Object>();
        String xpathPart = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:";
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            Species newSpecies = (Species)listOfSpecies.get((long)i);
            j = 0;
            while (j < listOfOriginSpecies.size()) {
                Species oldSpecies = (Species)listOfOriginSpecies.get(j);
                if (newSpecies.getId().equals(oldSpecies.getId())) {
                    String xpath;
                    SmlChangeAttribute smlChangeAttribute;
                    boolean bChanged = false;
                    if (newSpecies.isSetInitialAmount()) {
                        if (newSpecies.getInitialAmount() != oldSpecies.getInitialAmount()) {
                            bChanged = true;
                        }
                    } else if (newSpecies.isSetInitialConcentration() && newSpecies.getInitialConcentration() != oldSpecies.getInitialConcentration()) {
                        bChanged = true;
                    }
                    if (bChanged) {
                        smlChangeAttribute = new SmlChangeAttribute();
                        xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:species[@id='" + newSpecies.getId() + "']/@" + "initialquantity";
                        smlChangeAttribute.setTarget(xpath);
                        if (newSpecies.isSetInitialAmount()) {
                            smlChangeAttribute.setNewValue(String.valueOf(newSpecies.getInitialAmount()));
                        } else if (newSpecies.isSetInitialConcentration()) {
                            smlChangeAttribute.setNewValue(String.valueOf(newSpecies.getInitialConcentration()));
                        }
                        listOfChanges.add(smlChangeAttribute);
                    }
                    if (newSpecies.isSetInitialAmount() != oldSpecies.isSetInitialAmount()) {
                        smlChangeAttribute = new SmlChangeAttribute();
                        xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:species[@id='" + newSpecies.getId() + "']/@" + "quantitytype";
                        smlChangeAttribute.setTarget(xpath);
                        if (newSpecies.isSetInitialAmount()) {
                            smlChangeAttribute.setNewValue("amount");
                        } else if (newSpecies.isSetInitialConcentration()) {
                            smlChangeAttribute.setNewValue("concentration");
                        }
                        listOfChanges.add(smlChangeAttribute);
                    }
                    if (newSpecies.getBoundaryCondition() != oldSpecies.getBoundaryCondition()) {
                        smlChangeAttribute = new SmlChangeAttribute();
                        xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:species[@id='" + newSpecies.getId() + "']/@" + "boundarycondition";
                        smlChangeAttribute.setTarget(xpath);
                        smlChangeAttribute.setNewValue(String.valueOf(newSpecies.getBoundaryCondition()));
                        listOfChanges.add(smlChangeAttribute);
                    }
                    if (newSpecies.getConstant() == oldSpecies.getConstant()) break;
                    smlChangeAttribute = new SmlChangeAttribute();
                    xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:species[@id='" + newSpecies.getId() + "']/@" + "constant";
                    smlChangeAttribute.setTarget(xpath);
                    smlChangeAttribute.setNewValue(String.valueOf(newSpecies.getConstant()));
                    listOfChanges.add(smlChangeAttribute);
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while ((long)i < listOfParameters.size()) {
            Parameter newParameter = (Parameter)listOfParameters.get((long)i);
            j = 0;
            while (j < listOfOriginGlobalParameters.size()) {
                Parameter oldParameter = (Parameter)listOfOriginGlobalParameters.get(j);
                if (newParameter.getId().equals(oldParameter.getId())) {
                    String xpath;
                    if (newParameter.getValue() != oldParameter.getValue()) {
                        SmlChangeAttribute smlChangeAttribute = new SmlChangeAttribute();
                        xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:parameter[@id='" + newParameter.getId() + "']/@" + "value";
                        smlChangeAttribute.setTarget(xpath);
                        smlChangeAttribute.setNewValue(String.valueOf(newParameter.getValue()));
                        listOfChanges.add(smlChangeAttribute);
                    }
                    if (newParameter.getConstant() == oldParameter.getConstant()) break;
                    SmlChangeAttribute smlChangeAttribute = new SmlChangeAttribute();
                    xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:parameter[@id='" + newParameter.getId() + "']/@" + "constant";
                    smlChangeAttribute.setTarget(xpath);
                    smlChangeAttribute.setNewValue(String.valueOf(newParameter.getConstant()));
                    listOfChanges.add(smlChangeAttribute);
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while ((long)i < listOfReaction.size()) {
            Reaction reaction = (Reaction)listOfReaction.get((long)i);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            int k = 0;
            while ((long)k < lstParameter.size()) {
                Parameter newParameter = (Parameter)lstParameter.get((long)k);
                int j2 = 0;
                while (j2 < listOfOriginReactions.size()) {
                    Parameter oldParameter = (Parameter)listOfOriginReactions.get(j2);
                    if (newParameter.getId().equals(oldParameter.getId())) {
                        String xpath;
                        SmlChangeAttribute smlChangeAttribute;
                        if (newParameter.getValue() != oldParameter.getValue()) {
                            smlChangeAttribute = new SmlChangeAttribute();
                            xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:parameter[@id='" + newParameter.getId() + "']/@" + "value";
                            smlChangeAttribute.setTarget(xpath);
                            smlChangeAttribute.setNewValue(String.valueOf(newParameter.getValue()));
                            listOfChanges.add(smlChangeAttribute);
                        }
                        if (newParameter.getConstant() == oldParameter.getConstant()) break;
                        smlChangeAttribute = new SmlChangeAttribute();
                        xpath = "/sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:parameter[@id='" + newParameter.getId() + "']/@" + "constant";
                        smlChangeAttribute.setTarget(xpath);
                        smlChangeAttribute.setNewValue(String.valueOf(newParameter.getConstant()));
                        listOfChanges.add(smlChangeAttribute);
                        break;
                    }
                    ++j2;
                }
                ++k;
            }
            ++i;
        }
        smlModel.setListOfChanges(listOfChanges);
        SmlChangeAmount smlChanggeAmount = new SmlChangeAmount();
        smlChanggeAmount.setDoChangeAmount(changeAmount.doChangeAmount());
        smlChanggeAmount.setInterval(changeAmount.getStep());
        smlChanggeAmount.setTo(changeAmount.getSpan());
        ArrayList headerName = changeAmount.getHeaderName();
        SmlAmount smlHeaderName = new SmlAmount();
        smlHeaderName.setName(headerName.get(0).toString());
        ArrayList<Object> smlHeaderAmount = new ArrayList<Object>();
        int i2 = 1;
        while (i2 < headerName.size()) {
            smlHeaderAmount.add(headerName.get(i2));
            ++i2;
        }
        smlHeaderName.setAmount(smlHeaderAmount);
        smlChanggeAmount.setHeaderName(smlHeaderName);
        ArrayList speciesList = changeAmount.getSpeciesList();
        String[][] amountTable = changeAmount.getAmounts();
        ArrayList<Object> smlAmountList = new ArrayList<Object>();
        int i3 = 0;
        while (i3 < speciesList.size()) {
            SmlAmount smlRecordAmount = new SmlAmount();
            smlRecordAmount.setName(speciesList.get(i3).toString());
            ArrayList<Object> smlAmount = new ArrayList<Object>();
            int j3 = 1;
            while (j3 < headerName.size()) {
                try {
                    smlAmount.add(amountTable[i3][j3]);
                }
                catch (Exception e) {
                    smlAmount.add("");
                }
                ++j3;
            }
            smlRecordAmount.setAmount(smlAmount);
            smlAmountList.add(smlRecordAmount);
            ++i3;
        }
        smlChanggeAmount.setAmountList(smlAmountList);
        smlModel.setChangeAmount(smlChanggeAmount);
        SmlParameterScan smlParameterScan = new SmlParameterScan();
        ArrayList<Object> smlListOfPS = new ArrayList<Object>();
        int i4 = 0;
        while (i4 < 2) {
            SmlSimParameterScan smlSimParameterScan = new SmlSimParameterScan();
            smlSimParameterScan.setDoScanParameter(parameterScan.doScanParameter(i4));
            smlSimParameterScan.setKindOfParameter(parameterScan.getKindOfParameter(i4));
            smlSimParameterScan.setName(parameterScan.getTarget(i4));
            smlSimParameterScan.setFrom(Double.valueOf(parameterScan.getFrom(i4)));
            smlSimParameterScan.setTo(Double.valueOf(parameterScan.getTo(i4)));
            smlSimParameterScan.setInterval(Double.valueOf(parameterScan.getInterval(i4)));
            smlListOfPS.add(smlSimParameterScan);
            ++i4;
        }
        smlParameterScan.setListOfSimPS(smlListOfPS);
        smlModel.setParameterScan(smlParameterScan);
        SmlInteractiveSimulation smlInteractiveSimulation = new SmlInteractiveSimulation();
        ArrayList speciesValueSliderList = interactiveSimulation.getInteractiveParameterList("initial value");
        ArrayList<Object> smlSpeciesValueSliderList = new ArrayList<Object>();
        smlInteractiveSimulation.setKindOfParameter(interactiveSimulation.getKindOfParameter());
        int i5 = 0;
        while (i5 < speciesValueSliderList.size()) {
            SmlSliderValue sliderValue = new SmlSliderValue();
            SliderValue sv = (SliderValue)speciesValueSliderList.get(i5);
            sliderValue.setId(sv.getTarget());
            sliderValue.setReaId(sv.getRedSpeId());
            sliderValue.setMin(Double.valueOf(sv.getMinValue()));
            sliderValue.setMax(Double.valueOf(sv.getMaxValue()));
            sliderValue.setCurrent(Double.valueOf(sv.getValue()));
            smlSpeciesValueSliderList.add(sliderValue);
            ++i5;
        }
        ArrayList parameterValueSliderList = interactiveSimulation.getInteractiveParameterList("parameter value");
        ArrayList<Object> smlParameterValueSliderList = new ArrayList<Object>();
        int i6 = 0;
        while (i6 < parameterValueSliderList.size()) {
            SmlSliderValue sliderValue = new SmlSliderValue();
            SliderValue sv = (SliderValue)parameterValueSliderList.get(i6);
            sliderValue.setId(sv.getTarget());
            sliderValue.setReaId(sv.getRedSpeId());
            sliderValue.setMin(Double.valueOf(sv.getMinValue()));
            sliderValue.setMax(Double.valueOf(sv.getMaxValue()));
            sliderValue.setCurrent(Double.valueOf(sv.getValue()));
            smlParameterValueSliderList.add(sliderValue);
            ++i6;
        }
        smlInteractiveSimulation.setListOfInitial(smlSpeciesValueSliderList);
        smlInteractiveSimulation.setListOfParameter(smlParameterValueSliderList);
        smlModel.setInteractiveSimulation(smlInteractiveSimulation);
        int indexOfMode = 0;
        while (indexOfMode < modelList.size()) {
            if (smlModel.getId().equals(((SmlModel)modelList.get(indexOfMode)).getId())) {
                modelList.remove(indexOfMode);
                break;
            }
            ++indexOfMode;
        }
        modelList.add(indexOfMode, smlModel);
        SmlDataGenerator smlDataGenerator = new SmlDataGenerator();
        dataGeneratorsList.add(smlDataGenerator);
        boolean replaceFlag = false;
        if (listOfResult != null && listOfResult.size() > 0) {
            int i7 = 0;
            while (i7 < outputList.size()) {
                plot2d = (SmlPlot2D)outputList.get(i7);
                if (smlTask.getId().equals(plot2d.getTaskref())) {
                    SmlPlot2D plot2dUpdate = plot2d.clone();
                    outputList.remove(i7);
                    SmlUtil.SetPlot2DGraphInfo(plot2dUpdate, simulationInfo, smlModel, true);
                    plot2dUpdate.getResultofList().clear();
                    ArrayList<SBMLResults> listResults = new ArrayList<SBMLResults>();
                    int j4 = 0;
                    while (j4 < listOfResult.size()) {
                        listResults.add(((SBMLResults)listOfResult.get(j4)).clone());
                        ++j4;
                    }
                    plot2dUpdate.setResultofList(listResults);
                    outputList.add(i7, plot2dUpdate);
                    replaceFlag = true;
                    break;
                }
                ++i7;
            }
            if (!replaceFlag) {
                SmlPlot2D plot2d2 = new SmlPlot2D();
                plot2d2.setId(SmlUtil.getNewPlotId(smlSimCondition));
                plot2d2.setTaskref(smlTask.getId());
                SmlUtil.SetPlot2DGraphInfo(plot2d2, simulationInfo, smlModel, false);
                ArrayList<SBMLResults> listResults = new ArrayList<SBMLResults>();
                int j5 = 0;
                while (j5 < listOfResult.size()) {
                    listResults.add(((SBMLResults)listOfResult.get(j5)).clone());
                    ++j5;
                }
                plot2d2.setResultofList(listResults);
                outputList.add(plot2d2);
            }
        }
        if (path != null) {
            int i8 = 0;
            while (i8 < outputList.size()) {
                plot2d = (SmlPlot2D)outputList.get(i8);
                plot2d.setOutputPath(path.replace("_sed.xml", ""));
                ++i8;
            }
        }
        return true;
    }

    private static final void SetPlot2DGraphInfo(SmlPlot2D plot2d, SimulationInfo simulationInfo, SmlModel smlModel, boolean changeflag) {
        SmlGraphInfo graphInfo = new SmlGraphInfo();
        SimulationResultPanel srp = simulationInfo.getParent().getSrp();
        if (srp == null) {
            return;
        }
        graphInfo.setYmax(srp.getMaxRangeNow());
        graphInfo.setO(srp.getMinRangeNow());
        graphInfo.setXperscreen(srp.getMaxTimeNow());
        graphInfo.setConcentration(srp.getScaleListSelected());
        graphInfo.setSpecies(srp.getCheckSpeciesSelected());
        graphInfo.setFluxes(srp.getCheckFluxSelected());
        graphInfo.setParameters(srp.getCheckParameterSelected());
        graphInfo.setCompartments(srp.getCheckCompartmentSelected());
        graphInfo.setShow(simulationInfo.getParent().isShowScatter());
        graphInfo.setReverse(simulationInfo.getParent().isShowReverse());
        int i = 0;
        while (simulationInfo.getListOfResults() != null && i < simulationInfo.getListOfResults().size()) {
            SBMLResults result = (SBMLResults)simulationInfo.getListOfResults().get(i);
            if (result.isVisible() || simulationInfo.getListOfResults().size() == 1) {
                SBMLPanelLists panelList;
                ListOf sbsList;
                result.setVisible(true);
                ArrayList<SmlPaint> speciesPaintList = new ArrayList<SmlPaint>();
                ArrayList<Object> list = smlModel.getInteractiveSimulation().getListOfInitial();
                if (list != null && srp.getSpeciesVisible() != null) {
                    int num_val = list.size();
                    int index = 0;
                    while (index < num_val) {
                        SmlSliderValue sliderValue = (SmlSliderValue)list.get(index);
                        Color color = SmlUtil.SetPatinInfo(srp, sliderValue);
                        if (color != null) {
                            SmlPaint paint = new SmlPaint();
                            SmlUtil.SetPatinInfo(srp, paint, sliderValue.getReaId(), sliderValue.getId(), color, srp.getSpeciesVisible());
                            speciesPaintList.add(paint);
                        }
                        ++index;
                    }
                }
                ArrayList<SmlPaint> fluxesPaintList = new ArrayList<SmlPaint>();
                if (result.getFluxes() != null && srp.getSpeciesVisible() != null) {
                    int num_val = result.getFluxes().getNum_val();
                    int index = 0;
                    while (index < num_val) {
                        String reactionId = result.getFluxes().getName(index);
                        Color color = srp.getSpeciesColorSet().getColor(reactionId);
                        if (color != null) {
                            SmlPaint paint = new SmlPaint();
                            SmlUtil.SetPatinInfo(srp, paint, reactionId, reactionId, color, srp.getSpeciesVisible());
                            fluxesPaintList.add(paint);
                        }
                        ++index;
                    }
                }
                ArrayList<SmlPaint> parameteresPaintList = new ArrayList<SmlPaint>();
                ArrayList<Object> listParameter = smlModel.getInteractiveSimulation().getListOfParameter();
                if (listParameter != null && srp.getSpeciesVisible() != null) {
                    int num_val = listParameter.size();
                    int index = 0;
                    while (index < num_val) {
                        SmlSliderValue sliderValue = (SmlSliderValue)listParameter.get(index);
                        Color color = srp.getSpeciesColorSet().getColor(sliderValue.getId());
                        if (color != null) {
                            SmlPaint paint = new SmlPaint();
                            SmlUtil.SetPatinInfo(srp, paint, sliderValue.getId(), sliderValue.getId(), color, srp.getSpeciesVisible());
                            parameteresPaintList.add(paint);
                        }
                        ++index;
                    }
                }
                ArrayList<SmlPaint> compartmentPaintList = new ArrayList<SmlPaint>();
                if (simulationInfo.getParent().getSbframe().getSBModel().getSBMLPanelLists() != null && (sbsList = (panelList = simulationInfo.getParent().getSbframe().getSBModel().getSBMLPanelLists()).getSBaseListPanel(2).getSBaseList()) != null && srp.getSpeciesVisible() != null) {
                    int index = 0;
                    while ((long)index < sbsList.size()) {
                        Compartment compartment = (Compartment)sbsList.get((long)index);
                        Color color = srp.getSpeciesColorSet().getColor(compartment.getId());
                        if (color != null) {
                            SmlPaint paint = new SmlPaint();
                            SmlUtil.SetPatinInfo(srp, paint, compartment.getId(), compartment.getId(), color, srp.getSpeciesVisible());
                            compartmentPaintList.add(paint);
                        }
                        ++index;
                    }
                }
                if (changeflag) {
                    graphInfo.setSpeciesPaint(plot2d.getGraphInfo().getSpeciesPaint());
                } else {
                    graphInfo.setSpeciesPaint(speciesPaintList);
                }
                graphInfo.setFluxesPaint(fluxesPaintList);
                graphInfo.setParameteresPaint(parameteresPaintList);
                graphInfo.setCompartmentsPaint(compartmentPaintList);
                break;
            }
            ++i;
        }
        plot2d.setGraphInfo(graphInfo);
    }

    private static void SetPatinInfo(SimulationResultPanel srp, SmlPaint paint, String id, String name, Color color, SpeciesVisible speciesVisible) {
        paint.setId(id);
        if (srp.getSpeciesColorSet().getSpeciesColorMap().containsKey(String.valueOf(id) + ":" + name)) {
            paint.setName(String.valueOf(id) + ":" + name);
        } else {
            paint.setName(name);
        }
        paint.setColor(color);
        paint.setReactionId("");
        if (speciesVisible != null) {
            if (speciesVisible.isVisible(id) == null) {
                paint.setVisible(false);
            } else {
                paint.setVisible(speciesVisible.isVisible(id));
            }
        }
    }

    private static Color SetPatinInfo(SimulationResultPanel srp, SmlSliderValue sliderValue) {
        Color color = null;
        SpeciesColorSet speciesColorSet = srp.getSpeciesColorSet();
        for (Map.Entry entry : speciesColorSet.getSpeciesColorMap().entrySet()) {
            String key = entry.getKey().toString();
            if (key.equals(String.valueOf(sliderValue.getReaId()) + ":" + sliderValue.getId())) {
                color = srp.getSpeciesColorSet().getColor(key);
                break;
            }
            color = srp.getSpeciesColorSet().getColor(sliderValue.getId());
        }
        return color;
    }

    private static String RunValidate(SmlSimCondition rtnSedml) throws Exception {
        SedML sedml = CreateSedml.createPersistenceSedmlData(rtnSedml);
        SEDMLDocument doc = new SEDMLDocument(sedml);
        doc.validate();
        StringBuffer bufOutput = new StringBuffer();
        for (SedMLError error : doc.getErrors()) {
            bufOutput.append(error.toString());
            bufOutput.append("\r\n");
        }
        if (!bufOutput.toString().equals("")) {
            return bufOutput.toString();
        }
        return null;
    }
}

