/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.sedml.databean;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.sedml.databean.SEDBase;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlCurve;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlGraphInfo;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPaint;
import jp.co.mki.celldesigner.simulation.sedml.util.SmlUtil;
import jp.sbi.celldesigner.util.CelldUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmlPlot2D
extends SEDBase {
    private String id;
    private String name;
    private ArrayList<Object> listOfCurves = new ArrayList();
    private String taskref;
    private SmlGraphInfo graphInfo = new SmlGraphInfo();
    private String outputPath;
    private List<SBMLResults> resultofList = new ArrayList<SBMLResults>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<Object> getListOfCurves() {
        return this.listOfCurves;
    }

    public void setListOfCurves(ArrayList<Object> listOfCurves) {
        this.listOfCurves = listOfCurves;
    }

    public String getTaskref() {
        return this.taskref;
    }

    public void setTaskref(String taskref) {
        this.taskref = taskref;
    }

    public SmlGraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    public void setGraphInfo(SmlGraphInfo graphInfo) {
        this.graphInfo = graphInfo;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public List<SBMLResults> getResultofList() {
        return this.resultofList;
    }

    public void setResultofList(List<SBMLResults> resultofList) {
        this.resultofList = resultofList;
    }

    public static final void readingDOMTree(SmlPlot2D onerow, Element sourcedoc) throws Exception {
        Element elem;
        String nodename;
        if (sourcedoc.getNodeType() == 1 && CelldUtil.issameIgnoreCaseIgnoreSpace(nodename = (elem = sourcedoc).getNodeName(), "plot2D")) {
            NamedNodeMap map = elem.getAttributes();
            if (map != null) {
                int k = 0;
                while (k < map.getLength()) {
                    Node item = map.item(k);
                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "id")) {
                        onerow.setId(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "name")) {
                        onerow.setName(item.getNodeValue());
                    }
                    ++k;
                }
            }
            NodeList childlist1 = elem.getChildNodes();
            int childsize1 = childlist1.getLength();
            int i = 0;
            while (i < childsize1) {
                Node node1 = childlist1.item(i);
                if (node1.getNodeType() == 1) {
                    Element elem1 = (Element)node1;
                    String nodename1 = elem1.getNodeName();
                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "listOfCurves")) {
                        ArrayList<Object> list = onerow.getListOfCurves();
                        SmlUtil.setListValueByReadingDOMTree(list, elem1);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "annotation")) {
                        onerow.readAnnotationFromDOMTree(elem1);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "notes")) {
                        onerow.readNotesFromDOMTree(elem1);
                    }
                }
                ++i;
            }
        }
        if (onerow != null && onerow.getResultofList().size() > 0) {
            SmlPaint smlPaint;
            int speciesSize = onerow.getGraphInfo().getSpeciesPaintSize();
            int fluxesSize = onerow.getGraphInfo().getFluxesPaintSize();
            int parametersSize = onerow.getGraphInfo().getParameteresSize();
            int compartmentsSize = onerow.getGraphInfo().getCompartmentsSize();
            String[] species = new String[speciesSize];
            String[] fluxes = new String[fluxesSize];
            String[] parameters = new String[parametersSize];
            String[] compartments = new String[compartmentsSize];
            int i = 0;
            while (i < speciesSize) {
                smlPaint = onerow.getGraphInfo().getSpeciesPaint().get(i);
                species[i] = smlPaint.getName();
                ++i;
            }
            i = 0;
            while (i < fluxesSize) {
                smlPaint = onerow.getGraphInfo().getFluxesPaint().get(i);
                fluxes[i] = smlPaint.getName();
                ++i;
            }
            i = 0;
            while (i < parametersSize) {
                smlPaint = onerow.getGraphInfo().getParameteresPaint().get(i);
                parameters[i] = smlPaint.getName();
                ++i;
            }
            i = 0;
            while (i < compartmentsSize) {
                smlPaint = onerow.getGraphInfo().getCompartmentsPaint().get(i);
                compartments[i] = smlPaint.getName();
                ++i;
            }
            i = 0;
            while (i < onerow.getResultofList().size()) {
                SBMLResults result = onerow.getResultofList().get(i);
                if (result.getSpecies() != null) {
                    result.getSpecies().setNames(species);
                    result.getSpecies().setNum_val(speciesSize);
                }
                if (result.getFluxes() != null) {
                    result.getFluxes().setNames(fluxes);
                    result.getFluxes().setNum_val(fluxesSize);
                }
                if (result.getParameters() != null) {
                    result.getParameters().setNames(parameters);
                    result.getParameters().setNum_val(parametersSize);
                }
                if (result.getCompartments() != null) {
                    result.getCompartments().setNames(compartments);
                    result.getCompartments().setNum_val(compartmentsSize);
                }
                ++i;
            }
        }
    }

    @Override
    public void readAnnotationFromDOMTree(Element sourcedoc) throws Exception {
        NodeList childlist1 = sourcedoc.getChildNodes();
        int childsize1 = childlist1.getLength();
        int i = 0;
        while (i < childsize1) {
            Node node1 = childlist1.item(i);
            if (node1.getNodeType() == 1) {
                Element elem1 = (Element)node1;
                String nodename1 = elem1.getNodeName();
                if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "celldesigner:extension")) {
                    NodeList childlist2 = elem1.getChildNodes();
                    int childsize2 = childlist2.getLength();
                    int j = 0;
                    while (j < childsize2) {
                        Node node2 = childlist2.item(j);
                        if (node2.getNodeType() == 1) {
                            int k;
                            NamedNodeMap map;
                            Element elem2 = (Element)node2;
                            String nodename2 = elem2.getNodeName();
                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:taskref")) {
                                map = elem2.getAttributes();
                                if (map != null) {
                                    k = 0;
                                    while (k < map.getLength()) {
                                        Node item = map.item(k);
                                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "id")) {
                                            this.setTaskref(item.getNodeValue());
                                        }
                                        ++k;
                                    }
                                }
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:addition")) {
                                map = elem2.getAttributes();
                                if (map != null) {
                                    k = 0;
                                    while (k < map.getLength()) {
                                        boolean bo;
                                        Node item = map.item(k);
                                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "ymax")) {
                                            this.graphInfo.setYmax(Double.parseDouble(item.getNodeValue()));
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "o")) {
                                            this.graphInfo.setO(Double.parseDouble(item.getNodeValue()));
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "xperscreen")) {
                                            this.graphInfo.setXperscreen(Double.parseDouble(item.getNodeValue()));
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "concentration")) {
                                            this.graphInfo.setConcentration(item.getNodeValue());
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "species")) {
                                            bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.graphInfo.setSpecies(bo);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "fluxes")) {
                                            bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.graphInfo.setFluxes(bo);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "parameters")) {
                                            bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.graphInfo.setParameters(bo);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "compartments")) {
                                            bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.graphInfo.setCompartments(bo);
                                        }
                                        ++k;
                                    }
                                }
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:scatterplot")) {
                                map = elem2.getAttributes();
                                if (map != null) {
                                    k = 0;
                                    while (k < map.getLength()) {
                                        boolean bo;
                                        Node item = map.item(k);
                                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "show")) {
                                            bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.graphInfo.setShow(bo);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "reverse")) {
                                            bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.graphInfo.setReverse(bo);
                                        }
                                        ++k;
                                    }
                                }
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:paint")) {
                                NodeList paintNoteList = elem2.getChildNodes();
                                int paintNotesize = paintNoteList.getLength();
                                int index = 0;
                                while (index < paintNotesize) {
                                    Element paintInfoelem;
                                    String paintInfoNodename;
                                    Node paintNode = paintNoteList.item(index);
                                    if (paintNode.getNodeType() == 1 && CelldUtil.issameIgnoreCaseIgnoreSpace(paintInfoNodename = (paintInfoelem = (Element)paintNode).getNodeName(), "celldesigner:paintinfo")) {
                                        List<SmlPaint> smlPaintList;
                                        NodeList paintInfoNoteList;
                                        String type = paintInfoelem.getAttributes().getNamedItem("type").getNodeValue();
                                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(type, "species")) {
                                            paintInfoNoteList = paintInfoelem.getChildNodes();
                                            smlPaintList = this.readingPaintInfo(paintInfoNoteList);
                                            this.graphInfo.setSpeciesPaint(smlPaintList);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(type, "fluxes")) {
                                            paintInfoNoteList = paintInfoelem.getChildNodes();
                                            smlPaintList = this.readingPaintInfo(paintInfoNoteList);
                                            this.graphInfo.setFluxesPaint(smlPaintList);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(type, "parameters")) {
                                            paintInfoNoteList = paintInfoelem.getChildNodes();
                                            smlPaintList = this.readingPaintInfo(paintInfoNoteList);
                                            this.graphInfo.setParameteresPaint(smlPaintList);
                                        } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(type, "compartments")) {
                                            paintInfoNoteList = paintInfoelem.getChildNodes();
                                            smlPaintList = this.readingPaintInfo(paintInfoNoteList);
                                            this.graphInfo.setCompartmentsPaint(smlPaintList);
                                        }
                                    }
                                    ++index;
                                }
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:listOfResult")) {
                                NodeList resultList = elem2.getChildNodes();
                                int resultListNotesize = resultList.getLength();
                                int index = 0;
                                while (index < resultListNotesize) {
                                    Node resultNode = resultList.item(index);
                                    if (resultNode.getNodeType() == 1) {
                                        Element resultNodeElem = (Element)resultNode;
                                        SBMLResults result = new SBMLResults(0, new double[0]);
                                        result = result.readAnnotationFromDOMTree(resultNodeElem);
                                        this.resultofList.add(result);
                                    }
                                    ++index;
                                }
                            }
                        }
                        ++j;
                    }
                } else {
                    super.readAnnotationFromDOMTree(elem1);
                }
            }
            ++i;
        }
    }

    private final List<SmlPaint> readingPaintInfo(NodeList paintInfoNoteList) throws Exception {
        ArrayList<SmlPaint> smlPaintList = new ArrayList<SmlPaint>();
        int paintInfoNotesize = paintInfoNoteList.getLength();
        int i = 0;
        while (i < paintInfoNotesize) {
            Element plotElement;
            String paintName;
            Node plotNode = paintInfoNoteList.item(i);
            if (plotNode.getNodeType() == 1 && CelldUtil.issameIgnoreCaseIgnoreSpace(paintName = (plotElement = (Element)plotNode).getNodeName(), "celldesigner:plot")) {
                SmlPaint smlPaint = new SmlPaint();
                SmlPaint.readingDOMTree(smlPaint, plotElement);
                smlPaintList.add(smlPaint);
            }
            ++i;
        }
        return smlPaintList;
    }

    public static final void createPersistenceXmlData(StringBuffer bufOutput, SmlPlot2D anyone) throws Exception {
        bufOutput.append("<plot2D");
        if (anyone.id != null) {
            bufOutput.append(" id=\"" + anyone.id + "\"");
        }
        if (anyone.name != null) {
            bufOutput.append(" name=\"" + anyone.name + "\"");
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            bufOutput.append(">\n");
        } else if (anyone.listOfCurves != null && anyone.listOfCurves.size() > 0) {
            bufOutput.append(">\n");
        } else {
            bufOutput.append(" />\n");
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            anyone.appendNotesInfo(bufOutput);
            anyone.appendAnnotationInfo(bufOutput, true);
        }
        SmlCurve.createPersistenceXmlData(bufOutput, anyone);
        if (anyone.isNeedAppendChildrenInfo()) {
            bufOutput.append("</plot2D>\n");
        } else if (anyone.listOfCurves != null && anyone.listOfCurves.size() > 0) {
            bufOutput.append("</plot2D>\n");
        }
    }

    @Override
    protected void appendAnnotationInfo(StringBuffer bufOutput, boolean bNeedAnnoTag) {
        bufOutput.append("<annotation>\n");
        bufOutput.append("<celldesigner:extension xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">\n");
        bufOutput.append("<celldesigner:taskref id=\"" + this.taskref + "\" />\n");
        bufOutput.append("<celldesigner:addition ymax=\"" + this.graphInfo.getYmax() + "\"");
        bufOutput.append(" o=\"" + this.graphInfo.getO() + "\"");
        bufOutput.append(" xperscreen=\"" + this.graphInfo.getXperscreen() + "\"");
        bufOutput.append(" concentration=\"" + this.graphInfo.getConcentration() + "\"");
        bufOutput.append(" species=\"" + this.graphInfo.isSpecies() + "\"");
        bufOutput.append(" fluxes=\"" + this.graphInfo.isFluxes() + "\"");
        bufOutput.append(" parameters=\"" + this.graphInfo.isParameters() + "\"");
        bufOutput.append(" compartments=\"" + this.graphInfo.isCompartments() + "\"");
        bufOutput.append(" />\n");
        bufOutput.append("<celldesigner:scatterplot");
        bufOutput.append(" show=\"" + this.graphInfo.isShow() + "\"");
        bufOutput.append(" reverse=\"" + this.graphInfo.isReverse() + "\"");
        bufOutput.append(" />\n");
        if (this.graphInfo.getSpeciesPaintSize() > 0 || this.graphInfo.getFluxesPaintSize() > 0 || this.graphInfo.getParameteresSize() > 0 || this.graphInfo.getCompartmentsSize() > 0) {
            SmlPaint paint;
            int i;
            bufOutput.append("<celldesigner:paint>\n");
            if (this.graphInfo.getSpeciesPaintSize() > 0) {
                bufOutput.append("<celldesigner:paintinfo type=\"species\">\n");
                i = 0;
                while (i < this.graphInfo.getSpeciesPaintSize()) {
                    paint = this.graphInfo.getSpeciesPaint().get(i);
                    paint.appendAnnotationInfo(bufOutput);
                    ++i;
                }
                bufOutput.append("</celldesigner:paintinfo>\n");
            } else {
                bufOutput.append("<celldesigner:paintinfo type=\"species\"/>\n");
            }
            if (this.graphInfo.getFluxesPaintSize() > 0) {
                bufOutput.append("<celldesigner:paintinfo type=\"fluxes\">\n");
                i = 0;
                while (i < this.graphInfo.getFluxesPaintSize()) {
                    paint = this.graphInfo.getFluxesPaint().get(i);
                    paint.appendAnnotationInfo(bufOutput);
                    ++i;
                }
                bufOutput.append("</celldesigner:paintinfo>\n");
            } else {
                bufOutput.append("<celldesigner:paintinfo type=\"fluxes\"/>\n");
            }
            if (this.graphInfo.getParameteresSize() > 0) {
                bufOutput.append("<celldesigner:paintinfo type=\"parameters\">\n");
                i = 0;
                while (i < this.graphInfo.getParameteresSize()) {
                    paint = this.graphInfo.getParameteresPaint().get(i);
                    paint.appendAnnotationInfo(bufOutput);
                    ++i;
                }
                bufOutput.append("</celldesigner:paintinfo>\n");
            } else {
                bufOutput.append("<celldesigner:paintinfo type=\"parameters\"/>\n");
            }
            if (this.graphInfo.getCompartmentsSize() > 0) {
                bufOutput.append("<celldesigner:paintinfo type=\"compartments\">\n");
                i = 0;
                while (i < this.graphInfo.getCompartmentsSize()) {
                    paint = this.graphInfo.getCompartmentsPaint().get(i);
                    paint.appendAnnotationInfo(bufOutput);
                    ++i;
                }
                bufOutput.append("</celldesigner:paintinfo>\n");
            } else {
                bufOutput.append("<celldesigner:paintinfo type=\"compartments\"/>\n");
            }
            bufOutput.append("</celldesigner:paint>\n");
        } else {
            bufOutput.append("<celldesigner:paint/>\n");
        }
        if (this.resultofList != null && this.resultofList.size() > 0) {
            bufOutput.append("<celldesigner:listOfResult>\n");
            int index = 0;
            while (index < this.resultofList.size()) {
                SBMLResults resoutinfo = this.resultofList.get(index);
                String path = String.valueOf(this.outputPath) + "_Result" + File.separator + this.taskref + "_result";
                bufOutput.append("<celldesigner:result id=\"" + resoutinfo.getParameterInfo() + "\"");
                bufOutput.append(" source=\"" + path + File.separator + "result" + resoutinfo.getParameterInfo() + ".txt" + "\"");
                bufOutput.append(" visible=\"" + resoutinfo.isVisible() + "\"/>\n");
                ++index;
            }
            bufOutput.append("</celldesigner:listOfResult>\n");
        }
        bufOutput.append("</celldesigner:extension>\n");
        this.appendAdditionAnnotationInfo(bufOutput, false);
        bufOutput.append("</annotation>\n");
    }

    @Override
    protected boolean isNeedAppendCelldExtChildrenInfo() {
        return true;
    }

    public SmlPlot2D clone() {
        SmlPlot2D newInstance = new SmlPlot2D();
        newInstance.strNotes = this.strNotes;
        newInstance.strOtherAnnotation = this.strOtherAnnotation;
        newInstance.id = this.id;
        newInstance.name = this.name;
        if (this.listOfCurves != null && this.listOfCurves.size() > 0) {
            int i = 0;
            while (i < this.listOfCurves.size()) {
                newInstance.listOfCurves.add(((SmlCurve)this.listOfCurves.get(i)).clone());
                ++i;
            }
        }
        newInstance.taskref = this.taskref;
        newInstance.graphInfo = this.graphInfo.clone();
        newInstance.outputPath = this.outputPath;
        if (this.resultofList.size() > 0) {
            int index = 0;
            while (index < this.resultofList.size()) {
                newInstance.resultofList.add(this.resultofList.get(index).clone());
                ++index;
            }
        }
        return newInstance;
    }
}

