/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.sedml.databean;

import java.util.ArrayList;
import jp.co.mki.celldesigner.simulation.sedml.databean.SEDBase;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAttribute;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlInteractiveSimulation;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSliderValue;
import jp.co.mki.celldesigner.simulation.sedml.util.SmlUtil;
import jp.sbi.celldesigner.util.CelldUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmlModel
extends SEDBase {
    private String id;
    private String name;
    private String type;
    private String language;
    private String source;
    private SmlChangeAmount changeAmount;
    private SmlParameterScan parameterScan;
    private SmlInteractiveSimulation interactiveSimulation;
    private ArrayList<Object> listOfChanges = new ArrayList();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ArrayList<Object> getListOfChanges() {
        return this.listOfChanges;
    }

    public void setListOfChanges(ArrayList<Object> listOfChanges) {
        this.listOfChanges = listOfChanges;
    }

    public SmlChangeAmount getChangeAmount() {
        return this.changeAmount;
    }

    public void setChangeAmount(SmlChangeAmount changeAmount) {
        this.changeAmount = changeAmount;
    }

    public SmlParameterScan getParameterScan() {
        return this.parameterScan;
    }

    public void setParameterScan(SmlParameterScan parameterScan) {
        this.parameterScan = parameterScan;
    }

    public SmlInteractiveSimulation getInteractiveSimulation() {
        return this.interactiveSimulation;
    }

    public void setInteractiveSimulation(SmlInteractiveSimulation interactiveSimulation) {
        this.interactiveSimulation = interactiveSimulation;
    }

    public static final void readingDOMTree(SmlModel onerow, Element sourcedoc) throws Exception {
        if (sourcedoc.getNodeType() == 1) {
            NamedNodeMap map;
            Element elem = sourcedoc;
            String nodename = elem.getNodeName();
            if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename, "model") && (map = elem.getAttributes()) != null) {
                int k = 0;
                while (k < map.getLength()) {
                    Node item = map.item(k);
                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "id")) {
                        onerow.setId(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "name")) {
                        onerow.setName(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "type")) {
                        onerow.setType(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "language")) {
                        onerow.setLanguage(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "source")) {
                        onerow.setSource(item.getNodeValue());
                    }
                    ++k;
                }
            }
            NodeList childlist1 = elem.getChildNodes();
            int childsize1 = childlist1.getLength();
            int i = 0;
            while (i < childsize1) {
                Node node1 = childlist1.item(i);
                if (node1.getNodeType() == 1) {
                    Element elem1 = (Element)node1;
                    String nodename1 = elem1.getNodeName();
                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "listOfChanges")) {
                        ArrayList<Object> list = onerow.getListOfChanges();
                        SmlUtil.setListValueByReadingDOMTree(list, elem1);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "annotation")) {
                        onerow.readAnnotationFromDOMTree(elem1);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "notes")) {
                        onerow.readNotesFromDOMTree(elem1);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void readAnnotationFromDOMTree(Element sourcedoc) throws Exception {
        NodeList childlist1 = sourcedoc.getChildNodes();
        int childsize1 = childlist1.getLength();
        int i = 0;
        while (i < childsize1) {
            Node node1 = childlist1.item(i);
            if (node1.getNodeType() == 1) {
                Element elem1 = (Element)node1;
                String nodename1 = elem1.getNodeName();
                if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "celldesigner:extension")) {
                    NodeList childlist2 = elem1.getChildNodes();
                    int childsize2 = childlist2.getLength();
                    int j = 0;
                    while (j < childsize2) {
                        Node node2 = childlist2.item(j);
                        if (node2.getNodeType() == 1) {
                            Element elem2 = (Element)node2;
                            String nodename2 = elem2.getNodeName();
                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:changeamount")) {
                                if (this.changeAmount == null) {
                                    this.changeAmount = new SmlChangeAmount();
                                }
                                SmlChangeAmount.readingDOMTree(this.changeAmount, elem2);
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:listofparameterscan")) {
                                if (this.parameterScan == null) {
                                    this.parameterScan = new SmlParameterScan();
                                }
                                ArrayList<Object> list = this.parameterScan.getListOfSimPS();
                                SmlUtil.setListValueByReadingDOMTree(list, elem2);
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:interactivesimulation")) {
                                if (this.interactiveSimulation == null) {
                                    this.interactiveSimulation = new SmlInteractiveSimulation();
                                }
                                SmlInteractiveSimulation.readingDOMTree(this.interactiveSimulation, elem2);
                            }
                        }
                        ++j;
                    }
                } else {
                    super.readAnnotationFromDOMTree(elem1);
                }
            }
            ++i;
        }
        if (this.changeAmount != null) {
            int cnt = ((SmlAmount)this.changeAmount.getAmountList().get(0)).getAmount().size();
            int n = 1;
            while (n < this.changeAmount.getAmountList().size()) {
                if (cnt != ((SmlAmount)this.changeAmount.getAmountList().get(n)).getAmount().size()) {
                    throw new Exception();
                }
                ++n;
            }
        } else {
            this.changeAmount = new SmlChangeAmount();
            SmlAmount header = new SmlAmount();
            header.setName("");
            ArrayList<Object> datas = new ArrayList<Object>();
            datas.add("0");
            header.setAmount(datas);
            this.changeAmount.setHeaderName(header);
        }
    }

    public static final void createPersistenceXmlData(StringBuffer bufOutput, SmlModel anyone) throws Exception {
        bufOutput.append("<model");
        if (anyone.id != null) {
            bufOutput.append(" id=\"" + anyone.id + "\"");
        }
        if (anyone.name != null) {
            bufOutput.append(" name=\"" + anyone.name + "\"");
        }
        if (anyone.type != null) {
            bufOutput.append(" type=\"" + anyone.type + "\"");
        }
        if (anyone.language != null) {
            bufOutput.append(" language=\"" + anyone.language + "\"");
        }
        if (anyone.source != null) {
            bufOutput.append(" source=\"" + anyone.source + "\"");
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            bufOutput.append(">\n");
        } else if (anyone.listOfChanges != null && anyone.listOfChanges.size() > 0) {
            bufOutput.append(">\n");
        } else if (anyone.changeAmount != null) {
            bufOutput.append(">\n");
        } else if (anyone.parameterScan != null) {
            bufOutput.append(">\n");
        } else if (anyone.interactiveSimulation != null) {
            bufOutput.append(">\n");
        } else {
            bufOutput.append(" />\n");
        }
        if (anyone.listOfChanges != null && anyone.listOfChanges.size() > 0) {
            bufOutput.append("<listOfChanges>\n");
            int i = 0;
            while (i < anyone.listOfChanges.size()) {
                SmlChangeAttribute row = (SmlChangeAttribute)anyone.listOfChanges.get(i);
                bufOutput.append("<changeAttribute");
                bufOutput.append(" target=\"" + row.getTarget() + "\"");
                bufOutput.append(" newValue=\"" + row.getNewValue() + "\"");
                bufOutput.append(" />\n");
                ++i;
            }
            bufOutput.append("</listOfChanges>\n");
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            anyone.appendNotesInfo(bufOutput);
            anyone.appendAnnotationInfo(bufOutput, true);
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            bufOutput.append("</model>\n");
        } else if (anyone.listOfChanges != null && anyone.listOfChanges.size() > 0) {
            bufOutput.append("</model>\n");
        } else if (anyone.changeAmount != null) {
            bufOutput.append("</model>\n");
        } else if (anyone.parameterScan != null) {
            bufOutput.append("</model>\n");
        } else if (anyone.interactiveSimulation != null) {
            bufOutput.append("</model>\n");
        }
    }

    @Override
    protected void appendAnnotationInfo(StringBuffer bufOutput, boolean bNeedAnnoTag) {
        SEDBase row;
        int i;
        if (this.changeAmount == null && this.parameterScan == null && this.interactiveSimulation == null && (this.strOtherAnnotation == null || this.strOtherAnnotation.trim().equals(""))) {
            return;
        }
        bufOutput.append("<annotation>\n");
        bufOutput.append("<celldesigner:extension xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">\n");
        if (this.changeAmount != null) {
            bufOutput.append("<celldesigner:changeamount");
            bufOutput.append(" value=\"" + this.changeAmount.doChangeAmount() + "\"");
            bufOutput.append(" to=\"" + this.changeAmount.getTo() + "\"");
            bufOutput.append(" interval=\"" + this.changeAmount.getInterval() + "\"");
            bufOutput.append(">\n");
            bufOutput.append("<celldesigner:valuelist>\n");
            bufOutput.append("<celldesigner:value");
            bufOutput.append(" name=\"" + this.changeAmount.getHeaderName().getName() + "\"");
            bufOutput.append(" datas=\"" + this.changeAmount.getHeaderName().getAmount().get(0));
            i = 1;
            while (i < this.changeAmount.getHeaderName().getAmount().size()) {
                bufOutput.append(";" + this.changeAmount.getHeaderName().getAmount().get(i));
                ++i;
            }
            bufOutput.append("\"/>\n");
            i = 0;
            while (i < this.changeAmount.getAmountList().size()) {
                SmlAmount onerow = (SmlAmount)this.changeAmount.getAmountList().get(i);
                bufOutput.append("<celldesigner:value");
                bufOutput.append(" name=\"" + onerow.getName() + "\"");
                bufOutput.append(" datas=\"" + onerow.getAmount().get(0));
                int j = 1;
                while (j < onerow.getAmount().size()) {
                    try {
                        if (onerow.getAmount().get(j) == null) {
                            bufOutput.append(";null");
                        } else if (onerow.getAmount().get(j) instanceof String) {
                            try {
                                double d = Double.parseDouble((String)onerow.getAmount().get(j));
                                bufOutput.append(";" + d);
                            }
                            catch (Exception myErr) {
                                bufOutput.append(";null");
                            }
                        } else if (onerow.getAmount().get(j) instanceof Integer) {
                            bufOutput.append(";" + onerow.getAmount().get(j));
                        } else if (onerow.getAmount().get(j) instanceof Double) {
                            bufOutput.append(";" + onerow.getAmount().get(j));
                        }
                    }
                    catch (Exception myErr) {
                        bufOutput.append(";null");
                    }
                    ++j;
                }
                bufOutput.append("\"/>\n");
                ++i;
            }
            bufOutput.append("</celldesigner:valuelist>\n");
            bufOutput.append("</celldesigner:changeamount>\n");
        }
        if (this.parameterScan != null) {
            bufOutput.append("<celldesigner:listofparameterscan>\n");
            i = 0;
            while (i < this.parameterScan.getListOfSimPS().size()) {
                row = (SmlSimParameterScan)this.parameterScan.getListOfSimPS().get(i);
                bufOutput.append("<celldesigner:parameterscan");
                bufOutput.append(" doScanParameter=\"" + ((SmlSimParameterScan)row).getDoScanParameter() + "\"");
                bufOutput.append(" valuefrom=\"" + ((SmlSimParameterScan)row).getKindOfParameter() + "\"");
                bufOutput.append(" name=\"" + ((SmlSimParameterScan)row).getName() + "\"");
                bufOutput.append(" from=\"" + ((SmlSimParameterScan)row).getFrom() + "\"");
                bufOutput.append(" to=\"" + ((SmlSimParameterScan)row).getTo() + "\"");
                bufOutput.append(" interval=\"" + ((SmlSimParameterScan)row).getInterval() + "\"");
                bufOutput.append(" />\n");
                ++i;
            }
            bufOutput.append("</celldesigner:listofparameterscan>\n");
        }
        if (this.interactiveSimulation != null) {
            bufOutput.append("<celldesigner:interactivesimulation");
            bufOutput.append(" scanparameter=\"" + this.interactiveSimulation.getKindOfParameter() + "\">\n");
            if (this.interactiveSimulation.getListOfInitial().size() > 0) {
                bufOutput.append("<celldesigner:initialvalue>\n");
                i = 0;
                while (i < this.interactiveSimulation.getListOfInitial().size()) {
                    row = (SmlSliderValue)this.interactiveSimulation.getListOfInitial().get(i);
                    bufOutput.append("<celldesigner:value");
                    bufOutput.append(" name=\"" + ((SmlSliderValue)row).getId() + "\"");
                    bufOutput.append(" min=\"" + ((SmlSliderValue)row).getMin() + "\"");
                    bufOutput.append(" max=\"" + ((SmlSliderValue)row).getMax() + "\"");
                    bufOutput.append(" curr=\"" + ((SmlSliderValue)row).getCurrent() + "\"");
                    bufOutput.append(" />\n");
                    ++i;
                }
                bufOutput.append("</celldesigner:initialvalue>\n");
            }
            if (this.interactiveSimulation.getListOfParameter().size() > 0) {
                bufOutput.append("<celldesigner:parametervalue>\n");
                i = 0;
                while (i < this.interactiveSimulation.getListOfParameter().size()) {
                    row = (SmlSliderValue)this.interactiveSimulation.getListOfParameter().get(i);
                    bufOutput.append("<celldesigner:value");
                    bufOutput.append(" name=\"" + ((SmlSliderValue)row).getId() + "\"");
                    bufOutput.append(" min=\"" + ((SmlSliderValue)row).getMin() + "\"");
                    bufOutput.append(" max=\"" + ((SmlSliderValue)row).getMax() + "\"");
                    bufOutput.append(" curr=\"" + ((SmlSliderValue)row).getCurrent() + "\"");
                    bufOutput.append(" />\n");
                    ++i;
                }
                bufOutput.append("</celldesigner:parametervalue>\n");
            }
            bufOutput.append("</celldesigner:interactivesimulation>\n");
        }
        bufOutput.append("</celldesigner:extension>\n");
        this.appendAdditionAnnotationInfo(bufOutput, false);
        bufOutput.append("</annotation>\n");
    }

    @Override
    protected boolean isNeedAppendCelldExtChildrenInfo() {
        return this.changeAmount != null || this.parameterScan != null || this.interactiveSimulation != null;
    }

    public SmlModel clone() {
        SmlModel newInstance = new SmlModel();
        newInstance.strNotes = this.strNotes;
        newInstance.strOtherAnnotation = this.strOtherAnnotation;
        newInstance.id = this.id;
        newInstance.name = this.name;
        newInstance.type = this.type;
        newInstance.language = this.language;
        newInstance.source = this.source;
        if (this.changeAmount != null) {
            newInstance.changeAmount = this.changeAmount.clone();
        }
        if (this.parameterScan != null) {
            newInstance.parameterScan = this.parameterScan.clone();
        }
        if (this.interactiveSimulation != null) {
            newInstance.interactiveSimulation = this.interactiveSimulation.clone();
        }
        if (this.listOfChanges != null && this.listOfChanges.size() > 0) {
            int i = 0;
            while (i < this.listOfChanges.size()) {
                newInstance.listOfChanges.add(((SmlChangeAttribute)this.listOfChanges.get(i)).clone());
                ++i;
            }
        }
        return newInstance;
    }
}

