/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.sedml.databean;

import java.awt.Color;
import jp.co.mki.celldesigner.simulation.sedml.databean.SEDBase;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlGraphInfo;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPaint;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPlot2D;
import jp.sbi.celldesigner.util.CelldUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmlCurve
extends SEDBase {
    private String name;
    private String id;
    private boolean logX = false;
    private boolean logY = false;
    private String xDataReference;
    private String yDataReference;
    private boolean visible = true;
    private Color color;

    public String getId() {
        return this.id;
    }

    public void setId(String Id) {
        this.id = Id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String Name) {
        this.name = Name;
    }

    public boolean getLogX() {
        return this.logX;
    }

    public void setLogX(boolean logX) {
        this.logX = logX;
    }

    public boolean getLogY() {
        return this.logY;
    }

    public void setLogY(boolean logY) {
        this.logY = logY;
    }

    public String getxDataReference() {
        return this.xDataReference;
    }

    public void setxDataReference(String xDataReference) {
        this.xDataReference = xDataReference;
    }

    public String getyDataReference() {
        return this.yDataReference;
    }

    public void setyDataReference(String yDataReference) {
        this.yDataReference = yDataReference;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public static final void readingDOMTree(SmlCurve onerow, Element sourcedoc) throws Exception {
        if (sourcedoc.getNodeType() == 1) {
            NamedNodeMap map;
            Element elem = sourcedoc;
            String nodename = elem.getNodeName();
            if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename, "curve") && (map = elem.getAttributes()) != null) {
                int k = 0;
                while (k < map.getLength()) {
                    boolean bo;
                    Node item = map.item(k);
                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "id")) {
                        onerow.setId(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "logX")) {
                        bo = true;
                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                            bo = false;
                        }
                        onerow.setLogX(bo);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "logY")) {
                        bo = true;
                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                            bo = false;
                        }
                        onerow.setLogY(bo);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "xDataReference")) {
                        onerow.setxDataReference(item.getNodeValue());
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "yDataReference")) {
                        onerow.setyDataReference(item.getNodeValue());
                    }
                    ++k;
                }
            }
            NodeList childlist1 = elem.getChildNodes();
            int childsize1 = childlist1.getLength();
            int i = 0;
            while (i < childsize1) {
                Node node1 = childlist1.item(i);
                if (node1.getNodeType() == 1) {
                    Element elem1 = (Element)node1;
                    String nodename1 = elem1.getNodeName();
                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "annotation")) {
                        onerow.readAnnotationFromDOMTree(elem1);
                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "notes")) {
                        onerow.readNotesFromDOMTree(elem1);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public void readAnnotationFromDOMTree(Element sourcedoc) throws Exception {
        NodeList childlist1 = sourcedoc.getChildNodes();
        int childsize1 = childlist1.getLength();
        int i = 0;
        while (i < childsize1) {
            Node node1 = childlist1.item(i);
            if (node1.getNodeType() == 1) {
                Element elem1 = (Element)node1;
                String nodename1 = elem1.getNodeName();
                if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename1, "celldesigner:extension")) {
                    NodeList childlist2 = elem1.getChildNodes();
                    int childsize2 = childlist2.getLength();
                    int j = 0;
                    while (j < childsize2) {
                        Node node2 = childlist2.item(j);
                        if (node2.getNodeType() == 1) {
                            NamedNodeMap map;
                            Element elem2 = (Element)node2;
                            String nodename2 = elem2.getNodeName();
                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:visible")) {
                                map = elem2.getAttributes();
                                if (map != null) {
                                    int k = 0;
                                    while (k < map.getLength()) {
                                        Node item = map.item(k);
                                        if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "value")) {
                                            boolean bo = true;
                                            if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeValue(), "false")) {
                                                bo = false;
                                            }
                                            this.setVisible(bo);
                                        }
                                        ++k;
                                    }
                                }
                            } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(nodename2, "celldesigner:color") && (map = elem2.getAttributes()) != null) {
                                int r = -1;
                                int g = -1;
                                int b = -1;
                                int k = 0;
                                while (k < map.getLength()) {
                                    Node item = map.item(k);
                                    if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "r")) {
                                        r = Integer.parseInt(item.getNodeValue());
                                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "g")) {
                                        g = Integer.parseInt(item.getNodeValue());
                                    } else if (CelldUtil.issameIgnoreCaseIgnoreSpace(item.getNodeName(), "b")) {
                                        b = Integer.parseInt(item.getNodeValue());
                                    }
                                    ++k;
                                }
                                this.setColor(new Color(r, g, b));
                            }
                        }
                        ++j;
                    }
                } else {
                    super.readAnnotationFromDOMTree(elem1);
                }
            }
            ++i;
        }
    }

    public static final void createPersistenceXmlData(StringBuffer bufOutput, SmlCurve anyone) throws Exception {
        bufOutput.append("<curve");
        if (anyone.name != null) {
            bufOutput.append(" name=\"" + anyone.name + "\"");
        }
        bufOutput.append(" logX=\"" + anyone.logX + "\"");
        bufOutput.append(" logY=\"" + anyone.logY + "\"");
        if (anyone.xDataReference != null) {
            bufOutput.append(" xDataReference=\"" + anyone.xDataReference + "\"");
        }
        if (anyone.yDataReference != null) {
            bufOutput.append(" yDataReference=\"" + anyone.yDataReference + "\"");
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            bufOutput.append(">\n");
        } else {
            bufOutput.append(" />\n");
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            anyone.appendNotesInfo(bufOutput);
            anyone.appendAnnotationInfo(bufOutput, true);
        }
        if (anyone.isNeedAppendChildrenInfo()) {
            bufOutput.append("</curve>\n");
        }
    }

    public static final void createPersistenceXmlData(StringBuffer bufOutput, SmlPlot2D anyone) throws Exception {
        SmlGraphInfo graphInfo = anyone.getGraphInfo();
        if (graphInfo.getSpeciesPaintSize() > 0 || graphInfo.getFluxesPaintSize() > 0 || graphInfo.getParameteresSize() > 0 || graphInfo.getCompartmentsSize() > 0) {
            SmlPaint paint;
            int i;
            bufOutput.append("<listOfCurves>\n");
            if (graphInfo.getSpeciesPaintSize() > 0) {
                i = 0;
                while (i < graphInfo.getSpeciesPaintSize()) {
                    paint = graphInfo.getSpeciesPaint().get(i);
                    SmlCurve.appendCurveXmlData(bufOutput, paint);
                    ++i;
                }
            }
            if (graphInfo.getFluxesPaintSize() > 0) {
                i = 0;
                while (i < graphInfo.getFluxesPaintSize()) {
                    paint = graphInfo.getFluxesPaint().get(i);
                    SmlCurve.appendCurveXmlData(bufOutput, paint);
                    ++i;
                }
            }
            if (graphInfo.getParameteresSize() > 0) {
                i = 0;
                while (i < graphInfo.getParameteresSize()) {
                    paint = graphInfo.getParameteresPaint().get(i);
                    SmlCurve.appendCurveXmlData(bufOutput, paint);
                    ++i;
                }
            }
            if (graphInfo.getCompartmentsSize() > 0) {
                i = 0;
                while (i < graphInfo.getCompartmentsSize()) {
                    paint = graphInfo.getCompartmentsPaint().get(i);
                    SmlCurve.appendCurveXmlData(bufOutput, paint);
                    ++i;
                }
            }
            bufOutput.append("</listOfCurves>\n");
        } else {
            bufOutput.append("<listOfCurves/>\n");
        }
    }

    private static final void appendCurveXmlData(StringBuffer bufOutput, SmlPaint paint) {
        bufOutput.append("<curve logX=\"false\" logY=\"false");
        bufOutput.append("\" xDataReference=\"time\" yDataReference=\"" + paint.getId() + "\"/>\n");
    }

    @Override
    protected void appendAnnotationInfo(StringBuffer bufOutput, boolean bNeedAnnoTag) {
        bufOutput.append("<annotation>\n");
        bufOutput.append("<celldesigner:extension xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">\n");
        bufOutput.append("<celldesigner:visible");
        bufOutput.append(" value=\"" + this.visible + "\"");
        bufOutput.append(" />\n");
        if (this.color != null) {
            bufOutput.append("<celldesigner:color");
            bufOutput.append(" r=\"" + this.color.getRed() + "\"");
            bufOutput.append(" g=\"" + this.color.getGreen() + "\"");
            bufOutput.append(" b=\"" + this.color.getBlue() + "\"");
            bufOutput.append(" />\n");
        }
        bufOutput.append("</celldesigner:extension>\n");
        this.appendAdditionAnnotationInfo(bufOutput, false);
        bufOutput.append("</annotation>\n");
    }

    @Override
    protected boolean isNeedAppendCelldExtChildrenInfo() {
        return true;
    }

    public SmlCurve clone() {
        SmlCurve newInstance = new SmlCurve();
        newInstance.strNotes = this.strNotes;
        newInstance.strOtherAnnotation = this.strOtherAnnotation;
        newInstance.name = this.name;
        newInstance.logX = this.logX;
        newInstance.logY = this.logY;
        newInstance.xDataReference = this.xDataReference;
        newInstance.yDataReference = this.yDataReference;
        newInstance.visible = this.visible;
        if (this.color != null) {
            newInstance.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }
        return newInstance;
    }
}

