/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.jlibsedml.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAmount;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlChangeAttribute;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlGraphInfo;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlInteractiveSimulation;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlModel;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPaint;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlPlot2D;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimCondition;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSimParameterScan;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlSliderValue;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlTask;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlUniformTimeCourse;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.sbml.SpecInfo;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jmathml.ASTNode;
import org.sedml.Algorithm;
import org.sedml.Annotation;
import org.sedml.Change;
import org.sedml.ChangeAttribute;
import org.sedml.Curve;
import org.sedml.DataGenerator;
import org.sedml.Libsedml;
import org.sedml.Model;
import org.sedml.Notes;
import org.sedml.Output;
import org.sedml.Plot2D;
import org.sedml.SEDMLDocument;
import org.sedml.SedML;
import org.sedml.Simulation;
import org.sedml.Task;
import org.sedml.UniformTimeCourse;
import org.sedml.Variable;
import org.sedml.VariableSymbol;
import org.sedml.XPathTarget;

public class CreateSedml {
    private static final String COPASI = "KISAO:0000088";
    private static final String SOSLIB = "KISAO:0000019";
    private static final String SIMULATION_CORE = "KISAO:0000033";
    private static String level = "";
    private static String version = "";

    public static final SedML createPersistenceSedmlData(SmlSimCondition anyone) throws Exception {
        SEDMLDocument sdoc = new SEDMLDocument();
        SedML sedml = sdoc.getSedMLModel();
        MainWindow.getLastInstance().getFiler();
        SpecInfo spec = SBMLFiler.outputSpec;
        level = String.valueOf(spec.getLevel());
        version = String.valueOf(spec.getVersion());
        Element eleNotes = CreateSedml.getElementFromString(anyone.getSedmlNotes());
        if (eleNotes != null) {
            Notes notes = new Notes(eleNotes);
            sedml.addNote(notes);
        }
        sedml.setModels(CreateSedml.GetModel(anyone.getListOfModels()));
        sedml.setSimulations(CreateSedml.GetSimulation(anyone.getListOfSimulation()));
        sedml.setTasks(CreateSedml.GetTask(anyone.getListOfTasks()));
        if (CreateSedml.appendGeneratorXmlData(anyone) != null) {
            sedml.setDataGenerators(CreateSedml.appendGeneratorXmlData(anyone));
        }
        sedml.setOutputs(CreateSedml.GetOutput(anyone.getListOfOutputs()));
        return sedml;
    }

    private static Element getElementFromString(String s) throws IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        Element element = null;
        try {
            if (s != null && s != "") {
                doc = builder.build((Reader)new StringReader(s));
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        if (doc != null) {
            element = doc.getRootElement();
        }
        return element;
    }

    private static final List<Model> GetModel(ArrayList<Object> listsmlModel) throws IOException {
        ArrayList<Model> listModel = new ArrayList<Model>();
        int i = 0;
        while (i < listsmlModel.size()) {
            Element eleCelAnnot;
            SmlModel smlmodel = (SmlModel)listsmlModel.get(i);
            String id = CreateSedml.FormateValueString(smlmodel.getId());
            String name = CreateSedml.FormateValueString(smlmodel.getName());
            String language = "urn:sedml:language:sbml.level-" + level + ".version-" + version;
            String source = "";
            String temSource = CreateSedml.FormateValueString(smlmodel.getSource());
            if (!temSource.equals("")) {
                File tempFile = new File(temSource.trim());
                source = tempFile.getName();
            }
            Model model = new Model(id, name, language, source);
            ArrayList<Object> listChanges = smlmodel.getListOfChanges();
            int j = 0;
            while (j < listChanges.size()) {
                Element eleAnnot;
                SmlChangeAttribute smlchangeatt = (SmlChangeAttribute)listChanges.get(j);
                String newValue = smlchangeatt.getNewValue();
                XPathTarget xpathtarget = new XPathTarget(smlchangeatt.getTarget());
                ChangeAttribute changeattribute = new ChangeAttribute(xpathtarget, newValue);
                Element eleNotes = CreateSedml.getElementFromString(smlchangeatt.getNotes());
                if (eleNotes != null) {
                    Notes notes = new Notes(eleNotes);
                    changeattribute.addNote(notes);
                }
                if ((eleAnnot = CreateSedml.getElementFromString(smlchangeatt.getOtherAnnotation())) != null) {
                    Annotation annotation = new Annotation(eleAnnot);
                    changeattribute.addAnnotation(annotation);
                }
                model.addChange((Change)changeattribute);
                ++j;
            }
            Element eleNotes = CreateSedml.getElementFromString(smlmodel.getNotes());
            if (eleNotes != null) {
                Notes notes = new Notes(eleNotes);
                model.addNote(notes);
            }
            if ((eleCelAnnot = CreateSedml.appendModelAnnotationInfo(smlmodel)) != null) {
                Annotation annotation = new Annotation(eleCelAnnot);
                model.addAnnotation(annotation);
            }
            listModel.add(model);
            ++i;
        }
        return listModel;
    }

    private static Element appendModelAnnotationInfo(SmlModel smlmodel) {
        SmlInteractiveSimulation interactiveSimulation;
        SmlParameterScan parameterScan;
        SmlChangeAmount changeAmount;
        if (smlmodel.getChangeAmount() == null && smlmodel.getParameterScan() == null && smlmodel.getInteractiveSimulation() == null) {
            return null;
        }
        Element eleAnnot = new Element("extension", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        if (!smlmodel.getSource().equals("")) {
            File tempFile = new File(smlmodel.getSource().trim());
            String path = tempFile.getPath();
            Element elepath = new Element("modelsource", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            elepath.setAttribute("path", path);
            eleAnnot.addContent((Content)elepath);
        }
        if ((changeAmount = smlmodel.getChangeAmount()) != null) {
            Element elechangeamount = new Element("changeamount", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            elechangeamount.setAttribute("value", CreateSedml.FormateValueString(String.valueOf(changeAmount.doChangeAmount())));
            elechangeamount.setAttribute("to", CreateSedml.FormateValueString(changeAmount.getTo()));
            elechangeamount.setAttribute("interval", CreateSedml.FormateValueString(changeAmount.getInterval()));
            Element elevaluelist = new Element("valuelist", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            Element elevalue1 = new Element("value", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            if (changeAmount.getHeaderName() != null) {
                elevalue1.setAttribute("name", CreateSedml.FormateValueString(changeAmount.getHeaderName().getName()));
                if (changeAmount.getHeaderName().getAmount().size() > 0) {
                    String strdatas = String.valueOf(changeAmount.getHeaderName().getAmount().get(0));
                    int i = 1;
                    while (i < changeAmount.getHeaderName().getAmount().size()) {
                        strdatas = String.valueOf(strdatas) + ";" + changeAmount.getHeaderName().getAmount().get(i);
                        ++i;
                    }
                    elevalue1.setAttribute("datas", strdatas);
                }
            }
            elevaluelist.addContent((Content)elevalue1);
            int i = 0;
            while (i < changeAmount.getAmountList().size()) {
                SmlAmount onerow = (SmlAmount)changeAmount.getAmountList().get(i);
                Element elevalue2 = new Element("value", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elevalue2.setAttribute("name", onerow.getName());
                StringBuffer bufOutput = new StringBuffer();
                bufOutput.append(String.valueOf(onerow.getAmount().get(0)));
                int j = 1;
                while (j < onerow.getAmount().size()) {
                    try {
                        if (onerow.getAmount().get(j) == null) {
                            bufOutput.append(";null");
                        } else if (onerow.getAmount().get(j) instanceof String) {
                            try {
                                double d = Double.parseDouble((String)onerow.getAmount().get(j));
                                bufOutput.append(";" + d);
                            }
                            catch (Exception myErr) {
                                bufOutput.append(";null");
                            }
                        } else if (onerow.getAmount().get(j) instanceof Integer) {
                            bufOutput.append(";" + onerow.getAmount().get(j));
                        } else if (onerow.getAmount().get(j) instanceof Double) {
                            bufOutput.append(";" + onerow.getAmount().get(j));
                        }
                    }
                    catch (Exception myErr) {
                        bufOutput.append(";null");
                    }
                    ++j;
                }
                elevalue2.setAttribute("datas", bufOutput.toString());
                elevaluelist.addContent((Content)elevalue2);
                ++i;
            }
            elechangeamount.addContent((Content)elevaluelist);
            eleAnnot.addContent((Content)elechangeamount);
        }
        if ((parameterScan = smlmodel.getParameterScan()) != null) {
            Element elelistparame = new Element("listofparameterscan", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            int i = 0;
            while (i < parameterScan.getListOfSimPS().size()) {
                SmlSimParameterScan row = (SmlSimParameterScan)parameterScan.getListOfSimPS().get(i);
                Element eleparame = new Element("parameterscan", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                eleparame.setAttribute("doScanParameter", String.valueOf(row.getDoScanParameter()));
                eleparame.setAttribute("valuefrom", row.getKindOfParameter());
                eleparame.setAttribute("name", row.getName());
                eleparame.setAttribute("from", String.valueOf(row.getFrom()));
                eleparame.setAttribute("to", String.valueOf(row.getTo()));
                eleparame.setAttribute("interval", String.valueOf(row.getInterval()));
                elelistparame.addContent((Content)eleparame);
                ++i;
            }
            eleAnnot.addContent((Content)elelistparame);
        }
        if ((interactiveSimulation = smlmodel.getInteractiveSimulation()) != null) {
            Element elelintermulation = new Element("interactivesimulation", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            elelintermulation.setAttribute("scanparameter", interactiveSimulation.getKindOfParameter());
            if (interactiveSimulation.getListOfInitial().size() > 0) {
                Element eleinitialvalue = new Element("initialvalue", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                int i = 0;
                while (i < interactiveSimulation.getListOfInitial().size()) {
                    SmlSliderValue row = (SmlSliderValue)interactiveSimulation.getListOfInitial().get(i);
                    Element elevalue = new Element("value", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                    if (row.getId() != null) {
                        if (row.getId().split(":").length > 1) {
                            elevalue.setAttribute("id", row.getId().split(":")[0]);
                            elevalue.setAttribute("name", row.getId().split(":")[1]);
                        } else {
                            elevalue.setAttribute("id", CreateSedml.FormateValueString(row.getReaId()));
                            elevalue.setAttribute("name", CreateSedml.FormateValueString(row.getId()));
                        }
                    }
                    elevalue.setAttribute("min", String.valueOf(row.getMin()));
                    elevalue.setAttribute("max", String.valueOf(row.getMax()));
                    elevalue.setAttribute("curr", String.valueOf(row.getCurrent()));
                    eleinitialvalue.addContent((Content)elevalue);
                    ++i;
                }
                elelintermulation.addContent((Content)eleinitialvalue);
            }
            if (interactiveSimulation.getListOfParameter().size() > 0) {
                Element eleparametervalue = new Element("parametervalue", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                int i = 0;
                while (i < interactiveSimulation.getListOfParameter().size()) {
                    Element elevalue = new Element("value", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                    SmlSliderValue row = (SmlSliderValue)interactiveSimulation.getListOfParameter().get(i);
                    if (row.getId() != null) {
                        if (row.getId().split(":").length > 1) {
                            elevalue.setAttribute("id", row.getId().split(":")[0]);
                            elevalue.setAttribute("name", row.getId().split(":")[1]);
                        } else {
                            elevalue.setAttribute("id", CreateSedml.FormateValueString(row.getReaId()));
                            elevalue.setAttribute("name", CreateSedml.FormateValueString(row.getId()));
                        }
                    }
                    elevalue.setAttribute("min", String.valueOf(row.getMin()));
                    elevalue.setAttribute("max", String.valueOf(row.getMax()));
                    elevalue.setAttribute("curr", String.valueOf(row.getCurrent()));
                    eleparametervalue.addContent((Content)elevalue);
                    ++i;
                }
                elelintermulation.addContent((Content)eleparametervalue);
            }
            eleAnnot.addContent((Content)elelintermulation);
        }
        return eleAnnot;
    }

    private static final List<Simulation> GetSimulation(ArrayList<Object> listsmlSimulation) throws IOException {
        ArrayList<Simulation> listSimulation = new ArrayList<Simulation>();
        int i = 0;
        while (i < listsmlSimulation.size()) {
            SmlUniformTimeCourse smlSimulation = (SmlUniformTimeCourse)listsmlSimulation.get(i);
            String id = "simulation_" + smlSimulation.getId();
            String name = CreateSedml.FormateValueString(smlSimulation.getName());
            if (name.equals("")) {
                name = "name_" + id;
            }
            double initialTime = Double.parseDouble(smlSimulation.getInitialTime());
            double outputStartTime = Double.parseDouble(smlSimulation.getOutputStartTime());
            double outputEndTime = Double.parseDouble(smlSimulation.getOutputEndTime());
            int numberOfPoints = smlSimulation.getNumberOfPoints();
            String strAlgorithm = smlSimulation.getAlgorithm();
            if (smlSimulation.getAlgorithm().equals("SOSlib")) {
                strAlgorithm = SOSLIB;
            } else if (smlSimulation.getAlgorithm().equals("COPASI")) {
                strAlgorithm = COPASI;
            } else if (smlSimulation.getAlgorithm().equals("SimulationCore")) {
                strAlgorithm = SIMULATION_CORE;
            }
            Algorithm algorithm = new Algorithm(strAlgorithm);
            UniformTimeCourse simulation = new UniformTimeCourse(id, name, initialTime, outputStartTime, outputEndTime, numberOfPoints, algorithm);
            Element eleNotes = CreateSedml.getElementFromString(smlSimulation.getNotes());
            if (eleNotes != null) {
                Notes notes = new Notes(eleNotes);
                simulation.addNote(notes);
            }
            ArrayList<Annotation> listAnnot = new ArrayList<Annotation>();
            Element eleCelAnnot = CreateSedml.appendUniformTimeCourseAnnotationInfo(smlSimulation);
            if (eleCelAnnot != null) {
                Annotation annotation = new Annotation(eleCelAnnot);
                listAnnot.add(annotation);
            }
            simulation.setAnnotation(listAnnot);
            listSimulation.add((Simulation)simulation);
            ++i;
        }
        return listSimulation;
    }

    private static Element appendUniformTimeCourseAnnotationInfo(SmlUniformTimeCourse smlSimulation) {
        Element eleAnnot = new Element("extension", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        Element eleerror = new Element("errortolerance", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        eleerror.setAttribute("exp", String.valueOf(smlSimulation.getErrortolerance()));
        eleAnnot.addContent((Content)eleerror);
        Element eleSolver = new Element("solver", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        eleSolver.setAttribute("name", String.valueOf(smlSimulation.getSolver()));
        eleAnnot.addContent((Content)eleSolver);
        return eleAnnot;
    }

    private static final List<Task> GetTask(ArrayList<Object> listsmlTask) throws IOException {
        ArrayList<Task> listTask = new ArrayList<Task>();
        int i = 0;
        while (i < listsmlTask.size()) {
            Element eleAnnot;
            SmlTask smltask = (SmlTask)listsmlTask.get(i);
            String id = smltask.getId();
            String name = smltask.getName();
            String modelReference = smltask.getModelReference();
            String simulationReference = "simulation_" + smltask.getSimulationReference();
            Task task = new Task(id, name, modelReference, simulationReference);
            Element eleNotes = CreateSedml.getElementFromString(smltask.getNotes());
            if (eleNotes != null) {
                Notes notes = new Notes(eleNotes);
                task.addNote(notes);
            }
            if ((eleAnnot = CreateSedml.getElementFromString(smltask.getOtherAnnotation())) != null) {
                Annotation annotation = new Annotation(eleAnnot);
                task.addAnnotation(annotation);
            }
            listTask.add(task);
            ++i;
        }
        return listTask;
    }

    private static final List<Output> GetOutput(ArrayList<Object> listsmlOutput) throws Exception {
        ArrayList<Output> listPlot2D = new ArrayList<Output>();
        int i = 0;
        while (i < listsmlOutput.size()) {
            SmlPlot2D smlplot2d = (SmlPlot2D)listsmlOutput.get(i);
            String id = smlplot2d.getId();
            String name = CreateSedml.FormateValueString(smlplot2d.getName());
            Plot2D plot2d = new Plot2D(id, name);
            CreateSedml.createPersistenceXmlData(plot2d, smlplot2d);
            Element eleNotes = CreateSedml.getElementFromString(smlplot2d.getNotes());
            if (eleNotes != null) {
                Notes notes = new Notes(eleNotes);
                plot2d.addNote(notes);
            }
            ArrayList<Annotation> listAnnot = new ArrayList<Annotation>();
            Element eleCelAnnot = CreateSedml.appendOutputAnnotationInfo(smlplot2d);
            if (eleCelAnnot != null) {
                Annotation annotation = new Annotation(eleCelAnnot);
                listAnnot.add(annotation);
            }
            plot2d.setAnnotation(listAnnot);
            listPlot2D.add((Output)plot2d);
            ++i;
        }
        return listPlot2D;
    }

    private static final List<DataGenerator> appendGeneratorXmlData(SmlSimCondition anyone) {
        ArrayList<DataGenerator> listDataGenerator = null;
        if (anyone.getListOfOutputs() != null && anyone.getListOfOutputs().size() > 0) {
            int iOutputsCnt = anyone.getListOfOutputs().size();
            int i = 0;
            while (i < iOutputsCnt) {
                SmlPlot2D plot2d = (SmlPlot2D)anyone.getListOfOutputs().get(i);
                SmlGraphInfo graph = plot2d.getGraphInfo();
                if (graph.getCompartmentsSize() > 0 || graph.getSpeciesPaintSize() > 0 || graph.getFluxesPaintSize() > 0 || graph.getParameteresSize() > 0) {
                    String targetKind;
                    SmlPaint paint;
                    listDataGenerator = new ArrayList<DataGenerator>();
                    listDataGenerator.add(CreateSedml.createPersistenceXmlData(null, plot2d.getTaskref(), null));
                    int j = 0;
                    while (j < plot2d.getGraphInfo().getSpeciesPaintSize()) {
                        paint = plot2d.getGraphInfo().getSpeciesPaint().get(j);
                        if (paint.getId() != null) {
                            targetKind = "sbml:sbml/sbml:model/sbml:listOfSpecies/sbml:species";
                            listDataGenerator.add(CreateSedml.createPersistenceXmlData(paint, plot2d.getTaskref(), targetKind));
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < plot2d.getGraphInfo().getFluxesPaintSize()) {
                        paint = plot2d.getGraphInfo().getFluxesPaint().get(j);
                        if (paint.getId() != null) {
                            targetKind = "sbml:sbml/sbml:model/sbml:listOfReactions/sbml:reaction";
                            listDataGenerator.add(CreateSedml.createPersistenceXmlData(paint, plot2d.getTaskref(), targetKind));
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < plot2d.getGraphInfo().getParameteresSize()) {
                        paint = plot2d.getGraphInfo().getParameteresPaint().get(j);
                        if (paint.getId() != null) {
                            targetKind = "sbml:sbml/sbml:model/sbml:listOfParameters/sbml:parameter";
                            listDataGenerator.add(CreateSedml.createPersistenceXmlData(paint, plot2d.getTaskref(), targetKind));
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < plot2d.getGraphInfo().getCompartmentsSize()) {
                        paint = plot2d.getGraphInfo().getCompartmentsPaint().get(j);
                        if (paint.getId() != null) {
                            targetKind = "sbml:sbml/sbml:model/sbml:listOfCompartments/sbml:compartment";
                            listDataGenerator.add(CreateSedml.createPersistenceXmlData(paint, plot2d.getTaskref(), targetKind));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return listDataGenerator;
    }

    public static final DataGenerator createPersistenceXmlData(SmlPaint anyone, String taskref, String targetKind) {
        if (anyone == null) {
            return CreateSedml.appendGeneratorXmlData("time", "time", taskref, "time");
        }
        return CreateSedml.appendGeneratorXmlData(anyone.getId(), anyone.getName(), taskref, targetKind);
    }

    private static final DataGenerator appendGeneratorXmlData(String id, String name, String taskref, String targetKind) {
        Variable variable;
        String vid = "Variable_" + id;
        String target = "/" + targetKind + "[@id='" + id + "']";
        ASTNode OK_MATH = Libsedml.parseFormulaString((String)vid);
        DataGenerator datagenerator = new DataGenerator(id, name, OK_MATH);
        if (targetKind.equals("time")) {
            Object VarSymbol = null;
            variable = new Variable(vid, "name_" + id, taskref, VariableSymbol.getVariableSymbolFor((String)"urn:sedml:symbol:time"));
        } else {
            variable = new Variable(vid, "name_" + id, taskref, target);
        }
        datagenerator.addVariable(variable);
        return datagenerator;
    }

    private static final void createPersistenceXmlData(Plot2D plot2d, SmlPlot2D anyone) throws Exception {
        SmlGraphInfo graphInfo = anyone.getGraphInfo();
        if (graphInfo.getSpeciesPaintSize() > 0 || graphInfo.getFluxesPaintSize() > 0 || graphInfo.getParameteresSize() > 0 || graphInfo.getCompartmentsSize() > 0) {
            SmlPaint paint;
            int i;
            if (graphInfo.getSpeciesPaintSize() > 0) {
                i = 0;
                while (i < graphInfo.getSpeciesPaintSize()) {
                    paint = graphInfo.getSpeciesPaint().get(i);
                    if (paint.getId() != null) {
                        plot2d.addCurve(CreateSedml.appendCurveXmlData(plot2d, paint));
                    }
                    ++i;
                }
            }
            if (graphInfo.getFluxesPaintSize() > 0) {
                i = 0;
                while (i < graphInfo.getFluxesPaintSize()) {
                    paint = graphInfo.getFluxesPaint().get(i);
                    if (paint.getId() != null) {
                        plot2d.addCurve(CreateSedml.appendCurveXmlData(plot2d, paint));
                    }
                    ++i;
                }
            }
            if (graphInfo.getParameteresSize() > 0) {
                i = 0;
                while (i < graphInfo.getParameteresSize()) {
                    paint = graphInfo.getParameteresPaint().get(i);
                    if (paint.getId() != null) {
                        plot2d.addCurve(CreateSedml.appendCurveXmlData(plot2d, paint));
                    }
                    ++i;
                }
            }
            if (graphInfo.getCompartmentsSize() > 0) {
                i = 0;
                while (i < graphInfo.getCompartmentsSize()) {
                    paint = graphInfo.getCompartmentsPaint().get(i);
                    if (paint.getId() != null) {
                        plot2d.addCurve(CreateSedml.appendCurveXmlData(plot2d, paint));
                    }
                    ++i;
                }
            }
        }
    }

    private static final Curve appendCurveXmlData(Plot2D plot2d, SmlPaint paint) {
        String cid = String.valueOf(paint.getId()) + plot2d.getId();
        String cname = "Curve_" + paint.getId();
        boolean logX = false;
        boolean logY = false;
        String xDataReference = "time";
        String yDataReference = CreateSedml.FormateValueString(paint.getId());
        Curve curve = new Curve(cid, cname, logX, logY, xDataReference, yDataReference);
        return curve;
    }

    private static Element appendOutputAnnotationInfo(SmlPlot2D smlplot2d) {
        Element elePaint;
        if (smlplot2d.getTaskref() == null && smlplot2d.getGraphInfo() == null) {
            return null;
        }
        Element eleAnnot = new Element("extension", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        Element eleTaskref = new Element("taskref", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        eleTaskref.setAttribute("id", CreateSedml.FormateValueString(smlplot2d.getTaskref()));
        eleAnnot.addContent((Content)eleTaskref);
        Element eleAddition = new Element("addition", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        eleAddition.setAttribute("ymax", String.valueOf(smlplot2d.getGraphInfo().getYmax()));
        eleAddition.setAttribute("o", String.valueOf(smlplot2d.getGraphInfo().getO()));
        eleAddition.setAttribute("xperscreen", String.valueOf(smlplot2d.getGraphInfo().getXperscreen()));
        eleAddition.setAttribute("concentration", smlplot2d.getGraphInfo().getConcentration());
        eleAddition.setAttribute("species", String.valueOf(smlplot2d.getGraphInfo().isSpecies()));
        eleAddition.setAttribute("fluxes", String.valueOf(smlplot2d.getGraphInfo().isFluxes()));
        eleAddition.setAttribute("parameters", String.valueOf(smlplot2d.getGraphInfo().isParameters()));
        eleAddition.setAttribute("compartments", String.valueOf(smlplot2d.getGraphInfo().isCompartments()));
        eleAnnot.addContent((Content)eleAddition);
        Element eleScatterplot = new Element("scatterplot", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        eleScatterplot.setAttribute("show", String.valueOf(smlplot2d.getGraphInfo().isShow()));
        eleScatterplot.setAttribute("reverse", String.valueOf(smlplot2d.getGraphInfo().isReverse()));
        eleAnnot.addContent((Content)eleScatterplot);
        if (smlplot2d.getGraphInfo().getSpeciesPaintSize() > 0 || smlplot2d.getGraphInfo().getFluxesPaintSize() > 0 || smlplot2d.getGraphInfo().getParameteresSize() > 0 || smlplot2d.getGraphInfo().getCompartmentsSize() > 0) {
            Element elePaintDetail;
            SmlPaint paint;
            int i;
            Element elePaintinfo;
            elePaint = new Element("paint", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            if (smlplot2d.getGraphInfo().getSpeciesPaintSize() > 0) {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "species");
                elePaint.addContent((Content)elePaintinfo);
                i = 0;
                while (i < smlplot2d.getGraphInfo().getSpeciesPaintSize()) {
                    paint = smlplot2d.getGraphInfo().getSpeciesPaint().get(i);
                    if (paint.getId() != null) {
                        elePaintDetail = CreateSedml.appendAnnotationInfo(paint);
                        elePaintinfo.addContent((Content)elePaintDetail);
                    }
                    ++i;
                }
            } else {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "species");
                elePaint.addContent((Content)elePaintinfo);
            }
            if (smlplot2d.getGraphInfo().getFluxesPaintSize() > 0) {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "fluxes");
                elePaint.addContent((Content)elePaintinfo);
                i = 0;
                while (i < smlplot2d.getGraphInfo().getFluxesPaintSize()) {
                    paint = smlplot2d.getGraphInfo().getFluxesPaint().get(i);
                    if (paint.getId() != null) {
                        elePaintDetail = CreateSedml.appendAnnotationInfo(paint);
                        elePaintinfo.addContent((Content)elePaintDetail);
                    }
                    ++i;
                }
            } else {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "fluxes");
                elePaint.addContent((Content)elePaintinfo);
            }
            if (smlplot2d.getGraphInfo().getParameteresSize() > 0) {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "parameters");
                elePaint.addContent((Content)elePaintinfo);
                i = 0;
                while (i < smlplot2d.getGraphInfo().getParameteresSize()) {
                    paint = smlplot2d.getGraphInfo().getParameteresPaint().get(i);
                    if (paint.getId() != null) {
                        elePaintDetail = CreateSedml.appendAnnotationInfo(paint);
                        elePaintinfo.addContent((Content)elePaintDetail);
                    }
                    ++i;
                }
            } else {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "parameters");
                elePaint.addContent((Content)elePaintinfo);
            }
            if (smlplot2d.getGraphInfo().getCompartmentsSize() > 0) {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "compartments");
                elePaint.addContent((Content)elePaintinfo);
                i = 0;
                while (i < smlplot2d.getGraphInfo().getCompartmentsSize()) {
                    paint = smlplot2d.getGraphInfo().getCompartmentsPaint().get(i);
                    if (paint.getId() != null) {
                        elePaintDetail = CreateSedml.appendAnnotationInfo(paint);
                        elePaintinfo.addContent((Content)elePaintDetail);
                    }
                    ++i;
                }
            } else {
                elePaintinfo = new Element("paintinfo", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                elePaintinfo.setAttribute("type", "compartments");
                elePaint.addContent((Content)elePaintinfo);
            }
            eleAnnot.addContent((Content)elePaint);
        } else {
            elePaint = new Element("paint", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            eleAnnot.addContent((Content)elePaint);
        }
        if (smlplot2d.getResultofList() != null && smlplot2d.getResultofList().size() > 0) {
            Element eleResultinfo = new Element("listOfResult", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
            int index = 0;
            while (index < smlplot2d.getResultofList().size()) {
                SBMLResults resoutinfo = smlplot2d.getResultofList().get(index);
                String path = String.valueOf(smlplot2d.getOutputPath()) + "_Result" + File.separator + smlplot2d.getTaskref() + "_result";
                Element eleResoutinfo = new Element("result", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
                eleResoutinfo.setAttribute("id", resoutinfo.getParameterInfo());
                eleResoutinfo.setAttribute("source", String.valueOf(path) + File.separator + "result" + resoutinfo.getParameterInfo() + ".txt");
                eleResoutinfo.setAttribute("visible", String.valueOf(resoutinfo.isVisible()));
                eleResultinfo.addContent((Content)eleResoutinfo);
                ++index;
            }
            eleAnnot.addContent((Content)eleResultinfo);
        }
        return eleAnnot;
    }

    protected static Element appendAnnotationInfo(SmlPaint paint) {
        Element elePlot = new Element("plot", "celldesigner", "http://www.sbml.org/2001/ns/celldesigner");
        elePlot.setAttribute("id", paint.getId());
        elePlot.setAttribute("name", String.valueOf(paint.getName()));
        elePlot.setAttribute("r", String.valueOf(paint.getColor().getRed()));
        elePlot.setAttribute("g", String.valueOf(paint.getColor().getGreen()));
        elePlot.setAttribute("b", String.valueOf(paint.getColor().getBlue()));
        elePlot.setAttribute("reaction_Id", "");
        elePlot.setAttribute("visible", String.valueOf(paint.getVisible()));
        return elePlot;
    }

    private static String FormateValueString(String strValue) {
        if (strValue == null) {
            strValue = "";
        }
        return strValue;
    }
}

