/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class TriangleIcon
implements Icon {
    private int top = 0;
    private int drawType = 0;
    private int iconWidth = 12;
    private int iconHeight = 12;
    public static int TOP = 0;
    public static int BOTTOM = 1;
    public static int LEFT = 2;
    public static int RIGHT = 3;
    public static int DRAW = 0;
    public static int FILL = 1;

    public TriangleIcon() {
    }

    public TriangleIcon(int top, int drawType) {
        this.top = top;
        this.drawType = drawType;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setDrawType(int drawType) {
        this.drawType = drawType;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int[] xx = new int[4];
        int[] yy = new int[4];
        Color tColor = g.getColor();
        g.setColor(Color.black);
        boolean flag = false;
        if (this.top == TOP) {
            xx[0] = x + this.iconWidth / 2;
            yy[0] = y + 1;
            xx[1] = x;
            yy[1] = y + this.iconHeight - 1;
            xx[2] = x + this.iconWidth - 1;
            yy[2] = y + this.iconHeight - 1;
            xx[3] = x + this.iconWidth / 2;
            yy[3] = y + 1;
            flag = true;
        } else if (this.top == BOTTOM) {
            xx[0] = x + this.iconWidth / 2;
            yy[0] = y + this.iconHeight - 1;
            xx[1] = x;
            yy[1] = y + 1;
            xx[2] = x + this.iconWidth - 1;
            yy[2] = y + 1;
            xx[3] = x + this.iconWidth / 2;
            yy[3] = y + this.iconHeight - 1;
            flag = true;
        } else if (this.top == LEFT) {
            xx[0] = x + 1;
            yy[0] = y + this.iconHeight / 2;
            xx[1] = x + this.iconWidth - 1;
            yy[1] = y;
            xx[2] = x + this.iconWidth - 1;
            yy[2] = y + this.iconHeight;
            xx[3] = x + 1;
            yy[3] = y + this.iconHeight / 2;
            flag = true;
        } else if (this.top == RIGHT) {
            xx[0] = x + this.iconWidth - 1;
            yy[0] = y + this.iconHeight / 2;
            xx[1] = x + 1;
            yy[1] = y;
            xx[2] = x + 1;
            yy[2] = y + this.iconHeight;
            xx[3] = x + this.iconWidth - 1;
            yy[3] = y + this.iconHeight / 2;
            flag = true;
        }
        if (flag) {
            if (this.drawType == DRAW) {
                g.drawPolygon(xx, yy, 4);
            } else if (this.drawType == FILL) {
                g.fillPolygon(xx, yy, 4);
            }
        }
        g.setColor(tColor);
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int width) {
        if (width > 0) {
            this.iconWidth = width;
        }
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int height) {
        if (height > 0) {
            this.iconHeight = height;
        }
    }
}

