/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.mki.celldesigner.simulation.controlpanel.ScaleData;

public class TimeSeriesPanel
extends JPanel
implements Runnable {
    private Thread runner = null;
    private boolean blinkMode = true;
    private boolean drawEnd = true;
    private Color blinkColor = Color.GREEN;
    private BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f, 0.0f}, 0.0f);
    private BasicStroke basicStroke2 = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f, 0.0f}, 0.0f);
    private static int DISTANCE = 3;
    private Vector listenerList = null;
    private Vector selectChanglistenerList = null;
    private Vector timeList = null;
    private Vector dataList = null;
    private double maxTimeOfDraw = 0.0;
    private double minTimeOfDraw = 0.0;
    private double maxRange = 0.0;
    private double minRange = 0.0;
    private double startTime = 0.0;
    private double endTime = 0.0;
    private boolean isChanged = false;
    private boolean isDrawSamplingPointFlag = false;
    private Object[] xPosList;
    private Object[] yPosList;
    private Vector lineColorList = null;
    private Vector lineVisibleList = null;
    private int selectionFirstVisibleLineIndex = -1;
    private boolean[] sel = null;
    private Vector selectedDataVector = new Vector();
    private boolean isDragging = false;
    private int fx;
    private int fy;
    private int tx;
    private int ty;
    private int px;
    private int py;
    private Vector xScaleVector = new Vector();
    private Vector yScaleVector = new Vector();
    private static final double Log10 = Math.log(10.0);
    private static final double Log10_2 = Math.log(2.0) / Math.log(10.0);
    private static final double Log10_5 = Math.log(5.0) / Math.log(10.0);

    public TimeSeriesPanel() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                TimeSeriesPanel.this.isChanged = true;
                TimeSeriesPanel.this.fireStateChanged();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    TimeSeriesPanel.this.this_mouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    TimeSeriesPanel.this.this_mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    TimeSeriesPanel.this.this_mouseReleased(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    TimeSeriesPanel.this.this_mouseDragged(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TimeSeriesPanel.this.this_mouseMoved(e);
            }
        });
    }

    public void setData(Vector timeList, Vector dataList) {
        this.timeList = timeList;
        this.dataList = dataList;
        this.sel = new boolean[timeList.size()];
        this.startTime = Double.MAX_VALUE;
        this.endTime = 0.0;
        for (double[] d : timeList) {
            if (this.startTime > d[0]) {
                this.startTime = d[0];
            }
            if (!(this.endTime < d[d.length - 1])) continue;
            this.endTime = d[d.length - 1];
        }
        this.isChanged = true;
        this.fireStateChanged();
        this.repaint();
    }

    public void setLineColor(Vector color) {
        this.lineColorList = color;
    }

    public void setLineVisible(Vector visible) {
        this.lineVisibleList = visible;
    }

    public void setSelectionFirstVisibleLineIndex(int index) {
        this.selectionFirstVisibleLineIndex = index;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color c = g.getColor();
        g.setColor(Color.GRAY);
        g.drawLine(0, 0, 0, this.getHeight());
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        if (this.isChanged) {
            this.calcGraphCoordinate();
        }
        this.drawGraph(g);
        this.drawScale(g);
        if (this.isDragging) {
            g.setColor(Color.BLUE);
            g.drawRect(this.fx, this.fy, this.tx - this.fx, this.ty - this.fy);
        }
        g.setColor(c);
    }

    private void calcGraphCoordinate() {
        if (this.timeList == null || this.dataList == null) {
            this.isChanged = false;
            return;
        }
        double xScale = (double)this.getWidth() / (this.maxTimeOfDraw - this.minTimeOfDraw);
        double yScale = (double)this.getHeight() / (this.maxRange - this.minRange);
        int size = this.timeList.size();
        this.xPosList = null;
        this.yPosList = null;
        this.xPosList = new Object[size];
        this.yPosList = new Object[size];
        int maxTimeValueCount = 0;
        int maxTimeValueIndex = 0;
        int i = 0;
        while (i < size) {
            double[] valTime = (double[])this.timeList.elementAt(i);
            double[] valData = (double[])this.dataList.elementAt(i);
            int[] valX = new int[valTime.length];
            int[] valY = new int[valTime.length];
            if (valTime.length > maxTimeValueCount) {
                maxTimeValueCount = valTime.length;
                maxTimeValueIndex = i;
            }
            int j = 0;
            while (j < valTime.length) {
                double xp = (valTime[j] - this.minTimeOfDraw) * xScale;
                valX[j] = (int)xp;
                if (Double.isNaN(valData[j]) || Double.isInfinite(valData[j])) {
                    valY[j] = 0;
                } else {
                    double yp = (double)this.getHeight() - (valData[j] - this.minRange) * yScale;
                    valY[j] = (int)yp;
                }
                ++j;
            }
            this.xPosList[i] = valX;
            this.yPosList[i] = valY;
            ++i;
        }
        this.isChanged = false;
    }

    private void makeScaleData() {
        int i;
        this.xScaleVector.clear();
        double xScale = (double)this.getWidth() / (this.maxTimeOfDraw - this.minTimeOfDraw);
        double d = this.calculateDelta(this.minTimeOfDraw, this.maxTimeOfDraw);
        double id = 1.0 / d;
        int minT = (int)(this.minTimeOfDraw * id);
        int maxT = (int)(this.maxTimeOfDraw * id);
        if (this.maxTimeOfDraw > this.endTime) {
            maxT = (int)(this.endTime * id);
        }
        double delta = 0.0;
        if (d != 0.0) {
            delta = Math.log(d) / Log10;
        }
        StringBuffer sb = new StringBuffer("0");
        if (delta < 0.0) {
            int i2 = (int)delta;
            while (i2 <= 0) {
                if (sb.length() == 1) {
                    sb.append(".");
                }
                sb.append("0");
                ++i2;
            }
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        int i3 = minT;
        while (i3 <= maxT) {
            double xp = ((double)i3 * d - this.minTimeOfDraw) * xScale;
            if (!(xp < 0.0)) {
                ScaleData sd = new ScaleData(df.format((double)i3 * d), new Point((int)xp - 1, this.getHeight() - 1));
                this.xScaleVector.add(sd);
            }
            ++i3;
        }
        this.yScaleVector.clear();
        double yScale = (double)this.getHeight() / (this.maxRange - this.minRange);
        d = this.calculateDelta(this.minRange, this.maxRange);
        id = 1.0 / d;
        int minR = (int)(this.minRange * id);
        int maxR = (int)(this.maxRange * id);
        delta = 0.0;
        if (d != 0.0) {
            delta = Math.log(d) / Log10;
        }
        sb.delete(1, sb.length());
        if (delta < 0.0) {
            i = (int)delta;
            while (i <= 0) {
                if (sb.length() == 1) {
                    sb.append(".");
                }
                sb.append("0");
                ++i;
            }
        }
        df = new DecimalFormat(sb.toString());
        i = minR;
        while (i <= maxR) {
            double yp = ((double)i * d - this.minRange) * yScale;
            if (!(yp < 0.0)) {
                ScaleData sd = new ScaleData(df.format((double)i * d), new Point(0, this.getHeight() - (int)yp - 1));
                this.yScaleVector.add(sd);
            }
            ++i;
        }
        ScaleData sd = new ScaleData(df.format(this.maxRange), new Point(0, 0));
        this.yScaleVector.add(sd);
    }

    private double calculateDelta(double min, double max) {
        double ord;
        double delta = Math.log(max - min) / Log10;
        double dif = delta - (ord = Math.floor(delta));
        delta = dif < Log10_2 ? Math.pow(10.0, ord - 1.0) * 2.0 : (dif < Log10_5 ? Math.pow(10.0, ord - 1.0) * 5.0 : Math.pow(10.0, ord));
        return delta;
    }

    private void drawGraph(Graphics g) {
        this.drawEnd = false;
        Graphics2D g2d = (Graphics2D)g;
        Stroke defaultStroke = g2d.getStroke();
        g2d.setStroke(this.basicStroke);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color c = g.getColor();
        int i = 0;
        while (i < this.xPosList.length) {
            if (!(this.lineVisibleList != null && this.lineVisibleList.size() > 0 && !((Boolean)this.lineVisibleList.get(i)).booleanValue() || this.blinkMode && this.sel[i])) {
                if (this.lineColorList != null && this.lineColorList.get(i) != null) {
                    g.setColor((Color)this.lineColorList.get(i));
                } else {
                    g.setColor(new Color(i % 128, i % 128, i % 128));
                }
                int[] x = (int[])this.xPosList[i];
                int[] y = (int[])this.yPosList[i];
                if (x.length >= 2) {
                    int j = 1;
                    while (j < x.length) {
                        g2d.drawLine(x[j - 1], y[j - 1], x[j], y[j]);
                        ++j;
                    }
                    x = null;
                    y = null;
                }
            }
            ++i;
        }
        if (this.blinkMode) {
            int selCount = 0;
            g2d.setStroke(this.basicStroke2);
            int i2 = 0;
            while (i2 < this.xPosList.length) {
                if ((this.lineVisibleList == null || this.lineVisibleList.size() <= 0 || ((Boolean)this.lineVisibleList.get(i2)).booleanValue()) && this.sel[i2]) {
                    int[] x = (int[])this.xPosList[i2];
                    int[] y = (int[])this.yPosList[i2];
                    if (x.length >= 2) {
                        if (i2 != this.selectionFirstVisibleLineIndex) {
                            g.setColor(new Color(0, 255 - selCount * 21 % 255, 0));
                        }
                        ++selCount;
                        int j = 1;
                        while (j < x.length) {
                            g2d.drawLine(x[j - 1], y[j - 1], x[j], y[j]);
                            ++j;
                        }
                        x = null;
                        y = null;
                    }
                }
                ++i2;
            }
        }
        if (this.selectionFirstVisibleLineIndex != -1 && (this.lineVisibleList == null || this.lineVisibleList.size() <= 0 || ((Boolean)this.lineVisibleList.get(this.selectionFirstVisibleLineIndex)).booleanValue())) {
            int[] x = (int[])this.xPosList[this.selectionFirstVisibleLineIndex];
            int[] y = (int[])this.yPosList[this.selectionFirstVisibleLineIndex];
            if (x.length >= 2 && this.sel[this.selectionFirstVisibleLineIndex] && this.blinkMode) {
                g.setColor(this.blinkColor);
                int j = 1;
                while (j < x.length) {
                    g2d.drawLine(x[j - 1], y[j - 1], x[j], y[j]);
                    ++j;
                }
            }
        }
        g2d.setStroke(defaultStroke);
        g.setColor(c);
        this.drawEnd = true;
    }

    private void drawScale(Graphics g) {
        Point p;
        ScaleData sd;
        g.setColor(Color.GRAY);
        int i = 0;
        while (i < this.xScaleVector.size()) {
            sd = (ScaleData)this.xScaleVector.get(i);
            p = sd.getPoint();
            g.drawLine((int)p.getX(), (int)p.getY(), (int)p.getX(), (int)p.getY() - 5);
            ++i;
        }
        i = 0;
        while (i < this.yScaleVector.size()) {
            sd = (ScaleData)this.yScaleVector.get(i);
            p = sd.getPoint();
            g.drawLine((int)p.getX(), (int)p.getY(), (int)p.getX() + 5, (int)p.getY());
            ++i;
        }
    }

    public Vector getSelectedData() {
        this.selectedDataVector.clear();
        if (this.sel == null) {
            return this.selectedDataVector;
        }
        int i = 0;
        while (i < this.sel.length) {
            if (this.sel[i]) {
                this.selectedDataVector.add(new Integer(i));
            }
            ++i;
        }
        return this.selectedDataVector;
    }

    int getDataOnPoint(int ex, int ey) {
        int x1 = ex - DISTANCE;
        int x2 = ex + DISTANCE;
        int y1 = ey - DISTANCE;
        int y2 = ey + DISTANCE;
        double[] p1 = new double[]{x1, y1};
        double[] p2 = new double[]{x2, y2};
        double[] p3 = new double[2];
        double[] p4 = new double[2];
        double[] ap1 = new double[2];
        int i = 0;
        while (i < this.xPosList.length) {
            int[] x = (int[])this.xPosList[i];
            int[] y = (int[])this.yPosList[i];
            if (x.length >= 2) {
                int j = 1;
                while (j < x.length) {
                    p3[0] = x[j - 1];
                    p3[1] = y[j - 1];
                    p4[0] = x[j];
                    p4[1] = y[j];
                    if (x1 < x[j] && x[j] < x2 && x1 < x[j - 1] && x[j - 1] < x2 && y1 < y[j] && y[j] < y2 && y1 < y[j - 1] && y[j - 1] < y2) {
                        return i;
                    }
                    p1[0] = x1;
                    p1[1] = y1;
                    p2[0] = x1;
                    p2[1] = y2;
                    if (this.getCrossPoint(ap1, p1, p2, p3, p4)) {
                        return i;
                    }
                    p1[0] = x2;
                    p1[1] = y2;
                    p2[0] = x1;
                    p2[1] = y2;
                    if (this.getCrossPoint(ap1, p1, p2, p3, p4)) {
                        return i;
                    }
                    p1[0] = x1;
                    p1[1] = y1;
                    p2[0] = x2;
                    p2[1] = y1;
                    if (this.getCrossPoint(ap1, p1, p2, p3, p4)) {
                        return i;
                    }
                    p1[0] = x1;
                    p1[1] = y2;
                    p2[0] = x2;
                    p2[1] = y2;
                    if (this.getCrossPoint(ap1, p1, p2, p3, p4)) {
                        return i;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    void setSelectedData(Vector selectData) {
        boolean flag = false;
        Iterator itr = selectData.iterator();
        while (itr.hasNext()) {
            int i = (Integer)itr.next();
            if (i >= this.sel.length || i < 0) continue;
            this.sel[i] = true;
            flag = true;
        }
        if (flag) {
            this.startBlink();
        } else {
            this.stopBlink();
        }
    }

    void this_mouseClicked(MouseEvent e) {
        int i;
        int index = this.getDataOnPoint(e.getX(), e.getY());
        if (e.isControlDown()) {
            if (index >= 0) {
                this.sel[index] = !this.sel[index];
            }
        } else {
            i = 0;
            while (i < this.xPosList.length) {
                this.sel[i] = i == index;
                ++i;
            }
        }
        this.fireSelectStateChanged();
        this.repaint();
        i = 0;
        while (i < this.sel.length) {
            if (this.sel[i]) {
                this.startBlink();
                return;
            }
            ++i;
        }
        this.stopBlink();
    }

    void this_mousePressed(MouseEvent e) {
        this.isDragging = true;
        int x = e.getX();
        int y = e.getY();
        this.fx = x;
        this.fy = y;
        this.tx = x;
        this.ty = y;
        this.px = x;
        this.py = y;
    }

    void this_mouseReleased(MouseEvent e) {
        this.isDragging = false;
        int rx = e.getX();
        int ry = e.getY();
        if (this.px > rx) {
            this.fx = rx;
            this.tx = this.px;
        } else {
            this.fx = this.px;
            this.tx = rx;
        }
        this.px = 0;
        if (this.py > ry) {
            this.fy = ry;
            this.ty = this.py;
        } else {
            this.fy = this.py;
            this.ty = ry;
        }
        this.py = 0;
        if (this.fx == this.tx && this.fy == this.ty) {
            return;
        }
        this.setSelectedData(this.fx, this.fy, this.tx, this.ty, e.isControlDown());
        this.repaint();
    }

    void this_mouseDragged(MouseEvent e) {
        if (this.isDragging) {
            int x = e.getX();
            int y = e.getY();
            if (x > this.getWidth() - 1) {
                x = this.getWidth() - 1;
            } else if (x < 0) {
                x = 0;
            }
            if (y > this.getHeight() - 1) {
                y = this.getHeight() - 1;
            } else if (y < 0) {
                y = 0;
            }
            if (this.px > x) {
                this.fx = x;
                this.tx = this.px;
            } else {
                this.fx = this.px;
                this.tx = x;
            }
            if (this.py > y) {
                this.fy = y;
                this.ty = this.py;
            } else {
                this.fy = this.py;
                this.ty = y;
            }
            this.repaint();
        }
    }

    void this_mouseMoved(MouseEvent e) {
    }

    private void setSelectedData(int fx, int fy, int tx, int ty, boolean ctrl) {
        int x1 = Math.min(fx, tx);
        int x2 = Math.max(fx, tx);
        int y1 = Math.min(fy, ty);
        int y2 = Math.max(fy, ty);
        double[] p1 = new double[2];
        double[] p2 = new double[2];
        double[] p3 = new double[2];
        double[] p4 = new double[2];
        double[] ap1 = new double[2];
        int i = 0;
        while (i < this.xPosList.length) {
            int[] x = (int[])this.xPosList[i];
            int[] y = (int[])this.yPosList[i];
            if (!ctrl) {
                this.sel[i] = false;
            }
            if (x.length >= 2) {
                int j = 1;
                while (j < x.length) {
                    p3[0] = x[j - 1];
                    p3[1] = y[j - 1];
                    p4[0] = x[j];
                    p4[1] = y[j];
                    boolean b = false;
                    if (x1 < x[j] && x[j] < x2 && x1 < x[j - 1] && x[j - 1] < x2 && y1 < y[j] && y[j] < y2 && y1 < y[j - 1] && y[j - 1] < y2) {
                        b = true;
                    }
                    if (!b) {
                        p1[0] = fx;
                        p1[1] = fy;
                        p2[0] = tx;
                        p2[1] = ty;
                        if (this.getCrossPoint(ap1, p1, p2, p3, p4)) {
                            b = true;
                        } else {
                            p1[0] = tx;
                            p1[1] = fy;
                            p2[0] = fx;
                            p2[1] = ty;
                            if (this.getCrossPoint(ap1, p1, p2, p3, p4)) {
                                b = true;
                            }
                        }
                    }
                    if (b) {
                        this.sel[i] = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.fireSelectStateChanged();
        i = 0;
        while (i < this.sel.length) {
            if (this.sel[i]) {
                this.startBlink();
                return;
            }
            ++i;
        }
        this.stopBlink();
    }

    private boolean getCrossPoint(double[] ap1, double[] p1, double[] p2, double[] p3, double[] p4) {
        double a1 = p1[1] - p2[1];
        double b2 = p4[0] - p3[0];
        double a2 = p3[1] - p4[1];
        double b1 = p2[0] - p1[0];
        if (a1 * b2 - a2 * b1 == 0.0) {
            return false;
        }
        double c1 = p1[0] * p2[1] - p2[0] * p1[1];
        double c2 = p3[0] * p4[1] - p4[0] * p3[1];
        ap1[0] = (b1 * c2 - b2 * c1) / (a1 * b2 - a2 * b1);
        ap1[1] = (a1 * c2 - a2 * c1) / (a2 * b1 - a1 * b2);
        return (p1[0] <= ap1[0] && ap1[0] <= p2[0] || p2[0] <= ap1[0] && ap1[0] <= p1[0]) && (p1[1] <= ap1[1] && ap1[1] <= p2[1] || p2[1] <= ap1[1] && ap1[1] <= p1[1]) && (p3[0] <= ap1[0] && ap1[0] <= p4[0] || p4[0] <= ap1[0] && ap1[0] <= p3[0]) && (p3[1] <= ap1[1] && ap1[1] <= p4[1] || p4[1] <= ap1[1] && ap1[1] <= p3[1]);
    }

    public void setMaxTimeOfDraw(double d) {
        if (d < 0.0 || d <= this.minTimeOfDraw) {
            return;
        }
        this.maxTimeOfDraw = d;
        this.isChanged = true;
        this.fireStateChanged();
    }

    public void setMinTimeOfDraw(double d) {
        if (d < 0.0 || d >= this.maxTimeOfDraw) {
            return;
        }
        this.minTimeOfDraw = d;
        this.isChanged = true;
        this.fireStateChanged();
    }

    public void setMaxRange(double d) {
        if (d <= this.minRange) {
            return;
        }
        this.maxRange = d;
        this.isChanged = true;
        this.fireStateChanged();
    }

    public void setMinRange(double d) {
        if (d >= this.maxRange) {
            return;
        }
        this.minRange = d;
        this.isChanged = true;
        this.fireStateChanged();
    }

    public void setMaxMinValue(double maxRange, double minRange, double maxTime, double minTime) {
        if (maxTime < 0.0 || minTime < 0.0) {
            return;
        }
        this.maxTimeOfDraw = maxTime;
        this.minTimeOfDraw = minTime;
        this.maxRange = maxRange;
        this.minRange = minRange;
        this.isChanged = true;
        this.fireStateChanged();
    }

    public void setDrawSamplingPoint(boolean f) {
        this.isDrawSamplingPointFlag = f;
    }

    public boolean isDrawSamplingPoint() {
        return this.isDrawSamplingPointFlag;
    }

    Vector getXScaleData() {
        return this.xScaleVector;
    }

    Vector getYScaleData() {
        return this.yScaleVector;
    }

    void selectAll() {
        int i = 0;
        while (i < this.sel.length) {
            this.sel[i] = true;
            ++i;
        }
        this.repaint();
        this.startBlink();
        this.fireSelectStateChanged();
    }

    void clearSelected() {
        int i = 0;
        while (i < this.sel.length) {
            this.sel[i] = false;
            ++i;
        }
        this.stopBlink();
        this.fireSelectStateChanged();
    }

    private void startBlink() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    private void stopBlink() {
        if (this.runner != null) {
            this.runner.interrupt();
            this.runner = null;
        }
    }

    @Override
    public void run() {
        try {
            this.drawEnd = true;
            while (!Thread.interrupted()) {
                if (!this.drawEnd) continue;
                this.blinkMode = !this.blinkMode;
                this.repaint();
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.drawEnd = true;
        this.blinkMode = true;
        this.repaint();
    }

    public void addChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new Vector();
        }
        this.listenerList.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        this.makeScaleData();
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.listenerList) {
            cl.stateChanged(ce);
        }
    }

    public void test() {
        this.makeScaleData();
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.listenerList) {
            cl.stateChanged(ce);
        }
    }

    public void addSelectChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.selectChanglistenerList == null) {
            this.selectChanglistenerList = new Vector();
        }
        this.selectChanglistenerList.add(listener);
    }

    public void removeSelectChangeListener(ChangeListener listener) {
        this.selectChanglistenerList.remove(listener);
    }

    protected void fireSelectStateChanged() {
        if (this.selectChanglistenerList == null) {
            return;
        }
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener cl : this.selectChanglistenerList) {
            cl.stateChanged(ce);
        }
    }
}

