/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlTask;
import jp.sbi.sbml.util.SBMLPanelLists;

public class TaskTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static final String TASK = "Experiment";
    public static final String spacesTaskNameMaxLen = "            ";
    private SBMLPanelLists sbmlPanelLists = null;
    private DefaultMutableTreeNode rootNode = null;
    private ArrayList<Object> listOfRootNode = new ArrayList();

    public TaskTree() {
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new MyTreeCellRenderer1());
        this.rootNode = new DefaultMutableTreeNode(TASK);
        this.listOfRootNode.add(this.rootNode);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.expandRow(0);
        this.setModel(new DefaultTreeModel(this.rootNode));
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setBackgroundColor(Color color) {
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        renderer.setBackground(color);
        renderer.setBackgroundNonSelectionColor(color);
        this.setCellRenderer(renderer);
        this.setBackground(color);
    }

    public int removeNode(SmlTask removeTask) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int count = this.rootNode.getChildCount();
        int indexOfTask = 0;
        indexOfTask = 0;
        while (indexOfTask < count) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.rootNode.getChildAt(indexOfTask);
            if (((SmlTask)((MyTreeLeafObject)node.getUserObject()).obj).getName().equals(removeTask.getName())) {
                model.removeNodeFromParent(node);
                break;
            }
            ++indexOfTask;
        }
        return indexOfTask;
    }

    public void addNode(SmlTask newTask, int index) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(newTask.getName());
        MyTreeLeafObject obj = new MyTreeLeafObject(newTask);
        node.setUserObject(obj);
        this.rootNode.insert(node, index);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
        this.addSelectionRow(1);
    }

    public SmlTask getSelectedTask(ArrayList<Object> listOfTask) {
        int[] selected = this.getSelectionRows();
        DefaultMutableTreeNode selectedNode = null;
        try {
            selectedNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(selected[0] - 1);
        }
        catch (Exception e) {
            selectedNode = null;
        }
        if (selectedNode == null || !(selectedNode.getUserObject() instanceof MyTreeLeafObject)) {
            return null;
        }
        int i = 0;
        if (i < listOfTask.size()) {
            SmlTask task = (SmlTask)listOfTask.get(i);
            if (task.getName().equals(((MyTreeLeafObject)selectedNode.getUserObject()).getName())) {
                return task;
            }
            return null;
        }
        return null;
    }

    public void createRootNode(ArrayList<Object> listOfTasks) {
        int i = 0;
        while (i < listOfTasks.size()) {
            SmlTask task = (SmlTask)listOfTasks.get(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(task.getName());
            MyTreeLeafObject obj = new MyTreeLeafObject(task);
            node.setUserObject(obj);
            this.rootNode.add(node);
            ++i;
        }
        this.listOfRootNode.add(this.rootNode);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        this.setModel(model);
        model.reload();
    }

    class MyTreeCellRenderer1
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        MyTreeCellRenderer1() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Object object = ((DefaultMutableTreeNode)value).getUserObject();
            if (TaskTree.this.sbmlPanelLists == null || !(object instanceof MyTreeLeafObject)) {
                this.setToolTipText(null);
                return this;
            }
            MyTreeLeafObject obj = (MyTreeLeafObject)object;
            this.setText(obj.getName());
            return this;
        }
    }

    class MyTreeLeafObject {
        private Object obj;

        public MyTreeLeafObject(Object obj) {
            this.obj = obj;
        }

        public String getName() {
            return this.toString();
        }

        public String toString() {
            String str = ((SmlTask)this.obj).getName();
            if (str == null) {
                return TaskTree.spacesTaskNameMaxLen;
            }
            str = String.valueOf(str) + TaskTree.spacesTaskNameMaxLen;
            str = str.substring(0, TaskTree.spacesTaskNameMaxLen.length());
            return str;
        }

        public Object getObj() {
            return this.obj;
        }
    }
}

