/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.co.mki.celldesigner.simulation.sedml.databean.SmlTask;

public class TaskNameInputDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField text;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean isCancel;
    private ArrayList<Object> TaskNames = new ArrayList();

    public TaskNameInputDialog(ArrayList<Object> tasks) {
        if (tasks != null && tasks.size() > 0) {
            int i = 0;
            while (i < tasks.size()) {
                SmlTask smlTask = (SmlTask)tasks.get(i);
                this.TaskNames.add(smlTask.getName().trim().toLowerCase());
                ++i;
            }
        }
        this.setSize(300, 110);
        this.setTitle("ExperimentNameInputDialog");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JLabel label = new JLabel("Experiment Name");
        centerPanel.add(label);
        this.text = new JTextField();
        this.text.setPreferredSize(new Dimension(200, 22));
        centerPanel.add(this.text);
        this.getContentPane().add((Component)centerPanel, "Center");
        JPanel bottomPanel = new JPanel();
        this.buttonOK = new JButton("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (TaskNameInputDialog.this.text.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(null, "Please input task name.", "Warning", 1);
                    return;
                }
                if (TaskNameInputDialog.this.TaskNames.contains(TaskNameInputDialog.this.text.getText().trim().toLowerCase())) {
                    JOptionPane.showMessageDialog(null, "This name already exists. Use another name.", "Warning", 1);
                    return;
                }
                if (TaskNameInputDialog.this.text.getText().trim().length() > "            ".length()) {
                    JOptionPane.showMessageDialog(null, "The maximum length of TaskName is " + "            ".length() + ".", "Warning", 1);
                    return;
                }
                TaskNameInputDialog.this.setVisible(false);
            }
        });
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TaskNameInputDialog.this.isCancel = true;
                TaskNameInputDialog.this.setVisible(false);
            }
        });
        bottomPanel.add(this.buttonOK);
        bottomPanel.add(this.buttonCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setResizable(false);
        this.setModal(true);
        this.setCenterLocation();
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    private void setCenterLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
    }
}

