/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.mki.celldesigner.simulation.CvodeResults;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.SBaseEditorListener;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultChart;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultShowFrame;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.TabChangeAmount;
import jp.co.mki.celldesigner.simulation.controlpanel.TabParameterScanInteractive;
import jp.co.mki.celldesigner.simulation.util.FormatF;
import jp.co.mki.celldesigner.simulation.util.SimulationCheck;
import jp.co.mki.celldesigner.simulation.util.SimulationProperties;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.co.mki.celldesigner.simulation.viewparts.ColoredTableCellRenderer;
import jp.sbi.celldesigner.soslib.SOSlib;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.libsbml;

public class TabSpecies
extends JPanel
implements ActionListener {
    private final int X_WIDTH = 850;
    private final int Y_WIDTH = 500;
    private JScrollPane scrPane = null;
    private TableModel tblModel = null;
    private JTable mainTable = null;
    private String[][] tblDataStorage = null;
    private final int NUM_COL = 8;
    private JTextField dispFileName = null;
    private String XMLFileName = "";
    private JButton fileOpen = null;
    private JButton exeCmd = null;
    private SBMLDocument sbmlDocument = null;
    private GridBagLayout grbLayout = null;
    private TabSpecies tabSpecies = this;
    private List lstId = new ArrayList();
    private TextCellEditor[] textCellEditor = null;
    private SBMLPanelLists sbmlPanelLists = null;
    private TabParameterScanInteractive parameterScanInteractive = null;
    private TabChangeAmount changeAmount = null;
    private ComboCellEditor[] comboCellEditor = null;
    private Vector listeners = new Vector();
    private String[] initValue = null;
    private ControlPanelMainWindow parent;
    private String currentTextCellValue = null;

    public ControlPanelMainWindow getControlPanelMainWindow() {
        return this.parent;
    }

    public TabSpecies(SBMLDocument sbmlDocument) {
        this.sbmlDocument = sbmlDocument;
        this.initThisObjectInformation();
        this.addComponents();
    }

    public TabSpecies(SBMLPanelLists sbmlPanelLists, ControlPanelMainWindow parent) {
        this.parent = parent;
        this.sbmlPanelLists = sbmlPanelLists;
        this.initThisObjectInformation();
        this.addComponents();
        this.updateDataStorageTable();
        this.redrawDataStorageTable();
    }

    public void setColmunModel(TableColumnModel tm) {
        this.mainTable.setColumnModel(tm);
        this.textCellEditor = new TextCellEditor[8];
        ArrayList<ComboCellEditor> comboCellEditorAL = new ArrayList<ComboCellEditor>();
        int i = 0;
        while (i < 8) {
            TableColumn col = this.mainTable.getColumnModel().getColumn(i);
            this.textCellEditor[i] = new TextCellEditor(this, new JTextField());
            col.setCellEditor(this.textCellEditor[i]);
            if (col.getHeaderValue().equals("Initial Quantity") || col.getHeaderValue().equals("boundary condition") || col.getHeaderValue().equals("constant")) {
                col.setCellRenderer(new ColoredTableCellRenderer("Species", true));
            } else {
                col.setCellRenderer(new ColoredTableCellRenderer("Species", false));
            }
            if (col.getHeaderValue().equals("boundary condition") || col.getHeaderValue().equals("constant")) {
                ComboCellEditor cce = new ComboCellEditor();
                comboCellEditorAL.add(cce);
                col.setCellEditor(cce);
            }
            ++i;
        }
        this.comboCellEditor = new ComboCellEditor[comboCellEditorAL.size()];
        i = 0;
        while (i < comboCellEditorAL.size()) {
            this.comboCellEditor[i] = (ComboCellEditor)comboCellEditorAL.get(i);
            ++i;
        }
    }

    public TableColumnModel getColmunModel() {
        return this.mainTable.getColumnModel();
    }

    private void addComponents() {
        GridBagConstraints grc = new GridBagConstraints();
        this.mainTable = this.getMainTable();
        this.scrPane = new JScrollPane(this.mainTable);
        this.mainTable.setPreferredSize(new Dimension(1000, 700));
        this.scrPane.setPreferredSize(new Dimension(1000, 700));
        grc.gridx = 0;
        grc.gridy = 0;
        grc.weightx = 1.0;
        grc.weighty = 0.0;
        grc.insets = new Insets(2, 2, 0, 2);
        grc.ipadx = 800;
        grc.ipady = 700;
        grc.fill = 1;
        grc.anchor = 18;
        this.grbLayout.setConstraints(this.scrPane, grc);
        this.add(this.scrPane);
    }

    private void initThisObjectInformation() {
        this.grbLayout = new GridBagLayout();
        this.setLayout(this.grbLayout);
        this.setSize(850, 500);
    }

    private JTable getMainTable() {
        if (this.tblDataStorage == null) {
            this.mainTable = new JTable(0, 8);
        } else {
            this.tblModel = new MyTableModel(this.tblDataStorage);
            this.mainTable = new JTable(this.tblModel);
        }
        this.mainTable.setAutoResizeMode(0);
        this.mainTable.getTableHeader().setReorderingAllowed(true);
        ArrayList<ComboCellEditor> comboCellEditorAL = new ArrayList<ComboCellEditor>();
        this.textCellEditor = new TextCellEditor[8];
        int i = 0;
        while (i < 8) {
            TableColumn col = this.mainTable.getColumnModel().getColumn(i);
            this.textCellEditor[i] = new TextCellEditor(this, new JTextField());
            col.setCellEditor(this.textCellEditor[i]);
            if (i == 4 || i >= 6) {
                col.setCellRenderer(new ColoredTableCellRenderer("Species", true));
            } else {
                col.setCellRenderer(new ColoredTableCellRenderer("Species", false));
            }
            if (i >= 6) {
                ComboCellEditor cce = new ComboCellEditor();
                comboCellEditorAL.add(cce);
                col.setCellEditor(cce);
            }
            ++i;
        }
        this.comboCellEditor = new ComboCellEditor[comboCellEditorAL.size()];
        i = 0;
        while (i < comboCellEditorAL.size()) {
            this.comboCellEditor[i] = (ComboCellEditor)comboCellEditorAL.get(i);
            ++i;
        }
        return this.mainTable;
    }

    private JTextField getDispFileName() {
        JTextField _dispFileName = new JTextField();
        _dispFileName.setColumns(20);
        _dispFileName.setEditable(false);
        _dispFileName.setBackground(new Color(255, 255, 255));
        return _dispFileName;
    }

    private JButton getFileOpen() {
        JButton _fileOpen = new JButton("Open Condition");
        _fileOpen.addActionListener(this);
        return _fileOpen;
    }

    private JButton getExeCmd() {
        JButton _exeCmd = new JButton("Execute");
        _exeCmd.addActionListener(this);
        return _exeCmd;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileOpen) {
            this.fileOperate();
            this.redrawDataStorageTable();
        } else if (this.isTableDataStorage()) {
            this.showResultImage();
        }
    }

    public void addSBaseEditorListener(SBaseEditorListener listener) {
        int i;
        this.listeners.add(listener);
        if (this.textCellEditor != null) {
            i = 0;
            while (i < this.textCellEditor.length) {
                this.textCellEditor[i].addSBaseEditorListener(listener);
                ++i;
            }
        }
        if (this.comboCellEditor != null) {
            i = 0;
            while (i < this.comboCellEditor.length) {
                this.comboCellEditor[i].addSBaseEditorListener(listener);
                ++i;
            }
        }
    }

    private String solveODE() {
        String inputFileName = String.valueOf(SimulationProperties.getInstance().getInitParameter("input_path")) + "/" + SimulationProperties.getInstance().getInitParameter("input_file_name");
        this.writeXML(inputFileName);
        String[] args = new String[]{"dummy", inputFileName, "1000", "100"};
        CvodeResults results = SOSlib.solveOde(args);
        String resultImageFileName = String.valueOf(SimulationProperties.getInstance().getInitParameter("result_path")) + "/" + SimulationProperties.getInstance().getInitParameter("result_image_file_name");
        try {
            SimulationResultChart src = new SimulationResultChart();
            src.setTitle("test chart");
            src.setTimeAxisLabel("time axis");
            src.setValueAxisLabel("amount");
            src.createChart(results, resultImageFileName);
            results.outputFile(String.valueOf(SimulationProperties.getInstance().getInitParameter("result_path")) + "/" + SimulationProperties.getInstance().getInitParameter("result_file_name"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return resultImageFileName;
    }

    private void fileOperate() {
        String title = "Select File";
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select File");
        int retFile = fileChooser.showOpenDialog(this);
        if (retFile == 1) {
            return;
        }
        this.XMLFileName = fileChooser.getSelectedFile().getAbsolutePath();
        this.dispFileName.setText(this.XMLFileName);
        this.readXML(new File(this.XMLFileName));
        this.sbmlDocument = new SBMLDocument();
        try {
            SBMLReader reader = new SBMLReader();
            this.sbmlDocument = reader.readSBML(this.XMLFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readXML(File filepath) {
        try {
            SBMLReader reader = new SBMLReader();
            this.sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDataStorageTable() {
        Species species;
        SpeciesData speciesD;
        ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
        int lstSize = listOfSpeciesData.size();
        this.tblDataStorage = new String[lstSize][8];
        this.initValue = new String[lstSize];
        int left = 0;
        int right = 0;
        int i = 0;
        while (i < lstSize) {
            String s;
            speciesD = (SpeciesData)listOfSpeciesData.get(i);
            species = speciesD.getSpecies();
            boolean hasMath = false;
            if (species.isSetInitialAmount()) {
                s = String.valueOf(species.getInitialAmount());
            } else if (species.isSetInitialConcentration()) {
                s = String.valueOf(species.getInitialConcentration());
            } else {
                s = "0";
                Model targetModel = species.getModel();
                int j = 0;
                while ((long)j < targetModel.getNumInitialAssignments()) {
                    if (targetModel.getInitialAssignment((long)j).getId().equals(species.getId())) {
                        s = libsbml.formulaToString((ASTNode)targetModel.getInitialAssignment((long)j).getMath());
                        hasMath = true;
                    }
                    ++j;
                }
                j = 0;
                while ((long)j < targetModel.getNumRules()) {
                    if (targetModel.getRule((long)j).getId().equals(species.getId())) {
                        s = libsbml.formulaToString((ASTNode)targetModel.getRule((long)j).getMath());
                        hasMath = true;
                    }
                    ++j;
                }
            }
            if (!hasMath) {
                StringTokenizer token = new StringTokenizer(s, ".");
                String firstToken = token.nextToken();
                if (firstToken.length() > left) {
                    left = firstToken.length();
                }
                try {
                    String lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > right) {
                        right = lastToken.length();
                    }
                }
                catch (Exception lastToken) {
                    // empty catch block
                }
            }
            ++i;
        }
        i = 0;
        while (i < lstSize) {
            String ivalue;
            String qtype;
            speciesD = (SpeciesData)listOfSpeciesData.get(i);
            species = speciesD.getSpecies();
            boolean hasMath = false;
            if (species.isSetInitialAmount()) {
                qtype = "Amount";
                ivalue = Double.toString(species.getInitialAmount());
            } else if (species.isSetInitialConcentration()) {
                qtype = "Concentration";
                ivalue = Double.toString(species.getInitialConcentration());
            } else {
                qtype = "Amount";
                ivalue = "0";
                Model targetModel = species.getModel();
                int j = 0;
                while ((long)j < targetModel.getNumInitialAssignments()) {
                    if (targetModel.getInitialAssignment((long)j).getId().equals(species.getId())) {
                        ivalue = libsbml.formulaToString((ASTNode)targetModel.getInitialAssignment((long)j).getMath());
                        hasMath = true;
                    }
                    ++j;
                }
                j = 0;
                while ((long)j < targetModel.getNumRules()) {
                    if (targetModel.getRule((long)j).getId().equals(species.getId())) {
                        ivalue = libsbml.formulaToString((ASTNode)targetModel.getRule((long)j).getMath());
                        hasMath = true;
                    }
                    ++j;
                }
                if (!hasMath) {
                    species.setInitialAmount(0.0);
                } else {
                    qtype = "";
                }
            }
            this.tblDataStorage[i][0] = species.getId();
            this.tblDataStorage[i][1] = speciesD.toString();
            this.tblDataStorage[i][2] = species.getCompartment();
            this.tblDataStorage[i][3] = qtype;
            this.tblDataStorage[i][4] = ivalue;
            if (!hasMath && this.tblDataStorage[i][4].indexOf("E") == -1) {
                FormatF df = new FormatF(left, right);
                this.tblDataStorage[i][4] = species.isSetInitialAmount() ? String.valueOf(df.format(species.getInitialAmount())) : String.valueOf(df.format(species.getInitialConcentration()));
            }
            this.tblDataStorage[i][5] = String.valueOf(species.getSubstanceUnits());
            this.tblDataStorage[i][6] = String.valueOf(species.getBoundaryCondition());
            this.tblDataStorage[i][7] = String.valueOf(species.getConstant());
            this.initValue[i] = species.isSetInitialAmount() ? String.valueOf(species.getInitialAmount()) : (species.isSetInitialConcentration() ? String.valueOf(species.getInitialConcentration()) : ivalue);
            this.lstId.add(species.getId());
            ++i;
        }
        if (this.tblModel != null) {
            ((MyTableModel)this.tblModel).setValue(this.tblDataStorage);
        }
        this.notifySBaseEditorListener();
    }

    private void notifySBaseEditorListener() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SBaseEditorListener)this.listeners.get(i)).SBaseChanged(3);
            ++i;
        }
    }

    public String[][] getTblDataStorage() {
        return this.tblDataStorage;
    }

    public void redrawDataStorageTable() {
        this.remove(this.scrPane);
        this.setVisible(false);
        this.mainTable = this.getMainTable();
        this.scrPane = new JScrollPane(this.mainTable);
        this.scrPane.setPreferredSize(new Dimension(this.mainTable.getPreferredSize().width, this.mainTable.getPreferredSize().height));
        GridBagConstraints grc = new GridBagConstraints();
        grc.gridwidth = 6;
        grc.gridheight = 1;
        grc.gridx = 0;
        grc.gridy = 0;
        grc.weightx = 1.0;
        grc.weighty = 0.5;
        grc.insets = new Insets(2, 2, 2, 2);
        grc.fill = 1;
        grc.anchor = 18;
        this.grbLayout.setConstraints(this.scrPane, grc);
        this.add(this.scrPane);
        this.setVisible(true);
    }

    private void writeXML(String resultFileName) {
        try {
            SBMLWriter writer = new SBMLWriter();
            writer.writeSBML(this.sbmlDocument, resultFileName);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showResultImage() {
        String resultImageFileName = this.solveODE();
        SimulationResultShowFrame srsf = new SimulationResultShowFrame("Result Image");
        srsf.showFrame(resultImageFileName);
    }

    private boolean isTableDataStorage() {
        int col = 4;
        int row = SimulationCheck.checkTableDataStorage(this, this.tblDataStorage, col, this.tblDataStorage.length, 2);
        if (row >= 0) {
            JOptionPane.showMessageDialog(this, "The value which is not the integer value is input. ", "WARN", 0);
            return false;
        }
        return true;
    }

    public void setSBMLDocument(SBMLDocument sbmlDocument) {
        this.sbmlDocument = sbmlDocument;
    }

    public void setTabParameterScanInteractive(TabParameterScanInteractive parameterScanInteractive) {
        this.parameterScanInteractive = parameterScanInteractive;
    }

    public void setTabChangeAmount(TabChangeAmount changeAmount) {
        this.changeAmount = changeAmount;
    }

    private class ComboCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        int row;
        int col;
        JComboBox list;
        final String[] menu = new String[]{"true", "false"};
        Object selectedValue = null;
        ComboCellEditorListener editor = null;

        public Object getSelectedValue() {
            return this.selectedValue;
        }

        private ComboCellEditor() {
            this.list = new JComboBox<String>(this.menu);
            this.editor = new ComboCellEditorListener(this);
            this.addCellEditorListener(this.editor);
            this.list.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ComboCellEditor.this.selectedValue = (String)ComboCellEditor.this.list.getSelectedItem();
                }
            });
        }

        public void editCancel() {
            this.list.setSelectedItem(this.selectedValue);
        }

        public void addSBaseEditorListener(SBaseEditorListener listener) {
            CellEditorListener[] cel = this.getCellEditorListeners();
            int i = 0;
            while (i < cel.length) {
                ((ComboCellEditorListener)cel[i]).addSBaseEditorListener(listener);
                ++i;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.selectedValue = value;
            this.row = row;
            this.col = col;
            this.list.setSelectedItem(this.selectedValue);
            return this.list;
        }

        @Override
        public Object getCellEditorValue() {
            Object value = this.list.getSelectedItem();
            return value;
        }

        private class ComboCellEditorListener
        implements CellEditorListener {
            Vector myListener = new Vector();
            ComboCellEditor parent;

            public ComboCellEditorListener(ComboCellEditor parent) {
                this.parent = parent;
            }

            public Vector getMyListener() {
                return this.myListener;
            }

            public void addSBaseEditorListener(SBaseEditorListener listener) {
                this.myListener.add(listener);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                TabSpecies.this.tabSpecies.getControlPanelMainWindow().setSelectedModelTab();
                TabSpecies.this.sbmlPanelLists.setModel(TabSpecies.this.tabSpecies.getControlPanelMainWindow().getSbframe().getSBModel().getModel());
                Species species = (Species)TabSpecies.this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList().get((long)ComboCellEditor.this.row);
                if (species == null) {
                    return;
                }
                boolean oldBoundaryCondition = species.getBoundaryCondition();
                boolean oldConstant = species.getConstant();
                boolean newBoundaryCondition = Boolean.valueOf(TabSpecies.this.tblDataStorage[ComboCellEditor.this.row][6]);
                boolean newConstant = Boolean.valueOf(TabSpecies.this.tblDataStorage[ComboCellEditor.this.row][7]);
                if (oldBoundaryCondition != newBoundaryCondition || oldConstant != newConstant) {
                    TabSpecies.this.getControlPanelMainWindow().setChanged(true);
                }
                ((Species)TabSpecies.this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList().get((long)ComboCellEditor.this.row)).setBoundaryCondition(Boolean.valueOf(TabSpecies.this.tblDataStorage[ComboCellEditor.this.row][6]).booleanValue());
                ((Species)TabSpecies.this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList().get((long)ComboCellEditor.this.row)).setConstant(Boolean.valueOf(TabSpecies.this.tblDataStorage[ComboCellEditor.this.row][7]).booleanValue());
                int l = 0;
                while (l < this.myListener.size()) {
                    ((SBaseEditorListener)this.myListener.get(l)).SBaseChanged(3);
                    ++l;
                }
                this.parent.editCancel();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private Object[][] tblDataStorage;
        private Object[] headerName = new Object[]{"Id", "Name", "Compartment", "Quantity Type", "Initial Quantity", "Substance Units", "boundary condition", "constant"};

        public MyTableModel(String[][] tblDataStorage) {
            this.tblDataStorage = tblDataStorage;
        }

        public Object[] getHeaderName() {
            return this.headerName;
        }

        @Override
        public int getColumnCount() {
            return this.headerName.length;
        }

        @Override
        public int getRowCount() {
            return this.tblDataStorage.length;
        }

        @Override
        public String getColumnName(int col) {
            return (String)this.headerName[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tblDataStorage[row][col];
        }

        public void setValue(Object[][] value) {
            this.tblDataStorage = value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tblDataStorage[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            if (c == 0) {
                return new Boolean(false).getClass();
            }
            return new String().getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex > 3 && colIndex != 5;
        }
    }

    private class TextCellEditor
    extends DefaultCellEditor {
        int row;
        int col;
        TabSpecies tabSpecies;

        TextCellEditor(TabSpecies tabSpecies2, JTextField textField) {
            super(textField);
            this.setClickCountToStart(1);
            this.addCellEditorListener(new TextCellEditorListener(tabSpecies2));
            this.tabSpecies = tabSpecies2;
        }

        public void addSBaseEditorListener(SBaseEditorListener listener) {
            CellEditorListener[] cel = this.getCellEditorListeners();
            int i = 0;
            while (i < cel.length) {
                ((TextCellEditorListener)cel[i]).addSBaseEditorListener(listener);
                ++i;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.row = row;
            this.col = col;
            if (((String)value).indexOf(",", 0) != -1) {
                value = StringTool.replaceString((String)value, ",", "");
            }
            TabSpecies.this.currentTextCellValue = (String)value;
            return super.getTableCellEditorComponent(table, value, isSelected, row, col);
        }

        private class TextCellEditorListener
        implements CellEditorListener {
            TabSpecies tabSpecies;
            Vector myListener = new Vector();

            public TextCellEditorListener(TabSpecies tabSpecies) {
                this.tabSpecies = tabSpecies;
            }

            public void addSBaseEditorListener(SBaseEditorListener listener) {
                this.myListener.add(listener);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultCellEditor editor = (DefaultCellEditor)e.getSource();
                Object value = editor.getCellEditorValue();
                String sValue = (String)value;
                if (!SimulationCheck.checkExponentValue(this.tabSpecies, TabSpecies.this.initValue, TextCellEditor.this.row, sValue)) {
                    return;
                }
                if (SimulationCheck.isBecomeToDouble(sValue)) {
                    sValue = String.valueOf(Double.parseDouble(sValue));
                    this.resetSpecies();
                    TabSpecies.this.parameterScanInteractive.setInitialCurValue(TextCellEditor.this.row, sValue);
                    TabSpecies.this.parameterScanInteractive.setInitialMaxValue(TextCellEditor.this.row, sValue);
                    TabSpecies.this.changeAmount.updateDataStorageTable(TextCellEditor.this.row, sValue);
                    if (TabSpecies.this.parent != null && TabSpecies.this.currentTextCellValue != null && Double.parseDouble(TabSpecies.this.currentTextCellValue) != Double.parseDouble(sValue)) {
                        TabSpecies.this.parent.setChanged(true);
                    }
                    this.tabSpecies.updateDataStorageTable();
                    this.tabSpecies.repaint();
                } else {
                    JOptionPane.showMessageDialog(this.tabSpecies, "The value which is not the integer value is input. ", "WARN", 0);
                    this.tabSpecies.updateDataStorageTable();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }

            private void resetSpecies() {
                try {
                    this.tabSpecies.getControlPanelMainWindow().setSelectedModelTab();
                    TabSpecies.this.sbmlPanelLists.setModel(this.tabSpecies.getControlPanelMainWindow().getSbframe().getSBModel().getModel());
                    Species species = (Species)TabSpecies.this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList().get((long)TextCellEditor.this.row);
                    if (species.isSetInitialAmount()) {
                        species.setInitialAmount(Double.parseDouble(TabSpecies.this.tblDataStorage[TextCellEditor.this.row][4]));
                    } else {
                        species.setInitialConcentration(Double.parseDouble(TabSpecies.this.tblDataStorage[TextCellEditor.this.row][4]));
                    }
                    int l = 0;
                    while (l < this.myListener.size()) {
                        ((SBaseEditorListener)this.myListener.get(l)).SBaseChanged(3);
                        ++l;
                    }
                }
                catch (Exception sie) {
                    sie.printStackTrace();
                }
            }
        }
    }
}

