/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import jp.co.mki.celldesigner.simulation.SBMLResults;
import jp.co.mki.celldesigner.simulation.TimeCourse;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.OverlaySettingDialog;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesListPanel;
import jp.co.mki.celldesigner.simulation.controlpanel.TabResultTable;
import jp.co.mki.celldesigner.simulation.viewparts.SimFileFilter;
import jp.sbi.sbml.util.SBMLPanelLists;

public class TabResult
extends JPanel {
    private ControlPanelMainWindow parent;
    private OverlaySettingDialog settingsDialog;
    private SBMLPanelLists sbmlPanelLists;
    private JButton buttonShowGraph;
    private JButton buttonSetting;
    private JButton buttonWriting;
    private TabResultTable resultTabel;
    private JScrollPane resultTabelScrool;
    private ArrayList listOfResult;
    private boolean isOverlayMode = false;
    private Boolean[] listOfOverlayedSpecies;

    public TabResult(ControlPanelMainWindow parent, SBMLPanelLists sbmlPanelLists, ArrayList listOfResult) {
        this.sbmlPanelLists = sbmlPanelLists;
        this.listOfResult = listOfResult;
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Results"));
        this.createNorthPanel();
        this.createCenterPanel();
    }

    private void createNorthPanel() {
        JPanel innerNorthPanel = new JPanel(new BorderLayout());
        this.buttonShowGraph = new JButton("Show Graph");
        this.buttonShowGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabResult.this.buttonShowGraph_actionPerformed(e);
            }
        });
        this.buttonShowGraph.setEnabled(false);
        this.buttonSetting = new JButton("Overlay Setting");
        this.buttonSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabResult.this.buttonSetting_actionPerformed(e);
            }
        });
        this.buttonWriting = new JButton("Writing");
        this.buttonWriting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabResult.this.buttonWriting_actionPerformed(e);
            }
        });
        this.buttonWriting.setEnabled(false);
        JPanel innerPanel = new JPanel();
        innerPanel.add(this.buttonShowGraph);
        innerPanel.add(this.buttonSetting);
        innerPanel.add(this.buttonWriting);
        innerNorthPanel.add((Component)innerPanel, "West");
        this.add((Component)innerNorthPanel, "North");
    }

    private void createCenterPanel() {
        this.resultTabelScrool = new JScrollPane();
        this.resultTabel = new TabResultTable(this, this.getData(), this.isOverlayMode);
        this.resultTabelScrool.getViewport().add((Component)this.resultTabel, null);
        this.add((Component)this.resultTabelScrool, "Center");
    }

    private void buttonShowGraph_actionPerformed(ActionEvent e) {
        if (!this.buttonSetting.isEnabled() && this.resultTabel.getSelectedRow() < 0) {
            return;
        }
        if (this.isOverlayMode) {
            if (this.listOfOverlayedSpecies == null) {
                this.settingsDialog = new OverlaySettingDialog(this, this.parent);
                ArrayList listOfVOverlayedSpecies = this.settingsDialog.getListOfOverlayedSpecies();
                this.listOfOverlayedSpecies = new Boolean[listOfVOverlayedSpecies.size()];
                int i = 0;
                while (i < listOfVOverlayedSpecies.size()) {
                    ArrayList data = (ArrayList)listOfVOverlayedSpecies.get(i);
                    this.listOfOverlayedSpecies[i] = (Boolean)data.get(0);
                    ++i;
                }
            }
            ArrayList listOfOverlayedResults = this.getListOfOverlayedResults();
            Boolean[] target = new Boolean[listOfOverlayedResults.size()];
            int i = 0;
            while (i < listOfOverlayedResults.size()) {
                ArrayList data = (ArrayList)listOfOverlayedResults.get(i);
                target[i] = (Boolean)data.get(0);
                ++i;
            }
            if (this.parent.getSrp() == null) {
                this.parent.calcAndDrawLoadResultImage(target, this.listOfOverlayedSpecies, true, false, false, false, true);
            } else {
                this.parent.calcAndDrawLoadResultImage(target, this.listOfOverlayedSpecies, this.parent.getSrp().getCheckSpeciesSelected(), this.parent.getSrp().getCheckCompartmentSelected(), this.parent.getSrp().getCheckParameterSelected(), this.parent.getSrp().getCheckFluxSelected(), true);
            }
        } else {
            int i = 0;
            while (i < this.listOfResult.size()) {
                SBMLResults result = (SBMLResults)this.listOfResult.get(i);
                result.setVisible(false);
                ++i;
            }
            SBMLResults result = (SBMLResults)this.listOfResult.get(this.resultTabel.getSelectedRow());
            result.setVisible(true);
            if (this.parent.getSrp() == null) {
                this.parent.calcAndDrawLoadResultImage(result, true, false, false, false);
            } else {
                this.parent.calcAndDrawLoadResultImage(result, this.parent.getSrp().getCheckSpeciesSelected(), this.parent.getSrp().getCheckCompartmentSelected(), this.parent.getSrp().getCheckParameterSelected(), this.parent.getSrp().getCheckFluxSelected());
                if (this.parent.getExeCheck().isSelected()) {
                    this.parent.getSrp().getLineVisibleList().clear();
                    int i2 = 0;
                    while (i2 < this.parent.getSrp().getSpeciesList().size()) {
                        String selectedId = (String)this.parent.getSrp().getSpeciesList().get(i2);
                        this.parent.getSrp().getLineVisibleList().add(this.parent.getSrp().getSpeciesVisible().isVisible(selectedId));
                        ++i2;
                    }
                    this.parent.doShowScatterAction();
                    if (this.parent.getExeReverseCheck().isSelected()) {
                        this.parent.doShowReverseScatterAction();
                    }
                }
            }
        }
    }

    public void setRowSelect(int row) {
        this.resultTabel.setChangeSelection(row, 0, true, false);
    }

    private void buttonSetting_actionPerformed(ActionEvent e) {
        if (this.settingsDialog == null) {
            this.settingsDialog = new OverlaySettingDialog(this, this.parent);
            this.settingsDialog.setVisible(true);
        } else {
            this.settingsDialog.reload();
            this.settingsDialog.setVisible(true);
        }
    }

    public void setOverlaySettingDialog(OverlaySettingDialog dialog) {
        this.settingsDialog = dialog;
    }

    private void buttonWriting_actionPerformed(ActionEvent e) {
        SimulationResultPanel srp = this.parent.getSrp();
        if (srp == null) {
            JOptionPane.showMessageDialog(this, "No graph is shown. Click Show Graph button.", "WARN", 0);
            return;
        }
        SpeciesListPanel slp = srp.getSpeciesListPanel();
        JTable table = slp.getSpeciesTable();
        if (table.getSelectedRows() == null || table.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(this, "Select species on simulation result graph.", "WARN", 0);
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        SimFileFilter[] filter = new SimFileFilter[]{new SimFileFilter(".txt", "txt Files(*.txt)")};
        int i = 0;
        while (i < filter.length) {
            fileChooser.addChoosableFileFilter(filter[i]);
            ++i;
        }
        fileChooser.setDialogTitle("Select file");
        int retFile = fileChooser.showSaveDialog(this);
        if (retFile == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getAbsolutePath();
        ArrayList listOfTargetData = this.getSelectedValue(table);
        ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(String.valueOf(path) + ".txt"));
            int speciesIndex = -1;
            int paramIndex = -1;
            int compIndex = -1;
            int fluxesIndex = -1;
            int k = 0;
            while (k < listOfSpeciesData.size()) {
                SpeciesData sp = (SpeciesData)listOfSpeciesData.get(k);
                String s = (String)listOfTargetData.get(0);
                if (sp.toString().equals(s)) {
                    speciesIndex = k;
                    break;
                }
                ++k;
            }
            if (speciesIndex == -1) {
                SBMLResults result = (SBMLResults)this.listOfResult.get(0);
                TimeCourse fluxes = result.getFluxes();
                String[] names = fluxes.getNames();
                String s = (String)listOfTargetData.get(0);
                int k2 = 0;
                while (k2 < names.length) {
                    String ss = names[k2];
                    if (ss.equals(s)) {
                        fluxesIndex = k2;
                        break;
                    }
                    ++k2;
                }
            }
            SBMLResults first = (SBMLResults)this.listOfResult.get(0);
            String[][] output = new String[first.getTimepoints()][this.listOfResult.size() + 1];
            int i2 = 0;
            while (i2 < this.listOfResult.size()) {
                double d;
                int k3;
                SBMLResults result = (SBMLResults)this.listOfResult.get(i2);
                if (speciesIndex >= 0) {
                    TimeCourse species = result.getSpecies();
                    int timePoints = species.getTimepoints();
                    k3 = 0;
                    while (k3 < timePoints) {
                        output[k3][0] = String.valueOf(result.getTime(k3)) + " ";
                        ++k3;
                    }
                    k3 = 0;
                    while (k3 < timePoints) {
                        d = species.getValue(k3, speciesIndex);
                        output[k3][i2 + 1] = String.valueOf(d) + " ";
                        ++k3;
                    }
                } else if (fluxesIndex >= 0) {
                    TimeCourse species = result.getFluxes();
                    int timePoints = species.getTimepoints();
                    k3 = 0;
                    while (k3 < timePoints) {
                        output[k3][0] = String.valueOf(result.getTime(k3)) + " ";
                        ++k3;
                    }
                    k3 = 0;
                    while (k3 < timePoints) {
                        d = species.getValue(k3, fluxesIndex);
                        output[k3][i2 + 1] = String.valueOf(d) + " ";
                        ++k3;
                    }
                }
                ++i2;
            }
            StringBuffer buf = new StringBuffer();
            int i3 = 0;
            while (i3 < output.length) {
                int k4 = 0;
                while (k4 < output[i3].length) {
                    buf.append(output[i3][k4]);
                    ++k4;
                }
                buf.append("\n");
                ++i3;
            }
            pw.print(buf);
            pw.flush();
            pw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList getSelectedValue(JTable table) {
        int rowCount = table.getModel().getRowCount();
        int[] rows = table.getSelectedRows();
        ArrayList<Object> rowList = new ArrayList<Object>(rows.length);
        int i = 0;
        while (i < rows.length) {
            int row = rows[i];
            Object value = table.getModel().getValueAt(row, 1);
            rowList.add(value);
            ++i;
        }
        return rowList;
    }

    public Object[][] getData() {
        Vector newData = new Vector();
        if (this.listOfResult == null) {
            return new Object[0][0];
        }
        int i = 0;
        while (i < this.listOfResult.size()) {
            Vector<Object> rowData = new Vector<Object>();
            SBMLResults results = (SBMLResults)this.listOfResult.get(i);
            if (this.isOverlayMode) {
                if (results == null) {
                    rowData.addElement("null");
                    rowData.addElement("null");
                    rowData.addElement("null");
                } else if (results.getParameterInfo() != null) {
                    rowData.addElement(new Boolean(true));
                    rowData.addElement(results.getParameterInfo());
                    rowData.addElement(results.getPath());
                } else {
                    rowData.addElement(new Boolean(true));
                    rowData.addElement("");
                    rowData.addElement(results.getPath());
                }
            } else if (results == null) {
                rowData.addElement("null");
                rowData.addElement("null");
            } else if (results.getParameterInfo() != null) {
                rowData.addElement(results.getParameterInfo());
                rowData.addElement(results.getPath());
            } else {
                rowData.addElement("");
                rowData.addElement(results.getPath());
            }
            newData.addElement(rowData);
            ++i;
        }
        Object[][] arrayData = new Object[newData.size()][1];
        int i2 = 0;
        while (i2 < newData.size()) {
            Vector data = (Vector)newData.elementAt(i2);
            arrayData[i2] = data.toArray();
            ++i2;
        }
        return arrayData;
    }

    public ArrayList getListOfOverlayedResults() {
        int rowCount = this.resultTabel.getModel().getRowCount();
        ArrayList rowList = new ArrayList(rowCount);
        int i = 0;
        while (i < rowCount) {
            int colCount = this.resultTabel.getModel().getColumnCount();
            ArrayList<Object> row = new ArrayList<Object>(colCount);
            int j = 0;
            while (j < colCount) {
                Object value = this.resultTabel.getModel().getValueAt(i, j);
                row.add(value);
                ++j;
            }
            rowList.add(row);
            ++i;
        }
        return rowList;
    }

    public void reload(ArrayList listOfResult) {
        this.listOfResult = listOfResult;
        this.remove(this.resultTabelScrool);
        this.createCenterPanel();
    }

    public boolean isOverlayMode() {
        return this.isOverlayMode;
    }

    public void setOverlayMode(boolean isOverlayMode) {
        this.isOverlayMode = isOverlayMode;
        this.buttonSetting.setEnabled(isOverlayMode);
    }

    public void setShowButton(boolean isVisible) {
        this.buttonShowGraph.setEnabled(isVisible);
    }

    public void setWritingButton(boolean isVisible) {
        this.buttonWriting.setEnabled(isVisible);
    }

    public SBMLPanelLists getSbmlPanelLists() {
        return this.sbmlPanelLists;
    }

    public void setSbmlPanelLists(SBMLPanelLists sbmlPanelLists) {
        this.sbmlPanelLists = sbmlPanelLists;
    }

    public ArrayList getListOfResult() {
        return this.listOfResult;
    }

    public void setListOfResult(ArrayList listOfResult) {
        this.listOfResult = listOfResult;
    }

    public Boolean[] getListOfOverlayedSpecies() {
        return this.listOfOverlayedSpecies;
    }

    public void setListOfOverlayedSpecies(Boolean[] listOfOverlayedSpecies) {
        this.listOfOverlayedSpecies = listOfOverlayedSpecies;
    }

    public void setListOfResultsVisible(Boolean[] listOfResultsVisible) {
        int rowCount = this.resultTabel.getModel().getRowCount();
        ArrayList rowList = new ArrayList(rowCount);
        int i = 0;
        while (i < rowCount) {
            this.resultTabel.getModel().setValueAt(listOfResultsVisible[i], i, 0);
            ++i;
        }
    }

    public ArrayList getListOfOverlayedSpeciesFromOverlayDialog() {
        return this.settingsDialog.getListOfOverlayedSpecies();
    }

    public void setCloseOverlaySetting() {
        if (this.settingsDialog != null) {
            this.settingsDialog.setVisible(false);
            this.settingsDialog.dispose();
            this.settingsDialog = null;
        }
    }

    public int getLastSelectedRow() {
        return this.resultTabel.getSelectedRow();
    }
}

