/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.co.mki.celldesigner.simulation.controlpanel.TabChangeAmount;

public class TabPlotSetting
extends JPanel
implements ChangeListener {
    private final int X_WIDTH = 850;
    private final int Y_WIDTH = 500;
    private GridBagLayout grbLayout = null;
    private JLabel lblTimespan = null;
    private JSpinner spnSpan = null;
    private JSpinner spnStep = null;
    private double SpanValue;
    private double StepValue;
    private TabChangeAmount changeAmount = null;

    public TabPlotSetting() {
        this.initThisObjectInformation();
        this.addComponents();
        this.setSpnSpan(Double.valueOf(this.spnSpan.getValue().toString()));
        this.setSpnStep(Double.valueOf(this.spnStep.getValue().toString()));
    }

    private void redrawChangeAmount() {
        this.changeAmount.setPlotSetting(this);
        this.changeAmount.setHeaderName();
        this.changeAmount.setEnableStatusOnComponents();
    }

    public void setChangeAmount(TabChangeAmount changeAmount) {
        this.changeAmount = changeAmount;
    }

    private void initThisObjectInformation() {
        this.grbLayout = new GridBagLayout();
        this.setLayout(this.grbLayout);
        this.setSize(850, 500);
    }

    private void addComponents() {
        GridBagConstraints grc = new GridBagConstraints();
        this.lblTimespan = this.getLblTimespan();
        this.spnSpan = this.getSpnSpan();
        this.spnStep = this.getSpnStep();
        this.lblTimespan.add(new JLabel("Span"));
        this.lblTimespan.add(this.spnSpan);
        this.lblTimespan.add(new JLabel("Step"));
        this.lblTimespan.add(this.spnStep);
        grc.gridx = 0;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 1;
        grc.weightx = 1.0;
        grc.weighty = 1.0;
        grc.insets = new Insets(5, 5, 2, 2);
        grc.ipadx = 200;
        grc.ipady = 55;
        grc.anchor = 23;
        this.grbLayout.setConstraints(this.lblTimespan, grc);
        this.add(this.lblTimespan);
    }

    private JSpinner getSpnSpan() {
        double defaultValue = 100.0;
        double minValue = 0.0;
        double maxValue = 1000.0;
        double stepValue = 0.5;
        SpinnerNumberModel model = new SpinnerNumberModel(100.0, 0.0, 1000.0, 0.5);
        JSpinner _spnSpan = new JSpinner(model);
        _spnSpan.addChangeListener(this);
        return _spnSpan;
    }

    private void setSpnSpan(double SpanValue) {
        this.SpanValue = SpanValue;
    }

    private JSpinner getSpnStep() {
        double defaultValue = 10.0;
        double minValue = 0.0;
        double maxValue = 1000.0;
        double stepValue = 0.5;
        SpinnerNumberModel model = new SpinnerNumberModel(10.0, 0.0, 1000.0, 0.5);
        JSpinner _spnStep = new JSpinner(model);
        _spnStep.addChangeListener(this);
        return _spnStep;
    }

    private void setSpnStep(double StepValue) {
        this.StepValue = StepValue;
    }

    private JLabel getLblTimespan() {
        JLabel _lblTimespan = new JLabel();
        _lblTimespan.setBorder(new TitledBorder("Time span"));
        _lblTimespan.setLayout(new GridLayout(2, 2));
        return _lblTimespan;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spnSpan) {
            this.SpanValue = Double.valueOf(this.spnSpan.getValue().toString());
        } else {
            this.StepValue = Double.valueOf(this.spnStep.getValue().toString());
        }
        this.redrawChangeAmount();
    }

    public double getSpanValue() {
        return this.SpanValue;
    }

    public double getStepValue() {
        return this.StepValue;
    }

    public void setSpanValue(double SpanValue) {
        this.SpanValue = SpanValue;
    }

    public void setStepValue(double StepValue) {
        this.StepValue = StepValue;
    }
}

