/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.mki.celldesigner.simulation.CvodeResults;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.SBaseEditorListener;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultChart;
import jp.co.mki.celldesigner.simulation.controlpanel.SimulationResultShowFrame;
import jp.co.mki.celldesigner.simulation.controlpanel.TabParameterScanInteractive;
import jp.co.mki.celldesigner.simulation.util.FormatF;
import jp.co.mki.celldesigner.simulation.util.SimulationCheck;
import jp.co.mki.celldesigner.simulation.util.SimulationProperties;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.co.mki.celldesigner.simulation.viewparts.ColoredTableCellRenderer;
import jp.sbi.celldesigner.soslib.SOSlib;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;

public class TabParameters
extends JPanel
implements ActionListener {
    private final int X_WIDTH = 850;
    private final int Y_WIDTH = 500;
    private JScrollPane scrPane = null;
    private TableModel tblModel = null;
    private JTable mainTable = null;
    private String[][] tblDataStorage = null;
    private final int NUM_COL = 6;
    private JTextField dispFileName = null;
    private String XMLFileName = "";
    private JButton fileOpen = null;
    private JButton exeCmd = null;
    private SBMLDocument sbmlDocument = null;
    private GridBagLayout grbLayout = null;
    private TabParameters tabParameters = this;
    private List nParameter = new ArrayList();
    private TextCellEditor[] textCellEditor = null;
    private SBMLPanelLists sbmlPanelLists = null;
    private TabParameterScanInteractive tabParameterScanInteractive = null;
    private ComboCellEditor[] comboCellEditor = null;
    private Vector listeners = new Vector();
    private String[] initValue = null;
    private ControlPanelMainWindow parent;
    private String currentComboCellValue = null;
    private String currentTextCellValue = null;

    public ControlPanelMainWindow getControlPanelMainWindow() {
        return this.parent;
    }

    public TabParameters(SBMLDocument sbmlDocument) {
        this.sbmlDocument = sbmlDocument;
        this.initThisObjectInformation();
        this.addComponents();
    }

    public TabParameters(SBMLPanelLists sbmlPanelLists, ControlPanelMainWindow parent) {
        this.sbmlPanelLists = sbmlPanelLists;
        this.parent = parent;
        this.initThisObjectInformation();
        this.addComponents();
        this.createTblDataStorage();
        this.updateDataStorageTable();
        this.redrawDataStorageTable();
    }

    private void addComponents() {
        GridBagConstraints grc = new GridBagConstraints();
        this.mainTable = this.getMainTable();
        this.scrPane = new JScrollPane(this.mainTable);
        grc.gridx = 0;
        grc.gridy = 0;
        grc.weightx = 1.0;
        grc.weighty = 1.0;
        grc.insets = new Insets(2, 2, 2, 2);
        grc.fill = 2;
        grc.anchor = 18;
        this.grbLayout.setConstraints(this.scrPane, grc);
        this.add(this.scrPane);
        grc.ipady = 5;
        grc.insets = new Insets(30, 2, 20, 2);
        this.dispFileName = this.getDispFileName();
        grc.gridx = 1;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.fill = 0;
        grc.anchor = 22;
        this.grbLayout.setConstraints(this.dispFileName, grc);
        this.fileOpen = this.getFileOpen();
        grc.gridx = 2;
        grc.gridy = 1;
        grc.gridwidth = 1;
        this.grbLayout.setConstraints(this.fileOpen, grc);
        this.exeCmd = this.getExeCmd();
        grc.gridx = 3;
        grc.gridy = 1;
        grc.gridwidth = 1;
        grc.fill = 0;
        grc.anchor = 21;
        this.grbLayout.setConstraints(this.exeCmd, grc);
    }

    private void initThisObjectInformation() {
        this.grbLayout = new GridBagLayout();
        this.setLayout(this.grbLayout);
        this.setBounds(10, 20, 800, 300);
    }

    private JTable getMainTable() {
        this.mainTable = null;
        if (this.tblDataStorage == null) {
            this.mainTable = new JTable(0, 6);
        } else {
            this.tblModel = new MyTableModel(this.tblDataStorage);
            this.mainTable = new JTable(this.tblModel);
        }
        this.mainTable.setAutoResizeMode(0);
        ArrayList<ComboCellEditor> comboCellEditorAL = new ArrayList<ComboCellEditor>();
        this.textCellEditor = new TextCellEditor[6];
        int i = 0;
        while (i < 6) {
            TableColumn col = this.mainTable.getColumnModel().getColumn(i);
            this.textCellEditor[i] = new TextCellEditor(this, new JTextField());
            col.setCellEditor(this.textCellEditor[i]);
            if (i == 3 || i == 5) {
                col.setCellRenderer(new ColoredTableCellRenderer("Parameters", true));
            } else {
                col.setCellRenderer(new ColoredTableCellRenderer("Parameters", false));
            }
            if (i == 5) {
                ComboCellEditor cce = new ComboCellEditor();
                comboCellEditorAL.add(cce);
                col.setCellEditor(cce);
            }
            ++i;
        }
        this.comboCellEditor = new ComboCellEditor[comboCellEditorAL.size()];
        i = 0;
        while (i < comboCellEditorAL.size()) {
            this.comboCellEditor[i] = (ComboCellEditor)comboCellEditorAL.get(i);
            ++i;
        }
        return this.mainTable;
    }

    private JTextField getDispFileName() {
        JTextField _dispFileName = new JTextField();
        _dispFileName.setColumns(20);
        _dispFileName.setEditable(false);
        _dispFileName.setBackground(new Color(255, 255, 255));
        return _dispFileName;
    }

    private JButton getFileOpen() {
        JButton _fileOpen = new JButton("Open Condition");
        _fileOpen.addActionListener(this);
        return _fileOpen;
    }

    private JButton getExeCmd() {
        JButton _exeCmd = new JButton("Execute");
        _exeCmd.addActionListener(this);
        return _exeCmd;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileOpen) {
            this.fileOperate();
            this.redrawDataStorageTable();
        } else if (this.isTableDataStorage()) {
            this.showResultImage();
        }
    }

    public void addSBaseEditorListener(SBaseEditorListener listener) {
        int i;
        this.listeners.add(listener);
        if (this.textCellEditor != null) {
            i = 0;
            while (i < this.textCellEditor.length) {
                this.textCellEditor[i].addSBaseEditorListener(listener);
                ++i;
            }
        }
        if (this.comboCellEditor != null) {
            i = 0;
            while (i < this.comboCellEditor.length) {
                this.comboCellEditor[i].addSBaseEditorListener(listener);
                ++i;
            }
        }
    }

    private String solveODE() {
        String inputFileName = String.valueOf(SimulationProperties.getInstance().getInitParameter("input_path")) + "/" + SimulationProperties.getInstance().getInitParameter("input_file_name");
        this.writeXML(inputFileName);
        String[] args = new String[]{"dummy", inputFileName, "1000", "100"};
        CvodeResults results = SOSlib.solveOde(args);
        String resultImageFileName = String.valueOf(SimulationProperties.getInstance().getInitParameter("result_path")) + "/" + SimulationProperties.getInstance().getInitParameter("result_image_file_name");
        try {
            SimulationResultChart src = new SimulationResultChart();
            src.setTitle("test chart");
            src.setTimeAxisLabel("time axis");
            src.setValueAxisLabel("amount");
            src.createChart(results, resultImageFileName);
            results.outputFile(String.valueOf(SimulationProperties.getInstance().getInitParameter("result_path")) + "/" + SimulationProperties.getInstance().getInitParameter("result_file_name"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return resultImageFileName;
    }

    private void fileOperate() {
        String title = "Select File";
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select File");
        int retFile = fileChooser.showOpenDialog(this);
        if (retFile == 1) {
            return;
        }
        this.XMLFileName = fileChooser.getSelectedFile().getAbsolutePath();
        this.dispFileName.setText(this.XMLFileName);
        this.sbmlDocument = new SBMLDocument();
        this.readXML(new File(this.XMLFileName));
    }

    public void readXML(File filepath) {
        try {
            SBMLReader reader = new SBMLReader();
            this.sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
            ListOfReactions listOfReactions = this.sbmlDocument.getModel().getListOfReactions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDataStorageTable() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        this.processLocalParameters();
    }

    private void processLocalParameters() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        int lstSize = (int)lstSBase.size();
        int row = 0;
        int left = 0;
        int right = 0;
        int i = 0;
        while (i < lstSize) {
            Reaction reaction = (Reaction)lstSBase.get((long)i);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            int _lstSize = (int)lstParameter.size();
            int j = 0;
            while (j < _lstSize) {
                Parameter parameter = (Parameter)lstParameter.get((long)j);
                double d = parameter.getValue();
                String s = String.valueOf(d);
                StringTokenizer token = new StringTokenizer(s, ".");
                String firstToken = token.nextToken();
                if (firstToken.length() > left) {
                    left = firstToken.length();
                }
                try {
                    String lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > right) {
                        right = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        ArrayList<String> initValueArray = new ArrayList<String>();
        row = 0;
        ListOf lstSBaseGlobal = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        int lstSizeGlobal = (int)lstSBaseGlobal.size();
        int i2 = 0;
        while (i2 < lstSizeGlobal) {
            Parameter parameter = (Parameter)lstSBaseGlobal.get((long)i2);
            this.tblDataStorage[row][0] = LibSBMLUtil.getParameterScope(parameter);
            this.tblDataStorage[row][1] = parameter.getId();
            this.tblDataStorage[row][2] = parameter.getName();
            this.tblDataStorage[row][3] = String.valueOf(parameter.getValue());
            this.tblDataStorage[row][4] = parameter.getUnits();
            this.tblDataStorage[row][5] = String.valueOf(parameter.getConstant());
            initValueArray.add(String.valueOf(parameter.getValue()));
            ++row;
            ++i2;
        }
        i2 = 0;
        while (i2 < lstSize) {
            Reaction reaction = (Reaction)lstSBase.get((long)i2);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            int _lstSize = (int)lstParameter.size();
            Object scope = null;
            int j = 0;
            while (j < _lstSize) {
                Parameter parameter = (Parameter)lstParameter.get((long)j);
                this.tblDataStorage[row][0] = LibSBMLUtil.getParameterScope(parameter);
                this.tblDataStorage[row][1] = parameter.getId();
                this.tblDataStorage[row][2] = parameter.getName();
                this.tblDataStorage[row][3] = String.valueOf(parameter.getValue());
                if (this.tblDataStorage[row][3].indexOf("E") == -1) {
                    FormatF df = new FormatF(left, right);
                    this.tblDataStorage[row][3] = String.valueOf(df.format(parameter.getValue()));
                }
                this.tblDataStorage[row][4] = parameter.getUnits();
                this.tblDataStorage[row][5] = String.valueOf(parameter.getConstant());
                initValueArray.add(String.valueOf(parameter.getValue()));
                ++row;
                ++j;
            }
            ++i2;
        }
        this.initValue = initValueArray.toArray(new String[row]);
        if (this.tblModel != null) {
            ((MyTableModel)this.tblModel).setValue(this.tblDataStorage);
        }
        this.notifySBaseEditorListener();
    }

    private void processGlobalParameters() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        int lstSize = (int)lstSBase.size();
        int row = 0;
        this.tblDataStorage = new String[lstSize][6];
        Object scope = null;
        this.initValue = new String[lstSize];
        int i = 0;
        while (i < lstSize) {
            Parameter parameter = (Parameter)lstSBase.get((long)i);
            this.tblDataStorage[row][0] = LibSBMLUtil.getParameterScope(parameter);
            this.tblDataStorage[row][1] = parameter.getId();
            this.tblDataStorage[row][2] = parameter.getName();
            this.tblDataStorage[row][3] = String.valueOf(parameter.getValue());
            this.tblDataStorage[row][4] = parameter.getUnits();
            this.tblDataStorage[row][5] = String.valueOf(parameter.getConstant());
            this.initValue[i] = String.valueOf(parameter.getValue());
            ++row;
            ++i;
        }
        if (this.tblModel != null) {
            ((MyTableModel)this.tblModel).setValue(this.tblDataStorage);
        }
        this.notifySBaseEditorListener();
    }

    public void resetParameters() {
        if (this.tblDataStorage == null || this.tblDataStorage.length <= 0) {
            return;
        }
        int i = 0;
        this.resetParameters(true, i++);
        while (i < this.tblDataStorage.length) {
            this.resetParameters(false, i);
            ++i;
        }
    }

    public void resetParameters(boolean bResetModel, int row) {
        try {
            String checkScope;
            if (bResetModel) {
                this.tabParameters.getControlPanelMainWindow().setSelectedModelTab();
                this.sbmlPanelLists.setModel(this.tabParameters.getControlPanelMainWindow().getSbframe().getSBModel().getModel());
            }
            if ((checkScope = this.tblDataStorage[row][0]).equals("global")) {
                ((Parameter)this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList().get((long)row)).setValue(Double.parseDouble(this.tblDataStorage[row][3]));
                ((Parameter)this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList().get((long)row)).setConstant(Boolean.valueOf(this.tblDataStorage[row][5]).booleanValue());
            } else {
                int sumParameter = 0;
                int i = 0;
                ListOf lstGlobalParameters = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
                int numGlobalParams = (int)lstGlobalParameters.size();
                while (sumParameter <= row - numGlobalParams) {
                    sumParameter += Integer.parseInt((String)this.nParameter.get(i++));
                }
                int indexOfLocalParam = row - (sumParameter -= Integer.parseInt((String)this.nParameter.get(--i))) - numGlobalParams;
                KineticLaw kw = ((Reaction)this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList().get((long)i)).getKineticLaw();
                kw.getListOfParameters().get((long)indexOfLocalParam).setValue(Double.parseDouble(this.tblDataStorage[row][3]));
                kw.getListOfParameters().get((long)indexOfLocalParam).setConstant(Boolean.valueOf(this.tblDataStorage[row][5]).booleanValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifySBaseEditorListener() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SBaseEditorListener)this.listeners.get(i)).SBaseChanged(4);
            ++i;
        }
    }

    public String[][] getTblDataStorage() {
        return this.tblDataStorage;
    }

    public void redrawDataStorageTable() {
        this.remove(this.scrPane);
        this.setVisible(false);
        this.mainTable = this.getMainTable();
        this.scrPane = new JScrollPane(this.mainTable);
        this.scrPane.setPreferredSize(new Dimension(this.mainTable.getPreferredSize().width, this.mainTable.getPreferredSize().height));
        GridBagConstraints grc = new GridBagConstraints();
        grc.gridwidth = 6;
        grc.gridheight = 1;
        grc.gridx = 0;
        grc.gridy = 0;
        grc.weightx = 1.0;
        grc.weighty = 1.0;
        grc.insets = new Insets(2, 2, 2, 2);
        grc.fill = 1;
        grc.anchor = 18;
        this.grbLayout.setConstraints(this.scrPane, grc);
        this.add(this.scrPane);
        this.setVisible(true);
    }

    private void writeXML(String resultFileName) {
        try {
            SBMLWriter writer = new SBMLWriter();
            writer.writeSBML(this.sbmlDocument, resultFileName);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showResultImage() {
        String resultImageFileName = this.solveODE();
        SimulationResultShowFrame srsf = new SimulationResultShowFrame("Result Image");
        srsf.showFrame(resultImageFileName);
    }

    public void setColmunModel(TableColumnModel tm) {
        this.mainTable.setColumnModel(tm);
        ArrayList<ComboCellEditor> comboCellEditorAL = new ArrayList<ComboCellEditor>();
        this.textCellEditor = new TextCellEditor[6];
        int i = 0;
        while (i < 6) {
            TableColumn col = this.mainTable.getColumnModel().getColumn(i);
            this.textCellEditor[i] = new TextCellEditor(this, new JTextField());
            col.setCellEditor(this.textCellEditor[i]);
            if (col.getHeaderValue().equals("Value") || col.getHeaderValue().equals("constant")) {
                col.setCellRenderer(new ColoredTableCellRenderer("Parameters", true));
            } else {
                col.setCellRenderer(new ColoredTableCellRenderer("Parameters", false));
            }
            if (col.getHeaderValue().equals("constant")) {
                ComboCellEditor cce = new ComboCellEditor();
                comboCellEditorAL.add(cce);
                col.setCellEditor(cce);
            }
            ++i;
        }
        this.comboCellEditor = new ComboCellEditor[comboCellEditorAL.size()];
        i = 0;
        while (i < comboCellEditorAL.size()) {
            this.comboCellEditor[i] = (ComboCellEditor)comboCellEditorAL.get(i);
            ++i;
        }
    }

    public TableColumnModel getColmunModel() {
        return this.mainTable.getColumnModel();
    }

    private boolean isTableDataStorage() {
        int col = 3;
        int row = SimulationCheck.checkTableDataStorage(this, this.tblDataStorage, col, this.tblDataStorage.length, 2);
        if (row >= 0) {
            JOptionPane.showMessageDialog(this, "Small number of values which are not the values are input.", "WARN", 0);
            return false;
        }
        return true;
    }

    private void createTblDataStorage() {
        Reaction reaction;
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        ListOf list = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        int lstSize = (int)list.size();
        int rowSize = 0;
        int i = 0;
        while (i < lstSize) {
            reaction = (Reaction)list.get((long)i);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            rowSize = (int)((long)rowSize + lstParameter.size());
            this.nParameter.add(String.valueOf(lstParameter.size()));
            ++i;
        }
        list = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        lstSize = (int)list.size();
        i = 0;
        while (i < lstSize) {
            reaction = (Parameter)list.get((long)i);
            ++rowSize;
            this.nParameter.add(String.valueOf(1));
            ++i;
        }
        this.tblDataStorage = new String[rowSize][6];
    }

    public List getNumParameter() {
        return this.nParameter;
    }

    public void setTabParameterScanInteractive(TabParameterScanInteractive tabParameterScanInteractive) {
        this.tabParameterScanInteractive = tabParameterScanInteractive;
    }

    private class ComboCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        int row;
        int col;
        JComboBox list;
        final String[] menu = new String[]{"true", "false"};
        Object selectedValue = null;
        ComboCellEditorListener editor = null;

        private ComboCellEditor() {
            this.list = new JComboBox<String>(this.menu);
            this.editor = new ComboCellEditorListener(this);
            this.addCellEditorListener(this.editor);
            this.list.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ComboCellEditor.this.selectedValue = (String)ComboCellEditor.this.list.getSelectedItem();
                }
            });
        }

        public void editCancel() {
            this.list.setSelectedItem(this.selectedValue);
        }

        public void addSBaseEditorListener(SBaseEditorListener listener) {
            CellEditorListener[] cel = this.getCellEditorListeners();
            int i = 0;
            while (i < cel.length) {
                ((ComboCellEditorListener)cel[i]).addSBaseEditorListener(listener);
                ++i;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.selectedValue = value;
            this.row = row;
            this.col = col;
            this.list.setSelectedItem(this.selectedValue);
            TabParameters.this.currentComboCellValue = (String)value;
            return this.list;
        }

        @Override
        public Object getCellEditorValue() {
            Object value = this.list.getSelectedItem();
            return value;
        }

        private class ComboCellEditorListener
        implements CellEditorListener {
            Vector myListener = new Vector();
            ComboCellEditor parent;

            public ComboCellEditorListener(ComboCellEditor parent) {
                this.parent = parent;
            }

            public Vector getMyListener() {
                return this.myListener;
            }

            public void addSBaseEditorListener(SBaseEditorListener listener) {
                this.myListener.add(listener);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int sumParameter = 0;
                int i = 0;
                while (sumParameter <= ComboCellEditor.this.row) {
                    sumParameter += Integer.parseInt((String)TabParameters.this.nParameter.get(i++));
                }
                sumParameter -= Integer.parseInt((String)TabParameters.this.nParameter.get(--i));
                TabParameters.this.tabParameters.getControlPanelMainWindow().setSelectedModelTab();
                TabParameters.this.sbmlPanelLists.setModel(TabParameters.this.tabParameters.getControlPanelMainWindow().getSbframe().getSBModel().getModel());
                ListOf lstSBase = TabParameters.this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
                if (lstSBase.size() == 0L) {
                    ((Reaction)TabParameters.this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList().get((long)i)).getKineticLaw().getListOfParameters().get((long)(ComboCellEditor.this.row - sumParameter)).setConstant(Boolean.valueOf(TabParameters.this.tblDataStorage[ComboCellEditor.this.row][5]).booleanValue());
                } else {
                    ((Parameter)TabParameters.this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList().get((long)ComboCellEditor.this.row)).setConstant(Boolean.valueOf(TabParameters.this.tblDataStorage[ComboCellEditor.this.row][5]).booleanValue());
                }
                if (TabParameters.this.getControlPanelMainWindow() != null && TabParameters.this.currentComboCellValue != null && !TabParameters.this.currentComboCellValue.equals(TabParameters.this.tblDataStorage[ComboCellEditor.this.row][5])) {
                    TabParameters.this.getControlPanelMainWindow().setChanged(true);
                }
                int l = 0;
                while (l < this.myListener.size()) {
                    ((SBaseEditorListener)this.myListener.get(l)).SBaseChanged(4);
                    ++l;
                }
                this.parent.editCancel();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private Object[][] tblDataStorage;
        private String[] headerName = new String[]{"Scope", "Id", "Name", "Value", "Units", "constant"};

        public MyTableModel(String[][] tblDataStorage) {
            this.tblDataStorage = tblDataStorage;
        }

        @Override
        public int getColumnCount() {
            return this.headerName.length;
        }

        @Override
        public int getRowCount() {
            return this.tblDataStorage.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.headerName[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tblDataStorage[row][col];
        }

        public void setValue(Object[][] value) {
            this.tblDataStorage = value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tblDataStorage[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex > 2 && colIndex != 4 && (colIndex != 5 || !this.isLocalParameter(rowIndex));
        }

        public boolean isLocalParameter(int rowIndex) {
            String scope = (String)this.tblDataStorage[rowIndex][0];
            return scope != null && !scope.equals("global") && scope.startsWith("local:Reaction");
        }
    }

    private class TextCellEditor
    extends DefaultCellEditor {
        int row;
        int col;
        TabParameters tabParameters;

        TextCellEditor(TabParameters tabParameters2, JTextField textField) {
            super(textField);
            this.setClickCountToStart(1);
            this.addCellEditorListener(new TextCellEditorListener(tabParameters2));
            this.tabParameters = tabParameters2;
        }

        public void addSBaseEditorListener(SBaseEditorListener listener) {
            CellEditorListener[] cel = this.getCellEditorListeners();
            int i = 0;
            while (i < cel.length) {
                ((TextCellEditorListener)cel[i]).addSBaseEditorListener(listener);
                ++i;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.row = row;
            this.col = col;
            if (((String)value).indexOf(",", 0) != -1) {
                value = StringTool.replaceString((String)value, ",", "");
            }
            TabParameters.this.currentTextCellValue = (String)value;
            return super.getTableCellEditorComponent(table, value, isSelected, row, col);
        }

        private class TextCellEditorListener
        implements CellEditorListener {
            Vector myListener = new Vector();
            TabParameters tabParameters;

            public TextCellEditorListener(TabParameters tabParameters) {
                this.tabParameters = tabParameters;
            }

            public void addSBaseEditorListener(SBaseEditorListener listener) {
                this.myListener.add(listener);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultCellEditor editor = (DefaultCellEditor)e.getSource();
                Object value = editor.getCellEditorValue();
                String sValue = (String)value;
                if (!SimulationCheck.checkExponentValue(this.tabParameters, TabParameters.this.initValue, TextCellEditor.this.row, sValue)) {
                    return;
                }
                if (SimulationCheck.isBecomeToDouble(sValue)) {
                    sValue = String.valueOf(Double.parseDouble(sValue));
                    this.resetParameters();
                    TabParameters.this.tabParameterScanInteractive.setParameterCurValue(TextCellEditor.this.row, sValue);
                    TabParameters.this.tabParameterScanInteractive.setParameterMaxValue(TextCellEditor.this.row, sValue);
                    if (TabParameters.this.parent != null && TabParameters.this.currentTextCellValue != null && Double.parseDouble(TabParameters.this.currentTextCellValue) != Double.parseDouble(sValue)) {
                        TabParameters.this.parent.setChanged(true);
                    }
                    this.tabParameters.updateDataStorageTable();
                    this.tabParameters.repaint();
                } else {
                    JOptionPane.showMessageDialog(this.tabParameters, "The value which is not the integer value is input. ", "WARN", 0);
                    this.tabParameters.updateDataStorageTable();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }

            private void resetParameters() {
                int col = 3;
                int check = -1;
                if (check < 0) {
                    try {
                        this.tabParameters.getControlPanelMainWindow().setSelectedModelTab();
                        TabParameters.this.sbmlPanelLists.setModel(this.tabParameters.getControlPanelMainWindow().getSbframe().getSBModel().getModel());
                        String checkScope = TabParameters.this.tblDataStorage[TextCellEditor.this.row][0];
                        if (checkScope.equals("global")) {
                            ((Parameter)TabParameters.this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList().get((long)TextCellEditor.this.row)).setValue(Double.parseDouble(TabParameters.this.tblDataStorage[TextCellEditor.this.row][3]));
                        } else {
                            int sumParameter = 0;
                            int i = 0;
                            ListOf lstGlobalParameters = TabParameters.this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
                            int numGlobalParams = (int)lstGlobalParameters.size();
                            while (sumParameter <= TextCellEditor.this.row - numGlobalParams) {
                                sumParameter += Integer.parseInt((String)TabParameters.this.nParameter.get(i++));
                            }
                            int indexOfLocalParam = TextCellEditor.this.row - (sumParameter -= Integer.parseInt((String)TabParameters.this.nParameter.get(--i))) - numGlobalParams;
                            ((Reaction)TabParameters.this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList().get((long)i)).getKineticLaw().getListOfParameters().get((long)indexOfLocalParam).setValue(Double.parseDouble(TabParameters.this.tblDataStorage[TextCellEditor.this.row][3]));
                        }
                        int l = 0;
                        while (l < this.myListener.size()) {
                            ((SBaseEditorListener)this.myListener.get(l)).SBaseChanged(4);
                            ++l;
                        }
                    }
                    catch (Exception sie) {
                        sie.printStackTrace();
                    }
                } else {
                    JOptionPane.showMessageDialog(this.tabParameters, "The value which is not the integer value is input. ", "WARN", 0);
                }
            }
        }
    }
}

