/*
 * Decompiled with CFR 0.152.
 */
package jp.co.mki.celldesigner.simulation.controlpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.co.mki.celldesigner.simulation.controlpanel.InteractiveSimulation;
import jp.co.mki.celldesigner.simulation.controlpanel.SliderValue;
import jp.co.mki.celldesigner.simulation.controlpanel.SpeciesData;
import jp.co.mki.celldesigner.simulation.controlpanel.TabParameters;
import jp.co.mki.celldesigner.simulation.controlpanel.TabSpecies;
import jp.co.mki.celldesigner.simulation.util.FormatF;
import jp.co.mki.celldesigner.simulation.util.SimulationCheck;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.co.mki.celldesigner.simulation.viewparts.ColoredTableCellRenderer;
import jp.co.mki.celldesigner.simulation.viewparts.NumericField;
import jp.sbi.sbml.util.SBMLPanelLists;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.Species;

public class TabParameterScanInteractive
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
KeyListener {
    private final int X_WIDTH = 850;
    private final int Y_WIDTH = 500;
    private JScrollPane scrPane = null;
    private GridBagLayout grbLayout = null;
    private JLabel lblScanParameter = null;
    private JLabel lblSlider = null;
    private JLabel lblPlotArea = null;
    private JLabel picLabel = null;
    private JScrollPane picScrPane = null;
    private JButton exeDefRange = null;
    private ButtonGroup bgScanParameter = null;
    private JRadioButton rbInitial = null;
    private JRadioButton rbParameter = null;
    private SBMLDocument sbmlDocument = null;
    private File XMLFile = null;
    private List lstInitialId = new ArrayList();
    private ArrayList speciesValueSliderList = new ArrayList();
    private Vector vecInitialSlider = new Vector();
    private Vector vecLblInitialCurValue = new Vector();
    private Vector vecLblInitialMinValue = new Vector();
    private Vector vecLblInitialMaxValue = new Vector();
    private List lstParameterId = new ArrayList();
    private ArrayList parameterValueSliderList = new ArrayList();
    private Vector vecParameterSlider = new Vector();
    private Vector vecLblParameterCurValue = new Vector();
    private Vector vecLblParameterMinValue = new Vector();
    private Vector vecLblParameterMaxValue = new Vector();
    private TableModel tblModel = null;
    private JTable mainTable = null;
    private String[][] tblDataStorage = null;
    private TabSpecies tabSpecies = null;
    private TabParameters tabParameters = null;
    private final int NUM_COL = 4;
    private TabParameterScanInteractive tabParameterScanInteractive = this;
    private JPanel PicPanel = null;
    private SBMLPanelLists sbmlPanelLists = null;
    private JPanel pSlider = null;
    private JScrollPane scrSlider = null;
    private JTextField txtFldCurValue = null;
    private ControlPanelMainWindow parent = null;
    private int dmyMaxValue = 100;
    private String[] initValue = null;
    private InteractiveSimulation interactiveSimulation = null;
    private boolean initialize;
    boolean rightKeyPress;
    boolean leftKeyPress;
    boolean update = true;

    public boolean isrbInitialSelected() {
        return this.rbInitial.isSelected();
    }

    public void setrbInitialSelected(boolean selected) {
        this.rbInitial.setSelected(selected);
        this.rbParameter.setSelected(!selected);
    }

    public TabParameterScanInteractive(SBMLDocument sbmlDocument, TabSpecies tabSpecies, TabParameters tabParameters) {
        this.sbmlDocument = sbmlDocument;
        this.tabSpecies = tabSpecies;
        this.tabParameters = tabParameters;
        this.initThisObjectInformation();
        this.addComponents();
    }

    public TabParameterScanInteractive(InteractiveSimulation interactiveSimulation, SBMLPanelLists sbmlPanelLists, ControlPanelMainWindow mainWindow, TabSpecies tabSpecies, TabParameters tabParameters, boolean initialize) {
        this.interactiveSimulation = interactiveSimulation;
        this.sbmlPanelLists = sbmlPanelLists;
        this.parent = mainWindow;
        this.tabSpecies = tabSpecies;
        this.tabParameters = tabParameters;
        this.initialize = initialize;
        this.tabSpecies.setTabParameterScanInteractive(this);
        this.tabParameters.setTabParameterScanInteractive(this);
        this.initThisObjectInformation();
        this.addComponents();
        this.setInteractiveSimulation();
    }

    private void initThisObjectInformation() {
        this.grbLayout = new GridBagLayout();
        this.setLayout(this.grbLayout);
        this.setBounds(10, 20, 800, 300);
    }

    private void addComponents() {
        GridBagConstraints grc = new GridBagConstraints();
        this.lblScanParameter = new JLabel();
        this.lblScanParameter.setBorder(new TitledBorder("Scan parameter"));
        this.setScanParameter();
        this.lblScanParameter.setLayout(new GridLayout(2, 1));
        this.lblScanParameter.add(this.rbInitial);
        this.lblScanParameter.add(this.rbParameter);
        grc.gridx = 0;
        grc.gridy = 0;
        grc.gridwidth = 1;
        grc.gridheight = 2;
        grc.weightx = 1.0;
        grc.anchor = 23;
        grc.ipadx = 170;
        grc.ipady = 40;
        grc.insets = new Insets(0, 5, 0, 0);
        this.grbLayout.setConstraints(this.lblScanParameter, grc);
        this.add(this.lblScanParameter);
        this.exeDefRange = this.getExeDefRange();
        grc.gridx = 0;
        grc.gridy = 0;
        grc.anchor = 24;
        grc.ipadx = 12;
        grc.ipady = 3;
        grc.insets = new Insets(35, 5, 0, 15);
        this.grbLayout.setConstraints(this.exeDefRange, grc);
        this.add(this.exeDefRange);
        this.rgstInitConfig_InitialValue();
        this.rgstInitConfig_ParameterValue();
        this.setSpLblSlider(true);
        this.picLabel = new JLabel();
        this.picScrPane = new JScrollPane(this.picLabel);
        grc.gridx = 1;
        grc.gridy = 2;
        grc.weightx = 1.0;
        grc.weighty = 1.0;
        grc.fill = 1;
        grc.anchor = 23;
        grc.ipadx = 500;
        grc.ipady = 500;
        grc.insets = new Insets(7, 2, 5, 5);
        this.grbLayout.setConstraints(this.picScrPane, grc);
        this.setDataStorageTable();
    }

    public void setSpLblSlider(boolean isLoad) {
        if (this.scrSlider != null) {
            this.remove(this.scrSlider);
            this.setVisible(false);
        }
        Iterator itId = null;
        Object itMaxValue = null;
        Object itMinValue = null;
        Object itCurValue = null;
        Iterator currentValueIt = null;
        this.vecInitialSlider.clear();
        this.vecParameterSlider.clear();
        if (this.parent.isXMLLoad && isLoad && this.initialize) {
            ArrayList tmpSpeValueSliList = this.interactiveSimulation.getInteractiveParameterList("initial value");
            this.speciesValueSliderList = this.GetSliderValueReaId(tmpSpeValueSliList);
            this.parameterValueSliderList = this.interactiveSimulation.getInteractiveParameterList("parameter value");
        }
        if (this.rbInitial.isSelected()) {
            this.vecLblInitialCurValue.clear();
            this.vecLblInitialMinValue.clear();
            this.vecLblInitialMaxValue.clear();
            itId = this.lstInitialId.iterator();
            currentValueIt = this.speciesValueSliderList.iterator();
        } else {
            this.vecLblParameterCurValue.clear();
            this.vecLblParameterMinValue.clear();
            this.vecLblParameterMaxValue.clear();
            itId = this.lstParameterId.iterator();
            currentValueIt = this.parameterValueSliderList.iterator();
        }
        this.pSlider = this.getPnlSlider();
        GridBagLayout grbLayout1 = new GridBagLayout();
        GridBagConstraints grc1 = new GridBagConstraints();
        this.pSlider.setLayout(grbLayout1);
        this.initValue = this.rbInitial.isSelected() ? new String[this.lstInitialId.size()] : new String[this.lstParameterId.size()];
        int gridy = 0;
        while (itId.hasNext()) {
            JLabel lblId = new JLabel((String)itId.next());
            grc1.gridx = 0;
            grc1.gridy = gridy;
            grc1.ipadx = 10;
            grc1.ipady = 3;
            grc1.anchor = 24;
            grc1.fill = 1;
            grbLayout1.setConstraints(lblId, grc1);
            this.pSlider.add(lblId);
            Object obj = currentValueIt.next();
            SliderValue currentSV = (SliderValue)obj;
            JLabel lblMinValue = new JLabel(currentSV.getMinValue());
            JLabel lblMaxValue = new JLabel(currentSV.getMaxValue());
            this.txtFldCurValue = this.getTextFieldCurValue(currentSV.getValue());
            this.initValue[gridy] = currentSV.getValue();
            grc1.gridx = 1;
            grc1.gridy = gridy;
            grc1.ipadx = 10;
            grc1.ipadx = 1;
            grc1.anchor = 24;
            grc1.fill = 1;
            grbLayout1.setConstraints(lblMinValue, grc1);
            this.pSlider.add(lblMinValue);
            JSlider slider = this.getChangedJSlider(currentSV.getSliderMinValue(), currentSV.getSliderMaxValue(), currentSV.getSliderValue());
            if (this.rbInitial.isSelected()) {
                this.vecInitialSlider.add(slider);
            } else {
                this.vecParameterSlider.add(slider);
            }
            grc1.gridx = 2;
            grc1.gridy = gridy;
            grc1.ipadx = 55;
            grc1.ipady = 10;
            grc1.anchor = 10;
            grc1.fill = 0;
            grbLayout1.setConstraints(slider, grc1);
            this.pSlider.add(slider);
            if (this.rbInitial.isSelected()) {
                this.vecLblInitialMinValue.add(lblMinValue);
                this.vecLblInitialMaxValue.add(lblMaxValue);
                this.vecLblInitialCurValue.add(this.txtFldCurValue);
            } else {
                this.vecLblParameterMinValue.add(lblMinValue);
                this.vecLblParameterMaxValue.add(lblMaxValue);
                this.vecLblParameterCurValue.add(this.txtFldCurValue);
            }
            grc1.gridx = 3;
            grc1.gridy = gridy;
            grc1.ipadx = 10;
            grc1.ipady = 1;
            grc1.anchor = 23;
            grc1.fill = 1;
            grbLayout1.setConstraints(lblMaxValue, grc1);
            this.pSlider.add(lblMaxValue);
            grc1.gridx = 4;
            grc1.gridy = gridy++;
            grc1.weighty = 1.0;
            grc1.anchor = 10;
            grc1.fill = 23;
            grbLayout1.setConstraints(this.txtFldCurValue, grc1);
            this.pSlider.add(this.txtFldCurValue);
        }
        this.scrSlider = this.getScrPaneSlider(this.pSlider);
        grc1.gridx = 0;
        grc1.gridy = 2;
        grc1.weightx = 1.0;
        grc1.weighty = 1.0;
        grc1.fill = 1;
        grc1.anchor = 23;
        grc1.ipadx = 400;
        grc1.ipady = 450;
        grc1.insets = new Insets(0, 5, 2, 2);
        this.grbLayout.setConstraints(this.scrSlider, grc1);
        this.add(this.scrSlider);
        this.setVisible(true);
    }

    private ArrayList<SliderValue> GetSliderValueReaId(ArrayList<SliderValue> tmplist) {
        ArrayList<SliderValue> tmpSpeValueSliList = new ArrayList<SliderValue>();
        int i = 0;
        while (i < tmplist.size()) {
            SliderValue svOld = tmplist.get(i);
            SliderValue svNew = (SliderValue)this.speciesValueSliderList.get(i);
            svOld.setRedSpeId(svNew.getRedSpeId());
            tmpSpeValueSliList.add(svOld);
            ++i;
        }
        return tmpSpeValueSliList;
    }

    private JButton getExeDefRange() {
        JButton _exeDefRange = new JButton("Define Range");
        _exeDefRange.addActionListener(this);
        return _exeDefRange;
    }

    private void setScanParameter() {
        this.bgScanParameter = new ButtonGroup();
        this.rbInitial = new JRadioButton("Initial value", true);
        this.rbParameter = new JRadioButton("Parameter value");
        this.rbInitial.addActionListener(this);
        this.rbParameter.addActionListener(this);
        this.bgScanParameter.add(this.rbInitial);
        this.bgScanParameter.add(this.rbParameter);
    }

    public void readXML(File filepath) {
        try {
            SBMLReader reader = new SBMLReader();
            this.sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInitialCurValue(int i, String value) {
        SliderValue sv = (SliderValue)this.speciesValueSliderList.get(i);
        sv.setValue(value);
    }

    public void setInitialMinValue(int i) {
        SliderValue sv = (SliderValue)this.speciesValueSliderList.get(i);
        sv.setMinValue("0");
    }

    public void setInitialMaxValue(int i, String value) {
        SliderValue sv = (SliderValue)this.speciesValueSliderList.get(i);
        sv.setMaxValue(String.valueOf(Double.parseDouble(value) * 2.0));
    }

    public void setParameterCurValue(int i, String value) {
        SliderValue sv = (SliderValue)this.parameterValueSliderList.get(i);
        sv.setValue(value);
    }

    public void setParameterMinValue(int i) {
        SliderValue sv = (SliderValue)this.parameterValueSliderList.get(i);
        sv.setMinValue("0");
    }

    public void setParameterMaxValue(int i, String value) {
        SliderValue sv = (SliderValue)this.parameterValueSliderList.get(i);
        sv.setMaxValue(String.valueOf(Double.parseDouble(value) * 2.0));
    }

    private void rgstInitConfig_InitialValue() {
        if (this.rbInitial.isSelected()) {
            ArrayList listOfSpeciesData = this.parent.listOfSpeciesData;
            int lstSize = listOfSpeciesData.size();
            int i = 0;
            while (i < lstSize) {
                SpeciesData speciesD = (SpeciesData)listOfSpeciesData.get(i);
                Species species = speciesD.getSpecies();
                String id = speciesD.toString();
                this.lstInitialId.add(id);
                String value = species.isSetInitialAmount() ? String.valueOf(species.getInitialAmount()) : String.valueOf(species.getInitialConcentration());
                SliderValue sv = new SliderValue(value);
                sv.setTarget(id);
                String strId = speciesD.toStringID_Name().split(":")[0];
                sv.setRedSpeId(strId);
                this.speciesValueSliderList.add(sv);
                ++i;
            }
        }
    }

    private void rgstInitConfig_ParameterValue() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        this.processParameters();
    }

    private void processParameters() {
        int row = 0;
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        int lstSize = (int)lstSBase.size();
        int i = 0;
        while (i < lstSize) {
            Parameter parameter = (Parameter)lstSBase.get((long)i);
            this.lstParameterId.add(parameter.getId());
            String value = String.valueOf(parameter.getValue());
            try {
                int dd = Integer.parseInt(value);
                value = String.valueOf(dd);
            }
            catch (Exception dd) {
                // empty catch block
            }
            SliderValue sv = new SliderValue(value);
            sv.setTarget(parameter.getId());
            this.parameterValueSliderList.add(sv);
            ++row;
            ++i;
        }
        ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        lstSize = (int)lstReaction.size();
        int i2 = 0;
        while (i2 < lstSize) {
            Reaction reaction = (Reaction)lstReaction.get((long)i2);
            if (reaction.getKineticLaw() != null) {
                ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
                int _lstSize = (int)lstParameter.size();
                int j = 0;
                while (j < _lstSize) {
                    Parameter parameter = (Parameter)lstParameter.get((long)j);
                    this.lstParameterId.add(parameter.getId());
                    String value = String.valueOf(parameter.getValue());
                    SliderValue sv = new SliderValue(value);
                    sv.setTarget(parameter.getId());
                    this.parameterValueSliderList.add(sv);
                    ++j;
                }
            }
            ++row;
            ++i2;
        }
        this.tblDataStorage = new String[row][4];
    }

    private void processLocalParameters() {
        ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
        int lstSize = (int)lstReaction.size();
        boolean row = false;
        int i = 0;
        while (i < lstSize) {
            Reaction reaction = (Reaction)lstReaction.get((long)i);
            if (reaction.getKineticLaw() != null) {
                ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
                int _lstSize = (int)lstParameter.size();
                int j = 0;
                while (j < _lstSize) {
                    Parameter parameter = (Parameter)lstParameter.get((long)j);
                    this.lstParameterId.add(parameter.getId());
                    String value = String.valueOf(parameter.getValue());
                    SliderValue sv = new SliderValue(value);
                    sv.setTarget(parameter.getId());
                    this.parameterValueSliderList.add(sv);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void processGlobalParameters() {
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
        int lstSize = (int)lstSBase.size();
        this.tblDataStorage = new String[lstSize][4];
        int i = 0;
        while (i < lstSize) {
            Parameter parameter = (Parameter)lstSBase.get((long)i);
            this.lstParameterId.add(parameter.getId());
            String value = String.valueOf(parameter.getValue());
            try {
                int dd = Integer.parseInt(value);
                value = String.valueOf(dd);
            }
            catch (Exception dd) {
                // empty catch block
            }
            SliderValue sv = new SliderValue(value);
            sv.setTarget(parameter.getId());
            this.parameterValueSliderList.add(sv);
            ++i;
        }
    }

    private JSlider getJSlider(int value) {
        boolean min = false;
        int max = value * 2;
        int initValue = value;
        JSlider slider = null;
        try {
            slider = new JSlider(0, 0, max, initValue);
            slider.addChangeListener(this);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return slider;
    }

    private JSlider getChangedJSlider(int min, int max, int curValue) {
        JSlider slider = null;
        try {
            slider = new JSlider(0, min, max, curValue);
            slider.addChangeListener(this);
            slider.addMouseListener(this);
            slider.addKeyListener(this);
            slider.setMajorTickSpacing(max / 20);
            slider.setPaintTicks(true);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        return slider;
    }

    private JPanel getPnlSlider() {
        JPanel _pSlider = new JPanel();
        _pSlider.setBorder(new TitledBorder("Scan parameter"));
        return _pSlider;
    }

    private JScrollPane getScrPaneSlider(Component component) {
        JScrollPane _scrSlider = new JScrollPane(component);
        return _scrSlider;
    }

    private JLabel getLblSlider() {
        JLabel _lblSlider = new JLabel();
        _lblSlider.setBorder(new TitledBorder("Scan parameter"));
        return _lblSlider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exeDefRange) {
            this.onClickExeDefRange();
        } else if (e.getSource() == this.rbInitial || e.getSource() == this.rbParameter) {
            this.redrawSpLabel();
        } else {
            if (this.rbInitial.isSelected()) {
                int valueSize = this.vecLblInitialCurValue.size();
                int i = 0;
                while (i < valueSize) {
                    JTextField txtCurValue = (JTextField)this.vecLblInitialCurValue.get(i);
                    JLabel txtMinValue = (JLabel)this.vecLblInitialMinValue.get(i);
                    JLabel txtMaxValue = (JLabel)this.vecLblInitialMaxValue.get(i);
                    if (e.getSource() == txtCurValue) {
                        String CurValue = txtCurValue.getText();
                        String MinValue = txtMinValue.getText();
                        String MaxValue = txtMaxValue.getText();
                        if (SimulationCheck.isBecomeToDouble(CurValue)) {
                            if (Double.parseDouble(CurValue) < Double.parseDouble(MinValue)) {
                                JOptionPane.showMessageDialog(this, "Smaller value than minimum value cannot be input.", "WARN", 0);
                            } else if (Double.parseDouble(CurValue) > Double.parseDouble(MaxValue)) {
                                JOptionPane.showMessageDialog(this, "Larger value than the maximum value cannot be input.", "WARN", 0);
                            } else if (SimulationCheck.checkExponentValue(this, this.initValue, i, CurValue)) {
                                if (this.parent.getSrp() != null) {
                                    this.parent.calcAndDrawLoadResultImage(null, this.parent.getSrp().getCheckSpeciesSelected(), this.parent.getSrp().getCheckCompartmentSelected(), this.parent.getSrp().getCheckParameterSelected(), this.parent.getSrp().getCheckFluxSelected());
                                    this.parent.getSrp().resettingMaxRangeSpinner();
                                } else {
                                    this.parent.calcAndDrawResultImage();
                                }
                                ((JTextField)this.vecLblInitialCurValue.get(i)).setText(CurValue);
                                this.resetTabSpecies(i, Double.parseDouble(CurValue));
                                this.speciesValueSliderList.set(i, new SliderValue(CurValue));
                                this.interactiveSimulation.setKindOfParameter("initial value");
                                this.interactiveSimulation.setInteractiveParameterList(this.speciesValueSliderList, "initial value");
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "Small number of values which are not the values are input.", "WARN", 0);
                        }
                    }
                    ++i;
                }
            } else {
                int valueSize = this.vecLblParameterCurValue.size();
                int i = 0;
                while (i < valueSize) {
                    JTextField txtCurValue = (JTextField)this.vecLblParameterCurValue.get(i);
                    JLabel txtMinValue = (JLabel)this.vecLblParameterMinValue.get(i);
                    JLabel txtMaxValue = (JLabel)this.vecLblParameterMaxValue.get(i);
                    if (e.getSource() == txtCurValue) {
                        String CurValue = txtCurValue.getText();
                        String MinValue = txtMinValue.getText();
                        String MaxValue = txtMaxValue.getText();
                        if (SimulationCheck.isBecomeToDouble(CurValue)) {
                            if (Double.parseDouble(CurValue) < Double.parseDouble(MinValue)) {
                                JOptionPane.showMessageDialog(this, "Smaller value than minimum value cannot be input.", "WARN", 0);
                            } else if (Double.parseDouble(CurValue) > Double.parseDouble(MaxValue)) {
                                JOptionPane.showMessageDialog(this, "Larger value than the maximum value cannot be input.", "WARN", 0);
                            } else if (SimulationCheck.checkExponentValue(this, this.initValue, i, CurValue)) {
                                if (this.parent.getSrp() != null) {
                                    this.parent.calcAndDrawLoadResultImage(null, this.parent.getSrp().getCheckSpeciesSelected(), this.parent.getSrp().getCheckCompartmentSelected(), this.parent.getSrp().getCheckParameterSelected(), this.parent.getSrp().getCheckFluxSelected());
                                    this.parent.getSrp().resettingMaxRangeSpinner();
                                } else {
                                    this.parent.calcAndDrawResultImage();
                                }
                                ((JTextField)this.vecLblParameterCurValue.get(i)).setText(CurValue);
                                this.resetTabParameters(i, Double.parseDouble(CurValue));
                                this.parameterValueSliderList.set(i, new SliderValue(CurValue));
                                this.interactiveSimulation.setKindOfParameter("parameter value");
                                this.interactiveSimulation.setInteractiveParameterList(this.parameterValueSliderList, "parameter value");
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "Small number of values which are not the values are input.", "WARN", 0);
                        }
                    }
                    ++i;
                }
            }
            this.redrawSpLabel();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double sp = Double.parseDouble(this.parent.getSpan());
        double st = Double.parseDouble(this.parent.getStep());
        if (sp == 0.0) {
            JOptionPane.showMessageDialog(null, "Please set values that are larger than 0 to span.", "WARN", 0);
            return;
        }
        if (st == 0.0) {
            JOptionPane.showMessageDialog(null, "Please set values that are larger than 0 to step.", "WARN", 0);
            return;
        }
        if (this.parent.getSrp() != null) {
            this.parent.calcAndDrawLoadResultImage(null, this.parent.getSrp().getCheckSpeciesSelected(), this.parent.getSrp().getCheckCompartmentSelected(), this.parent.getSrp().getCheckParameterSelected(), this.parent.getSrp().getCheckFluxSelected());
            this.parent.getSrp().resettingMaxRangeSpinner();
        } else {
            this.parent.calcAndDrawResultImage();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            this.leftKeyPress = true;
        } else if (e.getKeyCode() == 39) {
            this.rightKeyPress = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.leftKeyPress = false;
        this.rightKeyPress = false;
        double sp = Double.parseDouble(this.parent.getSpan());
        double st = Double.parseDouble(this.parent.getStep());
        if (sp == 0.0) {
            JOptionPane.showMessageDialog(null, "Please set values that are larger than 0 to span.", "WARN", 0);
            return;
        }
        if (st == 0.0) {
            JOptionPane.showMessageDialog(null, "Please set values that are larger than 0 to step.", "WARN", 0);
            return;
        }
        if (this.parent.getSrp() != null) {
            this.parent.calcAndDrawLoadResultImage(null, this.parent.getSrp().getCheckSpeciesSelected(), this.parent.getSrp().getCheckCompartmentSelected(), this.parent.getSrp().getCheckParameterSelected(), this.parent.getSrp().getCheckFluxSelected());
        } else {
            this.parent.calcAndDrawResultImage();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setDefineRangeValue(String[][] tblDataStorage, boolean rbInitial) {
        int lstSize;
        this.remove(this.scrSlider);
        this.setVisible(false);
        Iterator itId = null;
        if (rbInitial) {
            this.speciesValueSliderList.clear();
            this.vecInitialSlider.clear();
            this.vecLblInitialMinValue.clear();
            this.vecLblInitialMaxValue.clear();
            this.vecLblInitialCurValue.clear();
            itId = this.lstInitialId.iterator();
            lstSize = this.lstInitialId.size();
        } else {
            this.parameterValueSliderList.clear();
            this.vecParameterSlider.clear();
            this.vecLblParameterMinValue.clear();
            this.vecLblParameterMaxValue.clear();
            this.vecLblParameterCurValue.clear();
            itId = this.lstParameterId.iterator();
            lstSize = this.lstParameterId.size();
        }
        this.pSlider = this.getPnlSlider();
        GridBagLayout grbLayout1 = new GridBagLayout();
        GridBagConstraints grc1 = new GridBagConstraints();
        this.pSlider.setLayout(grbLayout1);
        int gridy = 0;
        int i = 0;
        while (i < lstSize) {
            JLabel lblId = new JLabel((String)itId.next());
            grc1.gridx = 0;
            grc1.gridy = gridy;
            grc1.ipadx = 10;
            grc1.ipady = 5;
            grc1.anchor = 24;
            grc1.fill = 1;
            grbLayout1.setConstraints(lblId, grc1);
            this.pSlider.add(lblId);
            int minValue = this.calcDoubleToIntMultiplie100(tblDataStorage[i][1]);
            int maxValue = this.calcDoubleToIntMultiplie100(tblDataStorage[i][2]);
            int curValue = this.calcDoubleToIntMultiplie100(tblDataStorage[i][3]);
            SliderValue sv = new SliderValue(tblDataStorage[i][3]);
            sv.setMinValue(tblDataStorage[i][1]);
            sv.setMaxValue(tblDataStorage[i][2]);
            sv.setTarget(tblDataStorage[i][0]);
            JSlider slider = this.getChangedJSlider(sv.getSliderMinValue(), sv.getSliderMaxValue(), sv.getSliderValue());
            this.txtFldCurValue = this.getTextFieldCurValue(sv.getValue());
            JLabel lblMinValue = new JLabel(sv.getMinValue());
            JLabel lblMaxValue = new JLabel(sv.getMaxValue());
            if (rbInitial) {
                this.vecInitialSlider.add(i, slider);
                this.speciesValueSliderList.add(sv);
                this.vecLblInitialCurValue.add(this.txtFldCurValue);
                this.vecLblInitialMinValue.add(lblMinValue);
                this.vecLblInitialMaxValue.add(lblMaxValue);
            } else {
                this.vecParameterSlider.add(i, slider);
                this.parameterValueSliderList.add(sv);
                this.vecLblParameterCurValue.add(this.txtFldCurValue);
                this.vecLblParameterMinValue.add(lblMinValue);
                this.vecLblParameterMaxValue.add(lblMaxValue);
            }
            grc1.gridx = 1;
            grc1.gridy = gridy;
            grc1.ipadx = 10;
            grc1.ipady = 1;
            grc1.anchor = 24;
            grc1.fill = 1;
            grbLayout1.setConstraints(lblMinValue, grc1);
            this.pSlider.add(lblMinValue);
            grc1.gridx = 2;
            grc1.gridy = gridy;
            grc1.ipadx = 55;
            grc1.ipady = 10;
            grc1.anchor = 10;
            grc1.fill = 0;
            grbLayout1.setConstraints(slider, grc1);
            this.pSlider.add(slider);
            grc1.gridx = 3;
            grc1.gridy = gridy;
            grc1.ipadx = 10;
            grc1.ipady = 1;
            grc1.anchor = 23;
            grc1.fill = 1;
            grbLayout1.setConstraints(lblMaxValue, grc1);
            this.pSlider.add(lblMaxValue);
            grc1.gridx = 4;
            grc1.gridy = gridy++;
            grc1.weighty = 1.0;
            grc1.anchor = 10;
            grc1.fill = 23;
            grbLayout1.setConstraints(this.txtFldCurValue, grc1);
            this.pSlider.add(this.txtFldCurValue);
            ++i;
        }
        this.scrSlider = this.getScrPaneSlider(this.pSlider);
        grc1.gridx = 0;
        grc1.gridy = 2;
        grc1.weightx = 1.0;
        grc1.weighty = 1.0;
        grc1.fill = 1;
        grc1.anchor = 23;
        grc1.ipadx = 400;
        grc1.ipady = 450;
        grc1.insets = new Insets(0, 5, 2, 2);
        this.grbLayout.setConstraints(this.scrSlider, grc1);
        this.add(this.scrSlider);
    }

    private void onClickExeDefRange() {
        this.setDataStorageTable();
        JLabel lblRange = this.getLblRange();
        this.mainTable = this.getMainTable();
        JScrollPane scrPane = new JScrollPane(this.mainTable);
        lblRange.add(scrPane);
        int ans = JOptionPane.showConfirmDialog(this, scrPane, "Define Slider Range", 2, -1);
        if (ans == 0) {
            int lstSize;
            this.remove(this.scrSlider);
            this.setVisible(false);
            Iterator itId = null;
            if (this.rbInitial.isSelected()) {
                this.speciesValueSliderList.clear();
                this.vecInitialSlider.clear();
                this.vecLblInitialMinValue.clear();
                this.vecLblInitialMaxValue.clear();
                this.vecLblInitialCurValue.clear();
                itId = this.lstInitialId.iterator();
                lstSize = this.lstInitialId.size();
            } else {
                this.parameterValueSliderList.clear();
                this.vecParameterSlider.clear();
                this.vecLblParameterMinValue.clear();
                this.vecLblParameterMaxValue.clear();
                this.vecLblParameterCurValue.clear();
                itId = this.lstParameterId.iterator();
                lstSize = this.lstParameterId.size();
            }
            this.pSlider = this.getPnlSlider();
            GridBagLayout grbLayout1 = new GridBagLayout();
            GridBagConstraints grc1 = new GridBagConstraints();
            this.pSlider.setLayout(grbLayout1);
            int gridy = 0;
            int i = 0;
            while (i < lstSize) {
                JLabel lblId = new JLabel((String)itId.next());
                grc1.gridx = 0;
                grc1.gridy = gridy;
                grc1.ipadx = 10;
                grc1.ipady = 5;
                grc1.anchor = 24;
                grc1.fill = 1;
                grbLayout1.setConstraints(lblId, grc1);
                this.pSlider.add(lblId);
                int minValue = this.calcDoubleToIntMultiplie100(this.tblDataStorage[i][1]);
                int maxValue = this.calcDoubleToIntMultiplie100(this.tblDataStorage[i][2]);
                int curValue = this.calcDoubleToIntMultiplie100(this.tblDataStorage[i][3]);
                if (this.tblDataStorage[i][1].indexOf(",", 0) != -1) {
                    this.tblDataStorage[i][1] = StringTool.replaceString(this.tblDataStorage[i][1], ",", "");
                }
                if (this.tblDataStorage[i][2].indexOf(",", 0) != -1) {
                    this.tblDataStorage[i][2] = StringTool.replaceString(this.tblDataStorage[i][2], ",", "");
                }
                if (this.tblDataStorage[i][3].indexOf(",", 0) != -1) {
                    this.tblDataStorage[i][3] = StringTool.replaceString(this.tblDataStorage[i][3], ",", "");
                }
                SliderValue sv = new SliderValue(String.valueOf(Double.parseDouble(this.tblDataStorage[i][3])));
                sv.setMinValue(String.valueOf(Double.parseDouble(this.tblDataStorage[i][1])));
                sv.setMaxValue(String.valueOf(Double.parseDouble(this.tblDataStorage[i][2])));
                sv.setTarget(this.tblDataStorage[i][0]);
                JSlider slider = this.getChangedJSlider(sv.getSliderMinValue(), sv.getSliderMaxValue(), sv.getSliderValue());
                this.txtFldCurValue = this.getTextFieldCurValue(sv.getValue());
                JLabel lblMinValue = new JLabel(sv.getMinValue());
                JLabel lblMaxValue = new JLabel(sv.getMaxValue());
                if (this.rbInitial.isSelected()) {
                    this.vecInitialSlider.add(i, slider);
                    this.speciesValueSliderList.add(sv);
                    this.vecLblInitialCurValue.add(this.txtFldCurValue);
                    this.vecLblInitialMinValue.add(lblMinValue);
                    this.vecLblInitialMaxValue.add(lblMaxValue);
                } else {
                    this.vecParameterSlider.add(i, slider);
                    this.parameterValueSliderList.add(sv);
                    this.vecLblParameterCurValue.add(this.txtFldCurValue);
                    this.vecLblParameterMinValue.add(lblMinValue);
                    this.vecLblParameterMaxValue.add(lblMaxValue);
                }
                grc1.gridx = 1;
                grc1.gridy = gridy;
                grc1.ipadx = 10;
                grc1.ipady = 1;
                grc1.anchor = 24;
                grc1.fill = 1;
                grbLayout1.setConstraints(lblMinValue, grc1);
                this.pSlider.add(lblMinValue);
                grc1.gridx = 2;
                grc1.gridy = gridy;
                grc1.ipadx = 55;
                grc1.ipady = 10;
                grc1.anchor = 10;
                grc1.fill = 0;
                grbLayout1.setConstraints(slider, grc1);
                this.pSlider.add(slider);
                grc1.gridx = 3;
                grc1.gridy = gridy;
                grc1.ipadx = 10;
                grc1.ipady = 1;
                grc1.anchor = 23;
                grc1.fill = 1;
                grbLayout1.setConstraints(lblMaxValue, grc1);
                this.pSlider.add(lblMaxValue);
                grc1.gridx = 4;
                grc1.gridy = gridy++;
                grc1.weighty = 1.0;
                grc1.anchor = 10;
                grc1.fill = 23;
                grbLayout1.setConstraints(this.txtFldCurValue, grc1);
                this.pSlider.add(this.txtFldCurValue);
                ++i;
            }
            this.scrSlider = this.getScrPaneSlider(this.pSlider);
            grc1.gridx = 0;
            grc1.gridy = 2;
            grc1.weightx = 1.0;
            grc1.weighty = 1.0;
            grc1.fill = 1;
            grc1.anchor = 23;
            grc1.ipadx = 400;
            grc1.ipady = 450;
            grc1.insets = new Insets(0, 5, 2, 2);
            this.grbLayout.setConstraints(this.scrSlider, grc1);
            this.add(this.scrSlider);
        }
        this.setVisible(true);
    }

    private JLabel getLblRange() {
        JLabel _lblRange = new JLabel();
        _lblRange.setBorder(new TitledBorder("Range"));
        _lblRange.setLayout(new GridLayout(1, 1));
        return _lblRange;
    }

    private JTextField getTextFieldCurValue(String value) {
        NumericField _txtFldCurValue = new NumericField();
        _txtFldCurValue.setText(value);
        _txtFldCurValue.addActionListener(this);
        _txtFldCurValue.setPreferredSize(new Dimension(65, 20));
        return _txtFldCurValue;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int sliderSize = 0;
        if (this.rbInitial.isSelected()) {
            sliderSize = this.vecInitialSlider.size();
            int i = 0;
            while (i < sliderSize) {
                JSlider slider = (JSlider)this.vecInitialSlider.get(i);
                if (e.getSource() == slider) {
                    SliderValue sv = (SliderValue)this.speciesValueSliderList.get(i);
                    int max = slider.getMaximum();
                    int min = slider.getMinimum();
                    int interval = (max - min) / 20;
                    int value = slider.getValue();
                    if (this.leftKeyPress && this.update) {
                        this.update = false;
                        this.update = false;
                        if (value - interval >= min) {
                            slider.setValue(slider.getValue() + 1 - interval);
                        } else {
                            slider.setValue(min);
                        }
                    } else if (this.rightKeyPress && this.update) {
                        this.update = false;
                        this.update = false;
                        if (value + interval <= max) {
                            slider.setValue(slider.getValue() - 1 + interval);
                        } else {
                            slider.setValue(max);
                        }
                    }
                    sv.setSliderValue(slider.getValue());
                    ((JTextField)this.vecLblInitialCurValue.get(i)).setText(sv.getValue());
                    this.resetTabSpecies(i, Double.valueOf(sv.getValue()));
                }
                ++i;
            }
        } else {
            sliderSize = this.vecParameterSlider.size();
            int i = 0;
            while (i < sliderSize) {
                JSlider slider = (JSlider)this.vecParameterSlider.get(i);
                if (e.getSource() == slider) {
                    SliderValue sv = (SliderValue)this.parameterValueSliderList.get(i);
                    int max = slider.getMaximum();
                    int min = slider.getMinimum();
                    int interval = (max - min) / 20;
                    int value = slider.getValue();
                    if (this.leftKeyPress && this.update) {
                        this.update = false;
                        this.update = false;
                        if (value - interval >= min) {
                            slider.setValue(slider.getValue() + 1 - interval);
                        } else {
                            slider.setValue(min);
                        }
                    } else if (this.rightKeyPress && this.update) {
                        this.update = false;
                        this.update = false;
                        if (value + interval <= max) {
                            slider.setValue(slider.getValue() - 1 + interval);
                        } else {
                            slider.setValue(max);
                        }
                    }
                    sv.setSliderValue(slider.getValue());
                    ((JTextField)this.vecLblParameterCurValue.get(i)).setText(sv.getValue());
                    this.resetTabParameters(i, Double.valueOf(sv.getValue()));
                }
                ++i;
            }
        }
        this.update = true;
    }

    public boolean isRbInitial() {
        return this.rbInitial.isSelected();
    }

    public boolean isRbParameter() {
        return this.rbParameter.isSelected();
    }

    private void redrawSpLabel() {
        this.remove(this.scrSlider);
        this.setVisible(false);
        this.setSpLblSlider(false);
        this.setVisible(true);
    }

    public JLabel getPicLabel() {
        return this.picLabel;
    }

    private void resetTabSpecies(int row, double value) {
        this.tabSpecies.getControlPanelMainWindow().setSelectedModelTab();
        ListOf lstSBase = this.sbmlPanelLists.getSBaseListPanel(3).getSBaseList();
        this.resetSpecies(lstSBase, row, value);
        this.tabSpecies.updateDataStorageTable();
    }

    private void resetTabParameters(int row, double value) {
        this.tabSpecies.getControlPanelMainWindow().setSelectedModelTab();
        String[][] _tblDataStorage = this.tabParameters.getTblDataStorage();
        String scope = _tblDataStorage[row][0];
        if (!scope.equals("global")) {
            ArrayList nParameter = (ArrayList)this.tabParameters.getNumParameter();
            int sumParameter = 0;
            int i = 0;
            ListOf lstGlobalParameters = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
            int numGlobalParams = (int)lstGlobalParameters.size();
            while (sumParameter <= row - numGlobalParams) {
                sumParameter += Integer.parseInt((String)nParameter.get(i++));
            }
            ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(6).getSBaseList();
            int indexParameter = row - (sumParameter -= Integer.parseInt((String)nParameter.get(--i))) - numGlobalParams;
            Reaction reaction = (Reaction)lstReaction.get((long)i);
            ListOfParameters lstParameter = reaction.getKineticLaw().getListOfParameters();
            this.resetParameters((ListOf)lstParameter, indexParameter, row, value);
            this.tabParameters.updateDataStorageTable();
        } else {
            ListOf lstReaction = this.sbmlPanelLists.getSBaseListPanel(4).getSBaseList();
            this.resetParameters(lstReaction, row, row, value);
            this.tabParameters.updateDataStorageTable();
        }
    }

    private JTable getMainTable() {
        JTable _mainTable = null;
        this.tblModel = new MyTableModel(this.tblDataStorage);
        _mainTable = new JTable(this.tblModel);
        _mainTable.setAutoResizeMode(0);
        int i = 0;
        while (i < 4) {
            TableColumn col = _mainTable.getColumnModel().getColumn(i);
            col.setCellEditor(new TextCellEditor(new JTextField(), this));
            if (i == 1 || i == 2) {
                col.setCellRenderer(new ColoredTableCellRenderer("ParameterScan", true));
            } else {
                col.setCellRenderer(new ColoredTableCellRenderer("ParameterScan", false));
            }
            ++i;
        }
        return _mainTable;
    }

    public void setDataStorageTable() {
        if (this.rbInitial.isSelected()) {
            this.tblDataStorage = new String[this.lstInitialId.size()][4];
            int leftMin = 0;
            int rightMin = 0;
            int leftMax = 0;
            int rightMax = 0;
            int leftVal = 0;
            int rightVal = 0;
            int i = 0;
            while (i < this.lstInitialId.size()) {
                String min = ((SliderValue)this.speciesValueSliderList.get(i)).getMinValue();
                String max = ((SliderValue)this.speciesValueSliderList.get(i)).getMaxValue();
                String val = ((SliderValue)this.speciesValueSliderList.get(i)).getValue();
                min = String.valueOf(Double.parseDouble(min));
                max = String.valueOf(Double.parseDouble(max));
                val = String.valueOf(Double.parseDouble(val));
                StringTokenizer token = new StringTokenizer(min, ".");
                String firstToken = token.nextToken();
                if (firstToken.length() > leftMin) {
                    leftMin = firstToken.length();
                }
                String lastToken = "";
                try {
                    lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > rightMin) {
                        rightMin = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((firstToken = (token = new StringTokenizer(max, ".")).nextToken()).length() > leftMax) {
                    leftMax = firstToken.length();
                }
                try {
                    lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > rightMax) {
                        rightMax = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((firstToken = (token = new StringTokenizer(val, ".")).nextToken()).length() > leftVal) {
                    leftVal = firstToken.length();
                }
                try {
                    lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > rightVal) {
                        rightVal = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < this.lstInitialId.size()) {
                FormatF df;
                this.tblDataStorage[i][0] = (String)this.lstInitialId.get(i);
                this.tblDataStorage[i][1] = ((SliderValue)this.speciesValueSliderList.get(i)).getMinValue();
                this.tblDataStorage[i][2] = ((SliderValue)this.speciesValueSliderList.get(i)).getMaxValue();
                this.tblDataStorage[i][3] = ((SliderValue)this.speciesValueSliderList.get(i)).getValue();
                if (this.tblDataStorage[i][1].indexOf("E") == -1) {
                    df = new FormatF(leftMin, rightMin);
                    this.tblDataStorage[i][1] = String.valueOf(df.format(Double.parseDouble(((SliderValue)this.speciesValueSliderList.get(i)).getMinValue())));
                }
                if (this.tblDataStorage[i][2].indexOf("E") == -1) {
                    df = new FormatF(leftMax, rightMax);
                    this.tblDataStorage[i][2] = String.valueOf(df.format(Double.parseDouble(((SliderValue)this.speciesValueSliderList.get(i)).getMaxValue())));
                }
                if (this.tblDataStorage[i][3].indexOf("E") == -1) {
                    df = new FormatF(leftVal, rightVal);
                    this.tblDataStorage[i][3] = String.valueOf(df.format(Double.parseDouble(((SliderValue)this.speciesValueSliderList.get(i)).getValue())));
                }
                ++i;
            }
        } else {
            this.tblDataStorage = new String[this.lstParameterId.size()][4];
            int leftMin = 0;
            int rightMin = 0;
            int leftMax = 0;
            int rightMax = 0;
            int leftVal = 0;
            int rightVal = 0;
            int i = 0;
            while (i < this.lstParameterId.size()) {
                String min = ((SliderValue)this.parameterValueSliderList.get(i)).getMinValue();
                String max = ((SliderValue)this.parameterValueSliderList.get(i)).getMaxValue();
                String val = ((SliderValue)this.parameterValueSliderList.get(i)).getValue();
                min = String.valueOf(Double.parseDouble(min));
                max = String.valueOf(Double.parseDouble(max));
                val = String.valueOf(Double.parseDouble(val));
                StringTokenizer token = new StringTokenizer(min, ".");
                String firstToken = token.nextToken();
                if (firstToken.length() > leftMin) {
                    leftMin = firstToken.length();
                }
                String lastToken = "";
                try {
                    lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > rightMin) {
                        rightMin = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((firstToken = (token = new StringTokenizer(max, ".")).nextToken()).length() > leftMax) {
                    leftMax = firstToken.length();
                }
                try {
                    lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > rightMax) {
                        rightMax = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((firstToken = (token = new StringTokenizer(val, ".")).nextToken()).length() > leftVal) {
                    leftVal = firstToken.length();
                }
                try {
                    lastToken = token.nextToken();
                    if (lastToken.indexOf("E") == -1 && lastToken.length() > rightVal) {
                        rightVal = lastToken.length();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < this.lstParameterId.size()) {
                FormatF df;
                this.tblDataStorage[i][0] = (String)this.lstParameterId.get(i);
                this.tblDataStorage[i][1] = ((SliderValue)this.parameterValueSliderList.get(i)).getMinValue();
                this.tblDataStorage[i][2] = ((SliderValue)this.parameterValueSliderList.get(i)).getMaxValue();
                this.tblDataStorage[i][3] = ((SliderValue)this.parameterValueSliderList.get(i)).getValue();
                if (this.tblDataStorage[i][1].indexOf("E") == -1) {
                    df = new FormatF(leftMin, rightMin);
                    this.tblDataStorage[i][1] = String.valueOf(df.format(Double.parseDouble(((SliderValue)this.parameterValueSliderList.get(i)).getMinValue())));
                }
                if (this.tblDataStorage[i][2].indexOf("E") == -1) {
                    df = new FormatF(leftMax, rightMax);
                    this.tblDataStorage[i][2] = String.valueOf(df.format(Double.parseDouble(((SliderValue)this.parameterValueSliderList.get(i)).getMaxValue())));
                }
                if (this.tblDataStorage[i][3].indexOf("E") == -1) {
                    df = new FormatF(leftVal, rightVal);
                    this.tblDataStorage[i][3] = String.valueOf(df.format(Double.parseDouble(((SliderValue)this.parameterValueSliderList.get(i)).getValue())));
                }
                ++i;
            }
        }
    }

    public void updateDataStorageTable() {
        int leftMin = 0;
        int rightMin = 0;
        int leftMax = 0;
        int rightMax = 0;
        int leftVal = 0;
        int rightVal = 0;
        int i = 0;
        while (i < this.tblDataStorage.length) {
            int k = 1;
            while (k < this.tblDataStorage[i].length) {
                String lastToken2;
                String value = this.tblDataStorage[i][k];
                value = String.valueOf(Double.parseDouble(value));
                StringTokenizer token = new StringTokenizer(value, ".");
                String firstToken = token.nextToken();
                if (k == 1) {
                    if (firstToken.length() > leftMin) {
                        leftMin = firstToken.length();
                    }
                    try {
                        lastToken2 = token.nextToken();
                        if (lastToken2.indexOf("E") == -1 && lastToken2.length() > rightMin) {
                            rightMin = lastToken2.length();
                        }
                    }
                    catch (Exception lastToken2) {}
                } else if (k == 2) {
                    if (firstToken.length() > leftMax) {
                        leftMax = firstToken.length();
                    }
                    try {
                        lastToken2 = token.nextToken();
                        if (lastToken2.indexOf("E") == -1 && lastToken2.length() > rightMax) {
                            rightMax = lastToken2.length();
                        }
                    }
                    catch (Exception lastToken3) {}
                } else if (k == 3) {
                    if (firstToken.length() > leftVal) {
                        leftVal = firstToken.length();
                    }
                    try {
                        lastToken2 = token.nextToken();
                        if (lastToken2.indexOf("E") == -1 && lastToken2.length() > rightVal) {
                            rightVal = lastToken2.length();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this.tblDataStorage.length) {
            if (this.tblDataStorage[i][1].indexOf("E") == -1) {
                FormatF df = new FormatF(leftMin, rightMin);
                this.tblDataStorage[i][1] = String.valueOf(df.format(Double.parseDouble(this.tblDataStorage[i][1])));
            }
            if (this.tblDataStorage[i][2].indexOf("E") == -1) {
                FormatF df = new FormatF(leftMax, rightMax);
                this.tblDataStorage[i][2] = String.valueOf(df.format(Double.parseDouble(this.tblDataStorage[i][2])));
            }
            if (this.tblDataStorage[i][3].indexOf("E") == -1) {
                FormatF df = new FormatF(leftVal, rightVal);
                this.tblDataStorage[i][3] = String.valueOf(df.format(Double.parseDouble(this.tblDataStorage[i][3])));
            }
            ++i;
        }
        this.mainTable.repaint();
    }

    private void setInteractiveSimulation() {
        this.interactiveSimulation.setKindOfParameter("initial value");
        this.interactiveSimulation.setInteractiveParameterList(this.speciesValueSliderList, "initial value");
        this.interactiveSimulation.setKindOfParameter("parameter value");
        this.interactiveSimulation.setInteractiveParameterList(this.parameterValueSliderList, "parameter value");
    }

    private void resetSpecies(ListOf lstSBase, int i, double value) {
        Species beforeSpecie = (Species)lstSBase.get((long)i);
        double oldValue = 0.0;
        oldValue = beforeSpecie.isSetInitialAmount() ? beforeSpecie.getInitialAmount() : beforeSpecie.getInitialConcentration();
        if (this.parent != null && oldValue != value) {
            this.parent.setChanged(true);
        }
        if (beforeSpecie.isSetInitialAmount()) {
            beforeSpecie.setInitialAmount(value);
        } else {
            beforeSpecie.setInitialConcentration(value);
        }
    }

    private void resetParameters(ListOf lstSBase, int point, int i, double value) {
        String[][] _tblDataStorage = this.tabParameters.getTblDataStorage();
        Parameter parameter = (Parameter)lstSBase.get((long)point);
        double oldValue = parameter.getValue();
        if (this.parent != null && oldValue != value) {
            this.parent.setChanged(true);
        }
        parameter.setId(_tblDataStorage[i][1]);
        parameter.setName(_tblDataStorage[i][2]);
        parameter.setValue(value);
        parameter.setUnits(_tblDataStorage[i][4]);
        parameter.setConstant(Boolean.valueOf(_tblDataStorage[i][5]).booleanValue());
    }

    private String calcIntToDoubleDevide100(int value) {
        return String.valueOf(Double.valueOf(String.valueOf(value)) / 100.0);
    }

    private int calcDoubleToIntMultiplie100(String value) {
        if (value.indexOf(",", 0) != -1) {
            value = StringTool.replaceString(value, ",", "");
        }
        return new Long(new Double(Double.parseDouble(value) * 100.0).longValue()).intValue();
    }

    private class MyTableModel
    extends AbstractTableModel {
        String validValues = "0123456789.+-Ee\b";
        private Object[][] tblDataStorage;
        private String[] headerName = new String[]{"Id", "Min", "Max", "Current"};

        public MyTableModel(String[][] tblDataStorage) {
            this.tblDataStorage = tblDataStorage;
        }

        @Override
        public int getColumnCount() {
            return this.headerName.length;
        }

        @Override
        public int getRowCount() {
            return this.tblDataStorage.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.headerName[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tblDataStorage[row][col];
        }

        public void setValue(Object[][] value) {
            this.tblDataStorage = value;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tblDataStorage[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex != 0 && colIndex != 3;
        }
    }

    private class TextCellEditor
    extends DefaultCellEditor
    implements KeyListener {
        int row;
        int col;
        TabParameterScanInteractive interactive;
        JTextField textField;

        TextCellEditor(JTextField textField, TabParameterScanInteractive interactive) {
            super(textField);
            TabParameterScanInteractive.this.enableEvents(8L);
            this.setClickCountToStart(1);
            this.addCellEditorListener(new TextCellEditorListener());
            this.interactive = interactive;
            textField.addKeyListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            String validValues = "0123456789.+-Ee\b";
            char chr = e.getKeyChar();
            int code = e.getKeyCode();
            if (code == 0 && validValues.indexOf(chr) == -1) {
                e.consume();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.row = row;
            this.col = col;
            if (((String)value).indexOf(",", 0) != -1) {
                value = StringTool.replaceString((String)value, ",", "");
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, col);
        }

        private class TextCellEditorListener
        implements CellEditorListener {
            private TextCellEditorListener() {
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultCellEditor editor = (DefaultCellEditor)e.getSource();
                String value = (String)editor.getCellEditorValue();
                if (!SimulationCheck.checkExponentValue(TextCellEditor.this.interactive, TabParameterScanInteractive.this.initValue, TextCellEditor.this.row, value)) {
                    return;
                }
                if (this.checkValue(TextCellEditor.this.row, TextCellEditor.this.col, value)) {
                    TabParameterScanInteractive.this.updateDataStorageTable();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }

            private boolean checkValue(int row, int col, String value) {
                int check;
                if (value.indexOf(",", 0) != -1) {
                    value = StringTool.replaceString(value, ",", "");
                }
                if ((check = SimulationCheck.checkTableDataStorage(TabParameterScanInteractive.this.tabParameterScanInteractive, TabParameterScanInteractive.this.tblDataStorage, col, TabParameterScanInteractive.this.tblDataStorage.length, 2)) >= 0) {
                    return false;
                }
                if (col == 1) {
                    if (TabParameterScanInteractive.this.tblDataStorage[row][2].indexOf(",", 0) != -1) {
                        ((TabParameterScanInteractive)((TextCellEditor)TextCellEditor.this).TabParameterScanInteractive.this).tblDataStorage[row][2] = StringTool.replaceString(TabParameterScanInteractive.this.tblDataStorage[row][2], ",", "");
                    }
                    if (TabParameterScanInteractive.this.tblDataStorage[row][3].indexOf(",", 0) != -1) {
                        ((TabParameterScanInteractive)((TextCellEditor)TextCellEditor.this).TabParameterScanInteractive.this).tblDataStorage[row][3] = StringTool.replaceString(TabParameterScanInteractive.this.tblDataStorage[row][3], ",", "");
                    }
                    if (Double.parseDouble(value) > Double.parseDouble(TabParameterScanInteractive.this.tblDataStorage[row][2])) {
                        JOptionPane.showMessageDialog(TextCellEditor.this.interactive, "The thing to input the value whose minimum value is larger than the maximum value cannot be done.", "WARN", 0);
                        return false;
                    }
                    if (Double.parseDouble(value) > Double.parseDouble(TabParameterScanInteractive.this.tblDataStorage[row][3])) {
                        JOptionPane.showMessageDialog(TextCellEditor.this.interactive, "Larger value than the current value cannot be set as minimum value.", "WARN", 0);
                        return false;
                    }
                }
                if (col == 2) {
                    if (TabParameterScanInteractive.this.tblDataStorage[row][1].indexOf(",", 0) != -1) {
                        ((TabParameterScanInteractive)((TextCellEditor)TextCellEditor.this).TabParameterScanInteractive.this).tblDataStorage[row][1] = StringTool.replaceString(TabParameterScanInteractive.this.tblDataStorage[row][1], ",", "");
                    }
                    if (TabParameterScanInteractive.this.tblDataStorage[row][3].indexOf(",", 0) != -1) {
                        ((TabParameterScanInteractive)((TextCellEditor)TextCellEditor.this).TabParameterScanInteractive.this).tblDataStorage[row][3] = StringTool.replaceString(TabParameterScanInteractive.this.tblDataStorage[row][3], ",", "");
                    }
                    if (Double.parseDouble(value) < Double.parseDouble(TabParameterScanInteractive.this.tblDataStorage[row][1])) {
                        JOptionPane.showMessageDialog(TextCellEditor.this.interactive, "The thing to input the value whose maximum value is smaller than minimum value cannot be done.", "WARN", 0);
                        return false;
                    }
                    if (Double.parseDouble(value) < Double.parseDouble(TabParameterScanInteractive.this.tblDataStorage[row][3])) {
                        JOptionPane.showMessageDialog(TextCellEditor.this.interactive, "Smaller value than the  current value cannot be set as the maximum value.", "WARN", 0);
                        return false;
                    }
                }
                return true;
            }
        }
    }
}

